# plugins/pyloader/src/builtin-policies/fcfs.py - Copyright 2005, 2006, University
#                            of Padova, dept. of Pure and Applied
#                            Mathematics
#
# This file is part of SGPEMv2.
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SGPEMv2 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SGPEMv2; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA


from CPUPolicy import CPUPolicy

class fcfs(CPUPolicy) :
    """First Come First Served scheduling policy.
    
The first thread to arrive to the CPU will run until
it ends. This policy never pre-empts; it is probably
the simplest of them all."""
    
    def __init__(self):
        pass;

    def configure(self):
        pass;

    def is_preemptive(self):
        return False

    def get_time_slice(self):
        return -2

    def sort_queue(self, queue):
        cmpf = lambda a, b: \
            a.get_arrival_time() + a.get_process().get_arrival_time() <= \
            b.get_arrival_time() + b.get_process().get_arrival_time()
        self.sort(queue,cmpf)
