# src/builtin-policies/lottery.py - Copyright 2005, 2006, University
#                            of Padova, dept. of Pure and Applied
#                            Mathematics
#
# This file is part of SGPEMv2.
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SGPEMv2 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SGPEMv2; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA


from CPUPolicy import CPUPolicy
from random import randint

class lottery(CPUPolicy) :
    """Lottery scheduling

Every time slice, a thread will be selected from the ready
queue by random. This policy does not pre-empt before the
end of the time slice."""

    def __init__(self):
        pass;

    def configure(self):
        param = self.get_parameters()
        param.register_int("Time slice", 1, 10000, True, 2)

    def is_preemptive(self):
        return False

    def get_time_slice(self):
        return self.get_parameters().get_int("Time slice")

    def sort_queue(self, queue):
        sz = queue.size()
        if(sz > 0):
            queue.swap(0, randint(0, sz - 1))
