# plugins/pyloader/src/builtin-policies/rr.py - Copyright 2005, 2006, University
#                            of Padova, dept. of Pure and Applied
#                            Mathematics
#
# This file is part of SGPEMv2.
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SGPEMv2 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SGPEMv2; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA


from CPUPolicy import CPUPolicy

class rr(CPUPolicy) :
    """Round Robin scheduling policy

This policy executes a thread for a given amount
of time (the time-slice value), and then puts it
at the end of the queue. Does not pre-empt before
the end of the time slice, since it doesn't take
priority in account. Use rr_priority for that."""

    def __init__(self):
        pass;

    def configure(self):
        param = self.get_parameters()
        param.register_int("Time slice", 1, 10000, True, 2)

    def is_preemptive(self):
        return False

    def get_time_slice(self):
        return self.get_parameters().get_int("Time slice")

    def sort_queue(self, queue):
        by_ltime = lambda a, b: \
            a.get_last_acquisition() <= \
            b.get_last_acquisition()
        self.sort(queue,by_ltime)
