# src/builtin-policies/rr_priority.py - Copyright 2005, 2006, University
#                            of Padova, dept. of Pure and Applied
#                            Mathematics
#
# This file is part of SGPEMv2.
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SGPEMv2 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SGPEMv2; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA


from CPUPolicy import CPUPolicy

class rr_priority(CPUPolicy) :
    """Round Robin scheduling policy that takes priority in account. 
    
No lower priority thread can run if a higher 
priority thread exists. If pre-emptive by priority, a 
higher-priority thread becoming ready even in the middle
of a time slice will pre-empt the running thread. Else,
the time slice will have to end before the former can run."""

    def __init__(self):
        pass;

    def configure(self):
        param = self.get_parameters()
        param.register_int("Time slice", 1, 10000, True, 2)
        param.register_int("Is preemptive?", 0, 1, True, 1)

    def is_preemptive(self):
        value = self.get_parameters().get_int("Is preemptive?")
        if value == 0:
            return False
        else:
            return True

    def get_time_slice(self):
        return self.get_parameters().get_int("Time slice")

    def sort_queue(self, queue):
        by_ltime = lambda a, b: \
            a.get_last_acquisition() <= \
            b.get_last_acquisition()
        by_prio = lambda a, b: \
            a.get_current_priority() <= \
            b.get_current_priority()

        self.sort(queue,by_ltime)
        self.sort(queue,by_prio)

        # manage preemption: see if we've a running thread
        # in the ready queue, and if it can still run
        if self.is_preemptive() == True:
            higher_prio = queue.get_item_at(0).get_current_priority()
            i = 0
            while i < queue.size():
                sched = queue.get_item_at(i)
                priority = sched.get_current_priority()
                if(priority != higher_prio):
                    break
                if sched.get_state() == "running":
                    queue.bubble_to_front(i)
                i += 1
