# src/builtin-policies/sjf.py - Copyright 2005, 2006, University
#                            of Padova, dept. of Pure and Applied
#                            Mathematics
#
# This file is part of SGPEMv2.
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SGPEMv2 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SGPEMv2; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA


from CPUPolicy import CPUPolicy

class sjf(CPUPolicy) :
    """Shortest Job First scheduling policy

The thread with the shortest required CPU time
will run until it ends. If pre-emptive is set
to true, if a shorter thread arrives at the CPU
at a given moment, it will pre-empt the running
one. The policy is also called Shortest Remaining
Time Next in this case."""

    def __init__(self):
        pass;

    def configure(self):
        params = self.get_parameters()
        params.register_int("Is preemptive?", 0, 1, True, 0)

    def is_preemptive(self):
        value = self.get_parameters().get_int("Is preemptive?")
        if value == 0:
            return False
        else:
            return True

    def get_time_slice(self):
        return -1

    def sort_queue(self, queue):
        cmpf = lambda a, b: \
            a.get_total_cpu_time() - a.get_elapsed_time() <= \
            b.get_total_cpu_time() - b.get_elapsed_time()
        self.sort(queue,cmpf)
        
