
function [S1,S2,S3,pointset_stats]=set_albrecht_collatz_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 2.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Albrecht, L. Collatz,
%  "Zur numerischen Auswertung mehrdimensionaler Integrale".
%  ZAMM, Volume 38, Issue 1-2, 1958, pp. 1-15.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   3 |   6 |   0 |   0 | 3.68e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        S1=[];
        
        S2=[
            6.66666666666666657414808128123695e-02 5.00000000000000000000000000000000e-01
            5.99999999999999977795539507496869e-01 1.66666666666666657414808128123695e-01
            ];
        
        S3=[];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    3    6 3.68e-16    0    0
    ];




