
 	function [xyw,pointset_stats]=set_albrecht_collatz_standard(deg)
 	
 	 % --------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
 	 % --------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 % --------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
 	 %      REMARK: The sum of the weights makes 1/2.
 	 % 
 	 % pointset_stats:
 	 %    statistics of the pointset stored in a matrix. Each rows contains
 	 %    degree, cardinality of the full pointset, moment error w.r.t. orthn. 
 	 %    Dubiner basis,number of points with negative weights, number of
 	 %    points outside the domain.
 	 % --------------------------------------------------------------------
   	 % SOURCE:
  	 %  J. Albrecht, L. Collatz,
  	 %  "Zur numerischen Auswertung mehrdimensionaler Integrale".
  	 %  ZAMM, Volume 38, Issue 1-2, 1958, pp. 1-15.
 	 %--------------------------------------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %--------------------------------------------------------------------
 	 % |   3 |   6 |   0 |   0 | 3.68e-16 |PI|
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
   
 	 switch deg
 
 	 case   3 

 	 % ALG. DEG.:    3
 	 % PTS CARD.:    6
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.7e-16  

 	 xyw=[
 	 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 1.66666666666666664353702032030924e-02
 	 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 1.66666666666666664353702032030924e-02
 	 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 1.66666666666666664353702032030924e-02
 	 1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01 1.49999999999999994448884876874217e-01
 	 1.66666666666666657414808128123695e-01 6.66666666666666740681534975010436e-01 1.49999999999999994448884876874217e-01
 	 6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01 1.49999999999999994448884876874217e-01
 	 ];
 

 	 otherwise
 	 xyw=[];
 	 end
 

 	 pointset_stats=[
 	   3    6 3.68e-16    0    0
 	 ];
 
 

 
