
function [S1,S2,S3,pointset_stats]=set_berntsen_espelid_I_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%
%    The pointset is written in terms of rotations of type s1, s2, s3,
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Berntsen, T.O. Espelid,
%  "Degree 13 symmetric quadrature rules for the triangle",
%  Reports in Informatics, Dept. of Informatics, University of Bergen,
%  (1990).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  37 |   0 |   0 | 1.51e-12 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.5e-12
        
        S1=[
            1.54458342107015832167515867467955e-02 2.20762896536244035416984843323007e-02 8.51306504174348499525137867749436e-01
            1.78229899231786628743812173070182e-02 1.86205228025209702791276100697360e-02 6.89441970728591257966400007717311e-01
            3.70386836813846251348358862287569e-02 9.65064812921592324324038258964720e-02 6.35867859433372761834846187412040e-01
            ];
        
        S2=[
            8.00779955556480196876556476581754e-03 2.48621685379472184829197090039088e-02
            4.68688989818216439342535295509151e-02 4.14192542538082353331674312357791e-01
            4.65909401839764911179564421672694e-02 2.30293878161404785842591991240624e-01
            3.10169433137963829194561071744829e-02 1.13919981661733712985373756509944e-01
            1.07916127366312741137077679809408e-02 4.95457300025082314487434587135795e-01
            3.21955342424316212635027056876424e-02 4.68861354847056488459600132046035e-01
            ];
        
        S3=[
            5.17397660657441318954319342537929e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    13   37 1.51e-12    0    0
    ];




