
 	function [xyw,pointset_stats]=set_berntsen_espelid_I_standard(deg)
 	
 	 %--------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
 	 %--------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 %--------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
 	 %      REMARK: The sum of the weights makes 1/2.
 	 % 
 	 % pointset_stats:
 	 %    statistics of the pointset stored in a matrix. Each rows contains
 	 %    degree, cardinality of the full pointset, moment error w.r.t. orthn. 
 	 %    Dubiner basis,number of points with negative weights, number of
 	 %    points outside the domain.
 	 %--------------------------------------------------------------------
   	 % SOURCE:
  	 %  J. Berntsen, T.O. Espelid,
  	 %  "Degree 13 symmetric quadrature rules for the triangle",
  	 %  Reports in Informatics, Dept. of Informatics, University of Bergen,
  	 %  (1990).
 	 %--------------------------------------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %--------------------------------------------------------------------
 	 % |  13 |  37 |   0 |   0 | 1.51e-12 |PI|
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
 
 
 	 switch deg
 
 	 case  13 

 	 % ALG. DEG.:   13
 	 % PTS CARD.:   37
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-12  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.58698830328720728866098710341248e-02
 	 2.48621685379472184829197090039088e-02 2.48621685379472184829197090039088e-02 4.00389977778240185174452037131232e-03
 	 2.48621685379472184829197090039088e-02 9.50275662924105590789736197621096e-01 4.00389977778240185174452037131232e-03
 	 9.50275662924105590789736197621096e-01 2.48621685379472184829197090039088e-02 4.00389977778240185174452037131232e-03
 	 4.14192542538082353331674312357791e-01 4.14192542538082353331674312357791e-01 2.34344494909108254365737167290717e-02
 	 4.14192542538082353331674312357791e-01 1.71614914923835293336651375284418e-01 2.34344494909108254365737167290717e-02
 	 1.71614914923835293336651375284418e-01 4.14192542538082353331674312357791e-01 2.34344494909108254365737167290717e-02
 	 2.30293878161404785842591991240624e-01 2.30293878161404785842591991240624e-01 2.32954700919882490284251730372489e-02
 	 2.30293878161404785842591991240624e-01 5.39412243677190428314816017518751e-01 2.32954700919882490284251730372489e-02
 	 5.39412243677190428314816017518751e-01 2.30293878161404785842591991240624e-01 2.32954700919882490284251730372489e-02
 	 1.13919981661733712985373756509944e-01 1.13919981661733712985373756509944e-01 1.55084716568981949291750055408556e-02
 	 1.13919981661733712985373756509944e-01 7.72160036676532546273676871351199e-01 1.55084716568981949291750055408556e-02
 	 7.72160036676532546273676871351199e-01 1.13919981661733712985373756509944e-01 1.55084716568981949291750055408556e-02
 	 4.95457300025082314487434587135795e-01 4.95457300025082314487434587135795e-01 5.39580636831563792421562197887397e-03
 	 4.95457300025082314487434587135795e-01 9.08539994983537102513082572841085e-03 5.39580636831563792421562197887397e-03
 	 9.08539994983537102513082572841085e-03 4.95457300025082314487434587135795e-01 5.39580636831563792421562197887397e-03
 	 4.68861354847056488459600132046035e-01 4.68861354847056488459600132046035e-01 1.60977671212158141011983047974354e-02
 	 4.68861354847056488459600132046035e-01 6.22772903058870230807997359079309e-02 1.60977671212158141011983047974354e-02
 	 6.22772903058870230807997359079309e-02 4.68861354847056488459600132046035e-01 1.60977671212158141011983047974354e-02
 	 2.20762896536244035416984843323007e-02 8.51306504174348499525137867749436e-01 7.72291710535079334309926935020485e-03
 	 2.20762896536244035416984843323007e-02 1.26617206172027096933163647918263e-01 7.72291710535079334309926935020485e-03
 	 8.51306504174348499525137867749436e-01 2.20762896536244035416984843323007e-02 7.72291710535079334309926935020485e-03
 	 8.51306504174348499525137867749436e-01 1.26617206172027096933163647918263e-01 7.72291710535079334309926935020485e-03
 	 1.26617206172027096933163647918263e-01 2.20762896536244035416984843323007e-02 7.72291710535079334309926935020485e-03
 	 1.26617206172027096933163647918263e-01 8.51306504174348499525137867749436e-01 7.72291710535079334309926935020485e-03
 	 1.86205228025209702791276100697360e-02 6.89441970728591257966400007717311e-01 8.91149496158933317191408463031621e-03
 	 1.86205228025209702791276100697360e-02 2.91937506468887719712768102908740e-01 8.91149496158933317191408463031621e-03
 	 6.89441970728591257966400007717311e-01 1.86205228025209702791276100697360e-02 8.91149496158933317191408463031621e-03
 	 6.89441970728591257966400007717311e-01 2.91937506468887719712768102908740e-01 8.91149496158933317191408463031621e-03
 	 2.91937506468887719712768102908740e-01 1.86205228025209702791276100697360e-02 8.91149496158933317191408463031621e-03
 	 2.91937506468887719712768102908740e-01 6.89441970728591257966400007717311e-01 8.91149496158933317191408463031621e-03
 	 9.65064812921592324324038258964720e-02 6.35867859433372761834846187412040e-01 1.85193418406923160368648950679926e-02
 	 9.65064812921592324324038258964720e-02 2.67625659274468019610537794505944e-01 1.85193418406923160368648950679926e-02
 	 6.35867859433372761834846187412040e-01 9.65064812921592324324038258964720e-02 1.85193418406923160368648950679926e-02
 	 6.35867859433372761834846187412040e-01 2.67625659274468019610537794505944e-01 1.85193418406923160368648950679926e-02
 	 2.67625659274468019610537794505944e-01 9.65064812921592324324038258964720e-02 1.85193418406923160368648950679926e-02
 	 2.67625659274468019610537794505944e-01 6.35867859433372761834846187412040e-01 1.85193418406923160368648950679926e-02
 	 ];
 

 	 otherwise
 	 xyw=[];
 	 end
 

 
 
 	 pointset_stats=[
 	  13   37 1.51e-12    0    0
 	 ];
 
 

 
