
function [S1,S2,S3,pointset_stats]=set_berntsen_espelid_II_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3,
%    applied resp. to S1, S2, S3, where:
%    s1(a,b,w): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(a,w): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Berntsen, T.O. Espelid,
%  "Degree 13 symmetric quadrature rules for the triangle",
%  Reports in Informatics, Dept. of Informatics, University of Bergen,
%  (1990).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  37 |   0 |   0 | 4.41e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.4e-16
        
        S1=[
            1.58025322152607512748989648798670e-02 2.27978945382486114512587960234669e-02 8.51775587145410462142081087222323e-01
            1.59816377809284052013971688666061e-02 1.62757709910885395299118272305350e-02 6.92797317566660852961035743646789e-01
            3.65515022240972958789129165779741e-02 8.97330604516053537134112616513448e-02 6.37955883864209538636202978523215e-01
            ];
        
        S2=[
            7.85076829610007950743799653992028e-03 2.46071886432302176783704084073179e-02
            5.06689531758869604605166614419431e-02 4.20308753101194698675868721693405e-01
            5.00803260905090669163897132420971e-02 2.27900255506160609453303322879947e-01
            3.16471145922983185250210169670027e-02 1.16213058883517905695015315359342e-01
            5.35690379109086088627034172304775e-03 5.00000000000000000000000000000000e-01
            3.14925630759687949500325032659021e-02 4.76602980049079139046597219930845e-01
            ];
        
        S3=[
            5.86960796127190334581236186295428e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    13   37 4.41e-16    0    0
    ];




