
function [S1,S2,S3,pointset_stats]=set_berntsen_espelid_III_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3,
%    applied resp. to S1, S2, S3, where:
%    s1(a,b,w): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(a,w): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Berntsen, T.O. Espelid,
%  "Degree 13 symmetric quadrature rules for the triangle",
%  Reports in Informatics, Dept. of Informatics, University of Bergen,
%  (1990).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  36 |   3 |   6 | 4.93e-16 |N0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   36
        % NEG. W.  :    3
        % OUT PTS. :    6
        % M.E.INF. : 4.9e-16
        
        S1=[
            1.48670883219833814548049844006528e-02 2.08215208466316185897948543015445e-02 8.50459062644356778015719555696705e-01
            2.15756998162757729353700142382877e-02 2.29194828048128115827175577123853e-02 6.83758575887968178541598263109336e-01
            4.33983307028823692141905610242247e-02 1.15458022821994132911527231044602e-01 6.31364930935447432602813933044672e-01
            ];
        
        S2=[
            -4.43891793924971077632279695309594e-15 -1.09732124710628120567434962140396e+00
            2.38750840551693356561546721650302e-02 4.88287850733405304204381991439732e-01
            6.31897835987828282444667138406658e-02 2.71000295524474743569243173624272e-01
            8.04506981652458943998773577277461e-03 2.47884310336613615521894615767451e-02
            2.78560971135522056352229469666781e-02 1.07120353118147715321128998766653e-01
            5.06850610670257703538332805237587e-02 4.40323874478061316750654441420920e-01
            ];
        
        S3=[];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    13   36 4.93e-16    3    6
    ];




