
function [xyw,pointset_stats]=set_berntsen_espelid_III_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Berntsen, T.O. Espelid,
%  "Degree 13 symmetric quadrature rules for the triangle",
%  Reports in Informatics, Dept. of Informatics, University of Bergen,
%  (1990).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  36 |   3 |   6 | 4.93e-16 |N0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   36
        % NEG. W.  :    3
        % OUT PTS. :    6
        % M.E.INF. : 4.9e-16
        
        xyw=[
            -1.09732124710628120567434962140396e+00 -1.09732124710628120567434962140396e+00 -2.21945896962485696588320891857158e-15
            -1.09732124710628120567434962140396e+00 3.19464249421256241134869924280792e+00 -2.21945896962485696588320891857158e-15
            3.19464249421256241134869924280792e+00 -1.09732124710628120567434962140396e+00 -2.21945896962485696588320891857158e-15
            4.88287850733405304204381991439732e-01 4.88287850733405304204381991439732e-01 1.19375420275846765016947159665506e-02
            4.88287850733405304204381991439732e-01 2.34242985331893915912360171205364e-02 1.19375420275846765016947159665506e-02
            2.34242985331893915912360171205364e-02 4.88287850733405304204381991439732e-01 1.19375420275846765016947159665506e-02
            2.71000295524474743569243173624272e-01 2.71000295524474743569243173624272e-01 3.15948917993914349389150686420180e-02
            2.71000295524474743569243173624272e-01 4.57999408951050512861513652751455e-01 3.15948917993914349389150686420180e-02
            4.57999408951050512861513652751455e-01 2.71000295524474743569243173624272e-01 3.15948917993914349389150686420180e-02
            2.47884310336613615521894615767451e-02 2.47884310336613615521894615767451e-02 4.02253490826229732207908185159795e-03
            2.47884310336613615521894615767451e-02 9.50423137932677297712302788568195e-01 4.02253490826229732207908185159795e-03
            9.50423137932677297712302788568195e-01 2.47884310336613615521894615767451e-02 4.02253490826229732207908185159795e-03
            1.07120353118147715321128998766653e-01 1.07120353118147715321128998766653e-01 1.39280485567761114912288533673745e-02
            1.07120353118147715321128998766653e-01 7.85759293763704569357742002466694e-01 1.39280485567761114912288533673745e-02
            7.85759293763704569357742002466694e-01 1.07120353118147715321128998766653e-01 1.39280485567761114912288533673745e-02
            4.40323874478061316750654441420920e-01 4.40323874478061316750654441420920e-01 2.53425305335129025241514000299503e-02
            4.40323874478061316750654441420920e-01 1.19352251043877366498691117158160e-01 2.53425305335129025241514000299503e-02
            1.19352251043877366498691117158160e-01 4.40323874478061316750654441420920e-01 2.53425305335129025241514000299503e-02
            2.08215208466316185897948543015445e-02 8.50459062644356778015719555696705e-01 7.43354416099169593157292013074766e-03
            2.08215208466316185897948543015445e-02 1.28719416509011641558402061491506e-01 7.43354416099169593157292013074766e-03
            8.50459062644356778015719555696705e-01 2.08215208466316185897948543015445e-02 7.43354416099169593157292013074766e-03
            8.50459062644356778015719555696705e-01 1.28719416509011641558402061491506e-01 7.43354416099169593157292013074766e-03
            1.28719416509011641558402061491506e-01 2.08215208466316185897948543015445e-02 7.43354416099169593157292013074766e-03
            1.28719416509011641558402061491506e-01 8.50459062644356778015719555696705e-01 7.43354416099169593157292013074766e-03
            2.29194828048128115827175577123853e-02 6.83758575887968178541598263109336e-01 1.07878499081378934065789110263722e-02
            2.29194828048128115827175577123853e-02 2.93321941307219002936790275271051e-01 1.07878499081378934065789110263722e-02
            6.83758575887968178541598263109336e-01 2.29194828048128115827175577123853e-02 1.07878499081378934065789110263722e-02
            6.83758575887968178541598263109336e-01 2.93321941307219002936790275271051e-01 1.07878499081378934065789110263722e-02
            2.93321941307219002936790275271051e-01 2.29194828048128115827175577123853e-02 1.07878499081378934065789110263722e-02
            2.93321941307219002936790275271051e-01 6.83758575887968178541598263109336e-01 1.07878499081378934065789110263722e-02
            1.15458022821994132911527231044602e-01 6.31364930935447432602813933044672e-01 2.16991653514411984848830883265691e-02
            1.15458022821994132911527231044602e-01 2.53177046242558434485658835910726e-01 2.16991653514411984848830883265691e-02
            6.31364930935447432602813933044672e-01 1.15458022821994132911527231044602e-01 2.16991653514411984848830883265691e-02
            6.31364930935447432602813933044672e-01 2.53177046242558434485658835910726e-01 2.16991653514411984848830883265691e-02
            2.53177046242558434485658835910726e-01 1.15458022821994132911527231044602e-01 2.16991653514411984848830883265691e-02
            2.53177046242558434485658835910726e-01 6.31364930935447432602813933044672e-01 2.16991653514411984848830883265691e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    13   36 4.93e-16    3    6
    ];



