
function [S1,S2,S3,pointset_stats]=set_berntsen_espelid_IV_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3,
%    applied resp. to S1, S2, S3, where:
%    s1(a,b,w): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(a,w): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Berntsen, T.O. Espelid,
%  "Degree 13 symmetric quadrature rules for the triangle",
%  Reports in Informatics, Dept. of Informatics, University of Bergen,
%  (1990).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  40 |   0 |   0 | 3.96e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   40
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.0e-16
        
        S1=[
            1.54458342107015832167515867467955e-02 2.20762896536244035416984843323007e-02 8.51306504174348499525137867749436e-01
            1.78229899231786628743812173070182e-02 1.86205228025209702791276100697360e-02 6.89441970728591257966400007717311e-01
            3.70386836813846251348358862287569e-02 9.65064812921592324324038258964720e-02 6.35867859433872806285137357917847e-01
            ];
        
        S2=[
            1.11425204553221628633267320518385e-05 0.00000000000000000000000000000000e+00
            8.01933068147050488738702966884375e-03 2.49786406333912733290780749939586e-02
            3.34292167792217820299072172929300e-02 4.74489920436516832147333389002597e-01
            4.69665889308991668649184703099309e-02 2.30836272600280445477238799867337e-01
            3.10791694856029990234880244770466e-02 1.14080598593243459637491810099164e-01
            4.89479425551612098987952492734621e-02 4.17965185286509721684922169515630e-01
            5.88445960133870786534782126864229e-03 5.00000000000000000000000000000000e-01
            ];
        
        S3=[
            5.51414014459616699803667927426432e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    13   40 3.96e-16    0    0
    ];




