
function [xyw,pointset_stats]=set_berntsen_espelid_IV_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Berntsen, T.O. Espelid,
%  "Degree 13 symmetric quadrature rules for the triangle",
%  Reports in Informatics, Dept. of Informatics, University of Bergen,
%  (1990).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  40 |   0 |   0 | 3.96e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   40
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.0e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.75707007229808419290773002785500e-02
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 5.57126022766108227869631328021960e-06
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 5.57126022766108227869631328021960e-06
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 5.57126022766108227869631328021960e-06
            2.49786406333912733290780749939586e-02 2.49786406333912733290780749939586e-02 4.00966534073525331105525282282542e-03
            2.49786406333912733290780749939586e-02 9.50042718733217439464056042197626e-01 4.00966534073525331105525282282542e-03
            9.50042718733217439464056042197626e-01 2.49786406333912733290780749939586e-02 4.00966534073525331105525282282542e-03
            4.74489920436516832147333389002597e-01 4.74489920436516832147333389002597e-01 1.67146083896108944844005606000792e-02
            4.74489920436516832147333389002597e-01 5.10201591269663357053332219948061e-02 1.67146083896108944844005606000792e-02
            5.10201591269663357053332219948061e-02 4.74489920436516832147333389002597e-01 1.67146083896108944844005606000792e-02
            2.30836272600280445477238799867337e-01 2.30836272600280445477238799867337e-01 2.34832944654495903713531390621938e-02
            2.30836272600280445477238799867337e-01 5.38327454799439109045522400265327e-01 2.34832944654495903713531390621938e-02
            5.38327454799439109045522400265327e-01 2.30836272600280445477238799867337e-01 2.34832944654495903713531390621938e-02
            1.14080598593243459637491810099164e-01 1.14080598593243459637491810099164e-01 1.55395847428015029811909641921375e-02
            1.14080598593243459637491810099164e-01 7.71838802813513025213865148543846e-01 1.55395847428015029811909641921375e-02
            7.71838802813513025213865148543846e-01 1.14080598593243459637491810099164e-01 1.55395847428015029811909641921375e-02
            4.17965185286509721684922169515630e-01 4.17965185286509721684922169515630e-01 2.44739712775806118882915285439594e-02
            4.17965185286509721684922169515630e-01 1.64069629426980556630155660968740e-01 2.44739712775806118882915285439594e-02
            1.64069629426980556630155660968740e-01 4.17965185286509721684922169515630e-01 2.44739712775806118882915285439594e-02
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 2.94222980066935480003564862272469e-03
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 2.94222980066935480003564862272469e-03
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 2.94222980066935480003564862272469e-03
            2.20762896536244035416984843323007e-02 8.51306504174348499525137867749436e-01 7.72291710535079334309926935020485e-03
            2.20762896536244035416984843323007e-02 1.26617206172027096933163647918263e-01 7.72291710535079334309926935020485e-03
            8.51306504174348499525137867749436e-01 2.20762896536244035416984843323007e-02 7.72291710535079334309926935020485e-03
            8.51306504174348499525137867749436e-01 1.26617206172027096933163647918263e-01 7.72291710535079334309926935020485e-03
            1.26617206172027096933163647918263e-01 2.20762896536244035416984843323007e-02 7.72291710535079334309926935020485e-03
            1.26617206172027096933163647918263e-01 8.51306504174348499525137867749436e-01 7.72291710535079334309926935020485e-03
            1.86205228025209702791276100697360e-02 6.89441970728591257966400007717311e-01 8.91149496158933317191408463031621e-03
            1.86205228025209702791276100697360e-02 2.91937506468887719712768102908740e-01 8.91149496158933317191408463031621e-03
            6.89441970728591257966400007717311e-01 1.86205228025209702791276100697360e-02 8.91149496158933317191408463031621e-03
            6.89441970728591257966400007717311e-01 2.91937506468887719712768102908740e-01 8.91149496158933317191408463031621e-03
            2.91937506468887719712768102908740e-01 1.86205228025209702791276100697360e-02 8.91149496158933317191408463031621e-03
            2.91937506468887719712768102908740e-01 6.89441970728591257966400007717311e-01 8.91149496158933317191408463031621e-03
            9.65064812921592324324038258964720e-02 6.35867859433872806285137357917847e-01 1.85193418406923160368648950679926e-02
            9.65064812921592324324038258964720e-02 2.67625659273967975160246624000138e-01 1.85193418406923160368648950679926e-02
            6.35867859433872806285137357917847e-01 9.65064812921592324324038258964720e-02 1.85193418406923160368648950679926e-02
            6.35867859433872806285137357917847e-01 2.67625659273967975160246624000138e-01 1.85193418406923160368648950679926e-02
            2.67625659273967975160246624000138e-01 9.65064812921592324324038258964720e-02 1.85193418406923160368648950679926e-02
            2.67625659273967975160246624000138e-01 6.35867859433872806285137357917847e-01 1.85193418406923160368648950679926e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    13   40 3.96e-16    0    0
    ];




