
function [xyw_bar,pointset_stats]=set_berntsen_espelid_I_C_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Berntsen, T.O. Espelid,
%  "Degree 13 symmetric quadrature rules for the triangle",
%  Reports in Informatics, Dept. of Informatics, University of Bergen,
%  (1990).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  37 |   0 |   0 | 5.97e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.0e-16
        
        xyw_bar=[
            3.33333333333334314030338418888277e-01 3.33333333333333314829616256247391e-01 3.33333333333332315628894093606505e-01 5.17397660657436322950708529333497e-02
            2.48621685379472150134727570502946e-02 2.48621685379472982801996039370351e-02 9.50275662924105479767433735105442e-01 8.00779955556481931600032453388849e-03
            2.48621685379472878718587480761926e-02 9.50275662924105479767433735105442e-01 2.48621685379472046051319011894520e-02 8.00779955556481064238294464985302e-03
            9.50275662924105590789736197621096e-01 2.48621685379472462384953246328223e-02 2.48621685379471629717684777460818e-02 8.00779955556481064238294464985302e-03
            4.14192542538081631686708306006039e-01 4.14192542538082963954337856193888e-01 1.71614914923835348847802606542245e-01 4.68688989818213247451339498184097e-02
            4.14192542538082519865128006131272e-01 1.71614914923835931714890534749429e-01 4.14192542538081465153254612232558e-01 4.68688989818217063842986647159705e-02
            1.71614914923837541538276241226413e-01 4.14192542538080854530591068396461e-01 4.14192542538081631686708306006039e-01 4.68688989818212137228314873027557e-02
            2.30293878161405368709679919447808e-01 2.30293878161404785842591991240624e-01 5.39412243677189873203303704940481e-01 4.65909401839763037678210366721032e-02
            2.30293878161404841353743222498451e-01 5.39412243677190428314816017518751e-01 2.30293878161404785842591991240624e-01 4.65909401839763523400783640227019e-02
            5.39412243677190428314816017518751e-01 2.30293878161405701776587306994770e-01 2.30293878161403869908596675486478e-01 4.65909401839763176456088444865600e-02
            1.13919981661733796252100603396684e-01 1.13919981661733282773951714261784e-01 7.72160036676532879340584258898161e-01 3.10169433137963274083048759166559e-02
            1.13919981661733130118285828302760e-01 7.72160036676532768318281796382507e-01 1.13919981661734115441220183129190e-01 3.10169433137963759805622032672545e-02
            7.72160036676532657295979333866853e-01 1.13919981661733740740949372138857e-01 1.13919981661733601963071293994290e-01 3.10169433137964141444786747570106e-02
            4.95457300025082814087795668456238e-01 4.95457300025081370797863655752735e-01 9.08539994983581511434067579102702e-03 1.07916127366315256486117846179695e-02
            4.95457300025082314487434587135795e-01 9.08539994983518540971889621005175e-03 4.95457300025082425509737049651449e-01 1.07916127366311960511513490246216e-02
            9.08539994983653502458320616597121e-03 4.95457300025082703065493205940584e-01 4.95457300025080815686351343174465e-01 1.07916127366321432101692323612951e-02
            4.68861354847055933348087819467764e-01 4.68861354847056488459600132046035e-01 6.22772903058875781923120484862011e-02 3.21955342424315657523514744298154e-02
            4.68861354847056377437297669530381e-01 6.22772903058870230807997359079309e-02 4.68861354847056599481902594561689e-01 3.21955342424318502470015346261789e-02
            6.22772903058894586325600073450914e-02 4.68861354847054767613911963053397e-01 4.68861354847055766814634125694283e-01 3.21955342424317253469112642960681e-02
            2.20762896536242717027143100949615e-02 8.51306504174348832592045255296398e-01 1.26617206172026874888558722886955e-01 1.54458342107014791333430281383698e-02
            2.20762896536244174194862921467575e-02 1.26617206172027291222192957320658e-01 8.51306504174348277480532942718128e-01 1.54458342107016179112211062829374e-02
            8.51306504174348499525137867749436e-01 2.20762896536243861944637245642298e-02 1.26617206172027124688739263547177e-01 1.54458342107016005639863465148665e-02
            8.51306504174348610547440330265090e-01 1.26617206172027013666436801031523e-01 2.20762896536243757861228687033872e-02 1.54458342107015537264524951410749e-02
            1.26617206172026985910861185402609e-01 2.20762896536242959888429737702609e-02 8.51306504174348721569742792780744e-01 1.54458342107015277056003554889685e-02
            1.26617206172027318977768572949572e-01 8.51306504174348166458230480202474e-01 2.20762896536245145640009468479548e-02 1.54458342107016630140314816799219e-02
            1.86205228025211784459447272865873e-02 6.89441970728591591033307395264274e-01 2.91937506468887275623558252846124e-01 1.78229899231788189994940552196567e-02
            1.86205228025210639541953128173191e-02 2.91937506468888219313129184229183e-01 6.89441970728590813877190157654695e-01 1.78229899231787808355775837299007e-02
            6.89441970728590924899492620170349e-01 1.86205228025211853848386311938157e-02 2.91937506468887886246221796682221e-01 1.78229899231788502245166228021844e-02
            6.89441970728591591033307395264274e-01 2.91937506468887497668163177877432e-01 1.86205228025209112985294268582948e-02 1.78229899231786247104647458172622e-02
            2.91937506468887608690465640393086e-01 1.86205228025210917097709284462326e-02 6.89441970728591257966400007717311e-01 1.78229899231787669577897759154439e-02
            2.91937506468888330335431646744837e-01 6.89441970728590813877190157654695e-01 1.86205228025209112985294268582948e-02 1.78229899231786385882525536317189e-02
            9.65064812921596626438258681446314e-02 6.35867859433871918106717657792615e-01 2.67625659273968419249456474062754e-01 3.70386836813846251348358862287569e-02
            9.65064812921597597883405228458287e-02 2.67625659273967198004129386390559e-01 6.35867859433873028329742282949155e-01 3.70386836813847569738200604660960e-02
            6.35867859433872362195927507855231e-01 9.65064812921599957107332556915935e-02 2.67625659273967642093339236453176e-01 3.70386836813847777905017721877812e-02
            6.35867859433872695262834895402193e-01 2.67625659273968308227154011547100e-01 9.65064812921589965100110930507071e-02 3.70386836813845835014724627853866e-02
            2.67625659273967919649095392742311e-01 9.65064812921596210104624447012611e-02 6.35867859433872473218229970370885e-01 3.70386836813846598293054057648988e-02
            2.67625659273967253515280617648386e-01 6.35867859433873583441254595527425e-01 9.65064812921592185546160180820152e-02 3.70386836813846875848810213938123e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    13   37 5.97e-16    0    0
    ];

