
function [xyw,pointset_stats]=set_berntsen_espelid_I_C_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J. Berntsen, T.O. Espelid,
%  "Degree 13 symmetric quadrature rules for the triangle",
%  Reports in Informatics, Dept. of Informatics, University of Bergen,
%  (1990).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  37 |   0 |   0 | 5.97e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.0e-16
        
        xyw=[
            3.33333333333334314030338418888277e-01 3.33333333333333314829616256247391e-01 2.58698830328718161475354264666748e-02
            2.48621685379472150134727570502946e-02 2.48621685379472982801996039370351e-02 4.00389977778240965800016226694424e-03
            2.48621685379472878718587480761926e-02 9.50275662924105479767433735105442e-01 4.00389977778240532119147232492651e-03
            9.50275662924105590789736197621096e-01 2.48621685379472462384953246328223e-02 4.00389977778240532119147232492651e-03
            4.14192542538081631686708306006039e-01 4.14192542538082963954337856193888e-01 2.34344494909106623725669749092049e-02
            4.14192542538082519865128006131272e-01 1.71614914923835931714890534749429e-01 2.34344494909108531921493323579853e-02
            1.71614914923837541538276241226413e-01 4.14192542538080854530591068396461e-01 2.34344494909106068614157436513779e-02
            2.30293878161405368709679919447808e-01 2.30293878161404785842591991240624e-01 2.32954700919881518839105183360516e-02
            2.30293878161404841353743222498451e-01 5.39412243677190428314816017518751e-01 2.32954700919881761700391820113509e-02
            5.39412243677190428314816017518751e-01 2.30293878161405701776587306994770e-01 2.32954700919881588228044222432800e-02
            1.13919981661733796252100603396684e-01 1.13919981661733282773951714261784e-01 1.55084716568981637041524379583279e-02
            1.13919981661733130118285828302760e-01 7.72160036676532768318281796382507e-01 1.55084716568981879902811016336273e-02
            7.72160036676532657295979333866853e-01 1.13919981661733740740949372138857e-01 1.55084716568982070722393373785053e-02
            4.95457300025082814087795668456238e-01 4.95457300025081370797863655752735e-01 5.39580636831576282430589230898477e-03
            4.95457300025082314487434587135795e-01 9.08539994983518540971889621005175e-03 5.39580636831559802557567451231080e-03
            9.08539994983653502458320616597121e-03 4.95457300025082703065493205940584e-01 5.39580636831607160508461618064757e-03
            4.68861354847055933348087819467764e-01 4.68861354847056488459600132046035e-01 1.60977671212157828761757372149077e-02
            4.68861354847056377437297669530381e-01 6.22772903058870230807997359079309e-02 1.60977671212159251235007673130895e-02
            6.22772903058894586325600073450914e-02 4.68861354847054767613911963053397e-01 1.60977671212158626734556321480341e-02
            2.20762896536242717027143100949615e-02 8.51306504174348832592045255296398e-01 7.72291710535073956667151406918492e-03
            2.20762896536244174194862921467575e-02 1.26617206172027291222192957320658e-01 7.72291710535080895561055314146870e-03
            8.51306504174348499525137867749436e-01 2.20762896536243861944637245642298e-02 7.72291710535080028199317325743323e-03
            8.51306504174348610547440330265090e-01 1.26617206172027013666436801031523e-01 7.72291710535077686322624757053745e-03
            1.26617206172026985910861185402609e-01 2.20762896536242959888429737702609e-02 7.72291710535076385280017774448424e-03
            1.26617206172027318977768572949572e-01 8.51306504174348166458230480202474e-01 7.72291710535083150701574083996093e-03
            1.86205228025211784459447272865873e-02 6.89441970728591591033307395264274e-01 8.91149496158940949974702760982836e-03
            1.86205228025210639541953128173191e-02 2.91937506468888219313129184229183e-01 8.91149496158939041778879186495033e-03
            6.89441970728590924899492620170349e-01 1.86205228025211853848386311938157e-02 8.91149496158942511225831140109221e-03
            6.89441970728591591033307395264274e-01 2.91937506468887497668163177877432e-01 8.91149496158931235523237290863108e-03
            2.91937506468887608690465640393086e-01 1.86205228025210917097709284462326e-02 8.91149496158938347889488795772195e-03
            2.91937506468888330335431646744837e-01 6.89441970728590813877190157654695e-01 8.91149496158931929412627681585946e-03
            9.65064812921596626438258681446314e-02 6.35867859433871918106717657792615e-01 1.85193418406923125674179431143784e-02
            9.65064812921597597883405228458287e-02 2.67625659273967198004129386390559e-01 1.85193418406923784869100302330480e-02
            6.35867859433872362195927507855231e-01 9.65064812921599957107332556915935e-02 1.85193418406923888952508860938906e-02
            6.35867859433872695262834895402193e-01 2.67625659273968308227154011547100e-01 1.85193418406922917507362313926933e-02
            2.67625659273967919649095392742311e-01 9.65064812921596210104624447012611e-02 1.85193418406923299146527028824494e-02
            2.67625659273967253515280617648386e-01 6.35867859433873583441254595527425e-01 1.85193418406923437924405106969061e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    13   37 5.97e-16    0    0
    ];




