
 	function [xyw,xyw_barpointset_stats]=set_best_rule_triangle(deg)
 	
 	 %--------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
 	 %--------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 %--------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
 	 %      REMARK: The sum of the weights makes 1/2.
     % xyw_bar: MATRIX OF BARYCENTRIC NODES xyw(:,1:3) AND WEIGHTS xyw(:,4).
 	 %      REMARK: The sum of the weights makes 1.
 	 % 
 	 % pointset_stats:
 	 %    statistics of the pointset stored in a matrix. Each rows contains
 	 %    degree, cardinality of the full pointset, moment error w.r.t. orthn. 
 	 %    Dubiner basis,number of points with negative weights, number of
 	 %    points outside the domain.
 	 %--------------------------------------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %--------------------------------------------------------------------
 	 % |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
 	 % |   2 |   3 |   0 |   0 | 1.18e-16 |PI|
 	 % |   3 |   4 |   0 |   0 | 2.15e-16 |PI|
 	 % |   4 |   6 |   0 |   0 | 1.39e-16 |PI|
 	 % |   5 |   7 |   0 |   0 | 1.60e-16 |PI|
 	 % |   6 |  11 |   0 |   0 | 1.08e-15 |PI|
 	 % |   7 |  12 |   0 |   0 | 5.07e-16 |PI|
 	 % |   8 |  16 |   0 |   0 | 8.05e-16 |PI|
 	 % |   9 |  19 |   0 |   0 | 3.26e-16 |PI|
 	 % |  10 |  24 |   0 |   0 | 7.22e-16 |PI|
 	 % |  11 |  27 |   0 |   0 | 3.64e-15 |PI|
 	 % |  12 |  32 |   0 |   0 | 1.61e-15 |PI|
 	 % |  13 |  36 |   0 |   0 | 3.05e-16 |PI|
 	 % |  14 |  42 |   0 |   0 | 4.37e-16 |PI|
 	 % |  15 |  46 |   0 |   0 | 5.00e-16 |PI|
 	 % |  16 |  52 |   0 |   0 | 5.67e-16 |PI|
 	 % |  17 |  57 |   0 |   0 | 5.83e-16 |PI|
 	 % |  18 |  66 |   0 |   0 | 6.11e-16 |PI|
 	 % |  19 |  70 |   0 |   0 | 4.16e-16 |PI|
 	 % |  20 |  78 |   0 |   0 | 4.89e-16 |PI|
 	 % |  21 |  85 |   0 |   0 | 4.64e-16 |PI|
 	 % |  22 |  93 |   0 |   0 | 7.56e-16 |PI|
 	 % |  23 | 100 |   0 |   0 | 6.66e-16 |PI|
 	 % |  24 | 109 |   0 |   0 | 7.81e-16 |PI|
 	 % |  25 | 117 |   0 |   0 | 5.41e-16 |PI|
 	 % |  26 | 130 |   0 |   0 | 1.96e-15 |PI|
 	 % |  27 | 141 |   0 |   0 | 7.77e-16 |PI|
 	 % |  28 | 150 |   0 |   0 | 1.39e-15 |PI|
 	 % |  29 | 159 |   0 |   0 | 1.34e-15 |PI|
 	 % |  30 | 171 |   0 |   0 | 9.40e-16 |PI|
 	 % |  31 | 181 |   0 |   0 | 1.70e-15 |PI|
 	 % |  32 | 193 |   0 |   0 | 1.71e-15 |PI|
 	 % |  33 | 204 |   0 |   0 | 1.45e-15 |PI|
 	 % |  34 | 214 |   0 |   0 | 1.87e-15 |PI|
 	 % |  35 | 228 |   0 |   0 | 1.68e-15 |PI|
 	 % |  36 | 243 |   0 |   0 | 9.71e-16 |PI|
 	 % |  37 | 252 |   0 |   0 | 1.03e-15 |PI|
 	 % |  38 | 267 |   0 |   0 | 1.85e-15 |PI|
 	 % |  39 | 282 |   0 |   0 | 1.58e-15 |PI|
 	 % |  40 | 295 |   0 |   0 | 1.42e-15 |PI|
 	 % |  41 | 309 |   0 |   0 | 1.45e-15 |PI|
 	 % |  42 | 324 |   0 |   0 | 1.44e-15 |PI|
 	 % |  43 | 339 |   0 |   0 | 1.45e-15 |PI|
 	 % |  44 | 354 |   0 |   0 | 1.38e-15 |PI|
 	 % |  45 | 370 |   0 |   0 | 1.52e-15 |PI|
 	 % |  46 | 385 |   0 |   0 | 8.47e-16 |PI|
 	 % |  47 | 399 |   0 |   0 | 1.56e-15 |PI|
 	 % |  48 | 423 |   0 |   0 | 1.49e-15 |PI|
 	 % |  49 | 435 |   0 |   0 | 1.23e-15 |PI|
 	 % |  50 | 453 |   0 |   0 | 1.39e-15 |PI|
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
 
 
 
 	 switch deg
 
 	 case   1 

 	 % ALG. DEG.:    1
 	 % PTS CARD.:    1
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-16  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
 	 ];
 
 	 case   2 

 	 % ALG. DEG.:    2
 	 % PTS CARD.:    3
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-16  

 	 xyw=[
 	 6.66666666666666629659232512494782e-01 1.66666666666666685170383743752609e-01 1.66666666666666657414808128123695e-01
 	 1.66666666666666685170383743752609e-01 6.66666666666666629659232512494782e-01 1.66666666666666657414808128123695e-01
 	 1.66666666666666685170383743752609e-01 1.66666666666666685170383743752609e-01 1.66666666666666657414808128123695e-01
 	 ];
 
 	 case   3 

 	 % ALG. DEG.:    3
 	 % PTS CARD.:    4
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.2e-16  

 	 xyw=[
 	 6.44948974278317765929102733934997e-01 2.80019915499074123488298937445506e-01 9.09793091280113874752544234070228e-02
 	 1.55051025721682167457515788555611e-01 6.66390246014701426169324349757517e-01 1.59020690871988584769169960964064e-01
 	 6.44948974278317765929102733934997e-01 7.50311102226081105825983286194969e-02 9.09793091280113874752544234070228e-02
 	 1.55051025721682167457515788555611e-01 1.78558728263616406373159861686872e-01 1.59020690871988584769169960964064e-01
 	 ];
 
 	 case   4 

 	 % ALG. DEG.:    4
 	 % PTS CARD.:    6
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-16  

 	 xyw=[
 	 4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 1.11690794839005735905601568447310e-01
 	 4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 1.11690794839005735905601568447310e-01
 	 1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 1.11690794839005735905601568447310e-01
 	 9.15762135097707430375635340169538e-02 9.15762135097707430375635340169538e-02 5.49758718276609353869943674908427e-02
 	 9.15762135097707430375635340169538e-02 8.16847572980458513924872931966092e-01 5.49758718276609353869943674908427e-02
 	 8.16847572980458513924872931966092e-01 9.15762135097707430375635340169538e-02 5.49758718276609353869943674908427e-02
 	 ];
 
 	 case   5 

 	 % ALG. DEG.:    5
 	 % PTS CARD.:    7
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-16  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.12500000000000002775557561562891e-01
 	 7.97426985353087314223330395179801e-01 1.01286507323456342888334802410100e-01 6.29695902724135836425745083033689e-02
 	 1.01286507323456342888334802410100e-01 7.97426985353087314223330395179801e-01 6.29695902724135836425745083033689e-02
 	 1.01286507323456342888334802410100e-01 1.01286507323456342888334802410100e-01 6.29695902724135836425745083033689e-02
 	 5.97158717897697810528256923134904e-02 4.70142064105115109473587153843255e-01 6.61970763942530820989063045090006e-02
 	 4.70142064105115109473587153843255e-01 5.97158717897697810528256923134904e-02 6.61970763942530820989063045090006e-02
 	 4.70142064105115109473587153843255e-01 4.70142064105115109473587153843255e-01 6.61970763942530820989063045090006e-02
 	 ];
 
 	 case   6 

 	 % ALG. DEG.:    6
 	 % PTS CARD.:   11
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw=[
 	 5.72549866774768601018763547472190e-02 8.95498146789879490015096052957233e-01 1.90340359264777984893424189749567e-02
 	 8.95362640024579103936730462010019e-01 6.18282212503219533172860167269391e-02 1.91896776538764100850098515138598e-02
 	 6.84475748456514043738252439652570e-01 2.33437384976827311255931363120908e-02 2.31002283722809183263979804223709e-02
 	 6.87462559150295304810640573123237e-02 6.00302757472630024726534259116306e-02 2.67337947220994999464327435134692e-02
 	 6.15676205575839574635210738051683e-01 3.33461808341377174969011321081780e-01 4.18779134828728416550802648998797e-02
 	 6.27946141197789464705181217141217e-01 1.59189185992151482906820092466660e-01 5.08224165127585322809800061349961e-02
 	 6.29091383418635685664810353046050e-02 6.55295093705452469379224567092024e-01 5.09307622306834767433869615160802e-02
 	 6.83782119205099125913704938284354e-02 3.09117685428267230385301900241757e-01 5.57109158300008525110946777658683e-02
 	 2.87529458374392254960127957019722e-01 6.36426509179620181200220940809231e-01 5.60047251314730321070101126679219e-02
 	 3.28783556413134614437865366198821e-01 7.70240056424634222942415817669826e-02 6.23937857187791614088645530955546e-02
 	 3.12290405013644800646943622268736e-01 3.52344786445899504911949406960048e-01 9.42017444186974139963552943299874e-02
 	 ];
 
 	 case   7 

 	 % ALG. DEG.:    7
 	 % PTS CARD.:   12
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 5.1e-16  

 	 xyw=[
 	 6.23822650944021450669652040232904e-02 6.75178670739160630143160801708291e-02 2.65170281574362634580133146755543e-02
 	 6.75178670739161046476795036141993e-02 8.70099867831681805796506523620337e-01 2.65170281574362530496724588147117e-02
 	 8.70099867831681694774204061104683e-01 6.23822650944021381280713001160620e-02 2.65170281574362669274602666291685e-02
 	 5.52254566569266303055485423101345e-02 3.21502493851981818728802409168566e-01 4.38814087144460684974944797431817e-02
 	 3.21502493851981763217651177910739e-01 6.23272049491091606476800279779127e-01 4.38814087144460615586005758359534e-02
 	 6.23272049491091606476800279779127e-01 5.52254566569265609166095032378507e-02 4.38814087144460546197066719287250e-02
 	 3.43243029450971681715287786573754e-02 6.60949196186735643543386231613113e-01 2.87750427849816046987907469656420e-02
 	 6.60949196186735643543386231613113e-01 3.04726500868167216040660605358426e-01 2.87750427849815838821090352439569e-02
 	 3.04726500868167160529509374100599e-01 3.43243029450971195992714513067767e-02 2.87750427849815665348742754758860e-02
 	 5.15842334353591835949259802873712e-01 2.77716166976391787279965228663059e-01 6.74931870098027658633199621363019e-02
 	 2.77716166976391787279965228663059e-01 2.06441498670016376770774968463229e-01 6.74931870098027658633199621363019e-02
 	 2.06441498670016487793077430978883e-01 5.15842334353591724926957340358058e-01 6.74931870098027797411077699507587e-02
 	 ];
 
 	 case   8 

 	 % ALG. DEG.:    8
 	 % PTS CARD.:   16
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.0e-16  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 7.21578038388935860680817313550506e-02
 	 4.59292588292723125142913431773195e-01 4.59292588292723125142913431773195e-01 4.75458171336423096597911808203207e-02
 	 4.59292588292723125142913431773195e-01 8.14148234145537497141731364536099e-02 4.75458171336423096597911808203207e-02
 	 8.14148234145537497141731364536099e-02 4.59292588292723125142913431773195e-01 4.75458171336423096597911808203207e-02
 	 1.70569307751760212976677166807349e-01 1.70569307751760212976677166807349e-01 5.16086852673591223172877562319627e-02
 	 1.70569307751760212976677166807349e-01 6.58861384496479574046645666385302e-01 5.16086852673591223172877562319627e-02
 	 6.58861384496479574046645666385302e-01 1.70569307751760212976677166807349e-01 5.16086852673591223172877562319627e-02
 	 5.05472283170309566457945038564503e-02 5.05472283170309566457945038564503e-02 1.62292488115990396480015078850556e-02
 	 5.05472283170309566457945038564503e-02 8.98905543365938086708410992287099e-01 1.62292488115990396480015078850556e-02
 	 8.98905543365938086708410992287099e-01 5.05472283170309566457945038564503e-02 1.62292488115990396480015078850556e-02
 	 8.39477740995758781039626228448469e-03 2.63112829634638112352718053443823e-01 1.36151570872174963733325370185412e-02
 	 8.39477740995758781039626228448469e-03 7.28492392955404355348036915529519e-01 1.36151570872174963733325370185412e-02
 	 2.63112829634638112352718053443823e-01 8.39477740995758781039626228448469e-03 1.36151570872174963733325370185412e-02
 	 2.63112829634638112352718053443823e-01 7.28492392955404355348036915529519e-01 1.36151570872174963733325370185412e-02
 	 7.28492392955404355348036915529519e-01 8.39477740995758781039626228448469e-03 1.36151570872174963733325370185412e-02
 	 7.28492392955404355348036915529519e-01 2.63112829634638112352718053443823e-01 1.36151570872174963733325370185412e-02
 	 ];
 
 	 case   9 

 	 % ALG. DEG.:    9
 	 % PTS CARD.:   19
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.3e-16  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.85678981413994320659455183886166e-02
 	 4.37089591492936635486188379218220e-01 4.37089591492936635486188379218220e-01 3.89137705023871460774387287528953e-02
 	 4.37089591492936635486188379218220e-01 1.25820817014126729027623241563560e-01 3.89137705023871460774387287528953e-02
 	 1.25820817014126729027623241563560e-01 4.37089591492936635486188379218220e-01 3.89137705023871460774387287528953e-02
 	 1.88203535619032746861734040066949e-01 1.88203535619032746861734040066949e-01 3.98238694636051313024971420873044e-02
 	 1.88203535619032746861734040066949e-01 6.23592928761934506276531919866102e-01 3.98238694636051313024971420873044e-02
 	 6.23592928761934506276531919866102e-01 1.88203535619032746861734040066949e-01 3.98238694636051313024971420873044e-02
 	 4.89682519198737620236272505280795e-01 4.89682519198737620236272505280795e-01 1.56673501135695392161295558253187e-02
 	 4.89682519198737620236272505280795e-01 2.06349616025247595274549894384108e-02 1.56673501135695392161295558253187e-02
 	 2.06349616025247595274549894384108e-02 4.89682519198737620236272505280795e-01 1.56673501135695392161295558253187e-02
 	 4.47295133944526912550543329416541e-02 4.47295133944526912550543329416541e-02 1.27888378293490190956704921632081e-02
 	 4.47295133944526912550543329416541e-02 9.10540973211094617489891334116692e-01 1.27888378293490190956704921632081e-02
 	 9.10540973211094617489891334116692e-01 4.47295133944526912550543329416541e-02 1.27888378293490190956704921632081e-02
 	 3.68384120547362581277184290229343e-02 2.21962989160765677976172582930303e-01 2.16417696886446915549573333237277e-02
 	 3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01 2.16417696886446915549573333237277e-02
 	 2.21962989160765677976172582930303e-01 3.68384120547362581277184290229343e-02 2.16417696886446915549573333237277e-02
 	 2.21962989160765677976172582930303e-01 7.41198598784498008384957756788936e-01 2.16417696886446915549573333237277e-02
 	 7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02 2.16417696886446915549573333237277e-02
 	 7.41198598784498008384957756788936e-01 2.21962989160765677976172582930303e-01 2.16417696886446915549573333237277e-02
 	 ];
 
 	 case  10 

 	 % ALG. DEG.:   10
 	 % PTS CARD.:   24
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.2e-16  

 	 xyw=[
 	 5.05505073735290855196922166214790e-01 2.07761165754848264874965479975799e-01 4.33620193138323575809955912063742e-02
 	 2.75423850244129797548708893373259e-01 4.81232890624642473120786689833039e-01 4.76332786356749582346026272716699e-02
 	 2.64815316514967702410388028511079e-01 2.75863340893159669775513975764625e-01 4.22072212798550380763451528309815e-02
 	 7.53294027762542395265654704417102e-01 1.09549598555854665882236531615490e-01 2.63651907044195124574237354408979e-02
 	 5.24336825589244326373261628759792e-01 3.64197444303392625641890845145099e-01 3.70398236683899192978053349634138e-02
 	 2.95304455358511019902323369024089e-01 6.42033653186626640518852582317777e-01 2.74578021969271793278899451706820e-02
 	 1.06146429902899963604312461029622e-01 7.67776801700239541759174244361930e-01 2.62683295512058309628677932323626e-02
 	 6.34918323792006522587882955122041e-01 3.60362667879077225308037668582983e-02 2.14811646960396673833315617230255e-02
 	 3.87296579139603525110402415521094e-01 8.41985221155437391082898557215231e-02 3.13439626504568094600422512030491e-02
 	 1.69299274889664619347939833460259e-01 1.09994390556304499906303817624575e-01 2.89870702993496147381602412451684e-02
 	 8.04918946561055670407824891299242e-02 5.79663251054863493116897643631091e-01 3.30930672376299403469879223393946e-02
 	 9.53792084877216894689411219587782e-02 3.39472903118005542300039678593748e-01 3.08711229330977006413139207552376e-02
 	 9.28994869857879046470827688608551e-01 4.77683817720224168645870577165624e-02 7.30416461156084464295679126166760e-03
 	 7.47265917288688186204126395750791e-01 2.23763587742758507381779509159969e-01 1.61513010117286491540422588286674e-02
 	 5.03658250759439707344711223413469e-01 4.87984378053974987565766241459642e-01 9.77970610876095249042183610299617e-03
 	 1.61346504998909567873965897888411e-01 8.38653495001090432126034102111589e-01 5.53347339112354470042065557322530e-03
 	 2.95535928468228514809368334681494e-02 9.30498469002630890223315418552374e-01 7.60154701300635310401432320759341e-03
 	 8.68543869430765447248177224537358e-01 3.81025708546434138668246305314824e-03 5.33334563795629518212493280771014e-03
 	 3.93667744707220101929578959243372e-01 0.00000000000000000000000000000000e+00 5.95015240711780149518439486655552e-03
 	 1.76907306255590313082137754463474e-01 1.09391420571199327049782823451096e-02 7.42331182334024682056838884136596e-03
 	 3.53196562525860957570955633855192e-02 3.90997455504232815926002331252676e-02 8.82792229648109681716672270113122e-03
 	 0.00000000000000000000000000000000e+00 7.77575184294291066322557526291348e-01 6.69954039292840457936462073007533e-03
 	 0.00000000000000000000000000000000e+00 4.63743838674305408620313073697616e-01 7.57813095878283934231367524603229e-03
 	 3.05734040930993322682240886933869e-02 1.93059032242519357236432142599369e-01 1.57073511803344223469736107290373e-02
 	 ];
 
 	 case  11 

 	 % ALG. DEG.:   11
 	 % PTS CARD.:   27
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.6e-15  

 	 xyw=[
 	 4.64945647736939915439791093376698e-01 2.91338594369423609098390670624212e-01 3.41206899787455109063216696085874e-02
 	 3.20819579094829943066713440202875e-01 5.36342281120847141906438082514796e-01 3.10965750556274275751000857326289e-02
 	 5.13531434334472347558175897574984e-01 1.24544059105441029533523078498547e-01 2.83229425613497412528296592881816e-02
 	 2.87903102248196485213327378005488e-01 2.27899558843475014136004119791323e-01 3.30712229424806256061764031528583e-02
 	 2.66771680715777448344994127182872e-01 4.11324991789046578993804814672330e-01 2.93058842037048350448458222672343e-02
 	 1.16989764133234419585249952433514e-01 3.19097378146818710931142959452700e-01 2.74955063587111921130645697530781e-02
 	 8.16262337159688100562959789385786e-01 2.77195229186185665426478408335242e-02 1.18210297828823442806145394001760e-02
 	 5.69384861953279974855490763729904e-01 3.49929143342886495027244109223830e-01 2.74859990044218557847521822168346e-02
 	 3.72727698616290958888441764429444e-01 5.98954396299342106679830521898111e-01 1.62984365724539934094927673413622e-02
 	 2.68071506267725800931600588228321e-02 8.15629696932682168863948390935548e-01 1.15561901768105341342662839565492e-02
 	 7.00992679496452275600404391298071e-01 1.41181197309527994843136866620625e-01 2.60302676690604868625644741086944e-02
 	 3.27198781575528951925946330447914e-01 8.17214048553817629105822106794221e-02 2.12988524490576314196488283414510e-02
 	 1.36670835343905061609603990291362e-01 1.30354530319426897833068323961925e-01 2.27691295600751103522796370270953e-02
 	 1.38280002042923177985045413151965e-01 7.10278681077615825500970458961092e-01 2.45954974541872685434018563910286e-02
 	 2.25926510513065892382655874826014e-02 3.89139811133193569414601142852916e-01 1.33613935873663075559747426268586e-02
 	 9.36148935146756233649512068950571e-01 3.28998222921862981671381476189708e-02 6.55296742604411820709575664523072e-03
 	 8.04549747476155374670270248316228e-01 1.64292867157134647726479670382105e-01 1.37979500750899548855432641403240e-02
 	 6.19484315331351953481942018697737e-01 3.78021638913369206758119389633066e-01 5.63753560785515937803236141689922e-03
 	 1.66556144920605719850215109545388e-01 8.03648340539038774643643137096660e-01 1.33783180816265789142560649338520e-02
 	 3.32685606226784114092254185379716e-02 9.35514342858970948668684286531061e-01 6.68715464323136471458397522837913e-03
 	 6.19248732321101225117843114276184e-01 2.62971997137641522179762887390098e-02 1.47172790532167623717141324846125e-02
 	 3.96597316695864954283479164587334e-01 1.43545320109308982559070955176139e-02 9.17944219506817114806462853948688e-03
 	 1.68929709822902285321077897606301e-01 2.21205351961617502354329189984128e-02 1.06889040489568411251841695275289e-02
 	 3.29164038789997448475332930684090e-02 3.42227718413591897039793821022613e-02 7.27405434028103974053447444703124e-03
 	 2.56601868330524340855447462672601e-02 6.17588731712771510373727323894855e-01 1.43608886837635445210548112981996e-02
 	 1.24171485868014852549379156698706e-01 5.31419601540799590999597512563923e-01 2.70607382376273977730996023183252e-02
 	 2.52527046383044795341277222178178e-02 1.74005716730322557150856255248073e-01 1.20351502503041156433294389671573e-02
 	 ];
 
 	 case  12 

 	 % ALG. DEG.:   12
 	 % PTS CARD.:   32
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw=[
 	 3.79860210934019559836372081917943e-01 2.10785259391403911877205246128142e-01 2.97189169755677079498568105009326e-02
 	 3.01417093209093045480528871848946e-01 4.09786577770025306488577143682051e-01 3.76110313016622122006538120331243e-02
 	 5.58025289531202561832401443098206e-01 2.13777432530059596782479047760717e-01 3.15822732113283446975238177856227e-02
 	 1.25122995058103869681076503184158e-01 6.19381257362555781575963465002133e-01 2.54824624383938116989334332629369e-02
 	 2.11179399098049336291893496309058e-01 2.44982965093490157038047527748859e-01 2.37497876626535792121686085920373e-02
 	 8.54314749475804324774230735783931e-01 7.18714961015891051765436259302078e-02 1.12453730995791117974746953223075e-02
 	 7.17881858980523257507400103349937e-01 2.03768481077729768369266594163491e-01 1.97868028964859644924789705555668e-02
 	 4.66317874623230710362520312628476e-01 4.08963804491244753425149838221841e-01 2.99948536635530858818210475646993e-02
 	 2.50155003353392135778676674817689e-01 6.27682615680314026640473912266316e-01 2.66760415244104640009048523552337e-02
 	 7.99553848413813161855046018899884e-02 8.26003314017559997495254719979130e-01 1.52645862060361986456413774249086e-02
 	 7.10081259568365208423301737639122e-01 6.44132203822605498011455438245321e-02 2.06409436977313121008847929260810e-02
 	 4.97320633777965981359159286512295e-01 7.05667243440368241458315878844587e-02 2.40744025184536671047030864656335e-02
 	 2.60770682565628963978099363885121e-01 9.54285858105846096499647046584869e-02 2.29689210828958600973948023238336e-02
 	 8.96027058005874343926677738636499e-02 1.16386499067277326968650186245213e-01 1.52876388020194778349925002203236e-02
 	 2.30881487661157569490910645981785e-02 7.49189739790679487541069647704717e-01 1.08425427085057524828615171941237e-02
 	 1.29532969004336195872895132197300e-01 4.22605657433460013550075018429197e-01 2.70734363065837854711581655919872e-02
 	 9.34480876044409547453994946408784e-02 2.43458133948799726464784498602967e-01 1.39718671599399282823306123191287e-02
 	 9.55269193570060348719152898411267e-01 2.35517332495787101720452483277768e-02 3.33795001368367800706482562134170e-03
 	 8.45935398373143909722671196504962e-01 1.54064601626856090277328803495038e-01 3.85724618681241747039645240135997e-03
 	 6.16009296172674969405136380373733e-01 3.61181591189672079877936994307674e-01 1.25495867138425559739189907304535e-02
 	 3.93165103196048082434543857743847e-01 5.81689214740147453319707437913166e-01 1.40727793026066659576311934642945e-02
 	 1.89206330617159357299073008107371e-01 7.88601719223131603087040275568143e-01 1.03100020598410578587245112203163e-02
 	 4.30105601064054710036543838214129e-02 9.45475073220970907428295504359994e-01 3.55987571804036251679748126264258e-03
 	 8.58158884215330819422717922861921e-01 0.00000000000000000000000000000000e+00 3.42276732717184534182663924184453e-03
 	 6.27315319232411794381221170624485e-01 0.00000000000000000000000000000000e+00 4.82735437121817236721943444877070e-03
 	 3.63846604460775102651837187295314e-01 1.45665147883469736633799129776889e-02 9.27274021080326527055603946791962e-03
 	 1.55570668968979530788487863901537e-01 2.11522233831219486077657165878918e-02 9.24184290561538661357143809027548e-03
 	 2.97541174968417587720637129677925e-02 2.71109713562557863575364081043517e-02 5.25466336780125789496231902830914e-03
 	 0.00000000000000000000000000000000e+00 9.27348974483949817226857703644782e-01 2.44402490733001921327516292592463e-03
 	 2.57162836236938807665808326419210e-02 5.44446676271925222856395976123167e-01 1.40848272298649806327786038195882e-02
 	 2.45062866369900045349083939072443e-02 3.32129083947645065144627096742624e-01 1.24520366007538508396068621664199e-02
 	 9.22969090596492680589335577678867e-03 1.46044961672175677147578198855626e-01 5.34042182881414636413941465775679e-03
 	 ];
 
 	 case  13 

 	 % ALG. DEG.:   13
 	 % PTS CARD.:   36
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.1e-16  

 	 xyw=[
 	 2.60167889975679161862487376311037e-02 2.40222268841206107459207430565584e-02 4.03998964180703364068580896173444e-03
 	 2.40222266056275869650082910311539e-02 9.49960984299580535328288988239365e-01 4.03998960652205731103325803132975e-03
 	 9.49960983828827321140408912469866e-01 2.60167891895750139075182971737377e-02 4.03998968727853520477300008906241e-03
 	 1.88836306686942824450969879990225e-02 1.22080867325125158595611196687969e-01 6.44601445440000451331252762088297e-03
 	 1.22080865615096983978205003040785e-01 8.59035503703662994823275766975712e-01 6.44601436374914963517435140261114e-03
 	 8.59035502492874303293035609385697e-01 1.88836297321810057947555350210678e-02 6.44601419077840860627492958201401e-03
 	 1.31639216755138704906258340088243e-01 2.28747090565116009686086329111276e-02 8.28012183702025485187991904467708e-03
 	 2.28747093163145995275975508320698e-02 8.45486073780362001883759148768149e-01 8.28012192673547101073872056531400e-03
 	 8.45486073324166143017066588072339e-01 1.31639217770324529199754692854185e-01 8.28012185413436532788189481379959e-03
 	 2.07315314538747512418392915378718e-02 2.80737807897761981745787807085435e-01 9.51156673209609636321371084477505e-03
 	 2.80737804477865227070765286043752e-01 6.98530664767438969064983211865183e-01 9.51156633244431420903808316325012e-03
 	 6.98530660028288119534067845961545e-01 2.07315315728960856966889281238764e-02 9.51156678397508704991825112529114e-03
 	 4.76642854053482611931258361437358e-01 5.04849500035025267052901654096786e-01 9.67982549828267160862971252299758e-03
 	 5.04849495463474129408609769598115e-01 1.85076462972688683683575305849445e-02 9.67982564452105238850254664839667e-03
 	 1.85076458585603301210120719133556e-02 4.76642857835611943873033169438713e-01 9.67982542765623114877637789277287e-03
 	 3.02387014801126063900937879225239e-01 1.99757515090916715205793252607691e-02 9.79189853858823851251447223376090e-03
 	 1.99757511746916083250624751599389e-02 6.77637233570464792009602206235286e-01 9.79189840044913592520536838037515e-03
 	 6.77637231251634108986081628245302e-01 3.02387017597124940770925149990944e-01 9.79189846461464910576388831486838e-03
 	 1.01539777415501644708406558947900e-01 1.19028238394272706246468374047254e-01 1.51407481012283094690129559012348e-02
 	 1.19028239511687658480632023838552e-01 7.79431983178413778645676757150795e-01 1.51407482760150848000169077067767e-02
 	 7.79431987279475047003529653011356e-01 1.01539774383865286089267954139359e-01 1.51407479084209092151658282432436e-02
 	 2.49614419434176670886671445259708e-01 1.03589969002955084587114242822281e-01 1.90820321320367032591480693781705e-02
 	 1.03589967812852373763021773811488e-01 6.46795611281056226360419714183081e-01 1.90820320200718561431951769691295e-02
 	 6.46795616892277380749476378696272e-01 2.49614415590636157249448956463311e-01 1.90820317414477809425665810749706e-02
 	 1.02029245899726006552299395480077e-01 2.76888289616485705479931311856490e-01 1.90996691614169246398180490587038e-02
 	 2.76888294228863351964520234105294e-01 6.21082463846217014413753076951252e-01 1.90996686937001634853938725200351e-02
 	 6.21082464001205591941356942697894e-01 1.02029246368156176205665985889937e-01 1.90996692404052093028354875059449e-02
 	 2.26789276022037022961796992603922e-01 2.33728374217554740743807428771106e-01 2.04235756492426485941837910331742e-02
 	 2.33728371859891315143187284775195e-01 5.39482360682531081330637334758649e-01 2.04235749257686768909358931978204e-02
 	 5.39482355318465778282188693992794e-01 2.26789276022037022961796992603922e-01 2.04235750270172211617847324305330e-02
 	 4.37409498131037799417697442549979e-01 9.59920858845616786769738837392651e-02 2.05428460504838393541060526104047e-02
 	 9.59920836950179934277116444718558e-02 4.66598416159025475291599605043302e-01 2.05428456208598293752931596145572e-02
 	 4.66598421189779177797873899180559e-01 4.37409494682125088438340299035190e-01 2.05428457919928607322557212455649e-02
 	 3.80758577881083304372822340155835e-01 2.27855355201996984115808686510718e-01 2.46283800576019562544871632780996e-02
 	 2.27855351201257216864348720264388e-01 3.91386077299870405177273369190516e-01 2.46283803633365848406722165009342e-02
 	 3.91386069899954280870701950334478e-01 3.80758578955004756139146593341138e-01 2.46283798539006330841072411885762e-02
 	 ];
 
 	 case  14 

 	 % ALG. DEG.:   14
 	 % PTS CARD.:   42
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.4e-16  

 	 xyw=[
 	 1.77205532412543442788432912493590e-01 1.77205532412543442788432912493590e-01 2.10812943684965115043183914167457e-02
 	 1.77205532412543442788432912493590e-01 6.45588935174913114423134175012819e-01 2.10812943684965115043183914167457e-02
 	 6.45588935174913114423134175012819e-01 1.77205532412543442788432912493590e-01 2.10812943684965115043183914167457e-02
 	 4.17644719340453940414903399869218e-01 4.17644719340453940414903399869218e-01 1.63941767720626775661774132686332e-02
 	 4.17644719340453940414903399869218e-01 1.64710561319092119170193200261565e-01 1.63941767720626775661774132686332e-02
 	 1.64710561319092119170193200261565e-01 4.17644719340453940414903399869218e-01 1.63941767720626775661774132686332e-02
 	 6.17998830908725871324804757023230e-02 6.17998830908725871324804757023230e-02 7.21684983488833555614894166296835e-03
 	 6.17998830908725871324804757023230e-02 8.76400233818254825735039048595354e-01 7.21684983488833555614894166296835e-03
 	 8.76400233818254825735039048595354e-01 6.17998830908725871324804757023230e-02 7.21684983488833555614894166296835e-03
 	 4.88963910362178622026618768359185e-01 4.88963910362178622026618768359185e-01 1.09417906847144464493881699240774e-02
 	 4.88963910362178622026618768359185e-01 2.20721792756427559467624632816296e-02 1.09417906847144464493881699240774e-02
 	 2.20721792756427559467624632816296e-02 4.88963910362178622026618768359185e-01 1.09417906847144464493881699240774e-02
 	 2.73477528308838646609046918456443e-01 2.73477528308838646609046918456443e-01 2.58870522536457994822178818594693e-02
 	 2.73477528308838646609046918456443e-01 4.53044943382322706781906163087115e-01 2.58870522536457994822178818594693e-02
 	 4.53044943382322706781906163087115e-01 2.73477528308838646609046918456443e-01 2.58870522536457994822178818594693e-02
 	 1.93909612487010440950996326137101e-02 1.93909612487010440950996326137101e-02 2.46170180120004137430678170517240e-03
 	 1.93909612487010440950996326137101e-02 9.61218077502597911809800734772580e-01 2.46170180120004137430678170517240e-03
 	 9.61218077502597911809800734772580e-01 1.93909612487010440950996326137101e-02 2.46170180120004137430678170517240e-03
 	 2.98372882136257788765476561820833e-01 6.86980167808087793801519183034543e-01 7.21815405676692195546806374295556e-03
 	 2.98372882136257788765476561820833e-01 1.46469500556544174330042551446240e-02 7.21815405676692195546806374295556e-03
 	 6.86980167808087793801519183034543e-01 2.98372882136257788765476561820833e-01 7.21815405676692195546806374295556e-03
 	 6.86980167808087793801519183034543e-01 1.46469500556544174330042551446240e-02 7.21815405676692195546806374295556e-03
 	 1.46469500556544174330042551446240e-02 2.98372882136257788765476561820833e-01 7.21815405676692195546806374295556e-03
 	 1.46469500556544174330042551446240e-02 6.86980167808087793801519183034543e-01 7.21815405676692195546806374295556e-03
 	 5.71247574036479188741566304088337e-02 1.72266687821355568566161764465505e-01 1.23328766062818402649003957094465e-02
 	 5.71247574036479188741566304088337e-02 7.70608554774996457048530373867834e-01 1.23328766062818402649003957094465e-02
 	 1.72266687821355568566161764465505e-01 5.71247574036479188741566304088337e-02 1.23328766062818402649003957094465e-02
 	 1.72266687821355568566161764465505e-01 7.70608554774996457048530373867834e-01 1.23328766062818402649003957094465e-02
 	 7.70608554774996457048530373867834e-01 5.71247574036479188741566304088337e-02 1.23328766062818402649003957094465e-02
 	 7.70608554774996457048530373867834e-01 1.72266687821355568566161764465505e-01 1.23328766062818402649003957094465e-02
 	 3.36861459796344964168213209632086e-01 5.70222290846683188547672216373030e-01 1.92857553935303453751526348014522e-02
 	 3.36861459796344964168213209632086e-01 9.29162493569718472841145739948843e-02 1.92857553935303453751526348014522e-02
 	 5.70222290846683188547672216373030e-01 3.36861459796344964168213209632086e-01 1.92857553935303453751526348014522e-02
 	 5.70222290846683188547672216373030e-01 9.29162493569718472841145739948843e-02 1.92857553935303453751526348014522e-02
 	 9.29162493569718472841145739948843e-02 3.36861459796344964168213209632086e-01 1.92857553935303453751526348014522e-02
 	 9.29162493569718472841145739948843e-02 5.70222290846683188547672216373030e-01 1.92857553935303453751526348014522e-02
 	 1.26833093287204157206815580138937e-03 1.18974497696956837966553166552330e-01 2.50511441925033639596676060534719e-03
 	 1.26833093287204157206815580138937e-03 8.79757171370171064950227446388453e-01 2.50511441925033639596676060534719e-03
 	 1.18974497696956837966553166552330e-01 1.26833093287204157206815580138937e-03 2.50511441925033639596676060534719e-03
 	 1.18974497696956837966553166552330e-01 8.79757171370171064950227446388453e-01 2.50511441925033639596676060534719e-03
 	 8.79757171370171064950227446388453e-01 1.26833093287204157206815580138937e-03 2.50511441925033639596676060534719e-03
 	 8.79757171370171064950227446388453e-01 1.18974497696956837966553166552330e-01 2.50511441925033639596676060534719e-03
 	 ];
 
 	 case  15 

 	 % ALG. DEG.:   15
 	 % PTS CARD.:   46
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 5.0e-16  

 	 xyw=[
 	 3.33333292261711877646490620463737e-01 3.33333369225872422347833889944013e-01 2.33748155875758353849924731093779e-02
 	 1.84348340534850607674854927608976e-02 2.10206116064859810377285498361744e-02 2.51393589507226860105260080047174e-03
 	 2.10206198587913860309495106548638e-02 9.60544553925707256247790155612165e-01 2.51393569637528395410708270674149e-03
 	 9.60544579872547044097075286117615e-01 1.84348154031861895252308869430635e-02 2.51393239452845198081409883172910e-03
 	 9.44694948714600857275769385523745e-02 1.40084791735677512136692968169882e-02 3.79933836817317963779894185449848e-03
 	 1.40084495619432081864319528108354e-02 8.91522111110737869310582937032450e-01 3.79932899672832252724319346270931e-03
 	 8.91522077853913352818437942914898e-01 9.44693784006580272727404690158437e-02 3.79934737306244184329440116698606e-03
 	 2.21059623335564947588238737807842e-01 1.46001805115354987840703415713506e-02 5.36606624325662064090014524708749e-03
 	 1.46001627401248310761383564226890e-02 7.64340360199224910786597320111468e-01 5.36605572563657318152507968989084e-03
 	 7.64340671414178274289952241815627e-01 2.21059339300117646542886973293207e-01 5.36598839236875936598014646961019e-03
 	 1.83161349800822388644849780803270e-02 1.06831540445691930418803394786664e-01 5.41543061174039330740725972646032e-03
 	 1.06831572649002698449649528811278e-01 8.74852289591818377267884443426738e-01 5.41543292052138088010782013270727e-03
 	 8.74852363873429461627040382154519e-01 1.83161445101451825223648484097794e-02 5.41543076261086220313245576107875e-03
 	 3.84111880036755948264470816866378e-01 1.35065559081281177933320236661530e-02 6.12435944557631825602150854592765e-03
 	 1.35065505592318075428481805033698e-02 6.02381757760965697023891607386759e-01 6.12435703950236273035434564349089e-03
 	 6.02381907561370333326067338930443e-01 3.84111551382989191427697051040013e-01 6.12435463564138353464993969055286e-03
 	 1.76095784933983541542534823065580e-02 2.46869564037977468062834418560669e-01 7.19892017990240648539490564417065e-03
 	 2.46869635891989791520728658724693e-01 7.35520785115458264336041338538053e-01 7.19892224504508487781251346859790e-03
 	 7.35520958397237634152077134785941e-01 1.76095847380971885776101970577656e-02 7.19892013179164024644363095717381e-03
 	 1.62110954488718303490024652546708e-02 4.20027449315563017329111517028650e-01 7.49190020798990233275027605941432e-03
 	 4.20027557266491768928062811028212e-01 5.63761341880282595973028492153389e-01 7.49190393884934403151421022926115e-03
 	 5.63761608884686626907978279632516e-01 1.62111046483847491550545072414025e-02 7.49190232121703901524423230284810e-03
 	 9.45835540958728515636977363101323e-02 7.81937423335833381443649159336928e-02 9.61633693621145001217964676243355e-03
 	 7.81936458310440452024181468004826e-02 8.27222782704063241965286579215899e-01 9.61633495119591438782258308037854e-03
 	 8.27222507563532660768146342888940e-01 9.45835855871118430515664954327804e-02 9.61634719828197842561579022913065e-03
 	 2.23020503669574404748132678832917e-01 6.90247082160969777087089482847659e-02 1.04173339778732328836374776415141e-02
 	 6.90245901886988449946969126358454e-02 7.07954806600517905224023706978187e-01 1.04173200840826374324876724131173e-02
 	 7.07955491881565479594939915841678e-01 2.23020657547390782626806071675674e-01 1.04172557218891737029764499311568e-02
 	 9.13686563942972540530718106310815e-02 1.97441541806721687635217676870525e-01 1.42884849730802853534639140775653e-02
 	 1.97441432426123636423298535191861e-01 7.11189907126281162241809852275765e-01 1.42884846869895058146804345255987e-02
 	 7.11189569389398590359974150487687e-01 9.13686840082226642278939721109055e-02 1.42884890448401660062449636257043e-02
 	 3.84530855617108480171140172387823e-01 7.30977274485456463004595661914209e-02 1.45158335893254743925728789122331e-02
 	 7.30977106499786088988912524655461e-02 5.42371300752677920620214990776731e-01 1.45158336691942786711440049884914e-02
 	 5.42371248933846916706613683345495e-01 3.84531035703955026416878126838128e-01 1.45158423302523161002586249423985e-02
 	 2.15038812389831607285728409806325e-01 1.55893061854053271986231266055256e-01 1.51201380421244653551315906270247e-02
 	 1.55892843158961874605594744025439e-01 6.29068363385964834932906342146453e-01 1.51201294906665728579042706769542e-02
 	 6.29068887420656586151324063393986e-01 2.15038957479725206800580394883582e-01 1.51202112131431642971790552110178e-02
 	 8.53189508964801446300185716609121e-02 3.59007499441052202460156195229501e-01 1.62557619200069045084511287768692e-02
 	 3.59007386827242869209442233113805e-01 5.55673632624283819758659319631988e-01 1.62557683569843729187720526851990e-02
 	 5.55673357289606983933083483861992e-01 8.53189724946177840969596672948683e-02 1.62557597236451592537243016067805e-02
 	 2.04230402773116243020368187899294e-01 2.86157186802203589159887542336946e-01 2.00935650478077099112539372072206e-02
 	 2.86156970552324307899283439837745e-01 5.09612567484152623187299013807205e-01 2.00935725508967488739386908491724e-02
 	 5.09612717585778640660976179788122e-01 2.04230501683514309441136447276222e-01 2.00936262301876777947029495408060e-02
 	 3.63891035835017306876437714890926e-01 1.81085979988352741010260160692269e-01 2.06576753252571722330177550475128e-02
 	 1.81085896307873084332129565154901e-01 4.55023141283621535002623659238452e-01 2.06576526540188792901986403194314e-02
 	 4.55022970575782392810282317441306e-01 3.63891085598291641467483259475557e-01 2.06576631688787891449887723638312e-02
 	 ];
 
 	 case  16 

 	 % ALG. DEG.:   16
 	 % PTS CARD.:   52
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 5.7e-16  

 	 xyw=[
 	 3.33333258825057543450753883007565e-01 3.33333416793498094055081537590013e-01 1.83161356690042520511951806838624e-02
 	 1.59610022226682676804720983909647e-02 1.68831336617950890366390837016297e-02 1.77215002968106826418404065037748e-03
 	 1.68831386831158891670412458552164e-02 9.67155848242693849670104100368917e-01 1.77215172278432416680393757246748e-03
 	 9.67155874801573611776461802946869e-01 1.59610017505312264118888521124973e-02 1.77214893529966570698275241113606e-03
 	 3.82175264537209027904118840979208e-03 9.93497988852496682898873814338003e-02 2.00876779970245817816265621047478e-03
 	 9.93498059462007421238638471550075e-02 8.96828443482067250158706883667037e-01 2.00876763100196970360244996811616e-03
 	 8.96828514177593794087783862778451e-01 3.82166009293576384650559241151768e-03 2.00875428445736105981245245288846e-03
 	 9.26216384068819231778491030127043e-02 4.71767615382126959816533329217236e-03 2.09534643583341373060391354954390e-03
 	 4.71771782160070388134620600339986e-03 9.02660618534333103468725312268361e-01 2.09535309616869138554795526374619e-03
 	 9.02660635509004438681301962787984e-01 9.26216255989500553136295479816908e-02 2.09535571549310283348543926251750e-03
 	 9.80978287005476561055683504264380e-03 2.46739276017129749440925934322877e-01 4.28137141302858178354417972855117e-03
 	 2.46739291498785623391043486662966e-01 7.43450929200298094023935391305713e-01 4.28137043451878602368099180353056e-03
 	 7.43450875758368434631506715959404e-01 9.80976558397046727311163749618572e-03 4.28136536166454344937148945859917e-03
 	 2.34453465539761568559029569769336e-01 1.25212065221199080750080767643340e-02 4.98949564172988802024377719135373e-03
 	 1.25212159624579367350749592446846e-02 7.53025327539010524979801175504690e-01 4.98949931659404665590384908568922e-03
 	 7.53025384905626316012217102979776e-01 2.34453392434268298449850931319816e-01 4.98950249769322326520715193964861e-03
 	 5.16571129743772089470965624968812e-02 5.77757501193756767277065478083387e-02 5.10627260057649242502852970915228e-03
 	 5.77758193667164202111941051498434e-02 8.90567064125437068966562037530821e-01 5.10627524759000965548505490687603e-03
 	 8.90567194917750382110455120709958e-01 5.16569496852326212610329037033807e-02 5.10626983950075198637197360085338e-03
 	 1.59791125061900518566915252449689e-02 4.13443247683559167438005488293129e-01 7.04073382268429089070327364652258e-03
 	 4.13443261309727971841709859290859e-01 5.70577625472078464596847879874986e-01 7.04073434970744517491514358198401e-03
 	 5.70577597706886541217841113393661e-01 1.59791161057934658074053402287973e-02 7.04073372383285170372779759873083e-03
 	 3.96856249731830756921624470123788e-01 1.67626482477742817789323481747488e-02 7.31496003599158874097785343337819e-03
 	 1.67626502257961773612038314240635e-02 5.86381091244488561464720532967476e-01 7.31496182529749183753864372192766e-03
 	 5.86381123891194455666209250921384e-01 3.96856228163050439583514616970206e-01 7.31496204446115648456494540141648e-03
 	 1.40368578298825791295101339528628e-01 5.03998899802897762367770440050663e-02 8.02823717739924343217428059915619e-03
 	 5.03999622891451101724946681770234e-02 8.09231429420804393437549606460379e-01 8.02824167196676888313966458099458e-03
 	 8.09231545448009126353383635432692e-01 1.40368456667959051742400333750993e-01 8.02824738742507343358667526445061e-03
 	 4.86458021470726476032098162249895e-02 1.53602435235486750597644345361914e-01 8.51217272687783237106184941467291e-03
 	 1.53602501486405723651884613900620e-01 7.97751700040076339170980190829141e-01 8.51217172309876903002479053839124e-03
 	 7.97751821638013391968513587926282e-01 4.86457042544259365968173369765282e-02 8.51216838546291904021856566942006e-03
 	 6.75455296003345112554328011356120e-02 2.93562763267696591462652122572763e-01 1.24778725807735534764075779889936e-02
 	 2.93562815361712137196548155770870e-01 6.38891644704477568161848921590718e-01 1.24778766420405376469382474624581e-02
 	 6.38891715657272207806727237766609e-01 6.75455106829575269156151762217632e-02 1.24778728336622790617838063553791e-02
 	 1.60475924195126878890604871230607e-01 2.76119726602889581368316385123762e-01 1.40995757871014947004706385769168e-02
 	 2.76119919814122483092688753458788e-01 5.63404080925371975041571204201318e-01 1.40995945247351563839321997306797e-02
 	 5.63404080925371975041571204201318e-01 1.60475943078972893562905710496125e-01 1.40995883359170178644736992623621e-02
 	 2.80462494123582872784794517428963e-01 7.72798169129284839851123933840427e-02 1.41352938794588166987464816770625e-02
 	 7.72798476080368140772591800669034e-02 6.42257629182079847751651868748013e-01 1.41352983913212177508045286344895e-02
 	 6.42257731649287122444036413071444e-01 2.80462425269744686229245189679204e-01 1.41352990576473335621043858623125e-02
 	 1.47356656075135344918791702184535e-01 1.48012282095027453143742945940176e-01 1.46130641326821294340154722135594e-02
 	 1.48012388896020280482090925033845e-01 7.04630946772243804687718693458010e-01 1.46130722641734742822672288298236e-02
 	 7.04630995778554591879583313129842e-01 1.47356574993519673366648703449755e-01 1.46130732567871183397167911266479e-02
 	 4.24740426214290034412357499604695e-01 2.08953868767089018243510167849308e-01 1.70034828558818622290527144969019e-02
 	 2.08953731775949336224584840238094e-01 3.66305584744693935039805410269764e-01 1.70034876864141523689077928338520e-02
 	 3.66305807793043392006637759550358e-01 4.24740413497297630840421334141865e-01 1.70034756436661833867152182619975e-02
 	 4.51724222556604049216844032343943e-01 8.70333698449567150223771250239224e-02 1.71178294782583437227962974702677e-02
 	 8.70333625302085328589996038317622e-02 4.61242369666382878712340698257321e-01 1.71178274008436069608674046094166e-02
 	 4.61242460733382209081554492513533e-01 4.51724181218181475294670690345811e-01 1.71178283731215873098019386588931e-02
 	 2.88318499660714211429990427859593e-01 1.90229112412624801198290924730827e-01 1.99646339738734600322001000449745e-02
 	 1.90229156603659105284620522979822e-01 5.21452304852625614373096141207498e-01 1.99646409308296760021228521964076e-02
 	 5.21452426537516333659993961191503e-01 2.88318431951264997348260976650636e-01 1.99646334242829202876290395352044e-02
 	 ];
 
 	 case  17 

 	 % ALG. DEG.:   17
 	 % PTS CARD.:   57
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 5.8e-16  

 	 xyw=[
 	 1.47209661956265915744301864265253e-02 1.76399848555067323419009994722728e-02 1.68851800404976482711250085344545e-03
 	 1.76399848555067323419009994722728e-02 9.67639048948866653532263626402710e-01 1.68851800404976482711250085344545e-03
 	 9.67639048948866653532263626402710e-01 1.47209661956265915744301864265253e-02 1.68851800404976482711250085344545e-03
 	 7.58278723376997892957618319087487e-02 7.69747584377225568808000844001072e-03 1.90996283509696517834142159841804e-03
 	 7.69747584377225568808000844001072e-03 9.16474651818527941138370351836784e-01 1.90996283509696517834142159841804e-03
 	 9.16474651818527941138370351836784e-01 7.58278723376997892957618319087487e-02 1.90996283509696517834142159841804e-03
 	 3.10585516558464003189499180734856e-01 8.32009195104604741544118695628640e-03 3.31201304072067459829953328664942e-03
 	 8.32009195104604741544118695628640e-03 6.81094391490490003171487387589877e-01 3.31201304072067459829953328664942e-03
 	 6.81094391490490003171487387589877e-01 3.10585516558464003189499180734856e-01 3.31201304072067459829953328664942e-03
 	 1.44883146249404001770777483670827e-02 9.01640395800713256857505939478870e-02 3.64245036743674052356900538995887e-03
 	 9.01640395800713256857505939478870e-02 8.95347645794988267198277753777802e-01 3.64245036743674052356900538995887e-03
 	 8.95347645794988267198277753777802e-01 1.44883146249404001770777483670827e-02 3.64245036743674052356900538995887e-03
 	 1.78143852253019957521118499244039e-01 1.64238580465156137899729316131925e-02 4.98250123670270373549273656976766e-03
 	 1.64238580465156137899729316131925e-02 8.05432289700464432158355521096382e-01 4.98250123670270373549273656976766e-03
 	 8.05432289700464432158355521096382e-01 1.78143852253019957521118499244039e-01 4.98250123670270373549273656976766e-03
 	 4.66133550795934714638946161358035e-01 1.23355817687377852104324560400528e-02 5.13817254929797503915089862402965e-03
 	 1.23355817687377852104324560400528e-02 5.21530867435327394332489348016679e-01 5.13817254929797503915089862402965e-03
 	 5.21530867435327394332489348016679e-01 4.66133550795934714638946161358035e-01 5.13817254929797503915089862402965e-03
 	 1.47365661662822756972079929482788e-02 2.09325171157457634585341565980343e-01 5.15474565188859049080782881446794e-03
 	 2.09325171157457634585341565980343e-01 7.75938262676260093186897393024992e-01 5.15474565188859049080782881446794e-03
 	 7.75938262676260093186897393024992e-01 1.47365661662822756972079929482788e-02 5.15474565188859049080782881446794e-03
 	 1.43325355478803179165581127563200e-02 3.58602315795423676192399398132693e-01 5.80111456840011127655820644122286e-03
 	 3.58602315795423676192399398132693e-01 6.27065148656696047524405912554357e-01 5.80111456840011127655820644122286e-03
 	 6.27065148656696047524405912554357e-01 1.43325355478803179165581127563200e-02 5.80111456840011127655820644122286e-03
 	 7.53033493906421630414982359980058e-02 5.59681329947420772019661683316372e-02 6.23487189374104591732539404347335e-03
 	 5.59681329947420772019661683316372e-02 8.68728517614615669550914844876388e-01 6.23487189374104591732539404347335e-03
 	 8.68728517614615669550914844876388e-01 7.53033493906421630414982359980058e-02 6.23487189374104591732539404347335e-03
 	 3.17339393501727851099047938987496e-01 5.16948784187994947458832939446438e-02 9.81623975776597587628025110007002e-03
 	 5.16948784187994947458832939446438e-02 6.30965728079472598643917535810033e-01 9.81623975776597587628025110007002e-03
 	 6.30965728079472598643917535810033e-01 3.17339393501727851099047938987496e-01 9.81623975776597587628025110007002e-03
 	 7.53542654903545661149166789982701e-02 1.54598211665730095321080739267927e-01 1.00507535375725948895153649687018e-02
 	 1.54598211665730095321080739267927e-01 7.70047522843915421830729428620543e-01 1.00507535375725948895153649687018e-02
 	 7.70047522843915421830729428620543e-01 7.53542654903545661149166789982701e-02 1.00507535375725948895153649687018e-02
 	 1.82570774440876770761121861141874e-01 2.66530059635146754359880105766933e-01 1.04530227842825687578631743690494e-02
 	 2.66530059635146754359880105766933e-01 5.50899165923976474878998033091193e-01 1.04530227842825687578631743690494e-02
 	 5.50899165923976474878998033091193e-01 1.82570774440876770761121861141874e-01 1.04530227842825687578631743690494e-02
 	 1.79710032722074752875585090805544e-01 8.15862277549058850789620578325412e-02 1.06661238358018613248123784842392e-02
 	 8.15862277549058850789620578325412e-02 7.38703739523019375923240659176372e-01 1.06661238358018613248123784842392e-02
 	 7.38703739523019375923240659176372e-01 1.79710032722074752875585090805544e-01 1.06661238358018613248123784842392e-02
 	 1.75807941715677179539412122721842e-01 1.80353640520785951650850620353594e-01 1.18746885945923402044810401889663e-02
 	 1.80353640520785951650850620353594e-01 6.43838417763536896565312872553477e-01 1.18746885945923402044810401889663e-02
 	 6.43838417763536896565312872553477e-01 1.75807941715677179539412122721842e-01 1.18746885945923402044810401889663e-02
 	 4.58731499688783517232337771929451e-01 4.74126007719326725275976741613704e-01 1.23885120040660139800747785443491e-02
 	 4.74126007719326725275976741613704e-01 6.71424925918898130028367177146720e-02 1.23885120040660139800747785443491e-02
 	 6.71424925918898130028367177146720e-02 4.58731499688783517232337771929451e-01 1.23885120040660139800747785443491e-02
 	 7.53196920743743475457065983391658e-02 2.93754105362967754544456511212047e-01 1.27927851211363120126351944350063e-02
 	 2.93754105362967754544456511212047e-01 6.30926202562657856276473467005417e-01 1.27927851211363120126351944350063e-02
 	 6.30926202562657856276473467005417e-01 7.53196920743743475457065983391658e-02 1.27927851211363120126351944350063e-02
 	 1.63305177925384792381180432130350e-01 3.84251187765941693008642232598504e-01 1.56554294016505793352145303742873e-02
 	 3.84251187765941693008642232598504e-01 4.52443634308673514610177335271146e-01 1.56554294016505793352145303742873e-02
 	 4.52443634308673514610177335271146e-01 1.63305177925384792381180432130350e-01 1.56554294016505793352145303742873e-02
 	 3.11813568699614629409211374877486e-01 1.39501525996608172208723885887593e-01 1.57951812747187600449727540308231e-02
 	 1.39501525996608172208723885887593e-01 5.48684905303777226137640354863834e-01 1.57951812747187600449727540308231e-02
 	 5.48684905303777226137640354863834e-01 3.11813568699614629409211374877486e-01 1.57951812747187600449727540308231e-02
 	 3.06048259112027931649890888365917e-01 2.67720653545962083974529832630651e-01 1.93095802077451229872284699240481e-02
 	 2.67720653545962083974529832630651e-01 4.26231087342009984375579279003432e-01 1.93095802077451229872284699240481e-02
 	 4.26231087342009984375579279003432e-01 3.06048259112027931649890888365917e-01 1.93095802077451229872284699240481e-02
 	 ];
 
 	 case  18 

 	 % ALG. DEG.:   18
 	 % PTS CARD.:   66
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.1e-16  

 	 xyw=[
 	 3.69780964055097839671137904815623e-03 7.43579235081241601834634025181003e-02 1.31889556344126353086554370719341e-03
 	 7.43579235081241601834634025181003e-02 9.21944266851324800704503559245495e-01 1.31889556344126353086554370719341e-03
 	 9.21944266851324800704503559245495e-01 3.69780964055097839671137904815623e-03 1.31889556344126353086554370719341e-03
 	 1.49143992279988854554595434365183e-02 1.36909130733626482889775388684939e-02 1.33745332549837559789340790672441e-03
 	 1.36909130733626482889775388684939e-02 9.71394687698638459316669013787759e-01 1.33745332549837559789340790672441e-03
 	 9.71394687698638459316669013787759e-01 1.49143992279988854554595434365183e-02 1.33745332549837559789340790672441e-03
 	 1.69739996219302907189130369403074e-03 2.08913690615461083988080304152390e-01 1.59651913688176050332145905485959e-03
 	 2.08913690615461083988080304152390e-01 7.89388909422345963484701769630192e-01 1.59651913688176050332145905485959e-03
 	 7.89388909422345963484701769630192e-01 1.69739996219302907189130369403074e-03 1.59651913688176050332145905485959e-03
 	 8.06620839466252737004481332405703e-02 8.24353269029142778079322084749947e-03 2.08534921880513396397205383436813e-03
 	 8.24353269029142778079322084749947e-03 9.11094383363083348825739449239336e-01 2.08534921880513396397205383436813e-03
 	 9.11094383363083348825739449239336e-01 8.06620839466252737004481332405703e-02 2.08534921880513396397205383436813e-03
 	 1.98747901402310800378359090245795e-01 6.97659509618316596435416698795962e-03 2.62960161883945544789020765108489e-03
 	 6.97659509618316596435416698795962e-03 7.94275503501505997228093747253297e-01 2.62960161883945544789020765108489e-03
 	 7.94275503501505997228093747253297e-01 1.98747901402310800378359090245795e-01 2.62960161883945544789020765108489e-03
 	 3.46702719147276405831092915832414e-01 9.05977135347985074176335729134735e-03 3.59422250399369291526396885672057e-03
 	 9.05977135347985074176335729134735e-03 6.44237509499243632404841264360584e-01 3.59422250399369291526396885672057e-03
 	 6.44237509499243632404841264360584e-01 3.46702719147276405831092915832414e-01 3.59422250399369291526396885672057e-03
 	 4.86346333871042757479585816327017e-02 5.57910529717466976973305747833365e-02 4.47939134603269999146402113865406e-03
 	 5.57910529717466976973305747833365e-02 8.95574313641149033493604747491190e-01 4.47939134603269999146402113865406e-03
 	 8.95574313641149033493604747491190e-01 4.86346333871042757479585816327017e-02 4.47939134603269999146402113865406e-03
 	 1.28318629849446304985738365189718e-02 3.44692548477970428510985811954015e-01 4.62436269356279738840242998776375e-03
 	 3.44692548477970428510985811954015e-01 6.42475588537084973950186395086348e-01 4.62436269356279738840242998776375e-03
 	 6.42475588537084973950186395086348e-01 1.28318629849446304985738365189718e-02 4.62436269356279738840242998776375e-03
 	 2.93595389942205159394816860185529e-02 1.39964110318391732334930566139519e-01 5.03712312424570499147513658044772e-03
 	 1.39964110318391732334930566139519e-01 8.30676350687387765603375555656385e-01 5.03712312424570499147513658044772e-03
 	 8.30676350687387765603375555656385e-01 2.93595389942205159394816860185529e-02 5.03712312424570499147513658044772e-03
 	 4.90788394693759288944789886954823e-01 4.95822517789664629628276770745288e-01 5.11503744322468461430686303970106e-03
 	 4.95822517789664629628276770745288e-01 1.33890875165761369380845735577168e-02 5.11503744322468461430686303970106e-03
 	 1.33890875165761369380845735577168e-02 4.90788394693759288944789886954823e-01 5.11503744322468461430686303970106e-03
 	 1.38618784059788779927657742518932e-01 4.47076793855018736478790231103631e-02 6.36860809368266795466029250860629e-03
 	 4.47076793855018736478790231103631e-02 8.16673536554709311729993714834563e-01 6.36860809368266795466029250860629e-03
 	 8.16673536554709311729993714834563e-01 1.38618784059788779927657742518932e-01 6.36860809368266795466029250860629e-03
 	 2.63897606352200997381629576921114e-01 4.36720952517550692340009277359059e-02 7.06349077572058971913326885783135e-03
 	 4.36720952517550692340009277359059e-02 6.92430298396043975017732918786351e-01 7.06349077572058971913326885783135e-03
 	 6.92430298396043975017732918786351e-01 2.63897606352200997381629576921114e-01 7.06349077572058971913326885783135e-03
 	 4.55911744930610901560541492472112e-02 2.45218573506195719469147320523916e-01 7.66638720777674306100513135220353e-03
 	 2.45218573506195719469147320523916e-01 7.09190252000743259763737569301156e-01 7.66638720777674306100513135220353e-03
 	 7.09190252000743259763737569301156e-01 4.55911744930610901560541492472112e-02 7.66638720777674306100513135220353e-03
 	 3.94010358537068061668406926401076e-01 5.92769337816446834077410699137545e-02 9.57549415223419089771006440514611e-03
 	 5.92769337816446834077410699137545e-02 5.46712707681287324312791042757453e-01 9.57549415223419089771006440514611e-03
 	 5.46712707681287324312791042757453e-01 3.94010358537068061668406926401076e-01 9.57549415223419089771006440514611e-03
 	 1.06867206940964756811673908032390e-01 1.28325526947980300684903909314016e-01 9.79068792555368855312636355847644e-03
 	 1.28325526947980300684903909314016e-01 7.64807266111054984136785606096964e-01 9.79068792555368855312636355847644e-03
 	 7.64807266111054984136785606096964e-01 1.06867206940964756811673908032390e-01 9.79068792555368855312636355847644e-03
 	 2.20575279425483411488428941993334e-01 1.13275821301684689879074596774444e-01 1.12596074363941634627339638541343e-02
 	 1.13275821301684689879074596774444e-01 6.66148899272831940265859884675592e-01 1.12596074363941634627339638541343e-02
 	 6.66148899272831940265859884675592e-01 2.20575279425483411488428941993334e-01 1.12596074363941634627339638541343e-02
 	 1.23653835041298731933778753955266e-01 2.42720437216092432830549796562991e-01 1.18720440268093602870225211631805e-02
 	 2.42720437216092432830549796562991e-01 6.33625727742608724213368986966088e-01 1.18720440268093602870225211631805e-02
 	 6.33625727742608724213368986966088e-01 1.23653835041298731933778753955266e-01 1.18720440268093602870225211631805e-02
 	 7.13348794100979594068334677103849e-02 3.87908478942486534268851983142667e-01 1.22562901173755151029709509202803e-02
 	 3.87908478942486534268851983142667e-01 5.40756641647415436935375510074664e-01 1.22562901173755151029709509202803e-02
 	 5.40756641647415436935375510074664e-01 7.13348794100979594068334677103849e-02 1.22562901173755151029709509202803e-02
 	 2.24126910324971617693989855979453e-01 2.13289800009618973897218552338018e-01 1.23407368011343963887238572851857e-02
 	 2.13289800009618973897218552338018e-01 5.62583289665409380653215976053616e-01 1.23407368011343963887238572851857e-02
 	 5.62583289665409380653215976053616e-01 2.24126910324971617693989855979453e-01 1.23407368011343963887238572851857e-02
 	 3.51619049955642692939505877802731e-01 1.37937509976456512683640198702051e-01 1.34838314599763416795630277533746e-02
 	 1.37937509976456512683640198702051e-01 5.10443440067900877643580770381959e-01 1.34838314599763416795630277533746e-02
 	 5.10443440067900877643580770381959e-01 3.51619049955642692939505877802731e-01 1.34838314599763416795630277533746e-02
 	 3.60762340567732431306779972146614e-01 4.65125819964767317493681275664130e-01 1.61731054368957315181543066273662e-02
 	 4.65125819964767317493681275664130e-01 1.74111839467500195688387520931428e-01 1.61731054368957315181543066273662e-02
 	 1.74111839467500195688387520931428e-01 3.60762340567732431306779972146614e-01 1.61731054368957315181543066273662e-02
 	 3.11300128982519408449292086515925e-01 2.70073629388671410112010562443174e-01 1.69984272585877484174066154309912e-02
 	 2.70073629388671410112010562443174e-01 4.18626241628809125927546119783074e-01 1.69984272585877484174066154309912e-02
 	 4.18626241628809125927546119783074e-01 3.11300128982519408449292086515925e-01 1.69984272585877484174066154309912e-02
 	 ];
 
 	 case  19 

 	 % ALG. DEG.:   19
 	 % PTS CARD.:   70
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.2e-16  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.52314808800737087196575103575924e-02
 	 1.03766565457017543444573348665472e-02 1.44810472658998996842161233189472e-02 9.75090979032849436772267814887982e-04
 	 1.44810472658998996842161233189472e-02 9.75142296188398316481027450208785e-01 9.75090979032849436772267814887982e-04
 	 9.75142296188398316481027450208785e-01 1.03766565457017543444573348665472e-02 9.75090979032849436772267814887982e-04
 	 5.28956402129591926608576102353254e-02 8.92711734256453406932685368246894e-03 1.38097230858658754845680327605351e-03
 	 8.92711734256453406932685368246894e-03 9.38177242444476200411429545056308e-01 1.38097230858658754845680327605351e-03
 	 9.38177242444476200411429545056308e-01 5.28956402129591926608576102353254e-02 1.38097230858658754845680327605351e-03
 	 1.30940571465279348428722983044281e-01 6.39606356170804597055523643689412e-03 1.76658971586647118613699891653823e-03
 	 6.39606356170804597055523643689412e-03 8.62663364973012547487485335295787e-01 1.76658971586647118613699891653823e-03
 	 8.62663364973012547487485335295787e-01 1.30940571465279348428722983044281e-01 1.76658971586647118613699891653823e-03
 	 1.26681865510903015475951960411294e-02 7.29082350599041251193455082102446e-02 2.57601453884506942718091160315907e-03
 	 7.29082350599041251193455082102446e-02 9.14423578389005564659441915864591e-01 2.57601453884506942718091160315907e-03
 	 9.14423578389005564659441915864591e-01 1.26681865510903015475951960411294e-02 2.57601453884506942718091160315907e-03
 	 2.46613960104767354630794784497994e-01 1.13210284482716614512520791890893e-02 3.65585508313527205934145847265881e-03
 	 1.13210284482716614512520791890893e-02 7.42065011446961020347146131825866e-01 3.65585508313527205934145847265881e-03
 	 7.42065011446961020347146131825866e-01 2.46613960104767354630794784497994e-01 3.65585508313527205934145847265881e-03
 	 1.24330000962839457012698574089882e-02 1.71507203857275219993638870619179e-01 3.69473652588097082813400895417999e-03
 	 1.71507203857275219993638870619179e-01 8.16059796046440855121772983693518e-01 3.69473652588097082813400895417999e-03
 	 8.16059796046440855121772983693518e-01 1.24330000962839457012698574089882e-02 3.69473652588097082813400895417999e-03
 	 9.45870867926038548512135406554080e-03 4.54553083656948797575125809089513e-01 3.77389302633806883111033947386659e-03
 	 4.54553083656948797575125809089513e-01 5.35988207663790849899498880404280e-01 3.77389302633806883111033947386659e-03
 	 5.35988207663790849899498880404280e-01 9.45870867926038548512135406554080e-03 3.77389302633806883111033947386659e-03
 	 3.82677127432900721082376094273059e-01 1.03041271596045185682255507231275e-02 3.80773420333801061038458968255327e-03
 	 1.03041271596045185682255507231275e-02 6.07018745407494786370250494655920e-01 3.80773420333801061038458968255327e-03
 	 6.07018745407494786370250494655920e-01 3.82677127432900721082376094273059e-01 3.80773420333801061038458968255327e-03
 	 1.07221902311333636831358617769183e-02 3.02819418977863463737776328343898e-01 3.95037906656455200388178283787965e-03
 	 3.02819418977863463737776328343898e-01 6.86458390791003125741553958505392e-01 3.95037906656455200388178283787965e-03
 	 6.86458390791003125741553958505392e-01 1.07221902311333636831358617769183e-02 3.95037906656455200388178283787965e-03
 	 6.34588872173355300621011565453955e-02 4.79826825588268238154121547722752e-02 4.10521976646200867366864883933886e-03
 	 4.79826825588268238154121547722752e-02 8.88558430223837625305804976960644e-01 4.10521976646200867366864883933886e-03
 	 8.88558430223837625305804976960644e-01 6.34588872173355300621011565453955e-02 4.10521976646200867366864883933886e-03
 	 1.49585341667801352549815874226624e-01 4.15353642843105178017459877537476e-02 5.31583329040207202415002640805142e-03
 	 4.15353642843105178017459877537476e-02 8.08879294047888164342907657555770e-01 5.31583329040207202415002640805142e-03
 	 8.08879294047888164342907657555770e-01 1.49585341667801352549815874226624e-01 5.31583329040207202415002640805142e-03
 	 6.59383749931683749156974272409570e-02 1.27098301306499766871738188456220e-01 7.25903156102605112698356037981284e-03
 	 1.27098301306499766871738188456220e-01 8.06963323700331858212564384302823e-01 7.25903156102605112698356037981284e-03
 	 8.06963323700331858212564384302823e-01 6.59383749931683749156974272409570e-02 7.25903156102605112698356037981284e-03
 	 4.19360344474693613747717790829483e-01 4.84133944843579896999408163082990e-02 7.34705686595597384086486769660951e-03
 	 4.84133944843579896999408163082990e-02 5.32226261040948389613447488954989e-01 7.34705686595597384086486769660951e-03
 	 5.32226261040948389613447488954989e-01 4.19360344474693613747717790829483e-01 7.34705686595597384086486769660951e-03
 	 5.12859715627437540153010786525556e-02 3.85451519447595591927324676362332e-01 8.43495559667827368710568691767548e-03
 	 3.85451519447595591927324676362332e-01 5.63262508989660681812949860614026e-01 8.43495559667827368710568691767548e-03
 	 5.63262508989660681812949860614026e-01 5.12859715627437540153010786525556e-02 8.43495559667827368710568691767548e-03
 	 5.92161717125940026407171501432458e-02 2.44263378740914083309121451748069e-01 8.60958476231886947471760862526935e-03
 	 2.44263378740914083309121451748069e-01 6.96520449546491948744630917644827e-01 8.60958476231886947471760862526935e-03
 	 6.96520449546491948744630917644827e-01 5.92161717125940026407171501432458e-02 8.60958476231886947471760862526935e-03
 	 1.57744353652534891052638954533904e-01 1.07039102999093777013328576686035e-01 8.74583707273539692761410435650760e-03
 	 1.07039102999093777013328576686035e-01 7.35216543348371276422881237522233e-01 8.74583707273539692761410435650760e-03
 	 7.35216543348371276422881237522233e-01 1.57744353652534891052638954533904e-01 8.74583707273539692761410435650760e-03
 	 2.76356371451293159058337778333225e-01 5.93958296507460237201314612320857e-02 9.14573890014911371204586743033360e-03
 	 5.93958296507460237201314612320857e-02 6.64247798897960928243833222950343e-01 9.14573890014911371204586743033360e-03
 	 6.64247798897960928243833222950343e-01 2.76356371451293159058337778333225e-01 9.14573890014911371204586743033360e-03
 	 4.02925432504102898345621497355751e-01 1.11259697463848866716418228861585e-01 1.05446777512285729677676826554489e-02
 	 1.11259697463848866716418228861585e-01 4.85814870032048151671233426895924e-01 1.05446777512285729677676826554489e-02
 	 4.85814870032048151671233426895924e-01 4.02925432504102898345621497355751e-01 1.05446777512285729677676826554489e-02
 	 1.44741209510670071347604448419588e-01 2.07337086661877140203458225187205e-01 1.15145856655313790634087567354982e-02
 	 2.07337086661877140203458225187205e-01 6.47921703827452843960088557651034e-01 1.15145856655313790634087567354982e-02
 	 6.47921703827452843960088557651034e-01 1.44741209510670071347604448419588e-01 1.15145856655313790634087567354982e-02
 	 1.28002196170715176748444719123654e-01 3.38803971814336801759992567895097e-01 1.24670942256624363991823756236954e-02
 	 3.38803971814336801759992567895097e-01 5.33193832014948077002713944239076e-01 1.24670942256624363991823756236954e-02
 	 5.33193832014948077002713944239076e-01 1.28002196170715176748444719123654e-01 1.24670942256624363991823756236954e-02
 	 2.67334020957130047424499252883834e-01 1.47872285803578001894820204142889e-01 1.29780674745516941964718071744755e-02
 	 1.47872285803578001894820204142889e-01 5.84793693239291978436256158602191e-01 1.29780674745516941964718071744755e-02
 	 5.84793693239291978436256158602191e-01 2.67334020957130047424499252883834e-01 1.29780674745516941964718071744755e-02
 	 3.80640391337433547924717913701897e-01 2.07421341282564897223750222110539e-01 1.44577581531146661525388807945092e-02
 	 2.07421341282564897223750222110539e-01 4.11938267380001554851531864187564e-01 1.44577581531146661525388807945092e-02
 	 4.11938267380001554851531864187564e-01 3.80640391337433547924717913701897e-01 1.44577581531146661525388807945092e-02
 	 2.41019074102765712419582655456907e-01 2.67083117991290863724174187154858e-01 1.50827998399043674421227123616518e-02
 	 2.67083117991290863724174187154858e-01 4.91897807905943451611818773017148e-01 1.50827998399043674421227123616518e-02
 	 4.91897807905943451611818773017148e-01 2.41019074102765712419582655456907e-01 1.50827998399043674421227123616518e-02
 	 ];
 
 	 case  20 

 	 % ALG. DEG.:   20
 	 % PTS CARD.:   78
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.9e-16  

 	 xyw=[
 	 7.90368134162346309967706048382752e-03 1.08926176663298908409149845510910e-02 5.69495307448751944545684011700359e-04
 	 1.08926176663298908409149845510910e-02 9.81203700992046679019153998524416e-01 5.69495307448751944545684011700359e-04
 	 9.81203700992046679019153998524416e-01 7.90368134162346309967706048382752e-03 5.69495307448751944545684011700359e-04
 	 3.70261421404957180927852711249670e-03 5.68359139419127579184731757777627e-02 7.67883543729124679044772960878618e-04
 	 5.68359139419127579184731757777627e-02 9.39461471844037609990607506915694e-01 7.67883543729124679044772960878618e-04
 	 9.39461471844037609990607506915694e-01 3.70261421404957180927852711249670e-03 7.67883543729124679044772960878618e-04
 	 1.09337390150228475071969569398789e-01 3.03859257334367343500458602534309e-03 9.62342795893268102697115651267268e-04
 	 3.03859257334367343500458602534309e-03 8.87624017276427812461747635097709e-01 9.62342795893268102697115651267268e-04
 	 8.87624017276427812461747635097709e-01 1.09337390150228475071969569398789e-01 9.62342795893268102697115651267268e-04
 	 4.28810753769432936866046190971247e-02 9.80505702549880342466792626510141e-03 1.25021865617795701133840857721680e-03
 	 9.80505702549880342466792626510141e-03 9.47313867597557868194257935101632e-01 1.25021865617795701133840857721680e-03
 	 9.47313867597557868194257935101632e-01 4.28810753769432936866046190971247e-02 1.25021865617795701133840857721680e-03
 	 1.77473257307326614390374786012217e-03 2.36693018982774450176265190748381e-01 1.31537561809383081283530980698515e-03
 	 2.36693018982774450176265190748381e-01 7.61532248444152237709658948006108e-01 1.31537561809383081283530980698515e-03
 	 7.61532248444152237709658948006108e-01 1.77473257307326614390374786012217e-03 1.31537561809383081283530980698515e-03
 	 3.11814570601137097671795572750852e-01 2.54551979563882565041343930545281e-03 1.59781280701407611168074485163970e-03
 	 2.54551979563882565041343930545281e-03 6.85639909603224184664327367499936e-01 1.59781280701407611168074485163970e-03
 	 6.85639909603224184664327367499936e-01 3.11814570601137097671795572750852e-01 1.59781280701407611168074485163970e-03
 	 2.99000660469557651144345555849213e-03 4.63119441155936895082589899175218e-01 1.82588449703942291499347838623635e-03
 	 4.63119441155936895082589899175218e-01 5.33890552239367544018477929057553e-01 1.82588449703942291499347838623635e-03
 	 5.33890552239367544018477929057553e-01 2.99000660469557651144345555849213e-03 1.82588449703942291499347838623635e-03
 	 3.22142321349414423314883038074186e-02 5.24854182546855979607514086637821e-02 2.66226894560845240428337277194260e-03
 	 5.24854182546855979607514086637821e-02 9.15300349610372987463335903157713e-01 2.66226894560845240428337277194260e-03
 	 9.15300349610372987463335903157713e-01 3.22142321349414423314883038074186e-02 2.66226894560845240428337277194260e-03
 	 1.27799603324881029531301379620345e-02 1.31379538178000160320024747306888e-01 2.92222801419447005683016627131110e-03
 	 1.31379538178000160320024747306888e-01 8.55840501489511740196292066684691e-01 2.92222801419447005683016627131110e-03
 	 8.55840501489511740196292066684691e-01 1.27799603324881029531301379620345e-02 2.92222801419447005683016627131110e-03
 	 1.95430723381915305569833662957535e-01 1.40953400791673909980827872345799e-02 3.65400299007099822051758408747446e-03
 	 1.40953400791673909980827872345799e-02 7.90473936538917398841874728532275e-01 3.65400299007099822051758408747446e-03
 	 7.90473936538917398841874728532275e-01 1.95430723381915305569833662957535e-01 3.65400299007099822051758408747446e-03
 	 9.77669169905016482990944837183633e-02 3.50007516628948259218567784500920e-02 3.95316767664596370457363860850819e-03
 	 3.50007516628948259218567784500920e-02 8.67232331346603491084579218295403e-01 3.95316767664596370457363860850819e-03
 	 8.67232331346603491084579218295403e-01 9.77669169905016482990944837183633e-02 3.95316767664596370457363860850819e-03
 	 1.66006628441778165961029145591965e-02 3.38676752265837932576175717258593e-01 4.82797893544456221959215724837122e-03
 	 3.38676752265837932576175717258593e-01 6.44722584889984240419380512321368e-01 4.82797893544456221959215724837122e-03
 	 6.44722584889984240419380512321368e-01 1.66006628441778165961029145591965e-02 4.82797893544456221959215724837122e-03
 	 4.13395082180740003341412602821947e-01 1.82025878269482105364929225288506e-02 5.15729450192981084960530679950352e-03
 	 1.82025878269482105364929225288506e-02 5.68402329992311883266609129350400e-01 5.15729450192981084960530679950352e-03
 	 5.68402329992311883266609129350400e-01 4.13395082180740003341412602821947e-01 5.15729450192981084960530679950352e-03
 	 6.83293746341590430004586664836097e-02 1.08675089954566678196457019112131e-01 6.10491927213127442974904823813631e-03
 	 1.08675089954566678196457019112131e-01 8.22995535411274348192023353476543e-01 6.10491927213127442974904823813631e-03
 	 8.22995535411274348192023353476543e-01 6.83293746341590430004586664836097e-02 6.10491927213127442974904823813631e-03
 	 3.92153078432324539437381361040025e-02 2.14338430054550499459509182997863e-01 6.41934116104962010362910973526596e-03
 	 2.14338430054550499459509182997863e-01 7.46446262102216984146707545733079e-01 6.41934116104962010362910973526596e-03
 	 7.46446262102216984146707545733079e-01 3.92153078432324539437381361040025e-02 6.41934116104962010362910973526596e-03
 	 2.82851404387685689822973245100002e-01 4.32505997246091511421184350183466e-02 7.33339884886187540896651526622918e-03
 	 4.32505997246091511421184350183466e-02 6.73897995887705159034908319881652e-01 7.33339884886187540896651526622918e-03
 	 6.73897995887705159034908319881652e-01 2.82851404387685689822973245100002e-01 7.33339884886187540896651526622918e-03
 	 1.63149078355705329235192380110675e-01 7.46324203435316663179932561433816e-02 7.70252693118283777301558146177740e-03
 	 7.46324203435316663179932561433816e-02 7.62218501300762962813450940302573e-01 7.70252693118283777301558146177740e-03
 	 7.62218501300762962813450940302573e-01 1.63149078355705329235192380110675e-01 7.70252693118283777301558146177740e-03
 	 4.36290583906621953769189303784515e-01 5.16537077780689246608858411491383e-01 8.28779693743914719350485142967955e-03
 	 5.16537077780689246608858411491383e-01 4.71723383126887441108010534662753e-02 8.28779693743914719350485142967955e-03
 	 4.71723383126887441108010534662753e-02 4.36290583906621953769189303784515e-01 8.28779693743914719350485142967955e-03
 	 1.23069087330845969296966302408691e-01 1.73946464302243086752497447378119e-01 9.99461019059759599170167376769314e-03
 	 1.73946464302243086752497447378119e-01 7.02984448366910985583899673656560e-01 9.99461019059759599170167376769314e-03
 	 7.02984448366910985583899673656560e-01 1.23069087330845969296966302408691e-01 9.99461019059759599170167376769314e-03
 	 8.32579050810742932187125120435667e-02 2.99185227797303610053347711073002e-01 1.01487087387537137928017472177089e-02
 	 2.99185227797303610053347711073002e-01 6.17556867121622055094576353440061e-01 1.01487087387537137928017472177089e-02
 	 6.17556867121622055094576353440061e-01 8.32579050810742932187125120435667e-02 1.01487087387537137928017472177089e-02
 	 3.76028943583988584098420915324823e-01 8.64379444693639392705009072415123e-02 1.08183452528902452477455042867405e-02
 	 8.64379444693639392705009072415123e-02 5.37533111946647546020017216505948e-01 1.08183452528902452477455042867405e-02
 	 5.37533111946647546020017216505948e-01 3.76028943583988584098420915324823e-01 1.08183452528902452477455042867405e-02
 	 2.39866290944955318220621620639577e-01 1.30115610897138883617074611720454e-01 1.15127386814758876643072227352604e-02
 	 1.30115610897138883617074611720454e-01 6.30018098157905770406728152011055e-01 1.15127386814758876643072227352604e-02
 	 6.30018098157905770406728152011055e-01 2.39866290944955318220621620639577e-01 1.15127386814758876643072227352604e-02
 	 1.37221148823993804866105961082212e-01 3.91013201302957691396500194969121e-01 1.31617468738862725824434463106627e-02
 	 3.91013201302957691396500194969121e-01 4.71765649873048475981818228319753e-01 1.31617468738862725824434463106627e-02
 	 4.71765649873048475981818228319753e-01 1.37221148823993804866105961082212e-01 1.31617468738862725824434463106627e-02
 	 1.89932130608380905778531655414554e-01 2.50321346008893164114539331421838e-01 1.35240488135174967421203717776734e-02
 	 2.50321346008893164114539331421838e-01 5.59746523382725902351353397534695e-01 1.35240488135174967421203717776734e-02
 	 5.59746523382725902351353397534695e-01 1.89932130608380905778531655414554e-01 1.35240488135174967421203717776734e-02
 	 3.24158256395638832980665711147594e-01 1.94724488881111906790621901564009e-01 1.44971698648032557704690148625559e-02
 	 1.94724488881111906790621901564009e-01 4.81117254723249176961985540401656e-01 1.44971698648032557704690148625559e-02
 	 4.81117254723249176961985540401656e-01 3.24158256395638832980665711147594e-01 1.44971698648032557704690148625559e-02
 	 3.30862912147051713152023921793443e-01 4.07445324376853323933289630076615e-01 1.56953608107867174925598163781615e-02
 	 4.07445324376853323933289630076615e-01 2.61691763476095018425837679387769e-01 1.56953608107867174925598163781615e-02
 	 2.61691763476095018425837679387769e-01 3.30862912147051713152023921793443e-01 1.56953608107867174925598163781615e-02
 	 ];
 
 	 case  21 

 	 % ALG. DEG.:   21
 	 % PTS CARD.:   85
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.6e-16  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 7.96362196085264456568708624217834e-03
 	 1.08833811258291848766965870254353e-02 1.08437360200908869400926448633982e-02 7.70012405206899541373899431562222e-04
 	 1.08437360200908869400926448633982e-02 9.78272882854079872672059536853340e-01 7.70012405206899541373899431562222e-04
 	 9.78272882854079872672059536853340e-01 1.08833811258291848766965870254353e-02 7.70012405206899541373899431562222e-04
 	 1.34483082013301280532857617799891e-01 5.89401791446114188544047607365428e-03 1.48201910561772138424929678990338e-03
 	 5.89401791446114188544047607365428e-03 8.59622900072237627888682709453860e-01 1.48201910561772138424929678990338e-03
 	 8.59622900072237627888682709453860e-01 1.34483082013301280532857617799891e-01 1.48201910561772138424929678990338e-03
 	 5.60697914456082802114877949861693e-02 9.34072029515549240308303069468820e-01 1.57128523968988551701153610906658e-03
 	 9.34072029515549240308303069468820e-01 9.85817903884245172463351991609670e-03 1.57128523968988551701153610906658e-03
 	 9.85817903884245172463351991609670e-03 5.60697914456082802114877949861693e-02 1.57128523968988551701153610906658e-03
 	 5.62307971638516188028766862316843e-02 1.04111689007461219458328116616030e-02 1.66127886475559132656298899632930e-03
 	 1.04111689007461219458328116616030e-02 9.33358033935402287006866117735626e-01 1.66127886475559132656298899632930e-03
 	 9.33358033935402287006866117735626e-01 5.62307971638516188028766862316843e-02 1.66127886475559132656298899632930e-03
 	 4.95492250545260581873208138858899e-01 5.30139353929082006444684083135144e-03 2.03547106383759847034187195902177e-03
 	 5.30139353929082006444684083135144e-03 4.99206355915448596327621544332942e-01 2.03547106383759847034187195902177e-03
 	 4.99206355915448596327621544332942e-01 4.95492250545260581873208138858899e-01 2.03547106383759847034187195902177e-03
 	 1.33413544221436503045552512958238e-01 8.56502202113258115367955269903177e-01 2.35329019457066780651732784690466e-03
 	 8.56502202113258115367955269903177e-01 1.00842536653054093420678327674977e-02 2.35329019457066780651732784690466e-03
 	 1.00842536653054093420678327674977e-02 1.33413544221436503045552512958238e-01 2.35329019457066780651732784690466e-03
 	 2.37788853273795369736021143580729e-01 7.53553830034851435115683671028819e-01 2.59294011981360756138870193865387e-03
 	 7.53553830034851435115683671028819e-01 8.65731669135316739271956976153888e-03 2.59294011981360756138870193865387e-03
 	 8.65731669135316739271956976153888e-03 2.37788853273795369736021143580729e-01 2.59294011981360756138870193865387e-03
 	 2.36675822687569759050774109709891e-01 1.04315998683223633974881394692602e-02 3.02658613647318426240206967747781e-03
 	 1.04315998683223633974881394692602e-02 7.52892577444107868878120370936813e-01 3.02658613647318426240206967747781e-03
 	 7.52892577444107868878120370936813e-01 2.36675822687569759050774109709891e-01 3.02658613647318426240206967747781e-03
 	 3.59237431543587948379325780479121e-01 9.77441311908519919193771841037233e-03 3.24868657739030199799179499109414e-03
 	 9.77441311908519919193771841037233e-03 6.30988155337326772631456606177380e-01 3.24868657739030199799179499109414e-03
 	 6.30988155337326772631456606177380e-01 3.59237431543587948379325780479121e-01 3.24868657739030199799179499109414e-03
 	 3.62123795542131587943401882512262e-01 6.27482731394552795123331634385977e-01 3.48666208271716836566977981703985e-03
 	 6.27482731394552795123331634385977e-01 1.03934730633156169332664831017610e-02 3.48666208271716836566977981703985e-03
 	 1.03934730633156169332664831017610e-02 3.62123795542131587943401882512262e-01 3.48666208271716836566977981703985e-03
 	 5.47064625266307918982633395899029e-02 8.93376258603483019982149926363491e-01 3.60293779467318669648689954954079e-03
 	 8.93376258603483019982149926363491e-01 5.19172788698861742417989262321498e-02 3.60293779467318669648689954954079e-03
 	 5.19172788698861742417989262321498e-02 5.47064625266307918982633395899029e-02 3.60293779467318669648689954954079e-03
 	 1.28497845564646773208750119010801e-01 3.68128421478705475378134792663332e-02 4.18250641443536613078846286839507e-03
 	 3.68128421478705475378134792663332e-02 8.34689312287482665375648593908409e-01 4.18250641443536613078846286839507e-03
 	 8.34689312287482665375648593908409e-01 1.28497845564646773208750119010801e-01 4.18250641443536613078846286839507e-03
 	 1.32045621485988418086776619020384e-01 8.16750542291406311790069594280794e-01 5.11329816841889044087832161267215e-03
 	 8.16750542291406311790069594280794e-01 5.12038362226052701231537866988219e-02 5.11329816841889044087832161267215e-03
 	 5.12038362226052701231537866988219e-02 1.32045621485988418086776619020384e-01 5.11329816841889044087832161267215e-03
 	 4.80002887465515781784120008524042e-01 3.46233167655783727334473098835588e-02 5.87046436829854155481367428137673e-03
 	 3.46233167655783727334473098835588e-02 4.85373795768905824665750969870714e-01 5.87046436829854155481367428137673e-03
 	 4.85373795768905824665750969870714e-01 4.80002887465515781784120008524042e-01 5.87046436829854155481367428137673e-03
 	 2.35698652486183879428693899171776e-01 7.17639780294608065069894564658171e-01 6.09162472206678431291271280656474e-03
 	 7.17639780294608065069894564658171e-01 4.66615672192079999902603049122263e-02 6.09162472206678431291271280656474e-03
 	 4.66615672192079999902603049122263e-02 2.35698652486183879428693899171776e-01 6.09162472206678431291271280656474e-03
 	 1.21235453505120910344672324754356e-01 9.87172892132079649041287439104053e-02 6.43274473743770617423232138776257e-03
 	 9.87172892132079649041287439104053e-02 7.80047257281671124751198931335239e-01 6.43274473743770617423232138776257e-03
 	 7.80047257281671124751198931335239e-01 1.21235453505120910344672324754356e-01 6.43274473743770617423232138776257e-03
 	 2.26921312534569846741661081068742e-01 5.33826956732506574532237664243439e-02 6.54764913100841332294077545839173e-03
 	 5.33826956732506574532237664243439e-02 7.19695991792179468049539536878001e-01 6.54764913100841332294077545839173e-03
 	 7.19695991792179468049539536878001e-01 2.26921312534569846741661081068742e-01 6.54764913100841332294077545839173e-03
 	 3.52725956002229834584937862018705e-01 5.93956020138616369585804477537749e-01 7.04335952667112241698532670852728e-03
 	 5.93956020138616369585804477537749e-01 5.33180238591538513404088917013723e-02 7.04335952667112241698532670852728e-03
 	 5.33180238591538513404088917013723e-02 3.52725956002229834584937862018705e-01 7.04335952667112241698532670852728e-03
 	 3.46394760980635263436511195322964e-01 5.11343671910869101981944595536334e-02 7.09201535978721143288483474975692e-03
 	 5.11343671910869101981944595536334e-02 6.02470871828277854120869960752316e-01 7.09201535978721143288483474975692e-03
 	 6.02470871828277854120869960752316e-01 3.46394760980635263436511195322964e-01 7.09201535978721143288483474975692e-03
 	 2.08545376179994440546394685043197e-01 1.26661874088773246382899628770247e-01 8.61041578380116606750149799154315e-03
 	 1.26661874088773246382899628770247e-01 6.64792749731232257559554454928730e-01 8.61041578380116606750149799154315e-03
 	 6.64792749731232257559554454928730e-01 2.08545376179994440546394685043197e-01 8.61041578380116606750149799154315e-03
 	 1.16641181787498937616476268885890e-01 1.93583513707742599363470503703866e-01 8.70681197967806269621959813775902e-03
 	 1.93583513707742599363470503703866e-01 6.89775304504758435264477611781331e-01 8.70681197967806269621959813775902e-03
 	 6.89775304504758435264477611781331e-01 1.16641181787498937616476268885890e-01 8.70681197967806269621959813775902e-03
 	 3.01681731659511120913208515048609e-01 5.79485561285726924474204224679852e-01 9.04183777182423521756593487452847e-03
 	 5.79485561285726924474204224679852e-01 1.18832707054762010123738491529366e-01 9.04183777182423521756593487452847e-03
 	 1.18832707054762010123738491529366e-01 3.01681731659511120913208515048609e-01 9.04183777182423521756593487452847e-03
 	 3.59766505094364252848038177035050e-01 4.65449578776416461600717866531340e-01 9.57456938333661397577678542347712e-03
 	 4.65449578776416461600717866531340e-01 1.74783916129219285551243956433609e-01 9.57456938333661397577678542347712e-03
 	 1.74783916129219285551243956433609e-01 3.59766505094364252848038177035050e-01 9.57456938333661397577678542347712e-03
 	 3.17727894779720854145921293820720e-01 1.21922765864560744830669136717916e-01 9.61390963530625239363835987660423e-03
 	 1.21922765864560744830669136717916e-01 5.60349339355718401023409569461364e-01 9.61390963530625239363835987660423e-03
 	 5.60349339355718401023409569461364e-01 3.17727894779720854145921293820720e-01 9.61390963530625239363835987660423e-03
 	 4.50599237708166233673523493052926e-01 9.80260802306452266874359224857471e-02 1.00158383807107658619584000803115e-02
 	 9.80260802306452266874359224857471e-02 4.51374682061188525761252776646870e-01 1.00158383807107658619584000803115e-02
 	 4.51374682061188525761252776646870e-01 4.50599237708166233673523493052926e-01 1.00158383807107658619584000803115e-02
 	 2.66780208878214575296539123883122e-01 3.09304671639405781569109876727453e-01 1.03825614307465671076746716039452e-02
 	 3.09304671639405781569109876727453e-01 4.23915119482379698645502230647253e-01 1.03825614307465671076746716039452e-02
 	 4.23915119482379698645502230647253e-01 2.66780208878214575296539123883122e-01 1.03825614307465671076746716039452e-02
 	 2.14913322085512142889385245325684e-01 2.23615271231608347957120486171334e-01 1.19075263531945689521318598735888e-02
 	 2.23615271231608347957120486171334e-01 5.61471406682879425886767421616241e-01 1.19075263531945689521318598735888e-02
 	 5.61471406682879425886767421616241e-01 2.14913322085512142889385245325684e-01 1.19075263531945689521318598735888e-02
 	 3.41820828914985830326855875682668e-01 2.03059575102732176032915845098614e-01 1.19538232815810784720467196962090e-02
 	 2.03059575102732176032915845098614e-01 4.55119595982282021395803894847631e-01 1.19538232815810784720467196962090e-02
 	 4.55119595982282021395803894847631e-01 3.41820828914985830326855875682668e-01 1.19538232815810784720467196962090e-02
 	 ];
 
 	 case  22 

 	 % ALG. DEG.:   22
 	 % PTS CARD.:   93
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.6e-16  

 	 xyw=[
 	 1.17033848378872841304587648636470e-03 4.78536918807590805347018658721936e-02 4.87706020469868661414841737311576e-04
 	 4.78536918807590805347018658721936e-02 9.50975969635452167416644897457445e-01 4.87706020469868661414841737311576e-04
 	 9.50975969635452167416644897457445e-01 1.17033848378872841304587648636470e-03 4.87706020469868661414841737311576e-04
 	 1.09943655740260652631246074406590e-02 9.10867175372020998480593334534205e-03 6.55222610574895123272676222825339e-04
 	 9.10867175372020998480593334534205e-03 9.79896962672253679649259083817014e-01 6.55222610574895123272676222825339e-04
 	 9.79896962672253679649259083817014e-01 1.09943655740260652631246074406590e-02 6.55222610574895123272676222825339e-04
 	 1.06816925225288752131225233910072e-03 2.02709063387925630950192612544924e-01 9.09692042324600669452039358731099e-04
 	 2.02709063387925630950192612544924e-01 7.96222767359821559374211119575193e-01 9.09692042324600669452039358731099e-04
 	 7.96222767359821559374211119575193e-01 1.06816925225288752131225233910072e-03 9.09692042324600669452039358731099e-04
 	 2.21228350592110340616658348267265e-03 4.21769070671465406974220968550071e-01 1.24269485894917082122179685654828e-03
 	 4.21769070671465406974220968550071e-01 5.76018645822613528650890657445416e-01 1.24269485894917082122179685654828e-03
 	 5.76018645822613528650890657445416e-01 2.21228350592110340616658348267265e-03 1.24269485894917082122179685654828e-03
 	 5.72025987162534596541796361179877e-02 8.56087099920958480292476622253162e-03 1.39715288121358824011131183340240e-03
 	 8.56087099920958480292476622253162e-03 9.34236530284537014523493780870922e-01 1.39715288121358824011131183340240e-03
 	 9.34236530284537014523493780870922e-01 5.72025987162534596541796361179877e-02 1.39715288121358824011131183340240e-03
 	 3.53024211615276806153218558392837e-01 6.09424125055589051280779955277467e-03 1.77407428600574994942418172172438e-03
 	 6.09424125055589051280779955277467e-03 6.40881547134167228740864175051684e-01 1.77407428600574994942418172172438e-03
 	 6.40881547134167228740864175051684e-01 3.53024211615276806153218558392837e-01 1.77407428600574994942418172172438e-03
 	 1.36788957839153818563104891836701e-01 7.84998062848008687497625146534119e-03 1.88931332815918764413132269197604e-03
 	 7.84998062848008687497625146534119e-03 8.55361061532366129256388376234099e-01 1.88931332815918764413132269197604e-03
 	 8.55361061532366129256388376234099e-01 1.36788957839153818563104891836701e-01 1.88931332815918764413132269197604e-03
 	 2.41209563760037715152151349684573e-01 7.02726355172032801643666743984795e-03 2.01913314251987198455484673331739e-03
 	 7.02726355172032801643666743984795e-03 7.51763172688241887442472943803295e-01 2.01913314251987198455484673331739e-03
 	 7.51763172688241887442472943803295e-01 2.41209563760037715152151349684573e-01 2.01913314251987198455484673331739e-03
 	 1.16737477866878831822550210972622e-02 1.12641216429535215293178396223084e-01 2.31660679651168400008942604983986e-03
 	 1.12641216429535215293178396223084e-01 8.75685035783776988260740381520009e-01 2.31660679651168400008942604983986e-03
 	 8.75685035783776988260740381520009e-01 1.16737477866878831822550210972622e-02 2.31660679651168400008942604983986e-03
 	 3.01148996347992969901952164946124e-02 4.60558965203824444145652705628891e-02 2.46536317015107241459870301980573e-03
 	 4.60558965203824444145652705628891e-02 9.23829203844818258595239512942499e-01 2.46536317015107241459870301980573e-03
 	 9.23829203844818258595239512942499e-01 3.01148996347992969901952164946124e-02 2.46536317015107241459870301980573e-03
 	 4.56500154387454060156414925586432e-01 1.14379077070311217789733149174936e-02 3.20785199538873395594396065177989e-03
 	 1.14379077070311217789733149174936e-02 5.32061937905514814595164807542460e-01 3.20785199538873395594396065177989e-03
 	 5.32061937905514814595164807542460e-01 4.56500154387454060156414925586432e-01 3.20785199538873395594396065177989e-03
 	 1.18075946189018649024049523177382e-02 3.04996921690560307549588969777687e-01 3.32421252207346388726771913013636e-03
 	 3.04996921690560307549588969777687e-01 6.83195483690537841425793885719031e-01 3.32421252207346388726771913013636e-03
 	 6.83195483690537841425793885719031e-01 1.18075946189018649024049523177382e-02 3.32421252207346388726771913013636e-03
 	 9.61505587301470371341949316956743e-02 4.26352318690261661293661177296599e-02 3.96867722784416832731979596360361e-03
 	 4.26352318690261661293661177296599e-02 8.61214209400826824492014566203579e-01 3.96867722784416832731979596360361e-03
 	 8.61214209400826824492014566203579e-01 9.61505587301470371341949316956743e-02 3.96867722784416832731979596360361e-03
 	 3.06376574992079410419965057599256e-02 1.96990580025709072220507778183674e-01 4.69591283560160614035661197362970e-03
 	 1.96990580025709072220507778183674e-01 7.72371762475082990206942668010015e-01 4.69591283560160614035661197362970e-03
 	 7.72371762475082990206942668010015e-01 3.06376574992079410419965057599256e-02 4.69591283560160614035661197362970e-03
 	 1.94815244430806083775209458508471e-01 3.86641674378723973481974951482698e-02 4.88329231189547560698649419919093e-03
 	 3.86641674378723973481974951482698e-02 7.66520588131321511937699142436031e-01 4.88329231189547560698649419919093e-03
 	 7.66520588131321511937699142436031e-01 1.94815244430806083775209458508471e-01 4.88329231189547560698649419919093e-03
 	 6.03655030702410985710137936166575e-02 1.06610220689147924821860158317577e-01 4.96965611820962896438835798562650e-03
 	 1.06610220689147924821860158317577e-01 8.33024276240610928034868720715167e-01 4.96965611820962896438835798562650e-03
 	 8.33024276240610928034868720715167e-01 6.03655030702410985710137936166575e-02 4.96965611820962896438835798562650e-03
 	 3.15090899482059372260778218333144e-01 3.60898201743391419671347364328540e-02 5.39285897517053670890962990824846e-03
 	 3.60898201743391419671347364328540e-02 6.48819280343601478833193141326774e-01 5.39285897517053670890962990824846e-03
 	 6.48819280343601478833193141326774e-01 3.15090899482059372260778218333144e-01 5.39285897517053670890962990824846e-03
 	 4.11358367215817199991079178289510e-01 5.56390353961855654851831332052825e-01 5.59935690856001519466467186703085e-03
 	 5.56390353961855654851831332052825e-01 3.22512788223271451570894896576647e-02 5.59935690856001519466467186703085e-03
 	 3.22512788223271451570894896576647e-02 4.11358367215817199991079178289510e-01 5.59935690856001519466467186703085e-03
 	 1.44020350630489235577158524392871e-01 9.77155901845127572435956153640291e-02 6.79622462533692028169296506234787e-03
 	 9.77155901845127572435956153640291e-02 7.58264059184998062690397091500927e-01 6.79622462533692028169296506234787e-03
 	 7.58264059184998062690397091500927e-01 1.44020350630489235577158524392871e-01 6.79622462533692028169296506234787e-03
 	 4.20757709102121901789672619997873e-01 5.55288374894526703950958790301229e-02 7.05364365658125037211734209563474e-03
 	 5.55288374894526703950958790301229e-02 5.23713453408425344548504654085264e-01 7.05364365658125037211734209563474e-03
 	 5.23713453408425344548504654085264e-01 4.20757709102121901789672619997873e-01 7.05364365658125037211734209563474e-03
 	 6.09498995807896612464382712914812e-02 2.92056016141072904979125723912148e-01 7.17274949295997488879494952129789e-03
 	 2.92056016141072904979125723912148e-01 6.46994084278137426835542100889143e-01 7.17274949295997488879494952129789e-03
 	 6.46994084278137426835542100889143e-01 6.09498995807896612464382712914812e-02 7.17274949295997488879494952129789e-03
 	 9.69351064455874905645416106381163e-02 1.84224156891908047439798679079104e-01 7.51657234055716320930695673041555e-03
 	 1.84224156891908047439798679079104e-01 7.18840736662504475873447518097237e-01 7.51657234055716320930695673041555e-03
 	 7.18840736662504475873447518097237e-01 9.69351064455874905645416106381163e-02 7.51657234055716320930695673041555e-03
 	 2.53783465620646964122641975336592e-01 9.22286849014402332347373203447205e-02 7.91883890190281380938586153206415e-03
 	 9.22286849014402332347373203447205e-02 6.53987849477912774887045088689774e-01 7.91883890190281380938586153206415e-03
 	 6.53987849477912774887045088689774e-01 2.53783465620646964122641975336592e-01 7.91883890190281380938586153206415e-03
 	 3.48867101402162760326319812520524e-01 1.16235552070709735605902324095950e-01 8.55725277413337676035709478128410e-03
 	 1.16235552070709735605902324095950e-01 5.34897346527127615090080325899180e-01 8.55725277413337676035709478128410e-03
 	 5.34897346527127615090080325899180e-01 3.48867101402162760326319812520524e-01 8.55725277413337676035709478128410e-03
 	 1.90581558653074217835055037539860e-01 1.72148246666744941801852064600098e-01 8.98564555031942067964134679414201e-03
 	 1.72148246666744941801852064600098e-01 6.37270194680180868118668513488956e-01 8.98564555031942067964134679414201e-03
 	 6.37270194680180868118668513488956e-01 1.90581558653074217835055037539860e-01 8.98564555031942067964134679414201e-03
 	 9.69881143348128027525945071829483e-02 3.96552131508626504174941374003538e-01 9.27251659845123449299464368777990e-03
 	 3.96552131508626504174941374003538e-01 5.06459754156560748583615350071341e-01 9.27251659845123449299464368777990e-03
 	 5.06459754156560748583615350071341e-01 9.69881143348128027525945071829483e-02 9.27251659845123449299464368777990e-03
 	 1.41266334630631706925640855843085e-01 2.75379650245183016377126250517904e-01 9.69905562317903077729219774028024e-03
 	 2.75379650245183016377126250517904e-01 5.83354015124185165674930431123357e-01 9.69905562317903077729219774028024e-03
 	 5.83354015124185165674930431123357e-01 1.41266334630631706925640855843085e-01 9.69905562317903077729219774028024e-03
 	 4.12018101979952200419887731186463e-01 1.68573884290088321646905455963861e-01 9.76183529320075356328079152490318e-03
 	 1.68573884290088321646905455963861e-01 4.19408013729959394666479965962935e-01 9.76183529320075356328079152490318e-03
 	 4.19408013729959394666479965962935e-01 4.12018101979952200419887731186463e-01 9.76183529320075356328079152490318e-03
 	 2.76209339065321413109188597445609e-01 1.99199356373184033319745367407450e-01 1.03127659848185199154002589239099e-02
 	 1.99199356373184033319745367407450e-01 5.24591304561494498059914803889114e-01 1.03127659848185199154002589239099e-02
 	 5.24591304561494498059914803889114e-01 2.76209339065321413109188597445609e-01 1.03127659848185199154002589239099e-02
 	 2.18610614672497399757489233707020e-01 3.05685651047730433393923021867522e-01 1.06569112100914267088347386902569e-02
 	 3.05685651047730433393923021867522e-01 4.75703734279772139093012128796545e-01 1.06569112100914267088347386902569e-02
 	 4.75703734279772139093012128796545e-01 2.18610614672497399757489233707020e-01 1.06569112100914267088347386902569e-02
 	 3.36799046311846372869780452674604e-01 2.69814345781991038464298071630765e-01 1.17638765835114608715450401632552e-02
 	 2.69814345781991038464298071630765e-01 3.93386607906162533154770244436804e-01 1.17638765835114608715450401632552e-02
 	 3.93386607906162533154770244436804e-01 3.36799046311846372869780452674604e-01 1.17638765835114608715450401632552e-02
 	 ];
 
 	 case  23 

 	 % ALG. DEG.:   23
 	 % PTS CARD.:  100
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.7e-16  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.25694357301468478266270878407340e-02
 	 9.41394903300460904327362499088849e-03 8.64644445189447809207994311009315e-03 5.33058841253013855794595787784829e-04
 	 8.64644445189447809207994311009315e-03 9.81939606515100926742434239713475e-01 5.33058841253013855794595787784829e-04
 	 9.81939606515100926742434239713475e-01 9.41394903300460904327362499088849e-03 5.33058841253013855794595787784829e-04
 	 4.82410218908890808548611817130336e-04 1.08821420580560865309927010002866e-01 5.54936575277445703208156757568759e-04
 	 1.08821420580560865309927010002866e-01 8.90696169200530185605657607084140e-01 5.54936575277445703208156757568759e-04
 	 8.90696169200530185605657607084140e-01 4.82410218908890808548611817130336e-04 5.54936575277445703208156757568759e-04
 	 4.96335565629436092915938161240774e-01 5.03294735930981729232769339432707e-01 8.14811977822814392791173077057465e-04
 	 5.03294735930981729232769339432707e-01 3.69698439582122340141268068691716e-04 8.14811977822814392791173077057465e-04
 	 3.69698439582122340141268068691716e-04 4.96335565629436092915938161240774e-01 8.14811977822814392791173077057465e-04
 	 8.61452759024325040448921697588958e-03 4.49648589409331542188219543731975e-02 1.10264584656888744475244923393120e-03
 	 4.49648589409331542188219543731975e-02 9.46420613468823557212772357161157e-01 1.10264584656888744475244923393120e-03
 	 9.46420613468823557212772357161157e-01 8.61452759024325040448921697588958e-03 1.10264584656888744475244923393120e-03
 	 4.91006634687758056201367651283363e-02 8.24249708242969815474854300418883e-03 1.15877715989831956908129306782484e-03
 	 8.24249708242969815474854300418883e-03 9.42656839448794414693111320957541e-01 1.15877715989831956908129306782484e-03
 	 9.42656839448794414693111320957541e-01 4.91006634687758056201367651283363e-02 1.15877715989831956908129306782484e-03
 	 2.66041607735387425695550156490299e-03 2.94704482021720892692684401481529e-01 1.16081935080770103085878730553304e-03
 	 2.94704482021720892692684401481529e-01 7.02635101900925151952037595037837e-01 1.16081935080770103085878730553304e-03
 	 7.02635101900925151952037595037837e-01 2.66041607735387425695550156490299e-03 1.16081935080770103085878730553304e-03
 	 3.30984469269412107106376197407371e-01 3.82066849179892769131083873901389e-03 1.50183075569778300140111326754777e-03
 	 3.82066849179892769131083873901389e-03 6.65194862238788875430373082053848e-01 1.50183075569778300140111326754777e-03
 	 6.65194862238788875430373082053848e-01 3.30984469269412107106376197407371e-01 1.50183075569778300140111326754777e-03
 	 1.18154505921019392644666368141770e-01 8.41315741466065573905819263700323e-03 1.77381096176873259348538702795395e-03
 	 8.41315741466065573905819263700323e-03 8.73432336664319963759339771058876e-01 1.77381096176873259348538702795395e-03
 	 8.73432336664319963759339771058876e-01 1.18154505921019392644666368141770e-01 1.77381096176873259348538702795395e-03
 	 2.14073097879028895196285020574578e-01 7.20539757650225185653392045992405e-03 1.90132581827351246697710429600647e-03
 	 7.20539757650225185653392045992405e-03 7.78721504544468867692330604768358e-01 1.90132581827351246697710429600647e-03
 	 7.78721504544468867692330604768358e-01 2.14073097879028895196285020574578e-01 1.90132581827351246697710429600647e-03
 	 4.45774128773336539288685287374392e-02 4.30263570230853334419585110026674e-02 2.36716235132847186914406556468293e-03
 	 4.30263570230853334419585110026674e-02 9.12396230099581040384748575888807e-01 2.36716235132847186914406556468293e-03
 	 9.12396230099581040384748575888807e-01 4.45774128773336539288685287374392e-02 2.36716235132847186914406556468293e-03
 	 1.91431395153490890859160344916745e-01 3.11692698898602960078108026209520e-02 2.39102276472424142214623365987336e-03
 	 3.11692698898602960078108026209520e-02 7.77399334956648813133028852462303e-01 2.39102276472424142214623365987336e-03
 	 7.77399334956648813133028852462303e-01 1.91431395153490890859160344916745e-01 2.39102276472424142214623365987336e-03
 	 1.05850984567690802745643097182437e-02 1.91864903048277385400055550235265e-01 2.52746008365003528572945157293361e-03
 	 1.91864903048277385400055550235265e-01 7.97549998494953560346232279698597e-01 2.52746008365003528572945157293361e-03
 	 7.97549998494953560346232279698597e-01 1.05850984567690802745643097182437e-02 2.52746008365003528572945157293361e-03
 	 2.54202264290056406670359478994214e-02 1.05407606480096824319581116924383e-01 3.02260306724195853753101026484273e-03
 	 1.05407606480096824319581116924383e-01 8.69172167090897507257807319547283e-01 3.02260306724195853753101026484273e-03
 	 8.69172167090897507257807319547283e-01 2.54202264290056406670359478994214e-02 3.02260306724195853753101026484273e-03
 	 5.91292919761095991937338567367988e-01 1.21072892452521504308426969487300e-02 3.15635122284491521221783116857296e-03
 	 1.21072892452521504308426969487300e-02 3.96599790993651835080413547984790e-01 3.15635122284491521221783116857296e-03
 	 3.96599790993651835080413547984790e-01 5.91292919761095991937338567367988e-01 3.15635122284491521221783116857296e-03
 	 1.04903656520941024332671531738015e-01 4.33709753919495621943269725306891e-02 3.38820274356900008952409031337538e-03
 	 4.33709753919495621943269725306891e-02 8.51725368087109413473001495731296e-01 3.38820274356900008952409031337538e-03
 	 8.51725368087109413473001495731296e-01 1.04903656520941024332671531738015e-01 3.38820274356900008952409031337538e-03
 	 4.27217446018734792190230109554250e-01 1.66970788554706185691234310297659e-02 3.94239621381627623752930134060080e-03
 	 1.66970788554706185691234310297659e-02 5.56085475125794537198942180111771e-01 3.94239621381627623752930134060080e-03
 	 5.56085475125794537198942180111771e-01 4.27217446018734792190230109554250e-01 3.94239621381627623752930134060080e-03
 	 1.77899296750879898354469332844019e-01 6.45110680237001715697786607961461e-02 4.36845382037373986677808446188465e-03
 	 6.45110680237001715697786607961461e-02 7.57589635225419888442388582916465e-01 4.36845382037373986677808446188465e-03
 	 7.57589635225419888442388582916465e-01 1.77899296750879898354469332844019e-01 4.36845382037373986677808446188465e-03
 	 8.05482155825715390173868968304305e-02 1.01976993969515816740312175170402e-01 4.71720292699666973040839579311978e-03
 	 1.01976993969515816740312175170402e-01 8.17474790447912713631239967071451e-01 4.71720292699666973040839579311978e-03
 	 8.17474790447912713631239967071451e-01 8.05482155825715390173868968304305e-02 4.71720292699666973040839579311978e-03
 	 3.13173112798550493107718750707136e-02 2.85342978045655892849197243776871e-01 4.74543971390964033907344798990380e-03
 	 2.85342978045655892849197243776871e-01 6.83339710674489064778924785059644e-01 4.74543971390964033907344798990380e-03
 	 6.83339710674489064778924785059644e-01 3.13173112798550493107718750707136e-02 4.74543971390964033907344798990380e-03
 	 2.95446758742554271837121859789477e-01 3.28810125354330601288310731433739e-02 5.10548132810887539401178969455941e-03
 	 3.28810125354330601288310731433739e-02 6.71672228722012709667410490510520e-01 5.10548132810887539401178969455941e-03
 	 6.71672228722012709667410490510520e-01 2.95446758742554271837121859789477e-01 5.10548132810887539401178969455941e-03
 	 5.41132173539479316426437094378343e-02 1.83859582702943807897000283446687e-01 5.25962666774252175089232608229395e-03
 	 1.83859582702943807897000283446687e-01 7.62027199943108302093719430558849e-01 5.25962666774252175089232608229395e-03
 	 7.62027199943108302093719430558849e-01 5.41132173539479316426437094378343e-02 5.25962666774252175089232608229395e-03
 	 4.27400654280490135961123598917766e-02 4.43558986603905025525307337375125e-01 5.84456018763875907728877479030416e-03
 	 4.43558986603905025525307337375125e-01 5.13700947968045995573049822269240e-01 5.84456018763875907728877479030416e-03
 	 5.13700947968045995573049822269240e-01 4.27400654280490135961123598917766e-02 5.84456018763875907728877479030416e-03
 	 1.45187675973377866567304295131180e-01 1.29795450451007293724003943680145e-01 6.85020013970072307735170724640739e-03
 	 1.29795450451007293724003943680145e-01 7.25016873575614839708691761188675e-01 6.85020013970072307735170724640739e-03
 	 7.25016873575614839708691761188675e-01 1.45187675973377866567304295131180e-01 6.85020013970072307735170724640739e-03
 	 7.47139784787638483454230708957766e-02 3.29913961425314705699918249592884e-01 7.23022564954137799547728704396832e-03
 	 3.29913961425314705699918249592884e-01 5.95372060095921473710234295140253e-01 7.23022564954137799547728704396832e-03
 	 5.95372060095921473710234295140253e-01 7.47139784787638483454230708957766e-02 7.23022564954137799547728704396832e-03
 	 3.81968043130448131616816453970387e-01 6.73625275151304159226839374241536e-02 7.61569789179446145904739395859906e-03
 	 6.73625275151304159226839374241536e-02 5.50669429354421424704923992976546e-01 7.61569789179446145904739395859906e-03
 	 5.50669429354421424704923992976546e-01 3.81968043130448131616816453970387e-01 7.61569789179446145904739395859906e-03
 	 2.21783549821814751634718732020701e-01 6.68980984358149566304518884862773e-01 7.74293665972291839799668267119159e-03
 	 6.68980984358149566304518884862773e-01 1.09235465820035626549611151858699e-01 7.74293665972291839799668267119159e-03
 	 1.09235465820035626549611151858699e-01 2.21783549821814751634718732020701e-01 7.74293665972291839799668267119159e-03
 	 2.56870811513146835025622749526519e-01 9.60491211353747958989757194103731e-02 7.99447871827724948490256906552531e-03
 	 9.60491211353747958989757194103731e-02 6.47080067351478382953189338877564e-01 7.99447871827724948490256906552531e-03
 	 6.47080067351478382953189338877564e-01 2.56870811513146835025622749526519e-01 7.99447871827724948490256906552531e-03
 	 1.12751303426959964548714765442128e-01 4.23674182024581569283583348806133e-01 9.46451795294582336193212057651181e-03
 	 4.23674182024581569283583348806133e-01 4.63574514548458493923277501380653e-01 9.46451795294582336193212057651181e-03
 	 4.63574514548458493923277501380653e-01 1.12751303426959964548714765442128e-01 9.46451795294582336193212057651181e-03
 	 2.10323057441033522962925417232327e-01 1.87001109672332688216300766725908e-01 9.87404067836702981075802654231666e-03
 	 1.87001109672332688216300766725908e-01 6.02675832886633733309622584783938e-01 9.87404067836702981075802654231666e-03
 	 6.02675832886633733309622584783938e-01 2.10323057441033522962925417232327e-01 9.87404067836702981075802654231666e-03
 	 1.61575209179476625420690538703639e-01 2.99012948455699423266906933349674e-01 1.03338907798329795312275436458549e-02
 	 2.99012948455699423266906933349674e-01 5.39411842364823979067978143575601e-01 1.03338907798329795312275436458549e-02
 	 5.39411842364823979067978143575601e-01 1.61575209179476625420690538703639e-01 1.03338907798329795312275436458549e-02
 	 3.31656221355574820641720634739613e-01 1.50616235510018708909640849924472e-01 1.03991713323975526472864316929190e-02
 	 1.50616235510018708909640849924472e-01 5.17727543134406498204214130964829e-01 1.03991713323975526472864316929190e-02
 	 5.17727543134406498204214130964829e-01 3.31656221355574820641720634739613e-01 1.03991713323975526472864316929190e-02
 	 2.12294763316891205162662004113372e-01 3.84271485252512368102628670385457e-01 1.17877874203720679757712019863902e-02
 	 3.84271485252512368102628670385457e-01 4.03433751430596398979133709872258e-01 1.17877874203720679757712019863902e-02
 	 4.03433751430596398979133709872258e-01 2.12294763316891205162662004113372e-01 1.17877874203720679757712019863902e-02
 	 2.74113742189350695355187781387940e-01 2.58726723002178027321917852532351e-01 1.18459271543522540875992277165096e-02
 	 2.58726723002178027321917852532351e-01 4.67159534808471277322894366079709e-01 1.18459271543522540875992277165096e-02
 	 4.67159534808471277322894366079709e-01 2.74113742189350695355187781387940e-01 1.18459271543522540875992277165096e-02
 	 ];
 
 	 case  24 

 	 % ALG. DEG.:   24
 	 % PTS CARD.:  109
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.8e-16  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 5.34088846669340550771254427786516e-03
 	 7.27744218228642408829998089458968e-03 1.87178063161081678807129424768618e-03 1.71536069217019938697166292485008e-04
 	 1.87178063161081678807129424768618e-03 9.90850777186102704696679666085402e-01 1.71536069217019938697166292485008e-04
 	 9.90850777186102704696679666085402e-01 7.27744218228642408829998089458968e-03 1.71536069217019938697166292485008e-04
 	 9.37621417401595796947688654654485e-02 2.22584177630761334901188241985892e-03 6.11499851018703364027850888362536e-04
 	 2.22584177630761334901188241985892e-03 9.04012016483532798716282741224859e-01 6.11499851018703364027850888362536e-04
 	 9.04012016483532798716282741224859e-01 9.37621417401595796947688654654485e-02 6.11499851018703364027850888362536e-04
 	 2.75499567254815017069979887764930e-02 9.64825831627800223344593177898787e-01 8.19080136824596599653958151066035e-04
 	 9.64825831627800223344593177898787e-01 7.62421164671822637615150597412139e-03 8.19080136824596599653958151066035e-04
 	 7.62421164671822637615150597412139e-03 2.75499567254815017069979887764930e-02 8.19080136824596599653958151066035e-04
 	 3.88491565765760812900531107061397e-02 9.99221468468047303856938157196055e-03 1.11861297293506167446763832629131e-03
 	 9.99221468468047303856938157196055e-03 9.51158628738743461283888791513164e-01 1.11861297293506167446763832629131e-03
 	 9.51158628738743461283888791513164e-01 3.88491565765760812900531107061397e-02 1.11861297293506167446763832629131e-03
 	 8.45824643422994626451583144444157e-02 9.07583350374654984626943132752785e-01 1.42875093413913595123687638732690e-03
 	 9.07583350374654984626943132752785e-01 7.83418528304558048347416843171231e-03 1.42875093413913595123687638732690e-03
 	 7.83418528304558048347416843171231e-03 8.45824643422994626451583144444157e-02 1.42875093413913595123687638732690e-03
 	 1.69711974261767234439801654843905e-01 8.55094769491029395303005600226243e-03 1.84291480816372275908232580832191e-03
 	 8.55094769491029395303005600226243e-03 8.21737078043322521914149092481239e-01 1.84291480816372275908232580832191e-03
 	 8.21737078043322521914149092481239e-01 1.69711974261767234439801654843905e-01 1.84291480816372275908232580832191e-03
 	 2.61114259888929389763490007680957e-01 7.35523531115195392665606632931485e-03 1.84739772102621570108726967163193e-03
 	 7.35523531115195392665606632931485e-03 7.31530504799918657177215663978131e-01 1.84739772102621570108726967163193e-03
 	 7.31530504799918657177215663978131e-01 2.61114259888929389763490007680957e-01 1.84739772102621570108726967163193e-03
 	 1.67919705131083785154544329998316e-01 8.24005083539038452045133453793824e-01 1.95101600310397700621667382847590e-03
 	 8.24005083539038452045133453793824e-01 8.07521132987776280032221620786004e-03 1.95101600310397700621667382847590e-03
 	 8.07521132987776280032221620786004e-03 1.67919705131083785154544329998316e-01 1.95101600310397700621667382847590e-03
 	 3.66562445874964837333465084157069e-01 7.00566016949978002253951459010750e-03 2.01403454846550093032542250170991e-03
 	 7.00566016949978002253951459010750e-03 6.26431893955535445961402274406282e-01 2.01403454846550093032542250170991e-03
 	 6.26431893955535445961402274406282e-01 3.66562445874964837333465084157069e-01 2.01403454846550093032542250170991e-03
 	 2.71431359408183414672066646744497e-01 7.20628297746085721975362048397074e-01 2.26244036008083852090644327859081e-03
 	 7.20628297746085721975362048397074e-01 7.94034284573086335257130485842936e-03 2.26244036008083852090644327859081e-03
 	 7.94034284573086335257130485842936e-03 2.71431359408183414672066646744497e-01 2.26244036008083852090644327859081e-03
 	 4.83415122297192079159344757499639e-01 7.36119356684007599550545464239804e-03 2.26980146313370380675711324158783e-03
 	 7.36119356684007599550545464239804e-03 5.09223684135967857855575857684016e-01 2.26980146313370380675711324158783e-03
 	 5.09223684135967857855575857684016e-01 4.83415122297192079159344757499639e-01 2.26980146313370380675711324158783e-03
 	 3.87957374245691544167868869408267e-01 6.04329908418651196022608473867876e-01 2.37284772365591511630866783377769e-03
 	 6.04329908418651196022608473867876e-01 7.71271733565725980952265672385693e-03 2.37284772365591511630866783377769e-03
 	 7.71271733565725980952265672385693e-03 3.87957374245691544167868869408267e-01 2.37284772365591511630866783377769e-03
 	 5.20536116012078262094142644400563e-02 9.07672123610022807405073308473220e-01 2.59026828668722924886580472048081e-03
 	 9.07672123610022807405073308473220e-01 4.02742647887693872021941388084088e-02 2.59026828668722924886580472048081e-03
 	 4.02742647887693872021941388084088e-02 5.20536116012078262094142644400563e-02 2.59026828668722924886580472048081e-03
 	 2.29018909213725946338868766360974e-01 8.93452564981080527006795932720706e-02 2.65596161636161244221088217898341e-03
 	 8.93452564981080527006795932720706e-02 6.81635834288165987082663832552498e-01 2.65596161636161244221088217898341e-03
 	 6.81635834288165987082663832552498e-01 2.29018909213725946338868766360974e-01 2.65596161636161244221088217898341e-03
 	 9.49141955716360924411034716285940e-02 2.67967190917923619997154105476511e-02 2.68209752148339686944611415242434e-03
 	 2.67967190917923619997154105476511e-02 8.78289085336571573314756733452668e-01 2.68209752148339686944611415242434e-03
 	 8.78289085336571573314756733452668e-01 9.49141955716360924411034716285940e-02 2.68209752148339686944611415242434e-03
 	 1.23228014736413052365726628067932e-01 8.35184452859199955021551886602538e-01 3.92048297259448702556383636874671e-03
 	 8.35184452859199955021551886602538e-01 4.15875324043869509793580618861597e-02 3.92048297259448702556383636874671e-03
 	 4.15875324043869509793580618861597e-02 1.23228014736413052365726628067932e-01 3.92048297259448702556383636874671e-03
 	 1.74126507274859759766272304659651e-01 4.41306288863040421799333046237734e-02 4.34970113310666813694060905959304e-03
 	 4.41306288863040421799333046237734e-02 7.81742863838836177237112678994890e-01 4.34970113310666813694060905959304e-03
 	 7.81742863838836177237112678994890e-01 1.74126507274859759766272304659651e-01 4.34970113310666813694060905959304e-03
 	 2.72180746005686646782351090223528e-01 3.74687219394429782415301133369212e-02 4.42010181668393668796834816703267e-03
 	 3.74687219394429782415301133369212e-02 6.90350532054870402731694412068464e-01 4.42010181668393668796834816703267e-03
 	 6.90350532054870402731694412068464e-01 2.72180746005686646782351090223528e-01 4.42010181668393668796834816703267e-03
 	 9.90063515075153971478627568103548e-02 8.19687967813020335050566700374475e-02 4.81456610994497949396198066551733e-03
 	 8.19687967813020335050566700374475e-02 8.19024851711182666491595227853395e-01 4.81456610994497949396198066551733e-03
 	 8.19024851711182666491595227853395e-01 9.90063515075153971478627568103548e-02 4.81456610994497949396198066551733e-03
 	 2.18932787550637497631100814032834e-01 7.39314412421514188800131250900449e-01 4.90162630494199013514444729366915e-03
 	 7.39314412421514188800131250900449e-01 4.17528000278483135687679350667167e-02 4.90162630494199013514444729366915e-03
 	 4.17528000278483135687679350667167e-02 2.18932787550637497631100814032834e-01 4.90162630494199013514444729366915e-03
 	 3.85457856195294268353279676375678e-01 3.70114098745062680695383505735663e-02 4.97140868791443122504114526805097e-03
 	 3.70114098745062680695383505735663e-02 5.77530733930199491332757588679669e-01 4.97140868791443122504114526805097e-03
 	 5.77530733930199491332757588679669e-01 3.85457856195294268353279676375678e-01 4.97140868791443122504114526805097e-03
 	 4.53931532973698426136621719706454e-01 5.07124120567042480089980927004945e-01 5.37412036835000720552679709385302e-03
 	 5.07124120567042480089980927004945e-01 3.89443464592591492845485845464282e-02 5.37412036835000720552679709385302e-03
 	 3.89443464592591492845485845464282e-02 4.53931532973698426136621719706454e-01 5.37412036835000720552679709385302e-03
 	 3.31414067992492400449577871768270e-01 6.27872100319265880052910233644070e-01 5.38763633180223099061745273274937e-03
 	 6.27872100319265880052910233644070e-01 4.07138316882417194975118945876602e-02 5.38763633180223099061745273274937e-03
 	 4.07138316882417194975118945876602e-02 3.31414067992492400449577871768270e-01 5.38763633180223099061745273274937e-03
 	 1.75418478700220814570087668471388e-01 1.09788999485381039145082127106434e-01 5.89154887641259519814873613086093e-03
 	 1.09788999485381039145082127106434e-01 7.14792521814398118529254588793265e-01 5.89154887641259519814873613086093e-03
 	 7.14792521814398118529254588793265e-01 1.75418478700220814570087668471388e-01 5.89154887641259519814873613086093e-03
 	 2.99424606258227421484718888677889e-01 8.95177416056505692587563771667192e-02 6.07838382705238374631440123607717e-03
 	 8.95177416056505692587563771667192e-02 6.11057652136121953745373502897564e-01 6.07838382705238374631440123607717e-03
 	 6.11057652136121953745373502897564e-01 2.99424606258227421484718888677889e-01 6.07838382705238374631440123607717e-03
 	 1.64438284214270008520841770405241e-01 7.35720413124063998822066423599608e-01 6.47285261806641171178355875781563e-03
 	 7.35720413124063998822066423599608e-01 9.98413026616660204126674216240644e-02 6.47285261806641171178355875781563e-03
 	 9.98413026616660204126674216240644e-02 1.64438284214270008520841770405241e-01 6.47285261806641171178355875781563e-03
 	 3.69724758939286801684431793546537e-01 4.63127807453672823978507722131326e-01 6.77744987373955429243999049049307e-03
 	 4.63127807453672823978507722131326e-01 1.67147433607040374337060484322137e-01 6.77744987373955429243999049049307e-03
 	 1.67147433607040374337060484322137e-01 3.69724758939286801684431793546537e-01 6.77744987373955429243999049049307e-03
 	 4.06369061777283435699104074956267e-01 9.07167861113062495848069488602050e-02 7.33791624653477511652788223273092e-03
 	 9.07167861113062495848069488602050e-02 5.02914152111410217571574321482331e-01 7.33791624653477511652788223273092e-03
 	 5.02914152111410217571574321482331e-01 4.06369061777283435699104074956267e-01 7.33791624653477511652788223273092e-03
 	 2.67420664299267585306552064139396e-01 6.32902725169850244313352050085086e-01 7.71022722919994900336870813362111e-03
 	 6.32902725169850244313352050085086e-01 9.96766105308821703800958857755177e-02 7.71022722919994900336870813362111e-03
 	 9.96766105308821703800958857755177e-02 2.67420664299267585306552064139396e-01 7.71022722919994900336870813362111e-03
 	 3.83204107909751179317225933118607e-01 5.21623720050690464766773857263615e-01 7.75799889707759742635273525479533e-03
 	 5.21623720050690464766773857263615e-01 9.51721720395583004048489783599507e-02 7.75799889707759742635273525479533e-03
 	 9.51721720395583004048489783599507e-02 3.83204107909751179317225933118607e-01 7.75799889707759742635273525479533e-03
 	 1.78724492320244954246533097830252e-01 1.92031135757774140682130337154376e-01 7.83129465300495472557251730449934e-03
 	 1.92031135757774140682130337154376e-01 6.29244371921980905071336565015372e-01 7.83129465300495472557251730449934e-03
 	 6.29244371921980905071336565015372e-01 1.78724492320244954246533097830252e-01 7.83129465300495472557251730449934e-03
 	 2.82829128593355183518553985777544e-01 5.37642437490313485071169452567119e-01 7.96376875542390005868753632967127e-03
 	 5.37642437490313485071169452567119e-01 1.79528433916331331410276561655337e-01 7.96376875542390005868753632967127e-03
 	 1.79528433916331331410276561655337e-01 2.82829128593355183518553985777544e-01 7.96376875542390005868753632967127e-03
 	 2.70606479254229259634456639105338e-01 1.61339950052654446110977914941031e-01 8.05176651503982168667228336289554e-03
 	 1.61339950052654446110977914941031e-01 5.68053570693116238743414214695804e-01 8.05176651503982168667228336289554e-03
 	 5.68053570693116238743414214695804e-01 2.70606479254229259634456639105338e-01 8.05176651503982168667228336289554e-03
 	 3.70874346744923255592141231318237e-01 1.64548573538222442369516329563339e-01 8.32904021286562899761829470435259e-03
 	 1.64548573538222442369516329563339e-01 4.64577079716854302038342439118423e-01 8.32904021286562899761829470435259e-03
 	 4.64577079716854302038342439118423e-01 3.70874346744923255592141231318237e-01 8.32904021286562899761829470435259e-03
 	 3.63840811889283188840238381089875e-01 3.83367191770047632815021643182263e-01 9.67653974618146520136896526764758e-03
 	 3.83367191770047632815021643182263e-01 2.52791996340669178344739975727862e-01 9.67653974618146520136896526764758e-03
 	 2.52791996340669178344739975727862e-01 3.63840811889283188840238381089875e-01 9.67653974618146520136896526764758e-03
 	 2.75735321862771332046548877769965e-01 2.52760449512089535595293909864267e-01 1.02296793188677258290564253684352e-02
 	 2.52760449512089535595293909864267e-01 4.71504228625139076847005981107941e-01 1.02296793188677258290564253684352e-02
 	 4.71504228625139076847005981107941e-01 2.75735321862771332046548877769965e-01 1.02296793188677258290564253684352e-02
 	 ];
 
 	 case  25 

 	 % ALG. DEG.:   25
 	 % PTS CARD.:  117
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 5.4e-16  

 	 xyw=[
 	 1.31881771474051147363670821732740e-02 3.07956384011914569703849409165741e-03 2.63473905485520402090793279370473e-04
 	 3.07956384011914569703849409165741e-03 9.83732259012475740433956161723472e-01 2.63473905485520402090793279370473e-04
 	 9.83732259012475740433956161723472e-01 1.31881771474051147363670821732740e-02 2.63473905485520402090793279370473e-04
 	 2.72596213613051892646343965509459e-03 1.71043047595741092015142470472711e-02 2.69189285624497009162536809157018e-04
 	 1.71043047595741092015142470472711e-02 9.80169733104295337611233662755694e-01 2.69189285624497009162536809157018e-04
 	 9.80169733104295337611233662755694e-01 2.72596213613051892646343965509459e-03 2.69189285624497009162536809157018e-04
 	 6.29840020924785359834885412055883e-02 9.31371984168810507220825911645079e-01 8.56278646941008823867402810492422e-04
 	 9.31371984168810507220825911645079e-01 5.64401373871092904010993152041920e-03 8.56278646941008823867402810492422e-04
 	 5.64401373871092904010993152041920e-03 6.29840020924785359834885412055883e-02 8.56278646941008823867402810492422e-04
 	 5.20238006731535140847455522816745e-02 7.43791496086179931140902610309240e-03 9.56166433485291979849085564069355e-04
 	 7.43791496086179931140902610309240e-03 9.40538284365984744717081866838271e-01 9.56166433485291979849085564069355e-04
 	 9.40538284365984744717081866838271e-01 5.20238006731535140847455522816745e-02 9.56166433485291979849085564069355e-04
 	 2.20200206141671100956713758023398e-01 7.76414334424490371056037929520244e-01 9.94872257003353438475912184912886e-04
 	 7.76414334424490371056037929520244e-01 3.38545943383850023167269682744518e-03 9.94872257003353438475912184912886e-04
 	 3.38545943383850023167269682744518e-03 2.20200206141671100956713758023398e-01 9.94872257003353438475912184912886e-04
 	 3.04395561568152825393518412511185e-02 9.44856451527789409361446359980619e-01 1.35150087580622967585453064742751e-03
 	 9.44856451527789409361446359980619e-01 2.47039923153953289158835104899481e-02 1.35150087580622967585453064742751e-03
 	 2.47039923153953289158835104899481e-02 3.04395561568152825393518412511185e-02 1.35150087580622967585453064742751e-03
 	 1.13993174377526096385793152876431e-01 7.47102931577944221613885034116720e-03 1.41188107103241760817424754748117e-03
 	 7.47102931577944221613885034116720e-03 8.78535796306694427570960215234663e-01 1.41188107103241760817424754748117e-03
 	 8.78535796306694427570960215234663e-01 1.13993174377526096385793152876431e-01 1.41188107103241760817424754748117e-03
 	 3.42295210188022336339486173528712e-01 6.52613563397589468983994720474584e-01 1.45757458623657653630500963259919e-03
 	 6.52613563397589468983994720474584e-01 5.09122641438819467651910599670373e-03 1.45757458623657653630500963259919e-03
 	 5.09122641438819467651910599670373e-03 3.42295210188022336339486173528712e-01 1.45757458623657653630500963259919e-03
 	 1.30473991950559503605333588893700e-01 8.61524966076299802963944785005879e-01 1.57311439115006461778034640985879e-03
 	 8.61524966076299802963944785005879e-01 8.00104197314066567514601047150791e-03 1.57311439115006461778034640985879e-03
 	 8.00104197314066567514601047150791e-03 1.30473991950559503605333588893700e-01 1.57311439115006461778034640985879e-03
 	 2.00179308343867129460491582904069e-01 6.50781868302953165478230701523898e-03 1.62719887443376113288218132169050e-03
 	 6.50781868302953165478230701523898e-03 7.93312872973103377916004319558851e-01 1.62719887443376113288218132169050e-03
 	 7.93312872973103377916004319558851e-01 2.00179308343867129460491582904069e-01 1.62719887443376113288218132169050e-03
 	 3.07372363215433874739090924776974e-01 6.35240709459219433929977327579763e-03 1.86153289074892486741619190837582e-03
 	 6.35240709459219433929977327579763e-03 6.86275229689973897961863258387893e-01 1.86153289074892486741619190837582e-03
 	 6.86275229689973897961863258387893e-01 3.07372363215433874739090924776974e-01 1.86153289074892486741619190837582e-03
 	 2.76217326622710424022244524167036e-01 7.06370557783410402130641614348860e-01 2.15315736964076477263918540927534e-03
 	 7.06370557783410402130641614348860e-01 1.74121155938792293582650927419309e-02 2.15315736964076477263918540927534e-03
 	 1.74121155938792293582650927419309e-02 2.76217326622710424022244524167036e-01 2.15315736964076477263918540927534e-03
 	 4.22935483077426899178874464269029e-01 7.56275469533758924745026064329068e-03 2.26256707948115651576892481955383e-03
 	 7.56275469533758924745026064329068e-03 5.69501762227235475144482279574731e-01 2.26256707948115651576892481955383e-03
 	 5.69501762227235475144482279574731e-01 4.22935483077426899178874464269029e-01 2.26256707948115651576892481955383e-03
 	 4.53227003366671432615930825704709e-01 5.38998045885384025055486745259259e-01 2.28124961065890403608125147627561e-03
 	 5.38998045885384025055486745259259e-01 7.77495074794454232858242903603241e-03 2.28124961065890403608125147627561e-03
 	 7.77495074794454232858242903603241e-03 4.53227003366671432615930825704709e-01 2.28124961065890403608125147627561e-03
 	 1.90195202693624082490586602034455e-01 7.84036511910398581370884585339809e-01 2.34013831030492700652212434420107e-03
 	 7.84036511910398581370884585339809e-01 2.57682853959773083829531969968230e-02 2.34013831030492700652212434420107e-03
 	 2.57682853959773083829531969968230e-02 1.90195202693624082490586602034455e-01 2.34013831030492700652212434420107e-03
 	 3.61718299806125034856485456202790e-02 8.44564005292429142990329182794085e-02 2.82027799077192147664261412387532e-03
 	 8.44564005292429142990329182794085e-02 8.79371769490144616909788055636454e-01 2.82027799077192147664261412387532e-03
 	 8.79371769490144616909788055636454e-01 3.61718299806125034856485456202790e-02 2.82027799077192147664261412387532e-03
 	 7.60794388659036535660362687849556e-02 4.05076326129555214228261661446595e-02 2.88921152538740375753656408619463e-03
 	 4.05076326129555214228261661446595e-02 8.83412928521140838888925372884842e-01 2.88921152538740375753656408619463e-03
 	 8.83412928521140838888925372884842e-01 7.60794388659036535660362687849556e-02 2.88921152538740375753656408619463e-03
 	 1.49945977487857845522611910382693e-01 3.58350589330340557614462682067824e-02 3.28957067535762346516259313489172e-03
 	 3.58350589330340557614462682067824e-02 8.14218963579108057082578397967154e-01 3.28957067535762346516259313489172e-03
 	 8.14218963579108057082578397967154e-01 1.49945977487857845522611910382693e-01 3.28957067535762346516259313489172e-03
 	 1.50955341179002944240750139215379e-01 7.96913702682935043419831799837993e-01 3.36482658292138088473866019967318e-03
 	 7.96913702682935043419831799837993e-01 5.21309561380619568282668296888005e-02 3.36482658292138088473866019967318e-03
 	 5.21309561380619568282668296888005e-02 1.50955341179002944240750139215379e-01 3.36482658292138088473866019967318e-03
 	 2.44783310976574935979854785728094e-01 3.26897799308286454711414137364045e-02 3.78777121793418512785134311116053e-03
 	 3.26897799308286454711414137364045e-02 7.22526909092596425487897704442730e-01 3.78777121793418512785134311116053e-03
 	 7.22526909092596425487897704442730e-01 2.44783310976574935979854785728094e-01 3.78777121793418512785134311116053e-03
 	 1.70674433667943242776132706239878e-01 7.87558693381886776307965192245319e-02 4.07291752316681424095357044734556e-03
 	 7.87558693381886776307965192245319e-02 7.50569696993868107348646390164504e-01 4.07291752316681424095357044734556e-03
 	 7.50569696993868107348646390164504e-01 1.70674433667943242776132706239878e-01 4.07291752316681424095357044734556e-03
 	 3.71942611691943147977923445068882e-01 5.93428569491770030452926221187226e-01 4.54091761981328164571314331965368e-03
 	 5.93428569491770030452926221187226e-01 3.46288188162868770803015650017187e-02 4.54091761981328164571314331965368e-03
 	 3.46288188162868770803015650017187e-02 3.71942611691943147977923445068882e-01 4.54091761981328164571314331965368e-03
 	 3.51792010432223745119983959739329e-01 3.63528731441380772992921777131414e-02 4.70044765215418044318473889120469e-03
 	 3.63528731441380772992921777131414e-02 6.11855116423638212275193382083671e-01 4.70044765215418044318473889120469e-03
 	 6.11855116423638212275193382083671e-01 3.51792010432223745119983959739329e-01 4.70044765215418044318473889120469e-03
 	 9.84400611472149716929536111820198e-02 9.69591386055578818847777711198432e-02 4.76200227203537641840203065157766e-03
 	 9.69591386055578818847777711198432e-02 8.04600800247227132544480809883680e-01 4.76200227203537641840203065157766e-03
 	 8.04600800247227132544480809883680e-01 9.84400611472149716929536111820198e-02 4.76200227203537641840203065157766e-03
 	 2.60865026298107871571829718959634e-01 6.84089653184228985161041691753780e-01 5.05360407263360893181936006612887e-03
 	 6.84089653184228985161041691753780e-01 5.50453205176631987782798205444124e-02 5.05360407263360893181936006612887e-03
 	 5.50453205176631987782798205444124e-02 2.60865026298107871571829718959634e-01 5.05360407263360893181936006612887e-03
 	 3.66582144327067316336155045064515e-01 5.50781902551756963326567984040594e-01 5.42956340385742069337693394004418e-03
 	 5.50781902551756963326567984040594e-01 8.26359531211756648261257396370638e-02 5.42956340385742069337693394004418e-03
 	 8.26359531211756648261257396370638e-02 3.66582144327067316336155045064515e-01 5.42956340385742069337693394004418e-03
 	 4.68735987743839010999380434441264e-01 4.11368221710290485337857546710438e-02 5.58449209314384412833343063198299e-03
 	 4.11368221710290485337857546710438e-02 4.90127190085131891894576483537094e-01 5.58449209314384412833343063198299e-03
 	 4.90127190085131891894576483537094e-01 4.68735987743839010999380434441264e-01 5.58449209314384412833343063198299e-03
 	 2.57617931613541240043474545018398e-01 8.24865172853232742067319804846193e-02 5.88614843261607567637128113346989e-03
 	 8.24865172853232742067319804846193e-02 6.59895551101135513505369090125896e-01 5.88614843261607567637128113346989e-03
 	 6.59895551101135513505369090125896e-01 2.57617931613541240043474545018398e-01 5.88614843261607567637128113346989e-03
 	 1.84517952412833835529326620417123e-01 7.12575925803732079799601706326939e-01 6.07120200423857687282991335564475e-03
 	 7.12575925803732079799601706326939e-01 1.02906121783434056915496057627024e-01 6.07120200423857687282991335564475e-03
 	 1.02906121783434056915496057627024e-01 1.84517952412833835529326620417123e-01 6.07120200423857687282991335564475e-03
 	 2.81209118651227718554963530550594e-01 6.05257308197521104453642237785971e-01 6.27634946334984338001117265548601e-03
 	 6.05257308197521104453642237785971e-01 1.13533573151251121480243000405608e-01 6.27634946334984338001117265548601e-03
 	 1.13533573151251121480243000405608e-01 2.81209118651227718554963530550594e-01 6.27634946334984338001117265548601e-03
 	 1.73591491675633341484896732254128e-01 1.42209318699190873092064180127636e-01 6.39072063804919411611482615853674e-03
 	 1.42209318699190873092064180127636e-01 6.84199189625175785423039087618235e-01 6.39072063804919411611482615853674e-03
 	 6.84199189625175785423039087618235e-01 1.73591491675633341484896732254128e-01 6.39072063804919411611482615853674e-03
 	 4.42362027995821582848634534457233e-01 4.54988327657975588635963504202664e-01 6.62342069381232582264695807339194e-03
 	 4.54988327657975588635963504202664e-01 1.02649644346202828515401961340103e-01 6.62342069381232582264695807339194e-03
 	 1.02649644346202828515401961340103e-01 4.42362027995821582848634534457233e-01 6.62342069381232582264695807339194e-03
 	 3.59368226555797587451479557785206e-01 9.07953156997939186956259050020890e-02 6.91412078175607583419015611525538e-03
 	 9.07953156997939186956259050020890e-02 5.49836457744408479975106729398249e-01 6.91412078175607583419015611525538e-03
 	 5.49836457744408479975106729398249e-01 3.59368226555797587451479557785206e-01 6.91412078175607583419015611525538e-03
 	 1.82134268926742365346527208203042e-01 2.28667042140729831478651590259688e-01 7.96410608107515731457493046718810e-03
 	 2.28667042140729831478651590259688e-01 5.89198688932527803174821201537270e-01 7.96410608107515731457493046718810e-03
 	 5.89198688932527803174821201537270e-01 1.82134268926742365346527208203042e-01 7.96410608107515731457493046718810e-03
 	 2.67343042736282066051956007868284e-01 1.56184413818651390837288772672764e-01 8.37297856925192478250163929942573e-03
 	 1.56184413818651390837288772672764e-01 5.76472543445066598621906450716779e-01 8.37297856925192478250163929942573e-03
 	 5.76472543445066598621906450716779e-01 2.67343042736282066051956007868284e-01 8.37297856925192478250163929942573e-03
 	 3.65290320906562715475018876531976e-01 1.73792802318537387140651162553695e-01 9.38730527689661531365317159725237e-03
 	 1.73792802318537387140651162553695e-01 4.60916876774899841873178729656502e-01 9.38730527689661531365317159725237e-03
 	 4.60916876774899841873178729656502e-01 3.65290320906562715475018876531976e-01 9.38730527689661531365317159725237e-03
 	 3.45064826601384877502454173736623e-01 4.82299125389173410916043849283597e-01 9.86900254009348727735062567489877e-03
 	 4.82299125389173410916043849283597e-01 1.72636048009441656070350745721953e-01 9.86900254009348727735062567489877e-03
 	 1.72636048009441656070350745721953e-01 3.45064826601384877502454173736623e-01 9.86900254009348727735062567489877e-03
 	 2.65562227862875310790968796936795e-01 2.56802629703844209618779359516338e-01 1.01431421793431401218166243438645e-02
 	 2.56802629703844209618779359516338e-01 4.77635142433280479590251843546866e-01 1.01431421793431401218166243438645e-02
 	 4.77635142433280479590251843546866e-01 2.65562227862875310790968796936795e-01 1.01431421793431401218166243438645e-02
 	 3.62956385501777445412585620942991e-01 3.71550947373690598762863146475866e-01 1.08126717889738110239816748503472e-02
 	 3.71550947373690598762863146475866e-01 2.65492667124531955824551232581143e-01 1.08126717889738110239816748503472e-02
 	 2.65492667124531955824551232581143e-01 3.62956385501777445412585620942991e-01 1.08126717889738110239816748503472e-02
 	 ];
 
 	 case  26 

 	 % ALG. DEG.:   26
 	 % PTS CARD.:  130
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.0e-15  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.02433312946116142350128086491168e-02
 	 6.67371225764660652712834121302876e-02 6.67371225764660652712834121302876e-02 2.45691265148300762993782697662937e-03
 	 6.67371225764660652712834121302876e-02 8.66525754847067841701857560110511e-01 2.45691265148300762993782697662937e-03
 	 8.66525754847067841701857560110511e-01 6.67371225764660652712834121302876e-02 2.45691265148300762993782697662937e-03
 	 6.34011649207668302741236487918286e-03 6.34011649207668302741236487918286e-03 2.63476558340935778333713468413180e-04
 	 6.34011649207668302741236487918286e-03 9.87319767015846672109091741731390e-01 2.63476558340935778333713468413180e-04
 	 9.87319767015846672109091741731390e-01 6.34011649207668302741236487918286e-03 2.63476558340935778333713468413180e-04
 	 4.93753032896384780325860219818424e-01 4.93753032896384780325860219818424e-01 2.65107959093367154951303987786559e-03
 	 4.93753032896384780325860219818424e-01 1.24939342072304393482795603631530e-02 2.65107959093367154951303987786559e-03
 	 1.24939342072304393482795603631530e-02 4.93753032896384780325860219818424e-01 2.65107959093367154951303987786559e-03
 	 3.88787497107593971179539948934689e-01 3.88787497107593971179539948934689e-01 9.73403391859143339581716958264224e-03
 	 3.88787497107593971179539948934689e-01 2.22425005784812057640920102130622e-01 9.73403391859143339581716958264224e-03
 	 2.22425005784812057640920102130622e-01 3.88787497107593971179539948934689e-01 9.73403391859143339581716958264224e-03
 	 2.73147100929078678888117792666890e-01 2.73147100929078678888117792666890e-01 9.76782346162376538534211078967928e-03
 	 2.73147100929078678888117792666890e-01 4.53705798141842642223764414666221e-01 9.76782346162376538534211078967928e-03
 	 4.53705798141842642223764414666221e-01 2.73147100929078678888117792666890e-01 9.76782346162376538534211078967928e-03
 	 4.71828563321166016830687794936239e-01 4.71828563321166016830687794936239e-01 5.76425181732844339049792736773270e-03
 	 4.71828563321166016830687794936239e-01 5.63428733576679663386244101275224e-02 5.76425181732844339049792736773270e-03
 	 5.63428733576679663386244101275224e-02 4.71828563321166016830687794936239e-01 5.76425181732844339049792736773270e-03
 	 1.54201430364544173068352961308847e-01 1.54201430364544173068352961308847e-01 6.62762972427263091779181536367105e-03
 	 1.54201430364544173068352961308847e-01 6.91597139270911709374445308640134e-01 6.62762972427263091779181536367105e-03
 	 6.91597139270911709374445308640134e-01 1.54201430364544173068352961308847e-01 6.62762972427263091779181536367105e-03
 	 2.12043163302205517339871221338399e-01 2.12043163302205517339871221338399e-01 8.47217253926404144370732041124938e-03
 	 2.12043163302205517339871221338399e-01 5.75913673395588965320257557323202e-01 8.47217253926404144370732041124938e-03
 	 5.75913673395588965320257557323202e-01 2.12043163302205517339871221338399e-01 8.47217253926404144370732041124938e-03
 	 4.35985419384383177110464657744160e-01 4.35985419384383177110464657744160e-01 8.20620030129394668894082798260570e-03
 	 4.35985419384383177110464657744160e-01 1.28029161231233645779070684511680e-01 8.20620030129394668894082798260570e-03
 	 1.28029161231233645779070684511680e-01 4.35985419384383177110464657744160e-01 8.20620030129394668894082798260570e-03
 	 8.00716549403165389620085079513956e-02 4.79466097543667854607996048343921e-03 6.99263224080135621305021054183726e-04
 	 8.00716549403165389620085079513956e-02 9.15133684084246779022464579611551e-01 6.99263224080135621305021054183726e-04
 	 4.79466097543667854607996048343921e-03 8.00716549403165389620085079513956e-02 6.99263224080135621305021054183726e-04
 	 4.79466097543667854607996048343921e-03 9.15133684084246779022464579611551e-01 6.99263224080135621305021054183726e-04
 	 9.15133684084246779022464579611551e-01 8.00716549403165389620085079513956e-02 6.99263224080135621305021054183726e-04
 	 9.15133684084246779022464579611551e-01 4.79466097543667854607996048343921e-03 6.99263224080135621305021054183726e-04
 	 3.16436115715307691997892902691092e-02 2.91551962068358448687543926780563e-02 6.02782386858442364822863179796286e-04
 	 3.16436115715307691997892902691092e-02 9.39201192221633451850948404171504e-01 6.02782386858442364822863179796286e-04
 	 2.91551962068358448687543926780563e-02 3.16436115715307691997892902691092e-02 6.02782386858442364822863179796286e-04
 	 2.91551962068358448687543926780563e-02 9.39201192221633451850948404171504e-01 6.02782386858442364822863179796286e-04
 	 9.39201192221633451850948404171504e-01 3.16436115715307691997892902691092e-02 6.02782386858442364822863179796286e-04
 	 9.39201192221633451850948404171504e-01 2.91551962068358448687543926780563e-02 6.02782386858442364822863179796286e-04
 	 7.53800475153986598852995371089492e-02 2.62093640224986615394620059760200e-02 1.65277235648383404031935839384460e-03
 	 7.53800475153986598852995371089492e-02 8.98410588462102754903071399894543e-01 1.65277235648383404031935839384460e-03
 	 2.62093640224986615394620059760200e-02 7.53800475153986598852995371089492e-02 1.65277235648383404031935839384460e-03
 	 2.62093640224986615394620059760200e-02 8.98410588462102754903071399894543e-01 1.65277235648383404031935839384460e-03
 	 8.98410588462102754903071399894543e-01 7.53800475153986598852995371089492e-02 1.65277235648383404031935839384460e-03
 	 8.98410588462102754903071399894543e-01 2.62093640224986615394620059760200e-02 1.65277235648383404031935839384460e-03
 	 3.31000343360322718533339525492920e-02 5.69811791687521804888882925865801e-03 5.42853671498377018771186452994471e-04
 	 3.31000343360322718533339525492920e-02 9.61201847747092497087351148365997e-01 5.42853671498377018771186452994471e-04
 	 5.69811791687521804888882925865801e-03 3.31000343360322718533339525492920e-02 5.42853671498377018771186452994471e-04
 	 5.69811791687521804888882925865801e-03 9.61201847747092497087351148365997e-01 5.42853671498377018771186452994471e-04
 	 9.61201847747092497087351148365997e-01 3.31000343360322718533339525492920e-02 5.42853671498377018771186452994471e-04
 	 9.61201847747092497087351148365997e-01 5.69811791687521804888882925865801e-03 5.42853671498377018771186452994471e-04
 	 1.32486189614567290151470047021576e-01 4.17247227421209468389839969404420e-02 3.20179894985640712753993675221409e-03
 	 1.32486189614567290151470047021576e-01 8.25789087643311825459591091203038e-01 3.20179894985640712753993675221409e-03
 	 4.17247227421209468389839969404420e-02 1.32486189614567290151470047021576e-01 3.20179894985640712753993675221409e-03
 	 4.17247227421209468389839969404420e-02 8.25789087643311825459591091203038e-01 3.20179894985640712753993675221409e-03
 	 8.25789087643311825459591091203038e-01 1.32486189614567290151470047021576e-01 3.20179894985640712753993675221409e-03
 	 8.25789087643311825459591091203038e-01 4.17247227421209468389839969404420e-02 3.20179894985640712753993675221409e-03
 	 1.08687132914402101446782467064622e-01 1.00045659106527559667476623417315e-01 2.30710553818915756890683965707467e-03
 	 1.08687132914402101446782467064622e-01 7.91267207979070352763528717332520e-01 2.30710553818915756890683965707467e-03
 	 1.00045659106527559667476623417315e-01 1.08687132914402101446782467064622e-01 2.30710553818915756890683965707467e-03
 	 1.00045659106527559667476623417315e-01 7.91267207979070352763528717332520e-01 2.30710553818915756890683965707467e-03
 	 7.91267207979070352763528717332520e-01 1.08687132914402101446782467064622e-01 2.30710553818915756890683965707467e-03
 	 7.91267207979070352763528717332520e-01 1.00045659106527559667476623417315e-01 2.30710553818915756890683965707467e-03
 	 2.50272313290526460249907358956989e-01 1.20614402205249035548995095723512e-01 7.18973661379936589133077262658844e-03
 	 2.50272313290526460249907358956989e-01 6.29113284504224545834460968762869e-01 7.18973661379936589133077262658844e-03
 	 1.20614402205249035548995095723512e-01 2.50272313290526460249907358956989e-01 7.18973661379936589133077262658844e-03
 	 1.20614402205249035548995095723512e-01 6.29113284504224545834460968762869e-01 7.18973661379936589133077262658844e-03
 	 6.29113284504224545834460968762869e-01 2.50272313290526460249907358956989e-01 7.18973661379936589133077262658844e-03
 	 6.29113284504224545834460968762869e-01 1.20614402205249035548995095723512e-01 7.18973661379936589133077262658844e-03
 	 3.89022062042761740396912273354246e-01 2.95379425169078370372321984405062e-02 4.12988360854341703815029163138206e-03
 	 3.89022062042761740396912273354246e-01 5.81439995440330315013000017643208e-01 4.12988360854341703815029163138206e-03
 	 2.95379425169078370372321984405062e-02 3.89022062042761740396912273354246e-01 4.12988360854341703815029163138206e-03
 	 2.95379425169078370372321984405062e-02 5.81439995440330315013000017643208e-01 4.12988360854341703815029163138206e-03
 	 5.81439995440330315013000017643208e-01 3.89022062042761740396912273354246e-01 4.12988360854341703815029163138206e-03
 	 5.81439995440330315013000017643208e-01 2.95379425169078370372321984405062e-02 4.12988360854341703815029163138206e-03
 	 3.58509296427661550143994872996700e-01 8.73784651638445236665475590598362e-02 6.86397910804284645813755361132280e-03
 	 3.58509296427661550143994872996700e-01 5.54112238408493995578396607015748e-01 6.86397910804284645813755361132280e-03
 	 8.73784651638445236665475590598362e-02 3.58509296427661550143994872996700e-01 6.86397910804284645813755361132280e-03
 	 8.73784651638445236665475590598362e-02 5.54112238408493995578396607015748e-01 6.86397910804284645813755361132280e-03
 	 5.54112238408493995578396607015748e-01 3.58509296427661550143994872996700e-01 6.86397910804284645813755361132280e-03
 	 5.54112238408493995578396607015748e-01 8.73784651638445236665475590598362e-02 6.86397910804284645813755361132280e-03
 	 1.86869179476221558555693036396406e-01 7.63119015129594124857703718589619e-02 5.19882276408715864046694576927621e-03
 	 1.86869179476221558555693036396406e-01 7.36818919010818973447385360486805e-01 5.19882276408715864046694576927621e-03
 	 7.63119015129594124857703718589619e-02 1.86869179476221558555693036396406e-01 5.19882276408715864046694576927621e-03
 	 7.63119015129594124857703718589619e-02 7.36818919010818973447385360486805e-01 5.19882276408715864046694576927621e-03
 	 7.36818919010818973447385360486805e-01 1.86869179476221558555693036396406e-01 5.19882276408715864046694576927621e-03
 	 7.36818919010818973447385360486805e-01 7.63119015129594124857703718589619e-02 5.19882276408715864046694576927621e-03
 	 4.14705909590306287526573214563541e-01 2.05753096537086583445175236306568e-03 9.28573735499041365455685781427064e-04
 	 4.14705909590306287526573214563541e-01 5.83236559444322844036889819108183e-01 9.28573735499041365455685781427064e-04
 	 2.05753096537086583445175236306568e-03 4.14705909590306287526573214563541e-01 9.28573735499041365455685781427064e-04
 	 2.05753096537086583445175236306568e-03 5.83236559444322844036889819108183e-01 9.28573735499041365455685781427064e-04
 	 5.83236559444322844036889819108183e-01 4.14705909590306287526573214563541e-01 9.28573735499041365455685781427064e-04
 	 5.83236559444322844036889819108183e-01 2.05753096537086583445175236306568e-03 9.28573735499041365455685781427064e-04
 	 3.19415305383438707931276212548255e-01 1.70478728497248960271903683860728e-01 8.79958359034759864114594307693551e-03
 	 3.19415305383438707931276212548255e-01 5.10105966119312248530093256704276e-01 8.79958359034759864114594307693551e-03
 	 1.70478728497248960271903683860728e-01 3.19415305383438707931276212548255e-01 8.79958359034759864114594307693551e-03
 	 1.70478728497248960271903683860728e-01 5.10105966119312248530093256704276e-01 8.79958359034759864114594307693551e-03
 	 5.10105966119312248530093256704276e-01 3.19415305383438707931276212548255e-01 8.79958359034759864114594307693551e-03
 	 5.10105966119312248530093256704276e-01 1.70478728497248960271903683860728e-01 8.79958359034759864114594307693551e-03
 	 1.43737626199764018108950835994619e-01 7.99960809148430283810338181638144e-03 1.48338083132825175255997685042075e-03
 	 1.43737626199764018108950835994619e-01 8.48262765708751698134904017933877e-01 1.48338083132825175255997685042075e-03
 	 7.99960809148430283810338181638144e-03 1.43737626199764018108950835994619e-01 1.48338083132825175255997685042075e-03
 	 7.99960809148430283810338181638144e-03 8.48262765708751698134904017933877e-01 1.48338083132825175255997685042075e-03
 	 8.48262765708751698134904017933877e-01 1.43737626199764018108950835994619e-01 1.48338083132825175255997685042075e-03
 	 8.48262765708751698134904017933877e-01 7.99960809148430283810338181638144e-03 1.48338083132825175255997685042075e-03
 	 2.83788138859470406849538903770735e-01 5.11658736851377873855462041774445e-02 5.05356221604433969440961504915322e-03
 	 2.83788138859470406849538903770735e-01 6.65045987455391784948233180330135e-01 5.05356221604433969440961504915322e-03
 	 5.11658736851377873855462041774445e-02 2.83788138859470406849538903770735e-01 5.05356221604433969440961504915322e-03
 	 5.11658736851377873855462041774445e-02 6.65045987455391784948233180330135e-01 5.05356221604433969440961504915322e-03
 	 6.65045987455391784948233180330135e-01 2.83788138859470406849538903770735e-01 5.05356221604433969440961504915322e-03
 	 6.65045987455391784948233180330135e-01 5.11658736851377873855462041774445e-02 5.05356221604433969440961504915322e-03
 	 2.16546666473477117387247403712536e-01 2.27845992508956714239776175645602e-02 3.13466892304028240529012450110713e-03
 	 2.16546666473477117387247403712536e-01 7.60668734275627200780434122862061e-01 3.13466892304028240529012450110713e-03
 	 2.27845992508956714239776175645602e-02 2.16546666473477117387247403712536e-01 3.13466892304028240529012450110713e-03
 	 2.27845992508956714239776175645602e-02 7.60668734275627200780434122862061e-01 3.13466892304028240529012450110713e-03
 	 7.60668734275627200780434122862061e-01 2.16546666473477117387247403712536e-01 3.13466892304028240529012450110713e-03
 	 7.60668734275627200780434122862061e-01 2.27845992508956714239776175645602e-02 3.13466892304028240529012450110713e-03
 	 3.12898503074879985597078757564304e-01 9.47329791221356194708125286751965e-03 2.29577919369931739840273721142694e-03
 	 3.12898503074879985597078757564304e-01 6.77628199012906495823926888988353e-01 2.29577919369931739840273721142694e-03
 	 9.47329791221356194708125286751965e-03 3.12898503074879985597078757564304e-01 2.29577919369931739840273721142694e-03
 	 9.47329791221356194708125286751965e-03 6.77628199012906495823926888988353e-01 2.29577919369931739840273721142694e-03
 	 6.77628199012906495823926888988353e-01 3.12898503074879985597078757564304e-01 2.29577919369931739840273721142694e-03
 	 6.77628199012906495823926888988353e-01 9.47329791221356194708125286751965e-03 2.29577919369931739840273721142694e-03
 	 2.26434797407717519623915336524078e-01 4.64007732175652793521480887761754e-04 5.69774457934106321604916800538376e-04
 	 2.26434797407717519623915336524078e-01 7.73101194860106755157858060556464e-01 5.69774457934106321604916800538376e-04
 	 4.64007732175652793521480887761754e-04 2.26434797407717519623915336524078e-01 5.69774457934106321604916800538376e-04
 	 4.64007732175652793521480887761754e-04 7.73101194860106755157858060556464e-01 5.69774457934106321604916800538376e-04
 	 7.73101194860106755157858060556464e-01 2.26434797407717519623915336524078e-01 5.69774457934106321604916800538376e-04
 	 7.73101194860106755157858060556464e-01 4.64007732175652793521480887761754e-04 5.69774457934106321604916800538376e-04
 	 ];
 
 	 case  27 

 	 % ALG. DEG.:   27
 	 % PTS CARD.:  141
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.8e-16  

 	 xyw=[
 	 3.80714021181187134423851148312679e-01 3.80714021181187134423851148312679e-01 4.78004248372990679649685574759133e-03
 	 3.80714021181187134423851148312679e-01 2.38571957637625731152297703374643e-01 4.78004248372997531807415683147156e-03
 	 2.38571957637625731152297703374643e-01 3.80714021181187134423851148312679e-01 4.78004248372997011390372890105027e-03
 	 4.46667803703864552122837494607666e-01 4.46667803703864774167442419638974e-01 4.70507990472707714191269445791477e-03
 	 4.46667803703864552122837494607666e-01 1.06664392592270895754325010784669e-01 4.70507990472709882595614416800345e-03
 	 1.06664392592270895754325010784669e-01 4.46667803703864552122837494607666e-01 4.70507990472715433710737542583047e-03
 	 4.16141378805413242325528244691668e-01 4.16141378805411299435235150667722e-01 6.02511351207514912059481915207471e-03
 	 4.16141378805412576191713469597744e-01 1.67717242389175152927904832722561e-01 6.02511351207520636646952638670882e-03
 	 1.67717242389176068861900148476707e-01 4.16141378805410411256815450542490e-01 6.02511351207521504008690627074429e-03
 	 8.03046477884383352874309025537514e-02 8.03046477884382658984918634814676e-02 2.60631093640092612040426445219055e-03
 	 8.03046477884410553338412341872754e-02 8.39390704423123579225318735552719e-01 2.60631093640086540508260526394224e-03
 	 8.39390704423123246158411348005757e-01 8.03046477884383075318552869248379e-02 2.60631093640093869714946528404198e-03
 	 2.33400406669872106935059719035053e-01 2.33400406669869830977859237464145e-01 6.73565769902463064300324191435720e-03
 	 2.33400406669872523268693953468755e-01 5.33199186660256008174485486961203e-01 6.73565769902485008552295298045465e-03
 	 5.33199186660257451464417499664705e-01 2.33400406669870968956459478249599e-01 6.73565769902468094998404524176294e-03
 	 3.01165465166508772298925578070339e-01 3.01165465166509827010798971969052e-01 7.87398289068132195556160013438785e-03
 	 3.01165465166508494743169421781204e-01 3.97669069666983177047114850211074e-01 7.87398289068136705837197553137230e-03
 	 3.97669069666981012112216831155820e-01 3.01165465166509882521950203226879e-01 7.87398289068132542500855208800203e-03
 	 1.74779966354899923830501506927249e-01 1.74779966354900007097228353813989e-01 5.64122127234913985083242238260937e-03
 	 1.74779966354901311609282288372924e-01 6.50440067290198764560216204699827e-01 5.64122127234928643496614242280884e-03
 	 6.50440067290199874783240829856368e-01 1.74779966354900617719891897650086e-01 5.64122127234918929045148772161156e-03
 	 4.85565054185162214839266425769893e-01 4.85565054185163602618047207215568e-01 3.55861870643729661864429480999661e-03
 	 4.85565054185162603417325044574682e-01 2.88698916296747827570090549897941e-02 3.55861870643735603292334701563959e-03
 	 2.88698916296740264175735291019009e-02 4.85565054185165267952584144950379e-01 3.55861870643732003741122049689238e-03
 	 3.25715201801815776305737415441399e-02 3.25715201801815984472554532658251e-02 1.38866976447709288521037418462356e-03
 	 3.25715201801813555859688165128318e-02 9.34856959639637219439123327902053e-01 1.38866976447708226002908382668011e-03
 	 9.34856959639636775349913477839436e-01 3.25715201801817164084518196887075e-02 1.38866976447709483677428465853154e-03
 	 1.27570901904677180827007987318211e-01 1.27570901904678513094637537506060e-01 4.87162246140886070339126590056367e-03
 	 1.27570901904677569405066606123000e-01 7.44858196190645083234471712785307e-01 4.87162246140887544854081170342397e-03
 	 7.44858196190644861189866787753999e-01 1.27570901904677874716398378041049e-01 4.87162246140886764228516980779204e-03
 	 6.63921918095874714210724576446410e-03 6.63921918095869856984991841386545e-03 2.87721202835248982074972667888346e-04
 	 6.63921918095874454002203179925345e-03 9.86721561638082556022766311798478e-01 2.87721202835251258899534887447658e-04
 	 9.86721561638082667045068774314132e-01 6.63921918095871418236120220512930e-03 2.87721202835249795226602032016672e-04
 	 2.87042196593496612422313774004579e-01 3.07306047272726499952621992406421e-02 2.76589741688335749580929245894367e-03
 	 2.87042196593496612422313774004579e-01 6.82227198679230650846250227914425e-01 2.76589741688331282667978605616099e-03
 	 3.07306047272729344899122594370056e-02 2.87042196593496612422313774004579e-01 2.76589741688342298162051058341149e-03
 	 3.07306047272735693987044669484021e-02 6.82227198679237978318212753947591e-01 2.76589741688350017681519155132719e-03
 	 6.82227198679230539823947765398771e-01 2.87042196593496501400011311488925e-01 2.76589741688339782813010891970862e-03
 	 6.82227198679230539823947765398771e-01 3.07306047272726812202847668231698e-02 2.76589741688335272531973352272416e-03
 	 3.45087841715567555933574794835295e-01 1.29152640063450174778836299083196e-01 6.27871810201830089781527277636997e-03
 	 3.45087841715569942913077738921857e-01 5.25759518220981325598017974698450e-01 6.27871810201817946717195439987336e-03
 	 1.29152640063449231089265367700136e-01 3.45087841715568111045087107413565e-01 6.27871810201825406028142140257842e-03
 	 1.29152640063449064555811673926655e-01 5.25759518220981436620320437214104e-01 6.27871810201825319291968341417487e-03
 	 5.25759518220981769687227824761067e-01 3.45087841715568888201204345023143e-01 6.27871810201821763108842588962943e-03
 	 5.25759518220982435821042599854991e-01 1.29152640063450147023260683454282e-01 6.27871810201830003045353478796642e-03
 	 3.75930157048661783836251970569720e-01 2.80334860952500333763914852625021e-02 3.19757634972721912353099682491120e-03
 	 3.75930157048661062191285964217968e-01 5.96036356856089133415821379458066e-01 3.19757634972717749016757338154093e-03
 	 2.80334860952498494957030317209501e-02 3.75930157048663338148486445788876e-01 3.19757634972721652144578285970056e-03
 	 2.80334860952496933705901938083116e-02 5.96036356856093019196407567505958e-01 3.19757634972729241559785684501094e-03
 	 5.96036356856087579103586904238909e-01 3.75930157048662505481217976921471e-01 3.19757634972720914887100995827041e-03
 	 5.96036356856088134215099216817180e-01 2.80334860952501097042244282420143e-02 3.19757634972721912353099682491120e-03
 	 3.16945588933132571529682763866731e-01 2.09130921137669179010742936952738e-01 6.85769661527540173862060868259505e-03
 	 3.16945588933134181353068470343715e-01 4.73923489929198582526481686727493e-01 6.85769661527534015593721150594320e-03
 	 2.09130921137668818188259933776862e-01 3.16945588933130517617087207327131e-01 6.85769661527545898449531591722916e-03
 	 2.09130921137667263876025458557706e-01 4.73923489929199581727203849368379e-01 6.85769661527539046291801483334893e-03
 	 4.73923489929199137637993999305763e-01 3.16945588933131960907019220030634e-01 6.85769661527542862683448632310501e-03
 	 4.73923489929198471504179224211839e-01 2.09130921137669234521894168210565e-01 6.85769661527541561640841649705180e-03
 	 4.07228393042719349903535430712509e-01 6.60389128497390898164809414083720e-02 4.93113505949480026430142842741589e-03
 	 4.07228393042719960526198974548606e-01 5.26732694107541865591315399797168e-01 4.93113505949475863093800498404562e-03
 	 6.60389128497382571492124725409667e-02 4.07228393042721403816130987252109e-01 4.93113505949478465179014463615204e-03
 	 6.60389128497380351046075475096586e-02 5.26732694107542753769735099922400e-01 4.93113505949479419276926250859105e-03
 	 5.26732694107540644345988312124973e-01 4.07228393042720793193467443416012e-01 4.93113505949477684553450274052011e-03
 	 5.26732694107541532524408012250206e-01 6.60389128497391314498443648517423e-02 4.93113505949480026430142842741589e-03
 	 2.13553598457823901046737091746763e-01 4.10305768191819505985584726204252e-02 3.22768645246485769151334466187109e-03
 	 2.13553598457824983514186101274390e-01 7.45415824722993392015268909744918e-01 3.22768645246482343072469411993097e-03
 	 4.10305768191816105927571811662347e-02 2.13553598457823234912922316652839e-01 3.22768645246482516544817009673807e-03
 	 4.10305768191830053104318665191386e-02 7.45415824722999609264206810621545e-01 3.22768645246473235774220533755852e-03
 	 7.45415824722994613260595997417113e-01 2.13553598457823651246556551086542e-01 3.22768645246482169600121814312388e-03
 	 7.45415824722993947126781222323189e-01 4.10305768191819297818767608987400e-02 3.22768645246486853353506951691543e-03
 	 3.28852878068892851004534350067843e-01 5.29964037179900433749413224404634e-03 1.46391318089954844232358777134095e-03
 	 3.28852878068891962826114649942610e-01 6.65847481559309062326690309419064e-01 1.46391318089954193711055285831435e-03
 	 5.29964037179904423613407971060951e-03 3.28852878068892295893022037489573e-01 1.46391318089956427167530605970569e-03
 	 5.29964037179900693957934620925698e-03 6.65847481559309506415900159481680e-01 1.46391318089955538121749167856933e-03
 	 6.65847481559308063125968146778177e-01 3.28852878068892851004534350067843e-01 1.46391318089956492219660955100835e-03
 	 6.65847481559308063125968146778177e-01 5.29964037179901908264367804690664e-03 1.46391318089955061072793274234982e-03
 	 1.39295306142148439532135739682417e-01 6.30739954149516918180395919080183e-02 3.56531765524351800314417637594033e-03
 	 1.39295306142150382422428833706363e-01 7.97630698442899022104768391727703e-01 3.56531765524344904788600629785833e-03
 	 6.30739954149508869063467386695265e-02 1.39295306142148717087891895971552e-01 3.56531765524351540105896241072969e-03
 	 6.30739954149510811953760480719211e-02 7.97630698442904129130681667447789e-01 3.56531765524351106425027246871196e-03
 	 7.97630698442900243350095479399897e-01 1.39295306142148994643648052260687e-01 3.56531765524351843682504537014211e-03
 	 7.97630698442900465394700404431205e-01 6.30739954149509424174979699273536e-02 3.56531765524351496737809341652792e-03
 	 2.55246254696977592502094012161251e-01 1.48962850938239937947926705419377e-01 6.17383156543062534826749043759264e-03
 	 2.55246254696979923970445724989986e-01 5.95790894364780276859505647735205e-01 6.17383156543068866567436359105159e-03
 	 1.48962850938240493059439017997647e-01 2.55246254696977592502094012161251e-01 6.17383156543070080873869542870125e-03
 	 1.48962850938240187748107246079599e-01 5.95790894364781498104832735407399e-01 6.17383156543076412614556858216019e-03
 	 5.95790894364780942993320422829129e-01 2.55246254696978758236269868575619e-01 6.17383156543069820665348146349061e-03
 	 5.95790894364782275260949973016977e-01 1.48962850938240409792712171110907e-01 6.17383156543066784899265186936645e-03
 	 2.08376015600373692970848082950397e-01 9.46970824331308386190286796590954e-02 5.34685029480811303131959633105907e-03
 	 2.08376015600374386860238473673235e-01 6.96926901966494760642945038853213e-01 5.34685029480813645008652201795485e-03
 	 9.46970824331302557519407514519116e-02 2.08376015600375219527506942540640e-01 5.34685029480814599106563989039387e-03
 	 9.46970824331309912746945656181197e-02 6.96926901966496092910574589041062e-01 5.34685029480815986885344770485062e-03
 	 6.96926901966494649620642576337559e-01 2.08376015600374914216175170622591e-01 5.34685029480815379732128178602579e-03
 	 6.96926901966495426776759813947137e-01 9.46970824331310467858457968759467e-02 5.34685029480812777646914213391938e-03
 	 4.40010551946215577867604906714405e-01 5.58071701526011588329057033774916e-03 1.62123379881968284615956221728084e-03
 	 4.40010551946214800711487669104827e-01 5.54408731038525171008757297386182e-01 1.62123379881966094527567801009127e-03
 	 5.58071701525999532000898994965610e-03 4.40010551946215411334151212940924e-01 1.62123379881965639162655357097265e-03
 	 5.58071701526001006515853575251640e-03 5.54408731038525171008757297386182e-01 1.62123379881965964423307102748595e-03
 	 5.54408731038524282830337597260950e-01 4.40010551946215799912209831745713e-01 1.62123379881965942739263653038506e-03
 	 5.54408731038524393852640059776604e-01 5.58071701526013149580185412901301e-03 1.62123379881968588192564517669325e-03
 	 3.02220941227820782959412326817983e-01 7.50769024331961326579332194341987e-02 5.46530554645664572166463557323368e-03
 	 3.02220941227821282559773408138426e-01 6.22702156338982737437959258386400e-01 5.46530554645662924179161379356628e-03
 	 7.50769024331959938800551412896311e-02 3.02220941227822226249344339521485e-01 5.46530554645663444596204172398757e-03
 	 7.50769024331963685803259522799635e-02 6.22702156338983514594076495995978e-01 5.46530554645665613000549143407625e-03
 	 6.22702156338981849259539558261167e-01 3.02220941227821948693588183232350e-01 5.46530554645663965013246965440885e-03
 	 6.22702156338983181527169108449016e-01 7.50769024331962714358112975787662e-02 5.46530554645665439528201545726915e-03
 	 8.19468025835337066098418290494010e-02 6.98252932445894529400742811731106e-03 1.00756156364484881007848038336761e-03
 	 8.19468025835336649764784056060307e-02 9.11070668092007429628154113743221e-01 1.00756156364483384808850008340642e-03
 	 6.98252932445898606000911357227778e-03 8.19468025835330959871782852133038e-02 1.00756156364485097848282535437647e-03
 	 6.98252932445910922537590792558149e-03 9.11070668092007540650456576258875e-01 1.00756156364486962676019210505274e-03
 	 9.11070668092007651672759038774529e-01 8.19468025835333874207222493168956e-02 1.00756156364485444792977730799066e-03
 	 9.11070668092007318605851651227567e-01 6.98252932445894442664569012890752e-03 1.00756156364484924375934937756938e-03
 	 3.43649699121420029723772415763960e-02 6.09356940376482372756505867528176e-03 5.98386804236582508370601019009882e-04
 	 3.43649699121420584835284728342231e-02 9.59541460684093183708398555609165e-01 5.98386804236578822083214568294807e-04
 	 6.09356940376478382892511120871859e-03 3.43649699121417254166210852872609e-02 5.98386804236574702114959123377957e-04
 	 6.09356940376473178722083190450576e-03 9.59541460684093294730701018124819e-01 5.98386804236573509492569389323080e-04
 	 9.59541460684093405753003480640473e-01 3.43649699121418225611357399884582e-02 5.98386804236577846301259331340816e-04
 	 9.59541460684093072686096093093511e-01 6.09356940376485148314067430419527e-03 5.98386804236585435716466729871854e-04
 	 8.01120738471011728520920769369695e-02 3.50344225276972565108479784612427e-02 2.16357901768035251754973558035999e-03
 	 8.01120738471009091741237284622912e-02 8.84853503625202431059904029098107e-01 2.16357901768029960848371828774361e-03
 	 3.50344225276974022276199605130387e-02 8.01120738471011867298798847514263e-02 2.16357901768034818074104563834226e-03
 	 3.50344225276981377503737746792467e-02 8.84853503625201098792274478910258e-01 2.16357901768039892140271795994977e-03
 	 8.84853503625201209814576941425912e-01 8.01120738471013948966970019682776e-02 2.16357901768035251754973558035999e-03
 	 8.84853503625201542881484328972874e-01 3.50344225276972634497418823684711e-02 2.16357901768035251754973558035999e-03
 	 1.47213431898922580964850226337148e-01 1.93520013180395883400919387895556e-02 2.31119355589056319627561109086855e-03
 	 1.47213431898922331164669685676927e-01 8.33434566783038399684357955266023e-01 2.31119355589056016050952813145614e-03
 	 1.93520013180388666951259324378043e-02 1.47213431898922081364489145016705e-01 2.31119355589054541535998232859583e-03
 	 1.93520013180379160666610971475166e-02 8.33434566783040176041197355516488e-01 2.31119355589054498167911333439406e-03
 	 8.33434566783038732751265342812985e-01 1.47213431898922497698123379450408e-01 2.31119355589054931848780327641180e-03
 	 8.33434566783038399684357955266023e-01 1.93520013180390089424509625359860e-02 2.31119355589056189523300410826323e-03
 	 2.29719653257843187121878258949437e-01 7.33247254904042990858448192170727e-03 1.69712686940351551584393874350098e-03
 	 2.29719653257842743032668408886821e-01 7.62947874193116826191385371203069e-01 1.69712686940351096219481430438236e-03
 	 7.33247254904039608147670037396892e-03 2.29719653257842659765941562000080e-01 1.69712686940350944431177282467615e-03
 	 7.33247254904046026624531151583142e-03 7.62947874193117381302897683781339e-01 1.69712686940351421480133176089566e-03
 	 7.62947874193116382102175521140452e-01 2.29719653257843242633029490207264e-01 1.69712686940351074535437980728148e-03
 	 7.62947874193116382102175521140452e-01 7.33247254904043511275490985212855e-03 1.69712686940351573268437324060187e-03
 	 1.47655521119869653778877705008199e-01 4.90328443463460125414932200271778e-04 4.23303067881970697308030571193171e-04
 	 1.47655521119869542756575242492545e-01 8.51854150436667345580588062148308e-01 4.23303067881939960176440607142467e-04
 	 4.90328443462847009086391647514347e-04 1.47655521119868987645062929914275e-01 4.23303067881921745579942850667976e-04
 	 4.90328443461913619436098876747110e-04 8.51854150436668899892822537367465e-01 4.23303067881843845653849767174393e-04
 	 8.51854150436667678647495449695271e-01 1.47655521119869515000999626863631e-01 4.23303067881917408771252908650240e-04
 	 8.51854150436667345580588062148308e-01 4.90328443462949249351257030582474e-04 4.23303067881928576053629509345910e-04
 	 ];
 
 	 case  28 

 	 % ALG. DEG.:   28
 	 % PTS CARD.:  150
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw=[
 	 3.03982922516484066477460146415979e-01 3.03982922516484066477460146415979e-01 7.18123315032306776956039229276030e-03
 	 3.03982922516484066477460146415979e-01 3.92034154967031867045079707168043e-01 7.18123315032306776956039229276030e-03
 	 3.92034154967031867045079707168043e-01 3.03982922516484066477460146415979e-01 7.18123315032306776956039229276030e-03
 	 4.80412619665786157913123233242914e-03 4.80412619665786157913123233242914e-03 1.55567604340748190470261613782554e-04
 	 4.80412619665786157913123233242914e-03 9.90391747606684247351438443729421e-01 1.55567604340748190470261613782554e-04
 	 9.90391747606684247351438443729421e-01 4.80412619665786157913123233242914e-03 1.55567604340748190470261613782554e-04
 	 4.58279904240411928295628740670509e-01 4.58279904240411928295628740670509e-01 4.42585250544658137528131192084402e-03
 	 4.58279904240411928295628740670509e-01 8.34401915191761434087425186589826e-02 4.42585250544658137528131192084402e-03
 	 8.34401915191761434087425186589826e-02 4.58279904240411928295628740670509e-01 4.42585250544658137528131192084402e-03
 	 3.86267973570042055797557623009197e-01 3.86267973570042055797557623009197e-01 7.10529319522409507497995306835037e-03
 	 3.86267973570042055797557623009197e-01 2.27464052859915888404884753981605e-01 7.10529319522409507497995306835037e-03
 	 2.27464052859915888404884753981605e-01 3.86267973570042055797557623009197e-01 7.10529319522409507497995306835037e-03
 	 2.58264072150462098420575784984976e-01 2.58264072150462098420575784984976e-01 6.54637429454448492582852026089313e-03
 	 2.58264072150462098420575784984976e-01 4.83471855699075803158848430030048e-01 6.54637429454448492582852026089313e-03
 	 4.83471855699075803158848430030048e-01 2.58264072150462098420575784984976e-01 6.54637429454448492582852026089313e-03
 	 1.05895844178627504539313974873949e-01 1.05895844178627504539313974873949e-01 3.90497168554317141200837859571493e-03
 	 1.05895844178627504539313974873949e-01 7.88208311642744963165796434623189e-01 3.90497168554317141200837859571493e-03
 	 7.88208311642744963165796434623189e-01 1.05895844178627504539313974873949e-01 3.90497168554317141200837859571493e-03
 	 4.29552202118899328908696588769089e-01 4.29552202118899328908696588769089e-01 6.77379780166275594771585488729215e-03
 	 4.29552202118899328908696588769089e-01 1.40895595762201342182606822461821e-01 6.77379780166275594771585488729215e-03
 	 1.40895595762201342182606822461821e-01 4.29552202118899328908696588769089e-01 6.77379780166275594771585488729215e-03
 	 4.84841132562589427479338155535515e-01 4.84841132562589427479338155535515e-01 3.84105528929751249833657311683055e-03
 	 4.84841132562589427479338155535515e-01 3.03177348748211450413236889289692e-02 3.84105528929751249833657311683055e-03
 	 3.03177348748211450413236889289692e-02 4.84841132562589427479338155535515e-01 3.84105528929751249833657311683055e-03
 	 1.58637688863059594934767915219709e-01 1.58637688863059594934767915219709e-01 5.97133482012411533762508142331171e-03
 	 1.58637688863059594934767915219709e-01 6.82724622273880754619312938302755e-01 5.97133482012411533762508142331171e-03
 	 6.82724622273880754619312938302755e-01 1.58637688863059594934767915219709e-01 5.97133482012411533762508142331171e-03
 	 6.08391923927586036890957643663569e-02 6.08391923927586036890957643663569e-02 2.56412600233903468713303475112752e-03
 	 6.08391923927586036890957643663569e-02 8.78321615214482820377384086896200e-01 2.56412600233903468713303475112752e-03
 	 8.78321615214482820377384086896200e-01 6.08391923927586036890957643663569e-02 2.56412600233903468713303475112752e-03
 	 4.55054005583463913597874750394112e-02 2.15243853694561254608075273608847e-02 1.05876977884044936803475955855447e-03
 	 4.55054005583463913597874750394112e-02 9.32970214072197490118298901506932e-01 1.05876977884044936803475955855447e-03
 	 2.15243853694561254608075273608847e-02 4.55054005583463913597874750394112e-02 1.05876977884044936803475955855447e-03
 	 2.15243853694561254608075273608847e-02 9.32970214072197490118298901506932e-01 1.05876977884044936803475955855447e-03
 	 9.32970214072197490118298901506932e-01 4.55054005583463913597874750394112e-02 1.05876977884044936803475955855447e-03
 	 9.32970214072197490118298901506932e-01 2.15243853694561254608075273608847e-02 1.05876977884044936803475955855447e-03
 	 2.13394454767087293767247047071578e-01 4.90696693575595060954341875003593e-02 2.94783611725712340126404065188126e-03
 	 2.13394454767087293767247047071578e-01 7.37535875875353186259530957613606e-01 2.94783611725712340126404065188126e-03
 	 4.90696693575595060954341875003593e-02 2.13394454767087293767247047071578e-01 2.94783611725712340126404065188126e-03
 	 4.90696693575595060954341875003593e-02 7.37535875875353186259530957613606e-01 2.94783611725712340126404065188126e-03
 	 7.37535875875353186259530957613606e-01 2.13394454767087293767247047071578e-01 2.94783611725712340126404065188126e-03
 	 7.37535875875353186259530957613606e-01 4.90696693575595060954341875003593e-02 2.94783611725712340126404065188126e-03
 	 2.42102511919319640654180147976149e-01 1.77658450296370312715410477721889e-01 6.27862810833844028901573608436593e-03
 	 2.42102511919319640654180147976149e-01 5.80239037784310074385984989930876e-01 6.27862810833844028901573608436593e-03
 	 1.77658450296370312715410477721889e-01 2.42102511919319640654180147976149e-01 6.27862810833844028901573608436593e-03
 	 1.77658450296370312715410477721889e-01 5.80239037784310074385984989930876e-01 6.27862810833844028901573608436593e-03
 	 5.80239037784310074385984989930876e-01 2.42102511919319640654180147976149e-01 6.27862810833844028901573608436593e-03
 	 5.80239037784310074385984989930876e-01 1.77658450296370312715410477721889e-01 6.27862810833844028901573608436593e-03
 	 3.27190732019169983058048956081620e-01 1.89812356292736877927396221821255e-01 6.55305706204969366096557692458191e-03
 	 3.27190732019169983058048956081620e-01 4.82996911688093111258979206468211e-01 6.55305706204969366096557692458191e-03
 	 1.89812356292736877927396221821255e-01 3.27190732019169983058048956081620e-01 6.55305706204969366096557692458191e-03
 	 1.89812356292736877927396221821255e-01 4.82996911688093111258979206468211e-01 6.55305706204969366096557692458191e-03
 	 4.82996911688093111258979206468211e-01 3.27190732019169983058048956081620e-01 6.55305706204969366096557692458191e-03
 	 4.82996911688093111258979206468211e-01 1.89812356292736877927396221821255e-01 6.55305706204969366096557692458191e-03
 	 1.41998166933174241322035413759295e-01 4.45838202328932217688439720859606e-03 8.89447709627756862536818172060293e-04
 	 1.41998166933174241322035413759295e-01 8.53543451043536460787208852707408e-01 8.89447709627756862536818172060293e-04
 	 4.45838202328932217688439720859606e-03 1.41998166933174241322035413759295e-01 8.89447709627756862536818172060293e-04
 	 4.45838202328932217688439720859606e-03 8.53543451043536460787208852707408e-01 8.89447709627756862536818172060293e-04
 	 8.53543451043536460787208852707408e-01 1.41998166933174241322035413759295e-01 8.89447709627756862536818172060293e-04
 	 8.53543451043536460787208852707408e-01 4.45838202328932217688439720859606e-03 8.89447709627756862536818172060293e-04
 	 1.75396393191461719140988861909136e-01 8.76779764843520492689776801853441e-02 4.00596464334748193769630830729511e-03
 	 1.75396393191461719140988861909136e-01 7.36925630324186231590033457905520e-01 4.00596464334748193769630830729511e-03
 	 8.76779764843520492689776801853441e-02 1.75396393191461719140988861909136e-01 4.00596464334748193769630830729511e-03
 	 8.76779764843520492689776801853441e-02 7.36925630324186231590033457905520e-01 4.00596464334748193769630830729511e-03
 	 7.36925630324186231590033457905520e-01 1.75396393191461719140988861909136e-01 4.00596464334748193769630830729511e-03
 	 7.36925630324186231590033457905520e-01 8.76779764843520492689776801853441e-02 4.00596464334748193769630830729511e-03
 	 3.92139613334414494083546287583886e-01 6.31803276344106712336667897034204e-02 4.23234786713830302140593175863614e-03
 	 3.92139613334414494083546287583886e-01 5.44680059031174890193938153970521e-01 4.23234786713830302140593175863614e-03
 	 6.31803276344106712336667897034204e-02 3.92139613334414494083546287583886e-01 4.23234786713830302140593175863614e-03
 	 6.31803276344106712336667897034204e-02 5.44680059031174890193938153970521e-01 4.23234786713830302140593175863614e-03
 	 5.44680059031174890193938153970521e-01 3.92139613334414494083546287583886e-01 4.23234786713830302140593175863614e-03
 	 5.44680059031174890193938153970521e-01 6.31803276344106712336667897034204e-02 4.23234786713830302140593175863614e-03
 	 3.34145615035921328406232078123139e-01 4.14946413392367364353363612394787e-03 1.18838213384389189582190926586236e-03
 	 3.34145615035921328406232078123139e-01 6.61704920830154974531467360066017e-01 1.18838213384389189582190926586236e-03
 	 4.14946413392367364353363612394787e-03 3.34145615035921328406232078123139e-01 1.18838213384389189582190926586236e-03
 	 4.14946413392367364353363612394787e-03 6.61704920830154974531467360066017e-01 1.18838213384389189582190926586236e-03
 	 6.61704920830154974531467360066017e-01 3.34145615035921328406232078123139e-01 1.18838213384389189582190926586236e-03
 	 6.61704920830154974531467360066017e-01 4.14946413392367364353363612394787e-03 1.18838213384389189582190926586236e-03
 	 1.74146196051182144959312836363097e-01 2.27948049259162482949037098478584e-02 2.13847116750897269996101179856396e-03
 	 1.74146196051182144959312836363097e-01 8.03058999022901676134722492861329e-01 2.13847116750897269996101179856396e-03
 	 2.27948049259162482949037098478584e-02 1.74146196051182144959312836363097e-01 2.13847116750897269996101179856396e-03
 	 2.27948049259162482949037098478584e-02 8.03058999022901676134722492861329e-01 2.13847116750897269996101179856396e-03
 	 8.03058999022901676134722492861329e-01 1.74146196051182144959312836363097e-01 2.13847116750897269996101179856396e-03
 	 8.03058999022901676134722492861329e-01 2.27948049259162482949037098478584e-02 2.13847116750897269996101179856396e-03
 	 2.75839008071824209888944778867881e-01 2.27008443717970145869777809366497e-02 2.56563869101864884536556843386279e-03
 	 2.75839008071824209888944778867881e-01 7.01460147556378754707395728473784e-01 2.56563869101864884536556843386279e-03
 	 2.27008443717970145869777809366497e-02 2.75839008071824209888944778867881e-01 2.56563869101864884536556843386279e-03
 	 2.27008443717970145869777809366497e-02 7.01460147556378754707395728473784e-01 2.56563869101864884536556843386279e-03
 	 7.01460147556378754707395728473784e-01 2.75839008071824209888944778867881e-01 2.56563869101864884536556843386279e-03
 	 7.01460147556378754707395728473784e-01 2.27008443717970145869777809366497e-02 2.56563869101864884536556843386279e-03
 	 2.62226671646522725700467759679668e-02 6.14964854266397079746164777702688e-03 4.74270212944700336223091685639019e-04
 	 2.62226671646522725700467759679668e-02 9.67627684292683754030406362289796e-01 4.74270212944700336223091685639019e-04
 	 6.14964854266397079746164777702688e-03 2.62226671646522725700467759679668e-02 4.74270212944700336223091685639019e-04
 	 6.14964854266397079746164777702688e-03 9.67627684292683754030406362289796e-01 4.74270212944700336223091685639019e-04
 	 9.67627684292683754030406362289796e-01 2.62226671646522725700467759679668e-02 4.74270212944700336223091685639019e-04
 	 9.67627684292683754030406362289796e-01 6.14964854266397079746164777702688e-03 4.74270212944700336223091685639019e-04
 	 2.43047202365926140466001470485935e-01 1.12033629342270985018714668512985e-01 5.12299328085210128880255808780930e-03
 	 2.43047202365926140466001470485935e-01 6.44919168291802846759708245372167e-01 5.12299328085210128880255808780930e-03
 	 1.12033629342270985018714668512985e-01 2.43047202365926140466001470485935e-01 5.12299328085210128880255808780930e-03
 	 1.12033629342270985018714668512985e-01 6.44919168291802846759708245372167e-01 5.12299328085210128880255808780930e-03
 	 6.44919168291802846759708245372167e-01 2.43047202365926140466001470485935e-01 5.12299328085210128880255808780930e-03
 	 6.44919168291802846759708245372167e-01 1.12033629342270985018714668512985e-01 5.12299328085210128880255808780930e-03
 	 2.29992984057907162709355475271877e-01 4.78148977298713338118796301046132e-03 1.16227268223202543154237709188692e-03
 	 2.29992984057907162709355475271877e-01 7.65225526169105774165757338778349e-01 1.16227268223202543154237709188692e-03
 	 4.78148977298713338118796301046132e-03 2.29992984057907162709355475271877e-01 1.16227268223202543154237709188692e-03
 	 4.78148977298713338118796301046132e-03 7.65225526169105774165757338778349e-01 1.16227268223202543154237709188692e-03
 	 7.65225526169105774165757338778349e-01 2.29992984057907162709355475271877e-01 1.16227268223202543154237709188692e-03
 	 7.65225526169105774165757338778349e-01 4.78148977298713338118796301046132e-03 1.16227268223202543154237709188692e-03
 	 2.95608280872401651961922652844805e-01 6.24487421796328864842529071665922e-02 4.46255807013827641288594705315518e-03
 	 2.95608280872401651961922652844805e-01 6.41942976947965426859354920452461e-01 4.46255807013827641288594705315518e-03
 	 6.24487421796328864842529071665922e-02 2.95608280872401651961922652844805e-01 4.46255807013827641288594705315518e-03
 	 6.24487421796328864842529071665922e-02 6.41942976947965426859354920452461e-01 4.46255807013827641288594705315518e-03
 	 6.41942976947965426859354920452461e-01 2.95608280872401651961922652844805e-01 4.46255807013827641288594705315518e-03
 	 6.41942976947965426859354920452461e-01 6.24487421796328864842529071665922e-02 4.46255807013827641288594705315518e-03
 	 1.21393450754091192234085383461206e-01 5.02111859134281163230539846153988e-02 2.95894188617694571530325475805512e-03
 	 1.21393450754091192234085383461206e-01 8.28395363332480649809497208480025e-01 2.95894188617694571530325475805512e-03
 	 5.02111859134281163230539846153988e-02 1.21393450754091192234085383461206e-01 2.95894188617694571530325475805512e-03
 	 5.02111859134281163230539846153988e-02 8.28395363332480649809497208480025e-01 2.95894188617694571530325475805512e-03
 	 8.28395363332480649809497208480025e-01 1.21393450754091192234085383461206e-01 2.95894188617694571530325475805512e-03
 	 8.28395363332480649809497208480025e-01 5.02111859134281163230539846153988e-02 2.95894188617694571530325475805512e-03
 	 3.73823800310209619635060107611935e-01 2.57279987428787430825405380119264e-02 3.13026732148427664498280265092944e-03
 	 3.73823800310209619635060107611935e-01 6.00448200946911536668437747721327e-01 3.13026732148427664498280265092944e-03
 	 2.57279987428787430825405380119264e-02 3.73823800310209619635060107611935e-01 3.13026732148427664498280265092944e-03
 	 2.57279987428787430825405380119264e-02 6.00448200946911536668437747721327e-01 3.13026732148427664498280265092944e-03
 	 6.00448200946911536668437747721327e-01 3.73823800310209619635060107611935e-01 3.13026732148427664498280265092944e-03
 	 6.00448200946911536668437747721327e-01 2.57279987428787430825405380119264e-02 3.13026732148427664498280265092944e-03
 	 4.42783406520243560944294358705520e-01 5.64656599346616185769454077103546e-03 1.57008882174401818293540955551180e-03
 	 4.42783406520243560944294358705520e-01 5.51570027486290248575073746906128e-01 1.57008882174401818293540955551180e-03
 	 5.64656599346616185769454077103546e-03 4.42783406520243560944294358705520e-01 1.57008882174401818293540955551180e-03
 	 5.64656599346616185769454077103546e-03 5.51570027486290248575073746906128e-01 1.57008882174401818293540955551180e-03
 	 5.51570027486290248575073746906128e-01 4.42783406520243560944294358705520e-01 1.57008882174401818293540955551180e-03
 	 5.51570027486290248575073746906128e-01 5.64656599346616185769454077103546e-03 1.57008882174401818293540955551180e-03
 	 3.37798663200582327537091487101861e-01 1.18089069715095071333443854655343e-01 6.39356921147790288606493902534567e-03
 	 3.37798663200582327537091487101861e-01 5.44112267084322698273979312943993e-01 6.39356921147790288606493902534567e-03
 	 1.18089069715095071333443854655343e-01 3.37798663200582327537091487101861e-01 6.39356921147790288606493902534567e-03
 	 1.18089069715095071333443854655343e-01 5.44112267084322698273979312943993e-01 6.39356921147790288606493902534567e-03
 	 5.44112267084322698273979312943993e-01 3.37798663200582327537091487101861e-01 6.39356921147790288606493902534567e-03
 	 5.44112267084322698273979312943993e-01 1.18089069715095071333443854655343e-01 6.39356921147790288606493902534567e-03
 	 9.22291891952822101563569390236808e-02 1.82422910122947215527666742218571e-02 1.60245809539651790608105752511392e-03
 	 9.22291891952822101563569390236808e-02 8.89528519792423089107558098476147e-01 1.60245809539651790608105752511392e-03
 	 1.82422910122947215527666742218571e-02 9.22291891952822101563569390236808e-02 1.60245809539651790608105752511392e-03
 	 1.82422910122947215527666742218571e-02 8.89528519792423089107558098476147e-01 1.60245809539651790608105752511392e-03
 	 8.89528519792423089107558098476147e-01 9.22291891952822101563569390236808e-02 1.60245809539651790608105752511392e-03
 	 8.89528519792423089107558098476147e-01 1.82422910122947215527666742218571e-02 1.60245809539651790608105752511392e-03
 	 7.02907404781327321829920151685656e-02 1.20025560148715230122939967571938e-03 3.62567297493041594286938833491263e-04
 	 7.02907404781327321829920151685656e-02 9.28509003920380049379446063539945e-01 3.62567297493041594286938833491263e-04
 	 1.20025560148715230122939967571938e-03 7.02907404781327321829920151685656e-02 3.62567297493041594286938833491263e-04
 	 1.20025560148715230122939967571938e-03 9.28509003920380049379446063539945e-01 3.62567297493041594286938833491263e-04
 	 9.28509003920380049379446063539945e-01 7.02907404781327321829920151685656e-02 3.62567297493041594286938833491263e-04
 	 9.28509003920380049379446063539945e-01 1.20025560148715230122939967571938e-03 3.62567297493041594286938833491263e-04
 	 ];
 
 	 case  29 

 	 % ALG. DEG.:   29
 	 % PTS CARD.:  159
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 4.98914824637686160624383546746685e-01 4.98914824637686160624383546746685e-01 7.58231051578450981204282399517069e-04
 	 4.98914824637686160624383546746685e-01 2.17035072462767875123290650662966e-03 7.58231051578450981204282399517069e-04
 	 2.17035072462767875123290650662966e-03 4.98914824637686160624383546746685e-01 7.58231051578450981204282399517069e-04
 	 4.34380426761730609186429319379386e-01 4.34380426761730609186429319379386e-01 5.58555014758392847501466960125072e-03
 	 4.34380426761730609186429319379386e-01 1.31239146476538781627141361241229e-01 5.58555014758392847501466960125072e-03
 	 1.31239146476538781627141361241229e-01 4.34380426761730609186429319379386e-01 5.58555014758392847501466960125072e-03
 	 4.10973356271179326992815106223134e-02 4.10973356271179326992815106223134e-02 1.43024575307844348248664800848928e-03
 	 4.10973356271179326992815106223134e-02 9.17805328745764148479224786569830e-01 1.43024575307844348248664800848928e-03
 	 9.17805328745764148479224786569830e-01 4.10973356271179326992815106223134e-02 1.43024575307844348248664800848928e-03
 	 2.08405305132400797685221505162190e-01 2.08405305132400797685221505162190e-01 6.26960172131161338343607880574382e-03
 	 2.08405305132400797685221505162190e-01 5.83189389735198404629556989675621e-01 6.26960172131161338343607880574382e-03
 	 5.83189389735198404629556989675621e-01 2.08405305132400797685221505162190e-01 6.26960172131161338343607880574382e-03
 	 1.60745884431963526051134749650373e-01 1.60745884431963526051134749650373e-01 5.28570892911378771572561419134217e-03
 	 1.60745884431963526051134749650373e-01 6.78508231136072947897730500699254e-01 5.28570892911378771572561419134217e-03
 	 6.78508231136072947897730500699254e-01 1.60745884431963526051134749650373e-01 5.28570892911378771572561419134217e-03
 	 4.88401602932602707518583429191494e-01 4.88401602932602707518583429191494e-01 3.06720058235945489122364904233109e-03
 	 4.88401602932602707518583429191494e-01 2.31967941347945849628331416170113e-02 3.06720058235945489122364904233109e-03
 	 2.31967941347945849628331416170113e-02 4.88401602932602707518583429191494e-01 3.06720058235945489122364904233109e-03
 	 3.02386411215128436680288359639235e-01 3.02386411215128436680288359639235e-01 8.15511940387160169652069896528701e-03
 	 3.02386411215128436680288359639235e-01 3.95227177569743126639423280721530e-01 8.15511940387160169652069896528701e-03
 	 3.95227177569743126639423280721530e-01 3.02386411215128436680288359639235e-01 8.15511940387160169652069896528701e-03
 	 1.14426812994425419756083783795475e-01 1.14426812994425419756083783795475e-01 4.08643922061356634767292916876613e-03
 	 1.14426812994425419756083783795475e-01 7.71146374011149160487832432409050e-01 4.08643922061356634767292916876613e-03
 	 7.71146374011149160487832432409050e-01 1.14426812994425419756083783795475e-01 4.08643922061356634767292916876613e-03
 	 4.64762431080738891431280990218511e-01 4.64762431080738891431280990218511e-01 5.15655831762924961314542571244601e-03
 	 4.64762431080738891431280990218511e-01 7.04751378385222171374380195629783e-02 5.15655831762924961314542571244601e-03
 	 7.04751378385222171374380195629783e-02 4.64762431080738891431280990218511e-01 5.15655831762924961314542571244601e-03
 	 7.37218813900996500221296514610003e-02 7.37218813900996500221296514610003e-02 2.80442356641565212690969666198271e-03
 	 7.37218813900996500221296514610003e-02 8.52556237219800672200165081449086e-01 2.80442356641565212690969666198271e-03
 	 8.52556237219800672200165081449086e-01 7.37218813900996500221296514610003e-02 2.80442356641565212690969666198271e-03
 	 3.90619178783263687471105640725000e-01 3.90619178783263687471105640725000e-01 7.95660764204445154768041703619019e-03
 	 3.90619178783263687471105640725000e-01 2.18761642433472625057788718550000e-01 7.95660764204445154768041703619019e-03
 	 2.18761642433472625057788718550000e-01 3.90619178783263687471105640725000e-01 7.95660764204445154768041703619019e-03
 	 5.89421088402292056573905654204282e-02 2.72874324792107044584943409404332e-03 3.84626485738124364744533467685983e-04
 	 5.89421088402292056573905654204282e-02 9.38329147911849736907186070311582e-01 3.84626485738124364744533467685983e-04
 	 2.72874324792107044584943409404332e-03 5.89421088402292056573905654204282e-02 3.84626485738124364744533467685983e-04
 	 2.72874324792107044584943409404332e-03 9.38329147911849736907186070311582e-01 3.84626485738124364744533467685983e-04
 	 9.38329147911849736907186070311582e-01 5.89421088402292056573905654204282e-02 3.84626485738124364744533467685983e-04
 	 9.38329147911849736907186070311582e-01 2.72874324792107044584943409404332e-03 3.84626485738124364744533467685983e-04
 	 3.49788010009331795657772090635262e-01 1.57177699867193487737182522323565e-01 5.22610734846121714747280151414088e-03
 	 3.49788010009331795657772090635262e-01 4.93034290123474716605045387041173e-01 5.22610734846121714747280151414088e-03
 	 1.57177699867193487737182522323565e-01 3.49788010009331795657772090635262e-01 5.22610734846121714747280151414088e-03
 	 1.57177699867193487737182522323565e-01 4.93034290123474716605045387041173e-01 5.22610734846121714747280151414088e-03
 	 4.93034290123474716605045387041173e-01 3.49788010009331795657772090635262e-01 5.22610734846121714747280151414088e-03
 	 4.93034290123474716605045387041173e-01 1.57177699867193487737182522323565e-01 5.22610734846121714747280151414088e-03
 	 3.23001823543550170558802392406506e-01 2.10096664482755952213510752812908e-03 6.76411974626204203983603768790545e-04
 	 3.23001823543550170558802392406506e-01 6.74897209811622378339279748615809e-01 6.76411974626204203983603768790545e-04
 	 2.10096664482755952213510752812908e-03 3.23001823543550170558802392406506e-01 6.76411974626204203983603768790545e-04
 	 2.10096664482755952213510752812908e-03 6.74897209811622378339279748615809e-01 6.76411974626204203983603768790545e-04
 	 6.74897209811622378339279748615809e-01 3.23001823543550170558802392406506e-01 6.76411974626204203983603768790545e-04
 	 6.74897209811622378339279748615809e-01 2.10096664482755952213510752812908e-03 6.76411974626204203983603768790545e-04
 	 1.58145854249516104594874832400819e-01 6.81658088137464396316644865692069e-02 3.21956835376690240005381760113323e-03
 	 1.58145854249516104594874832400819e-01 7.73688336936737441895672873215517e-01 3.21956835376690240005381760113323e-03
 	 6.81658088137464396316644865692069e-02 1.58145854249516104594874832400819e-01 3.21956835376690240005381760113323e-03
 	 6.81658088137464396316644865692069e-02 7.73688336936737441895672873215517e-01 3.21956835376690240005381760113323e-03
 	 7.73688336936737441895672873215517e-01 1.58145854249516104594874832400819e-01 3.21956835376690240005381760113323e-03
 	 7.73688336936737441895672873215517e-01 6.81658088137464396316644865692069e-02 3.21956835376690240005381760113323e-03
 	 2.95494682613533683757101044875526e-02 1.08309586036093533772950436855353e-02 6.36097218585815536544270099028608e-04
 	 2.95494682613533683757101044875526e-02 9.59619573135037207123332336777821e-01 6.36097218585815536544270099028608e-04
 	 1.08309586036093533772950436855353e-02 2.95494682613533683757101044875526e-02 6.36097218585815536544270099028608e-04
 	 1.08309586036093533772950436855353e-02 9.59619573135037207123332336777821e-01 6.36097218585815536544270099028608e-04
 	 9.59619573135037207123332336777821e-01 2.95494682613533683757101044875526e-02 6.36097218585815536544270099028608e-04
 	 9.59619573135037207123332336777821e-01 1.08309586036093533772950436855353e-02 6.36097218585815536544270099028608e-04
 	 2.91819173426537070703545850847149e-01 2.18932341980172556761274904602033e-01 6.77262328600378594317676927971661e-03
 	 2.91819173426537070703545850847149e-01 4.89248484593290400290754860179732e-01 6.77262328600378594317676927971661e-03
 	 2.18932341980172556761274904602033e-01 2.91819173426537070703545850847149e-01 6.77262328600378594317676927971661e-03
 	 2.18932341980172556761274904602033e-01 4.89248484593290400290754860179732e-01 6.77262328600378594317676927971661e-03
 	 4.89248484593290400290754860179732e-01 2.91819173426537070703545850847149e-01 6.77262328600378594317676927971661e-03
 	 4.89248484593290400290754860179732e-01 2.18932341980172556761274904602033e-01 6.77262328600378594317676927971661e-03
 	 7.55221785129957801085964774756576e-02 2.12868962407332593111952689923783e-02 1.38076537479522192843062189382408e-03
 	 7.55221785129957801085964774756576e-02 9.03190925246270981396889965253649e-01 1.38076537479522192843062189382408e-03
 	 2.12868962407332593111952689923783e-02 7.55221785129957801085964774756576e-02 1.38076537479522192843062189382408e-03
 	 2.12868962407332593111952689923783e-02 9.03190925246270981396889965253649e-01 1.38076537479522192843062189382408e-03
 	 9.03190925246270981396889965253649e-01 7.55221785129957801085964774756576e-02 1.38076537479522192843062189382408e-03
 	 9.03190925246270981396889965253649e-01 2.12868962407332593111952689923783e-02 1.38076537479522192843062189382408e-03
 	 1.17116669508898874063618222862715e-01 4.08472165761024560981518050084560e-02 2.25634342274366479080827119219066e-03
 	 1.17116669508898874063618222862715e-01 8.42036113914998662899336068221601e-01 2.25634342274366479080827119219066e-03
 	 4.08472165761024560981518050084560e-02 1.17116669508898874063618222862715e-01 2.25634342274366479080827119219066e-03
 	 4.08472165761024560981518050084560e-02 8.42036113914998662899336068221601e-01 2.25634342274366479080827119219066e-03
 	 8.42036113914998662899336068221601e-01 1.17116669508898874063618222862715e-01 2.25634342274366479080827119219066e-03
 	 8.42036113914998662899336068221601e-01 4.08472165761024560981518050084560e-02 2.25634342274366479080827119219066e-03
 	 1.11662181081691909423359021502620e-02 1.60349649604376361805568862450855e-03 1.34746115929350578771517277232306e-04
 	 1.11662181081691909423359021502620e-02 9.87230285395787054980587527097668e-01 1.34746115929350578771517277232306e-04
 	 1.60349649604376361805568862450855e-03 1.11662181081691909423359021502620e-02 1.34746115929350578771517277232306e-04
 	 1.60349649604376361805568862450855e-03 9.87230285395787054980587527097668e-01 1.34746115929350578771517277232306e-04
 	 9.87230285395787054980587527097668e-01 1.11662181081691909423359021502620e-02 1.34746115929350578771517277232306e-04
 	 9.87230285395787054980587527097668e-01 1.60349649604376361805568862450855e-03 1.34746115929350578771517277232306e-04
 	 2.08045649279087141447774911284796e-01 1.01545985226834029058196051664709e-01 4.69316533814183138584308352392327e-03
 	 2.08045649279087141447774911284796e-01 6.90408365494078801738453421421582e-01 4.69316533814183138584308352392327e-03
 	 1.01545985226834029058196051664709e-01 2.08045649279087141447774911284796e-01 4.69316533814183138584308352392327e-03
 	 1.01545985226834029058196051664709e-01 6.90408365494078801738453421421582e-01 4.69316533814183138584308352392327e-03
 	 6.90408365494078801738453421421582e-01 2.08045649279087141447774911284796e-01 4.69316533814183138584308352392327e-03
 	 6.90408365494078801738453421421582e-01 1.01545985226834029058196051664709e-01 4.69316533814183138584308352392327e-03
 	 3.92210114980434843001688705044216e-01 4.15270612688226833930649206649832e-02 3.91145922915323886182026313917959e-03
 	 3.92210114980434843001688705044216e-01 5.66262823750742438910776854754658e-01 3.91145922915323886182026313917959e-03
 	 4.15270612688226833930649206649832e-02 3.92210114980434843001688705044216e-01 3.91145922915323886182026313917959e-03
 	 4.15270612688226833930649206649832e-02 5.66262823750742438910776854754658e-01 3.91145922915323886182026313917959e-03
 	 5.66262823750742438910776854754658e-01 3.92210114980434843001688705044216e-01 3.91145922915323886182026313917959e-03
 	 5.66262823750742438910776854754658e-01 4.15270612688226833930649206649832e-02 3.91145922915323886182026313917959e-03
 	 3.59711275509975836328635523386765e-01 9.38490411451324418878883193428919e-02 5.31519818159830598203186013961385e-03
 	 3.59711275509975836328635523386765e-01 5.46439683344891680150112733826973e-01 5.31519818159830598203186013961385e-03
 	 9.38490411451324418878883193428919e-02 3.59711275509975836328635523386765e-01 5.31519818159830598203186013961385e-03
 	 9.38490411451324418878883193428919e-02 5.46439683344891680150112733826973e-01 5.31519818159830598203186013961385e-03
 	 5.46439683344891680150112733826973e-01 3.59711275509975836328635523386765e-01 5.31519818159830598203186013961385e-03
 	 5.46439683344891680150112733826973e-01 9.38490411451324418878883193428919e-02 5.31519818159830598203186013961385e-03
 	 2.45874699482875436196138707600767e-01 8.68602980438413878327974515514143e-03 1.52561941167259529535116246989901e-03
 	 2.45874699482875436196138707600767e-01 7.45439270712740409408070263452828e-01 1.52561941167259529535116246989901e-03
 	 8.68602980438413878327974515514143e-03 2.45874699482875436196138707600767e-01 1.52561941167259529535116246989901e-03
 	 8.68602980438413878327974515514143e-03 7.45439270712740409408070263452828e-01 1.52561941167259529535116246989901e-03
 	 7.45439270712740409408070263452828e-01 2.45874699482875436196138707600767e-01 1.52561941167259529535116246989901e-03
 	 7.45439270712740409408070263452828e-01 8.68602980438413878327974515514143e-03 1.52561941167259529535116246989901e-03
 	 1.67002738174923143210648390777351e-01 1.75891240440456259053192411556665e-02 1.91268333586500560369869639032459e-03
 	 1.67002738174923143210648390777351e-01 8.15408137781031161495093328994699e-01 1.91268333586500560369869639032459e-03
 	 1.75891240440456259053192411556665e-02 1.67002738174923143210648390777351e-01 1.91268333586500560369869639032459e-03
 	 1.75891240440456259053192411556665e-02 8.15408137781031161495093328994699e-01 1.91268333586500560369869639032459e-03
 	 8.15408137781031161495093328994699e-01 1.67002738174923143210648390777351e-01 1.91268333586500560369869639032459e-03
 	 8.15408137781031161495093328994699e-01 1.75891240440456259053192411556665e-02 1.91268333586500560369869639032459e-03
 	 1.15008598631946429291517119963828e-01 5.52352451221255549840272180972534e-03 8.70847615650874578435702844103616e-04
 	 1.15008598631946429291517119963828e-01 8.79467876855840935412800263293320e-01 8.70847615650874578435702844103616e-04
 	 5.52352451221255549840272180972534e-03 1.15008598631946429291517119963828e-01 8.70847615650874578435702844103616e-04
 	 5.52352451221255549840272180972534e-03 8.79467876855840935412800263293320e-01 8.70847615650874578435702844103616e-04
 	 8.79467876855840935412800263293320e-01 1.15008598631946429291517119963828e-01 8.70847615650874578435702844103616e-04
 	 8.79467876855840935412800263293320e-01 5.52352451221255549840272180972534e-03 8.70847615650874578435702844103616e-04
 	 3.15395398117319147868187201311230e-01 2.38589269426556054021215658167421e-02 2.83457674083272903944874521187103e-03
 	 3.15395398117319147868187201311230e-01 6.60745674940025229382456473103957e-01 2.83457674083272903944874521187103e-03
 	 2.38589269426556054021215658167421e-02 3.15395398117319147868187201311230e-01 2.83457674083272903944874521187103e-03
 	 2.38589269426556054021215658167421e-02 6.60745674940025229382456473103957e-01 2.83457674083272903944874521187103e-03
 	 6.60745674940025229382456473103957e-01 3.15395398117319147868187201311230e-01 2.83457674083272903944874521187103e-03
 	 6.60745674940025229382456473103957e-01 2.38589269426556054021215658167421e-02 2.83457674083272903944874521187103e-03
 	 2.23222650224820601261299657380732e-01 4.02953345447718061511643838912278e-02 3.29099888192610273360272366005574e-03
 	 2.23222650224820601261299657380732e-01 7.36482015230407571770854247006355e-01 3.29099888192610273360272366005574e-03
 	 4.02953345447718061511643838912278e-02 2.23222650224820601261299657380732e-01 3.29099888192610273360272366005574e-03
 	 4.02953345447718061511643838912278e-02 7.36482015230407571770854247006355e-01 3.29099888192610273360272366005574e-03
 	 7.36482015230407571770854247006355e-01 2.23222650224820601261299657380732e-01 3.29099888192610273360272366005574e-03
 	 7.36482015230407571770854247006355e-01 4.02953345447718061511643838912278e-02 3.29099888192610273360272366005574e-03
 	 2.88395859918732400117846736975480e-01 6.78784043114470936330917538725771e-02 4.58946208246379782486057408164015e-03
 	 2.88395859918732400117846736975480e-01 6.43725735769820506249061509151943e-01 4.58946208246379782486057408164015e-03
 	 6.78784043114470936330917538725771e-02 2.88395859918732400117846736975480e-01 4.58946208246379782486057408164015e-03
 	 6.78784043114470936330917538725771e-02 6.43725735769820506249061509151943e-01 4.58946208246379782486057408164015e-03
 	 6.43725735769820506249061509151943e-01 2.88395859918732400117846736975480e-01 4.58946208246379782486057408164015e-03
 	 6.43725735769820506249061509151943e-01 6.78784043114470936330917538725771e-02 4.58946208246379782486057408164015e-03
 	 2.67366350272775554763882155384636e-01 1.39535607181082654815185151164769e-01 6.25918324941721233856117834193356e-03
 	 2.67366350272775554763882155384636e-01 5.93098042546141845932083924708422e-01 6.25918324941721233856117834193356e-03
 	 1.39535607181082654815185151164769e-01 2.67366350272775554763882155384636e-01 6.25918324941721233856117834193356e-03
 	 1.39535607181082654815185151164769e-01 5.93098042546141845932083924708422e-01 6.25918324941721233856117834193356e-03
 	 5.93098042546141845932083924708422e-01 2.67366350272775554763882155384636e-01 6.25918324941721233856117834193356e-03
 	 5.93098042546141845932083924708422e-01 1.39535607181082654815185151164769e-01 6.25918324941721233856117834193356e-03
 	 4.05765395298891551334463656530716e-01 8.06658570416661502289201735038660e-03 1.82067020564036837620980335827880e-03
 	 4.05765395298891551334463656530716e-01 5.86168018996941819764856518304441e-01 1.82067020564036837620980335827880e-03
 	 8.06658570416661502289201735038660e-03 4.05765395298891551334463656530716e-01 1.82067020564036837620980335827880e-03
 	 8.06658570416661502289201735038660e-03 5.86168018996941819764856518304441e-01 1.82067020564036837620980335827880e-03
 	 5.86168018996941819764856518304441e-01 4.05765395298891551334463656530716e-01 1.82067020564036837620980335827880e-03
 	 5.86168018996941819764856518304441e-01 8.06658570416661502289201735038660e-03 1.82067020564036837620980335827880e-03
 	 1.86320727675359537611754490171734e-01 1.23446812287404965226972342051681e-04 3.44336312520880421985530750461635e-04
 	 1.86320727675359537611754490171734e-01 8.13555825512353059103531904838746e-01 3.44336312520880421985530750461635e-04
 	 1.23446812287404965226972342051681e-04 1.86320727675359537611754490171734e-01 3.44336312520880421985530750461635e-04
 	 1.23446812287404965226972342051681e-04 8.13555825512353059103531904838746e-01 3.44336312520880421985530750461635e-04
 	 8.13555825512353059103531904838746e-01 1.86320727675359537611754490171734e-01 3.44336312520880421985530750461635e-04
 	 8.13555825512353059103531904838746e-01 1.23446812287404965226972342051681e-04 3.44336312520880421985530750461635e-04
 	 ];
 
 	 case  30 

 	 % ALG. DEG.:   30
 	 % PTS CARD.:  171
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 9.4e-16  

 	 xyw=[
 	 3.31872493664456995679512552044343e-03 3.31872493664447281228047081924615e-03 8.58649506855249081051922876994809e-05
 	 3.31872493664445633240744903957875e-03 9.93362550126711041365012988535454e-01 8.58649506855236612726939293693817e-05
 	 9.93362550126710930342710526019800e-01 3.31872493664456128317774563640796e-03 8.58649506855257619144031200342226e-05
 	 7.23724072246780952832878597291710e-02 7.23724072246776234385023940376414e-02 1.90096633420776131920271190267613e-03
 	 7.23724072246777483385926643677521e-02 8.55255185550644392300512208748842e-01 1.90096633420775980131967042296992e-03
 	 8.55255185550643615144394971139263e-01 7.23724072246783173278927847604791e-02 1.90096633420776327076662237658411e-03
 	 4.71579102421717036297543756973027e-02 4.71579102421719048576775890069257e-02 1.42221683384374797398663758940529e-03
 	 4.71579102421717799575873186768149e-02 9.05684179515656384573674131388543e-01 1.42221683384374558874185812129554e-03
 	 9.05684179515655829462161818810273e-01 4.71579102421719811855105319864379e-02 1.42221683384375664760401747344076e-03
 	 4.68030173651125036560216585712624e-01 4.68030173651125924738636285837856e-01 3.89206436616542413714503467758732e-03
 	 4.68030173651125425138275204517413e-01 6.39396526977492052346008222230012e-02 3.89206436616542934131546260800860e-03
 	 6.39396526977491358456617831507174e-02 4.68030173651125147582519048228278e-01 3.89206436616542890763459361380683e-03
 	 1.26866046744676056606815350846773e-02 1.26866046744678710733733595361628e-02 4.23275072664445182503423215081284e-04
 	 1.26866046744677114788135696699101e-02 9.74626790651064611736842380196322e-01 4.23275072664444640402336972329067e-04
 	 9.74626790651064389692237455165014e-01 1.26866046744677826024760847190009e-02 4.23275072664444477772011099503402e-04
 	 1.21591508222727934240836589196988e-01 1.21591508222728142407653706413839e-01 3.69345591745715018383577898930525e-03
 	 1.21591508222727948118624397011445e-01 7.56816983554544076007175590348197e-01 3.69345591745714714806969602989284e-03
 	 7.56816983554543964984873127832543e-01 1.21591508222727892607473165753618e-01 3.69345591745714281126100608787510e-03
 	 1.82409561517453105983221917085757e-01 1.82409561517453022716495070199016e-01 5.37642548271641089463468432541049e-03
 	 1.82409561517452994960919454570103e-01 6.35180876965093954567009859601967e-01 5.37642548271641089463468432541049e-03
 	 6.35180876965094287633917247148929e-01 1.82409561517452828427465760796622e-01 5.37642548271640742518773237179630e-03
 	 3.62287279352949853628018672679900e-01 3.62287279352949853628018672679900e-01 7.79804566291290336688124540387435e-03
 	 3.62287279352949853628018672679900e-01 2.75425441294100348255113885898027e-01 7.79804566291291117313688729950627e-03
 	 2.75425441294100348255113885898027e-01 3.62287279352949853628018672679900e-01 7.79804566291291030577514931110272e-03
 	 4.36743248548460250013647510058945e-01 4.36743248548460083480193816285464e-01 6.20247951407301885418110742875797e-03
 	 4.36743248548460250013647510058945e-01 1.26513502903079527728280595511023e-01 6.20247951407301278264894150993314e-03
 	 1.26513502903079583239431826768850e-01 4.36743248548460250013647510058945e-01 6.20247951407300497639329961430121e-03
 	 2.72428040783928238077749028889230e-01 2.72428040783928238077749028889230e-01 7.45727538134288454180209626542819e-03
 	 2.72428040783928238077749028889230e-01 4.55143918432143523844501942221541e-01 7.45727538134288540916383425383174e-03
 	 4.55143918432143579355653173479368e-01 2.72428040783928238077749028889230e-01 7.45727538134288627652557224223528e-03
 	 4.97319339000308224818525104637956e-01 4.97319339000308946463491110989708e-01 1.39565905987038625830909399638813e-03
 	 4.97319339000308668907734954700572e-01 5.36132199938280876866381063905465e-03 1.39565905987038343938344553407660e-03
 	 5.36132199938280269713164472022981e-03 4.97319339000308446863130029669264e-01 1.39565905987038430674518352248015e-03
 	 2.59053884521067367963098604377592e-01 4.78351231407723800903575295251358e-02 2.10737923195620634880809163291815e-03
 	 2.59053884521067201429644910604111e-01 6.93110992338160092351984076231020e-01 2.10737923195623844119239720384940e-03
 	 4.78351231407727478517344366082398e-02 2.59053884521067256940796141861938e-01 2.10737923195623063493675530821747e-03
 	 4.78351231407725049904477998552466e-02 6.93110992338160092351984076231020e-01 2.10737923195620721616982962132170e-03
 	 6.93110992338160092351984076231020e-01 2.59053884521067645518854760666727e-01 2.10737923195620678248896062711992e-03
 	 6.93110992338160203374286538746674e-01 4.78351231407725258071295115769317e-02 2.10737923195621762451068548216426e-03
 	 3.91572188291256340075818798140972e-01 7.96595269316004994664126570569351e-02 2.96246137254601140179066653956852e-03
 	 3.91572188291256340075818798140972e-01 5.28768284777142882902012388512958e-01 2.96246137254598668198113387006742e-03
 	 7.96595269316007770221688133460702e-02 3.91572188291256340075818798140972e-01 2.96246137254598841670460984687452e-03
 	 7.96595269316005549775638883147622e-02 5.28768284777142771879709925997304e-01 2.96246137254600879970545257435788e-03
 	 5.28768284777143215968919776059920e-01 3.91572188291256395586970029398799e-01 2.96246137254605086674974501192992e-03
 	 5.28768284777143215968919776059920e-01 7.96595269316005549775638883147622e-02 2.96246137254600272817328665553305e-03
 	 3.56140283296233706167299715161789e-01 5.76934012738741786030516323080519e-02 2.97211009221223614040763294497083e-03
 	 3.56140283296233373100392327614827e-01 5.86166315429892281763102346303640e-01 2.97211009221227517168584242313045e-03
 	 5.76934012738743381976114221743046e-02 3.56140283296233539633846021388308e-01 2.97211009221226996751541449270917e-03
 	 5.76934012738742341142028635658789e-02 5.86166315429891837673892496241024e-01 2.97211009221224221193979886379566e-03
 	 5.86166315429892281763102346303640e-01 3.56140283296233706167299715161789e-01 2.97211009221221879317287317689988e-03
 	 5.86166315429892281763102346303640e-01 5.76934012738742479919906713803357e-02 2.97211009221224438034414383480453e-03
 	 2.83012497349588887374238765914924e-01 7.72614375768838901326063250962761e-02 3.43859219376797071651696846572577e-03
 	 2.83012497349588498796180147110135e-01 6.39726065073527250248730524617713e-01 3.43859219376795640504829165706724e-03
 	 7.72614375768842509550893282721518e-02 2.83012497349588554307331378367962e-01 3.43859219376795250192047070925128e-03
 	 7.72614375768838901326063250962761e-02 6.39726065073527139226428062102059e-01 3.43859219376796854811262349471690e-03
 	 6.39726065073526917181823137070751e-01 2.83012497349589053907692459688406e-01 3.43859219376798849743259722799849e-03
 	 6.39726065073527472293335449649021e-01 7.72614375768840289104844032408437e-02 3.43859219376796117553785059328675e-03
 	 2.41613762451524383134682238960522e-01 2.27583842950000343752225973048553e-02 2.04624948417360180349944265287832e-03
 	 2.41613762451524133334501698300301e-01 7.35627853253475905148661695420742e-01 2.04624948417360570662726360069428e-03
 	 2.27583842950000898863738285626823e-02 2.41613762451524327623531007702695e-01 2.04624948417361091079769153111556e-03
 	 2.27583842950000690696921168409972e-02 7.35627853253475461059451845358126e-01 2.04624948417360570662726360069428e-03
 	 7.35627853253475239014846920326818e-01 2.41613762451524688446014010878571e-01 2.04624948417359399724380075724639e-03
 	 7.35627853253475572081754307873780e-01 2.27583842949999996807530777687134e-02 2.04624948417360050245683567027299e-03
 	 2.52781247187933100217804849307868e-01 1.23811978770674471772572644567845e-01 4.43632725300868724360725536826067e-03
 	 2.52781247187932989195502386792214e-01 6.23406774041392330865107851423090e-01 4.43632725300866989637249560018972e-03
 	 1.23811978770674652183814146155783e-01 2.52781247187933100217804849307868e-01 4.43632725300866382484032968136489e-03
 	 1.23811978770674430139209221124474e-01 6.23406774041392663932015238970052e-01 4.43632725300868811096899335666421e-03
 	 6.23406774041392774954317701485706e-01 2.52781247187932600617443767987425e-01 4.43632725300868637624551737985712e-03
 	 6.23406774041392441887410313938744e-01 1.23811978770674596672662914897955e-01 4.43632725300867163109597157699682e-03
 	 1.84906106383917107072178964699560e-01 1.15881967236100641427398727500986e-01 3.76716146477325524583035232240036e-03
 	 1.84906106383917162583330195957387e-01 6.99211926379982307011573539057281e-01 3.76716146477325221006426936298794e-03
 	 1.15881967236100655305186535315443e-01 1.84906106383917412383510736617609e-01 3.76716146477324960797905539777730e-03
 	 1.15881967236100613671823111872072e-01 6.99211926379982307011573539057281e-01 3.76716146477323833227646154853119e-03
 	 6.99211926379982640078480926604243e-01 1.84906106383916857271998424039339e-01 3.76716146477323919963819953693474e-03
 	 6.99211926379982307011573539057281e-01 1.15881967236100377749430379026307e-01 3.76716146477324657221297243836489e-03
 	 1.93704377153640361353126309040817e-01 6.65174447818816100275185476675688e-02 3.40200337805094451398835175837121e-03
 	 1.93704377153639917263916458978201e-01 7.39778178064478542097504032426514e-01 3.40200337805093497300923388593219e-03
 	 6.65174447818816239053063554820255e-02 1.93704377153639833997189612091461e-01 3.40200337805094191190313779316057e-03
 	 6.65174447818816100275185476675688e-02 7.39778178064478098008294182363898e-01 3.40200337805094928447791069459072e-03
 	 7.39778178064477764941386794816935e-01 1.93704377153640638908882465329953e-01 3.40200337805094321294574477576589e-03
 	 7.39778178064478320052899107395206e-01 6.65174447818815128830038929663715e-02 3.40200337805093323828575790912510e-03
 	 7.64012484393875451749167382331507e-02 4.43878137706129466399929128783697e-03 6.03348284271059461664199474739689e-04
 	 7.64012484393875451749167382331507e-02 9.19159970183551111588826643128414e-01 6.03348284271059027983330480537916e-04
 	 4.43878137706126257161498571690572e-03 7.64012484393876284416435851198912e-02 6.03348284271056642738551012428161e-04
 	 4.43878137706129813344624324145116e-03 9.19159970183551111588826643128414e-01 6.03348284271059895345068468941463e-04
 	 9.19159970183551111588826643128414e-01 7.64012484393875868082801616765209e-02 6.03348284271060979547240954445897e-04
 	 9.19159970183551222611129105644068e-01 4.43878137706130420497840916027599e-03 6.03348284271059570084416723290133e-04
 	 2.09048087452689601573041500159889e-01 4.66357939268863264103970323048998e-03 9.79474288946623498561261378370091e-04
 	 2.09048087452689462795163422015321e-01 7.86288333154621987830523721640930e-01 9.79474288946621330156916407361223e-04
 	 4.66357939268859881393192168275164e-03 2.09048087452689573817465884530975e-01 9.79474288946623932242130372571864e-04
 	 4.66357939268859187503801777552326e-03 7.86288333154621654763616334093967e-01 9.79474288946625016444302858076298e-04
 	 7.86288333154621543741313871578313e-01 2.09048087452689795862070809562283e-01 9.79474288946623498561261378370091e-04
 	 7.86288333154621876808221259125276e-01 4.66357939268862223269884736964741e-03 9.79474288946623281720826881269204e-04
 	 2.98542994059242727811209761057398e-01 4.70368176447704278847483649883543e-03 1.13722295049934135971470006154505e-03
 	 2.98542994059242394744302373510436e-01 6.96753324176280552926243672118289e-01 1.13722295049933919131035509053618e-03
 	 4.70368176447702804332529069597513e-03 2.98542994059242505766604836026090e-01 1.13722295049934092603383106734327e-03
 	 4.70368176447703151277224264958932e-03 6.96753324176280219859336284571327e-01 1.13722295049934201023600355284771e-03
 	 6.96753324176280108837033822055673e-01 2.98542994059242894344663454830879e-01 1.13722295049933854078905159923352e-03
 	 6.96753324176280441903941209602635e-01 4.70368176447702717596355270757158e-03 1.13722295049934135971470006154505e-03
 	 3.34379040034031127515135040084715e-01 2.51820667038687162619936543705990e-02 2.68234242309315891808485510239279e-03
 	 3.34379040034030683425925190022099e-01 6.40438893262100572556505539978389e-01 2.68234242309315935176572409659457e-03
 	 2.51820667038687232008875582778273e-02 3.34379040034030905470530115053407e-01 2.68234242309316455593615202701585e-03
 	 2.51820667038687058536527985097564e-02 6.40438893262100128467295689915773e-01 2.68234242309316282121267605020876e-03
 	 6.40438893262100017444993227400118e-01 3.34379040034031405070891196373850e-01 2.68234242309314981078660622415555e-03
 	 6.40438893262100239489598152431427e-01 2.51820667038687023842058465561422e-02 2.68234242309315935176572409659457e-03
 	 1.23230802380695295128454347377556e-01 6.57765738247429870844129595752747e-02 2.93503490153276857047015546697821e-03
 	 1.23230802380694934305971344201680e-01 8.10992623794562161876342543109786e-01 2.93503490153276640206581049596934e-03
 	 6.57765738247428483065348814307072e-02 1.23230802380694795528093266057112e-01 2.93503490153276510102320351336402e-03
 	 6.57765738247428205509592658017937e-02 8.10992623794561939831737618078478e-01 2.93503490153276640206581049596934e-03
 	 8.10992623794561606764830230531516e-01 1.23230802380695503295271464594407e-01 2.93503490153276987151276244958353e-03
 	 8.10992623794562050854040080594132e-01 6.57765738247427927953836501728802e-02 2.93503490153276423366146552496048e-03
 	 3.38514162429845832935626503967796e-01 1.26124094984989387757678969137487e-01 5.65151177146875141610316006790526e-03
 	 3.38514162429845777424475272709969e-01 5.35361742585164779306694526894717e-01 5.65151177146874707929447012588753e-03
 	 1.26124094984989443268830200395314e-01 3.38514162429845721913324041452142e-01 5.65151177146874187512404219546625e-03
 	 1.26124094984989360002103353508573e-01 5.35361742585164890328996989410371e-01 5.65151177146875315082663604471236e-03
 	 5.35361742585165112373601914441679e-01 3.38514162429845555379870347678661e-01 5.65151177146875054874142207950172e-03
 	 5.35361742585164890328996989410371e-01 1.26124094984989415513254584766401e-01 5.65151177146875141610316006790526e-03
 	 3.54403602180687560263550039962865e-01 1.94870950923518415631718880831613e-01 7.15824263483380487244067680308035e-03
 	 3.54403602180687560263550039962865e-01 4.50725446895794079615882310463348e-01 7.15824263483379793354677289585197e-03
 	 1.94870950923518443387294496460527e-01 3.54403602180687504752398808705038e-01 7.15824263483380140299372484946616e-03
 	 1.94870950923518387876143265202700e-01 4.50725446895794135127033541721175e-01 7.15824263483380834188762875669454e-03
 	 4.50725446895794135127033541721175e-01 3.54403602180687449241247577447211e-01 7.15824263483380053563198686106261e-03
 	 4.50725446895794190638184772979002e-01 1.94870950923518415631718880831613e-01 7.15824263483380053563198686106261e-03
 	 2.63068297757808378101174184848787e-01 1.91001424572283001745987007780059e-01 6.46301172505915448585067650810743e-03
 	 2.63068297757808378101174184848787e-01 5.45930277669908536886111960484413e-01 6.46301172505915535321241449651097e-03
 	 1.91001424572283112768289470295713e-01 2.63068297757808322590022953590960e-01 6.46301172505915708793589047331807e-03
 	 1.91001424572283001745987007780059e-01 5.45930277669908647908414423000067e-01 6.46301172505915795529762846172162e-03
 	 5.45930277669908758930716885515722e-01 2.63068297757808267078871722333133e-01 6.46301172505915622057415248491452e-03
 	 5.45930277669908647908414423000067e-01 1.91001424572283057257138239037886e-01 6.46301172505915622057415248491452e-03
 	 4.34566173964669788531978156242985e-01 2.75334061245498459835623350500100e-02 3.14079829044583641942112173239821e-03
 	 4.34566173964669344442768306180369e-01 5.37900419910780858145926686120220e-01 3.14079829044583208261243179038047e-03
 	 2.75334061245498286363275752819391e-02 4.34566173964669510976221999953850e-01 3.14079829044583511837851474979288e-03
 	 2.75334061245498459835623350500100e-02 5.37900419910780303034414373541949e-01 3.14079829044583555205938374399466e-03
 	 5.37900419910780080989809448510641e-01 4.34566173964670010576583081274293e-01 3.14079829044583338365503877298579e-03
 	 5.37900419910780525079019298573257e-01 2.75334061245498529224562389572384e-02 3.14079829044583772046372871500353e-03
 	 1.64070987069878299058345305638795e-01 2.80639219813729849650751901890544e-02 2.35096849705298833327349328214950e-03
 	 1.64070987069878160280467227494228e-01 8.07865090948748920673949669435387e-01 2.35096849705298399646480334013177e-03
 	 2.80639219813729676178404304209835e-02 1.64070987069878271302769690009882e-01 2.35096849705298659855001730534241e-03
 	 2.80639219813729572094995745601409e-02 8.07865090948748698629344744404079e-01 2.35096849705298920063523127055305e-03
 	 8.07865090948748476584739819372771e-01 1.64070987069878576614101461927930e-01 2.35096849705298833327349328214950e-03
 	 8.07865090948748809651647206919733e-01 2.80639219813729051677952952559281e-02 2.35096849705298486382654132853531e-03
 	 4.26819997060804076638440562874166e-02 1.59024162689347728361077827230474e-02 9.15253438074417006303784560827808e-04
 	 4.26819997060803660304806328440463e-02 9.41415584024985041544653086020844e-01 9.15253438074413103175963613011845e-04
 	 1.59024162689345334442680979236684e-02 4.26819997060804146027379601946450e-02 9.15253438074412561074877370259628e-04
 	 1.59024162689346479360175123929366e-02 9.41415584024984930522350623505190e-01 9.15253438074413862117484352864949e-04
 	 9.41415584024984597455443235958228e-01 4.26819997060805395028282305247558e-02 9.15253438074417114724001809378251e-04
 	 9.41415584024984819500048160989536e-01 1.59024162689347138555095995116062e-02 9.15253438074415488420743081121600e-04
 	 9.39597946527299249241949041788757e-02 2.72942306520957377047320591145763e-02 1.91094027354751371146346361484802e-03
 	 9.39597946527298000241046338487649e-02 8.78745974695174458801716355083045e-01 1.91094027354751110937824964963738e-03
 	 2.72942306520956891324747317639776e-02 9.39597946527298416574680572921352e-02 1.91094027354750894097390467862851e-03
 	 2.72942306520956648463460680886783e-02 8.78745974695174458801716355083045e-01 1.91094027354751110937824964963738e-03
 	 8.78745974695174125734808967536082e-01 9.39597946527300775798607901379000e-02 1.91094027354751414514433260904980e-03
 	 8.78745974695174347779413892567391e-01 2.72942306520957585214137708362614e-02 1.91094027354751175989955314094004e-03
 	 1.35408853519934452291906268328603e-01 5.69121144541609533945569765478467e-03 9.59940278734462541267158375291046e-04
 	 1.35408853519934396780755037070776e-01 8.58899935034649564258302234520670e-01 9.59940278734458529719120178924641e-04
 	 5.69121144541610574779655351562724e-03 1.35408853519934507803057499586430e-01 9.59940278734459830761727161529961e-04
 	 5.69121144541609880890264960839886e-03 8.58899935034649342213697309489362e-01 9.59940278734460047602161658630848e-04
 	 8.58899935034649342213697309489362e-01 1.35408853519934591069784346473170e-01 9.59940278734462107586289381089273e-04
 	 8.58899935034649675280604697036324e-01 5.69121144541609187000874570117048e-03 9.59940278734460264442596155731735e-04
 	 3.96221514739659219639378306965227e-01 5.16234701662126715254741426974761e-03 1.32128396158162761050980371635433e-03
 	 3.96221514739658831061319688160438e-01 5.98616138243719952960475438885624e-01 1.32128396158162630946719673374901e-03
 	 5.16234701662126975463262823495825e-03 3.96221514739658942083622150676092e-01 1.32128396158162479158415525404280e-03
 	 5.16234701662127756088827013059017e-03 5.98616138243719508871265588823007e-01 1.32128396158162739366936921925344e-03
 	 5.98616138243719286826660663791699e-01 3.96221514739659441683983231996535e-01 1.32128396158162609262676223664812e-03
 	 5.98616138243719619893568051338661e-01 5.16234701662131138799605167832851e-03 1.32128396158162782735023821345521e-03
 	 2.94840425976739366198398073493081e-02 5.33708660694586205924805355493845e-04 1.67810855733205332475377336010069e-04
 	 2.94840425976739227420519995348513e-02 9.69982248741631747357416770682903e-01 1.67810855733197932795550122442307e-04
 	 5.33708660694311577514514777220711e-04 2.94840425976739331503928553956939e-02 1.67810855733194978344630099442725e-04
 	 5.33708660694432466056746910965103e-04 9.69982248741631636335114308167249e-01 1.67810855733200589090872711928171e-04
 	 9.69982248741631414290509383135941e-01 2.94840425976740025393318944679777e-02 1.67810855733206497992712757927336e-04
 	 9.69982248741631636335114308167249e-01 5.33708660694437995487826587037716e-04 1.67810855733200995666687393992333e-04
 	 ];
 
 	 case  31 

 	 % ALG. DEG.:   31
 	 % PTS CARD.:  181
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.7e-15  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.17156040694318525074990589018853e-03
 	 4.86152467913059771476014248037245e-01 4.86152467913059771476014248037245e-01 2.02199419825968259092907608476253e-03
 	 4.86152467913059771476014248037245e-01 2.76950641738804570479715039255098e-02 2.02199419825968259092907608476253e-03
 	 2.76950641738804570479715039255098e-02 4.86152467913059771476014248037245e-01 2.02199419825968259092907608476253e-03
 	 4.19588080864260470903559507860336e-01 4.19588080864260470903559507860336e-01 4.42154132154415607097730500640864e-03
 	 4.19588080864260470903559507860336e-01 1.60823838271479058192880984279327e-01 4.42154132154415607097730500640864e-03
 	 1.60823838271479058192880984279327e-01 4.19588080864260470903559507860336e-01 4.42154132154415607097730500640864e-03
 	 7.92067965066985402167176744114840e-02 7.92067965066985402167176744114840e-02 2.11186492555161513945405360459517e-03
 	 7.92067965066985402167176744114840e-02 8.41586406986602919566564651177032e-01 2.11186492555161513945405360459517e-03
 	 8.41586406986602919566564651177032e-01 7.92067965066985402167176744114840e-02 2.11186492555161513945405360459517e-03
 	 1.77313492497139200965161620615618e-02 1.77313492497139200965161620615618e-02 4.93433072513541656593794026974820e-04
 	 1.77313492497139200965161620615618e-02 9.64537301500572152868073771969648e-01 4.93433072513541656593794026974820e-04
 	 9.64537301500572152868073771969648e-01 1.77313492497139200965161620615618e-02 4.93433072513541656593794026974820e-04
 	 2.18436496790928025291123049100861e-01 2.18436496790928025291123049100861e-01 5.61850175400658690544331008709378e-03
 	 2.18436496790928025291123049100861e-01 5.63127006418143949417753901798278e-01 5.61850175400658690544331008709378e-03
 	 5.63127006418143949417753901798278e-01 2.18436496790928025291123049100861e-01 5.61850175400658690544331008709378e-03
 	 1.72450787183886011799671678090817e-01 1.72450787183886011799671678090817e-01 4.77959798336420951803127366019908e-03
 	 1.72450787183886011799671678090817e-01 6.55098425632227976400656643818365e-01 4.77959798336420951803127366019908e-03
 	 6.55098425632227976400656643818365e-01 1.72450787183886011799671678090817e-01 4.77959798336420951803127366019908e-03
 	 5.10951808223812711795552843341284e-02 5.10951808223812711795552843341284e-02 1.62954332509288556118942636885549e-03
 	 5.10951808223812711795552843341284e-02 8.97809638355237416007526007888373e-01 1.62954332509288556118942636885549e-03
 	 8.97809638355237416007526007888373e-01 5.10951808223812711795552843341284e-02 1.62954332509288556118942636885549e-03
 	 4.97748620626470295036369861918502e-01 4.97748620626470295036369861918502e-01 1.16383032102821597567055000865821e-03
 	 4.97748620626470295036369861918502e-01 4.50275874705940992726027616299689e-03 1.16383032102821597567055000865821e-03
 	 4.50275874705940992726027616299689e-03 4.97748620626470295036369861918502e-01 1.16383032102821597567055000865821e-03
 	 3.85168469245680045176527528383303e-01 3.85168469245680045176527528383303e-01 6.86969759828413156776960590832459e-03
 	 3.85168469245680045176527528383303e-01 2.29663061508639909646944943233393e-01 6.86969759828413156776960590832459e-03
 	 2.29663061508639909646944943233393e-01 3.85168469245680045176527528383303e-01 6.86969759828413156776960590832459e-03
 	 2.97491490367992827970056168851443e-01 2.97491490367992827970056168851443e-01 6.17952025467345157638821007139995e-03
 	 2.97491490367992827970056168851443e-01 4.05017019264014344059887662297115e-01 6.17952025467345157638821007139995e-03
 	 4.05017019264014344059887662297115e-01 2.97491490367992827970056168851443e-01 6.17952025467345157638821007139995e-03
 	 5.08280946272773696825719724756709e-03 5.08280946272773696825719724756709e-03 1.72200689636290549646216452295278e-04
 	 5.08280946272773696825719724756709e-03 9.89834381074544578105189884809079e-01 1.72200689636290549646216452295278e-04
 	 9.89834381074544578105189884809079e-01 5.08280946272773696825719724756709e-03 1.72200689636290549646216452295278e-04
 	 4.50340941739018174594377796893241e-01 4.50340941739018174594377796893241e-01 5.21698864789029055633040599104788e-03
 	 4.50340941739018174594377796893241e-01 9.93181165219636508112444062135182e-02 5.21698864789029055633040599104788e-03
 	 9.93181165219636508112444062135182e-02 4.50340941739018174594377796893241e-01 5.21698864789029055633040599104788e-03
 	 1.39090628472094579581863627026905e-01 1.06669680864077562332248305665416e-01 2.90314662418183350167666390007071e-03
 	 1.39090628472094579581863627026905e-01 7.54239690663827899719251490751049e-01 2.90314662418183350167666390007071e-03
 	 1.06669680864077562332248305665416e-01 1.39090628472094579581863627026905e-01 2.90314662418183350167666390007071e-03
 	 1.06669680864077562332248305665416e-01 7.54239690663827899719251490751049e-01 2.90314662418183350167666390007071e-03
 	 7.54239690663827899719251490751049e-01 1.39090628472094579581863627026905e-01 2.90314662418183350167666390007071e-03
 	 7.54239690663827899719251490751049e-01 1.06669680864077562332248305665416e-01 2.90314662418183350167666390007071e-03
 	 1.97233130789653043901665796511224e-01 3.26115566372831879038418634308982e-03 6.41925849384848050752094827942074e-04
 	 1.97233130789653043901665796511224e-01 7.99505713546618590470416165771894e-01 6.41925849384848050752094827942074e-04
 	 3.26115566372831879038418634308982e-03 1.97233130789653043901665796511224e-01 6.41925849384848050752094827942074e-04
 	 3.26115566372831879038418634308982e-03 7.99505713546618590470416165771894e-01 6.41925849384848050752094827942074e-04
 	 7.99505713546618590470416165771894e-01 1.97233130789653043901665796511224e-01 6.41925849384848050752094827942074e-04
 	 7.99505713546618590470416165771894e-01 3.26115566372831879038418634308982e-03 6.41925849384848050752094827942074e-04
 	 2.38524150984310012724165517283836e-01 1.31398178404036562044732150411619e-02 1.41325713796386929002601995364330e-03
 	 2.38524150984310012724165517283836e-01 7.48336031175286353622766455373494e-01 1.41325713796386929002601995364330e-03
 	 1.31398178404036562044732150411619e-02 2.38524150984310012724165517283836e-01 1.41325713796386929002601995364330e-03
 	 1.31398178404036562044732150411619e-02 7.48336031175286353622766455373494e-01 1.41325713796386929002601995364330e-03
 	 7.48336031175286353622766455373494e-01 2.38524150984310012724165517283836e-01 1.41325713796386929002601995364330e-03
 	 7.48336031175286353622766455373494e-01 1.31398178404036562044732150411619e-02 1.41325713796386929002601995364330e-03
 	 2.97507293859899553389869453212668e-02 2.34422112868689367162766679086872e-03 2.52754523436129129813215721256370e-04
 	 2.97507293859899553389869453212668e-02 9.67905049485323076829956789879361e-01 2.52754523436129129813215721256370e-04
 	 2.34422112868689367162766679086872e-03 2.97507293859899553389869453212668e-02 2.52754523436129129813215721256370e-04
 	 2.34422112868689367162766679086872e-03 9.67905049485323076829956789879361e-01 2.52754523436129129813215721256370e-04
 	 9.67905049485323076829956789879361e-01 2.97507293859899553389869453212668e-02 2.52754523436129129813215721256370e-04
 	 9.67905049485323076829956789879361e-01 2.34422112868689367162766679086872e-03 2.52754523436129129813215721256370e-04
 	 3.95783933296885381825092053986737e-01 1.96140036989502072536928345414253e-03 6.51347724486725748564708293741887e-04
 	 3.95783933296885381825092053986737e-01 6.02254666333219668139520308614010e-01 6.51347724486725748564708293741887e-04
 	 1.96140036989502072536928345414253e-03 3.95783933296885381825092053986737e-01 6.51347724486725748564708293741887e-04
 	 1.96140036989502072536928345414253e-03 6.02254666333219668139520308614010e-01 6.51347724486725748564708293741887e-04
 	 6.02254666333219668139520308614010e-01 3.95783933296885381825092053986737e-01 6.51347724486725748564708293741887e-04
 	 6.02254666333219668139520308614010e-01 1.96140036989502072536928345414253e-03 6.51347724486725748564708293741887e-04
 	 3.51680058776080939342278952608467e-01 1.52636565775219751328606321294501e-01 5.09628972217063790084434771188171e-03
 	 3.51680058776080939342278952608467e-01 4.95683375448699337084690341725945e-01 5.09628972217063790084434771188171e-03
 	 1.52636565775219751328606321294501e-01 3.51680058776080939342278952608467e-01 5.09628972217063790084434771188171e-03
 	 1.52636565775219751328606321294501e-01 4.95683375448699337084690341725945e-01 5.09628972217063790084434771188171e-03
 	 4.95683375448699337084690341725945e-01 3.51680058776080939342278952608467e-01 5.09628972217063790084434771188171e-03
 	 4.95683375448699337084690341725945e-01 1.52636565775219751328606321294501e-01 5.09628972217063790084434771188171e-03
 	 2.02482194261758341458090626474586e-01 1.13425278347502905829102815005172e-01 3.93343524786906890283733062574356e-03
 	 2.02482194261758341458090626474586e-01 6.84092527390738780468382174149156e-01 3.93343524786906890283733062574356e-03
 	 1.13425278347502905829102815005172e-01 2.02482194261758341458090626474586e-01 3.93343524786906890283733062574356e-03
 	 1.13425278347502905829102815005172e-01 6.84092527390738780468382174149156e-01 3.93343524786906890283733062574356e-03
 	 6.84092527390738780468382174149156e-01 2.02482194261758341458090626474586e-01 3.93343524786906890283733062574356e-03
 	 6.84092527390738780468382174149156e-01 1.13425278347502905829102815005172e-01 3.93343524786906890283733062574356e-03
 	 4.22553955222215060771873140765820e-01 5.45213844446831366608030577936006e-02 3.56040462070939586064488580063880e-03
 	 4.22553955222215060771873140765820e-01 5.22924660333101809506217705347808e-01 3.56040462070939586064488580063880e-03
 	 5.45213844446831366608030577936006e-02 4.22553955222215060771873140765820e-01 3.56040462070939586064488580063880e-03
 	 5.45213844446831366608030577936006e-02 5.22924660333101809506217705347808e-01 3.56040462070939586064488580063880e-03
 	 5.22924660333101809506217705347808e-01 4.22553955222215060771873140765820e-01 3.56040462070939586064488580063880e-03
 	 5.22924660333101809506217705347808e-01 5.45213844446831366608030577936006e-02 3.56040462070939586064488580063880e-03
 	 1.24680508847443971554014296998503e-01 6.06049291607722168118144168147410e-02 2.48205723825383481676021268924615e-03
 	 1.24680508847443971554014296998503e-01 8.14714561991783825511959094001213e-01 2.48205723825383481676021268924615e-03
 	 6.06049291607722168118144168147410e-02 1.24680508847443971554014296998503e-01 2.48205723825383481676021268924615e-03
 	 6.06049291607722168118144168147410e-02 8.14714561991783825511959094001213e-01 2.48205723825383481676021268924615e-03
 	 8.14714561991783825511959094001213e-01 1.24680508847443971554014296998503e-01 2.48205723825383481676021268924615e-03
 	 8.14714561991783825511959094001213e-01 6.06049291607722168118144168147410e-02 2.48205723825383481676021268924615e-03
 	 2.55546236402857285252565588962170e-01 3.75889521575177576462323258965625e-02 2.71821873650677668307618084497790e-03
 	 2.55546236402857285252565588962170e-01 7.06864811439624873834475238254527e-01 2.71821873650677668307618084497790e-03
 	 3.75889521575177576462323258965625e-02 2.55546236402857285252565588962170e-01 2.71821873650677668307618084497790e-03
 	 3.75889521575177576462323258965625e-02 7.06864811439624873834475238254527e-01 2.71821873650677668307618084497790e-03
 	 7.06864811439624873834475238254527e-01 2.55546236402857285252565588962170e-01 2.71821873650677668307618084497790e-03
 	 7.06864811439624873834475238254527e-01 3.75889521575177576462323258965625e-02 2.71821873650677668307618084497790e-03
 	 7.45031299353863113443807719704637e-02 4.38633017006165564638520137918931e-03 5.76291470042130803304314401458441e-04
 	 7.45031299353863113443807719704637e-02 9.21110539894552049489107048430014e-01 5.76291470042130803304314401458441e-04
 	 4.38633017006165564638520137918931e-03 7.45031299353863113443807719704637e-02 5.76291470042130803304314401458441e-04
 	 4.38633017006165564638520137918931e-03 9.21110539894552049489107048430014e-01 5.76291470042130803304314401458441e-04
 	 9.21110539894552049489107048430014e-01 7.45031299353863113443807719704637e-02 5.76291470042130803304314401458441e-04
 	 9.21110539894552049489107048430014e-01 4.38633017006165564638520137918931e-03 5.76291470042130803304314401458441e-04
 	 4.16807275523650544446496724049211e-01 1.72734143249371197015307188848965e-02 2.08916634591076524896102739603521e-03
 	 4.16807275523650544446496724049211e-01 5.65919310151412391363123788323719e-01 2.08916634591076524896102739603521e-03
 	 1.72734143249371197015307188848965e-02 4.16807275523650544446496724049211e-01 2.08916634591076524896102739603521e-03
 	 1.72734143249371197015307188848965e-02 5.65919310151412391363123788323719e-01 2.08916634591076524896102739603521e-03
 	 5.65919310151412391363123788323719e-01 4.16807275523650544446496724049211e-01 2.08916634591076524896102739603521e-03
 	 5.65919310151412391363123788323719e-01 1.72734143249371197015307188848965e-02 2.08916634591076524896102739603521e-03
 	 1.92871723006198453331805353627715e-01 6.25780220143109106034629007808689e-02 3.18121152643343870283776375629259e-03
 	 1.92871723006198453331805353627715e-01 7.44550254979490566675792706519132e-01 3.18121152643343870283776375629259e-03
 	 6.25780220143109106034629007808689e-02 1.92871723006198453331805353627715e-01 3.18121152643343870283776375629259e-03
 	 6.25780220143109106034629007808689e-02 7.44550254979490566675792706519132e-01 3.18121152643343870283776375629259e-03
 	 7.44550254979490566675792706519132e-01 1.92871723006198453331805353627715e-01 3.18121152643343870283776375629259e-03
 	 7.44550254979490566675792706519132e-01 6.25780220143109106034629007808689e-02 3.18121152643343870283776375629259e-03
 	 4.73478189395524634575096456501342e-02 1.84079470312829319988967569088345e-02 9.06384644141955365601037719613942e-04
 	 4.73478189395524634575096456501342e-02 9.34244234029164677401979588466929e-01 9.06384644141955365601037719613942e-04
 	 1.84079470312829319988967569088345e-02 4.73478189395524634575096456501342e-02 9.06384644141955365601037719613942e-04
 	 1.84079470312829319988967569088345e-02 9.34244234029164677401979588466929e-01 9.06384644141955365601037719613942e-04
 	 9.34244234029164677401979588466929e-01 4.73478189395524634575096456501342e-02 9.06384644141955365601037719613942e-04
 	 9.34244234029164677401979588466929e-01 1.84079470312829319988967569088345e-02 9.06384644141955365601037719613942e-04
 	 3.41905005347527657377781906689052e-01 4.29032089427714424800797132775187e-02 3.34497962252281290720934414650856e-03
 	 3.41905005347527657377781906689052e-01 6.15191785709700900142138380033430e-01 3.34497962252281290720934414650856e-03
 	 4.29032089427714424800797132775187e-02 3.41905005347527657377781906689052e-01 3.34497962252281290720934414650856e-03
 	 4.29032089427714424800797132775187e-02 6.15191785709700900142138380033430e-01 3.34497962252281290720934414650856e-03
 	 6.15191785709700900142138380033430e-01 3.41905005347527657377781906689052e-01 3.34497962252281290720934414650856e-03
 	 6.15191785709700900142138380033430e-01 4.29032089427714424800797132775187e-02 3.34497962252281290720934414650856e-03
 	 3.25813953057509653188361653519678e-01 1.31890837790157033904137051649741e-02 1.81985674247372021354596238751355e-03
 	 3.25813953057509653188361653519678e-01 6.60996963163474560154497794428607e-01 1.81985674247372021354596238751355e-03
 	 1.31890837790157033904137051649741e-02 3.25813953057509653188361653519678e-01 1.81985674247372021354596238751355e-03
 	 1.31890837790157033904137051649741e-02 6.60996963163474560154497794428607e-01 1.81985674247372021354596238751355e-03
 	 6.60996963163474560154497794428607e-01 3.25813953057509653188361653519678e-01 1.81985674247372021354596238751355e-03
 	 6.60996963163474560154497794428607e-01 1.31890837790157033904137051649741e-02 1.81985674247372021354596238751355e-03
 	 2.89425948757137285749507782384171e-01 1.19688163070959881391364110214681e-03 4.64685168846559022107906011811451e-04
 	 2.89425948757137285749507782384171e-01 7.09377169612153024580436522228410e-01 4.64685168846559022107906011811451e-04
 	 1.19688163070959881391364110214681e-03 2.89425948757137285749507782384171e-01 4.64685168846559022107906011811451e-04
 	 1.19688163070959881391364110214681e-03 7.09377169612153024580436522228410e-01 4.64685168846559022107906011811451e-04
 	 7.09377169612153024580436522228410e-01 2.89425948757137285749507782384171e-01 4.64685168846559022107906011811451e-04
 	 7.09377169612153024580436522228410e-01 1.19688163070959881391364110214681e-03 4.64685168846559022107906011811451e-04
 	 2.98789795676013270053772430401295e-01 2.19132761430176847827766550835804e-01 6.44779339399209703437287899419061e-03
 	 2.98789795676013270053772430401295e-01 4.82077442893809882118461018762900e-01 6.44779339399209703437287899419061e-03
 	 2.19132761430176847827766550835804e-01 2.98789795676013270053772430401295e-01 6.44779339399209703437287899419061e-03
 	 2.19132761430176847827766550835804e-01 4.82077442893809882118461018762900e-01 6.44779339399209703437287899419061e-03
 	 4.82077442893809882118461018762900e-01 2.98789795676013270053772430401295e-01 6.44779339399209703437287899419061e-03
 	 4.82077442893809882118461018762900e-01 2.19132761430176847827766550835804e-01 6.44779339399209703437287899419061e-03
 	 2.74475747742794984329606222672737e-01 8.11298915693309669050492516362283e-02 4.23794885856830939180328599036329e-03
 	 2.74475747742794984329606222672737e-01 6.44394360687874034887556717876578e-01 4.23794885856830939180328599036329e-03
 	 8.11298915693309669050492516362283e-02 2.74475747742794984329606222672737e-01 4.23794885856830939180328599036329e-03
 	 8.11298915693309669050492516362283e-02 6.44394360687874034887556717876578e-01 4.23794885856830939180328599036329e-03
 	 6.44394360687874034887556717876578e-01 2.74475747742794984329606222672737e-01 4.23794885856830939180328599036329e-03
 	 6.44394360687874034887556717876578e-01 8.11298915693309669050492516362283e-02 4.23794885856830939180328599036329e-03
 	 3.53229873891415580011710062535712e-01 9.52781144820168263143145281901525e-02 4.81113776584836221050789362152500e-03
 	 3.53229873891415580011710062535712e-01 5.51492011626567579796187601459678e-01 4.81113776584836221050789362152500e-03
 	 9.52781144820168263143145281901525e-02 3.53229873891415580011710062535712e-01 4.81113776584836221050789362152500e-03
 	 9.52781144820168263143145281901525e-02 5.51492011626567579796187601459678e-01 4.81113776584836221050789362152500e-03
 	 5.51492011626567579796187601459678e-01 3.53229873891415580011710062535712e-01 4.81113776584836221050789362152500e-03
 	 5.51492011626567579796187601459678e-01 9.52781144820168263143145281901525e-02 4.81113776584836221050789362152500e-03
 	 2.66367882475071815484568560350453e-01 1.46888708002111900707831182444352e-01 5.79983451569281074217121485503412e-03
 	 2.66367882475071815484568560350453e-01 5.86743409522816339318751488463022e-01 5.79983451569281074217121485503412e-03
 	 1.46888708002111900707831182444352e-01 2.66367882475071815484568560350453e-01 5.79983451569281074217121485503412e-03
 	 1.46888708002111900707831182444352e-01 5.86743409522816339318751488463022e-01 5.79983451569281074217121485503412e-03
 	 5.86743409522816339318751488463022e-01 2.66367882475071815484568560350453e-01 5.79983451569281074217121485503412e-03
 	 5.86743409522816339318751488463022e-01 1.46888708002111900707831182444352e-01 5.79983451569281074217121485503412e-03
 	 9.60481521010510957969685819080041e-02 2.75306300785874945302733607377377e-02 1.83329335246342297639776663942257e-03
 	 9.60481521010510957969685819080041e-02 8.76421217820361420081098913215101e-01 1.83329335246342297639776663942257e-03
 	 2.75306300785874945302733607377377e-02 9.60481521010510957969685819080041e-02 1.83329335246342297639776663942257e-03
 	 2.75306300785874945302733607377377e-02 8.76421217820361420081098913215101e-01 1.83329335246342297639776663942257e-03
 	 8.76421217820361420081098913215101e-01 9.60481521010510957969685819080041e-02 1.83329335246342297639776663942257e-03
 	 8.76421217820361420081098913215101e-01 2.75306300785874945302733607377377e-02 1.83329335246342297639776663942257e-03
 	 1.67407824778356056905082027697063e-01 2.58751082199381692017237099889826e-02 2.22266899562620053390493701783726e-03
 	 1.67407824778356056905082027697063e-01 8.06717067001705756545959502545884e-01 2.22266899562620053390493701783726e-03
 	 2.58751082199381692017237099889826e-02 1.67407824778356056905082027697063e-01 2.22266899562620053390493701783726e-03
 	 2.58751082199381692017237099889826e-02 8.06717067001705756545959502545884e-01 2.22266899562620053390493701783726e-03
 	 8.06717067001705756545959502545884e-01 1.67407824778356056905082027697063e-01 2.22266899562620053390493701783726e-03
 	 8.06717067001705756545959502545884e-01 2.58751082199381692017237099889826e-02 2.22266899562620053390493701783726e-03
 	 1.30677633770288320613772725664603e-01 5.79731868473983870393428929901347e-03 9.10626392061236224206854927842869e-04
 	 1.30677633770288320613772725664603e-01 8.63525047544971835478122557105962e-01 9.10626392061236224206854927842869e-04
 	 5.79731868473983870393428929901347e-03 1.30677633770288320613772725664603e-01 9.10626392061236224206854927842869e-04
 	 5.79731868473983870393428929901347e-03 8.63525047544971835478122557105962e-01 9.10626392061236224206854927842869e-04
 	 8.63525047544971835478122557105962e-01 1.30677633770288320613772725664603e-01 9.10626392061236224206854927842869e-04
 	 8.63525047544971835478122557105962e-01 5.79731868473983870393428929901347e-03 9.10626392061236224206854927842869e-04
 	 ];
 
 	 case  32 

 	 % ALG. DEG.:   32
 	 % PTS CARD.:  193
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.7e-15  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 6.51503549788128803049724879770110e-03
 	 1.45744546236985564845178853232710e-03 1.45744546236985564845178853232710e-03 2.66619511667080602026168312246313e-05
 	 1.45744546236985564845178853232710e-03 9.97085109075260267452733842219459e-01 2.66619511667080602026168312246313e-05
 	 9.97085109075260267452733842219459e-01 1.45744546236985564845178853232710e-03 2.66619511667080602026168312246313e-05
 	 4.98650893578847342890725258257589e-01 4.98650893578847342890725258257589e-01 7.07313623831419785274732259239272e-04
 	 4.98650893578847342890725258257589e-01 2.69821284230531421854948348482139e-03 7.07313623831419785274732259239272e-04
 	 2.69821284230531421854948348482139e-03 4.98650893578847342890725258257589e-01 7.07313623831419785274732259239272e-04
 	 4.81168115995836753739922642125748e-01 4.81168115995836753739922642125748e-01 2.79000757120663510704727805489256e-03
 	 4.81168115995836753739922642125748e-01 3.76637680083264925201547157485038e-02 2.79000757120663510704727805489256e-03
 	 3.76637680083264925201547157485038e-02 4.81168115995836753739922642125748e-01 2.79000757120663510704727805489256e-03
 	 4.52285756511600522955518499657046e-01 4.52285756511600522955518499657046e-01 4.18929535206312257666905196629159e-03
 	 4.52285756511600522955518499657046e-01 9.54284869767989540889630006859079e-02 4.18929535206312257666905196629159e-03
 	 9.54284869767989540889630006859079e-02 4.52285756511600522955518499657046e-01 4.18929535206312257666905196629159e-03
 	 3.76328758047918987550417568854755e-01 3.76328758047918987550417568854755e-01 6.33064728024301630326942103010879e-03
 	 3.76328758047918987550417568854755e-01 2.47342483904162024899164862290490e-01 6.33064728024301630326942103010879e-03
 	 2.47342483904162024899164862290490e-01 3.76328758047918987550417568854755e-01 6.33064728024301630326942103010879e-03
 	 2.83018279849573173301280348823639e-01 2.83018279849573173301280348823639e-01 6.44136658858768165053509946460508e-03
 	 2.83018279849573173301280348823639e-01 4.33963440300853653397439302352723e-01 6.44136658858768165053509946460508e-03
 	 4.33963440300853653397439302352723e-01 2.83018279849573173301280348823639e-01 6.44136658858768165053509946460508e-03
 	 4.13679784325413357759515520228888e-01 4.13679784325413357759515520228888e-01 5.44023301346712503251401571446877e-03
 	 4.13679784325413357759515520228888e-01 1.72640431349173284480968959542224e-01 5.44023301346712503251401571446877e-03
 	 1.72640431349173284480968959542224e-01 4.13679784325413357759515520228888e-01 5.44023301346712503251401571446877e-03
 	 3.02691910404441627546745507970627e-02 3.02691910404441627546745507970627e-02 9.29639126596945065961197229853497e-04
 	 3.02691910404441627546745507970627e-02 9.39461617919111646735075282776961e-01 9.29639126596945065961197229853497e-04
 	 9.39461617919111646735075282776961e-01 3.02691910404441627546745507970627e-02 9.29639126596945065961197229853497e-04
 	 1.28101964801118073378205508561223e-02 1.28101964801118073378205508561223e-02 4.00870525836536913209112720224425e-04
 	 1.28101964801118073378205508561223e-02 9.74379607039776329813207667029928e-01 4.00870525836536913209112720224425e-04
 	 9.74379607039776329813207667029928e-01 1.28101964801118073378205508561223e-02 4.00870525836536913209112720224425e-04
 	 6.20106498262642247265574724224280e-02 6.20106498262642247265574724224280e-02 1.98817429746268046000801099637556e-03
 	 6.20106498262642247265574724224280e-02 8.75978700347471495035733823897317e-01 1.98817429746268046000801099637556e-03
 	 8.75978700347471495035733823897317e-01 6.20106498262642247265574724224280e-02 1.98817429746268046000801099637556e-03
 	 2.29277996928069882631717746335198e-01 2.29277996928069882631717746335198e-01 6.26779886282444187450835215713596e-03
 	 2.29277996928069882631717746335198e-01 5.41444006143860234736564507329604e-01 6.26779886282444187450835215713596e-03
 	 5.41444006143860234736564507329604e-01 2.29277996928069882631717746335198e-01 6.26779886282444187450835215713596e-03
 	 1.01958826900269583504154979891609e-01 1.01958826900269583504154979891609e-01 3.31469955752957713690509677917362e-03
 	 1.01958826900269583504154979891609e-01 7.96082346199460832991690040216781e-01 3.31469955752957713690509677917362e-03
 	 7.96082346199460832991690040216781e-01 1.01958826900269583504154979891609e-01 3.31469955752957713690509677917362e-03
 	 2.06831686315902013584278051894216e-01 1.58867941229046738538244198934990e-01 4.17460956476896957040301217034539e-03
 	 2.06831686315902013584278051894216e-01 6.34300372455051331144204596057534e-01 4.17460956476896957040301217034539e-03
 	 1.58867941229046738538244198934990e-01 2.06831686315902013584278051894216e-01 4.17460956476896957040301217034539e-03
 	 1.58867941229046738538244198934990e-01 6.34300372455051331144204596057534e-01 4.17460956476896957040301217034539e-03
 	 6.34300372455051331144204596057534e-01 2.06831686315902013584278051894216e-01 4.17460956476896957040301217034539e-03
 	 6.34300372455051331144204596057534e-01 1.58867941229046738538244198934990e-01 4.17460956476896957040301217034539e-03
 	 4.46761426533167027574933172218152e-01 1.47664424308546586572798986480848e-02 1.52032612888649935889429087865210e-03
 	 4.46761426533167027574933172218152e-01 5.38472131035978351931703400623519e-01 1.52032612888649935889429087865210e-03
 	 1.47664424308546586572798986480848e-02 4.46761426533167027574933172218152e-01 1.52032612888649935889429087865210e-03
 	 1.47664424308546586572798986480848e-02 5.38472131035978351931703400623519e-01 1.52032612888649935889429087865210e-03
 	 5.38472131035978351931703400623519e-01 4.46761426533167027574933172218152e-01 1.52032612888649935889429087865210e-03
 	 5.38472131035978351931703400623519e-01 1.47664424308546586572798986480848e-02 1.52032612888649935889429087865210e-03
 	 2.32466207646378680840015817921085e-01 5.14311272402330696418282229842589e-02 2.64302180126624059602891136933067e-03
 	 2.32466207646378680840015817921085e-01 7.16102665113388270334837670816341e-01 2.64302180126624059602891136933067e-03
 	 5.14311272402330696418282229842589e-02 2.32466207646378680840015817921085e-01 2.64302180126624059602891136933067e-03
 	 5.14311272402330696418282229842589e-02 7.16102665113388270334837670816341e-01 2.64302180126624059602891136933067e-03
 	 7.16102665113388270334837670816341e-01 2.32466207646378680840015817921085e-01 2.64302180126624059602891136933067e-03
 	 7.16102665113388270334837670816341e-01 5.14311272402330696418282229842589e-02 2.64302180126624059602891136933067e-03
 	 1.16834926706957942244002879306208e-01 1.95597403645923935411321537003460e-02 1.24663496233453469606844432604476e-03
 	 1.16834926706957942244002879306208e-01 8.63605332928449653806524111132603e-01 1.24663496233453469606844432604476e-03
 	 1.95597403645923935411321537003460e-02 1.16834926706957942244002879306208e-01 1.24663496233453469606844432604476e-03
 	 1.95597403645923935411321537003460e-02 8.63605332928449653806524111132603e-01 1.24663496233453469606844432604476e-03
 	 8.63605332928449653806524111132603e-01 1.16834926706957942244002879306208e-01 1.24663496233453469606844432604476e-03
 	 8.63605332928449653806524111132603e-01 1.95597403645923935411321537003460e-02 1.24663496233453469606844432604476e-03
 	 3.28240545844934006325388509139884e-01 1.26185667501572066490078682932108e-02 1.51029052835681344875429221730201e-03
 	 3.28240545844934006325388509139884e-01 6.59140887404908837332584425894311e-01 1.51029052835681344875429221730201e-03
 	 1.26185667501572066490078682932108e-02 3.28240545844934006325388509139884e-01 1.51029052835681344875429221730201e-03
 	 1.26185667501572066490078682932108e-02 6.59140887404908837332584425894311e-01 1.51029052835681344875429221730201e-03
 	 6.59140887404908837332584425894311e-01 3.28240545844934006325388509139884e-01 1.51029052835681344875429221730201e-03
 	 6.59140887404908837332584425894311e-01 1.26185667501572066490078682932108e-02 1.51029052835681344875429221730201e-03
 	 2.59350932003120149271779837363283e-01 2.10621566756392201991143764416847e-02 1.82208778843809108584361755589498e-03
 	 2.59350932003120149271779837363283e-01 7.19586911321240529915144179540221e-01 1.82208778843809108584361755589498e-03
 	 2.10621566756392201991143764416847e-02 2.59350932003120149271779837363283e-01 1.82208778843809108584361755589498e-03
 	 2.10621566756392201991143764416847e-02 7.19586911321240529915144179540221e-01 1.82208778843809108584361755589498e-03
 	 7.19586911321240529915144179540221e-01 2.59350932003120149271779837363283e-01 1.82208778843809108584361755589498e-03
 	 7.19586911321240529915144179540221e-01 2.10621566756392201991143764416847e-02 1.82208778843809108584361755589498e-03
 	 1.65463998237349529940587444798439e-01 1.17543509254347977588395224302076e-01 3.74054484958007832373638734679844e-03
 	 1.65463998237349529940587444798439e-01 7.16992492508302436959866099641658e-01 3.74054484958007832373638734679844e-03
 	 1.17543509254347977588395224302076e-01 1.65463998237349529940587444798439e-01 3.74054484958007832373638734679844e-03
 	 1.17543509254347977588395224302076e-01 7.16992492508302436959866099641658e-01 3.74054484958007832373638734679844e-03
 	 7.16992492508302436959866099641658e-01 1.65463998237349529940587444798439e-01 3.74054484958007832373638734679844e-03
 	 7.16992492508302436959866099641658e-01 1.17543509254347977588395224302076e-01 3.74054484958007832373638734679844e-03
 	 3.82464907380937246816898777979077e-01 2.92988505404852273006355289908242e-02 2.28407706778600751856833639408251e-03
 	 3.82464907380937246816898777979077e-01 5.88236242078577609149192539916839e-01 2.28407706778600751856833639408251e-03
 	 2.92988505404852273006355289908242e-02 3.82464907380937246816898777979077e-01 2.28407706778600751856833639408251e-03
 	 2.92988505404852273006355289908242e-02 5.88236242078577609149192539916839e-01 2.28407706778600751856833639408251e-03
 	 5.88236242078577609149192539916839e-01 3.82464907380937246816898777979077e-01 2.28407706778600751856833639408251e-03
 	 5.88236242078577609149192539916839e-01 2.92988505404852273006355289908242e-02 2.28407706778600751856833639408251e-03
 	 3.97817072646720837347800170391565e-01 3.44282165227435561077884429437290e-03 8.42601820267144035678241742459704e-04
 	 3.97817072646720837347800170391565e-01 5.98740105701004776683760155719938e-01 8.42601820267144035678241742459704e-04
 	 3.44282165227435561077884429437290e-03 3.97817072646720837347800170391565e-01 8.42601820267144035678241742459704e-04
 	 3.44282165227435561077884429437290e-03 5.98740105701004776683760155719938e-01 8.42601820267144035678241742459704e-04
 	 5.98740105701004776683760155719938e-01 3.97817072646720837347800170391565e-01 8.42601820267144035678241742459704e-04
 	 5.98740105701004776683760155719938e-01 3.44282165227435561077884429437290e-03 8.42601820267144035678241742459704e-04
 	 3.25417469646690105111730417775107e-01 9.03702811448642562286437396323890e-02 4.10460332323965386425168588857559e-03
 	 3.25417469646690105111730417775107e-01 5.84212249208445721926352689479245e-01 4.10460332323965386425168588857559e-03
 	 9.03702811448642562286437396323890e-02 3.25417469646690105111730417775107e-01 4.10460332323965386425168588857559e-03
 	 9.03702811448642562286437396323890e-02 5.84212249208445721926352689479245e-01 4.10460332323965386425168588857559e-03
 	 5.84212249208445721926352689479245e-01 3.25417469646690105111730417775107e-01 4.10460332323965386425168588857559e-03
 	 5.84212249208445721926352689479245e-01 9.03702811448642562286437396323890e-02 4.10460332323965386425168588857559e-03
 	 1.13339191487603074826040483458200e-01 5.06976359267404738662143870442378e-02 2.23283842380996673179782696649909e-03
 	 1.13339191487603074826040483458200e-01 8.35963172585656444368851225590333e-01 2.23283842380996673179782696649909e-03
 	 5.06976359267404738662143870442378e-02 1.13339191487603074826040483458200e-01 2.23283842380996673179782696649909e-03
 	 5.06976359267404738662143870442378e-02 8.35963172585656444368851225590333e-01 2.23283842380996673179782696649909e-03
 	 8.35963172585656444368851225590333e-01 1.13339191487603074826040483458200e-01 2.23283842380996673179782696649909e-03
 	 8.35963172585656444368851225590333e-01 5.06976359267404738662143870442378e-02 2.23283842380996673179782696649909e-03
 	 3.11041632827641745251412430661730e-01 4.79444789155617986931012808327068e-02 3.10141736076142158010093830000642e-03
 	 3.11041632827641745251412430661730e-01 6.41013888256796504627743615856161e-01 3.10141736076142158010093830000642e-03
 	 4.79444789155617986931012808327068e-02 3.11041632827641745251412430661730e-01 3.10141736076142158010093830000642e-03
 	 4.79444789155617986931012808327068e-02 6.41013888256796504627743615856161e-01 3.10141736076142158010093830000642e-03
 	 6.41013888256796504627743615856161e-01 3.11041632827641745251412430661730e-01 3.10141736076142158010093830000642e-03
 	 6.41013888256796504627743615856161e-01 4.79444789155617986931012808327068e-02 3.10141736076142158010093830000642e-03
 	 2.98837135388912988887000210525002e-01 1.27665738027984911225065633999520e-03 4.44446271575963465678971164862787e-04
 	 2.98837135388912988887000210525002e-01 6.99886207230807189105803445272613e-01 4.44446271575963465678971164862787e-04
 	 1.27665738027984911225065633999520e-03 2.98837135388912988887000210525002e-01 4.44446271575963465678971164862787e-04
 	 1.27665738027984911225065633999520e-03 6.99886207230807189105803445272613e-01 4.44446271575963465678971164862787e-04
 	 6.99886207230807189105803445272613e-01 2.98837135388912988887000210525002e-01 4.44446271575963465678971164862787e-04
 	 6.99886207230807189105803445272613e-01 1.27665738027984911225065633999520e-03 4.44446271575963465678971164862787e-04
 	 1.52112280943783789721734933664266e-01 4.26256341511160007085035061891176e-03 7.42614664592583821264848431553673e-04
 	 1.52112280943783789721734933664266e-01 8.43625155641104629289372951461701e-01 7.42614664592583821264848431553673e-04
 	 4.26256341511160007085035061891176e-03 1.52112280943783789721734933664266e-01 7.42614664592583821264848431553673e-04
 	 4.26256341511160007085035061891176e-03 8.43625155641104629289372951461701e-01 7.42614664592583821264848431553673e-04
 	 8.43625155641104629289372951461701e-01 1.52112280943783789721734933664266e-01 7.42614664592583821264848431553673e-04
 	 8.43625155641104629289372951461701e-01 4.26256341511160007085035061891176e-03 7.42614664592583821264848431553673e-04
 	 8.86617050339115198021033847908257e-02 3.85251198871905528239856231209615e-03 5.56353172795318300786204801511303e-04
 	 8.86617050339115198021033847908257e-02 9.07485782977369370705389428621856e-01 5.56353172795318300786204801511303e-04
 	 3.85251198871905528239856231209615e-03 8.86617050339115198021033847908257e-02 5.56353172795318300786204801511303e-04
 	 3.85251198871905528239856231209615e-03 9.07485782977369370705389428621856e-01 5.56353172795318300786204801511303e-04
 	 9.07485782977369370705389428621856e-01 8.86617050339115198021033847908257e-02 5.56353172795318300786204801511303e-04
 	 9.07485782977369370705389428621856e-01 3.85251198871905528239856231209615e-03 5.56353172795318300786204801511303e-04
 	 3.19152580593060508640235184429912e-01 2.01900148632476683641101544708363e-01 5.98667955124138843198133841383424e-03
 	 3.19152580593060508640235184429912e-01 4.78947270774462807718663270861725e-01 5.98667955124138843198133841383424e-03
 	 2.01900148632476683641101544708363e-01 3.19152580593060508640235184429912e-01 5.98667955124138843198133841383424e-03
 	 2.01900148632476683641101544708363e-01 4.78947270774462807718663270861725e-01 5.98667955124138843198133841383424e-03
 	 4.78947270774462807718663270861725e-01 3.19152580593060508640235184429912e-01 5.98667955124138843198133841383424e-03
 	 4.78947270774462807718663270861725e-01 2.01900148632476683641101544708363e-01 5.98667955124138843198133841383424e-03
 	 1.66755693582133324159855192192481e-01 6.77103932212691633774070965046121e-02 2.94115803140992861791636059365374e-03
 	 1.66755693582133324159855192192481e-01 7.65533913196597581851676750375191e-01 2.94115803140992861791636059365374e-03
 	 6.77103932212691633774070965046121e-02 1.66755693582133324159855192192481e-01 2.94115803140992861791636059365374e-03
 	 6.77103932212691633774070965046121e-02 7.65533913196597581851676750375191e-01 2.94115803140992861791636059365374e-03
 	 7.65533913196597581851676750375191e-01 1.66755693582133324159855192192481e-01 2.94115803140992861791636059365374e-03
 	 7.65533913196597581851676750375191e-01 6.77103932212691633774070965046121e-02 2.94115803140992861791636059365374e-03
 	 2.42137924019432793087958089017775e-01 9.55724171106545339338111944016418e-02 4.22437173597556281379183928947896e-03
 	 2.42137924019432793087958089017775e-01 6.62289658869912645222655100951670e-01 4.22437173597556281379183928947896e-03
 	 9.55724171106545339338111944016418e-02 2.42137924019432793087958089017775e-01 4.22437173597556281379183928947896e-03
 	 9.55724171106545339338111944016418e-02 6.62289658869912645222655100951670e-01 4.22437173597556281379183928947896e-03
 	 6.62289658869912645222655100951670e-01 2.42137924019432793087958089017775e-01 4.22437173597556281379183928947896e-03
 	 6.62289658869912645222655100951670e-01 9.55724171106545339338111944016418e-02 4.22437173597556281379183928947896e-03
 	 2.79861747997829701795069468062138e-01 1.50370864573458273838468812755309e-01 5.10572795818304073223181660523551e-03
 	 2.79861747997829701795069468062138e-01 5.69767387428712024366461719182553e-01 5.10572795818304073223181660523551e-03
 	 1.50370864573458273838468812755309e-01 2.79861747997829701795069468062138e-01 5.10572795818304073223181660523551e-03
 	 1.50370864573458273838468812755309e-01 5.69767387428712024366461719182553e-01 5.10572795818304073223181660523551e-03
 	 5.69767387428712024366461719182553e-01 2.79861747997829701795069468062138e-01 5.10572795818304073223181660523551e-03
 	 5.69767387428712024366461719182553e-01 1.50370864573458273838468812755309e-01 5.10572795818304073223181660523551e-03
 	 6.73984002072566534824460404706770e-02 2.43498506845871223736033073237195e-02 1.24497957660826331395542698743384e-03
 	 6.73984002072566534824460404706770e-02 9.08251749108156203327268940483918e-01 1.24497957660826331395542698743384e-03
 	 2.43498506845871223736033073237195e-02 6.73984002072566534824460404706770e-02 1.24497957660826331395542698743384e-03
 	 2.43498506845871223736033073237195e-02 9.08251749108156203327268940483918e-01 1.24497957660826331395542698743384e-03
 	 9.08251749108156203327268940483918e-01 6.73984002072566534824460404706770e-02 1.24497957660826331395542698743384e-03
 	 9.08251749108156203327268940483918e-01 2.43498506845871223736033073237195e-02 1.24497957660826331395542698743384e-03
 	 3.71687966693420357433552680959110e-01 1.29387867366923425826996663090540e-01 4.94425282751114174989437444196483e-03
 	 3.71687966693420357433552680959110e-01 4.98924165939656272250601887208177e-01 4.94425282751114174989437444196483e-03
 	 1.29387867366923425826996663090540e-01 3.71687966693420357433552680959110e-01 4.94425282751114174989437444196483e-03
 	 1.29387867366923425826996663090540e-01 4.98924165939656272250601887208177e-01 4.94425282751114174989437444196483e-03
 	 4.98924165939656272250601887208177e-01 3.71687966693420357433552680959110e-01 4.94425282751114174989437444196483e-03
 	 4.98924165939656272250601887208177e-01 1.29387867366923425826996663090540e-01 4.94425282751114174989437444196483e-03
 	 4.05628149065882848134378946269862e-01 6.32274204565012321044292775695794e-02 3.70455657146824719749833576543097e-03
 	 4.05628149065882848134378946269862e-01 5.31144430477615947516767391789472e-01 3.70455657146824719749833576543097e-03
 	 6.32274204565012321044292775695794e-02 4.05628149065882848134378946269862e-01 3.70455657146824719749833576543097e-03
 	 6.32274204565012321044292775695794e-02 5.31144430477615947516767391789472e-01 3.70455657146824719749833576543097e-03
 	 5.31144430477615947516767391789472e-01 4.05628149065882848134378946269862e-01 3.70455657146824719749833576543097e-03
 	 5.31144430477615947516767391789472e-01 6.32274204565012321044292775695794e-02 3.70455657146824719749833576543097e-03
 	 2.21980165737481027754540718888165e-01 5.26663302076577251320532724321311e-03 9.72796620491533643552972687729152e-04
 	 2.21980165737481027754540718888165e-01 7.72753201241753173711401814216515e-01 9.72796620491533643552972687729152e-04
 	 5.26663302076577251320532724321311e-03 2.21980165737481027754540718888165e-01 9.72796620491533643552972687729152e-04
 	 5.26663302076577251320532724321311e-03 7.72753201241753173711401814216515e-01 9.72796620491533643552972687729152e-04
 	 7.72753201241753173711401814216515e-01 2.21980165737481027754540718888165e-01 9.72796620491533643552972687729152e-04
 	 7.72753201241753173711401814216515e-01 5.26663302076577251320532724321311e-03 9.72796620491533643552972687729152e-04
 	 1.78325682037862948137174612384115e-01 2.61588819796510496651364974241005e-02 2.13041829825008242546569015019031e-03
 	 1.78325682037862948137174612384115e-01 7.95515435982486085464415737078525e-01 2.13041829825008242546569015019031e-03
 	 2.61588819796510496651364974241005e-02 1.78325682037862948137174612384115e-01 2.13041829825008242546569015019031e-03
 	 2.61588819796510496651364974241005e-02 7.95515435982486085464415737078525e-01 2.13041829825008242546569015019031e-03
 	 7.95515435982486085464415737078525e-01 1.78325682037862948137174612384115e-01 2.13041829825008242546569015019031e-03
 	 7.95515435982486085464415737078525e-01 2.61588819796510496651364974241005e-02 2.13041829825008242546569015019031e-03
 	 4.26221905914095089418225370536675e-02 5.55476787043224142642605656305932e-03 5.27687184808808547147040979297117e-04
 	 4.26221905914095089418225370536675e-02 9.51823041538158332031116515281610e-01 5.27687184808808547147040979297117e-04
 	 5.55476787043224142642605656305932e-03 4.26221905914095089418225370536675e-02 5.27687184808808547147040979297117e-04
 	 5.55476787043224142642605656305932e-03 9.51823041538158332031116515281610e-01 5.27687184808808547147040979297117e-04
 	 9.51823041538158332031116515281610e-01 4.26221905914095089418225370536675e-02 5.27687184808808547147040979297117e-04
 	 9.51823041538158332031116515281610e-01 5.55476787043224142642605656305932e-03 5.27687184808808547147040979297117e-04
 	 1.43443003792803787377341251385587e-02 6.23098020345069585589070637610121e-04 8.50441238712439719375432711778728e-05
 	 1.43443003792803787377341251385587e-02 9.85032601600374535522064434189815e-01 8.50441238712439719375432711778728e-05
 	 6.23098020345069585589070637610121e-04 1.43443003792803787377341251385587e-02 8.50441238712439719375432711778728e-05
 	 6.23098020345069585589070637610121e-04 9.85032601600374535522064434189815e-01 8.50441238712439719375432711778728e-05
 	 9.85032601600374535522064434189815e-01 1.43443003792803787377341251385587e-02 8.50441238712439719375432711778728e-05
 	 9.85032601600374535522064434189815e-01 6.23098020345069585589070637610121e-04 8.50441238712439719375432711778728e-05
 	 ];
 
 	 case  33 

 	 % ALG. DEG.:   33
 	 % PTS CARD.:  204
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 8.66842399345696401624650206940714e-02 8.66842399345696401624650206940714e-02 1.60118200620710366376131528198812e-03
 	 8.66842399345696401624650206940714e-02 8.26631520130860719675069958611857e-01 1.60118200620710366376131528198812e-03
 	 8.26631520130860719675069958611857e-01 8.66842399345696401624650206940714e-02 1.60118200620710366376131528198812e-03
 	 4.09427960802643320370464152802015e-01 4.09427960802643320370464152802015e-01 3.41733996723404516784872164691933e-03
 	 4.09427960802643320370464152802015e-01 1.81144078394713359259071694395971e-01 3.41733996723404516784872164691933e-03
 	 1.81144078394713359259071694395971e-01 4.09427960802643320370464152802015e-01 3.41733996723404516784872164691933e-03
 	 3.78333538296242721798989805392921e-01 3.78333538296242721798989805392921e-01 4.46708090406837312474896961589366e-03
 	 3.78333538296242721798989805392921e-01 2.43332923407514556402020389214158e-01 4.46708090406837312474896961589366e-03
 	 2.43332923407514556402020389214158e-01 3.78333538296242721798989805392921e-01 4.46708090406837312474896961589366e-03
 	 4.98979717860051186217873464556760e-01 4.98979717860051186217873464556760e-01 5.20545618643210739745486037577393e-04
 	 4.98979717860051186217873464556760e-01 2.04056427989762756425307088647969e-03 5.20545618643210739745486037577393e-04
 	 2.04056427989762756425307088647969e-03 4.98979717860051186217873464556760e-01 5.20545618643210739745486037577393e-04
 	 2.59660668008721118305004438298056e-01 2.59660668008721118305004438298056e-01 4.86942861834268724691154872630250e-03
 	 2.59660668008721118305004438298056e-01 4.80678663982557763389991123403888e-01 4.86942861834268724691154872630250e-03
 	 4.80678663982557763389991123403888e-01 2.59660668008721118305004438298056e-01 4.86942861834268724691154872630250e-03
 	 4.78511973256382172614564751711441e-01 4.78511973256382172614564751711441e-01 2.73216284202301923703104513663220e-03
 	 4.78511973256382172614564751711441e-01 4.29760534872356547708704965771176e-02 2.73216284202301923703104513663220e-03
 	 4.29760534872356547708704965771176e-02 4.78511973256382172614564751711441e-01 2.73216284202301923703104513663220e-03
 	 2.35174430579130483431882225886511e-02 2.35174430579130483431882225886511e-02 6.90684531513952428352642876063783e-04
 	 2.35174430579130483431882225886511e-02 9.52965113884173931069199170451611e-01 6.90684531513952428352642876063783e-04
 	 9.52965113884173931069199170451611e-01 2.35174430579130483431882225886511e-02 6.90684531513952428352642876063783e-04
 	 3.06023861760360560424487630371004e-01 3.06023861760360560424487630371004e-01 6.04436999045828392274071205747532e-03
 	 3.06023861760360560424487630371004e-01 3.87952276479278879151024739257991e-01 6.04436999045828392274071205747532e-03
 	 3.87952276479278879151024739257991e-01 3.06023861760360560424487630371004e-01 6.04436999045828392274071205747532e-03
 	 1.46489050716642699168090757666505e-01 1.46489050716642699168090757666505e-01 3.68872324836709694281799976067759e-03
 	 1.46489050716642699168090757666505e-01 7.07021898566714601663818484666990e-01 3.68872324836709694281799976067759e-03
 	 7.07021898566714601663818484666990e-01 1.46489050716642699168090757666505e-01 3.68872324836709694281799976067759e-03
 	 5.43792032794962812425332288057689e-02 5.43792032794962812425332288057689e-02 1.60467522197081072406199542257355e-03
 	 5.43792032794962812425332288057689e-02 8.91241593441007395881570118945092e-01 1.60467522197081072406199542257355e-03
 	 8.91241593441007395881570118945092e-01 5.43792032794962812425332288057689e-02 1.60467522197081072406199542257355e-03
 	 2.18192015863253874208282923063962e-01 2.18192015863253874208282923063962e-01 4.96318808977210326749407443003292e-03
 	 2.18192015863253874208282923063962e-01 5.63615968273492251583434153872076e-01 4.96318808977210326749407443003292e-03
 	 5.63615968273492251583434153872076e-01 2.18192015863253874208282923063962e-01 4.96318808977210326749407443003292e-03
 	 4.91991344456553236774709603196243e-01 4.91991344456553236774709603196243e-01 1.93118101498302146418195590626965e-03
 	 4.91991344456553236774709603196243e-01 1.60173110868935264505807936075144e-02 1.93118101498302146418195590626965e-03
 	 1.60173110868935264505807936075144e-02 4.91991344456553236774709603196243e-01 1.93118101498302146418195590626965e-03
 	 4.53399961617805269398218115384225e-01 4.53399961617805269398218115384225e-01 4.66689888482329107849411187203259e-03
 	 4.53399961617805269398218115384225e-01 9.32000767643894612035637692315504e-02 4.66689888482329107849411187203259e-03
 	 9.32000767643894612035637692315504e-02 4.53399961617805269398218115384225e-01 4.66689888482329107849411187203259e-03
 	 4.72666051056800425728132708513840e-03 4.72666051056800425728132708513840e-03 1.46741366789008789326895221272196e-04
 	 4.72666051056800425728132708513840e-03 9.90546678978863948117350446409546e-01 1.46741366789008789326895221272196e-04
 	 9.90546678978863948117350446409546e-01 4.72666051056800425728132708513840e-03 1.46741366789008789326895221272196e-04
 	 2.58152928789506741491521779607865e-01 8.69286359632870375691027220454998e-02 2.50541172828744936745826166202278e-03
 	 2.58152928789506741491521779607865e-01 6.54918435247206165428224267088808e-01 2.50541172828744936745826166202278e-03
 	 8.69286359632870375691027220454998e-02 2.58152928789506741491521779607865e-01 2.50541172828744936745826166202278e-03
 	 8.69286359632870375691027220454998e-02 6.54918435247206165428224267088808e-01 2.50541172828744936745826166202278e-03
 	 6.54918435247206165428224267088808e-01 2.58152928789506741491521779607865e-01 2.50541172828744936745826166202278e-03
 	 6.54918435247206165428224267088808e-01 8.69286359632870375691027220454998e-02 2.50541172828744936745826166202278e-03
 	 2.84962401972082890466708704479970e-01 1.14092035322831353294503742290544e-01 3.13333575729897928149880748094347e-03
 	 2.84962401972082890466708704479970e-01 6.00945562705085700727636321971659e-01 3.13333575729897928149880748094347e-03
 	 1.14092035322831353294503742290544e-01 2.84962401972082890466708704479970e-01 3.13333575729897928149880748094347e-03
 	 1.14092035322831353294503742290544e-01 6.00945562705085700727636321971659e-01 3.13333575729897928149880748094347e-03
 	 6.00945562705085700727636321971659e-01 2.84962401972082890466708704479970e-01 3.13333575729897928149880748094347e-03
 	 6.00945562705085700727636321971659e-01 1.14092035322831353294503742290544e-01 3.13333575729897928149880748094347e-03
 	 1.34067633841934125138450895065034e-01 9.16653314400512203574677982942376e-02 2.55304615093165715097867085603411e-03
 	 1.34067633841934125138450895065034e-01 7.74267034718014723893020345713012e-01 2.55304615093165715097867085603411e-03
 	 9.16653314400512203574677982942376e-02 1.34067633841934125138450895065034e-01 2.55304615093165715097867085603411e-03
 	 9.16653314400512203574677982942376e-02 7.74267034718014723893020345713012e-01 2.55304615093165715097867085603411e-03
 	 7.74267034718014723893020345713012e-01 1.34067633841934125138450895065034e-01 2.55304615093165715097867085603411e-03
 	 7.74267034718014723893020345713012e-01 9.16653314400512203574677982942376e-02 2.55304615093165715097867085603411e-03
 	 3.26913750209671560842394910650910e-01 2.15939391243415657051230027718702e-01 4.81962342942039278365085053223993e-03
 	 3.26913750209671560842394910650910e-01 4.57146858546912837617526292888215e-01 4.81962342942039278365085053223993e-03
 	 2.15939391243415657051230027718702e-01 3.26913750209671560842394910650910e-01 4.81962342942039278365085053223993e-03
 	 2.15939391243415657051230027718702e-01 4.57146858546912837617526292888215e-01 4.81962342942039278365085053223993e-03
 	 4.57146858546912837617526292888215e-01 3.26913750209671560842394910650910e-01 4.81962342942039278365085053223993e-03
 	 4.57146858546912837617526292888215e-01 2.15939391243415657051230027718702e-01 4.81962342942039278365085053223993e-03
 	 1.00845715982775571695206906497333e-01 2.23903162865835385353374675787563e-02 1.21061901943424784881819800119729e-03
 	 1.00845715982775571695206906497333e-01 8.76763967730640914055584289599210e-01 1.21061901943424784881819800119729e-03
 	 2.23903162865835385353374675787563e-02 1.00845715982775571695206906497333e-01 1.21061901943424784881819800119729e-03
 	 2.23903162865835385353374675787563e-02 8.76763967730640914055584289599210e-01 1.21061901943424784881819800119729e-03
 	 8.76763967730640914055584289599210e-01 1.00845715982775571695206906497333e-01 1.21061901943424784881819800119729e-03
 	 8.76763967730640914055584289599210e-01 2.23903162865835385353374675787563e-02 1.21061901943424784881819800119729e-03
 	 3.55232825404763974397326364851324e-01 9.92419378880282920807331947798957e-02 3.84867336352746934949320412044926e-03
 	 3.55232825404763974397326364851324e-01 5.45525236707207761277516055997694e-01 3.84867336352746934949320412044926e-03
 	 9.92419378880282920807331947798957e-02 3.55232825404763974397326364851324e-01 3.84867336352746934949320412044926e-03
 	 9.92419378880282920807331947798957e-02 5.45525236707207761277516055997694e-01 3.84867336352746934949320412044926e-03
 	 5.45525236707207761277516055997694e-01 3.55232825404763974397326364851324e-01 3.84867336352746934949320412044926e-03
 	 5.45525236707207761277516055997694e-01 9.92419378880282920807331947798957e-02 3.84867336352746934949320412044926e-03
 	 1.58402734195724786969705633055128e-01 2.04436751441748401636466780928458e-02 1.49412234597451668537126945324189e-03
 	 1.58402734195724786969705633055128e-01 8.21153590660100296538814745872514e-01 1.49412234597451668537126945324189e-03
 	 2.04436751441748401636466780928458e-02 1.58402734195724786969705633055128e-01 1.49412234597451668537126945324189e-03
 	 2.04436751441748401636466780928458e-02 8.21153590660100296538814745872514e-01 1.49412234597451668537126945324189e-03
 	 8.21153590660100296538814745872514e-01 1.58402734195724786969705633055128e-01 1.49412234597451668537126945324189e-03
 	 8.21153590660100296538814745872514e-01 2.04436751441748401636466780928458e-02 1.49412234597451668537126945324189e-03
 	 4.01239748458054656943261306878412e-01 5.86121184566509023650127119253739e-02 3.09942701297168240678892026096491e-03
 	 4.01239748458054656943261306878412e-01 5.40148133085294412936150365567300e-01 3.09942701297168240678892026096491e-03
 	 5.86121184566509023650127119253739e-02 4.01239748458054656943261306878412e-01 3.09942701297168240678892026096491e-03
 	 5.86121184566509023650127119253739e-02 5.40148133085294412936150365567300e-01 3.09942701297168240678892026096491e-03
 	 5.40148133085294412936150365567300e-01 4.01239748458054656943261306878412e-01 3.09942701297168240678892026096491e-03
 	 5.40148133085294412936150365567300e-01 5.86121184566509023650127119253739e-02 3.09942701297168240678892026096491e-03
 	 2.27322013164966585385684538778150e-01 1.94249101655772464514182473749315e-02 1.65849864695653739093961220874007e-03
 	 2.27322013164966585385684538778150e-01 7.53253076669456178571238069707761e-01 1.65849864695653739093961220874007e-03
 	 1.94249101655772464514182473749315e-02 2.27322013164966585385684538778150e-01 1.65849864695653739093961220874007e-03
 	 1.94249101655772464514182473749315e-02 7.53253076669456178571238069707761e-01 1.65849864695653739093961220874007e-03
 	 7.53253076669456178571238069707761e-01 2.27322013164966585385684538778150e-01 1.65849864695653739093961220874007e-03
 	 7.53253076669456178571238069707761e-01 1.94249101655772464514182473749315e-02 1.65849864695653739093961220874007e-03
 	 1.04004000131427021269558963467716e-01 5.08701921937649848004525665601250e-02 1.85446480629463316888716484243105e-03
 	 1.04004000131427021269558963467716e-01 8.45125807674807938418837238714332e-01 1.85446480629463316888716484243105e-03
 	 5.08701921937649848004525665601250e-02 1.04004000131427021269558963467716e-01 1.85446480629463316888716484243105e-03
 	 5.08701921937649848004525665601250e-02 8.45125807674807938418837238714332e-01 1.85446480629463316888716484243105e-03
 	 8.45125807674807938418837238714332e-01 1.04004000131427021269558963467716e-01 1.85446480629463316888716484243105e-03
 	 8.45125807674807938418837238714332e-01 5.08701921937649848004525665601250e-02 1.85446480629463316888716484243105e-03
 	 2.51619019363036655612120284786215e-01 3.80625212881914110410463969458306e-03 7.71323259235281869297673473795385e-04
 	 2.51619019363036655612120284786215e-01 7.44574728508144212391073324397439e-01 7.71323259235281869297673473795385e-04
 	 3.80625212881914110410463969458306e-03 2.51619019363036655612120284786215e-01 7.71323259235281869297673473795385e-04
 	 3.80625212881914110410463969458306e-03 7.44574728508144212391073324397439e-01 7.71323259235281869297673473795385e-04
 	 7.44574728508144212391073324397439e-01 2.51619019363036655612120284786215e-01 7.71323259235281869297673473795385e-04
 	 7.44574728508144212391073324397439e-01 3.80625212881914110410463969458306e-03 7.71323259235281869297673473795385e-04
 	 1.94671527372046238024694275736692e-01 9.39537103695899794564283524778148e-02 3.30608620553421222662549006088284e-03
 	 1.94671527372046238024694275736692e-01 7.11374762258363713129938332713209e-01 3.30608620553421222662549006088284e-03
 	 9.39537103695899794564283524778148e-02 1.94671527372046238024694275736692e-01 3.30608620553421222662549006088284e-03
 	 9.39537103695899794564283524778148e-02 7.11374762258363713129938332713209e-01 3.30608620553421222662549006088284e-03
 	 7.11374762258363713129938332713209e-01 1.94671527372046238024694275736692e-01 3.30608620553421222662549006088284e-03
 	 7.11374762258363713129938332713209e-01 9.39537103695899794564283524778148e-02 3.30608620553421222662549006088284e-03
 	 1.75639631458033129707274611064349e-01 3.66697762401211810323609086026408e-03 6.77589097875325174769045588618610e-04
 	 1.75639631458033129707274611064349e-01 8.20693390917954790353405769565143e-01 6.77589097875325174769045588618610e-04
 	 3.66697762401211810323609086026408e-03 1.75639631458033129707274611064349e-01 6.77589097875325174769045588618610e-04
 	 3.66697762401211810323609086026408e-03 8.20693390917954790353405769565143e-01 6.77589097875325174769045588618610e-04
 	 8.20693390917954790353405769565143e-01 1.75639631458033129707274611064349e-01 6.77589097875325174769045588618610e-04
 	 8.20693390917954790353405769565143e-01 3.66697762401211810323609086026408e-03 6.77589097875325174769045588618610e-04
 	 1.65422503950626270663448735831480e-01 5.04257035060658373448738700517424e-02 2.45181417177645858546108925679619e-03
 	 1.65422503950626270663448735831480e-01 7.84151792543307912808359105838463e-01 2.45181417177645858546108925679619e-03
 	 5.04257035060658373448738700517424e-02 1.65422503950626270663448735831480e-01 2.45181417177645858546108925679619e-03
 	 5.04257035060658373448738700517424e-02 7.84151792543307912808359105838463e-01 2.45181417177645858546108925679619e-03
 	 7.84151792543307912808359105838463e-01 1.65422503950626270663448735831480e-01 2.45181417177645858546108925679619e-03
 	 7.84151792543307912808359105838463e-01 5.04257035060658373448738700517424e-02 2.45181417177645858546108925679619e-03
 	 6.04829240909602813824896827554767e-02 4.11214828094120989770976493105081e-03 4.57883078590504025238289154131621e-04
 	 6.04829240909602813824896827554767e-02 9.35404927628098570302483949490124e-01 4.57883078590504025238289154131621e-04
 	 4.11214828094120989770976493105081e-03 6.04829240909602813824896827554767e-02 4.57883078590504025238289154131621e-04
 	 4.11214828094120989770976493105081e-03 9.35404927628098570302483949490124e-01 4.57883078590504025238289154131621e-04
 	 9.35404927628098570302483949490124e-01 6.04829240909602813824896827554767e-02 4.57883078590504025238289154131621e-04
 	 9.35404927628098570302483949490124e-01 4.11214828094120989770976493105081e-03 4.57883078590504025238289154131621e-04
 	 3.32103565357523278223084162164014e-01 4.33667086499291924012178256475636e-03 9.10908132213261809845272765073787e-04
 	 3.32103565357523278223084162164014e-01 6.63559763777483824220837504981318e-01 9.10908132213261809845272765073787e-04
 	 4.33667086499291924012178256475636e-03 3.32103565357523278223084162164014e-01 9.10908132213261809845272765073787e-04
 	 4.33667086499291924012178256475636e-03 6.63559763777483824220837504981318e-01 9.10908132213261809845272765073787e-04
 	 6.63559763777483824220837504981318e-01 3.32103565357523278223084162164014e-01 9.10908132213261809845272765073787e-04
 	 6.63559763777483824220837504981318e-01 4.33667086499291924012178256475636e-03 9.10908132213261809845272765073787e-04
 	 3.79413216845638723295763838905259e-01 1.43764176240543023466145200472965e-01 4.62118995085480672307953753374932e-03
 	 3.79413216845638723295763838905259e-01 4.76822606913818169971364113735035e-01 4.62118995085480672307953753374932e-03
 	 1.43764176240543023466145200472965e-01 3.79413216845638723295763838905259e-01 4.62118995085480672307953753374932e-03
 	 1.43764176240543023466145200472965e-01 4.76822606913818169971364113735035e-01 4.62118995085480672307953753374932e-03
 	 4.76822606913818169971364113735035e-01 3.79413216845638723295763838905259e-01 4.62118995085480672307953753374932e-03
 	 4.76822606913818169971364113735035e-01 1.43764176240543023466145200472965e-01 4.62118995085480672307953753374932e-03
 	 5.65688972489456487480197210970800e-02 2.18658180283708390712060776195358e-02 9.80315616846607479351050074001250e-04
 	 5.65688972489456487480197210970800e-02 9.21565284722683508711327249329770e-01 9.80315616846607479351050074001250e-04
 	 2.18658180283708390712060776195358e-02 5.65688972489456487480197210970800e-02 9.80315616846607479351050074001250e-04
 	 2.18658180283708390712060776195358e-02 9.21565284722683508711327249329770e-01 9.80315616846607479351050074001250e-04
 	 9.21565284722683508711327249329770e-01 5.65688972489456487480197210970800e-02 9.80315616846607479351050074001250e-04
 	 9.21565284722683508711327249329770e-01 2.18658180283708390712060776195358e-02 9.80315616846607479351050074001250e-04
 	 2.90984916269330096127987417276017e-01 1.68307331342502364268653991530300e-01 5.10495889319825032343080906116484e-03
 	 2.90984916269330096127987417276017e-01 5.40707752388167595114509822451510e-01 5.10495889319825032343080906116484e-03
 	 1.68307331342502364268653991530300e-01 2.90984916269330096127987417276017e-01 5.10495889319825032343080906116484e-03
 	 1.68307331342502364268653991530300e-01 5.40707752388167595114509822451510e-01 5.10495889319825032343080906116484e-03
 	 5.40707752388167595114509822451510e-01 2.90984916269330096127987417276017e-01 5.10495889319825032343080906116484e-03
 	 5.40707752388167595114509822451510e-01 1.68307331342502364268653991530300e-01 5.10495889319825032343080906116484e-03
 	 2.36845394483151533426834589590726e-01 4.85139799052083930952505852474133e-02 2.73188521868607909690029877936013e-03
 	 2.36845394483151533426834589590726e-01 7.14640625611639990211187978275120e-01 2.73188521868607909690029877936013e-03
 	 4.85139799052083930952505852474133e-02 2.36845394483151533426834589590726e-01 2.73188521868607909690029877936013e-03
 	 4.85139799052083930952505852474133e-02 7.14640625611639990211187978275120e-01 2.73188521868607909690029877936013e-03
 	 7.14640625611639990211187978275120e-01 2.36845394483151533426834589590726e-01 2.73188521868607909690029877936013e-03
 	 7.14640625611639990211187978275120e-01 4.85139799052083930952505852474133e-02 2.73188521868607909690029877936013e-03
 	 4.14549152976443013862706266081659e-01 4.73723988093216474837277019105386e-03 1.00555100489236335162268609622060e-03
 	 4.14549152976443013862706266081659e-01 5.80713607142624876900072194985114e-01 1.00555100489236335162268609622060e-03
 	 4.73723988093216474837277019105386e-03 4.14549152976443013862706266081659e-01 1.00555100489236335162268609622060e-03
 	 4.73723988093216474837277019105386e-03 5.80713607142624876900072194985114e-01 1.00555100489236335162268609622060e-03
 	 5.80713607142624876900072194985114e-01 4.14549152976443013862706266081659e-01 1.00555100489236335162268609622060e-03
 	 5.80713607142624876900072194985114e-01 4.73723988093216474837277019105386e-03 1.00555100489236335162268609622060e-03
 	 3.07536188240941033011921490469831e-01 2.21352139073682022130107327484438e-02 2.13416735131724153926024989402777e-03
 	 3.07536188240941033011921490469831e-01 6.70328597851690743958386065060040e-01 2.13416735131724153926024989402777e-03
 	 2.21352139073682022130107327484438e-02 3.07536188240941033011921490469831e-01 2.13416735131724153926024989402777e-03
 	 2.21352139073682022130107327484438e-02 6.70328597851690743958386065060040e-01 2.13416735131724153926024989402777e-03
 	 6.70328597851690743958386065060040e-01 3.07536188240941033011921490469831e-01 2.13416735131724153926024989402777e-03
 	 6.70328597851690743958386065060040e-01 2.21352139073682022130107327484438e-02 2.13416735131724153926024989402777e-03
 	 1.10926664433470392734371046117303e-01 4.39339510946666188945242126351332e-03 6.43938204447683649848943598925644e-04
 	 1.10926664433470392734371046117303e-01 8.84679940457062885528216611419339e-01 6.43938204447683649848943598925644e-04
 	 4.39339510946666188945242126351332e-03 1.10926664433470392734371046117303e-01 6.43938204447683649848943598925644e-04
 	 4.39339510946666188945242126351332e-03 8.84679940457062885528216611419339e-01 6.43938204447683649848943598925644e-04
 	 8.84679940457062885528216611419339e-01 1.10926664433470392734371046117303e-01 6.43938204447683649848943598925644e-04
 	 8.84679940457062885528216611419339e-01 4.39339510946666188945242126351332e-03 6.43938204447683649848943598925644e-04
 	 3.18863122056367798151654824323487e-01 5.51602053562473687575717917752627e-02 3.29994166362838859882233855103095e-03
 	 3.18863122056367798151654824323487e-01 6.25976672587384874724136807344621e-01 3.29994166362838859882233855103095e-03
 	 5.51602053562473687575717917752627e-02 3.18863122056367798151654824323487e-01 3.29994166362838859882233855103095e-03
 	 5.51602053562473687575717917752627e-02 6.25976672587384874724136807344621e-01 3.29994166362838859882233855103095e-03
 	 6.25976672587384874724136807344621e-01 3.18863122056367798151654824323487e-01 3.29994166362838859882233855103095e-03
 	 6.25976672587384874724136807344621e-01 5.51602053562473687575717917752627e-02 3.29994166362838859882233855103095e-03
 	 3.95367759101382776343314162659226e-01 2.43998884696386975079462899884675e-02 2.47371640440409521627396216558736e-03
 	 3.95367759101382776343314162659226e-01 5.80232352428978526148739547352307e-01 2.47371640440409521627396216558736e-03
 	 2.43998884696386975079462899884675e-02 3.95367759101382776343314162659226e-01 2.47371640440409521627396216558736e-03
 	 2.43998884696386975079462899884675e-02 5.80232352428978526148739547352307e-01 2.47371640440409521627396216558736e-03
 	 5.80232352428978526148739547352307e-01 3.95367759101382776343314162659226e-01 2.47371640440409521627396216558736e-03
 	 5.80232352428978526148739547352307e-01 2.43998884696386975079462899884675e-02 2.47371640440409521627396216558736e-03
 	 2.13757830297353068615962001786102e-01 1.50634941829186158601672218537715e-01 4.59074077896355278727291704399249e-03
 	 2.13757830297353068615962001786102e-01 6.35607227873460800537941395305097e-01 4.59074077896355278727291704399249e-03
 	 1.50634941829186158601672218537715e-01 2.13757830297353068615962001786102e-01 4.59074077896355278727291704399249e-03
 	 1.50634941829186158601672218537715e-01 6.35607227873460800537941395305097e-01 4.59074077896355278727291704399249e-03
 	 6.35607227873460800537941395305097e-01 2.13757830297353068615962001786102e-01 4.59074077896355278727291704399249e-03
 	 6.35607227873460800537941395305097e-01 1.50634941829186158601672218537715e-01 4.59074077896355278727291704399249e-03
 	 2.47793702175406298227056112182254e-02 4.50238528829736278646933556046861e-03 3.22000887173716021996683345207657e-04
 	 2.47793702175406298227056112182254e-02 9.70718244494161996982484197360463e-01 3.22000887173716021996683345207657e-04
 	 4.50238528829736278646933556046861e-03 2.47793702175406298227056112182254e-02 3.22000887173716021996683345207657e-04
 	 4.50238528829736278646933556046861e-03 9.70718244494161996982484197360463e-01 3.22000887173716021996683345207657e-04
 	 9.70718244494161996982484197360463e-01 2.47793702175406298227056112182254e-02 3.22000887173716021996683345207657e-04
 	 9.70718244494161996982484197360463e-01 4.50238528829736278646933556046861e-03 3.22000887173716021996683345207657e-04
 	 ];
 
 	 case  34 

 	 % ALG. DEG.:   34
 	 % PTS CARD.:  214
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-15  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 6.05048246508555886274960400328382e-03
 	 4.59825951541271496503249238685385e-02 4.59825951541271496503249238685385e-02 1.14948328440455348198323548558619e-03
 	 4.59825951541271496503249238685385e-02 9.08034809691745659065986728819553e-01 1.14948328440455348198323548558619e-03
 	 9.08034809691745659065986728819553e-01 4.59825951541271496503249238685385e-02 1.14948328440455348198323548558619e-03
 	 2.08387475149684059383403678111790e-02 2.08387475149684059383403678111790e-02 5.49840283231598555419017415601957e-04
 	 2.08387475149684059383403678111790e-02 9.58322504970063215878894880006555e-01 5.49840283231598555419017415601957e-04
 	 9.58322504970063215878894880006555e-01 2.08387475149684059383403678111790e-02 5.49840283231598555419017415601957e-04
 	 7.57621741867907788625657872216834e-02 7.57621741867907788625657872216834e-02 1.99868672682467114765092475181518e-03
 	 7.57621741867907788625657872216834e-02 8.48475651626418470030444041185547e-01 1.99868672682467114765092475181518e-03
 	 8.48475651626418470030444041185547e-01 7.57621741867907788625657872216834e-02 1.99868672682467114765092475181518e-03
 	 3.76601980517545675830604068323737e-01 3.76601980517545675830604068323737e-01 5.87000329562878831596295370331973e-03
 	 3.76601980517545675830604068323737e-01 2.46796038964908648338791863352526e-01 5.87000329562878831596295370331973e-03
 	 2.46796038964908648338791863352526e-01 3.76601980517545675830604068323737e-01 5.87000329562878831596295370331973e-03
 	 2.87355839822164893515576977733872e-01 2.87355839822164893515576977733872e-01 5.88060381970681184810034736187845e-03
 	 2.87355839822164893515576977733872e-01 4.25288320355670212968846044532256e-01 5.88060381970681184810034736187845e-03
 	 4.25288320355670212968846044532256e-01 2.87355839822164893515576977733872e-01 5.88060381970681184810034736187845e-03
 	 4.74412498902845591874921638009255e-01 4.74412498902845591874921638009255e-01 3.24211260691925889226849832880362e-03
 	 4.74412498902845591874921638009255e-01 5.11750021943088162501567239814904e-02 3.24211260691925889226849832880362e-03
 	 5.11750021943088162501567239814904e-02 4.74412498902845591874921638009255e-01 3.24211260691925889226849832880362e-03
 	 1.11172701285845609842084513729787e-01 1.11172701285845609842084513729787e-01 2.91671683977711131835475200091423e-03
 	 1.11172701285845609842084513729787e-01 7.77654597428308780315830972540425e-01 2.91671683977711131835475200091423e-03
 	 7.77654597428308780315830972540425e-01 1.11172701285845609842084513729787e-01 2.91671683977711131835475200091423e-03
 	 4.91864961957689694749262798723066e-01 4.91864961957689694749262798723066e-01 1.86468547170908589480364803137036e-03
 	 4.91864961957689694749262798723066e-01 1.62700760846206105014744025538675e-02 1.86468547170908589480364803137036e-03
 	 1.62700760846206105014744025538675e-02 4.91864961957689694749262798723066e-01 1.86468547170908589480364803137036e-03
 	 1.50887722762872905635234133114864e-01 1.50887722762872905635234133114864e-01 3.84365534298183961908756955949684e-03
 	 1.50887722762872905635234133114864e-01 6.98224554474254244240682965028100e-01 3.84365534298183961908756955949684e-03
 	 6.98224554474254244240682965028100e-01 1.50887722762872905635234133114864e-01 3.84365534298183961908756955949684e-03
 	 4.15795739231892506199139702971479e-03 4.15795739231892506199139702971479e-03 1.13480678385471649041553454662079e-04
 	 4.15795739231892506199139702971479e-03 9.91684085215362109977377258474007e-01 1.13480678385471649041553454662079e-04
 	 9.91684085215362109977377258474007e-01 4.15795739231892506199139702971479e-03 1.13480678385471649041553454662079e-04
 	 2.40434910413816760321736865080311e-01 2.40434910413816760321736865080311e-01 5.40684965813481143576124665628413e-03
 	 2.40434910413816760321736865080311e-01 5.19130179172366479356526269839378e-01 5.40684965813481143576124665628413e-03
 	 5.19130179172366479356526269839378e-01 2.40434910413816760321736865080311e-01 5.40684965813481143576124665628413e-03
 	 4.15511596744837174988163042144151e-01 4.15511596744837174988163042144151e-01 5.32372242124446500705081675164365e-03
 	 4.15511596744837174988163042144151e-01 1.68976806510325650023673915711697e-01 5.32372242124446500705081675164365e-03
 	 1.68976806510325650023673915711697e-01 4.15511596744837174988163042144151e-01 5.32372242124446500705081675164365e-03
 	 4.99542182661511791064157250730204e-01 4.99542182661511791064157250730204e-01 3.80463083109050395971828528729475e-04
 	 4.99542182661511791064157250730204e-01 9.15634676976417871685498539591208e-04 3.80463083109050395971828528729475e-04
 	 9.15634676976417871685498539591208e-04 4.99542182661511791064157250730204e-01 3.80463083109050395971828528729475e-04
 	 4.48564265878708234858152081869775e-01 4.48564265878708234858152081869775e-01 4.43046965007651803725163830449674e-03
 	 4.48564265878708234858152081869775e-01 1.02871468242583530283695836260449e-01 4.43046965007651803725163830449674e-03
 	 1.02871468242583530283695836260449e-01 4.48564265878708234858152081869775e-01 4.43046965007651803725163830449674e-03
 	 1.94386543578966120016104923706735e-01 1.94386543578966120016104923706735e-01 4.70007051859917639180519444153106e-03
 	 1.94386543578966120016104923706735e-01 6.11226912842067759967790152586531e-01 4.70007051859917639180519444153106e-03
 	 6.11226912842067759967790152586531e-01 1.94386543578966120016104923706735e-01 4.70007051859917639180519444153106e-03
 	 3.85126251838280975192674304707907e-01 2.10967602701019364686008117359961e-02 5.08429861835656490701498833040262e-05
 	 3.85126251838280975192674304707907e-01 5.93776987891617036297020604251884e-01 5.08429861835656490701498833040262e-05
 	 2.10967602701019364686008117359961e-02 3.85126251838280975192674304707907e-01 5.08429861835656490701498833040262e-05
 	 2.10967602701019364686008117359961e-02 5.93776987891617036297020604251884e-01 5.08429861835656490701498833040262e-05
 	 5.93776987891617036297020604251884e-01 3.85126251838280975192674304707907e-01 5.08429861835656490701498833040262e-05
 	 5.93776987891617036297020604251884e-01 2.10967602701019364686008117359961e-02 5.08429861835656490701498833040262e-05
 	 5.28200673454987598698373574279685e-02 3.38811215039004848606496445029279e-03 3.27023983293753294551015065039223e-04
 	 5.28200673454987598698373574279685e-02 9.43791820504111256262547158257803e-01 3.27023983293753294551015065039223e-04
 	 3.38811215039004848606496445029279e-03 5.28200673454987598698373574279685e-02 3.27023983293753294551015065039223e-04
 	 3.38811215039004848606496445029279e-03 9.43791820504111256262547158257803e-01 3.27023983293753294551015065039223e-04
 	 9.43791820504111256262547158257803e-01 5.28200673454987598698373574279685e-02 3.27023983293753294551015065039223e-04
 	 9.43791820504111256262547158257803e-01 3.38811215039004848606496445029279e-03 3.27023983293753294551015065039223e-04
 	 5.08987652831316070289879860411020e-02 1.82083287994723903857607893996828e-02 7.59905829130818753942844256954459e-04
 	 5.08987652831316070289879860411020e-02 9.30892905917395929726865233533317e-01 7.59905829130818753942844256954459e-04
 	 1.82083287994723903857607893996828e-02 5.08987652831316070289879860411020e-02 7.59905829130818753942844256954459e-04
 	 1.82083287994723903857607893996828e-02 9.30892905917395929726865233533317e-01 7.59905829130818753942844256954459e-04
 	 9.30892905917395929726865233533317e-01 5.08987652831316070289879860411020e-02 7.59905829130818753942844256954459e-04
 	 9.30892905917395929726865233533317e-01 1.82083287994723903857607893996828e-02 7.59905829130818753942844256954459e-04
 	 1.29124372072608517569847208505962e-01 6.05107706433122560785164978369721e-02 2.33481884197296032587565228766380e-03
 	 1.29124372072608517569847208505962e-01 8.10364857284079254107211909285979e-01 2.33481884197296032587565228766380e-03
 	 6.05107706433122560785164978369721e-02 1.29124372072608517569847208505962e-01 2.33481884197296032587565228766380e-03
 	 6.05107706433122560785164978369721e-02 8.10364857284079254107211909285979e-01 2.33481884197296032587565228766380e-03
 	 8.10364857284079254107211909285979e-01 1.29124372072608517569847208505962e-01 2.33481884197296032587565228766380e-03
 	 8.10364857284079254107211909285979e-01 6.05107706433122560785164978369721e-02 2.33481884197296032587565228766380e-03
 	 8.78179027775244785969377403489489e-02 3.59198913635777883346378303031088e-02 1.47605781528108853661862553963147e-03
 	 8.78179027775244785969377403489489e-02 8.76262205858897802457363468420226e-01 1.47605781528108853661862553963147e-03
 	 3.59198913635777883346378303031088e-02 8.78179027775244785969377403489489e-02 1.47605781528108853661862553963147e-03
 	 3.59198913635777883346378303031088e-02 8.76262205858897802457363468420226e-01 1.47605781528108853661862553963147e-03
 	 8.76262205858897802457363468420226e-01 8.78179027775244785969377403489489e-02 1.47605781528108853661862553963147e-03
 	 8.76262205858897802457363468420226e-01 3.59198913635777883346378303031088e-02 1.47605781528108853661862553963147e-03
 	 2.73553738024819192986569760250859e-01 1.64061028670212660784955005510710e-01 4.93046515645235820801683956915440e-03
 	 2.73553738024819192986569760250859e-01 5.62385233304968146228475234238431e-01 4.93046515645235820801683956915440e-03
 	 1.64061028670212660784955005510710e-01 2.73553738024819192986569760250859e-01 4.93046515645235820801683956915440e-03
 	 1.64061028670212660784955005510710e-01 5.62385233304968146228475234238431e-01 4.93046515645235820801683956915440e-03
 	 5.62385233304968146228475234238431e-01 2.73553738024819192986569760250859e-01 4.93046515645235820801683956915440e-03
 	 5.62385233304968146228475234238431e-01 1.64061028670212660784955005510710e-01 4.93046515645235820801683956915440e-03
 	 9.44770656323741658821901978626556e-02 1.06832635235884227525859913043860e-02 8.63136629420848690806555847387926e-04
 	 9.44770656323741658821901978626556e-02 8.94839670844037482488886325882049e-01 8.63136629420848690806555847387926e-04
 	 1.06832635235884227525859913043860e-02 9.44770656323741658821901978626556e-02 8.63136629420848690806555847387926e-04
 	 1.06832635235884227525859913043860e-02 8.94839670844037482488886325882049e-01 8.63136629420848690806555847387926e-04
 	 8.94839670844037482488886325882049e-01 9.44770656323741658821901978626556e-02 8.63136629420848690806555847387926e-04
 	 8.94839670844037482488886325882049e-01 1.06832635235884227525859913043860e-02 8.63136629420848690806555847387926e-04
 	 4.11152233303600511682418527925620e-01 3.11326803063737105048414122165923e-02 2.51809125066696729705606472293766e-03
 	 4.11152233303600511682418527925620e-01 5.57715086390025760465505300089717e-01 2.51809125066696729705606472293766e-03
 	 3.11326803063737105048414122165923e-02 4.11152233303600511682418527925620e-01 2.51809125066696729705606472293766e-03
 	 3.11326803063737105048414122165923e-02 5.57715086390025760465505300089717e-01 2.51809125066696729705606472293766e-03
 	 5.57715086390025760465505300089717e-01 4.11152233303600511682418527925620e-01 2.51809125066696729705606472293766e-03
 	 5.57715086390025760465505300089717e-01 3.11326803063737105048414122165923e-02 2.51809125066696729705606472293766e-03
 	 3.59447569498255292685939821240027e-01 1.33192623221705830349748111984809e-01 4.82894011472339863139113802503743e-03
 	 3.59447569498255292685939821240027e-01 5.07359807280038932475463298032992e-01 4.82894011472339863139113802503743e-03
 	 1.33192623221705830349748111984809e-01 3.59447569498255292685939821240027e-01 4.82894011472339863139113802503743e-03
 	 1.33192623221705830349748111984809e-01 5.07359807280038932475463298032992e-01 4.82894011472339863139113802503743e-03
 	 5.07359807280038932475463298032992e-01 3.59447569498255292685939821240027e-01 4.82894011472339863139113802503743e-03
 	 5.07359807280038932475463298032992e-01 1.33192623221705830349748111984809e-01 4.82894011472339863139113802503743e-03
 	 3.88410085330437082618004751566332e-01 7.42973192372942126127099982113577e-02 3.80595751044293531886730796998108e-03
 	 3.88410085330437082618004751566332e-01 5.37292595432268704769285250222310e-01 3.80595751044293531886730796998108e-03
 	 7.42973192372942126127099982113577e-02 3.88410085330437082618004751566332e-01 3.80595751044293531886730796998108e-03
 	 7.42973192372942126127099982113577e-02 5.37292595432268704769285250222310e-01 3.80595751044293531886730796998108e-03
 	 5.37292595432268704769285250222310e-01 3.88410085330437082618004751566332e-01 3.80595751044293531886730796998108e-03
 	 5.37292595432268704769285250222310e-01 7.42973192372942126127099982113577e-02 3.80595751044293531886730796998108e-03
 	 3.25355043342057725919147515014629e-01 2.05166497814761955575946217322780e-01 5.53293194379955895201295135166220e-03
 	 3.25355043342057725919147515014629e-01 4.69478458843180290749330652033677e-01 5.53293194379955895201295135166220e-03
 	 2.05166497814761955575946217322780e-01 3.25355043342057725919147515014629e-01 5.53293194379955895201295135166220e-03
 	 2.05166497814761955575946217322780e-01 4.69478458843180290749330652033677e-01 5.53293194379955895201295135166220e-03
 	 4.69478458843180290749330652033677e-01 3.25355043342057725919147515014629e-01 5.53293194379955895201295135166220e-03
 	 4.69478458843180290749330652033677e-01 2.05166497814761955575946217322780e-01 5.53293194379955895201295135166220e-03
 	 1.74780479481068395930520864567370e-01 9.02196061251755165866228480808786e-02 3.25191985632487020468905924985847e-03
 	 1.74780479481068395930520864567370e-01 7.34999914393756115238431902980665e-01 3.25191985632487020468905924985847e-03
 	 9.02196061251755165866228480808786e-02 1.74780479481068395930520864567370e-01 3.25191985632487020468905924985847e-03
 	 9.02196061251755165866228480808786e-02 7.34999914393756115238431902980665e-01 3.25191985632487020468905924985847e-03
 	 7.34999914393756115238431902980665e-01 1.74780479481068395930520864567370e-01 3.25191985632487020468905924985847e-03
 	 7.34999914393756115238431902980665e-01 9.02196061251755165866228480808786e-02 3.25191985632487020468905924985847e-03
 	 1.94164618149563289462022908082872e-01 4.39158729045114326616783273493638e-02 2.41634362674254333028245333991890e-03
 	 1.94164618149563289462022908082872e-01 7.61919508945925194609571917681023e-01 2.41634362674254333028245333991890e-03
 	 4.39158729045114326616783273493638e-02 1.94164618149563289462022908082872e-01 2.41634362674254333028245333991890e-03
 	 4.39158729045114326616783273493638e-02 7.61919508945925194609571917681023e-01 2.41634362674254333028245333991890e-03
 	 7.61919508945925194609571917681023e-01 1.94164618149563289462022908082872e-01 2.41634362674254333028245333991890e-03
 	 7.61919508945925194609571917681023e-01 4.39158729045114326616783273493638e-02 2.41634362674254333028245333991890e-03
 	 2.48327873404578958194122151326155e-01 6.89638299646016944555171335196064e-02 3.29675723387471862266262512264348e-03
 	 2.48327873404578958194122151326155e-01 6.82708296630819333472572907339782e-01 3.29675723387471862266262512264348e-03
 	 6.89638299646016944555171335196064e-02 2.48327873404578958194122151326155e-01 3.29675723387471862266262512264348e-03
 	 6.89638299646016944555171335196064e-02 6.82708296630819333472572907339782e-01 3.29675723387471862266262512264348e-03
 	 6.82708296630819333472572907339782e-01 2.48327873404578958194122151326155e-01 3.29675723387471862266262512264348e-03
 	 6.82708296630819333472572907339782e-01 6.89638299646016944555171335196064e-02 3.29675723387471862266262512264348e-03
 	 2.22992041261200868440539579751203e-01 1.25181798142886657743133582698647e-01 4.14263325655032672162336737642363e-03
 	 2.22992041261200868440539579751203e-01 6.51826160595912473816326837550150e-01 4.14263325655032672162336737642363e-03
 	 1.25181798142886657743133582698647e-01 2.22992041261200868440539579751203e-01 4.14263325655032672162336737642363e-03
 	 1.25181798142886657743133582698647e-01 6.51826160595912473816326837550150e-01 4.14263325655032672162336737642363e-03
 	 6.51826160595912473816326837550150e-01 2.22992041261200868440539579751203e-01 4.14263325655032672162336737642363e-03
 	 6.51826160595912473816326837550150e-01 1.25181798142886657743133582698647e-01 4.14263325655032672162336737642363e-03
 	 1.49604423548951093181358373840339e-01 4.67029856128329395881237928733754e-03 6.99714692701543196015623315986431e-04
 	 1.49604423548951093181358373840339e-01 8.45725277889765592043147535150638e-01 6.99714692701543196015623315986431e-04
 	 4.67029856128329395881237928733754e-03 1.49604423548951093181358373840339e-01 6.99714692701543196015623315986431e-04
 	 4.67029856128329395881237928733754e-03 8.45725277889765592043147535150638e-01 6.99714692701543196015623315986431e-04
 	 8.45725277889765592043147535150638e-01 1.49604423548951093181358373840339e-01 6.99714692701543196015623315986431e-04
 	 8.45725277889765592043147535150638e-01 4.67029856128329395881237928733754e-03 6.99714692701543196015623315986431e-04
 	 3.28391413692126599155329813584103e-01 4.89259225038644121608122361521964e-02 3.04763201624416940963002708997465e-03
 	 3.28391413692126599155329813584103e-01 6.22682663804008940111600622913102e-01 3.04763201624416940963002708997465e-03
 	 4.89259225038644121608122361521964e-02 3.28391413692126599155329813584103e-01 3.04763201624416940963002708997465e-03
 	 4.89259225038644121608122361521964e-02 6.22682663804008940111600622913102e-01 3.04763201624416940963002708997465e-03
 	 6.22682663804008940111600622913102e-01 3.28391413692126599155329813584103e-01 3.04763201624416940963002708997465e-03
 	 6.22682663804008940111600622913102e-01 4.89259225038644121608122361521964e-02 3.04763201624416940963002708997465e-03
 	 1.42385500324542807470962202387454e-01 2.46582497782073459258178615982615e-02 1.57160307407964387055310240270956e-03
 	 1.42385500324542807470962202387454e-01 8.32956249897249922931052878993796e-01 1.57160307407964387055310240270956e-03
 	 2.46582497782073459258178615982615e-02 1.42385500324542807470962202387454e-01 1.57160307407964387055310240270956e-03
 	 2.46582497782073459258178615982615e-02 8.32956249897249922931052878993796e-01 1.57160307407964387055310240270956e-03
 	 8.32956249897249922931052878993796e-01 1.42385500324542807470962202387454e-01 1.57160307407964387055310240270956e-03
 	 8.32956249897249922931052878993796e-01 2.46582497782073459258178615982615e-02 1.57160307407964387055310240270956e-03
 	 4.23840299720368851588148118025856e-01 5.95994324974427527180642627513407e-03 1.11566589667664987396700215782630e-03
 	 4.23840299720368851588148118025856e-01 5.70199757029886900028259333339520e-01 1.11566589667664987396700215782630e-03
 	 5.95994324974427527180642627513407e-03 4.23840299720368851588148118025856e-01 1.11566589667664987396700215782630e-03
 	 5.95994324974427527180642627513407e-03 5.70199757029886900028259333339520e-01 1.11566589667664987396700215782630e-03
 	 5.70199757029886900028259333339520e-01 4.23840299720368851588148118025856e-01 1.11566589667664987396700215782630e-03
 	 5.70199757029886900028259333339520e-01 5.95994324974427527180642627513407e-03 1.11566589667664987396700215782630e-03
 	 2.67690419344305596816013803618262e-01 2.85187228422853940312808873613903e-02 2.21786548672097674414493972960827e-03
 	 2.67690419344305596816013803618262e-01 7.03790857813408998744364453159506e-01 2.21786548672097674414493972960827e-03
 	 2.85187228422853940312808873613903e-02 2.67690419344305596816013803618262e-01 2.21786548672097674414493972960827e-03
 	 2.85187228422853940312808873613903e-02 7.03790857813408998744364453159506e-01 2.21786548672097674414493972960827e-03
 	 7.03790857813408998744364453159506e-01 2.67690419344305596816013803618262e-01 2.21786548672097674414493972960827e-03
 	 7.03790857813408998744364453159506e-01 2.85187228422853940312808873613903e-02 2.21786548672097674414493972960827e-03
 	 3.45411378952901138017494986343081e-01 1.55626433010154947844672079781958e-02 1.74416367287191353269149018956341e-03
 	 3.45411378952901138017494986343081e-01 6.39025977746083273522970102931140e-01 1.74416367287191353269149018956341e-03
 	 1.55626433010154947844672079781958e-02 3.45411378952901138017494986343081e-01 1.74416367287191353269149018956341e-03
 	 1.55626433010154947844672079781958e-02 6.39025977746083273522970102931140e-01 1.74416367287191353269149018956341e-03
 	 6.39025977746083273522970102931140e-01 3.45411378952901138017494986343081e-01 1.74416367287191353269149018956341e-03
 	 6.39025977746083273522970102931140e-01 1.55626433010154947844672079781958e-02 1.74416367287191353269149018956341e-03
 	 3.53449519657663746574627339214203e-01 9.25718233933834830362563650396623e-04 3.65922936835055574028574554290572e-04
 	 3.53449519657663746574627339214203e-01 6.45624762108402472371437852416420e-01 3.65922936835055574028574554290572e-04
 	 9.25718233933834830362563650396623e-04 3.53449519657663746574627339214203e-01 3.65922936835055574028574554290572e-04
 	 9.25718233933834830362563650396623e-04 6.45624762108402472371437852416420e-01 3.65922936835055574028574554290572e-04
 	 6.45624762108402472371437852416420e-01 3.53449519657663746574627339214203e-01 3.65922936835055574028574554290572e-04
 	 6.45624762108402472371437852416420e-01 9.25718233933834830362563650396623e-04 3.65922936835055574028574554290572e-04
 	 3.03335639471789153542857775391894e-01 9.92862116185854320926651439549460e-02 4.12539871537647307581098132800435e-03
 	 3.03335639471789153542857775391894e-01 5.97378148909625372731113657209789e-01 4.12539871537647307581098132800435e-03
 	 9.92862116185854320926651439549460e-02 3.03335639471789153542857775391894e-01 4.12539871537647307581098132800435e-03
 	 9.92862116185854320926651439549460e-02 5.97378148909625372731113657209789e-01 4.12539871537647307581098132800435e-03
 	 5.97378148909625372731113657209789e-01 3.03335639471789153542857775391894e-01 4.12539871537647307581098132800435e-03
 	 5.97378148909625372731113657209789e-01 9.92862116185854320926651439549460e-02 4.12539871537647307581098132800435e-03
 	 2.17555603201839350968604946956475e-02 3.97450587251847731184994927389198e-03 2.48983786598558842154821357794958e-04
 	 2.17555603201839350968604946956475e-02 9.74269933807297650041334691195516e-01 2.48983786598558842154821357794958e-04
 	 3.97450587251847731184994927389198e-03 2.17555603201839350968604946956475e-02 2.48983786598558842154821357794958e-04
 	 3.97450587251847731184994927389198e-03 9.74269933807297650041334691195516e-01 2.48983786598558842154821357794958e-04
 	 9.74269933807297650041334691195516e-01 2.17555603201839350968604946956475e-02 2.48983786598558842154821357794958e-04
 	 9.74269933807297650041334691195516e-01 3.97450587251847731184994927389198e-03 2.48983786598558842154821357794958e-04
 	 2.07546868273520451753100246605754e-01 1.37796394053688077419028701342540e-02 1.40290906865686267404602638464439e-03
 	 2.07546868273520451753100246605754e-01 7.78673492321110716218868219584692e-01 1.40290906865686267404602638464439e-03
 	 1.37796394053688077419028701342540e-02 2.07546868273520451753100246605754e-01 1.40290906865686267404602638464439e-03
 	 1.37796394053688077419028701342540e-02 7.78673492321110716218868219584692e-01 1.40290906865686267404602638464439e-03
 	 7.78673492321110716218868219584692e-01 2.07546868273520451753100246605754e-01 1.40290906865686267404602638464439e-03
 	 7.78673492321110716218868219584692e-01 1.37796394053688077419028701342540e-02 1.40290906865686267404602638464439e-03
 	 2.13560239517947836329625488360762e-01 7.72139120327043496430641233985170e-04 2.88825287117379120738897002595991e-04
 	 2.13560239517947836329625488360762e-01 7.85667621361725077022697405482177e-01 2.88825287117379120738897002595991e-04
 	 7.72139120327043496430641233985170e-04 2.13560239517947836329625488360762e-01 2.88825287117379120738897002595991e-04
 	 7.72139120327043496430641233985170e-04 7.85667621361725077022697405482177e-01 2.88825287117379120738897002595991e-04
 	 7.85667621361725077022697405482177e-01 2.13560239517947836329625488360762e-01 2.88825287117379120738897002595991e-04
 	 7.85667621361725077022697405482177e-01 7.72139120327043496430641233985170e-04 2.88825287117379120738897002595991e-04
 	 2.79386431782223720876601191775990e-01 5.46179089429344854361714212132028e-03 9.81314402741667981058815151129693e-04
 	 2.79386431782223720876601191775990e-01 7.15151777323482895631912015232956e-01 9.81314402741667981058815151129693e-04
 	 5.46179089429344854361714212132028e-03 2.79386431782223720876601191775990e-01 9.81314402741667981058815151129693e-04
 	 5.46179089429344854361714212132028e-03 7.15151777323482895631912015232956e-01 9.81314402741667981058815151129693e-04
 	 7.15151777323482895631912015232956e-01 2.79386431782223720876601191775990e-01 9.81314402741667981058815151129693e-04
 	 7.15151777323482895631912015232956e-01 5.46179089429344854361714212132028e-03 9.81314402741667981058815151129693e-04
 	 9.68669225755471735572754710119625e-02 4.70969101854539203629197718914412e-06 1.43672677304066987455724579980654e-04
 	 9.68669225755471735572754710119625e-02 9.03128367733434300745898326567840e-01 1.43672677304066987455724579980654e-04
 	 4.70969101854539203629197718914412e-06 9.68669225755471735572754710119625e-02 1.43672677304066987455724579980654e-04
 	 4.70969101854539203629197718914412e-06 9.03128367733434300745898326567840e-01 1.43672677304066987455724579980654e-04
 	 9.03128367733434300745898326567840e-01 9.68669225755471735572754710119625e-02 1.43672677304066987455724579980654e-04
 	 9.03128367733434300745898326567840e-01 4.70969101854539203629197718914412e-06 1.43672677304066987455724579980654e-04
 	 ];
 
 	 case  35 

 	 % ALG. DEG.:   35
 	 % PTS CARD.:  228
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.7e-15  

 	 xyw=[
 	 3.01435168617317950090495060067042e-01 3.01435168617317950090495060067042e-01 2.87396701483509002875149640487962e-03
 	 3.01435168617317950090495060067042e-01 3.97129662765364099819009879865916e-01 2.87396701483509002875149640487962e-03
 	 3.97129662765364099819009879865916e-01 3.01435168617317950090495060067042e-01 2.87396701483509002875149640487962e-03
 	 4.91641403982890690116391851915978e-01 4.91641403982890690116391851915978e-01 1.14818404604971461592521908556819e-03
 	 4.91641403982890690116391851915978e-01 1.67171920342186197672162961680442e-02 1.14818404604971461592521908556819e-03
 	 1.67171920342186197672162961680442e-02 4.91641403982890690116391851915978e-01 1.14818404604971461592521908556819e-03
 	 3.57793135798597061736359137285035e-01 3.57793135798597061736359137285035e-01 3.99767542093215459686472712519389e-03
 	 3.57793135798597061736359137285035e-01 2.84413728402805876527281725429930e-01 3.99767542093215459686472712519389e-03
 	 2.84413728402805876527281725429930e-01 3.57793135798597061736359137285035e-01 3.99767542093215459686472712519389e-03
 	 2.62413960109345423266091756886453e-01 2.62413960109345423266091756886453e-01 4.39509294666389632721958946603991e-03
 	 2.62413960109345423266091756886453e-01 4.75172079781309153467816486227093e-01 4.39509294666389632721958946603991e-03
 	 4.75172079781309153467816486227093e-01 2.62413960109345423266091756886453e-01 4.39509294666389632721958946603991e-03
 	 4.02816450585781860027623224596027e-01 4.02816450585781860027623224596027e-01 4.16018330616281083872420865077402e-03
 	 4.02816450585781860027623224596027e-01 1.94367098828436279944753550807945e-01 4.16018330616281083872420865077402e-03
 	 1.94367098828436279944753550807945e-01 4.02816450585781860027623224596027e-01 4.16018330616281083872420865077402e-03
 	 4.73088965500664149210763298469828e-01 4.73088965500664149210763298469828e-01 2.63759414258074543699339464808418e-03
 	 4.73088965500664149210763298469828e-01 5.38220689986717015784734030603431e-02 2.63759414258074543699339464808418e-03
 	 5.38220689986717015784734030603431e-02 4.73088965500664149210763298469828e-01 2.63759414258074543699339464808418e-03
 	 6.28680490440657047113148792050197e-02 6.28680490440657047113148792050197e-02 1.48410331952580042125244830231168e-03
 	 6.28680490440657047113148792050197e-02 8.74263901911868535066219010332134e-01 1.48410331952580042125244830231168e-03
 	 8.74263901911868535066219010332134e-01 6.28680490440657047113148792050197e-02 1.48410331952580042125244830231168e-03
 	 4.41597433754930324134591046458809e-01 4.41597433754930324134591046458809e-01 3.80259126526817647917511067134910e-03
 	 4.41597433754930324134591046458809e-01 1.16805132490139351730817907082383e-01 3.80259126526817647917511067134910e-03
 	 1.16805132490139351730817907082383e-01 4.41597433754930324134591046458809e-01 3.80259126526817647917511067134910e-03
 	 1.96271599834707231868602406166247e-02 1.96271599834707231868602406166247e-02 5.06560516369039190442968845218275e-04
 	 1.96271599834707231868602406166247e-02 9.60745680033058602198536846117349e-01 5.06560516369039190442968845218275e-04
 	 9.60745680033058602198536846117349e-01 1.96271599834707231868602406166247e-02 5.06560516369039190442968845218275e-04
 	 4.02868688301933966511292339873762e-02 4.02868688301933966511292339873762e-02 1.03241781329916270867896876950454e-03
 	 4.02868688301933966511292339873762e-02 9.19426262339613220575529339839704e-01 1.03241781329916270867896876950454e-03
 	 9.19426262339613220575529339839704e-01 4.02868688301933966511292339873762e-02 1.03241781329916270867896876950454e-03
 	 9.85261546687923595033709034396452e-02 9.85261546687923595033709034396452e-02 2.50181980777866531592823484686505e-03
 	 9.85261546687923595033709034396452e-02 8.02947690662415336504409424378537e-01 2.50181980777866531592823484686505e-03
 	 8.02947690662415336504409424378537e-01 9.85261546687923595033709034396452e-02 2.50181980777866531592823484686505e-03
 	 1.39534462989307272984262908721576e-01 1.39534462989307272984262908721576e-01 3.35953990620869481775745413187906e-03
 	 1.39534462989307272984262908721576e-01 7.20931074021385454031474182556849e-01 3.35953990620869481775745413187906e-03
 	 7.20931074021385454031474182556849e-01 1.39534462989307272984262908721576e-01 3.35953990620869481775745413187906e-03
 	 2.21536010509691960734812710143160e-01 2.21536010509691960734812710143160e-01 4.58095447046864921031295025954932e-03
 	 2.21536010509691960734812710143160e-01 5.56927978980616078530374579713680e-01 4.58095447046864921031295025954932e-03
 	 5.56927978980616078530374579713680e-01 2.21536010509691960734812710143160e-01 4.58095447046864921031295025954932e-03
 	 1.80750322135299568149235938108177e-01 1.80750322135299568149235938108177e-01 4.18595331850647994070824253753926e-03
 	 1.80750322135299568149235938108177e-01 6.38499355729400863701528123783646e-01 4.18595331850647994070824253753926e-03
 	 6.38499355729400863701528123783646e-01 1.80750322135299568149235938108177e-01 4.18595331850647994070824253753926e-03
 	 4.27720726848295623723217318001844e-03 4.27720726848295623723217318001844e-03 1.20166868702420545807207918898030e-04
 	 4.27720726848295623723217318001844e-03 9.91445585463034073647747845825506e-01 1.20166868702420545807207918898030e-04
 	 9.91445585463034073647747845825506e-01 4.27720726848295623723217318001844e-03 1.20166868702420545807207918898030e-04
 	 4.99913222486225106155899311488611e-01 4.99913222486225106155899311488611e-01 3.13792170535282313736935577708209e-04
 	 4.99913222486225106155899311488611e-01 1.73555027549787688201377022778615e-04 3.13792170535282313736935577708209e-04
 	 1.73555027549787688201377022778615e-04 4.99913222486225106155899311488611e-01 3.13792170535282313736935577708209e-04
 	 5.50454796915316388328243135674711e-02 2.06822021540594260316514585440473e-03 2.27099691187698603635561345193139e-04
 	 5.50454796915316388328243135674711e-02 9.42886300093062401650456649804255e-01 2.27099691187698603635561345193139e-04
 	 2.06822021540594260316514585440473e-03 5.50454796915316388328243135674711e-02 2.27099691187698603635561345193139e-04
 	 2.06822021540594260316514585440473e-03 9.42886300093062401650456649804255e-01 2.27099691187698603635561345193139e-04
 	 9.42886300093062401650456649804255e-01 5.50454796915316388328243135674711e-02 2.27099691187698603635561345193139e-04
 	 9.42886300093062401650456649804255e-01 2.06822021540594260316514585440473e-03 2.27099691187698603635561345193139e-04
 	 4.45376464915297476387934239028255e-01 8.90499418612781569459802000210402e-03 9.85874665492084698362185157805015e-04
 	 4.45376464915297476387934239028255e-01 5.45718540898574744346660736482590e-01 9.85874665492084698362185157805015e-04
 	 8.90499418612781569459802000210402e-03 4.45376464915297476387934239028255e-01 9.85874665492084698362185157805015e-04
 	 8.90499418612781569459802000210402e-03 5.45718540898574744346660736482590e-01 9.85874665492084698362185157805015e-04
 	 5.45718540898574744346660736482590e-01 4.45376464915297476387934239028255e-01 9.85874665492084698362185157805015e-04
 	 5.45718540898574744346660736482590e-01 8.90499418612781569459802000210402e-03 9.85874665492084698362185157805015e-04
 	 1.52384002524315248505715203464206e-01 2.11597756303986755596624469433209e-03 3.91333152719676587941860512742664e-04
 	 1.52384002524315248505715203464206e-01 8.45500019912644895647702014684910e-01 3.91333152719676587941860512742664e-04
 	 2.11597756303986755596624469433209e-03 1.52384002524315248505715203464206e-01 3.91333152719676587941860512742664e-04
 	 2.11597756303986755596624469433209e-03 8.45500019912644895647702014684910e-01 3.91333152719676587941860512742664e-04
 	 8.45500019912644895647702014684910e-01 1.52384002524315248505715203464206e-01 3.91333152719676587941860512742664e-04
 	 8.45500019912644895647702014684910e-01 2.11597756303986755596624469433209e-03 3.91333152719676587941860512742664e-04
 	 3.97516610028231298645806646163692e-01 3.26127342913124992906936938652507e-03 6.32346551198585031874910278304469e-04
 	 3.97516610028231298645806646163692e-01 5.99222116542637461833464840310626e-01 6.32346551198585031874910278304469e-04
 	 3.26127342913124992906936938652507e-03 3.97516610028231298645806646163692e-01 6.32346551198585031874910278304469e-04
 	 3.26127342913124992906936938652507e-03 5.99222116542637461833464840310626e-01 6.32346551198585031874910278304469e-04
 	 5.99222116542637461833464840310626e-01 3.97516610028231298645806646163692e-01 6.32346551198585031874910278304469e-04
 	 5.99222116542637461833464840310626e-01 3.26127342913124992906936938652507e-03 6.32346551198585031874910278304469e-04
 	 1.56078769403476091959248606144683e-01 4.51678948131286547851281909515819e-02 1.77862813045475548490159667380794e-03
 	 1.56078769403476091959248606144683e-01 7.98753335783395246316729298996506e-01 1.77862813045475548490159667380794e-03
 	 4.51678948131286547851281909515819e-02 1.56078769403476091959248606144683e-01 1.77862813045475548490159667380794e-03
 	 4.51678948131286547851281909515819e-02 7.98753335783395246316729298996506e-01 1.77862813045475548490159667380794e-03
 	 7.98753335783395246316729298996506e-01 1.56078769403476091959248606144683e-01 1.77862813045475548490159667380794e-03
 	 7.98753335783395246316729298996506e-01 4.51678948131286547851281909515819e-02 1.77862813045475548490159667380794e-03
 	 1.97295676276558723527543293130293e-01 8.60602170575682987041510330072924e-03 9.21416331587752469867158566785292e-04
 	 1.97295676276558723527543293130293e-01 7.94098302017684387621443420357537e-01 9.21416331587752469867158566785292e-04
 	 8.60602170575682987041510330072924e-03 1.97295676276558723527543293130293e-01 9.21416331587752469867158566785292e-04
 	 8.60602170575682987041510330072924e-03 7.94098302017684387621443420357537e-01 9.21416331587752469867158566785292e-04
 	 7.94098302017684387621443420357537e-01 1.97295676276558723527543293130293e-01 9.21416331587752469867158566785292e-04
 	 7.94098302017684387621443420357537e-01 8.60602170575682987041510330072924e-03 9.21416331587752469867158566785292e-04
 	 5.00938368999261987579707522399985e-02 1.39743532515683617500901192443052e-02 6.64489967827079099603471146195943e-04
 	 5.00938368999261987579707522399985e-02 9.35931809848505436022492176562082e-01 6.64489967827079099603471146195943e-04
 	 1.39743532515683617500901192443052e-02 5.00938368999261987579707522399985e-02 6.64489967827079099603471146195943e-04
 	 1.39743532515683617500901192443052e-02 9.35931809848505436022492176562082e-01 6.64489967827079099603471146195943e-04
 	 9.35931809848505436022492176562082e-01 5.00938368999261987579707522399985e-02 6.64489967827079099603471146195943e-04
 	 9.35931809848505436022492176562082e-01 1.39743532515683617500901192443052e-02 6.64489967827079099603471146195943e-04
 	 2.98859063014319081830194591020700e-01 1.87471332499894505208004602536676e-01 4.51170642755310997984441456765126e-03
 	 2.98859063014319081830194591020700e-01 5.13669604485786468472952037700452e-01 4.51170642755310997984441456765126e-03
 	 1.87471332499894505208004602536676e-01 2.98859063014319081830194591020700e-01 4.51170642755310997984441456765126e-03
 	 1.87471332499894505208004602536676e-01 5.13669604485786468472952037700452e-01 4.51170642755310997984441456765126e-03
 	 5.13669604485786468472952037700452e-01 2.98859063014319081830194591020700e-01 4.51170642755310997984441456765126e-03
 	 5.13669604485786468472952037700452e-01 1.87471332499894505208004602536676e-01 4.51170642755310997984441456765126e-03
 	 3.34763343265331358988845522617339e-01 2.32722344075948522901242654370435e-01 4.30275224704192334190810953487016e-03
 	 3.34763343265331358988845522617339e-01 4.32514312658720090354336207383312e-01 4.30275224704192334190810953487016e-03
 	 2.32722344075948522901242654370435e-01 3.34763343265331358988845522617339e-01 4.30275224704192334190810953487016e-03
 	 2.32722344075948522901242654370435e-01 4.32514312658720090354336207383312e-01 4.30275224704192334190810953487016e-03
 	 4.32514312658720090354336207383312e-01 3.34763343265331358988845522617339e-01 4.30275224704192334190810953487016e-03
 	 4.32514312658720090354336207383312e-01 2.32722344075948522901242654370435e-01 4.30275224704192334190810953487016e-03
 	 2.09372824976375354610880208383605e-01 2.90018846146845241107392610047100e-02 1.80523399849691606328105919487825e-03
 	 2.09372824976375354610880208383605e-01 7.61625290408940114339486626704456e-01 1.80523399849691606328105919487825e-03
 	 2.90018846146845241107392610047100e-02 2.09372824976375354610880208383605e-01 1.80523399849691606328105919487825e-03
 	 2.90018846146845241107392610047100e-02 7.61625290408940114339486626704456e-01 1.80523399849691606328105919487825e-03
 	 7.61625290408940114339486626704456e-01 2.09372824976375354610880208383605e-01 1.80523399849691606328105919487825e-03
 	 7.61625290408940114339486626704456e-01 2.90018846146845241107392610047100e-02 1.80523399849691606328105919487825e-03
 	 1.06564744861383425833523119763413e-01 5.35674828677535283527610943110631e-02 1.76178038360539799753179401875514e-03
 	 1.06564744861383425833523119763413e-01 8.39867772270863066630397497647209e-01 1.76178038360539799753179401875514e-03
 	 5.35674828677535283527610943110631e-02 1.06564744861383425833523119763413e-01 1.76178038360539799753179401875514e-03
 	 5.35674828677535283527610943110631e-02 8.39867772270863066630397497647209e-01 1.76178038360539799753179401875514e-03
 	 8.39867772270863066630397497647209e-01 1.06564744861383425833523119763413e-01 1.76178038360539799753179401875514e-03
 	 8.39867772270863066630397497647209e-01 5.35674828677535283527610943110631e-02 1.76178038360539799753179401875514e-03
 	 3.21362627669543321484724174297298e-01 3.49619434914352376561619273331871e-03 6.89038261003182715344617115249548e-04
 	 3.21362627669543321484724174297298e-01 6.75141177981313123090956196392654e-01 6.89038261003182715344617115249548e-04
 	 3.49619434914352376561619273331871e-03 3.21362627669543321484724174297298e-01 6.89038261003182715344617115249548e-04
 	 3.49619434914352376561619273331871e-03 6.75141177981313123090956196392654e-01 6.89038261003182715344617115249548e-04
 	 6.75141177981313123090956196392654e-01 3.21362627669543321484724174297298e-01 6.89038261003182715344617115249548e-04
 	 6.75141177981313123090956196392654e-01 3.49619434914352376561619273331871e-03 6.89038261003182715344617115249548e-04
 	 2.41587026347987537944206337670039e-01 1.17604279684175661371825505341349e-03 3.47514792975928241310079602754968e-04
 	 2.41587026347987537944206337670039e-01 7.57236930855170631282646809268044e-01 3.47514792975928241310079602754968e-04
 	 1.17604279684175661371825505341349e-03 2.41587026347987537944206337670039e-01 3.47514792975928241310079602754968e-04
 	 1.17604279684175661371825505341349e-03 7.57236930855170631282646809268044e-01 3.47514792975928241310079602754968e-04
 	 7.57236930855170631282646809268044e-01 2.41587026347987537944206337670039e-01 3.47514792975928241310079602754968e-04
 	 7.57236930855170631282646809268044e-01 1.17604279684175661371825505341349e-03 3.47514792975928241310079602754968e-04
 	 3.33153099720764844793308157022693e-01 1.13953928744148377805167626775074e-01 4.06486029903899495629993054990337e-03
 	 3.33153099720764844793308157022693e-01 5.52892971535086874546038870903431e-01 4.06486029903899495629993054990337e-03
 	 1.13953928744148377805167626775074e-01 3.33153099720764844793308157022693e-01 4.06486029903899495629993054990337e-03
 	 1.13953928744148377805167626775074e-01 5.52892971535086874546038870903431e-01 4.06486029903899495629993054990337e-03
 	 5.52892971535086874546038870903431e-01 3.33153099720764844793308157022693e-01 4.06486029903899495629993054990337e-03
 	 5.52892971535086874546038870903431e-01 1.13953928744148377805167626775074e-01 4.06486029903899495629993054990337e-03
 	 1.55116554813303442195149273175048e-01 8.49385995115550379574997919007728e-02 2.74482817993335331124837850325093e-03
 	 1.55116554813303442195149273175048e-01 7.59944845675141533725138742738636e-01 2.74482817993335331124837850325093e-03
 	 8.49385995115550379574997919007728e-02 1.55116554813303442195149273175048e-01 2.74482817993335331124837850325093e-03
 	 8.49385995115550379574997919007728e-02 7.59944845675141533725138742738636e-01 2.74482817993335331124837850325093e-03
 	 7.59944845675141533725138742738636e-01 1.55116554813303442195149273175048e-01 2.74482817993335331124837850325093e-03
 	 7.59944845675141533725138742738636e-01 8.49385995115550379574997919007728e-02 2.74482817993335331124837850325093e-03
 	 3.71014151677461878620079005486332e-01 1.52565186347216358297984584169171e-01 4.11799366142912449256785478723941e-03
 	 3.71014151677461878620079005486332e-01 4.76420661975321735326360794715583e-01 4.11799366142912449256785478723941e-03
 	 1.52565186347216358297984584169171e-01 3.71014151677461878620079005486332e-01 4.11799366142912449256785478723941e-03
 	 1.52565186347216358297984584169171e-01 4.76420661975321735326360794715583e-01 4.11799366142912449256785478723941e-03
 	 4.76420661975321735326360794715583e-01 3.71014151677461878620079005486332e-01 4.11799366142912449256785478723941e-03
 	 4.76420661975321735326360794715583e-01 1.52565186347216358297984584169171e-01 4.11799366142912449256785478723941e-03
 	 2.70883661807772069263222647350631e-01 1.36186781090766283186521690140580e-02 1.38988675968128349083596795310314e-03
 	 2.70883661807772069263222647350631e-01 7.15497660083151298948678231681697e-01 1.38988675968128349083596795310314e-03
 	 1.36186781090766283186521690140580e-02 2.70883661807772069263222647350631e-01 1.38988675968128349083596795310314e-03
 	 1.36186781090766283186521690140580e-02 7.15497660083151298948678231681697e-01 1.38988675968128349083596795310314e-03
 	 7.15497660083151298948678231681697e-01 2.70883661807772069263222647350631e-01 1.38988675968128349083596795310314e-03
 	 7.15497660083151298948678231681697e-01 1.36186781090766283186521690140580e-02 1.38988675968128349083596795310314e-03
 	 3.52506748415466475421453651506454e-01 5.62263874435523919315116359030071e-02 3.16589094074169784612249323174638e-03
 	 3.52506748415466475421453651506454e-01 5.91266864140981174280398136033909e-01 3.16589094074169784612249323174638e-03
 	 5.62263874435523919315116359030071e-02 3.52506748415466475421453651506454e-01 3.16589094074169784612249323174638e-03
 	 5.62263874435523919315116359030071e-02 5.91266864140981174280398136033909e-01 3.16589094074169784612249323174638e-03
 	 5.91266864140981174280398136033909e-01 3.52506748415466475421453651506454e-01 3.16589094074169784612249323174638e-03
 	 5.91266864140981174280398136033909e-01 5.62263874435523919315116359030071e-02 3.16589094074169784612249323174638e-03
 	 4.05720132778190467615075931462343e-01 8.17534894396882150235938979676575e-02 3.47285535997079227582551297359714e-03
 	 4.05720132778190467615075931462343e-01 5.12526377782121289605754554941086e-01 3.47285535997079227582551297359714e-03
 	 8.17534894396882150235938979676575e-02 4.05720132778190467615075931462343e-01 3.47285535997079227582551297359714e-03
 	 8.17534894396882150235938979676575e-02 5.12526377782121289605754554941086e-01 3.47285535997079227582551297359714e-03
 	 5.12526377782121289605754554941086e-01 4.05720132778190467615075931462343e-01 3.47285535997079227582551297359714e-03
 	 5.12526377782121289605754554941086e-01 8.17534894396882150235938979676575e-02 3.47285535997079227582551297359714e-03
 	 2.18949681014998343009381187584950e-01 6.36424301897473843059316322978702e-02 2.78297055784304482248248113762656e-03
 	 2.18949681014998343009381187584950e-01 7.17407888795254300440262795746094e-01 2.78297055784304482248248113762656e-03
 	 6.36424301897473843059316322978702e-02 2.18949681014998343009381187584950e-01 2.78297055784304482248248113762656e-03
 	 6.36424301897473843059316322978702e-02 7.17407888795254300440262795746094e-01 2.78297055784304482248248113762656e-03
 	 7.17407888795254300440262795746094e-01 2.18949681014998343009381187584950e-01 2.78297055784304482248248113762656e-03
 	 7.17407888795254300440262795746094e-01 6.36424301897473843059316322978702e-02 2.78297055784304482248248113762656e-03
 	 2.06709248085564512020795291391551e-01 1.15394220836074104519219929443352e-01 3.66880507838133768788724253795408e-03
 	 2.06709248085564512020795291391551e-01 6.77896531078361341826621355721727e-01 3.66880507838133768788724253795408e-03
 	 1.15394220836074104519219929443352e-01 2.06709248085564512020795291391551e-01 3.66880507838133768788724253795408e-03
 	 1.15394220836074104519219929443352e-01 6.77896531078361341826621355721727e-01 3.66880507838133768788724253795408e-03
 	 6.77896531078361341826621355721727e-01 2.06709248085564512020795291391551e-01 3.66880507838133768788724253795408e-03
 	 6.77896531078361341826621355721727e-01 1.15394220836074104519219929443352e-01 3.66880507838133768788724253795408e-03
 	 2.56601087879092248922319186021923e-01 1.48187116283310715836307736026356e-01 4.35571331178043284065859452880431e-03
 	 2.56601087879092248922319186021923e-01 5.95211795837596979730221846693894e-01 4.35571331178043284065859452880431e-03
 	 1.48187116283310715836307736026356e-01 2.56601087879092248922319186021923e-01 4.35571331178043284065859452880431e-03
 	 1.48187116283310715836307736026356e-01 5.95211795837596979730221846693894e-01 4.35571331178043284065859452880431e-03
 	 5.95211795837596979730221846693894e-01 2.56601087879092248922319186021923e-01 4.35571331178043284065859452880431e-03
 	 5.95211795837596979730221846693894e-01 1.48187116283310715836307736026356e-01 4.35571331178043284065859452880431e-03
 	 1.38206295211249968746258787177794e-01 1.85978710613813984220410446823735e-02 1.36837471636100881620945468597483e-03
 	 1.38206295211249968746258787177794e-01 8.43195833727368615484465408371761e-01 1.36837471636100881620945468597483e-03
 	 1.85978710613813984220410446823735e-02 1.38206295211249968746258787177794e-01 1.36837471636100881620945468597483e-03
 	 1.85978710613813984220410446823735e-02 8.43195833727368615484465408371761e-01 1.36837471636100881620945468597483e-03
 	 8.43195833727368615484465408371761e-01 1.38206295211249968746258787177794e-01 1.36837471636100881620945468597483e-03
 	 8.43195833727368615484465408371761e-01 1.85978710613813984220410446823735e-02 1.36837471636100881620945468597483e-03
 	 4.25810208585481020371332760987571e-01 3.29710199269463780091804494531971e-02 2.35082879046609070569640032033476e-03
 	 4.25810208585481020371332760987571e-01 5.41218771487572580802805077837547e-01 2.35082879046609070569640032033476e-03
 	 3.29710199269463780091804494531971e-02 4.25810208585481020371332760987571e-01 2.35082879046609070569640032033476e-03
 	 3.29710199269463780091804494531971e-02 5.41218771487572580802805077837547e-01 2.35082879046609070569640032033476e-03
 	 5.41218771487572580802805077837547e-01 4.25810208585481020371332760987571e-01 2.35082879046609070569640032033476e-03
 	 5.41218771487572580802805077837547e-01 3.29710199269463780091804494531971e-02 2.35082879046609070569640032033476e-03
 	 2.79725926952240189216070120892255e-01 8.53795515729538628812989031757752e-02 3.58750447996635662972764180267404e-03
 	 2.79725926952240189216070120892255e-01 6.34894521474805961780418783746427e-01 3.58750447996635662972764180267404e-03
 	 8.53795515729538628812989031757752e-02 2.79725926952240189216070120892255e-01 3.58750447996635662972764180267404e-03
 	 8.53795515729538628812989031757752e-02 6.34894521474805961780418783746427e-01 3.58750447996635662972764180267404e-03
 	 6.34894521474805961780418783746427e-01 2.79725926952240189216070120892255e-01 3.58750447996635662972764180267404e-03
 	 6.34894521474805961780418783746427e-01 8.53795515729538628812989031757752e-02 3.58750447996635662972764180267404e-03
 	 2.24666835802111858333418581423757e-02 3.63305584293396573516976566509129e-03 2.36623486900244448492836024655617e-04
 	 2.24666835802111858333418581423757e-02 9.73900260576854859273510101047577e-01 2.36623486900244448492836024655617e-04
 	 3.63305584293396573516976566509129e-03 2.24666835802111858333418581423757e-02 2.36623486900244448492836024655617e-04
 	 3.63305584293396573516976566509129e-03 9.73900260576854859273510101047577e-01 2.36623486900244448492836024655617e-04
 	 9.73900260576854859273510101047577e-01 2.24666835802111858333418581423757e-02 2.36623486900244448492836024655617e-04
 	 9.73900260576854859273510101047577e-01 3.63305584293396573516976566509129e-03 2.36623486900244448492836024655617e-04
 	 8.38622585244554186179044563687057e-02 2.60200776623639613849281460034035e-02 1.26733105568389002072715587843277e-03
 	 8.38622585244554186179044563687057e-02 8.90117663813180692855553388653789e-01 1.26733105568389002072715587843277e-03
 	 2.60200776623639613849281460034035e-02 8.38622585244554186179044563687057e-02 1.26733105568389002072715587843277e-03
 	 2.60200776623639613849281460034035e-02 8.90117663813180692855553388653789e-01 1.26733105568389002072715587843277e-03
 	 8.90117663813180692855553388653789e-01 8.38622585244554186179044563687057e-02 1.26733105568389002072715587843277e-03
 	 8.90117663813180692855553388653789e-01 2.60200776623639613849281460034035e-02 1.26733105568389002072715587843277e-03
 	 2.84800346414468275035858368937625e-01 3.94569261564381226770059640784893e-02 2.53507865000569820868037140826345e-03
 	 2.84800346414468275035858368937625e-01 6.75742727429093581470453955262201e-01 2.53507865000569820868037140826345e-03
 	 3.94569261564381226770059640784893e-02 2.84800346414468275035858368937625e-01 2.53507865000569820868037140826345e-03
 	 3.94569261564381226770059640784893e-02 6.75742727429093581470453955262201e-01 2.53507865000569820868037140826345e-03
 	 6.75742727429093581470453955262201e-01 2.84800346414468275035858368937625e-01 2.53507865000569820868037140826345e-03
 	 6.75742727429093581470453955262201e-01 3.94569261564381226770059640784893e-02 2.53507865000569820868037140826345e-03
 	 3.56594103536573836521483826800250e-01 1.97707177044081881811532497295048e-02 2.02703604344201156195470758802912e-03
 	 3.56594103536573836521483826800250e-01 6.23635178759017971827915971516632e-01 2.02703604344201156195470758802912e-03
 	 1.97707177044081881811532497295048e-02 3.56594103536573836521483826800250e-01 2.02703604344201156195470758802912e-03
 	 1.97707177044081881811532497295048e-02 6.23635178759017971827915971516632e-01 2.02703604344201156195470758802912e-03
 	 6.23635178759017971827915971516632e-01 3.56594103536573836521483826800250e-01 2.02703604344201156195470758802912e-03
 	 6.23635178759017971827915971516632e-01 1.97707177044081881811532497295048e-02 2.02703604344201156195470758802912e-03
 	 9.74242311151380380174202855414478e-02 5.02869741562738704898638530949029e-03 6.27239193620508111472189316515369e-04
 	 9.74242311151380380174202855414478e-02 8.97547071469234514218271669960814e-01 6.27239193620508111472189316515369e-04
 	 5.02869741562738704898638530949029e-03 9.74242311151380380174202855414478e-02 6.27239193620508111472189316515369e-04
 	 5.02869741562738704898638530949029e-03 8.97547071469234514218271669960814e-01 6.27239193620508111472189316515369e-04
 	 8.97547071469234514218271669960814e-01 9.74242311151380380174202855414478e-02 6.27239193620508111472189316515369e-04
 	 8.97547071469234514218271669960814e-01 5.02869741562738704898638530949029e-03 6.27239193620508111472189316515369e-04
 	 ];
 
 	 case  36 

 	 % ALG. DEG.:   36
 	 % PTS CARD.:  243
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 9.7e-16  

 	 xyw=[
 	 4.12357340313630305050907054464915e-01 4.12357340313630360562058285722742e-01 3.83524725895431411668012877669298e-03
 	 4.12357340313630305050907054464915e-01 1.75285319372739278875883428554516e-01 3.83524725895431801980794972450894e-03
 	 1.75285319372739445409337122327997e-01 4.12357340313630305050907054464915e-01 3.83524725895430067257318995643800e-03
 	 4.39048383245843443223321855839458e-01 4.39048383245843609756775549612939e-01 3.43814785469807957657417674113276e-03
 	 4.39048383245843887312531705902074e-01 1.21903233508312919264326978918689e-01 3.43814785469806873455245188608842e-03
 	 1.21903233508312974775478210176516e-01 4.39048383245843054645263237034669e-01 3.43814785469808304602112869474695e-03
 	 2.35052325458213168252186164863815e-01 2.35052325458214306230786405649269e-01 4.03399885831911848149688992748452e-03
 	 2.35052325458214195208483943133615e-01 5.29895349083572719806056738889311e-01 4.03399885831912715511426981151999e-03
 	 5.29895349083572164694544426311040e-01 2.35052325458213529074669168039691e-01 4.03399885831911327732646199706323e-03
 	 1.50821734779891580835453623876674e-01 1.50821734779891664102180470763415e-01 3.08553034072575615986977481952636e-03
 	 1.50821734779891497568726776989934e-01 6.98356530440216838329092752246652e-01 3.08553034072575442514629884271926e-03
 	 6.98356530440216727306790289730998e-01 1.50821734779891941657936627052550e-01 3.08553034072576093035933375574587e-03
 	 4.64273777634669870817418768638163e-01 4.64273777634670203884326156185125e-01 3.33061681062376581385908735910562e-03
 	 4.64273777634670425928931081216433e-01 7.14524447306599946871941142489959e-02 3.33061681062376321177387339389497e-03
 	 7.14524447306599391760428829911689e-02 4.64273777634669482239360149833374e-01 3.33061681062377448747646724314109e-03
 	 1.91161361877308727530433429819823e-01 1.91161361877309310397521358027006e-01 4.04661253784453171095103485299660e-03
 	 1.91161361877309032841765201737871e-01 6.17677276245382045338772059039911e-01 4.04661253784454385401536669064626e-03
 	 6.17677276245381823294167134008603e-01 1.91161361877309116108492048624612e-01 4.04661253784453691512146278341788e-03
 	 2.93500490934270191756283452377829e-02 2.93500490934270052978405374233262e-02 7.83711855575438057219805898512277e-04
 	 2.93500490934270365228631050058539e-02 9.41299901813145933893167693895521e-01 7.83711855575436105655895424604296e-04
 	 9.41299901813146044915470156411175e-01 2.93500490934269497866893061654991e-02 7.83711855575437948799588649961834e-04
 	 3.08145218991093261529101710038958e-01 3.08145218991093317040252941296785e-01 5.50413808085680605897138661930512e-03
 	 3.08145218991093206017950478781131e-01 3.83709562017813532452947811179911e-01 5.50413808085680605897138661930512e-03
 	 3.83709562017813365919494117406430e-01 3.08145218991093317040252941296785e-01 5.50413808085680605897138661930512e-03
 	 1.11178264788380901095798947153526e-01 1.11178264788381095384828256555920e-01 2.71177446206628640357205739519486e-03
 	 1.11178264788381067629252640927007e-01 7.77643470423238003519372796290554e-01 2.71177446206628423516771242418599e-03
 	 7.77643470423238003519372796290554e-01 1.11178264788381039873677025298093e-01 2.71177446206628510252945041258954e-03
 	 3.81002349603441925474101026338758e-01 3.81002349603441869962949795080931e-01 5.25317300340854068108065177966637e-03
 	 3.81002349603441758940647332565277e-01 2.37995300793116204562949178580311e-01 5.25317300340855195678324562891248e-03
 	 2.37995300793116232318524794209225e-01 3.81002349603442036496403488854412e-01 5.25317300340854068108065177966637e-03
 	 4.94480996747700185522944593685679e-01 4.94480996747700629612154443748295e-01 1.44795788173428382691887428279642e-03
 	 4.94480996747700685123305675006122e-01 1.10380065045991068023445436097063e-02 1.44795788173428295955713629439288e-03
 	 1.10380065045991692523896787747617e-02 4.94480996747700352056398287459160e-01 1.44795788173428404375930877989731e-03
 	 2.55002336075419056005131324127433e-01 3.22922639737692543371316844513785e-02 1.53084158353408369968029489882611e-03
 	 2.55002336075419722138946099221357e-01 7.12705399950811169240694198379060e-01 1.53084158353408651860594336113763e-03
 	 3.22922639737690392314206633272988e-02 2.55002336075419500094341174190049e-01 1.53084158353407871235030146550571e-03
 	 3.22922639737693445427524352453474e-02 7.12705399950811391285299123410368e-01 1.53084158353408239863768791622078e-03
 	 7.12705399950811169240694198379060e-01 2.55002336075419389072038711674395e-01 1.53084158353408651860594336113763e-03
 	 7.12705399950810836173786810832098e-01 3.22922639737693584205402430598042e-02 1.53084158353410299847896514080503e-03
 	 2.71121513603339248099644009926124e-01 9.41402098044081675487504412558337e-02 2.46163598764502977375712156060672e-03
 	 2.71121513603340191789214941309183e-01 6.34738276592251793317700503394008e-01 2.46163598764502977375712156060672e-03
 	 9.41402098044082785710529037714878e-02 2.71121513603339969744610016277875e-01 2.46163598764500158450063693749144e-03
 	 9.41402098044080287708723631112662e-02 6.34738276592251793317700503394008e-01 2.46163598764501632965018274035174e-03
 	 6.34738276592252015362305428425316e-01 2.71121513603339969744610016277875e-01 2.46163598764500592130932687950917e-03
 	 6.34738276592251793317700503394008e-01 9.41402098044082230599016725136607e-02 2.46163598764503671265102546783510e-03
 	 9.26886044848755363823045172466664e-02 6.49936721042400217251966410003661e-02 1.66186042169761717668396983071943e-03
 	 9.26886044848755363823045172466664e-02 8.42317723410884400259135418309597e-01 1.66186042169761804404570781912298e-03
 	 6.49936721042402298920137582172174e-02 9.26886044848756335268191719478637e-02 1.66186042169761761036483882492121e-03
 	 6.49936721042402298920137582172174e-02 8.42317723410884178214530493278289e-01 1.66186042169761175567310740319726e-03
 	 8.42317723410884178214530493278289e-01 9.26886044848755363823045172466664e-02 1.66186042169761045463050042059194e-03
 	 8.42317723410884289236832955793943e-01 6.49936721042400633585600644437363e-02 1.66186042169761652616266633941677e-03
 	 3.29454376584550512330196170296404e-01 7.37136644534190782485083559549821e-02 2.37136824651691929116692492129914e-03
 	 3.29454376584550512330196170296404e-01 5.96831958962031228210776134801563e-01 2.37136824651685770848352774464729e-03
 	 7.37136644534185647703594668200822e-02 3.29454376584549291084869082624209e-01 2.37136824651685727480265875044552e-03
 	 7.37136644534187035482375449646497e-02 5.96831958962030673099263822223293e-01 2.37136824651688416301653639095548e-03
 	 5.96831958962030562076961359707639e-01 3.29454376584550401307893707780750e-01 2.37136824651688633142088136196435e-03
 	 5.96831958962030673099263822223293e-01 7.37136644534187729371765840369335e-02 2.37136824651686378001569366347212e-03
 	 2.88378841130442042928194723572233e-01 5.00649881468918506177701033266203e-02 2.05690064632489460691444627116198e-03
 	 2.88378841130441709861287336025271e-01 6.61556170722666481154305984091479e-01 2.05690064632486685133883064224847e-03
 	 5.00649881468916979621042173675960e-02 2.88378841130441598838984873509617e-01 2.05690064632486077980666472342364e-03
 	 5.00649881468917881677249681615649e-02 6.61556170722666037065096134028863e-01 2.05690064632487812704142449149458e-03
 	 6.61556170722665703998188746481901e-01 2.88378841130442542528555804892676e-01 2.05690064632486468293448567123960e-03
 	 6.61556170722665815020491208997555e-01 5.00649881468921142957384518012987e-02 2.05690064632487292287099656107330e-03
 	 3.92172416405174528719612681015860e-01 6.58963384748945807389830520151008e-02 2.61767126144689171382551329259059e-03
 	 3.92172416405173529518890518374974e-01 5.41931245119931626064158081135247e-01 2.61767126144689171382551329259059e-03
 	 6.58963384748947333946489379741251e-02 3.92172416405172752362773280765396e-01 2.61767126144691513259243897948636e-03
 	 6.58963384748946640057098989018414e-02 5.41931245119931181974948231072631e-01 2.61767126144689561695333424040655e-03
 	 5.41931245119931404019553156103939e-01 3.92172416405174029119251599695417e-01 2.61767126144689561695333424040655e-03
 	 5.41931245119931737086460543650901e-01 6.58963384748946362501342832729279e-02 2.61767126144688217284639542015157e-03
 	 7.62225001558767406573124958413246e-03 1.23411852776322567698530363600185e-03 6.51699642263260068035177208223274e-05
 	 7.62225001558754829827924126561811e-03 9.91143631456649298883121446124278e-01 6.51699642263248548387094549738663e-05
 	 1.23411852776318144153666622742094e-03 7.62225001558765932058170378127215e-03 6.51699642263240281345529347767354e-05
 	 1.23411852776318642886665966074133e-03 9.91143631456649076838516521092970e-01 6.51699642263252343094698249004182e-05
 	 9.91143631456649076838516521092970e-01 7.62225001558776080190504842448718e-03 6.51699642263245702356391775289524e-05
 	 9.91143631456649298883121446124278e-01 1.23411852776320984763358534763711e-03 6.51699642263253156246327613132507e-05
 	 1.78207936627975682686297886903048e-01 1.05695827327609778722994349209330e-01 2.61385214196918538170910650819678e-03
 	 1.78207936627975543908419808758481e-01 7.16096236044414635735222418588819e-01 2.61385214196918191226215455458259e-03
 	 1.05695827327609861989721196096070e-01 1.78207936627975793708600349418703e-01 2.61385214196917540704911964155599e-03
 	 1.05695827327609861989721196096070e-01 7.16096236044414302668315031041857e-01 2.61385214196917237128303668214357e-03
 	 7.16096236044414857779827343620127e-01 1.78207936627975765953024733789789e-01 2.61385214196917020287869171113471e-03
 	 7.16096236044414524712919956073165e-01 1.05695827327610028523174889869551e-01 2.61385214196918364698563053138969e-03
 	 3.10248931459913224184532509752898e-01 1.23871670395551122800803511836421e-01 3.31556877077429429032107144337260e-03
 	 3.10248931459914001340649747362477e-01 5.65879398144535694648027401854051e-01 3.31556877077424745278722006958105e-03
 	 1.23871670395550595444866814887064e-01 3.10248931459913834807196053588996e-01 3.31556877077423877916984018554558e-03
 	 1.23871670395550900756198586805112e-01 5.65879398144535361581120014307089e-01 3.31556877077428258093760859992472e-03
 	 5.65879398144535694648027401854051e-01 3.10248931459913224184532509752898e-01 3.31556877077427911149065664631053e-03
 	 5.65879398144535583625724939338397e-01 1.23871670395550873000622971176199e-01 3.31556877077425178959591001159879e-03
 	 8.29157021331251437024079109505692e-02 2.80739761856612767693119891987408e-03 3.47617319858535913940783546038915e-04
 	 8.29157021331251575801957187650260e-02 9.14276900248308765917215623630909e-01 3.47617319858534938158828309084925e-04
 	 2.80739761856610686024948719818894e-03 8.29157021331252269691347578373097e-02 3.47617319858537486033933650020344e-04
 	 2.80739761856614372312335170533970e-03 9.14276900248308654894913161115255e-01 3.47617319858539546018061372478769e-04
 	 9.14276900248308765917215623630909e-01 8.29157021331250743134688718782854e-02 3.47617319858537648664259522846010e-04
 	 9.14276900248308654894913161115255e-01 2.80739761856612507484598495466344e-03 3.47617319858534775528502436259259e-04
 	 3.79638679346943341830211693377350e-01 1.10689778326021240340004681002029e-01 3.45918624369629355841393447690280e-03
 	 3.79638679346943064274455537088215e-01 5.09671542327035709263327589724213e-01 3.45918624369625712922093896395381e-03
 	 1.10689778326021115439914410671918e-01 3.79638679346942786718699380799080e-01 3.45918624369625149136964203933076e-03
 	 1.10689778326021157073277834115288e-01 5.09671542327035376196420202177251e-01 3.45918624369627707854091269723540e-03
 	 5.09671542327035709263327589724213e-01 3.79638679346943119785606768346042e-01 3.45918624369628141534960263925313e-03
 	 5.09671542327035931307932514755521e-01 1.10689778326021254217792488816485e-01 3.45918624369626883860440180740170e-03
 	 1.98068292114543464954579121695133e-01 2.75642261370559948571723474231021e-03 5.08853424677456912111894737904549e-04
 	 1.98068292114543270665549812292738e-01 7.99175285271751079108071280643344e-01 5.08853424677454526867115269794795e-04
 	 2.75642261370561986871807746979357e-03 1.98068292114543270665549812292738e-01 5.08853424677453767925594529941691e-04
 	 2.75642261370565239478325203492659e-03 7.99175285271750968085768818127690e-01 5.08853424677460381558846691518738e-04
 	 7.99175285271750857063466355612036e-01 1.98068292114543464954579121695133e-01 5.08853424677462441542974413977163e-04
 	 7.99175285271751079108071280643344e-01 2.75642261370559991939810373651198e-03 5.08853424677456153170373998051446e-04
 	 1.47947945322072837992521954220138e-01 7.20516990960158587586903422561591e-02 2.26549564853226409813502506551686e-03
 	 1.47947945322073060037126879251446e-01 7.80000355581911275493212087894790e-01 2.26549564853227060334805997854346e-03
 	 7.20516990960158587586903422561591e-02 1.47947945322073309837307419911667e-01 2.26549564853226930230545299593814e-03
 	 7.20516990960160808032952672874671e-02 7.80000355581910831404002237832174e-01 2.26549564853226670022023903072750e-03
 	 7.80000355581911164470909625379136e-01 1.47947945322072976770400032364705e-01 2.26549564853225629187938316988493e-03
 	 7.80000355581911164470909625379136e-01 7.20516990960158032475391109983320e-02 2.26549564853226843494371500753459e-03
 	 2.29202766553467385257647492835531e-01 1.44286115706842143352472973560907e-02 1.18964024781927925865365747171154e-03
 	 2.29202766553467274235345030319877e-01 7.56368621875848634594774466677336e-01 1.18964024781927969233452646591331e-03
 	 1.44286115706841622935430180518779e-02 2.29202766553467163213042567804223e-01 1.18964024781927405448322954129026e-03
 	 1.44286115706842785200159084979532e-02 7.56368621875848301527867079130374e-01 1.18964024781928533018582339053637e-03
 	 7.56368621875848079483262154099066e-01 2.29202766553467524035525570980099e-01 1.18964024781929075119668581805854e-03
 	 7.56368621875848523572472004161682e-01 1.44286115706842212741412012633191e-02 1.18964024781928533018582339053637e-03
 	 3.57473850344384558308519217462162e-01 2.74256669741186273614452773017547e-03 6.08439554852724644867789649538281e-04
 	 3.57473850344384558308519217462162e-01 6.39783582958203589363677110668505e-01 6.08439554852715429149323522750592e-04
 	 2.74256669741179638297157161730411e-03 3.57473850344384613819670448719990e-01 6.08439554852716296511061511154139e-04
 	 2.74256669741182587327066322302471e-03 6.39783582958203700385979573184159e-01 6.08439554852722151202792932878083e-04
 	 6.39783582958203589363677110668505e-01 3.57473850344384502797367986204335e-01 6.08439554852722693303879175630300e-04
 	 6.39783582958203700385979573184159e-01 2.74256669741183064376022215924422e-03 6.08439554852718681755840979263894e-04
 	 1.25249672229437752912772907620820e-01 3.90243298422157519622643917500682e-02 1.55651362018915267494689746996528e-03
 	 1.25249672229437780668348523249733e-01 8.35725997928346564513901739701396e-01 1.55651362018915094022342149315818e-03
 	 3.90243298422159254346119894307776e-02 1.25249672229437836179499754507560e-01 1.55651362018915549387254593227681e-03
 	 3.90243298422160364569144519464317e-02 8.35725997928346120424691889638780e-01 1.55651362018915549387254593227681e-03
 	 8.35725997928346453491599277185742e-01 1.25249672229437641890470445105166e-01 1.55651362018915310862776646416705e-03
 	 8.35725997928346564513901739701396e-01 3.90243298422157658400521995645249e-02 1.55651362018915462651080794387326e-03
 	 2.09805646004062873455353610552265e-02 7.47466346593329746678113778557417e-03 3.24092666406562040278677150340059e-04
 	 2.09805646004062387732780337046279e-02 9.71544771933660511464836417871993e-01 3.24092666406561931858459901789615e-04
 	 7.47466346593326971120552215666066e-03 2.09805646004062214260432739365569e-02 3.24092666406562419749437520266611e-04
 	 7.47466346593330787512199364641674e-03 9.71544771933660400442533955356339e-01 3.24092666406562365539328895991389e-04
 	 9.71544771933660511464836417871993e-01 2.09805646004061450982103309570448e-02 3.24092666406562690799980641642719e-04
 	 9.71544771933660511464836417871993e-01 7.47466346593318991392562722353432e-03 3.24092666406561172916939161936511e-04
 	 2.69131611744009346942618776665768e-01 1.75571778601519651319406989387062e-01 4.17258237302728721140887557794485e-03
 	 2.69131611744010068587584783017519e-01 5.55296609654471362560457237123046e-01 4.17258237302727420098280575189165e-03
 	 1.75571778601518735385411673632916e-01 2.69131611744010124098736014275346e-01 4.17258237302726205791847391424199e-03
 	 1.75571778601519457030377679984667e-01 5.55296609654470807448944924544776e-01 4.17258237302729501766451747357678e-03
 	 5.55296609654470918471247387060430e-01 2.69131611744009568987223701697076e-01 4.17258237302728027251497167071648e-03
 	 5.55296609654471140515852312091738e-01 1.75571778601519012941167829922051e-01 4.17258237302726899681237782147036e-03
 	 3.46219872421893504199630342554883e-01 1.71226758850752891483182338561164e-01 4.45190142462590591337923129344745e-03
 	 3.46219872421893448688479111297056e-01 4.82553368727353715339489781399607e-01 4.45190142462590244393227933983326e-03
 	 1.71226758850752808216455491674424e-01 3.46219872421893615221932805070537e-01 4.45190142462590244393227933983326e-03
 	 1.71226758850752780460879876045510e-01 4.82553368727353493294884856368299e-01 4.45190142462589984184706537462262e-03
 	 4.82553368727353604317187318883953e-01 3.46219872421893615221932805070537e-01 4.45190142462590417865575531664035e-03
 	 4.82553368727353548806036087626126e-01 1.71226758850753002505484801076818e-01 4.45190142462590851546444525865809e-03
 	 4.42387742658069016421507058112184e-01 3.43061434540936835424496109681058e-02 2.38190698469413486559886905524763e-03
 	 4.42387742658067906198482432955643e-01 5.23306113887838320053447205282282e-01 2.38190698469414223817364195667778e-03
 	 3.43061434540937182369191305042477e-02 4.42387742658068128243087357986951e-01 2.38190698469414484025885592188843e-03
 	 3.43061434540936904813435148753342e-02 5.23306113887837653919632430188358e-01 2.38190698469413833504582100886182e-03
 	 5.23306113887837320852725042641396e-01 4.42387742658069016421507058112184e-01 2.38190698469413529927973804944941e-03
 	 5.23306113887838209031144742766628e-01 3.43061434540937112980252265970194e-02 2.38190698469413660032234503205473e-03
 	 2.74633883722658955761630750203039e-01 3.02963551184709653160687103934379e-03 6.16571745718727439594664119226763e-04
 	 2.74633883722658844739328287687385e-01 7.22336480765494171052409910771530e-01 6.16571745718719633339022223594839e-04
 	 3.02963551184703841837042581630612e-03 2.74633883722658789228177056429558e-01 6.16571745718719741759239472145282e-04
 	 3.02963551184705836769039954958771e-03 7.22336480765494060030107448255876e-01 6.16571745718725162770101899667452e-04
 	 7.22336480765494060030107448255876e-01 2.74633883722658844739328287687385e-01 6.16571745718726463812708882272773e-04
 	 7.22336480765494282074712373287184e-01 3.02963551184707354652081434664979e-03 6.16571745718723211206191425759471e-04
 	 2.23701284655143856072712083005172e-01 7.24869584556439711109376844433427e-02 2.64051811768302056512847109104314e-03
 	 2.23701284655143939339438929891912e-01 7.03811756889212047916259962221375e-01 2.64051811768304051444844482432472e-03
 	 7.24869584556440127443011078867130e-02 2.23701284655144300161921933067788e-01 2.64051811768304008076757583012295e-03
 	 7.24869584556441515221791860312806e-02 7.03811756889211603827050112158759e-01 2.64051811768303661132062387650876e-03
 	 7.03811756889211714849352574674413e-01 2.23701284655144327917497548696701e-01 2.64051811768302576929889902146442e-03
 	 7.03811756889212047916259962221375e-01 7.24869584556441237666035704023670e-02 2.64051811768304311653365878953537e-03
 	 2.26472947511629524308673921950685e-01 1.33817023340664253971965536038624e-01 3.60197908152548726054553718256557e-03
 	 2.26472947511629746353278846981993e-01 6.39710029147706471519541082670912e-01 3.60197908152548682686466818836379e-03
 	 1.33817023340663726616028839089267e-01 2.26472947511629885131156925126561e-01 3.60197908152547468380033635071413e-03
 	 1.33817023340663920905058148491662e-01 6.39710029147706138452633695123950e-01 3.60197908152549680152465505500459e-03
 	 6.39710029147706249474936157639604e-01 2.26472947511629885131156925126561e-01 3.60197908152550070465247600282055e-03
 	 6.39710029147706471519541082670912e-01 1.33817023340664004171784995378403e-01 3.60197908152548379109858522895138e-03
 	 1.63361966829370597320547631170484e-01 1.76742202382502121282836782256709e-02 1.27502323317564905669208030758455e-03
 	 1.63361966829370458542669553025917e-01 8.18963812932379409126326663681539e-01 1.27502323317564710512816983367657e-03
 	 1.76742202382502190671775821328993e-02 1.63361966829370403031518321768090e-01 1.27502323317565079141555628439164e-03
 	 1.76742202382503023339044290196398e-02 8.18963812932379187081721738650231e-01 1.27502323317565556190511522061115e-03
 	 8.18963812932379187081721738650231e-01 1.63361966829370458542669553025917e-01 1.27502323317565642926685320901470e-03
 	 8.18963812932379409126326663681539e-01 1.76742202382502121282836782256709e-02 1.27502323317564688828773533657568e-03
 	 1.90791272854378801682173616427463e-01 4.22082170395820591157765022671811e-02 2.04656057870132405962504407170854e-03
 	 1.90791272854379051482354157087684e-01 7.67000510106039090629792553954758e-01 2.04656057870132796275286501952451e-03
 	 4.22082170395819619712618475659838e-02 1.90791272854379079237929772716598e-01 2.04656057870132752907199602532273e-03
 	 4.22082170395821631991850608756067e-02 7.67000510106038979607490091439104e-01 2.04656057870133099851894797893692e-03
 	 7.67000510106039201652095016470412e-01 1.90791272854378773926598000798549e-01 2.04656057870132666171025803691919e-03
 	 7.67000510106039201652095016470412e-01 4.22082170395819689101557514732121e-02 2.04656057870132839643373401372628e-03
 	 3.58165870631431071391403975212597e-01 3.44163203969896983047682681444712e-02 2.23469587180632426465232143186768e-03
 	 3.58165870631430405257589200118673e-01 6.07417808971580264199019438819960e-01 2.23469587180631689207754853043753e-03
 	 3.44163203969894623823755352987064e-02 3.58165870631430294235286737603019e-01 2.23469587180631515735407255363043e-03
 	 3.44163203969895942213597095360456e-02 6.07417808971579598065204663726036e-01 2.23469587180631775943928651884107e-03
 	 6.07417808971579376020599738694727e-01 3.58165870631431015880252743954770e-01 2.23469587180631385631146557102511e-03
 	 6.07417808971580042154414513788652e-01 3.44163203969894970768450548348483e-02 2.23469587180631862680102450724462e-03
 	 9.93849892050522321085281873820350e-02 1.74529902610204186441666962537056e-02 1.05061121151762298410459184339061e-03
 	 9.93849892050521072084379170519242e-02 8.83162020533927560883569185534725e-01 1.05061121151761994833850888397819e-03
 	 1.74529902610204463997423118826191e-02 9.93849892050521765973769561242079e-02 1.05061121151762471882806782019770e-03
 	 1.74529902610205157886813509549029e-02 8.83162020533927116794359335472109e-01 1.05061121151762818827501977381189e-03
 	 8.83162020533927338838964260503417e-01 9.93849892050522321085281873820350e-02 1.05061121151762298410459184339061e-03
 	 8.83162020533927449861266723019071e-01 1.74529902610204082358258403928630e-02 1.05061121151762168306198486078529e-03
 	 4.50232897891652383837168827085407e-01 1.22783484472309520514621272724298e-03 4.11044553657112943928497728052207e-04
 	 4.50232897891652661392924983374542e-01 5.48539267263624341630645631084917e-01 4.11044553657105029252638583869839e-04
 	 1.22783484472303839295237448681064e-03 4.50232897891652661392924983374542e-01 4.11044553657109257641111277337131e-04
 	 1.22783484472308132735840491278623e-03 5.48539267263624563675250556116225e-01 4.11044553657114353391321959207971e-04
 	 5.48539267263624674697553018631879e-01 4.50232897891652328326017595827579e-01 4.11044553657115329173277196161962e-04
 	 5.48539267263624563675250556116225e-01 1.22783484472303340562238105349024e-03 4.11044553657105408723398953796391e-04
 	 3.04860292986679104476621660069213e-01 2.36263190066308609305067989225790e-01 5.10667280776456924268336123873269e-03
 	 3.04860292986679382032377816358348e-01 4.58876516947012091929281041302602e-01 5.10667280776455883434250537789012e-03
 	 2.36263190066308526038341142339050e-01 3.04860292986679493054680278874002e-01 5.10667280776455970170424336629367e-03
 	 2.36263190066308498282765526710136e-01 4.58876516947012369485037197591737e-01 5.10667280776457531421552715755752e-03
 	 4.58876516947012147440432272560429e-01 3.04860292986679326521226585100521e-01 5.10667280776456750795988526192559e-03
 	 4.58876516947011869884676116271294e-01 2.36263190066308664816219220483617e-01 5.10667280776455449753381543587238e-03
 	 3.13583606270695258722014386876253e-01 1.55229285287318569813708180049616e-02 1.52011067741505685561864691379697e-03
 	 3.13583606270695203210863155618426e-01 6.70893465200573246853821274271468e-01 1.52011067741503950838388714572602e-03
 	 1.55229285287315933034024695302833e-02 3.13583606270695147699711924360599e-01 1.52011067741503733997954217471715e-03
 	 1.55229285287317771840909230718353e-02 6.70893465200573135831518811755814e-01 1.52011067741505230196952247467834e-03
 	 6.70893465200573024809216349240160e-01 3.13583606270695147699711924360599e-01 1.52011067741505512089517093698987e-03
 	 6.70893465200573357876123736787122e-01 1.55229285287317164687692638835870e-02 1.52011067741504384519257708774376e-03
 	 1.34806288266682949839037064521108e-01 3.84804577084500720740578572076629e-03 5.54805076808530684556730605550001e-04
 	 1.34806288266682922083461448892194e-01 8.61345665962472084586920573201496e-01 5.54805076808528624572602883091577e-04
 	 3.84804577084505187653529212354897e-03 1.34806288266682894327885833263281e-01 5.54805076808530792976947854100445e-04
 	 3.84804577084501935047011755841595e-03 8.61345665962471973564618110685842e-01 5.54805076808530901397165102650888e-04
 	 8.61345665962471973564618110685842e-01 1.34806288266682894327885833263281e-01 5.54805076808531551918468593953548e-04
 	 8.61345665962471973564618110685842e-01 3.84804577084500807476752370916984e-03 5.54805076808529491934340871495124e-04
 	 6.58281924328198708717962972514215e-02 3.80724693230129473953127217100700e-02 1.33345058300172406712258421634942e-03
 	 6.58281924328198292384328738080512e-02 8.96099338244167209488466596667422e-01 1.33345058300172319976084622794588e-03
 	 3.80724693230131139287664154835511e-02 6.58281924328198431162206816225080e-02 1.33345058300172710288866717576184e-03
 	 3.80724693230131347454481272052362e-02 8.96099338244166987443861671636114e-01 1.33345058300172797025040516416539e-03
 	 8.96099338244166987443861671636114e-01 6.58281924328198431162206816225080e-02 1.33345058300172666920779818156007e-03
 	 8.96099338244167209488466596667422e-01 3.80724693230129335175249138956133e-02 1.33345058300172536816519119895474e-03
 	 5.31928439194578189797013578754559e-02 1.21702541539400934528236675191692e-02 6.67804382032509500494166232442694e-04
 	 5.31928439194577218351867031742586e-02 9.34636901926602203793947865051450e-01 6.67804382032508849972862741140034e-04
 	 1.21702541539401541681453267074176e-02 5.31928439194577704074440305248572e-02 6.67804382032510801536773215048015e-04
 	 1.21702541539401992709557021044020e-02 9.34636901926601981749342940020142e-01 6.67804382032512102579380197653336e-04
 	 9.34636901926601981749342940020142e-01 5.31928439194577842852318383393140e-02 6.67804382032510476276121469396685e-04
 	 9.34636901926602203793947865051450e-01 1.21702541539400292680550563773068e-02 6.67804382032508633132428244039147e-04
 	 4.06479626359585594075340964081988e-02 8.58559044683869401586029379558340e-04 1.33088911946719918449888453437779e-04
 	 4.06479626359585802242158081298840e-02 9.58493478319357605776929176499834e-01 1.33088911946718698722444407245291e-04
 	 8.58559044683909083385542349020625e-04 4.06479626359585802242158081298840e-02 1.33088911946720921336898002529381e-04
 	 8.58559044683947680982882832978476e-04 9.58493478319357383732324251468526e-01 1.33088911946722872900808476437362e-04
 	 9.58493478319357605776929176499834e-01 4.06479626359583859351864987274894e-02 1.33088911946724173943415459042683e-04
 	 9.58493478319357494754626713984180e-01 8.58559044683810204147411671016243e-04 1.33088911946717045314131366851029e-04
 	 4.06447567212284976978509121181560e-01 1.23358378103272641607146553610619e-02 1.44384349566076177623363818725011e-03
 	 4.06447567212284921467357889923733e-01 5.81216594977387979170657672511879e-01 1.44384349566075700574407925103060e-03
 	 1.23358378103271409953478610077582e-02 4.06447567212284865956206658665906e-01 1.44384349566076025835059670754390e-03
 	 1.23358378103272051801164721496207e-02 5.81216594977387979170657672511879e-01 1.44384349566075982466972771334213e-03
 	 5.81216594977387868148355209996225e-01 4.06447567212284865956206658665906e-01 1.44384349566076416147841765535986e-03
 	 5.81216594977387979170657672511879e-01 1.23358378103271479342417649149866e-02 1.44384349566075722258451374813149e-03
 	 ];
 
 	 case  37 

 	 % ALG. DEG.:   37
 	 % PTS CARD.:  252
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw=[
 	 1.02303932157760305021731994656875e-01 1.02303932157760305021731994656875e-01 7.56994885929007654823408302036114e-04
 	 1.02303932157760305021731994656875e-01 7.95392135684479417712111626315163e-01 7.56994885929007654823408302036114e-04
 	 7.95392135684479417712111626315163e-01 1.02303932157760305021731994656875e-01 7.56994885929007654823408302036114e-04
 	 3.50202358754684098252063506606646e-02 3.50202358754684098252063506606646e-02 5.52341834522307299250309942095782e-04
 	 3.50202358754684098252063506606646e-02 9.29959528249063138716223875235301e-01 5.52341834522307299250309942095782e-04
 	 9.29959528249063138716223875235301e-01 3.50202358754684098252063506606646e-02 5.52341834522307299250309942095782e-04
 	 2.59243490456549541267605718530831e-01 2.59243490456549541267605718530831e-01 3.79254617818526248984589699375647e-03
 	 2.59243490456549541267605718530831e-01 4.81513019086900917464788562938338e-01 3.79254617818526248984589699375647e-03
 	 4.81513019086900917464788562938338e-01 2.59243490456549541267605718530831e-01 3.79254617818526248984589699375647e-03
 	 1.39441235872292679243145130385528e-01 1.39441235872292679243145130385528e-01 2.62503007716438857901963821461777e-03
 	 1.39441235872292679243145130385528e-01 7.21117528255414641513709739228943e-01 2.62503007716438857901963821461777e-03
 	 7.21117528255414641513709739228943e-01 1.39441235872292679243145130385528e-01 2.62503007716438857901963821461777e-03
 	 4.61168458890810040173846573452465e-01 4.61168458890810040173846573452465e-01 2.94041733963891450606698008130024e-03
 	 4.61168458890810040173846573452465e-01 7.76630822183799196523068530950695e-02 2.94041733963891450606698008130024e-03
 	 7.76630822183799196523068530950695e-02 4.61168458890810040173846573452465e-01 2.94041733963891450606698008130024e-03
 	 3.79153717955037827813669082388515e-01 3.79153717955037827813669082388515e-01 4.32227828704266625603480633799336e-03
 	 3.79153717955037827813669082388515e-01 2.41692564089924344372661835222971e-01 4.32227828704266625603480633799336e-03
 	 2.41692564089924344372661835222971e-01 3.79153717955037827813669082388515e-01 4.32227828704266625603480633799336e-03
 	 1.73411753639024328321749379711036e-02 1.73411753639024328321749379711036e-02 4.38793626075407376500858713797015e-04
 	 1.73411753639024328321749379711036e-02 9.65317649272195099641180604521651e-01 4.38793626075407376500858713797015e-04
 	 9.65317649272195099641180604521651e-01 1.73411753639024328321749379711036e-02 4.38793626075407376500858713797015e-04
 	 7.79889301806426238350411495048320e-02 7.79889301806426238350411495048320e-02 1.79311680137484233399369770722842e-03
 	 7.79889301806426238350411495048320e-02 8.44022139638714752329917700990336e-01 1.79311680137484233399369770722842e-03
 	 8.44022139638714752329917700990336e-01 7.79889301806426238350411495048320e-02 1.79311680137484233399369770722842e-03
 	 4.79244935556920326202856585950940e-01 4.79244935556920326202856585950940e-01 2.49962141423790921296310685306707e-03
 	 4.79244935556920326202856585950940e-01 4.15101288861593475942868280981202e-02 2.49962141423790921296310685306707e-03
 	 4.15101288861593475942868280981202e-02 4.79244935556920326202856585950940e-01 2.49962141423790921296310685306707e-03
 	 4.12061405479689502051598992693471e-01 4.12061405479689502051598992693471e-01 4.53942125276982424986194075700041e-03
 	 4.12061405479689502051598992693471e-01 1.75877189040620995896802014613058e-01 4.53942125276982424986194075700041e-03
 	 1.75877189040620995896802014613058e-01 4.12061405479689502051598992693471e-01 4.53942125276982424986194075700041e-03
 	 4.98410574413956974915151931782020e-01 4.98410574413956974915151931782020e-01 7.07839054597255682051148983902067e-04
 	 4.98410574413956974915151931782020e-01 3.17885117208605016969613643595949e-03 7.07839054597255682051148983902067e-04
 	 3.17885117208605016969613643595949e-03 4.98410574413956974915151931782020e-01 7.07839054597255682051148983902067e-04
 	 3.09125948685350482314504461101023e-01 3.09125948685350482314504461101023e-01 5.10331832458679572617210595808501e-03
 	 3.09125948685350482314504461101023e-01 3.81748102629299035370991077797953e-01 5.10331832458679572617210595808501e-03
 	 3.81748102629299035370991077797953e-01 3.09125948685350482314504461101023e-01 5.10331832458679572617210595808501e-03
 	 3.67156682198311505940790944180208e-03 3.67156682198311505940790944180208e-03 8.66476678904295929527917818901983e-05
 	 3.67156682198311505940790944180208e-03 9.92656866356033784626333726919256e-01 8.66476678904295929527917818901983e-05
 	 9.92656866356033784626333726919256e-01 3.67156682198311505940790944180208e-03 8.66476678904295929527917818901983e-05
 	 1.89364261200196171142096090989071e-01 1.89364261200196171142096090989071e-01 4.14530662852686040964478308978869e-03
 	 1.89364261200196171142096090989071e-01 6.21271477599607657715807818021858e-01 4.14530662852686040964478308978869e-03
 	 6.21271477599607657715807818021858e-01 1.89364261200196171142096090989071e-01 4.14530662852686040964478308978869e-03
 	 3.16024096496639927966754157750984e-01 3.38290906827213161411904707165377e-02 1.04959604867473662963284208871073e-03
 	 3.16024096496639927966754157750984e-01 6.50146812820638797525418794975849e-01 1.04959604867473662963284208871073e-03
 	 3.38290906827213161411904707165377e-02 3.16024096496639927966754157750984e-01 1.04959604867473662963284208871073e-03
 	 3.38290906827213161411904707165377e-02 6.50146812820638797525418794975849e-01 1.04959604867473662963284208871073e-03
 	 6.50146812820638797525418794975849e-01 3.16024096496639927966754157750984e-01 1.04959604867473662963284208871073e-03
 	 6.50146812820638797525418794975849e-01 3.38290906827213161411904707165377e-02 1.04959604867473662963284208871073e-03
 	 1.05359411960281923459348263349966e-01 3.31459895561884293480048313540465e-02 9.61312586091038847636858211131994e-04
 	 1.05359411960281923459348263349966e-01 8.61494598483529716581585944368271e-01 9.61312586091038847636858211131994e-04
 	 3.31459895561884293480048313540465e-02 1.05359411960281923459348263349966e-01 9.61312586091038847636858211131994e-04
 	 3.31459895561884293480048313540465e-02 8.61494598483529716581585944368271e-01 9.61312586091038847636858211131994e-04
 	 8.61494598483529716581585944368271e-01 1.05359411960281923459348263349966e-01 9.61312586091038847636858211131994e-04
 	 8.61494598483529716581585944368271e-01 3.31459895561884293480048313540465e-02 9.61312586091038847636858211131994e-04
 	 7.49810217841138243466403423553857e-02 2.03347607611732879295818321452316e-03 2.40221505000938354099787597206728e-04
 	 7.49810217841138243466403423553857e-02 9.22985502139768820839549334777985e-01 2.40221505000938354099787597206728e-04
 	 2.03347607611732879295818321452316e-03 7.49810217841138243466403423553857e-02 2.40221505000938354099787597206728e-04
 	 2.03347607611732879295818321452316e-03 9.22985502139768820839549334777985e-01 2.40221505000938354099787597206728e-04
 	 9.22985502139768820839549334777985e-01 7.49810217841138243466403423553857e-02 2.40221505000938354099787597206728e-04
 	 9.22985502139768820839549334777985e-01 2.03347607611732879295818321452316e-03 2.40221505000938354099787597206728e-04
 	 1.19486593380355193838582295029482e-01 5.55104031624588586946167367841554e-02 1.51627373004474563268628717338515e-03
 	 1.19486593380355193838582295029482e-01 8.25003003457186023794633911165874e-01 1.51627373004474563268628717338515e-03
 	 5.55104031624588586946167367841554e-02 1.19486593380355193838582295029482e-01 1.51627373004474563268628717338515e-03
 	 5.55104031624588586946167367841554e-02 8.25003003457186023794633911165874e-01 1.51627373004474563268628717338515e-03
 	 8.25003003457186023794633911165874e-01 1.19486593380355193838582295029482e-01 1.51627373004474563268628717338515e-03
 	 8.25003003457186023794633911165874e-01 5.55104031624588586946167367841554e-02 1.51627373004474563268628717338515e-03
 	 3.19235165045989144338989262905670e-01 2.38060847117024854124878174843616e-01 3.65945316462084864819748197817262e-03
 	 3.19235165045989144338989262905670e-01 4.42703987836986001536132562250714e-01 3.65945316462084864819748197817262e-03
 	 2.38060847117024854124878174843616e-01 3.19235165045989144338989262905670e-01 3.65945316462084864819748197817262e-03
 	 2.38060847117024854124878174843616e-01 4.42703987836986001536132562250714e-01 3.65945316462084864819748197817262e-03
 	 4.42703987836986001536132562250714e-01 3.19235165045989144338989262905670e-01 3.65945316462084864819748197817262e-03
 	 4.42703987836986001536132562250714e-01 2.38060847117024854124878174843616e-01 3.65945316462084864819748197817262e-03
 	 3.91788257723670096943635599018307e-01 7.52705489375098402149433240992948e-02 2.69415942149049117068648762085559e-03
 	 3.91788257723670096943635599018307e-01 5.32941193338820062841421076882398e-01 2.69415942149049117068648762085559e-03
 	 7.52705489375098402149433240992948e-02 3.91788257723670096943635599018307e-01 2.69415942149049117068648762085559e-03
 	 7.52705489375098402149433240992948e-02 5.32941193338820062841421076882398e-01 2.69415942149049117068648762085559e-03
 	 5.32941193338820062841421076882398e-01 3.91788257723670096943635599018307e-01 2.69415942149049117068648762085559e-03
 	 5.32941193338820062841421076882398e-01 7.52705489375098402149433240992948e-02 2.69415942149049117068648762085559e-03
 	 3.17543407214198269983285172202159e-01 5.36208316291131165121086610270140e-02 2.28460795949074089647434782079927e-03
 	 3.17543407214198269983285172202159e-01 6.28835761156688599626818358956371e-01 2.28460795949074089647434782079927e-03
 	 5.36208316291131165121086610270140e-02 3.17543407214198269983285172202159e-01 2.28460795949074089647434782079927e-03
 	 5.36208316291131165121086610270140e-02 6.28835761156688599626818358956371e-01 2.28460795949074089647434782079927e-03
 	 6.28835761156688599626818358956371e-01 3.17543407214198269983285172202159e-01 2.28460795949074089647434782079927e-03
 	 6.28835761156688599626818358956371e-01 5.36208316291131165121086610270140e-02 2.28460795949074089647434782079927e-03
 	 3.26764524592731753216412471374497e-01 9.12947670950428336045234800621984e-02 2.86017995322923818460325584567272e-03
 	 3.26764524592731753216412471374497e-01 5.81940708312225440934639664192218e-01 2.86017995322923818460325584567272e-03
 	 9.12947670950428336045234800621984e-02 3.26764524592731753216412471374497e-01 2.86017995322923818460325584567272e-03
 	 9.12947670950428336045234800621984e-02 5.81940708312225440934639664192218e-01 2.86017995322923818460325584567272e-03
 	 5.81940708312225440934639664192218e-01 3.26764524592731753216412471374497e-01 2.86017995322923818460325584567272e-03
 	 5.81940708312225440934639664192218e-01 9.12947670950428336045234800621984e-02 2.86017995322923818460325584567272e-03
 	 3.18749666827180144768050240600132e-01 1.35115749070284674182573780854000e-01 3.35600242454283520521229888800008e-03
 	 3.18749666827180144768050240600132e-01 5.46134584102535236560527209803695e-01 3.35600242454283520521229888800008e-03
 	 1.35115749070284674182573780854000e-01 3.18749666827180144768050240600132e-01 3.35600242454283520521229888800008e-03
 	 1.35115749070284674182573780854000e-01 5.46134584102535236560527209803695e-01 3.35600242454283520521229888800008e-03
 	 5.46134584102535236560527209803695e-01 3.18749666827180144768050240600132e-01 3.35600242454283520521229888800008e-03
 	 5.46134584102535236560527209803695e-01 1.35115749070284674182573780854000e-01 3.35600242454283520521229888800008e-03
 	 6.74578790813868262032926281790424e-02 4.07701237566786764410231569399912e-02 1.15853875465657374897732179164223e-03
 	 6.74578790813868262032926281790424e-02 8.91771997161934559805729350046022e-01 1.15853875465657374897732179164223e-03
 	 4.07701237566786764410231569399912e-02 6.74578790813868262032926281790424e-02 1.15853875465657374897732179164223e-03
 	 4.07701237566786764410231569399912e-02 8.91771997161934559805729350046022e-01 1.15853875465657374897732179164223e-03
 	 8.91771997161934559805729350046022e-01 6.74578790813868262032926281790424e-02 1.15853875465657374897732179164223e-03
 	 8.91771997161934559805729350046022e-01 4.07701237566786764410231569399912e-02 1.15853875465657374897732179164223e-03
 	 1.83794409210811804378238321078243e-02 2.99027787656391775758524254058557e-03 1.54334630985266210191630964487786e-04
 	 1.83794409210811804378238321078243e-02 9.78630281202354956882061287615215e-01 1.54334630985266210191630964487786e-04
 	 2.99027787656391775758524254058557e-03 1.83794409210811804378238321078243e-02 1.54334630985266210191630964487786e-04
 	 2.99027787656391775758524254058557e-03 9.78630281202354956882061287615215e-01 1.54334630985266210191630964487786e-04
 	 9.78630281202354956882061287615215e-01 1.83794409210811804378238321078243e-02 1.54334630985266210191630964487786e-04
 	 9.78630281202354956882061287615215e-01 2.99027787656391775758524254058557e-03 1.54334630985266210191630964487786e-04
 	 4.76569358622159489069503024438745e-02 1.72509604538075254909212929987916e-02 6.02351384720529949186318408038687e-04
 	 4.76569358622159489069503024438745e-02 9.35092103683976549888257068232633e-01 6.02351384720529949186318408038687e-04
 	 1.72509604538075254909212929987916e-02 4.76569358622159489069503024438745e-02 6.02351384720529949186318408038687e-04
 	 1.72509604538075254909212929987916e-02 9.35092103683976549888257068232633e-01 6.02351384720529949186318408038687e-04
 	 9.35092103683976549888257068232633e-01 4.76569358622159489069503024438745e-02 6.02351384720529949186318408038687e-04
 	 9.35092103683976549888257068232633e-01 1.72509604538075254909212929987916e-02 6.02351384720529949186318408038687e-04
 	 3.35722787038010062055093385424698e-01 1.81116409195531985476534941881255e-01 4.08187312607179424855941007876936e-03
 	 3.35722787038010062055093385424698e-01 4.83160803766457980223947288322961e-01 4.08187312607179424855941007876936e-03
 	 1.81116409195531985476534941881255e-01 3.35722787038010062055093385424698e-01 4.08187312607179424855941007876936e-03
 	 1.81116409195531985476534941881255e-01 4.83160803766457980223947288322961e-01 4.08187312607179424855941007876936e-03
 	 4.83160803766457980223947288322961e-01 3.35722787038010062055093385424698e-01 4.08187312607179424855941007876936e-03
 	 4.83160803766457980223947288322961e-01 1.81116409195531985476534941881255e-01 4.08187312607179424855941007876936e-03
 	 1.35671607916117625824981018922699e-01 9.01302718482900888652409321366576e-02 2.18226201409495428745755063459910e-03
 	 1.35671607916117625824981018922699e-01 7.74198120235592313065353664569557e-01 2.18226201409495428745755063459910e-03
 	 9.01302718482900888652409321366576e-02 1.35671607916117625824981018922699e-01 2.18226201409495428745755063459910e-03
 	 9.01302718482900888652409321366576e-02 7.74198120235592313065353664569557e-01 2.18226201409495428745755063459910e-03
 	 7.74198120235592313065353664569557e-01 1.35671607916117625824981018922699e-01 2.18226201409495428745755063459910e-03
 	 7.74198120235592313065353664569557e-01 9.01302718482900888652409321366576e-02 2.18226201409495428745755063459910e-03
 	 4.17693614359697928950510004142416e-02 4.01709708723125332591186165132058e-03 2.74898275323659198928621938406991e-04
 	 4.17693614359697928950510004142416e-02 9.54213541476798932094993688224349e-01 2.74898275323659198928621938406991e-04
 	 4.01709708723125332591186165132058e-03 4.17693614359697928950510004142416e-02 2.74898275323659198928621938406991e-04
 	 4.01709708723125332591186165132058e-03 9.54213541476798932094993688224349e-01 2.74898275323659198928621938406991e-04
 	 9.54213541476798932094993688224349e-01 4.17693614359697928950510004142416e-02 2.74898275323659198928621938406991e-04
 	 9.54213541476798932094993688224349e-01 4.01709708723125332591186165132058e-03 2.74898275323659198928621938406991e-04
 	 1.91263737438076231178740727045806e-01 8.09653202292540813411747535610630e-02 2.62321907934608654355823631476596e-03
 	 1.91263737438076231178740727045806e-01 7.27770942332669701357872327207588e-01 2.62321907934608654355823631476596e-03
 	 8.09653202292540813411747535610630e-02 1.91263737438076231178740727045806e-01 2.62321907934608654355823631476596e-03
 	 8.09653202292540813411747535610630e-02 7.27770942332669701357872327207588e-01 2.62321907934608654355823631476596e-03
 	 7.27770942332669701357872327207588e-01 1.91263737438076231178740727045806e-01 2.62321907934608654355823631476596e-03
 	 7.27770942332669701357872327207588e-01 8.09653202292540813411747535610630e-02 2.62321907934608654355823631476596e-03
 	 4.48920329956642827351487312625977e-01 1.68814585101307729209096919475996e-02 1.62924472819564610491516187806837e-03
 	 4.48920329956642827351487312625977e-01 5.34198211533226330338663956354139e-01 1.62924472819564610491516187806837e-03
 	 1.68814585101307729209096919475996e-02 4.48920329956642827351487312625977e-01 1.62924472819564610491516187806837e-03
 	 1.68814585101307729209096919475996e-02 5.34198211533226330338663956354139e-01 1.62924472819564610491516187806837e-03
 	 5.34198211533226330338663956354139e-01 4.48920329956642827351487312625977e-01 1.62924472819564610491516187806837e-03
 	 5.34198211533226330338663956354139e-01 1.68814585101307729209096919475996e-02 1.62924472819564610491516187806837e-03
 	 3.97083379134988478931234112678794e-01 4.14766785336368876135892946876993e-02 2.39061749419019640636174806047620e-03
 	 3.97083379134988478931234112678794e-01 5.61439942331374619577388784819050e-01 2.39061749419019640636174806047620e-03
 	 4.14766785336368876135892946876993e-02 3.97083379134988478931234112678794e-01 2.39061749419019640636174806047620e-03
 	 4.14766785336368876135892946876993e-02 5.61439942331374619577388784819050e-01 2.39061749419019640636174806047620e-03
 	 5.61439942331374619577388784819050e-01 3.97083379134988478931234112678794e-01 2.39061749419019640636174806047620e-03
 	 5.61439942331374619577388784819050e-01 4.14766785336368876135892946876993e-02 2.39061749419019640636174806047620e-03
 	 8.62263440628871780102571165116387e-02 1.37345861622121794692885643485170e-02 8.04385951443430027157921458069723e-04
 	 8.62263440628871780102571165116387e-02 9.00039069774900668541306458791951e-01 8.04385951443430027157921458069723e-04
 	 1.37345861622121794692885643485170e-02 8.62263440628871780102571165116387e-02 8.04385951443430027157921458069723e-04
 	 1.37345861622121794692885643485170e-02 9.00039069774900668541306458791951e-01 8.04385951443430027157921458069723e-04
 	 9.00039069774900668541306458791951e-01 8.62263440628871780102571165116387e-02 8.04385951443430027157921458069723e-04
 	 9.00039069774900668541306458791951e-01 1.37345861622121794692885643485170e-02 8.04385951443430027157921458069723e-04
 	 2.81487959942281984471179612228298e-01 1.79186043302918159014769372561204e-02 1.49128325264966544311251439580701e-03
 	 2.81487959942281984471179612228298e-01 7.00593435727426272485729441541480e-01 1.49128325264966544311251439580701e-03
 	 1.79186043302918159014769372561204e-02 2.81487959942281984471179612228298e-01 1.49128325264966544311251439580701e-03
 	 1.79186043302918159014769372561204e-02 7.00593435727426272485729441541480e-01 1.49128325264966544311251439580701e-03
 	 7.00593435727426272485729441541480e-01 2.81487959942281984471179612228298e-01 1.49128325264966544311251439580701e-03
 	 7.00593435727426272485729441541480e-01 1.79186043302918159014769372561204e-02 1.49128325264966544311251439580701e-03
 	 1.92376834744259289644574550948164e-01 1.28471390056792922340633822386735e-01 3.04697442177643109187390457748279e-03
 	 1.92376834744259289644574550948164e-01 6.79151775198947760259216011036187e-01 3.04697442177643109187390457748279e-03
 	 1.28471390056792922340633822386735e-01 1.92376834744259289644574550948164e-01 3.04697442177643109187390457748279e-03
 	 1.28471390056792922340633822386735e-01 6.79151775198947760259216011036187e-01 3.04697442177643109187390457748279e-03
 	 6.79151775198947760259216011036187e-01 1.92376834744259289644574550948164e-01 3.04697442177643109187390457748279e-03
 	 6.79151775198947760259216011036187e-01 1.28471390056792922340633822386735e-01 3.04697442177643109187390457748279e-03
 	 2.51794247517433122940389012001106e-01 1.37321159731595615616228656108433e-01 3.54367037302832183984224734274449e-03
 	 2.51794247517433122940389012001106e-01 6.10884592750971289198957947519375e-01 3.54367037302832183984224734274449e-03
 	 1.37321159731595615616228656108433e-01 2.51794247517433122940389012001106e-01 3.54367037302832183984224734274449e-03
 	 1.37321159731595615616228656108433e-01 6.10884592750971289198957947519375e-01 3.54367037302832183984224734274449e-03
 	 6.10884592750971289198957947519375e-01 2.51794247517433122940389012001106e-01 3.54367037302832183984224734274449e-03
 	 6.10884592750971289198957947519375e-01 1.37321159731595615616228656108433e-01 3.54367037302832183984224734274449e-03
 	 3.65034794936327955383603693917394e-01 1.74418264943838295655265113737187e-02 1.57487631404059475435930348652391e-03
 	 3.65034794936327955383603693917394e-01 6.17523378569288183825847227126360e-01 1.57487631404059475435930348652391e-03
 	 1.74418264943838295655265113737187e-02 3.65034794936327955383603693917394e-01 1.57487631404059475435930348652391e-03
 	 1.74418264943838295655265113737187e-02 6.17523378569288183825847227126360e-01 1.57487631404059475435930348652391e-03
 	 6.17523378569288183825847227126360e-01 3.65034794936327955383603693917394e-01 1.57487631404059475435930348652391e-03
 	 6.17523378569288183825847227126360e-01 1.74418264943838295655265113737187e-02 1.57487631404059475435930348652391e-03
 	 2.57156635550253476196758128935471e-01 8.61981702781003389368663647474023e-02 3.12593497656047953486835311309733e-03
 	 2.57156635550253476196758128935471e-01 6.56645194171646240377526737574954e-01 3.12593497656047953486835311309733e-03
 	 8.61981702781003389368663647474023e-02 2.57156635550253476196758128935471e-01 3.12593497656047953486835311309733e-03
 	 8.61981702781003389368663647474023e-02 6.56645194171646240377526737574954e-01 3.12593497656047953486835311309733e-03
 	 6.56645194171646240377526737574954e-01 2.57156635550253476196758128935471e-01 3.12593497656047953486835311309733e-03
 	 6.56645194171646240377526737574954e-01 8.61981702781003389368663647474023e-02 3.12593497656047953486835311309733e-03
 	 1.24181611934111021944282526874304e-01 3.41126780083469841389764987127364e-03 4.74652661273614420202326957820560e-04
 	 1.24181611934111021944282526874304e-01 8.72407120265054292218565024086274e-01 4.74652661273614420202326957820560e-04
 	 3.41126780083469841389764987127364e-03 1.24181611934111021944282526874304e-01 4.74652661273614420202326957820560e-04
 	 3.41126780083469841389764987127364e-03 8.72407120265054292218565024086274e-01 4.74652661273614420202326957820560e-04
 	 8.72407120265054292218565024086274e-01 1.24181611934111021944282526874304e-01 4.74652661273614420202326957820560e-04
 	 8.72407120265054292218565024086274e-01 3.41126780083469841389764987127364e-03 4.74652661273614420202326957820560e-04
 	 1.71650727809369157972341213280743e-01 4.45555167117895126183135801056778e-02 2.01562604214640178276751747432627e-03
 	 1.71650727809369157972341213280743e-01 7.83793755478841336348239110520808e-01 2.01562604214640178276751747432627e-03
 	 4.45555167117895126183135801056778e-02 1.71650727809369157972341213280743e-01 2.01562604214640178276751747432627e-03
 	 4.45555167117895126183135801056778e-02 7.83793755478841336348239110520808e-01 2.01562604214640178276751747432627e-03
 	 7.83793755478841336348239110520808e-01 1.71650727809369157972341213280743e-01 2.01562604214640178276751747432627e-03
 	 7.83793755478841336348239110520808e-01 4.45555167117895126183135801056778e-02 2.01562604214640178276751747432627e-03
 	 3.97723109198285573739894971367903e-01 1.22097548884562687177002260341396e-01 4.08610877411519878010803807910634e-03
 	 3.97723109198285573739894971367903e-01 4.80179341917151725205314960476244e-01 4.08610877411519878010803807910634e-03
 	 1.22097548884562687177002260341396e-01 3.97723109198285573739894971367903e-01 4.08610877411519878010803807910634e-03
 	 1.22097548884562687177002260341396e-01 4.80179341917151725205314960476244e-01 4.08610877411519878010803807910634e-03
 	 4.80179341917151725205314960476244e-01 3.97723109198285573739894971367903e-01 4.08610877411519878010803807910634e-03
 	 4.80179341917151725205314960476244e-01 1.22097548884562687177002260341396e-01 4.08610877411519878010803807910634e-03
 	 2.57896645669856483529258639464388e-01 1.95710371236428148922215086713550e-01 4.47932951436091821711960037077915e-03
 	 2.57896645669856483529258639464388e-01 5.46392983093715312037375042564236e-01 4.47932951436091821711960037077915e-03
 	 1.95710371236428148922215086713550e-01 2.57896645669856483529258639464388e-01 4.47932951436091821711960037077915e-03
 	 1.95710371236428148922215086713550e-01 5.46392983093715312037375042564236e-01 4.47932951436091821711960037077915e-03
 	 5.46392983093715312037375042564236e-01 2.57896645669856483529258639464388e-01 4.47932951436091821711960037077915e-03
 	 5.46392983093715312037375042564236e-01 1.95710371236428148922215086713550e-01 4.47932951436091821711960037077915e-03
 	 1.44150074481193601894091216308880e-01 1.83113919798339880307125326908135e-02 1.23104937074616088699130500572210e-03
 	 1.44150074481193601894091216308880e-01 8.37538533538972340686257211928023e-01 1.23104937074616088699130500572210e-03
 	 1.83113919798339880307125326908135e-02 1.44150074481193601894091216308880e-01 1.23104937074616088699130500572210e-03
 	 1.83113919798339880307125326908135e-02 8.37538533538972340686257211928023e-01 1.23104937074616088699130500572210e-03
 	 8.37538533538972340686257211928023e-01 1.44150074481193601894091216308880e-01 1.23104937074616088699130500572210e-03
 	 8.37538533538972340686257211928023e-01 1.83113919798339880307125326908135e-02 1.23104937074616088699130500572210e-03
 	 4.12259561001791008383321468500071e-01 3.26225803520382127975718589141252e-03 7.10646460660964017670704340190468e-04
 	 4.12259561001791008383321468500071e-01 5.84478180963005189418879581353394e-01 7.10646460660964017670704340190468e-04
 	 3.26225803520382127975718589141252e-03 4.12259561001791008383321468500071e-01 7.10646460660964017670704340190468e-04
 	 3.26225803520382127975718589141252e-03 5.84478180963005189418879581353394e-01 7.10646460660964017670704340190468e-04
 	 5.84478180963005189418879581353394e-01 4.12259561001791008383321468500071e-01 7.10646460660964017670704340190468e-04
 	 5.84478180963005189418879581353394e-01 3.26225803520382127975718589141252e-03 7.10646460660964017670704340190468e-04
 	 2.52428464791436324432538640394341e-01 3.47544150731571212936676928961788e-03 6.52578247959340355596746796607022e-04
 	 2.52428464791436324432538640394341e-01 7.44096093701247962570732852327637e-01 6.52578247959340355596746796607022e-04
 	 3.47544150731571212936676928961788e-03 2.52428464791436324432538640394341e-01 6.52578247959340355596746796607022e-04
 	 3.47544150731571212936676928961788e-03 7.44096093701247962570732852327637e-01 6.52578247959340355596746796607022e-04
 	 7.44096093701247962570732852327637e-01 2.52428464791436324432538640394341e-01 6.52578247959340355596746796607022e-04
 	 7.44096093701247962570732852327637e-01 3.47544150731571212936676928961788e-03 6.52578247959340355596746796607022e-04
 	 3.29366927485774507733395921604824e-01 3.53879008258183198887270037857888e-03 7.22954763894363607729109943988988e-04
 	 3.29366927485774507733395921604824e-01 6.67094282431643703645818277436774e-01 7.22954763894363607729109943988988e-04
 	 3.53879008258183198887270037857888e-03 3.29366927485774507733395921604824e-01 7.22954763894363607729109943988988e-04
 	 3.53879008258183198887270037857888e-03 6.67094282431643703645818277436774e-01 7.22954763894363607729109943988988e-04
 	 6.67094282431643703645818277436774e-01 3.29366927485774507733395921604824e-01 7.22954763894363607729109943988988e-04
 	 6.67094282431643703645818277436774e-01 3.53879008258183198887270037857888e-03 7.22954763894363607729109943988988e-04
 	 2.09581481700515409594132165693736e-01 1.88449390557523001332729251089404e-02 1.46729752903976013583831061737328e-03
 	 2.09581481700515409594132165693736e-01 7.71573579243732265986466245522024e-01 1.46729752903976013583831061737328e-03
 	 1.88449390557523001332729251089404e-02 2.09581481700515409594132165693736e-01 1.46729752903976013583831061737328e-03
 	 1.88449390557523001332729251089404e-02 7.71573579243732265986466245522024e-01 1.46729752903976013583831061737328e-03
 	 7.71573579243732265986466245522024e-01 2.09581481700515409594132165693736e-01 1.46729752903976013583831061737328e-03
 	 7.71573579243732265986466245522024e-01 1.88449390557523001332729251089404e-02 1.46729752903976013583831061737328e-03
 	 1.83640169446232209837788218464993e-01 3.63810210869633648272936099488106e-03 5.98229502634915494968526061825287e-04
 	 1.83640169446232209837788218464993e-01 8.12721728445071511792718865763163e-01 5.98229502634915494968526061825287e-04
 	 3.63810210869633648272936099488106e-03 1.83640169446232209837788218464993e-01 5.98229502634915494968526061825287e-04
 	 3.63810210869633648272936099488106e-03 8.12721728445071511792718865763163e-01 5.98229502634915494968526061825287e-04
 	 8.12721728445071511792718865763163e-01 1.83640169446232209837788218464993e-01 5.98229502634915494968526061825287e-04
 	 8.12721728445071511792718865763163e-01 3.63810210869633648272936099488106e-03 5.98229502634915494968526061825287e-04
 	 2.41696232469337524140229334079777e-01 4.57532869613174186795845344022382e-02 2.43675220996146524310432823767769e-03
 	 2.41696232469337524140229334079777e-01 7.12550480569345112691337362775812e-01 2.43675220996146524310432823767769e-03
 	 4.57532869613174186795845344022382e-02 2.41696232469337524140229334079777e-01 2.43675220996146524310432823767769e-03
 	 4.57532869613174186795845344022382e-02 7.12550480569345112691337362775812e-01 2.43675220996146524310432823767769e-03
 	 7.12550480569345112691337362775812e-01 2.41696232469337524140229334079777e-01 2.43675220996146524310432823767769e-03
 	 7.12550480569345112691337362775812e-01 4.57532869613174186795845344022382e-02 2.43675220996146524310432823767769e-03
 	 ];
 
 	 case  38 

 	 % ALG. DEG.:   38
 	 % PTS CARD.:  267
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.8e-15  

 	 xyw=[
 	 4.59072136031764554964240687695565e-01 4.59072136031764554964240687695565e-01 1.58198222014196152387932592375819e-03
 	 4.59072136031764554964240687695565e-01 8.18557279364708900715186246088706e-02 1.58198222014196152387932592375819e-03
 	 8.18557279364708900715186246088706e-02 4.59072136031764554964240687695565e-01 1.58198222014196152387932592375819e-03
 	 3.93268006255360069722826210636413e-01 3.93268006255360069722826210636413e-01 2.93082910955432202407267006094571e-03
 	 3.93268006255360069722826210636413e-01 2.13463987489279860554347578727175e-01 2.93082910955432202407267006094571e-03
 	 2.13463987489279860554347578727175e-01 3.93268006255360069722826210636413e-01 2.93082910955432202407267006094571e-03
 	 4.68182589206935673153964216908207e-01 4.68182589206935673153964216908207e-01 1.96510845185057228187708311395454e-03
 	 4.68182589206935673153964216908207e-01 6.36348215861286536920715661835857e-02 1.96510845185057228187708311395454e-03
 	 6.36348215861286536920715661835857e-02 4.68182589206935673153964216908207e-01 1.96510845185057228187708311395454e-03
 	 1.75045040462672892023210380330056e-02 1.75045040462672892023210380330056e-02 3.49734883664800603325639727358976e-04
 	 1.75045040462672892023210380330056e-02 9.64990991907465400778676212212304e-01 3.49734883664800603325639727358976e-04
 	 9.64990991907465400778676212212304e-01 1.75045040462672892023210380330056e-02 3.49734883664800603325639727358976e-04
 	 1.45480114652860703650105733686360e-01 1.45480114652860703650105733686360e-01 2.60121125552193084573548986782043e-03
 	 1.45480114652860703650105733686360e-01 7.09039770694278592699788532627281e-01 2.60121125552193084573548986782043e-03
 	 7.09039770694278592699788532627281e-01 1.45480114652860703650105733686360e-01 2.60121125552193084573548986782043e-03
 	 3.04717426636049414090390285991816e-03 3.04717426636049414090390285991816e-03 6.20233313265518054670927261540214e-05
 	 3.04717426636049414090390285991816e-03 9.93905651467279049882108665769920e-01 6.20233313265518054670927261540214e-05
 	 9.93905651467279049882108665769920e-01 3.04717426636049414090390285991816e-03 6.20233313265518054670927261540214e-05
 	 5.87361601120219983807047015034186e-02 5.87361601120219983807047015034186e-02 1.25319110825724373478595730091456e-03
 	 5.87361601120219983807047015034186e-02 8.82527679775956030994166212622076e-01 1.25319110825724373478595730091456e-03
 	 8.82527679775956030994166212622076e-01 5.87361601120219983807047015034186e-02 1.25319110825724373478595730091456e-03
 	 3.73835575017464616376372532613459e-02 3.73835575017464616376372532613459e-02 8.53775101957864220036942271008229e-04
 	 3.73835575017464616376372532613459e-02 9.25232884996507021213574262219481e-01 8.53775101957864220036942271008229e-04
 	 9.25232884996507021213574262219481e-01 3.73835575017464616376372532613459e-02 8.53775101957864220036942271008229e-04
 	 2.85504778291264027512141865372541e-01 2.85504778291264027512141865372541e-01 4.49280475940249442862173268053994e-03
 	 2.85504778291264027512141865372541e-01 4.28990443417471944975716269254917e-01 4.49280475940249442862173268053994e-03
 	 4.28990443417471944975716269254917e-01 2.85504778291264027512141865372541e-01 4.49280475940249442862173268053994e-03
 	 4.20333501770014217324700211975141e-01 4.20333501770014217324700211975141e-01 3.96885213756022810910328857403329e-03
 	 4.20333501770014217324700211975141e-01 1.59332996459971565350599576049717e-01 3.96885213756022810910328857403329e-03
 	 1.59332996459971565350599576049717e-01 4.20333501770014217324700211975141e-01 3.96885213756022810910328857403329e-03
 	 2.07689421653862921202104985241021e-01 2.07689421653862921202104985241021e-01 3.87427659633373874803474734562769e-03
 	 2.07689421653862921202104985241021e-01 5.84621156692274102084638798260130e-01 3.87427659633373874803474734562769e-03
 	 5.84621156692274102084638798260130e-01 2.07689421653862921202104985241021e-01 3.87427659633373874803474734562769e-03
 	 4.92196272955310765162550978857325e-01 4.92196272955310765162550978857325e-01 1.51794877726721681894528348522044e-03
 	 4.92196272955310765162550978857325e-01 1.56074540893784696748980422853492e-02 1.51794877726721681894528348522044e-03
 	 1.56074540893784696748980422853492e-02 4.92196272955310765162550978857325e-01 1.51794877726721681894528348522044e-03
 	 3.56565593983026118962698092218488e-01 3.56565593983026118962698092218488e-01 4.98799680519128318945121236538398e-03
 	 3.56565593983026118962698092218488e-01 2.86868812033947762074603815563023e-01 4.98799680519128318945121236538398e-03
 	 2.86868812033947762074603815563023e-01 3.56565593983026118962698092218488e-01 4.98799680519128318945121236538398e-03
 	 2.83765514701740717562472582358168e-01 5.22971139020114439421860197398928e-02 1.24250261557132582988793867428967e-03
 	 2.83765514701740717562472582358168e-01 6.63937371396247866250917013530852e-01 1.24250261557132582988793867428967e-03
 	 5.22971139020114439421860197398928e-02 2.83765514701740717562472582358168e-01 1.24250261557132582988793867428967e-03
 	 5.22971139020114439421860197398928e-02 6.63937371396247866250917013530852e-01 1.24250261557132582988793867428967e-03
 	 6.63937371396247866250917013530852e-01 2.83765514701740717562472582358168e-01 1.24250261557132582988793867428967e-03
 	 6.63937371396247866250917013530852e-01 5.22971139020114439421860197398928e-02 1.24250261557132582988793867428967e-03
 	 1.28516564969693936060224359607673e-01 9.90797627018412813137970829302503e-02 1.84824458035341416921315538246517e-03
 	 1.28516564969693936060224359607673e-01 7.72403672328464740992615134018706e-01 1.84824458035341416921315538246517e-03
 	 9.90797627018412813137970829302503e-02 1.28516564969693936060224359607673e-01 1.84824458035341416921315538246517e-03
 	 9.90797627018412813137970829302503e-02 7.72403672328464740992615134018706e-01 1.84824458035341416921315538246517e-03
 	 7.72403672328464740992615134018706e-01 1.28516564969693936060224359607673e-01 1.84824458035341416921315538246517e-03
 	 7.72403672328464740992615134018706e-01 9.90797627018412813137970829302503e-02 1.84824458035341416921315538246517e-03
 	 4.13075041428614328498092334029934e-02 2.06440514930518719677321470840070e-03 1.73852199496849705705886490747503e-04
 	 4.13075041428614328498092334029934e-02 9.56628090707833389494396669761045e-01 1.73852199496849705705886490747503e-04
 	 2.06440514930518719677321470840070e-03 4.13075041428614328498092334029934e-02 1.73852199496849705705886490747503e-04
 	 2.06440514930518719677321470840070e-03 9.56628090707833389494396669761045e-01 1.73852199496849705705886490747503e-04
 	 9.56628090707833389494396669761045e-01 4.13075041428614328498092334029934e-02 1.73852199496849705705886490747503e-04
 	 9.56628090707833389494396669761045e-01 2.06440514930518719677321470840070e-03 1.73852199496849705705886490747503e-04
 	 8.92719800534144680703718677250436e-02 3.67301756493483427812307695603522e-02 1.03691343697038932704368452419885e-03
 	 8.92719800534144680703718677250436e-02 8.73997844297237147515033939271234e-01 1.03691343697038932704368452419885e-03
 	 3.67301756493483427812307695603522e-02 8.92719800534144680703718677250436e-02 1.03691343697038932704368452419885e-03
 	 3.67301756493483427812307695603522e-02 8.73997844297237147515033939271234e-01 1.03691343697038932704368452419885e-03
 	 8.73997844297237147515033939271234e-01 8.92719800534144680703718677250436e-02 1.03691343697038932704368452419885e-03
 	 8.73997844297237147515033939271234e-01 3.67301756493483427812307695603522e-02 1.03691343697038932704368452419885e-03
 	 3.37205292317987237460386040766025e-01 2.25945824487785718037713422745583e-01 3.68552054500562598776669531730477e-03
 	 3.37205292317987237460386040766025e-01 4.36848883194227044501900536488392e-01 3.68552054500562598776669531730477e-03
 	 2.25945824487785718037713422745583e-01 3.37205292317987237460386040766025e-01 3.68552054500562598776669531730477e-03
 	 2.25945824487785718037713422745583e-01 4.36848883194227044501900536488392e-01 3.68552054500562598776669531730477e-03
 	 4.36848883194227044501900536488392e-01 3.37205292317987237460386040766025e-01 3.68552054500562598776669531730477e-03
 	 4.36848883194227044501900536488392e-01 2.25945824487785718037713422745583e-01 3.68552054500562598776669531730477e-03
 	 2.73851374124178703617360497446498e-01 3.27011819900537709093768512502720e-02 1.56269905721992657249286295950697e-03
 	 2.73851374124178703617360497446498e-01 6.93447443885767511595474843488773e-01 1.56269905721992657249286295950697e-03
 	 3.27011819900537709093768512502720e-02 2.73851374124178703617360497446498e-01 1.56269905721992657249286295950697e-03
 	 3.27011819900537709093768512502720e-02 6.93447443885767511595474843488773e-01 1.56269905721992657249286295950697e-03
 	 6.93447443885767511595474843488773e-01 2.73851374124178703617360497446498e-01 1.56269905721992657249286295950697e-03
 	 6.93447443885767511595474843488773e-01 3.27011819900537709093768512502720e-02 1.56269905721992657249286295950697e-03
 	 3.99162626294194411435967140278080e-02 1.30695090443300153404404539969619e-02 4.53088107226028440240039873998512e-04
 	 3.99162626294194411435967140278080e-02 9.47014228326250595557667111279443e-01 4.53088107226028440240039873998512e-04
 	 1.30695090443300153404404539969619e-02 3.99162626294194411435967140278080e-02 4.53088107226028440240039873998512e-04
 	 1.30695090443300153404404539969619e-02 9.47014228326250595557667111279443e-01 4.53088107226028440240039873998512e-04
 	 9.47014228326250595557667111279443e-01 3.99162626294194411435967140278080e-02 4.53088107226028440240039873998512e-04
 	 9.47014228326250595557667111279443e-01 1.30695090443300153404404539969619e-02 4.53088107226028440240039873998512e-04
 	 3.08106832759384330344687441538554e-01 7.37176145710159158586094463316840e-02 2.49781388487334667439232482877287e-03
 	 3.08106832759384330344687441538554e-01 6.18175552669599781552278727758676e-01 2.49781388487334667439232482877287e-03
 	 7.37176145710159158586094463316840e-02 3.08106832759384330344687441538554e-01 2.49781388487334667439232482877287e-03
 	 7.37176145710159158586094463316840e-02 6.18175552669599781552278727758676e-01 2.49781388487334667439232482877287e-03
 	 6.18175552669599781552278727758676e-01 3.08106832759384330344687441538554e-01 2.49781388487334667439232482877287e-03
 	 6.18175552669599781552278727758676e-01 7.37176145710159158586094463316840e-02 2.49781388487334667439232482877287e-03
 	 2.19624713138435623260846796256374e-01 2.70388221454352780867558259103589e-03 4.62834099424956190577118420037550e-04
 	 2.19624713138435623260846796256374e-01 7.77671404647020780842581189062912e-01 4.62834099424956190577118420037550e-04
 	 2.70388221454352780867558259103589e-03 2.19624713138435623260846796256374e-01 4.62834099424956190577118420037550e-04
 	 2.70388221454352780867558259103589e-03 7.77671404647020780842581189062912e-01 4.62834099424956190577118420037550e-04
 	 7.77671404647020780842581189062912e-01 2.19624713138435623260846796256374e-01 4.62834099424956190577118420037550e-04
 	 7.77671404647020780842581189062912e-01 2.70388221454352780867558259103589e-03 4.62834099424956190577118420037550e-04
 	 2.73464607114281443855929865094367e-01 2.19158263446028789278585691135959e-01 4.14108323134647609425895709023280e-03
 	 2.73464607114281443855929865094367e-01 5.07377129439689822376635675027501e-01 4.14108323134647609425895709023280e-03
 	 2.19158263446028789278585691135959e-01 2.73464607114281443855929865094367e-01 4.14108323134647609425895709023280e-03
 	 2.19158263446028789278585691135959e-01 5.07377129439689822376635675027501e-01 4.14108323134647609425895709023280e-03
 	 5.07377129439689822376635675027501e-01 2.73464607114281443855929865094367e-01 4.14108323134647609425895709023280e-03
 	 5.07377129439689822376635675027501e-01 2.19158263446028789278585691135959e-01 4.14108323134647609425895709023280e-03
 	 6.86830028555526772571226956642931e-02 2.07228118815140395503338055505083e-02 7.68421232903655489036853776241287e-04
 	 6.86830028555526772571226956642931e-02 9.10594185262933231150839219480986e-01 7.68421232903655489036853776241287e-04
 	 2.07228118815140395503338055505083e-02 6.86830028555526772571226956642931e-02 7.68421232903655489036853776241287e-04
 	 2.07228118815140395503338055505083e-02 9.10594185262933231150839219480986e-01 7.68421232903655489036853776241287e-04
 	 9.10594185262933231150839219480986e-01 6.86830028555526772571226956642931e-02 7.68421232903655489036853776241287e-04
 	 9.10594185262933231150839219480986e-01 2.07228118815140395503338055505083e-02 7.68421232903655489036853776241287e-04
 	 1.83013599840179452815647209718009e-01 1.00621720892076091380396007934905e-01 2.61137036940718670827155101221706e-03
 	 1.83013599840179452815647209718009e-01 7.16364679267744497437320205790456e-01 2.61137036940718670827155101221706e-03
 	 1.00621720892076091380396007934905e-01 1.83013599840179452815647209718009e-01 2.61137036940718670827155101221706e-03
 	 1.00621720892076091380396007934905e-01 7.16364679267744497437320205790456e-01 2.61137036940718670827155101221706e-03
 	 7.16364679267744497437320205790456e-01 1.83013599840179452815647209718009e-01 2.61137036940718670827155101221706e-03
 	 7.16364679267744497437320205790456e-01 1.00621720892076091380396007934905e-01 2.61137036940718670827155101221706e-03
 	 2.28799483229925271210447590419790e-01 6.94898178335092570057085481494141e-02 2.35919639420995507980705063744153e-03
 	 2.28799483229925271210447590419790e-01 7.01710698936565457906056053616339e-01 2.35919639420995507980705063744153e-03
 	 6.94898178335092570057085481494141e-02 2.28799483229925271210447590419790e-01 2.35919639420995507980705063744153e-03
 	 6.94898178335092570057085481494141e-02 7.01710698936565457906056053616339e-01 2.35919639420995507980705063744153e-03
 	 7.01710698936565457906056053616339e-01 2.28799483229925271210447590419790e-01 2.35919639420995507980705063744153e-03
 	 7.01710698936565457906056053616339e-01 6.94898178335092570057085481494141e-02 2.35919639420995507980705063744153e-03
 	 1.01882711486939128708861801442254e-01 6.83773554225138580076048810951761e-02 1.80105850247642843356410402577694e-03
 	 1.01882711486939128708861801442254e-01 8.29739933090546943894594278390286e-01 1.80105850247642843356410402577694e-03
 	 6.83773554225138580076048810951761e-02 1.01882711486939128708861801442254e-01 1.80105850247642843356410402577694e-03
 	 6.83773554225138580076048810951761e-02 8.29739933090546943894594278390286e-01 1.80105850247642843356410402577694e-03
 	 8.29739933090546943894594278390286e-01 1.01882711486939128708861801442254e-01 1.80105850247642843356410402577694e-03
 	 8.29739933090546943894594278390286e-01 6.83773554225138580076048810951761e-02 1.80105850247642843356410402577694e-03
 	 2.43563673395817054112555410938512e-01 1.43204413633164825275789766578782e-02 1.18514523369667602176180665196625e-03
 	 2.43563673395817054112555410938512e-01 7.42115885240866468564036040334031e-01 1.18514523369667602176180665196625e-03
 	 1.43204413633164825275789766578782e-02 2.43563673395817054112555410938512e-01 1.18514523369667602176180665196625e-03
 	 1.43204413633164825275789766578782e-02 7.42115885240866468564036040334031e-01 1.18514523369667602176180665196625e-03
 	 7.42115885240866468564036040334031e-01 2.43563673395817054112555410938512e-01 1.18514523369667602176180665196625e-03
 	 7.42115885240866468564036040334031e-01 1.43204413633164825275789766578782e-02 1.18514523369667602176180665196625e-03
 	 2.05887716517901192547768118856766e-01 3.89678567422942698228460756126879e-02 1.80524491668789866839761604211390e-03
 	 2.05887716517901192547768118856766e-01 7.55144426739804530690491901623318e-01 1.80524491668789866839761604211390e-03
 	 3.89678567422942698228460756126879e-02 2.05887716517901192547768118856766e-01 1.80524491668789866839761604211390e-03
 	 3.89678567422942698228460756126879e-02 7.55144426739804530690491901623318e-01 1.80524491668789866839761604211390e-03
 	 7.55144426739804530690491901623318e-01 2.05887716517901192547768118856766e-01 1.80524491668789866839761604211390e-03
 	 7.55144426739804530690491901623318e-01 3.89678567422942698228460756126879e-02 1.80524491668789866839761604211390e-03
 	 2.01869508887603077429417908206233e-01 1.49396461917944173292127629792958e-01 3.27022726537275166755480704239289e-03
 	 2.01869508887603077429417908206233e-01 6.48734029194452777034030077629723e-01 3.27022726537275166755480704239289e-03
 	 1.49396461917944173292127629792958e-01 2.01869508887603077429417908206233e-01 3.27022726537275166755480704239289e-03
 	 1.49396461917944173292127629792958e-01 6.48734029194452777034030077629723e-01 3.27022726537275166755480704239289e-03
 	 6.48734029194452777034030077629723e-01 2.01869508887603077429417908206233e-01 3.27022726537275166755480704239289e-03
 	 6.48734029194452777034030077629723e-01 1.49396461917944173292127629792958e-01 3.27022726537275166755480704239289e-03
 	 1.59116021010545172220673748597619e-01 6.22282118189532995611301657845615e-02 2.03961074015630156042178100506135e-03
 	 1.59116021010545172220673748597619e-01 7.78655767170501555973771701246733e-01 2.03961074015630156042178100506135e-03
 	 6.22282118189532995611301657845615e-02 1.59116021010545172220673748597619e-01 2.03961074015630156042178100506135e-03
 	 6.22282118189532995611301657845615e-02 7.78655767170501555973771701246733e-01 2.03961074015630156042178100506135e-03
 	 7.78655767170501555973771701246733e-01 1.59116021010545172220673748597619e-01 2.03961074015630156042178100506135e-03
 	 7.78655767170501555973771701246733e-01 6.22282118189532995611301657845615e-02 2.03961074015630156042178100506135e-03
 	 1.77947635855591812514830962754786e-01 1.76192414704859877383480437629260e-02 1.16281945905291768904310512056099e-03
 	 1.77947635855591812514830962754786e-01 8.04433122673922196277374041528674e-01 1.16281945905291768904310512056099e-03
 	 1.76192414704859877383480437629260e-02 1.77947635855591812514830962754786e-01 1.16281945905291768904310512056099e-03
 	 1.76192414704859877383480437629260e-02 8.04433122673922196277374041528674e-01 1.16281945905291768904310512056099e-03
 	 8.04433122673922196277374041528674e-01 1.77947635855591812514830962754786e-01 1.16281945905291768904310512056099e-03
 	 8.04433122673922196277374041528674e-01 1.76192414704859877383480437629260e-02 1.16281945905291768904310512056099e-03
 	 1.62036747949692083725636848612339e-01 3.94772766521245526555317084671515e-03 5.02872011041631604248702824833117e-04
 	 1.62036747949692083725636848612339e-01 8.34015524385095519122046425763983e-01 5.02872011041631604248702824833117e-04
 	 3.94772766521245526555317084671515e-03 1.62036747949692083725636848612339e-01 5.02872011041631604248702824833117e-04
 	 3.94772766521245526555317084671515e-03 8.34015524385095519122046425763983e-01 5.02872011041631604248702824833117e-04
 	 8.34015524385095519122046425763983e-01 1.62036747949692083725636848612339e-01 5.02872011041631604248702824833117e-04
 	 8.34015524385095519122046425763983e-01 3.94772766521245526555317084671515e-03 5.02872011041631604248702824833117e-04
 	 2.91854983858524597017947144195205e-01 2.93117988617291056266389581708154e-03 5.71580885705873253423148216967320e-04
 	 2.91854983858524597017947144195205e-01 7.05213836255302539690603680355707e-01 5.71580885705873253423148216967320e-04
 	 2.93117988617291056266389581708154e-03 2.91854983858524597017947144195205e-01 5.71580885705873253423148216967320e-04
 	 2.93117988617291056266389581708154e-03 7.05213836255302539690603680355707e-01 5.71580885705873253423148216967320e-04
 	 7.05213836255302539690603680355707e-01 2.91854983858524597017947144195205e-01 5.71580885705873253423148216967320e-04
 	 7.05213836255302539690603680355707e-01 2.93117988617291056266389581708154e-03 5.71580885705873253423148216967320e-04
 	 3.71878691749589151971377987138112e-01 2.77798098243856299988108204956916e-03 5.94230661254127579505579515029012e-04
 	 3.71878691749589151971377987138112e-01 6.25343327267972370897552991664270e-01 5.94230661254127579505579515029012e-04
 	 2.77798098243856299988108204956916e-03 3.71878691749589151971377987138112e-01 5.94230661254127579505579515029012e-04
 	 2.77798098243856299988108204956916e-03 6.25343327267972370897552991664270e-01 5.94230661254127579505579515029012e-04
 	 6.25343327267972370897552991664270e-01 3.71878691749589151971377987138112e-01 5.94230661254127579505579515029012e-04
 	 6.25343327267972370897552991664270e-01 2.77798098243856299988108204956916e-03 5.94230661254127579505579515029012e-04
 	 1.34969372652465280371103517609299e-01 3.43221858358502412977841800056922e-02 1.45260947260546073069031880464763e-03
 	 1.34969372652465280371103517609299e-01 8.30708441511684547720051341457292e-01 1.45260947260546073069031880464763e-03
 	 3.43221858358502412977841800056922e-02 1.34969372652465280371103517609299e-01 1.45260947260546073069031880464763e-03
 	 3.43221858358502412977841800056922e-02 8.30708441511684547720051341457292e-01 1.45260947260546073069031880464763e-03
 	 8.30708441511684547720051341457292e-01 1.34969372652465280371103517609299e-01 1.45260947260546073069031880464763e-03
 	 8.30708441511684547720051341457292e-01 3.43221858358502412977841800056922e-02 1.45260947260546073069031880464763e-03
 	 2.52453429906421944473038365686079e-01 1.08724039341924899604308052403212e-01 3.16335759879328654378682905701226e-03
 	 2.52453429906421944473038365686079e-01 6.38822530751653183678229197539622e-01 3.16335759879328654378682905701226e-03
 	 1.08724039341924899604308052403212e-01 2.52453429906421944473038365686079e-01 3.16335759879328654378682905701226e-03
 	 1.08724039341924899604308052403212e-01 6.38822530751653183678229197539622e-01 3.16335759879328654378682905701226e-03
 	 6.38822530751653183678229197539622e-01 2.52453429906421944473038365686079e-01 3.16335759879328654378682905701226e-03
 	 6.38822530751653183678229197539622e-01 1.08724039341924899604308052403212e-01 3.16335759879328654378682905701226e-03
 	 3.24235164108304496632939617484226e-01 1.49491079080454249833342927900048e-02 1.36284311036006036688128517653240e-03
 	 3.24235164108304496632939617484226e-01 6.60815727983650069710108709841734e-01 1.36284311036006036688128517653240e-03
 	 1.49491079080454249833342927900048e-02 3.24235164108304496632939617484226e-01 1.36284311036006036688128517653240e-03
 	 1.49491079080454249833342927900048e-02 6.60815727983650069710108709841734e-01 1.36284311036006036688128517653240e-03
 	 6.60815727983650069710108709841734e-01 3.24235164108304496632939617484226e-01 1.36284311036006036688128517653240e-03
 	 6.60815727983650069710108709841734e-01 1.49491079080454249833342927900048e-02 1.36284311036006036688128517653240e-03
 	 4.37416190646625679949721643424709e-01 3.73240771592634676401267768142134e-02 2.26079579990258157720650622479752e-03
 	 4.37416190646625679949721643424709e-01 5.25259732194110928737984522740589e-01 2.26079579990258157720650622479752e-03
 	 3.73240771592634676401267768142134e-02 4.37416190646625679949721643424709e-01 2.26079579990258157720650622479752e-03
 	 3.73240771592634676401267768142134e-02 5.25259732194110928737984522740589e-01 2.26079579990258157720650622479752e-03
 	 5.25259732194110928737984522740589e-01 4.37416190646625679949721643424709e-01 2.26079579990258157720650622479752e-03
 	 5.25259732194110928737984522740589e-01 3.73240771592634676401267768142134e-02 2.26079579990258157720650622479752e-03
 	 4.55998803661209317628077997142100e-01 2.96327193163695200642249183431431e-03 6.44587138714711118010758372776081e-04
 	 4.55998803661209317628077997142100e-01 5.41037924407153814065907226904528e-01 6.44587138714711118010758372776081e-04
 	 2.96327193163695200642249183431431e-03 4.55998803661209317628077997142100e-01 6.44587138714711118010758372776081e-04
 	 2.96327193163695200642249183431431e-03 5.41037924407153814065907226904528e-01 6.44587138714711118010758372776081e-04
 	 5.41037924407153814065907226904528e-01 4.55998803661209317628077997142100e-01 6.44587138714711118010758372776081e-04
 	 5.41037924407153814065907226904528e-01 2.96327193163695200642249183431431e-03 6.44587138714711118010758372776081e-04
 	 7.54872857005682990072514826351835e-02 4.20297816077350953195557181629738e-03 4.08341959086390329358023931760613e-04
 	 7.54872857005682990072514826351835e-02 9.20309736138658185389260779629694e-01 4.08341959086390329358023931760613e-04
 	 4.20297816077350953195557181629738e-03 7.54872857005682990072514826351835e-02 4.08341959086390329358023931760613e-04
 	 4.20297816077350953195557181629738e-03 9.20309736138658185389260779629694e-01 4.08341959086390329358023931760613e-04
 	 9.20309736138658185389260779629694e-01 7.54872857005682990072514826351835e-02 4.08341959086390329358023931760613e-04
 	 9.20309736138658185389260779629694e-01 4.20297816077350953195557181629738e-03 4.08341959086390329358023931760613e-04
 	 3.26054126652946585362968789922888e-01 1.14274187380454431139931159577827e-01 3.47388966177611087718379856426054e-03
 	 3.26054126652946585362968789922888e-01 5.59671685966598886352585395798087e-01 3.47388966177611087718379856426054e-03
 	 1.14274187380454431139931159577827e-01 3.26054126652946585362968789922888e-01 3.47388966177611087718379856426054e-03
 	 1.14274187380454431139931159577827e-01 5.59671685966598886352585395798087e-01 3.47388966177611087718379856426054e-03
 	 5.59671685966598886352585395798087e-01 3.26054126652946585362968789922888e-01 3.47388966177611087718379856426054e-03
 	 5.59671685966598886352585395798087e-01 1.14274187380454431139931159577827e-01 3.47388966177611087718379856426054e-03
 	 4.01199588505488202727633506583516e-01 1.12888085312921521152773607354902e-01 3.54930896974515889055745709868006e-03
 	 4.01199588505488202727633506583516e-01 4.85912326181590303875168501690496e-01 3.54930896974515889055745709868006e-03
 	 1.12888085312921521152773607354902e-01 4.01199588505488202727633506583516e-01 3.54930896974515889055745709868006e-03
 	 1.12888085312921521152773607354902e-01 4.85912326181590303875168501690496e-01 3.54930896974515889055745709868006e-03
 	 4.85912326181590303875168501690496e-01 4.01199588505488202727633506583516e-01 3.54930896974515889055745709868006e-03
 	 4.85912326181590303875168501690496e-01 1.12888085312921521152773607354902e-01 3.54930896974515889055745709868006e-03
 	 2.68760660341264001615968481928576e-01 1.60196677899755890450705919647589e-01 3.84596017428895809581179676683860e-03
 	 2.68760660341264001615968481928576e-01 5.71042661758980107933325598423835e-01 3.84596017428895809581179676683860e-03
 	 1.60196677899755890450705919647589e-01 2.68760660341264001615968481928576e-01 3.84596017428895809581179676683860e-03
 	 1.60196677899755890450705919647589e-01 5.71042661758980107933325598423835e-01 3.84596017428895809581179676683860e-03
 	 5.71042661758980107933325598423835e-01 2.68760660341264001615968481928576e-01 3.84596017428895809581179676683860e-03
 	 5.71042661758980107933325598423835e-01 1.60196677899755890450705919647589e-01 3.84596017428895809581179676683860e-03
 	 4.06014702573877173108485294505954e-01 1.51551286402894190563639398305895e-02 1.46260950936205245086207948901347e-03
 	 4.06014702573877173108485294505954e-01 5.78830168785833376610128198080929e-01 1.46260950936205245086207948901347e-03
 	 1.51551286402894190563639398305895e-02 4.06014702573877173108485294505954e-01 1.46260950936205245086207948901347e-03
 	 1.51551286402894190563639398305895e-02 5.78830168785833376610128198080929e-01 1.46260950936205245086207948901347e-03
 	 5.78830168785833376610128198080929e-01 4.06014702573877173108485294505954e-01 1.46260950936205245086207948901347e-03
 	 5.78830168785833376610128198080929e-01 1.51551286402894190563639398305895e-02 1.46260950936205245086207948901347e-03
 	 3.83510346834340154487108520697802e-01 7.00421815004378944813367979804752e-02 3.02834849824288633579616458746386e-03
 	 3.83510346834340154487108520697802e-01 5.46447471665221895520403450063895e-01 3.02834849824288633579616458746386e-03
 	 7.00421815004378944813367979804752e-02 3.83510346834340154487108520697802e-01 3.02834849824288633579616458746386e-03
 	 7.00421815004378944813367979804752e-02 5.46447471665221895520403450063895e-01 3.02834849824288633579616458746386e-03
 	 5.46447471665221895520403450063895e-01 3.83510346834340154487108520697802e-01 3.02834849824288633579616458746386e-03
 	 5.46447471665221895520403450063895e-01 7.00421815004378944813367979804752e-02 3.02834849824288633579616458746386e-03
 	 1.64470646369431552913376037849957e-02 3.44298850158080132349835977834118e-03 1.66852816559418681450696619883445e-04
 	 1.64470646369431552913376037849957e-02 9.80109946861476122315082193381386e-01 1.66852816559418681450696619883445e-04
 	 3.44298850158080132349835977834118e-03 1.64470646369431552913376037849957e-02 1.66852816559418681450696619883445e-04
 	 3.44298850158080132349835977834118e-03 9.80109946861476122315082193381386e-01 1.66852816559418681450696619883445e-04
 	 9.80109946861476122315082193381386e-01 1.64470646369431552913376037849957e-02 1.66852816559418681450696619883445e-04
 	 9.80109946861476122315082193381386e-01 3.44298850158080132349835977834118e-03 1.66852816559418681450696619883445e-04
 	 3.54297786162694750000667909262120e-01 3.76676144786773081651887196130701e-02 2.26473446047441642758890623099433e-03
 	 3.54297786162694750000667909262120e-01 6.08034599358627914078567755495897e-01 2.26473446047441642758890623099433e-03
 	 3.76676144786773081651887196130701e-02 3.54297786162694750000667909262120e-01 2.26473446047441642758890623099433e-03
 	 3.76676144786773081651887196130701e-02 6.08034599358627914078567755495897e-01 2.26473446047441642758890623099433e-03
 	 6.08034599358627914078567755495897e-01 3.54297786162694750000667909262120e-01 2.26473446047441642758890623099433e-03
 	 6.08034599358627914078567755495897e-01 3.76676144786773081651887196130701e-02 2.26473446047441642758890623099433e-03
 	 3.41995175798316008997090875709546e-01 1.65998426676715687966279233478417e-01 4.20126870715988726123768515208212e-03
 	 3.41995175798316008997090875709546e-01 4.92006397524968330792205506440951e-01 4.20126870715988726123768515208212e-03
 	 1.65998426676715687966279233478417e-01 3.41995175798316008997090875709546e-01 4.20126870715988726123768515208212e-03
 	 1.65998426676715687966279233478417e-01 4.92006397524968330792205506440951e-01 4.20126870715988726123768515208212e-03
 	 4.92006397524968330792205506440951e-01 3.41995175798316008997090875709546e-01 4.20126870715988726123768515208212e-03
 	 4.92006397524968330792205506440951e-01 1.65998426676715687966279233478417e-01 4.20126870715988726123768515208212e-03
 	 1.15288891079278379980799229542754e-01 1.20325311111651837847613677467962e-02 9.05485926201706186472462078995704e-04
 	 1.15288891079278379980799229542754e-01 8.72678577809556377253841219499009e-01 9.05485926201706186472462078995704e-04
 	 1.20325311111651837847613677467962e-02 1.15288891079278379980799229542754e-01 9.05485926201706186472462078995704e-04
 	 1.20325311111651837847613677467962e-02 8.72678577809556377253841219499009e-01 9.05485926201706186472462078995704e-04
 	 8.72678577809556377253841219499009e-01 1.15288891079278379980799229542754e-01 9.05485926201706186472462078995704e-04
 	 8.72678577809556377253841219499009e-01 1.20325311111651837847613677467962e-02 9.05485926201706186472462078995704e-04
 	 1.16528101812402543058233561623638e-01 2.98221681520129382886308277988974e-04 1.46142831591413282013580676732545e-04
 	 1.16528101812402543058233561623638e-01 8.83173676506077254266813270078273e-01 1.46142831591413282013580676732545e-04
 	 2.98221681520129382886308277988974e-04 1.16528101812402543058233561623638e-01 1.46142831591413282013580676732545e-04
 	 2.98221681520129382886308277988974e-04 8.83173676506077254266813270078273e-01 1.46142831591413282013580676732545e-04
 	 8.83173676506077254266813270078273e-01 1.16528101812402543058233561623638e-01 1.46142831591413282013580676732545e-04
 	 8.83173676506077254266813270078273e-01 2.98221681520129382886308277988974e-04 1.46142831591413282013580676732545e-04
 	 ];
 
 	 case  39 

 	 % ALG. DEG.:   39
 	 % PTS CARD.:  282
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw=[
 	 4.72409482150556669921570573933423e-01 4.72409482150556669921570573933423e-01 1.90023648880032858081434721242431e-03
 	 4.72409482150556669921570573933423e-01 5.51810356988866601568588521331549e-02 1.90023648880032858081434721242431e-03
 	 5.51810356988866601568588521331549e-02 4.72409482150556669921570573933423e-01 1.90023648880032858081434721242431e-03
 	 4.57507968673824261252036649239017e-01 4.57507968673824261252036649239017e-01 2.40451787008430202877140580142168e-03
 	 4.57507968673824261252036649239017e-01 8.49840626523514774959267015219666e-02 2.40451787008430202877140580142168e-03
 	 8.49840626523514774959267015219666e-02 4.57507968673824261252036649239017e-01 2.40451787008430202877140580142168e-03
 	 3.53847291916883299744966961952741e-01 3.53847291916883299744966961952741e-01 4.03949727267366963390227141417199e-03
 	 3.53847291916883299744966961952741e-01 2.92305416166233400510066076094517e-01 4.03949727267366963390227141417199e-03
 	 2.92305416166233400510066076094517e-01 3.53847291916883299744966961952741e-01 4.03949727267366963390227141417199e-03
 	 4.99106149860298997644747487356653e-01 4.99106149860298997644747487356653e-01 4.19238340914585027631444891227375e-04
 	 4.99106149860298997644747487356653e-01 1.78770027940200471050502528669313e-03 4.19238340914585027631444891227375e-04
 	 1.78770027940200471050502528669313e-03 4.99106149860298997644747487356653e-01 4.19238340914585027631444891227375e-04
 	 1.13331658196365314683617953050998e-01 1.13331658196365314683617953050998e-01 1.85446781068809006011444129313759e-03
 	 1.13331658196365314683617953050998e-01 7.73336683607269370632764093898004e-01 1.85446781068809006011444129313759e-03
 	 7.73336683607269370632764093898004e-01 1.13331658196365314683617953050998e-01 1.85446781068809006011444129313759e-03
 	 1.57787047228343108029591235208500e-02 1.57787047228343108029591235208500e-02 3.34303455844673681491424632739040e-04
 	 1.57787047228343108029591235208500e-02 9.68442590554331350638506137329387e-01 3.34303455844673681491424632739040e-04
 	 9.68442590554331350638506137329387e-01 1.57787047228343108029591235208500e-02 3.34303455844673681491424632739040e-04
 	 1.64009184766605586869303579078405e-01 1.64009184766605586869303579078405e-01 2.90176895980177960293611150177640e-03
 	 1.64009184766605586869303579078405e-01 6.71981630466788826261392841843190e-01 2.90176895980177960293611150177640e-03
 	 6.71981630466788826261392841843190e-01 1.64009184766605586869303579078405e-01 2.90176895980177960293611150177640e-03
 	 4.08471560729133986722416693737614e-01 4.08471560729133986722416693737614e-01 3.84960331613813482032337986993298e-03
 	 4.08471560729133986722416693737614e-01 1.83056878541732026555166612524772e-01 3.84960331613813482032337986993298e-03
 	 1.83056878541732026555166612524772e-01 4.08471560729133986722416693737614e-01 3.84960331613813482032337986993298e-03
 	 4.36541655107956616532760563131887e-01 4.36541655107956616532760563131887e-01 3.38825160904275340598146293302761e-03
 	 4.36541655107956616532760563131887e-01 1.26916689784086766934478873736225e-01 3.38825160904275340598146293302761e-03
 	 1.26916689784086766934478873736225e-01 4.36541655107956616532760563131887e-01 3.38825160904275340598146293302761e-03
 	 3.70326513393935824458580441387312e-02 3.70326513393935824458580441387312e-02 7.96024816034627885272256797577484e-04
 	 3.70326513393935824458580441387312e-02 9.25934697321212807352708296093624e-01 7.96024816034627885272256797577484e-04
 	 9.25934697321212807352708296093624e-01 3.70326513393935824458580441387312e-02 7.96024816034627885272256797577484e-04
 	 2.11731749565185534134315048504504e-01 2.11731749565185534134315048504504e-01 3.56278191707463378831710620886497e-03
 	 2.11731749565185534134315048504504e-01 5.76536500869628931731369902990991e-01 3.56278191707463378831710620886497e-03
 	 5.76536500869628931731369902990991e-01 2.11731749565185534134315048504504e-01 3.56278191707463378831710620886497e-03
 	 2.86957288459068593500234101156821e-01 2.86957288459068593500234101156821e-01 4.36436425490537883986608136410723e-03
 	 2.86957288459068593500234101156821e-01 4.26085423081862812999531797686359e-01 4.36436425490537883986608136410723e-03
 	 4.26085423081862812999531797686359e-01 2.86957288459068593500234101156821e-01 4.36436425490537883986608136410723e-03
 	 8.06765828829424935797476337029366e-02 8.06765828829424935797476337029366e-02 1.85384268403265112766520328335673e-03
 	 8.06765828829424935797476337029366e-02 8.38646834234115012840504732594127e-01 1.85384268403265112766520328335673e-03
 	 8.38646834234115012840504732594127e-01 8.06765828829424935797476337029366e-02 1.85384268403265112766520328335673e-03
 	 3.64321992072988865701832494892187e-03 3.64321992072988865701832494892187e-03 8.74538907766669241887480534813903e-05
 	 3.64321992072988865701832494892187e-03 9.92713560158540175848429498728365e-01 8.74538907766669241887480534813903e-05
 	 9.92713560158540175848429498728365e-01 3.64321992072988865701832494892187e-03 8.74538907766669241887480534813903e-05
 	 2.38275208584557002255976954074868e-01 4.37448243826125699601492513579615e-03 3.91201516419781921037046590328146e-04
 	 2.38275208584557002255976954074868e-01 7.57350308977181807534861945896409e-01 3.91201516419781921037046590328146e-04
 	 4.37448243826125699601492513579615e-03 2.38275208584557002255976954074868e-01 3.91201516419781921037046590328146e-04
 	 4.37448243826125699601492513579615e-03 7.57350308977181807534861945896409e-01 3.91201516419781921037046590328146e-04
 	 7.57350308977181807534861945896409e-01 2.38275208584557002255976954074868e-01 3.91201516419781921037046590328146e-04
 	 7.57350308977181807534861945896409e-01 4.37448243826125699601492513579615e-03 3.91201516419781921037046590328146e-04
 	 5.02290201314918416386490207514726e-01 2.31437075889000587469723768663243e-01 2.71296293947622833495070260312332e-03
 	 5.02290201314918416386490207514726e-01 2.66272722796080996143786023822031e-01 2.71296293947622833495070260312332e-03
 	 2.31437075889000587469723768663243e-01 5.02290201314918416386490207514726e-01 2.71296293947622833495070260312332e-03
 	 2.31437075889000587469723768663243e-01 2.66272722796080996143786023822031e-01 2.71296293947622833495070260312332e-03
 	 2.66272722796080996143786023822031e-01 5.02290201314918416386490207514726e-01 2.71296293947622833495070260312332e-03
 	 2.66272722796080996143786023822031e-01 2.31437075889000587469723768663243e-01 2.71296293947622833495070260312332e-03
 	 3.50682734157158282339850075004506e-01 2.36099447436519921383890618926671e-01 3.21678249161045553064508517593367e-03
 	 3.50682734157158282339850075004506e-01 4.13217818406321768520683690439910e-01 3.21678249161045553064508517593367e-03
 	 2.36099447436519921383890618926671e-01 3.50682734157158282339850075004506e-01 3.21678249161045553064508517593367e-03
 	 2.36099447436519921383890618926671e-01 4.13217818406321768520683690439910e-01 3.21678249161045553064508517593367e-03
 	 4.13217818406321768520683690439910e-01 3.50682734157158282339850075004506e-01 3.21678249161045553064508517593367e-03
 	 4.13217818406321768520683690439910e-01 2.36099447436519921383890618926671e-01 3.21678249161045553064508517593367e-03
 	 2.77808917719284009795188694624812e-01 2.66233974789171091296369198175853e-03 3.82255318815834753670007684078769e-04
 	 2.77808917719284009795188694624812e-01 7.19528742532824283628656303335447e-01 3.82255318815834753670007684078769e-04
 	 2.66233974789171091296369198175853e-03 2.77808917719284009795188694624812e-01 3.82255318815834753670007684078769e-04
 	 2.66233974789171091296369198175853e-03 7.19528742532824283628656303335447e-01 3.82255318815834753670007684078769e-04
 	 7.19528742532824283628656303335447e-01 2.77808917719284009795188694624812e-01 3.82255318815834753670007684078769e-04
 	 7.19528742532824283628656303335447e-01 2.66233974789171091296369198175853e-03 3.82255318815834753670007684078769e-04
 	 3.21203482682616781040962905535707e-01 2.07439611934945505877792015780869e-01 3.12974434051319170407845504655597e-03
 	 3.21203482682616781040962905535707e-01 4.71356905382437685325669463054510e-01 3.12974434051319170407845504655597e-03
 	 2.07439611934945505877792015780869e-01 3.21203482682616781040962905535707e-01 3.12974434051319170407845504655597e-03
 	 2.07439611934945505877792015780869e-01 4.71356905382437685325669463054510e-01 3.12974434051319170407845504655597e-03
 	 4.71356905382437685325669463054510e-01 3.21203482682616781040962905535707e-01 3.12974434051319170407845504655597e-03
 	 4.71356905382437685325669463054510e-01 2.07439611934945505877792015780869e-01 3.12974434051319170407845504655597e-03
 	 4.57424216852982068459709807939362e-01 1.19091524767886494662327834248572e-02 1.08104370344727293562492320688762e-03
 	 4.57424216852982068459709807939362e-01 5.30666630670229233501800081285182e-01 1.08104370344727293562492320688762e-03
 	 1.19091524767886494662327834248572e-02 4.57424216852982068459709807939362e-01 1.08104370344727293562492320688762e-03
 	 1.19091524767886494662327834248572e-02 5.30666630670229233501800081285182e-01 1.08104370344727293562492320688762e-03
 	 5.30666630670229233501800081285182e-01 4.57424216852982068459709807939362e-01 1.08104370344727293562492320688762e-03
 	 5.30666630670229233501800081285182e-01 1.19091524767886494662327834248572e-02 1.08104370344727293562492320688762e-03
 	 1.91038342852184600539899861360027e-01 2.15696233889989567519829272157494e-03 3.45426989161139847382686607346614e-04
 	 1.91038342852184600539899861360027e-01 8.06804694808915479065092313248897e-01 3.45426989161139847382686607346614e-04
 	 2.15696233889989567519829272157494e-03 1.91038342852184600539899861360027e-01 3.45426989161139847382686607346614e-04
 	 2.15696233889989567519829272157494e-03 8.06804694808915479065092313248897e-01 3.45426989161139847382686607346614e-04
 	 8.06804694808915479065092313248897e-01 1.91038342852184600539899861360027e-01 3.45426989161139847382686607346614e-04
 	 8.06804694808915479065092313248897e-01 2.15696233889989567519829272157494e-03 3.45426989161139847382686607346614e-04
 	 2.06351940732836303116215503905551e-01 1.07257493751645838209185512823751e-01 2.19054804285410704284275951181371e-03
 	 2.06351940732836303116215503905551e-01 6.86390565515517914185750214528525e-01 2.19054804285410704284275951181371e-03
 	 1.07257493751645838209185512823751e-01 2.06351940732836303116215503905551e-01 2.19054804285410704284275951181371e-03
 	 1.07257493751645838209185512823751e-01 6.86390565515517914185750214528525e-01 2.19054804285410704284275951181371e-03
 	 6.86390565515517914185750214528525e-01 2.06351940732836303116215503905551e-01 2.19054804285410704284275951181371e-03
 	 6.86390565515517914185750214528525e-01 1.07257493751645838209185512823751e-01 2.19054804285410704284275951181371e-03
 	 2.61238382787471912216403779893881e-01 1.12438393291482544023018874668196e-01 2.44886953539576006366740301700702e-03
 	 2.61238382787471912216403779893881e-01 6.26323223921045557638365153252380e-01 2.44886953539576006366740301700702e-03
 	 1.12438393291482544023018874668196e-01 2.61238382787471912216403779893881e-01 2.44886953539576006366740301700702e-03
 	 1.12438393291482544023018874668196e-01 6.26323223921045557638365153252380e-01 2.44886953539576006366740301700702e-03
 	 6.26323223921045557638365153252380e-01 2.61238382787471912216403779893881e-01 2.44886953539576006366740301700702e-03
 	 6.26323223921045557638365153252380e-01 1.12438393291482544023018874668196e-01 2.44886953539576006366740301700702e-03
 	 1.59388899623120305903967164340429e-01 1.14090324996719685857193837819068e-01 2.21549482544702641337308612889956e-03
 	 1.59388899623120305903967164340429e-01 7.26520775380160022116626805654960e-01 2.21549482544702641337308612889956e-03
 	 1.14090324996719685857193837819068e-01 1.59388899623120305903967164340429e-01 2.21549482544702641337308612889956e-03
 	 1.14090324996719685857193837819068e-01 7.26520775380160022116626805654960e-01 2.21549482544702641337308612889956e-03
 	 7.26520775380160022116626805654960e-01 1.59388899623120305903967164340429e-01 2.21549482544702641337308612889956e-03
 	 7.26520775380160022116626805654960e-01 1.14090324996719685857193837819068e-01 2.21549482544702641337308612889956e-03
 	 3.98869513224066885026530826507951e-01 6.19448419160624624835165263903036e-02 2.34993921431397032387189405255867e-03
 	 3.98869513224066885026530826507951e-01 5.39185644859870638612164839287288e-01 2.34993921431397032387189405255867e-03
 	 6.19448419160624624835165263903036e-02 3.98869513224066885026530826507951e-01 2.34993921431397032387189405255867e-03
 	 6.19448419160624624835165263903036e-02 5.39185644859870638612164839287288e-01 2.34993921431397032387189405255867e-03
 	 5.39185644859870638612164839287288e-01 3.98869513224066885026530826507951e-01 2.34993921431397032387189405255867e-03
 	 5.39185644859870638612164839287288e-01 6.19448419160624624835165263903036e-02 2.34993921431397032387189405255867e-03
 	 3.12272579273360884055676933712675e-01 1.21962883225284618449180129573506e-01 2.84747357948343486622189146828532e-03
 	 3.12272579273360884055676933712675e-01 5.65764537501354469739567321084905e-01 2.84747357948343486622189146828532e-03
 	 1.21962883225284618449180129573506e-01 3.12272579273360884055676933712675e-01 2.84747357948343486622189146828532e-03
 	 1.21962883225284618449180129573506e-01 5.65764537501354469739567321084905e-01 2.84747357948343486622189146828532e-03
 	 5.65764537501354469739567321084905e-01 3.12272579273360884055676933712675e-01 2.84747357948343486622189146828532e-03
 	 5.65764537501354469739567321084905e-01 1.21962883225284618449180129573506e-01 2.84747357948343486622189146828532e-03
 	 3.64436262358476370515347753098467e-01 3.86447963475402486710486016363575e-02 1.86161499437441217176536500943484e-03
 	 3.64436262358476370515347753098467e-01 5.96918941293983373874709741357947e-01 1.86161499437441217176536500943484e-03
 	 3.86447963475402486710486016363575e-02 3.64436262358476370515347753098467e-01 1.86161499437441217176536500943484e-03
 	 3.86447963475402486710486016363575e-02 5.96918941293983373874709741357947e-01 1.86161499437441217176536500943484e-03
 	 5.96918941293983373874709741357947e-01 3.64436262358476370515347753098467e-01 1.86161499437441217176536500943484e-03
 	 5.96918941293983373874709741357947e-01 3.86447963475402486710486016363575e-02 1.86161499437441217176536500943484e-03
 	 2.30564834240443161661460180766881e-01 1.72339717685665617941115357325543e-02 1.13555331101312202354836067286215e-03
 	 2.30564834240443161661460180766881e-01 7.52201193990990280013875235454179e-01 1.13555331101312202354836067286215e-03
 	 1.72339717685665617941115357325543e-02 2.30564834240443161661460180766881e-01 1.13555331101312202354836067286215e-03
 	 1.72339717685665617941115357325543e-02 7.52201193990990280013875235454179e-01 1.13555331101312202354836067286215e-03
 	 7.52201193990990280013875235454179e-01 2.30564834240443161661460180766881e-01 1.13555331101312202354836067286215e-03
 	 7.52201193990990280013875235454179e-01 1.72339717685665617941115357325543e-02 1.13555331101312202354836067286215e-03
 	 3.92682833818939619474619462380360e-02 1.45623703030592060309045265853456e-02 4.75092827573918936780866806302015e-04
 	 3.92682833818939619474619462380360e-02 9.46169346315046899675849090272095e-01 4.75092827573918936780866806302015e-04
 	 1.45623703030592060309045265853456e-02 3.92682833818939619474619462380360e-02 4.75092827573918936780866806302015e-04
 	 1.45623703030592060309045265853456e-02 9.46169346315046899675849090272095e-01 4.75092827573918936780866806302015e-04
 	 9.46169346315046899675849090272095e-01 3.92682833818939619474619462380360e-02 4.75092827573918936780866806302015e-04
 	 9.46169346315046899675849090272095e-01 1.45623703030592060309045265853456e-02 4.75092827573918936780866806302015e-04
 	 3.58257733547722723166373270942131e-01 1.54161109997349499156626961848815e-01 3.71655031528527347167711880615570e-03
 	 3.58257733547722723166373270942131e-01 4.87581156454927777676999767209054e-01 3.71655031528527347167711880615570e-03
 	 1.54161109997349499156626961848815e-01 3.58257733547722723166373270942131e-01 3.71655031528527347167711880615570e-03
 	 1.54161109997349499156626961848815e-01 4.87581156454927777676999767209054e-01 3.71655031528527347167711880615570e-03
 	 4.87581156454927777676999767209054e-01 3.58257733547722723166373270942131e-01 3.71655031528527347167711880615570e-03
 	 4.87581156454927777676999767209054e-01 1.54161109997349499156626961848815e-01 3.71655031528527347167711880615570e-03
 	 3.80507882548312525994305133281159e-01 1.01140130678948808595762898221437e-01 3.09321526687093969684716476820086e-03
 	 3.80507882548312525994305133281159e-01 5.18351986772738637654356352868490e-01 3.09321526687093969684716476820086e-03
 	 1.01140130678948808595762898221437e-01 3.80507882548312525994305133281159e-01 3.09321526687093969684716476820086e-03
 	 1.01140130678948808595762898221437e-01 5.18351986772738637654356352868490e-01 3.09321526687093969684716476820086e-03
 	 5.18351986772738637654356352868490e-01 3.80507882548312525994305133281159e-01 3.09321526687093969684716476820086e-03
 	 5.18351986772738637654356352868490e-01 1.01140130678948808595762898221437e-01 3.09321526687093969684716476820086e-03
 	 1.31886575586608933985388603105093e-01 7.32858166481221984245308931349427e-02 1.91871114087192569733208991067386e-03
 	 1.31886575586608933985388603105093e-01 7.94827607765268839834504888131050e-01 1.91871114087192569733208991067386e-03
 	 7.32858166481221984245308931349427e-02 1.31886575586608933985388603105093e-01 1.91871114087192569733208991067386e-03
 	 7.32858166481221984245308931349427e-02 7.94827607765268839834504888131050e-01 1.91871114087192569733208991067386e-03
 	 7.94827607765268839834504888131050e-01 1.31886575586608933985388603105093e-01 1.91871114087192569733208991067386e-03
 	 7.94827607765268839834504888131050e-01 7.32858166481221984245308931349427e-02 1.91871114087192569733208991067386e-03
 	 1.72630255068886018232632295621443e-01 1.35174633972146174959449993480121e-02 9.47936482876536525184196779747481e-04
 	 1.72630255068886018232632295621443e-01 8.13852281533899324372782757563982e-01 9.47936482876536525184196779747481e-04
 	 1.35174633972146174959449993480121e-02 1.72630255068886018232632295621443e-01 9.47936482876536525184196779747481e-04
 	 1.35174633972146174959449993480121e-02 8.13852281533899324372782757563982e-01 9.47936482876536525184196779747481e-04
 	 8.13852281533899324372782757563982e-01 1.72630255068886018232632295621443e-01 9.47936482876536525184196779747481e-04
 	 8.13852281533899324372782757563982e-01 1.35174633972146174959449993480121e-02 9.47936482876536525184196779747481e-04
 	 7.07756358900085702501314699475188e-02 4.31486463812221776592537025862839e-02 1.15793858431617623962195384734741e-03
 	 7.07756358900085702501314699475188e-02 8.86075717728769252090614827466197e-01 1.15793858431617623962195384734741e-03
 	 4.31486463812221776592537025862839e-02 7.07756358900085702501314699475188e-02 1.15793858431617623962195384734741e-03
 	 4.31486463812221776592537025862839e-02 8.86075717728769252090614827466197e-01 1.15793858431617623962195384734741e-03
 	 8.86075717728769252090614827466197e-01 7.07756358900085702501314699475188e-02 1.15793858431617623962195384734741e-03
 	 8.86075717728769252090614827466197e-01 4.31486463812221776592537025862839e-02 1.15793858431617623962195384734741e-03
 	 4.73824731204699201025931643016520e-02 2.84833883835317481364457492531983e-03 2.44135381101898417703296995107110e-04
 	 4.73824731204699201025931643016520e-02 9.49769188041176826153844103828305e-01 2.44135381101898417703296995107110e-04
 	 2.84833883835317481364457492531983e-03 4.73824731204699201025931643016520e-02 2.44135381101898417703296995107110e-04
 	 2.84833883835317481364457492531983e-03 9.49769188041176826153844103828305e-01 2.44135381101898417703296995107110e-04
 	 9.49769188041176826153844103828305e-01 4.73824731204699201025931643016520e-02 2.44135381101898417703296995107110e-04
 	 9.49769188041176826153844103828305e-01 2.84833883835317481364457492531983e-03 2.44135381101898417703296995107110e-04
 	 2.97193248295744893994196900166571e-01 4.03974541969813680242218367766327e-02 1.96662350376744640353954274303305e-03
 	 2.97193248295744893994196900166571e-01 6.62409297507273731042687359149568e-01 1.96662350376744640353954274303305e-03
 	 4.03974541969813680242218367766327e-02 2.97193248295744893994196900166571e-01 1.96662350376744640353954274303305e-03
 	 4.03974541969813680242218367766327e-02 6.62409297507273731042687359149568e-01 1.96662350376744640353954274303305e-03
 	 6.62409297507273731042687359149568e-01 2.97193248295744893994196900166571e-01 1.96662350376744640353954274303305e-03
 	 6.62409297507273731042687359149568e-01 4.03974541969813680242218367766327e-02 1.96662350376744640353954274303305e-03
 	 4.43765239953598289446290436899289e-01 3.10025483435276659471835358772296e-02 1.86849159371713937315140352524168e-03
 	 4.43765239953598289446290436899289e-01 5.25232211702874041137079075269867e-01 1.86849159371713937315140352524168e-03
 	 3.10025483435276659471835358772296e-02 4.43765239953598289446290436899289e-01 1.86849159371713937315140352524168e-03
 	 3.10025483435276659471835358772296e-02 5.25232211702874041137079075269867e-01 1.86849159371713937315140352524168e-03
 	 5.25232211702874041137079075269867e-01 4.43765239953598289446290436899289e-01 1.86849159371713937315140352524168e-03
 	 5.25232211702874041137079075269867e-01 3.10025483435276659471835358772296e-02 1.86849159371713937315140352524168e-03
 	 2.29854890249822918502076163349557e-01 3.92854639000807109860957666569448e-02 1.76531343516777954050223087278937e-03
 	 2.29854890249822918502076163349557e-01 7.30859645850096328878464646550128e-01 1.76531343516777954050223087278937e-03
 	 3.92854639000807109860957666569448e-02 2.29854890249822918502076163349557e-01 1.76531343516777954050223087278937e-03
 	 3.92854639000807109860957666569448e-02 7.30859645850096328878464646550128e-01 1.76531343516777954050223087278937e-03
 	 7.30859645850096328878464646550128e-01 2.29854890249822918502076163349557e-01 1.76531343516777954050223087278937e-03
 	 7.30859645850096328878464646550128e-01 3.92854639000807109860957666569448e-02 1.76531343516777954050223087278937e-03
 	 2.51525427138907131663358995865565e-01 7.15641320496676891504961304235621e-02 2.43665074530694967733235323237295e-03
 	 2.51525427138907131663358995865565e-01 6.76910440811425151430569258081960e-01 2.43665074530694967733235323237295e-03
 	 7.15641320496676891504961304235621e-02 2.51525427138907131663358995865565e-01 2.43665074530694967733235323237295e-03
 	 7.15641320496676891504961304235621e-02 6.76910440811425151430569258081960e-01 2.43665074530694967733235323237295e-03
 	 6.76910440811425151430569258081960e-01 2.51525427138907131663358995865565e-01 2.43665074530694967733235323237295e-03
 	 6.76910440811425151430569258081960e-01 7.15641320496676891504961304235621e-02 2.43665074530694967733235323237295e-03
 	 2.20628791932752477134016544368933e-01 1.54394591780774664835362841586175e-01 3.03484621096303339854438618772292e-03
 	 2.20628791932752477134016544368933e-01 6.24976616286472830275044998415979e-01 3.03484621096303339854438618772292e-03
 	 1.54394591780774664835362841586175e-01 2.20628791932752477134016544368933e-01 3.03484621096303339854438618772292e-03
 	 1.54394591780774664835362841586175e-01 6.24976616286472830275044998415979e-01 3.03484621096303339854438618772292e-03
 	 6.24976616286472830275044998415979e-01 2.20628791932752477134016544368933e-01 3.03484621096303339854438618772292e-03
 	 6.24976616286472830275044998415979e-01 1.54394591780774664835362841586175e-01 3.03484621096303339854438618772292e-03
 	 4.16403182046817754713430304036592e-01 2.77347337277504936772776211739711e-03 5.50881790375419870195439209226151e-04
 	 4.16403182046817754713430304036592e-01 5.80823344580407296966484409495024e-01 5.50881790375419870195439209226151e-04
 	 2.77347337277504936772776211739711e-03 4.16403182046817754713430304036592e-01 5.50881790375419870195439209226151e-04
 	 2.77347337277504936772776211739711e-03 5.80823344580407296966484409495024e-01 5.50881790375419870195439209226151e-04
 	 5.80823344580407296966484409495024e-01 4.16403182046817754713430304036592e-01 5.50881790375419870195439209226151e-04
 	 5.80823344580407296966484409495024e-01 2.77347337277504936772776211739711e-03 5.50881790375419870195439209226151e-04
 	 2.78037243584027538023661918487051e-01 1.71845869035243042910465760542138e-01 3.65459140776114863383150499487328e-03
 	 2.78037243584027538023661918487051e-01 5.50116887380729502332599167857552e-01 3.65459140776114863383150499487328e-03
 	 1.71845869035243042910465760542138e-01 2.78037243584027538023661918487051e-01 3.65459140776114863383150499487328e-03
 	 1.71845869035243042910465760542138e-01 5.50116887380729502332599167857552e-01 3.65459140776114863383150499487328e-03
 	 5.50116887380729502332599167857552e-01 2.78037243584027538023661918487051e-01 3.65459140776114863383150499487328e-03
 	 5.50116887380729502332599167857552e-01 1.71845869035243042910465760542138e-01 3.65459140776114863383150499487328e-03
 	 3.42075832214508490647375538173947e-01 3.25241025804930876733078726203985e-03 5.86809763869502467280303559249433e-04
 	 3.42075832214508490647375538173947e-01 6.54671757527442110813353792764246e-01 5.86809763869502467280303559249433e-04
 	 3.25241025804930876733078726203985e-03 3.42075832214508490647375538173947e-01 5.86809763869502467280303559249433e-04
 	 3.25241025804930876733078726203985e-03 6.54671757527442110813353792764246e-01 5.86809763869502467280303559249433e-04
 	 6.54671757527442110813353792764246e-01 3.42075832214508490647375538173947e-01 5.86809763869502467280303559249433e-04
 	 6.54671757527442110813353792764246e-01 3.25241025804930876733078726203985e-03 5.86809763869502467280303559249433e-04
 	 3.76651522742024291723339501913870e-01 1.60811994772276506404651286175067e-02 1.41387321020510284275140122645098e-03
 	 3.76651522742024291723339501913870e-01 6.07267277780748071513983177283080e-01 1.41387321020510284275140122645098e-03
 	 1.60811994772276506404651286175067e-02 3.76651522742024291723339501913870e-01 1.41387321020510284275140122645098e-03
 	 1.60811994772276506404651286175067e-02 6.07267277780748071513983177283080e-01 1.41387321020510284275140122645098e-03
 	 6.07267277780748071513983177283080e-01 3.76651522742024291723339501913870e-01 1.41387321020510284275140122645098e-03
 	 6.07267277780748071513983177283080e-01 1.60811994772276506404651286175067e-02 1.41387321020510284275140122645098e-03
 	 1.12297916741235570547985389566747e-01 4.36591987048875543320214376308286e-02 1.40590977903145685629082706213921e-03
 	 1.12297916741235570547985389566747e-01 8.44042884553876882058887076709652e-01 1.40590977903145685629082706213921e-03
 	 4.36591987048875543320214376308286e-02 1.12297916741235570547985389566747e-01 1.40590977903145685629082706213921e-03
 	 4.36591987048875543320214376308286e-02 8.44042884553876882058887076709652e-01 1.40590977903145685629082706213921e-03
 	 8.44042884553876882058887076709652e-01 1.12297916741235570547985389566747e-01 1.40590977903145685629082706213921e-03
 	 8.44042884553876882058887076709652e-01 4.36591987048875543320214376308286e-02 1.40590977903145685629082706213921e-03
 	 1.86141155841773708878861270932248e-01 6.82956923610527899537459006751305e-02 2.18881088644219939237656191721726e-03
 	 1.86141155841773708878861270932248e-01 7.45563151797173473411817212763708e-01 2.18881088644219939237656191721726e-03
 	 6.82956923610527899537459006751305e-02 1.86141155841773708878861270932248e-01 2.18881088644219939237656191721726e-03
 	 6.82956923610527899537459006751305e-02 7.45563151797173473411817212763708e-01 2.18881088644219939237656191721726e-03
 	 7.45563151797173473411817212763708e-01 1.86141155841773708878861270932248e-01 2.18881088644219939237656191721726e-03
 	 7.45563151797173473411817212763708e-01 6.82956923610527899537459006751305e-02 2.18881088644219939237656191721726e-03
 	 3.21703398275187124610852151818108e-01 7.47225031108798287693417705668253e-02 2.88989258748446366242834670856610e-03
 	 3.21703398275187124610852151818108e-01 6.03574098613933074375381693243980e-01 2.88989258748446366242834670856610e-03
 	 7.47225031108798287693417705668253e-02 3.21703398275187124610852151818108e-01 2.88989258748446366242834670856610e-03
 	 7.47225031108798287693417705668253e-02 6.03574098613933074375381693243980e-01 2.88989258748446366242834670856610e-03
 	 6.03574098613933074375381693243980e-01 3.21703398275187124610852151818108e-01 2.88989258748446366242834670856610e-03
 	 6.03574098613933074375381693243980e-01 7.47225031108798287693417705668253e-02 2.88989258748446366242834670856610e-03
 	 1.66012685178866747914838697397499e-01 3.61553743643339420277271756276605e-02 1.66084415751654133897030618527424e-03
 	 1.66012685178866747914838697397499e-01 7.97831940456799282301858511345927e-01 1.66084415751654133897030618527424e-03
 	 3.61553743643339420277271756276605e-02 1.66012685178866747914838697397499e-01 1.66084415751654133897030618527424e-03
 	 3.61553743643339420277271756276605e-02 7.97831940456799282301858511345927e-01 1.66084415751654133897030618527424e-03
 	 7.97831940456799282301858511345927e-01 1.66012685178866747914838697397499e-01 1.66084415751654133897030618527424e-03
 	 7.97831940456799282301858511345927e-01 3.61553743643339420277271756276605e-02 1.66084415751654133897030618527424e-03
 	 1.93576952354284764767911042326887e-02 2.83309069924117659308726580036364e-03 1.61710719288366602244474967697840e-04
 	 1.93576952354284764767911042326887e-02 9.77809214065330278842225197877269e-01 1.61710719288366602244474967697840e-04
 	 2.83309069924117659308726580036364e-03 1.93576952354284764767911042326887e-02 1.61710719288366602244474967697840e-04
 	 2.83309069924117659308726580036364e-03 9.77809214065330278842225197877269e-01 1.61710719288366602244474967697840e-04
 	 9.77809214065330278842225197877269e-01 1.93576952354284764767911042326887e-02 1.61710719288366602244474967697840e-04
 	 9.77809214065330278842225197877269e-01 2.83309069924117659308726580036364e-03 1.61710719288366602244474967697840e-04
 	 7.19904092251254096312962360570964e-02 1.79498835307187742937884422644856e-02 7.79979255879456709506236666840095e-04
 	 7.19904092251254096312962360570964e-02 9.10059707244155746685976282606134e-01 7.79979255879456709506236666840095e-04
 	 1.79498835307187742937884422644856e-02 7.19904092251254096312962360570964e-02 7.79979255879456709506236666840095e-04
 	 1.79498835307187742937884422644856e-02 9.10059707244155746685976282606134e-01 7.79979255879456709506236666840095e-04
 	 9.10059707244155746685976282606134e-01 7.19904092251254096312962360570964e-02 7.79979255879456709506236666840095e-04
 	 9.10059707244155746685976282606134e-01 1.79498835307187742937884422644856e-02 7.79979255879456709506236666840095e-04
 	 1.33332716879897866801840677908331e-01 3.19253987057180636452424771221104e-03 4.34229828650841581140495950563718e-04
 	 1.33332716879897866801840677908331e-01 8.63474743249530329869401157338871e-01 4.34229828650841581140495950563718e-04
 	 3.19253987057180636452424771221104e-03 1.33332716879897866801840677908331e-01 4.34229828650841581140495950563718e-04
 	 3.19253987057180636452424771221104e-03 8.63474743249530329869401157338871e-01 4.34229828650841581140495950563718e-04
 	 8.63474743249530329869401157338871e-01 1.33332716879897866801840677908331e-01 4.34229828650841581140495950563718e-04
 	 8.63474743249530329869401157338871e-01 3.19253987057180636452424771221104e-03 4.34229828650841581140495950563718e-04
 	 2.99445529172993885058673413368524e-01 1.62924574190147324059818600971994e-02 1.37583912829826286727818995814232e-03
 	 2.99445529172993885058673413368524e-01 6.84262013407991420699261198024033e-01 1.37583912829826286727818995814232e-03
 	 1.62924574190147324059818600971994e-02 2.99445529172993885058673413368524e-01 1.37583912829826286727818995814232e-03
 	 1.62924574190147324059818600971994e-02 6.84262013407991420699261198024033e-01 1.37583912829826286727818995814232e-03
 	 6.84262013407991420699261198024033e-01 2.99445529172993885058673413368524e-01 1.37583912829826286727818995814232e-03
 	 6.84262013407991420699261198024033e-01 1.62924574190147324059818600971994e-02 1.37583912829826286727818995814232e-03
 	 1.17107885189153299032582822292170e-01 1.79153991813487192819032145507663e-02 1.02529312215662404654537009918158e-03
 	 1.17107885189153299032582822292170e-01 8.64976715629497960868832251435379e-01 1.02529312215662404654537009918158e-03
 	 1.79153991813487192819032145507663e-02 1.17107885189153299032582822292170e-01 1.02529312215662404654537009918158e-03
 	 1.79153991813487192819032145507663e-02 8.64976715629497960868832251435379e-01 1.02529312215662404654537009918158e-03
 	 8.64976715629497960868832251435379e-01 1.17107885189153299032582822292170e-01 1.02529312215662404654537009918158e-03
 	 8.64976715629497960868832251435379e-01 1.79153991813487192819032145507663e-02 1.02529312215662404654537009918158e-03
 	 8.53676016562654599306725344831648e-02 3.56724930413417637767303780549355e-03 3.92075062823016567015860234235447e-04
 	 8.53676016562654599306725344831648e-02 9.11065149039600341573930109007051e-01 3.92075062823016567015860234235447e-04
 	 3.56724930413417637767303780549355e-03 8.53676016562654599306725344831648e-02 3.92075062823016567015860234235447e-04
 	 3.56724930413417637767303780549355e-03 9.11065149039600341573930109007051e-01 3.92075062823016567015860234235447e-04
 	 9.11065149039600341573930109007051e-01 8.53676016562654599306725344831648e-02 3.92075062823016567015860234235447e-04
 	 9.11065149039600341573930109007051e-01 3.56724930413417637767303780549355e-03 3.92075062823016567015860234235447e-04
 	 ];
 
 	 case  40 

 	 % ALG. DEG.:   40
 	 % PTS CARD.:  295
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.39274222643156082857007760367196e-03
 	 1.57037453637930216054918730606005e-02 1.57037453637930216054918730606005e-02 3.12803309837426067596677370374891e-04
 	 1.57037453637930216054918730606005e-02 9.68592509272413915155652830435429e-01 3.12803309837426067596677370374891e-04
 	 9.68592509272413915155652830435429e-01 1.57037453637930216054918730606005e-02 3.12803309837426067596677370374891e-04
 	 2.93889962897443068889913320163032e-01 2.93889962897443068889913320163032e-01 4.29726447949341054666216876967155e-03
 	 2.93889962897443068889913320163032e-01 4.12220074205113862220173359673936e-01 4.29726447949341054666216876967155e-03
 	 4.12220074205113862220173359673936e-01 2.93889962897443068889913320163032e-01 4.29726447949341054666216876967155e-03
 	 3.70102868423741626635603552131215e-01 3.70102868423741626635603552131215e-01 4.29966617078100712262545002317893e-03
 	 3.70102868423741626635603552131215e-01 2.59794263152516746728792895737570e-01 4.29966617078100712262545002317893e-03
 	 2.59794263152516746728792895737570e-01 3.70102868423741626635603552131215e-01 4.29966617078100712262545002317893e-03
 	 2.52696314852206671552892203180818e-01 2.52696314852206671552892203180818e-01 4.01956779966072645648988981292860e-03
 	 2.52696314852206671552892203180818e-01 4.94607370295586656894215593638364e-01 4.01956779966072645648988981292860e-03
 	 4.94607370295586656894215593638364e-01 2.52696314852206671552892203180818e-01 4.01956779966072645648988981292860e-03
 	 2.10577129514804201049216203500691e-01 2.10577129514804201049216203500691e-01 3.60591179745443999454801442539065e-03
 	 2.10577129514804201049216203500691e-01 5.78845740970391542390416361740790e-01 3.60591179745443999454801442539065e-03
 	 5.78845740970391542390416361740790e-01 2.10577129514804201049216203500691e-01 3.60591179745443999454801442539065e-03
 	 3.05751062854184036537974478164870e-03 3.05751062854184036537974478164870e-03 6.14819425666628664077853483327374e-05
 	 3.05751062854184036537974478164870e-03 9.93884978742916369576221313764108e-01 6.14819425666628664077853483327374e-05
 	 9.93884978742916369576221313764108e-01 3.05751062854184036537974478164870e-03 6.14819425666628664077853483327374e-05
 	 4.03292222274262812664602506629308e-01 4.03292222274262812664602506629308e-01 4.03340248372595876202861830961410e-03
 	 4.03292222274262812664602506629308e-01 1.93415555451474374670794986741384e-01 4.03340248372595876202861830961410e-03
 	 1.93415555451474374670794986741384e-01 4.03292222274262812664602506629308e-01 4.03340248372595876202861830961410e-03
 	 4.76751646800292860906012037958135e-01 4.76751646800292860906012037958135e-01 2.33948811422646056612517639905491e-03
 	 4.76751646800292860906012037958135e-01 4.64967063994142781879759240837302e-02 2.33948811422646056612517639905491e-03
 	 4.64967063994142781879759240837302e-02 4.76751646800292860906012037958135e-01 2.33948811422646056612517639905491e-03
 	 6.48562451597025496630166685463337e-02 6.48562451597025496630166685463337e-02 1.35864928596238915270433267323824e-03
 	 6.48562451597025496630166685463337e-02 8.70287509680594872918391047278419e-01 1.35864928596238915270433267323824e-03
 	 8.70287509680594872918391047278419e-01 6.48562451597025496630166685463337e-02 1.35864928596238915270433267323824e-03
 	 1.68896379782961736371049710214720e-01 1.68896379782961736371049710214720e-01 3.11997101526517630482038256900523e-03
 	 1.68896379782961736371049710214720e-01 6.62207240434076527257900579570560e-01 3.11997101526517630482038256900523e-03
 	 6.62207240434076527257900579570560e-01 1.68896379782961736371049710214720e-01 3.11997101526517630482038256900523e-03
 	 9.62980341591576360915638588267029e-02 9.62980341591576360915638588267029e-02 1.94545468980248065053728634410390e-03
 	 9.62980341591576360915638588267029e-02 8.07403931681684783328023513604421e-01 1.94545468980248065053728634410390e-03
 	 8.07403931681684783328023513604421e-01 9.62980341591576360915638588267029e-02 1.94545468980248065053728634410390e-03
 	 4.90701569130203962831870967420400e-01 4.90701569130203962831870967420400e-01 1.51448455313863469123836225094237e-03
 	 4.90701569130203962831870967420400e-01 1.85968617395920743362580651591998e-02 1.51448455313863469123836225094237e-03
 	 1.85968617395920743362580651591998e-02 4.90701569130203962831870967420400e-01 1.51448455313863469123836225094237e-03
 	 4.98464579236597593592250632354990e-01 4.98464579236597593592250632354990e-01 6.02514031127760157739714497182604e-04
 	 4.98464579236597593592250632354990e-01 3.07084152680481281549873529002070e-03 6.02514031127760157739714497182604e-04
 	 3.07084152680481281549873529002070e-03 4.98464579236597593592250632354990e-01 6.02514031127760157739714497182604e-04
 	 4.32271977606806356853041961585404e-01 4.32271977606806356853041961585404e-01 3.61244286747945154980588000626085e-03
 	 4.32271977606806356853041961585404e-01 1.35456044786387286293916076829191e-01 3.61244286747945154980588000626085e-03
 	 1.35456044786387286293916076829191e-01 4.32271977606806356853041961585404e-01 3.61244286747945154980588000626085e-03
 	 1.30241606990209146665904427209171e-01 1.30241606990209146665904427209171e-01 2.56819586307022217422368903783081e-03
 	 1.30241606990209146665904427209171e-01 7.39516786019581706668191145581659e-01 2.56819586307022217422368903783081e-03
 	 7.39516786019581706668191145581659e-01 1.30241606990209146665904427209171e-01 2.56819586307022217422368903783081e-03
 	 4.56871737154322776763848423797754e-01 4.56871737154322776763848423797754e-01 3.04222693774763896026880338752107e-03
 	 4.56871737154322776763848423797754e-01 8.62565256913544464723031524044927e-02 3.04222693774763896026880338752107e-03
 	 8.62565256913544464723031524044927e-02 4.56871737154322776763848423797754e-01 3.04222693774763896026880338752107e-03
 	 1.67177838355710456363922844502667e-01 1.52794904901324161625164599342952e-03 1.88776183926785134925552256390802e-04
 	 1.67177838355710456363922844502667e-01 8.31294212595276360566742823721142e-01 1.88776183926785134925552256390802e-04
 	 1.52794904901324161625164599342952e-03 1.67177838355710456363922844502667e-01 1.88776183926785134925552256390802e-04
 	 1.52794904901324161625164599342952e-03 8.31294212595276360566742823721142e-01 1.88776183926785134925552256390802e-04
 	 8.31294212595276360566742823721142e-01 1.67177838355710456363922844502667e-01 1.88776183926785134925552256390802e-04
 	 8.31294212595276360566742823721142e-01 1.52794904901324161625164599342952e-03 1.88776183926785134925552256390802e-04
 	 3.71478099445237464060198817605851e-01 1.49718224721410841232538402323371e-02 7.75842484927518824533443364543928e-04
 	 3.71478099445237464060198817605851e-01 6.13550078082621408448460442741634e-01 7.75842484927518824533443364543928e-04
 	 1.49718224721410841232538402323371e-02 3.71478099445237464060198817605851e-01 7.75842484927518824533443364543928e-04
 	 1.49718224721410841232538402323371e-02 6.13550078082621408448460442741634e-01 7.75842484927518824533443364543928e-04
 	 6.13550078082621408448460442741634e-01 3.71478099445237464060198817605851e-01 7.75842484927518824533443364543928e-04
 	 6.13550078082621408448460442741634e-01 1.49718224721410841232538402323371e-02 7.75842484927518824533443364543928e-04
 	 1.59023884712373636540760912794212e-01 6.80425879912778096975101149723741e-03 4.32207280373297485914774185289389e-04
 	 1.59023884712373636540760912794212e-01 8.34171856488498564274891577952076e-01 4.32207280373297485914774185289389e-04
 	 6.80425879912778096975101149723741e-03 1.59023884712373636540760912794212e-01 4.32207280373297485914774185289389e-04
 	 6.80425879912778096975101149723741e-03 8.34171856488498564274891577952076e-01 4.32207280373297485914774185289389e-04
 	 8.34171856488498564274891577952076e-01 1.59023884712373636540760912794212e-01 4.32207280373297485914774185289389e-04
 	 8.34171856488498564274891577952076e-01 6.80425879912778096975101149723741e-03 4.32207280373297485914774185289389e-04
 	 4.62179329282665363187732054939261e-02 3.53139747015546109909500671619753e-02 4.98592465936584087506100448905499e-04
 	 4.62179329282665363187732054939261e-02 9.18468092370178790240231592179043e-01 4.98592465936584087506100448905499e-04
 	 3.53139747015546109909500671619753e-02 4.62179329282665363187732054939261e-02 4.98592465936584087506100448905499e-04
 	 3.53139747015546109909500671619753e-02 9.18468092370178790240231592179043e-01 4.98592465936584087506100448905499e-04
 	 9.18468092370178790240231592179043e-01 4.62179329282665363187732054939261e-02 4.98592465936584087506100448905499e-04
 	 9.18468092370178790240231592179043e-01 3.53139747015546109909500671619753e-02 4.98592465936584087506100448905499e-04
 	 1.14865167380080651637896949068818e-01 1.58398644760465636543989020879053e-03 2.04538515649023709729384390421103e-04
 	 1.14865167380080651637896949068818e-01 8.83550846172314718884877038362902e-01 2.04538515649023709729384390421103e-04
 	 1.58398644760465636543989020879053e-03 1.14865167380080651637896949068818e-01 2.04538515649023709729384390421103e-04
 	 1.58398644760465636543989020879053e-03 8.83550846172314718884877038362902e-01 2.04538515649023709729384390421103e-04
 	 8.83550846172314718884877038362902e-01 1.14865167380080651637896949068818e-01 2.04538515649023709729384390421103e-04
 	 8.83550846172314718884877038362902e-01 1.58398644760465636543989020879053e-03 2.04538515649023709729384390421103e-04
 	 3.34246008184714449296137672718032e-01 2.15166720844818110114360365514585e-02 1.02183358004221650112974817403710e-03
 	 3.34246008184714449296137672718032e-01 6.44237319730803670303487251658225e-01 1.02183358004221650112974817403710e-03
 	 2.15166720844818110114360365514585e-02 3.34246008184714449296137672718032e-01 1.02183358004221650112974817403710e-03
 	 2.15166720844818110114360365514585e-02 6.44237319730803670303487251658225e-01 1.02183358004221650112974817403710e-03
 	 6.44237319730803670303487251658225e-01 3.34246008184714449296137672718032e-01 1.02183358004221650112974817403710e-03
 	 6.44237319730803670303487251658225e-01 2.15166720844818110114360365514585e-02 1.02183358004221650112974817403710e-03
 	 7.23711649483900210100273397983983e-02 2.02526169256312012223464336102552e-03 2.06322166313811512349668531030034e-04
 	 7.23711649483900210100273397983983e-02 9.25603573359046860602461492817383e-01 2.06322166313811512349668531030034e-04
 	 2.02526169256312012223464336102552e-03 7.23711649483900210100273397983983e-02 2.06322166313811512349668531030034e-04
 	 2.02526169256312012223464336102552e-03 9.25603573359046860602461492817383e-01 2.06322166313811512349668531030034e-04
 	 9.25603573359046860602461492817383e-01 7.23711649483900210100273397983983e-02 2.06322166313811512349668531030034e-04
 	 9.25603573359046860602461492817383e-01 2.02526169256312012223464336102552e-03 2.06322166313811512349668531030034e-04
 	 2.23684246664788699554549111780943e-01 1.53612037490868675454480651865197e-02 9.57348377198418017640368926635119e-04
 	 2.23684246664788699554549111780943e-01 7.60954549586124406879150683380431e-01 9.57348377198418017640368926635119e-04
 	 1.53612037490868675454480651865197e-02 2.23684246664788699554549111780943e-01 9.57348377198418017640368926635119e-04
 	 1.53612037490868675454480651865197e-02 7.60954549586124406879150683380431e-01 9.57348377198418017640368926635119e-04
 	 7.60954549586124406879150683380431e-01 2.23684246664788699554549111780943e-01 9.57348377198418017640368926635119e-04
 	 7.60954549586124406879150683380431e-01 1.53612037490868675454480651865197e-02 9.57348377198418017640368926635119e-04
 	 1.11129016990584944535314093627676e-01 1.01659439479149828200466032512850e-02 5.82001567994971762132205839179733e-04
 	 1.11129016990584944535314093627676e-01 8.78705039061499992847359408187913e-01 5.82001567994971762132205839179733e-04
 	 1.01659439479149828200466032512850e-02 1.11129016990584944535314093627676e-01 5.82001567994971762132205839179733e-04
 	 1.01659439479149828200466032512850e-02 8.78705039061499992847359408187913e-01 5.82001567994971762132205839179733e-04
 	 8.78705039061499992847359408187913e-01 1.11129016990584944535314093627676e-01 5.82001567994971762132205839179733e-04
 	 8.78705039061499992847359408187913e-01 1.01659439479149828200466032512850e-02 5.82001567994971762132205839179733e-04
 	 2.76444541807790877818717945046956e-01 3.00138537838292723813893303486111e-02 1.45933685532618887849276578805302e-03
 	 2.76444541807790877818717945046956e-01 6.93541604408379863677680532418890e-01 1.45933685532618887849276578805302e-03
 	 3.00138537838292723813893303486111e-02 2.76444541807790877818717945046956e-01 1.45933685532618887849276578805302e-03
 	 3.00138537838292723813893303486111e-02 6.93541604408379863677680532418890e-01 1.45933685532618887849276578805302e-03
 	 6.93541604408379863677680532418890e-01 2.76444541807790877818717945046956e-01 1.45933685532618887849276578805302e-03
 	 6.93541604408379863677680532418890e-01 3.00138537838292723813893303486111e-02 1.45933685532618887849276578805302e-03
 	 1.69263355465675779942813505840604e-01 1.89700426400215629851864207466861e-02 9.71169086161179236603435693808706e-04
 	 1.69263355465675779942813505840604e-01 8.11766601894302719522045208577765e-01 9.71169086161179236603435693808706e-04
 	 1.89700426400215629851864207466861e-02 1.69263355465675779942813505840604e-01 9.71169086161179236603435693808706e-04
 	 1.89700426400215629851864207466861e-02 8.11766601894302719522045208577765e-01 9.71169086161179236603435693808706e-04
 	 8.11766601894302719522045208577765e-01 1.69263355465675779942813505840604e-01 9.71169086161179236603435693808706e-04
 	 8.11766601894302719522045208577765e-01 1.89700426400215629851864207466861e-02 9.71169086161179236603435693808706e-04
 	 1.19650955248758308901990687900252e-01 2.67407842221269662075222584007861e-02 1.02185803211649354690915281196339e-03
 	 1.19650955248758308901990687900252e-01 8.53608260529114648562654110719450e-01 1.02185803211649354690915281196339e-03
 	 2.67407842221269662075222584007861e-02 1.19650955248758308901990687900252e-01 1.02185803211649354690915281196339e-03
 	 2.67407842221269662075222584007861e-02 8.53608260529114648562654110719450e-01 1.02185803211649354690915281196339e-03
 	 8.53608260529114648562654110719450e-01 1.19650955248758308901990687900252e-01 1.02185803211649354690915281196339e-03
 	 8.53608260529114648562654110719450e-01 2.67407842221269662075222584007861e-02 1.02185803211649354690915281196339e-03
 	 2.83019097129268648593836132931756e-01 8.53818693537522336624301377838719e-04 2.28089429217444983463355945296769e-04
 	 2.83019097129268648593836132931756e-01 7.16127084177193840019981507794000e-01 2.28089429217444983463355945296769e-04
 	 8.53818693537522336624301377838719e-04 2.83019097129268648593836132931756e-01 2.28089429217444983463355945296769e-04
 	 8.53818693537522336624301377838719e-04 7.16127084177193840019981507794000e-01 2.28089429217444983463355945296769e-04
 	 7.16127084177193840019981507794000e-01 2.83019097129268648593836132931756e-01 2.28089429217444983463355945296769e-04
 	 7.16127084177193840019981507794000e-01 8.53818693537522336624301377838719e-04 2.28089429217444983463355945296769e-04
 	 7.04045501511467719524262065533549e-02 1.22584700439817353978533276404050e-02 5.59076325349262218816770442231245e-04
 	 7.04045501511467719524262065533549e-02 9.17336979804871499588614369713468e-01 5.59076325349262218816770442231245e-04
 	 1.22584700439817353978533276404050e-02 7.04045501511467719524262065533549e-02 5.59076325349262218816770442231245e-04
 	 1.22584700439817353978533276404050e-02 9.17336979804871499588614369713468e-01 5.59076325349262218816770442231245e-04
 	 9.17336979804871499588614369713468e-01 7.04045501511467719524262065533549e-02 5.59076325349262218816770442231245e-04
 	 9.17336979804871499588614369713468e-01 1.22584700439817353978533276404050e-02 5.59076325349262218816770442231245e-04
 	 2.16472098751412100892110856875661e-01 3.71700471134970150677290234852990e-02 1.51823620580618899589264714222736e-03
 	 2.16472098751412100892110856875661e-01 7.46357854135090814651221080566756e-01 1.51823620580618899589264714222736e-03
 	 3.71700471134970150677290234852990e-02 2.16472098751412100892110856875661e-01 1.51823620580618899589264714222736e-03
 	 3.71700471134970150677290234852990e-02 7.46357854135090814651221080566756e-01 1.51823620580618899589264714222736e-03
 	 7.46357854135090814651221080566756e-01 2.16472098751412100892110856875661e-01 1.51823620580618899589264714222736e-03
 	 7.46357854135090814651221080566756e-01 3.71700471134970150677290234852990e-02 1.51823620580618899589264714222736e-03
 	 7.69268815632590530206869061657926e-02 3.21942006634704513956535265606362e-02 9.70092839555703584895895996709214e-04
 	 7.69268815632590530206869061657926e-02 8.90878917773270440072508336015744e-01 9.70092839555703584895895996709214e-04
 	 3.21942006634704513956535265606362e-02 7.69268815632590530206869061657926e-02 9.70092839555703584895895996709214e-04
 	 3.21942006634704513956535265606362e-02 8.90878917773270440072508336015744e-01 9.70092839555703584895895996709214e-04
 	 8.90878917773270440072508336015744e-01 7.69268815632590530206869061657926e-02 9.70092839555703584895895996709214e-04
 	 8.90878917773270440072508336015744e-01 3.21942006634704513956535265606362e-02 9.70092839555703584895895996709214e-04
 	 4.29222732038551268995973941855482e-01 8.93215271131544107097166573794311e-03 9.57461742196478917538149389088176e-04
 	 4.29222732038551268995973941855482e-01 5.61845115250133253503861396893626e-01 9.57461742196478917538149389088176e-04
 	 8.93215271131544107097166573794311e-03 4.29222732038551268995973941855482e-01 9.57461742196478917538149389088176e-04
 	 8.93215271131544107097166573794311e-03 5.61845115250133253503861396893626e-01 9.57461742196478917538149389088176e-04
 	 5.61845115250133253503861396893626e-01 4.29222732038551268995973941855482e-01 9.57461742196478917538149389088176e-04
 	 5.61845115250133253503861396893626e-01 8.93215271131544107097166573794311e-03 9.57461742196478917538149389088176e-04
 	 3.25147924885204830935947484249482e-01 2.24045215227499733279259430673847e-01 4.11606702811379617651388329591100e-03
 	 3.25147924885204830935947484249482e-01 4.50806859887295408029217469447758e-01 4.11606702811379617651388329591100e-03
 	 2.24045215227499733279259430673847e-01 3.25147924885204830935947484249482e-01 4.11606702811379617651388329591100e-03
 	 2.24045215227499733279259430673847e-01 4.50806859887295408029217469447758e-01 4.11606702811379617651388329591100e-03
 	 4.50806859887295408029217469447758e-01 3.25147924885204830935947484249482e-01 4.11606702811379617651388329591100e-03
 	 4.50806859887295408029217469447758e-01 2.24045215227499733279259430673847e-01 4.11606702811379617651388329591100e-03
 	 2.78272710286936342249930476100417e-01 1.87626216990675664941790046214010e-01 3.76976024293510262805351196391257e-03
 	 2.78272710286936342249930476100417e-01 5.34101072722388048319430708943401e-01 3.76976024293510262805351196391257e-03
 	 1.87626216990675664941790046214010e-01 2.78272710286936342249930476100417e-01 3.76976024293510262805351196391257e-03
 	 1.87626216990675664941790046214010e-01 5.34101072722388048319430708943401e-01 3.76976024293510262805351196391257e-03
 	 5.34101072722388048319430708943401e-01 2.78272710286936342249930476100417e-01 3.76976024293510262805351196391257e-03
 	 5.34101072722388048319430708943401e-01 1.87626216990675664941790046214010e-01 3.76976024293510262805351196391257e-03
 	 2.85210253518710044051687191313249e-01 9.75852132386811378650381954003024e-03 9.27587312436341454927046790146505e-04
 	 2.85210253518710044051687191313249e-01 7.05031225157421892468789792474126e-01 9.27587312436341454927046790146505e-04
 	 9.75852132386811378650381954003024e-03 2.85210253518710044051687191313249e-01 9.27587312436341454927046790146505e-04
 	 9.75852132386811378650381954003024e-03 7.05031225157421892468789792474126e-01 9.27587312436341454927046790146505e-04
 	 7.05031225157421892468789792474126e-01 2.85210253518710044051687191313249e-01 9.27587312436341454927046790146505e-04
 	 7.05031225157421892468789792474126e-01 9.75852132386811378650381954003024e-03 9.27587312436341454927046790146505e-04
 	 2.72725631829831005603637095191516e-01 5.87062906216736027364966332697804e-02 2.20241068708403519779692736335619e-03
 	 2.72725631829831005603637095191516e-01 6.68568077548495343087608944188105e-01 2.20241068708403519779692736335619e-03
 	 5.87062906216736027364966332697804e-02 2.72725631829831005603637095191516e-01 2.20241068708403519779692736335619e-03
 	 5.87062906216736027364966332697804e-02 6.68568077548495343087608944188105e-01 2.20241068708403519779692736335619e-03
 	 6.68568077548495343087608944188105e-01 2.72725631829831005603637095191516e-01 2.20241068708403519779692736335619e-03
 	 6.68568077548495343087608944188105e-01 5.87062906216736027364966332697804e-02 2.20241068708403519779692736335619e-03
 	 4.15469594771239403296902992224204e-01 3.07419996861602630444654238317526e-02 1.90360250309295087750571795481846e-03
 	 4.15469594771239403296902992224204e-01 5.53788405542600226105776073382003e-01 1.90360250309295087750571795481846e-03
 	 3.07419996861602630444654238317526e-02 4.15469594771239403296902992224204e-01 1.90360250309295087750571795481846e-03
 	 3.07419996861602630444654238317526e-02 5.53788405542600226105776073382003e-01 1.90360250309295087750571795481846e-03
 	 5.53788405542600226105776073382003e-01 4.15469594771239403296902992224204e-01 1.90360250309295087750571795481846e-03
 	 5.53788405542600226105776073382003e-01 3.07419996861602630444654238317526e-02 1.90360250309295087750571795481846e-03
 	 2.20577446533709115028543124026328e-01 3.25675363711016695872357828989152e-03 4.84722289527270957989329991377758e-04
 	 2.20577446533709115028543124026328e-01 7.76165799829180658164773376483936e-01 4.84722289527270957989329991377758e-04
 	 3.25675363711016695872357828989152e-03 2.20577446533709115028543124026328e-01 4.84722289527270957989329991377758e-04
 	 3.25675363711016695872357828989152e-03 7.76165799829180658164773376483936e-01 4.84722289527270957989329991377758e-04
 	 7.76165799829180658164773376483936e-01 2.20577446533709115028543124026328e-01 4.84722289527270957989329991377758e-04
 	 7.76165799829180658164773376483936e-01 3.25675363711016695872357828989152e-03 4.84722289527270957989329991377758e-04
 	 3.42885620394358714424498657535878e-01 4.51876229604891294089341613471333e-02 2.11204016674039225104353434403492e-03
 	 3.42885620394358714424498657535878e-01 6.11926756645152170044354988931445e-01 2.11204016674039225104353434403492e-03
 	 4.51876229604891294089341613471333e-02 3.42885620394358714424498657535878e-01 2.11204016674039225104353434403492e-03
 	 4.51876229604891294089341613471333e-02 6.11926756645152170044354988931445e-01 2.11204016674039225104353434403492e-03
 	 6.11926756645152170044354988931445e-01 3.42885620394358714424498657535878e-01 2.11204016674039225104353434403492e-03
 	 6.11926756645152170044354988931445e-01 4.51876229604891294089341613471333e-02 2.11204016674039225104353434403492e-03
 	 2.31503860611680267744816319464007e-01 1.50818510224056762103472806302307e-01 3.30966277647021678981476000558359e-03
 	 2.31503860611680267744816319464007e-01 6.17677629164262942396135258604772e-01 3.30966277647021678981476000558359e-03
 	 1.50818510224056762103472806302307e-01 2.31503860611680267744816319464007e-01 3.30966277647021678981476000558359e-03
 	 1.50818510224056762103472806302307e-01 6.17677629164262942396135258604772e-01 3.30966277647021678981476000558359e-03
 	 6.17677629164262942396135258604772e-01 2.31503860611680267744816319464007e-01 3.30966277647021678981476000558359e-03
 	 6.17677629164262942396135258604772e-01 1.50818510224056762103472806302307e-01 3.30966277647021678981476000558359e-03
 	 3.81017129649182106909677258954616e-02 1.66736740374798728114846824155393e-02 5.00703644413419131191378408374248e-04
 	 3.81017129649182106909677258954616e-02 9.45224612997601965069804919039598e-01 5.00703644413419131191378408374248e-04
 	 1.66736740374798728114846824155393e-02 3.81017129649182106909677258954616e-02 5.00703644413419131191378408374248e-04
 	 1.66736740374798728114846824155393e-02 9.45224612997601965069804919039598e-01 5.00703644413419131191378408374248e-04
 	 9.45224612997601965069804919039598e-01 3.81017129649182106909677258954616e-02 5.00703644413419131191378408374248e-04
 	 9.45224612997601965069804919039598e-01 1.66736740374798728114846824155393e-02 5.00703644413419131191378408374248e-04
 	 3.52891108510167694767289958690526e-01 1.62105242145544004017665429273620e-01 3.77815553726075330220890435839465e-03
 	 3.52891108510167694767289958690526e-01 4.85003649344288301215044612035854e-01 3.77815553726075330220890435839465e-03
 	 1.62105242145544004017665429273620e-01 3.52891108510167694767289958690526e-01 3.77815553726075330220890435839465e-03
 	 1.62105242145544004017665429273620e-01 4.85003649344288301215044612035854e-01 3.77815553726075330220890435839465e-03
 	 4.85003649344288301215044612035854e-01 3.52891108510167694767289958690526e-01 3.77815553726075330220890435839465e-03
 	 4.85003649344288301215044612035854e-01 1.62105242145544004017665429273620e-01 3.77815553726075330220890435839465e-03
 	 4.00076069919581056577584377009771e-01 6.45258600999303599810019704818842e-02 2.64935252199681231174976936415533e-03
 	 4.00076069919581056577584377009771e-01 5.35398069980488555685838036879431e-01 2.64935252199681231174976936415533e-03
 	 6.45258600999303599810019704818842e-02 4.00076069919581056577584377009771e-01 2.64935252199681231174976936415533e-03
 	 6.45258600999303599810019704818842e-02 5.35398069980488555685838036879431e-01 2.64935252199681231174976936415533e-03
 	 5.35398069980488555685838036879431e-01 4.00076069919581056577584377009771e-01 2.64935252199681231174976936415533e-03
 	 5.35398069980488555685838036879431e-01 6.45258600999303599810019704818842e-02 2.64935252199681231174976936415533e-03
 	 1.87784341546537586475906778105127e-01 1.14379695468569117511314914281684e-01 2.77734489806421474059061615946575e-03
 	 1.87784341546537586475906778105127e-01 6.97835962984893365401717346685473e-01 2.77734489806421474059061615946575e-03
 	 1.14379695468569117511314914281684e-01 1.87784341546537586475906778105127e-01 2.77734489806421474059061615946575e-03
 	 1.14379695468569117511314914281684e-01 6.97835962984893365401717346685473e-01 2.77734489806421474059061615946575e-03
 	 6.97835962984893365401717346685473e-01 1.87784341546537586475906778105127e-01 2.77734489806421474059061615946575e-03
 	 6.97835962984893365401717346685473e-01 1.14379695468569117511314914281684e-01 2.77734489806421474059061615946575e-03
 	 2.07376937690341156539375333522912e-01 6.95719958527820786509110462247918e-02 2.25299228047472644559379162387813e-03
 	 2.07376937690341156539375333522912e-01 7.23051066456876778687501428066753e-01 2.25299228047472644559379162387813e-03
 	 6.95719958527820786509110462247918e-02 2.07376937690341156539375333522912e-01 2.25299228047472644559379162387813e-03
 	 6.95719958527820786509110462247918e-02 7.23051066456876778687501428066753e-01 2.25299228047472644559379162387813e-03
 	 7.23051066456876778687501428066753e-01 2.07376937690341156539375333522912e-01 2.25299228047472644559379162387813e-03
 	 7.23051066456876778687501428066753e-01 6.95719958527820786509110462247918e-02 2.25299228047472644559379162387813e-03
 	 1.07803830226375463308130520090344e-01 5.60343597005426088952795282693842e-02 1.55656756946014745990325423008471e-03
 	 1.07803830226375463308130520090344e-01 8.36161810073081879224332624289673e-01 1.55656756946014745990325423008471e-03
 	 5.60343597005426088952795282693842e-02 1.07803830226375463308130520090344e-01 1.55656756946014745990325423008471e-03
 	 5.60343597005426088952795282693842e-02 8.36161810073081879224332624289673e-01 1.55656756946014745990325423008471e-03
 	 8.36161810073081879224332624289673e-01 1.07803830226375463308130520090344e-01 1.55656756946014745990325423008471e-03
 	 8.36161810073081879224332624289673e-01 5.60343597005426088952795282693842e-02 1.55656756946014745990325423008471e-03
 	 1.47901466073126069966647833098250e-01 8.15896657841670980282344771694625e-02 2.19491910810134735476673029097583e-03
 	 1.47901466073126069966647833098250e-01 7.70508868142706804249542074103374e-01 2.19491910810134735476673029097583e-03
 	 8.15896657841670980282344771694625e-02 1.47901466073126069966647833098250e-01 2.19491910810134735476673029097583e-03
 	 8.15896657841670980282344771694625e-02 7.70508868142706804249542074103374e-01 2.19491910810134735476673029097583e-03
 	 7.70508868142706804249542074103374e-01 1.47901466073126069966647833098250e-01 2.19491910810134735476673029097583e-03
 	 7.70508868142706804249542074103374e-01 8.15896657841670980282344771694625e-02 2.19491910810134735476673029097583e-03
 	 1.60042668411358779412267949737725e-01 4.46292737712247408743415633125551e-02 1.61927618604146197206494761644535e-03
 	 1.60042668411358779412267949737725e-01 7.95328057817416556041223429929232e-01 1.61927618604146197206494761644535e-03
 	 4.46292737712247408743415633125551e-02 1.60042668411358779412267949737725e-01 1.61927618604146197206494761644535e-03
 	 4.46292737712247408743415633125551e-02 7.95328057817416556041223429929232e-01 1.61927618604146197206494761644535e-03
 	 7.95328057817416556041223429929232e-01 1.60042668411358779412267949737725e-01 1.61927618604146197206494761644535e-03
 	 7.95328057817416556041223429929232e-01 4.46292737712247408743415633125551e-02 1.61927618604146197206494761644535e-03
 	 3.77876669688772037769552980535082e-01 1.08791876599217379739670263916196e-01 3.28714905580476798516165182206805e-03
 	 3.77876669688772037769552980535082e-01 5.13331453712010499224049908661982e-01 3.28714905580476798516165182206805e-03
 	 1.08791876599217379739670263916196e-01 3.77876669688772037769552980535082e-01 3.28714905580476798516165182206805e-03
 	 1.08791876599217379739670263916196e-01 5.13331453712010499224049908661982e-01 3.28714905580476798516165182206805e-03
 	 5.13331453712010499224049908661982e-01 3.77876669688772037769552980535082e-01 3.28714905580476798516165182206805e-03
 	 5.13331453712010499224049908661982e-01 1.08791876599217379739670263916196e-01 3.28714905580476798516165182206805e-03
 	 3.92233696648084315117266385186667e-02 3.20614858452418710968445658693327e-03 2.30968790187327586808929691386538e-04
 	 3.92233696648084315117266385186667e-02 9.57570481750667390485887153772637e-01 2.30968790187327586808929691386538e-04
 	 3.20614858452418710968445658693327e-03 3.92233696648084315117266385186667e-02 2.30968790187327586808929691386538e-04
 	 3.20614858452418710968445658693327e-03 9.57570481750667390485887153772637e-01 2.30968790187327586808929691386538e-04
 	 9.57570481750667390485887153772637e-01 3.92233696648084315117266385186667e-02 2.30968790187327586808929691386538e-04
 	 9.57570481750667390485887153772637e-01 3.20614858452418710968445658693327e-03 2.30968790187327586808929691386538e-04
 	 3.24304445077138125963500669968198e-01 8.29765480589191445348618003663432e-02 2.81016493113481809901221808445371e-03
 	 3.24304445077138125963500669968198e-01 5.92719006863942632357122874964261e-01 2.81016493113481809901221808445371e-03
 	 8.29765480589191445348618003663432e-02 3.24304445077138125963500669968198e-01 2.81016493113481809901221808445371e-03
 	 8.29765480589191445348618003663432e-02 5.92719006863942632357122874964261e-01 2.81016493113481809901221808445371e-03
 	 5.92719006863942632357122874964261e-01 3.24304445077138125963500669968198e-01 2.81016493113481809901221808445371e-03
 	 5.92719006863942632357122874964261e-01 8.29765480589191445348618003663432e-02 2.81016493113481809901221808445371e-03
 	 3.50984847622504703146262272639433e-01 3.52073500998824817295740352562916e-03 6.16384778464870676170650476421997e-04
 	 3.50984847622504703146262272639433e-01 6.45494417367507011817906459327787e-01 6.16384778464870676170650476421997e-04
 	 3.52073500998824817295740352562916e-03 3.50984847622504703146262272639433e-01 6.16384778464870676170650476421997e-04
 	 3.52073500998824817295740352562916e-03 6.45494417367507011817906459327787e-01 6.16384778464870676170650476421997e-04
 	 6.45494417367507011817906459327787e-01 3.50984847622504703146262272639433e-01 6.16384778464870676170650476421997e-04
 	 6.45494417367507011817906459327787e-01 3.52073500998824817295740352562916e-03 6.16384778464870676170650476421997e-04
 	 4.20870827625693666451667240835377e-01 5.98294728636777515748401690132141e-04 2.24505119098073640301199693780632e-04
 	 4.20870827625693666451667240835377e-01 5.78530877645669572295616944757057e-01 2.24505119098073640301199693780632e-04
 	 5.98294728636777515748401690132141e-04 4.20870827625693666451667240835377e-01 2.24505119098073640301199693780632e-04
 	 5.98294728636777515748401690132141e-04 5.78530877645669572295616944757057e-01 2.24505119098073640301199693780632e-04
 	 5.78530877645669572295616944757057e-01 4.20870827625693666451667240835377e-01 2.24505119098073640301199693780632e-04
 	 5.78530877645669572295616944757057e-01 5.98294728636777515748401690132141e-04 2.24505119098073640301199693780632e-04
 	 2.52656038560264695203017026869929e-01 9.96837194601994935894140326126944e-02 2.84409163267837408056726289373728e-03
 	 2.52656038560264695203017026869929e-01 6.47660241979535755696417709259549e-01 2.84409163267837408056726289373728e-03
 	 9.96837194601994935894140326126944e-02 2.52656038560264695203017026869929e-01 2.84409163267837408056726289373728e-03
 	 9.96837194601994935894140326126944e-02 6.47660241979535755696417709259549e-01 2.84409163267837408056726289373728e-03
 	 6.47660241979535755696417709259549e-01 2.52656038560264695203017026869929e-01 2.84409163267837408056726289373728e-03
 	 6.47660241979535755696417709259549e-01 9.96837194601994935894140326126944e-02 2.84409163267837408056726289373728e-03
 	 3.01670333560527526017835953098256e-01 1.30823914375048672154022710856225e-01 3.37395444806113092156563126877700e-03
 	 3.01670333560527526017835953098256e-01 5.67505752064423774072565720416605e-01 3.37395444806113092156563126877700e-03
 	 1.30823914375048672154022710856225e-01 3.01670333560527526017835953098256e-01 3.37395444806113092156563126877700e-03
 	 1.30823914375048672154022710856225e-01 5.67505752064423774072565720416605e-01 3.37395444806113092156563126877700e-03
 	 5.67505752064423774072565720416605e-01 3.01670333560527526017835953098256e-01 3.37395444806113092156563126877700e-03
 	 5.67505752064423774072565720416605e-01 1.30823914375048672154022710856225e-01 3.37395444806113092156563126877700e-03
 	 1.60613879667907410997429451526841e-02 2.99558774001274126519422935643888e-03 1.39280312524316953436132049404250e-04
 	 1.60613879667907410997429451526841e-02 9.80943024293196463858635070209857e-01 1.39280312524316953436132049404250e-04
 	 2.99558774001274126519422935643888e-03 1.60613879667907410997429451526841e-02 1.39280312524316953436132049404250e-04
 	 2.99558774001274126519422935643888e-03 9.80943024293196463858635070209857e-01 1.39280312524316953436132049404250e-04
 	 9.80943024293196463858635070209857e-01 1.60613879667907410997429451526841e-02 1.39280312524316953436132049404250e-04
 	 9.80943024293196463858635070209857e-01 2.99558774001274126519422935643888e-03 1.39280312524316953436132049404250e-04
 	 ];
 
 	 case  41 

 	 % ALG. DEG.:   41
 	 % PTS CARD.:  309
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 1.81005509308153171577071560705008e-03 1.81005509308153171577071560705008e-03 2.61046615627579676728684671127567e-05
 	 1.81005509308153171577071560705008e-03 9.96379889813836960854587232461199e-01 2.61046615627579676728684671127567e-05
 	 9.96379889813836960854587232461199e-01 1.81005509308153171577071560705008e-03 2.61046615627579676728684671127567e-05
 	 3.14607751383877753958984158089152e-01 3.14607751383877753958984158089152e-01 3.22163483544135034394861882844907e-03
 	 3.14607751383877753958984158089152e-01 3.70784497232244492082031683821697e-01 3.22163483544135034394861882844907e-03
 	 3.70784497232244492082031683821697e-01 3.14607751383877753958984158089152e-01 3.22163483544135034394861882844907e-03
 	 3.71832457839435748248035906726727e-01 3.71832457839435748248035906726727e-01 2.82310188625230608708283064345324e-03
 	 3.71832457839435748248035906726727e-01 2.56335084321128503503928186546545e-01 2.82310188625230608708283064345324e-03
 	 2.56335084321128503503928186546545e-01 3.71832457839435748248035906726727e-01 2.82310188625230608708283064345324e-03
 	 4.81848960175834395425198408702272e-01 4.81848960175834395425198408702272e-01 1.48755341237118664243777033107108e-03
 	 4.81848960175834395425198408702272e-01 3.63020796483312091496031825954560e-02 1.48755341237118664243777033107108e-03
 	 3.63020796483312091496031825954560e-02 4.81848960175834395425198408702272e-01 1.48755341237118664243777033107108e-03
 	 1.42281998308420726262468747336243e-01 1.42281998308420726262468747336243e-01 2.12247788855559650633697543753442e-03
 	 1.42281998308420726262468747336243e-01 7.15436003383158602986213736585341e-01 2.12247788855559650633697543753442e-03
 	 7.15436003383158602986213736585341e-01 1.42281998308420726262468747336243e-01 2.12247788855559650633697543753442e-03
 	 1.74633614866341574378694190272654e-01 1.74633614866341574378694190272654e-01 2.51812585448819240691031851042681e-03
 	 1.74633614866341574378694190272654e-01 6.50732770267316906753762850712519e-01 2.51812585448819240691031851042681e-03
 	 6.50732770267316906753762850712519e-01 1.74633614866341574378694190272654e-01 2.51812585448819240691031851042681e-03
 	 4.25198078415139901764518981508445e-01 4.25198078415139901764518981508445e-01 3.00505023858111926585157114288904e-03
 	 4.25198078415139901764518981508445e-01 1.49603843169720196470962036983110e-01 3.00505023858111926585157114288904e-03
 	 1.49603843169720196470962036983110e-01 4.25198078415139901764518981508445e-01 3.00505023858111926585157114288904e-03
 	 2.09977372337917744804514086354175e-01 2.09977372337917744804514086354175e-01 3.03861449848868113432498461179421e-03
 	 2.09977372337917744804514086354175e-01 5.80045255324164510390971827291651e-01 3.03861449848868113432498461179421e-03
 	 5.80045255324164510390971827291651e-01 2.09977372337917744804514086354175e-01 3.03861449848868113432498461179421e-03
 	 2.62739973625342737584276164852781e-01 2.62739973625342737584276164852781e-01 3.38357010421123536800247499911620e-03
 	 2.62739973625342737584276164852781e-01 4.74520052749314524831447670294438e-01 3.38357010421123536800247499911620e-03
 	 4.74520052749314524831447670294438e-01 2.62739973625342737584276164852781e-01 3.38357010421123536800247499911620e-03
 	 4.98603639231114337260208912994131e-01 4.98603639231114337260208912994131e-01 5.11819985150216666229538997612281e-04
 	 4.98603639231114337260208912994131e-01 2.79272153777132547958217401173897e-03 5.11819985150216666229538997612281e-04
 	 2.79272153777132547958217401173897e-03 4.98603639231114337260208912994131e-01 5.11819985150216666229538997612281e-04
 	 3.99566525526970250936642514716368e-01 3.99566525526970250936642514716368e-01 3.61505486647584802634147749245130e-03
 	 3.99566525526970250936642514716368e-01 2.00866948946059498126714970567264e-01 3.61505486647584802634147749245130e-03
 	 2.00866948946059498126714970567264e-01 3.99566525526970250936642514716368e-01 3.61505486647584802634147749245130e-03
 	 4.66761057785514965612350124501972e-01 4.66761057785514965612350124501972e-01 2.56693516261922256502248096410312e-03
 	 4.66761057785514965612350124501972e-01 6.64778844289700687752997509960551e-02 2.56693516261922256502248096410312e-03
 	 6.64778844289700687752997509960551e-02 4.66761057785514965612350124501972e-01 2.56693516261922256502248096410312e-03
 	 1.03095485576030487795406997975078e-01 1.03095485576030487795406997975078e-01 1.98478451967980555267767606153484e-03
 	 1.03095485576030487795406997975078e-01 7.93809028847939024409186004049843e-01 1.98478451967980555267767606153484e-03
 	 7.93809028847939024409186004049843e-01 1.03095485576030487795406997975078e-01 1.98478451967980555267767606153484e-03
 	 9.33847895869260646861675922991708e-01 2.67728022087155327624063971825308e-02 4.73316998226449626475942356051974e-04
 	 9.33847895869260646861675922991708e-01 3.93793019220238238453646317793755e-02 4.73316998226449626475942356051974e-04
 	 2.67728022087155327624063971825308e-02 9.33847895869260646861675922991708e-01 4.73316998226449626475942356051974e-04
 	 2.67728022087155327624063971825308e-02 3.93793019220238238453646317793755e-02 4.73316998226449626475942356051974e-04
 	 3.93793019220238238453646317793755e-02 9.33847895869260646861675922991708e-01 4.73316998226449626475942356051974e-04
 	 3.93793019220238238453646317793755e-02 2.67728022087155327624063971825308e-02 4.73316998226449626475942356051974e-04
 	 7.08749727266859141927568543906091e-02 2.14673861123130318984131292836537e-02 5.38919164693541581818980734652769e-04
 	 7.08749727266859141927568543906091e-02 9.07657641161001005336572688975139e-01 5.38919164693541581818980734652769e-04
 	 2.14673861123130318984131292836537e-02 7.08749727266859141927568543906091e-02 5.38919164693541581818980734652769e-04
 	 2.14673861123130318984131292836537e-02 9.07657641161001005336572688975139e-01 5.38919164693541581818980734652769e-04
 	 9.07657641161001005336572688975139e-01 7.08749727266859141927568543906091e-02 5.38919164693541581818980734652769e-04
 	 9.07657641161001005336572688975139e-01 2.14673861123130318984131292836537e-02 5.38919164693541581818980734652769e-04
 	 2.27676589099523561665616711024995e-02 1.19851112427548141953215221633400e-02 2.76775703152319619247678783580113e-04
 	 2.27676589099523561665616711024995e-02 9.65247229847292831372840282710968e-01 2.76775703152319619247678783580113e-04
 	 1.19851112427548141953215221633400e-02 2.27676589099523561665616711024995e-02 2.76775703152319619247678783580113e-04
 	 1.19851112427548141953215221633400e-02 9.65247229847292831372840282710968e-01 2.76775703152319619247678783580113e-04
 	 9.65247229847292831372840282710968e-01 2.27676589099523561665616711024995e-02 2.76775703152319619247678783580113e-04
 	 9.65247229847292831372840282710968e-01 1.19851112427548141953215221633400e-02 2.76775703152319619247678783580113e-04
 	 2.12702658519097947964482386851159e-01 9.64112026242689990063183813617798e-02 1.87236045763998363092306398414166e-03
 	 2.12702658519097947964482386851159e-01 6.90886138856632969762472384900320e-01 1.87236045763998363092306398414166e-03
 	 9.64112026242689990063183813617798e-02 2.12702658519097947964482386851159e-01 1.87236045763998363092306398414166e-03
 	 9.64112026242689990063183813617798e-02 6.90886138856632969762472384900320e-01 1.87236045763998363092306398414166e-03
 	 6.90886138856632969762472384900320e-01 2.12702658519097947964482386851159e-01 1.87236045763998363092306398414166e-03
 	 6.90886138856632969762472384900320e-01 9.64112026242689990063183813617798e-02 1.87236045763998363092306398414166e-03
 	 1.97079994941520175721905161481118e-01 1.27978222846432787562775956757832e-01 2.03686960481117831575637033836301e-03
 	 1.97079994941520175721905161481118e-01 6.74941782212047036715318881761050e-01 2.03686960481117831575637033836301e-03
 	 1.27978222846432787562775956757832e-01 1.97079994941520175721905161481118e-01 2.03686960481117831575637033836301e-03
 	 1.27978222846432787562775956757832e-01 6.74941782212047036715318881761050e-01 2.03686960481117831575637033836301e-03
 	 6.74941782212047036715318881761050e-01 1.97079994941520175721905161481118e-01 2.03686960481117831575637033836301e-03
 	 6.74941782212047036715318881761050e-01 1.27978222846432787562775956757832e-01 2.03686960481117831575637033836301e-03
 	 6.39130414360007115259776355742360e-02 4.23991066111561523688244790264434e-02 8.94377285332313351484678776159853e-04
 	 6.39130414360007115259776355742360e-02 8.93687851952843059777364942419808e-01 8.94377285332313351484678776159853e-04
 	 4.23991066111561523688244790264434e-02 6.39130414360007115259776355742360e-02 8.94377285332313351484678776159853e-04
 	 4.23991066111561523688244790264434e-02 8.93687851952843059777364942419808e-01 8.94377285332313351484678776159853e-04
 	 8.93687851952843059777364942419808e-01 6.39130414360007115259776355742360e-02 8.94377285332313351484678776159853e-04
 	 8.93687851952843059777364942419808e-01 4.23991066111561523688244790264434e-02 8.94377285332313351484678776159853e-04
 	 9.16254632757576847890135240959353e-02 1.16869974011746882713858042279753e-02 5.15712369071734746950319561165088e-04
 	 9.16254632757576847890135240959353e-02 8.96687539323067550611767728696577e-01 5.15712369071734746950319561165088e-04
 	 1.16869974011746882713858042279753e-02 9.16254632757576847890135240959353e-02 5.15712369071734746950319561165088e-04
 	 1.16869974011746882713858042279753e-02 8.96687539323067550611767728696577e-01 5.15712369071734746950319561165088e-04
 	 8.96687539323067550611767728696577e-01 9.16254632757576847890135240959353e-02 5.15712369071734746950319561165088e-04
 	 8.96687539323067550611767728696577e-01 1.16869974011746882713858042279753e-02 5.15712369071734746950319561165088e-04
 	 8.89175403557379839813989974572905e-02 6.32415329385831864739131447095133e-02 1.26610363416353199385311345537275e-03
 	 8.89175403557379839813989974572905e-02 8.47840926705678898933626896905480e-01 1.26610363416353199385311345537275e-03
 	 6.32415329385831864739131447095133e-02 8.89175403557379839813989974572905e-02 1.26610363416353199385311345537275e-03
 	 6.32415329385831864739131447095133e-02 8.47840926705678898933626896905480e-01 1.26610363416353199385311345537275e-03
 	 8.47840926705678898933626896905480e-01 8.89175403557379839813989974572905e-02 1.26610363416353199385311345537275e-03
 	 8.47840926705678898933626896905480e-01 6.32415329385831864739131447095133e-02 1.26610363416353199385311345537275e-03
 	 4.59230558903699015438348851603223e-01 1.48409448407795345470372438967388e-02 1.12623927896231767163681691812371e-03
 	 4.59230558903699015438348851603223e-01 5.25928496255521404911803529103054e-01 1.12623927896231767163681691812371e-03
 	 1.48409448407795345470372438967388e-02 4.59230558903699015438348851603223e-01 1.12623927896231767163681691812371e-03
 	 1.48409448407795345470372438967388e-02 5.25928496255521404911803529103054e-01 1.12623927896231767163681691812371e-03
 	 5.25928496255521404911803529103054e-01 4.59230558903699015438348851603223e-01 1.12623927896231767163681691812371e-03
 	 5.25928496255521404911803529103054e-01 1.48409448407795345470372438967388e-02 1.12623927896231767163681691812371e-03
 	 3.38843822348438572511497568484629e-02 1.84003961561307214853111524632823e-03 1.40918754232970182228498745580225e-04
 	 3.38843822348438572511497568484629e-02 9.64275578149543122208342538215220e-01 1.40918754232970182228498745580225e-04
 	 1.84003961561307214853111524632823e-03 3.38843822348438572511497568484629e-02 1.40918754232970182228498745580225e-04
 	 1.84003961561307214853111524632823e-03 9.64275578149543122208342538215220e-01 1.40918754232970182228498745580225e-04
 	 9.64275578149543122208342538215220e-01 3.38843822348438572511497568484629e-02 1.40918754232970182228498745580225e-04
 	 9.64275578149543122208342538215220e-01 1.84003961561307214853111524632823e-03 1.40918754232970182228498745580225e-04
 	 3.20075210406615351388381895958446e-01 2.58057113739871668567360529777943e-01 3.05468653482410821067838391229543e-03
 	 3.20075210406615351388381895958446e-01 4.21867675853512980044257574263611e-01 3.05468653482410821067838391229543e-03
 	 2.58057113739871668567360529777943e-01 3.20075210406615351388381895958446e-01 3.05468653482410821067838391229543e-03
 	 2.58057113739871668567360529777943e-01 4.21867675853512980044257574263611e-01 3.05468653482410821067838391229543e-03
 	 4.21867675853512980044257574263611e-01 3.20075210406615351388381895958446e-01 3.05468653482410821067838391229543e-03
 	 4.21867675853512980044257574263611e-01 2.58057113739871668567360529777943e-01 3.05468653482410821067838391229543e-03
 	 4.22068492531888939112150183063932e-01 3.62192254340186342576046740759921e-02 1.65448560765117679872970857246628e-03
 	 4.22068492531888939112150183063932e-01 5.41712282034092384996881719416706e-01 1.65448560765117679872970857246628e-03
 	 3.62192254340186342576046740759921e-02 4.22068492531888939112150183063932e-01 1.65448560765117679872970857246628e-03
 	 3.62192254340186342576046740759921e-02 5.41712282034092384996881719416706e-01 1.65448560765117679872970857246628e-03
 	 5.41712282034092384996881719416706e-01 4.22068492531888939112150183063932e-01 1.65448560765117679872970857246628e-03
 	 5.41712282034092384996881719416706e-01 3.62192254340186342576046740759921e-02 1.65448560765117679872970857246628e-03
 	 4.78764410729283981793535929227801e-02 1.05439660443664238315131242984535e-02 3.75170187050299106055334386056188e-04
 	 4.78764410729283981793535929227801e-02 9.41579592882705096457129911868833e-01 3.75170187050299106055334386056188e-04
 	 1.05439660443664238315131242984535e-02 4.78764410729283981793535929227801e-02 3.75170187050299106055334386056188e-04
 	 1.05439660443664238315131242984535e-02 9.41579592882705096457129911868833e-01 3.75170187050299106055334386056188e-04
 	 9.41579592882705096457129911868833e-01 4.78764410729283981793535929227801e-02 3.75170187050299106055334386056188e-04
 	 9.41579592882705096457129911868833e-01 1.05439660443664238315131242984535e-02 3.75170187050299106055334386056188e-04
 	 3.61799022706076223165894134581322e-01 1.51026887499565554140446010933374e-01 3.11182961660478674473240268127938e-03
 	 3.61799022706076223165894134581322e-01 4.87174089794358222693659854485304e-01 3.11182961660478674473240268127938e-03
 	 1.51026887499565554140446010933374e-01 3.61799022706076223165894134581322e-01 3.11182961660478674473240268127938e-03
 	 1.51026887499565554140446010933374e-01 4.87174089794358222693659854485304e-01 3.11182961660478674473240268127938e-03
 	 4.87174089794358222693659854485304e-01 3.61799022706076223165894134581322e-01 3.11182961660478674473240268127938e-03
 	 4.87174089794358222693659854485304e-01 1.51026887499565554140446010933374e-01 3.11182961660478674473240268127938e-03
 	 6.84569430922209731793515175013454e-02 2.48206090173236360030273317534011e-03 2.45210435507164665330792630015821e-04
 	 6.84569430922209731793515175013454e-02 9.29060996006046746487072596210055e-01 2.45210435507164665330792630015821e-04
 	 2.48206090173236360030273317534011e-03 6.84569430922209731793515175013454e-02 2.45210435507164665330792630015821e-04
 	 2.48206090173236360030273317534011e-03 9.29060996006046746487072596210055e-01 2.45210435507164665330792630015821e-04
 	 9.29060996006046746487072596210055e-01 6.84569430922209731793515175013454e-02 2.45210435507164665330792630015821e-04
 	 9.29060996006046746487072596210055e-01 2.48206090173236360030273317534011e-03 2.45210435507164665330792630015821e-04
 	 2.36288472596456022856159506773110e-01 1.54957767021962872222573537328572e-01 2.94532213285211624462234247801007e-03
 	 2.36288472596456022856159506773110e-01 6.08753760381581132676842571527231e-01 2.94532213285211624462234247801007e-03
 	 1.54957767021962872222573537328572e-01 2.36288472596456022856159506773110e-01 2.94532213285211624462234247801007e-03
 	 1.54957767021962872222573537328572e-01 6.08753760381581132676842571527231e-01 2.94532213285211624462234247801007e-03
 	 6.08753760381581132676842571527231e-01 2.36288472596456022856159506773110e-01 2.94532213285211624462234247801007e-03
 	 6.08753760381581132676842571527231e-01 1.54957767021962872222573537328572e-01 2.94532213285211624462234247801007e-03
 	 2.97895418985049564852829462324735e-01 1.51961553665098864085436503046367e-01 3.11906005955700157961096863346029e-03
 	 2.97895418985049564852829462324735e-01 5.50143027349851543306158418999985e-01 3.11906005955700157961096863346029e-03
 	 1.51961553665098864085436503046367e-01 2.97895418985049564852829462324735e-01 3.11906005955700157961096863346029e-03
 	 1.51961553665098864085436503046367e-01 5.50143027349851543306158418999985e-01 3.11906005955700157961096863346029e-03
 	 5.50143027349851543306158418999985e-01 2.97895418985049564852829462324735e-01 3.11906005955700157961096863346029e-03
 	 5.50143027349851543306158418999985e-01 1.51961553665098864085436503046367e-01 3.11906005955700157961096863346029e-03
 	 1.12557251523921778013637151616422e-01 2.37754573037215425485024766771858e-03 2.94459094064066602067231137596082e-04
 	 1.12557251523921778013637151616422e-01 8.85065202745705992271041395724751e-01 2.94459094064066602067231137596082e-04
 	 2.37754573037215425485024766771858e-03 1.12557251523921778013637151616422e-01 2.94459094064066602067231137596082e-04
 	 2.37754573037215425485024766771858e-03 8.85065202745705992271041395724751e-01 2.94459094064066602067231137596082e-04
 	 8.85065202745705992271041395724751e-01 1.12557251523921778013637151616422e-01 2.94459094064066602067231137596082e-04
 	 8.85065202745705992271041395724751e-01 2.37754573037215425485024766771858e-03 2.94459094064066602067231137596082e-04
 	 1.20658629713076021722217845422165e-02 3.04923808583817523149006589733290e-03 1.19525780902384455117552775060830e-04
 	 1.20658629713076021722217845422165e-02 9.84884898942854247749778551224153e-01 1.19525780902384455117552775060830e-04
 	 3.04923808583817523149006589733290e-03 1.20658629713076021722217845422165e-02 1.19525780902384455117552775060830e-04
 	 3.04923808583817523149006589733290e-03 9.84884898942854247749778551224153e-01 1.19525780902384455117552775060830e-04
 	 9.84884898942854247749778551224153e-01 1.20658629713076021722217845422165e-02 1.19525780902384455117552775060830e-04
 	 9.84884898942854247749778551224153e-01 3.04923808583817523149006589733290e-03 1.19525780902384455117552775060830e-04
 	 3.90653097086316902775138260039967e-01 1.50754657505242934539824162243349e-02 1.16906687993455953369914546158270e-03
 	 3.90653097086316902775138260039967e-01 5.94271437163158777750027184083592e-01 1.16906687993455953369914546158270e-03
 	 1.50754657505242934539824162243349e-02 3.90653097086316902775138260039967e-01 1.16906687993455953369914546158270e-03
 	 1.50754657505242934539824162243349e-02 5.94271437163158777750027184083592e-01 1.16906687993455953369914546158270e-03
 	 5.94271437163158777750027184083592e-01 3.90653097086316902775138260039967e-01 1.16906687993455953369914546158270e-03
 	 5.94271437163158777750027184083592e-01 1.50754657505242934539824162243349e-02 1.16906687993455953369914546158270e-03
 	 4.27410727373970178444295697772759e-01 2.88455410756848591377621282560995e-03 5.22716485387803410714302465578385e-04
 	 4.27410727373970178444295697772759e-01 5.69704718518461272758202085242374e-01 5.22716485387803410714302465578385e-04
 	 2.88455410756848591377621282560995e-03 4.27410727373970178444295697772759e-01 5.22716485387803410714302465578385e-04
 	 2.88455410756848591377621282560995e-03 5.69704718518461272758202085242374e-01 5.22716485387803410714302465578385e-04
 	 5.69704718518461272758202085242374e-01 4.27410727373970178444295697772759e-01 5.22716485387803410714302465578385e-04
 	 5.69704718518461272758202085242374e-01 2.88455410756848591377621282560995e-03 5.22716485387803410714302465578385e-04
 	 4.11845522097719740628463114262559e-01 1.04765137725845669525170933411573e-01 2.99509456015477782547806739898988e-03
 	 4.11845522097719740628463114262559e-01 4.83389340176434589846365952325868e-01 2.99509456015477782547806739898988e-03
 	 1.04765137725845669525170933411573e-01 4.11845522097719740628463114262559e-01 2.99509456015477782547806739898988e-03
 	 1.04765137725845669525170933411573e-01 4.83389340176434589846365952325868e-01 2.99509456015477782547806739898988e-03
 	 4.83389340176434589846365952325868e-01 4.11845522097719740628463114262559e-01 2.99509456015477782547806739898988e-03
 	 4.83389340176434589846365952325868e-01 1.04765137725845669525170933411573e-01 2.99509456015477782547806739898988e-03
 	 3.22221194516843667532413064691355e-01 1.48317675755721811031717649598249e-02 1.14412479363062567945530378921148e-03
 	 3.22221194516843667532413064691355e-01 6.62947037907584246774206349073211e-01 1.14412479363062567945530378921148e-03
 	 1.48317675755721811031717649598249e-02 3.22221194516843667532413064691355e-01 1.14412479363062567945530378921148e-03
 	 1.48317675755721811031717649598249e-02 6.62947037907584246774206349073211e-01 1.14412479363062567945530378921148e-03
 	 6.62947037907584246774206349073211e-01 3.22221194516843667532413064691355e-01 1.14412479363062567945530378921148e-03
 	 6.62947037907584246774206349073211e-01 1.48317675755721811031717649598249e-02 1.14412479363062567945530378921148e-03
 	 3.54524901630881295044872558719362e-01 3.67451935646271599100742832888500e-02 1.80524352827792118614258498610070e-03
 	 3.54524901630881295044872558719362e-01 6.08729904804491517289477542362874e-01 1.80524352827792118614258498610070e-03
 	 3.67451935646271599100742832888500e-02 3.54524901630881295044872558719362e-01 1.80524352827792118614258498610070e-03
 	 3.67451935646271599100742832888500e-02 6.08729904804491517289477542362874e-01 1.80524352827792118614258498610070e-03
 	 6.08729904804491517289477542362874e-01 3.54524901630881295044872558719362e-01 1.80524352827792118614258498610070e-03
 	 6.08729904804491517289477542362874e-01 3.67451935646271599100742832888500e-02 1.80524352827792118614258498610070e-03
 	 3.32027617298779720300672124722041e-01 2.02832977056254276648772361113515e-01 3.52932890427508144312596094493983e-03
 	 3.32027617298779720300672124722041e-01 4.65139405644966030806131129793357e-01 3.52932890427508144312596094493983e-03
 	 2.02832977056254276648772361113515e-01 3.32027617298779720300672124722041e-01 3.52932890427508144312596094493983e-03
 	 2.02832977056254276648772361113515e-01 4.65139405644966030806131129793357e-01 3.52932890427508144312596094493983e-03
 	 4.65139405644966030806131129793357e-01 3.32027617298779720300672124722041e-01 3.52932890427508144312596094493983e-03
 	 4.65139405644966030806131129793357e-01 2.02832977056254276648772361113515e-01 3.52932890427508144312596094493983e-03
 	 2.53029739084772276047630157336243e-01 6.55893176896967106115354795292660e-02 2.18927628685137770289670378076607e-03
 	 2.53029739084772276047630157336243e-01 6.81380943225531110485349017835688e-01 2.18927628685137770289670378076607e-03
 	 6.55893176896967106115354795292660e-02 2.53029739084772276047630157336243e-01 2.18927628685137770289670378076607e-03
 	 6.55893176896967106115354795292660e-02 6.81380943225531110485349017835688e-01 2.18927628685137770289670378076607e-03
 	 6.81380943225531110485349017835688e-01 2.53029739084772276047630157336243e-01 2.18927628685137770289670378076607e-03
 	 6.81380943225531110485349017835688e-01 6.55893176896967106115354795292660e-02 2.18927628685137770289670378076607e-03
 	 3.57039904894509707578009738426772e-01 2.83340788181253838001749656427819e-03 5.08569179475153979215484856268858e-04
 	 3.57039904894509707578009738426772e-01 6.40126687223677826032997018046444e-01 5.08569179475153979215484856268858e-04
 	 2.83340788181253838001749656427819e-03 3.57039904894509707578009738426772e-01 5.08569179475153979215484856268858e-04
 	 2.83340788181253838001749656427819e-03 6.40126687223677826032997018046444e-01 5.08569179475153979215484856268858e-04
 	 6.40126687223677826032997018046444e-01 3.57039904894509707578009738426772e-01 5.08569179475153979215484856268858e-04
 	 6.40126687223677826032997018046444e-01 2.83340788181253838001749656427819e-03 5.08569179475153979215484856268858e-04
 	 2.87060689211655395425282222277019e-01 3.60525157666744186513163583640562e-02 1.72774226236022945477066592445681e-03
 	 2.87060689211655395425282222277019e-01 6.76886795021670151228931899822783e-01 1.72774226236022945477066592445681e-03
 	 3.60525157666744186513163583640562e-02 2.87060689211655395425282222277019e-01 1.72774226236022945477066592445681e-03
 	 3.60525157666744186513163583640562e-02 6.76886795021670151228931899822783e-01 1.72774226236022945477066592445681e-03
 	 6.76886795021670151228931899822783e-01 2.87060689211655395425282222277019e-01 1.72774226236022945477066592445681e-03
 	 6.76886795021670151228931899822783e-01 3.60525157666744186513163583640562e-02 1.72774226236022945477066592445681e-03
 	 1.36131351631136071622663052949065e-01 1.41561971271275018058322103797764e-02 8.31309620788596328848363281593947e-04
 	 1.36131351631136071622663052949065e-01 8.49712451241736443918739496439230e-01 8.31309620788596328848363281593947e-04
 	 1.41561971271275018058322103797764e-02 1.36131351631136071622663052949065e-01 8.31309620788596328848363281593947e-04
 	 1.41561971271275018058322103797764e-02 8.49712451241736443918739496439230e-01 8.31309620788596328848363281593947e-04
 	 8.49712451241736443918739496439230e-01 1.36131351631136071622663052949065e-01 8.31309620788596328848363281593947e-04
 	 8.49712451241736443918739496439230e-01 1.41561971271275018058322103797764e-02 8.31309620788596328848363281593947e-04
 	 1.32224125661775021578492328444554e-01 6.37728096721327936124978918996931e-02 1.67558532663434852673367547737371e-03
 	 1.32224125661775021578492328444554e-01 8.04003064666092170931221971841296e-01 1.67558532663434852673367547737371e-03
 	 6.37728096721327936124978918996931e-02 1.32224125661775021578492328444554e-01 1.67558532663434852673367547737371e-03
 	 6.37728096721327936124978918996931e-02 8.04003064666092170931221971841296e-01 1.67558532663434852673367547737371e-03
 	 8.04003064666092170931221971841296e-01 1.32224125661775021578492328444554e-01 1.67558532663434852673367547737371e-03
 	 8.04003064666092170931221971841296e-01 6.37728096721327936124978918996931e-02 1.67558532663434852673367547737371e-03
 	 1.07924219839552332222964992070047e-01 3.35534395458731288242049117798160e-02 1.19328232526644479119526387478345e-03
 	 1.07924219839552332222964992070047e-01 8.58522340614574552830617903964594e-01 1.19328232526644479119526387478345e-03
 	 3.35534395458731288242049117798160e-02 1.07924219839552332222964992070047e-01 1.19328232526644479119526387478345e-03
 	 3.35534395458731288242049117798160e-02 8.58522340614574552830617903964594e-01 1.19328232526644479119526387478345e-03
 	 8.58522340614574552830617903964594e-01 1.07924219839552332222964992070047e-01 1.19328232526644479119526387478345e-03
 	 8.58522340614574552830617903964594e-01 3.35534395458731288242049117798160e-02 1.19328232526644479119526387478345e-03
 	 1.52886902141386588072080598976754e-01 9.95790446035427906368298067718570e-02 2.08768949658442049682749441785745e-03
 	 1.52886902141386588072080598976754e-01 7.47534053255070607413301786436932e-01 2.08768949658442049682749441785745e-03
 	 9.95790446035427906368298067718570e-02 1.52886902141386588072080598976754e-01 2.08768949658442049682749441785745e-03
 	 9.95790446035427906368298067718570e-02 7.47534053255070607413301786436932e-01 2.08768949658442049682749441785745e-03
 	 7.47534053255070607413301786436932e-01 1.52886902141386588072080598976754e-01 2.08768949658442049682749441785745e-03
 	 7.47534053255070607413301786436932e-01 9.95790446035427906368298067718570e-02 2.08768949658442049682749441785745e-03
 	 1.88101771929606642608234778890619e-01 6.46491520250393747470951666400651e-02 1.93556074427131776828636677834083e-03
 	 1.88101771929606642608234778890619e-01 7.47249076045353954889094438840402e-01 1.93556074427131776828636677834083e-03
 	 6.46491520250393747470951666400651e-02 1.88101771929606642608234778890619e-01 1.93556074427131776828636677834083e-03
 	 6.46491520250393747470951666400651e-02 7.47249076045353954889094438840402e-01 1.93556074427131776828636677834083e-03
 	 7.47249076045353954889094438840402e-01 1.88101771929606642608234778890619e-01 1.93556074427131776828636677834083e-03
 	 7.47249076045353954889094438840402e-01 6.46491520250393747470951666400651e-02 1.93556074427131776828636677834083e-03
 	 2.54982429150887923707813342844020e-01 1.48987268708079909768082771392983e-02 1.09616959802194720297041641288160e-03
 	 2.54982429150887923707813342844020e-01 7.30118843978304066233420144271804e-01 1.09616959802194720297041641288160e-03
 	 1.48987268708079909768082771392983e-02 2.54982429150887923707813342844020e-01 1.09616959802194720297041641288160e-03
 	 1.48987268708079909768082771392983e-02 7.30118843978304066233420144271804e-01 1.09616959802194720297041641288160e-03
 	 7.30118843978304066233420144271804e-01 2.54982429150887923707813342844020e-01 1.09616959802194720297041641288160e-03
 	 7.30118843978304066233420144271804e-01 1.48987268708079909768082771392983e-02 1.09616959802194720297041641288160e-03
 	 2.23078080481277696289765799519955e-01 2.85444727801385713522597242786105e-03 4.56366168260760238489098794545384e-04
 	 2.23078080481277696289765799519955e-01 7.74067472240708376318707450991496e-01 4.56366168260760238489098794545384e-04
 	 2.85444727801385713522597242786105e-03 2.23078080481277696289765799519955e-01 4.56366168260760238489098794545384e-04
 	 2.85444727801385713522597242786105e-03 7.74067472240708376318707450991496e-01 4.56366168260760238489098794545384e-04
 	 7.74067472240708376318707450991496e-01 2.23078080481277696289765799519955e-01 4.56366168260760238489098794545384e-04
 	 7.74067472240708376318707450991496e-01 2.85444727801385713522597242786105e-03 4.56366168260760238489098794545384e-04
 	 1.64050736021032539380115622407175e-01 2.83077182118177030772931956903449e-03 4.01417326307675211786302194028053e-04
 	 1.64050736021032539380115622407175e-01 8.33118492157785661689217704406474e-01 4.01417326307675211786302194028053e-04
 	 2.83077182118177030772931956903449e-03 1.64050736021032539380115622407175e-01 4.01417326307675211786302194028053e-04
 	 2.83077182118177030772931956903449e-03 8.33118492157785661689217704406474e-01 4.01417326307675211786302194028053e-04
 	 8.33118492157785661689217704406474e-01 1.64050736021032539380115622407175e-01 4.01417326307675211786302194028053e-04
 	 8.33118492157785661689217704406474e-01 2.83077182118177030772931956903449e-03 4.01417326307675211786302194028053e-04
 	 2.88151117418988578222638352599461e-01 2.83594679658896297452796986249268e-03 4.89679800789311839986917007649936e-04
 	 2.88151117418988578222638352599461e-01 7.09012935784422482221600603224942e-01 4.89679800789311839986917007649936e-04
 	 2.83594679658896297452796986249268e-03 2.88151117418988578222638352599461e-01 4.89679800789311839986917007649936e-04
 	 2.83594679658896297452796986249268e-03 7.09012935784422482221600603224942e-01 4.89679800789311839986917007649936e-04
 	 7.09012935784422482221600603224942e-01 2.88151117418988578222638352599461e-01 4.89679800789311839986917007649936e-04
 	 7.09012935784422482221600603224942e-01 2.83594679658896297452796986249268e-03 4.89679800789311839986917007649936e-04
 	 3.40957788874061529238446155432030e-01 1.05632686278177900796038102271268e-01 2.97754338044403698074202857526416e-03
 	 3.40957788874061529238446155432030e-01 5.53409524847760514454364511038875e-01 2.97754338044403698074202857526416e-03
 	 1.05632686278177900796038102271268e-01 3.40957788874061529238446155432030e-01 2.97754338044403698074202857526416e-03
 	 1.05632686278177900796038102271268e-01 5.53409524847760514454364511038875e-01 2.97754338044403698074202857526416e-03
 	 5.53409524847760514454364511038875e-01 3.40957788874061529238446155432030e-01 2.97754338044403698074202857526416e-03
 	 5.53409524847760514454364511038875e-01 1.05632686278177900796038102271268e-01 2.97754338044403698074202857526416e-03
 	 2.68293448069283901880055509536760e-01 2.05408895782746736546897636799258e-01 3.37625766935876819516137992138738e-03
 	 2.68293448069283901880055509536760e-01 5.26297656147969306061895622406155e-01 3.37625766935876819516137992138738e-03
 	 2.05408895782746736546897636799258e-01 2.68293448069283901880055509536760e-01 3.37625766935876819516137992138738e-03
 	 2.05408895782746736546897636799258e-01 5.26297656147969306061895622406155e-01 3.37625766935876819516137992138738e-03
 	 5.26297656147969306061895622406155e-01 2.68293448069283901880055509536760e-01 3.37625766935876819516137992138738e-03
 	 5.26297656147969306061895622406155e-01 2.05408895782746736546897636799258e-01 3.37625766935876819516137992138738e-03
 	 3.19409003528324686449479941074969e-01 6.74786310679263284795226240930788e-02 2.46633730412294501291303738810257e-03
 	 3.19409003528324686449479941074969e-01 6.13112365403749026704360858275322e-01 2.46633730412294501291303738810257e-03
 	 6.74786310679263284795226240930788e-02 3.19409003528324686449479941074969e-01 2.46633730412294501291303738810257e-03
 	 6.74786310679263284795226240930788e-02 6.13112365403749026704360858275322e-01 2.46633730412294501291303738810257e-03
 	 6.13112365403749026704360858275322e-01 3.19409003528324686449479941074969e-01 2.46633730412294501291303738810257e-03
 	 6.13112365403749026704360858275322e-01 6.74786310679263284795226240930788e-02 2.46633730412294501291303738810257e-03
 	 1.92295465185952280107173351098027e-01 1.49331073629515708595105749623144e-02 9.99758561822005915181721391604697e-04
 	 1.92295465185952280107173351098027e-01 7.92771427451096077909653558890568e-01 9.99758561822005915181721391604697e-04
 	 1.49331073629515708595105749623144e-02 1.92295465185952280107173351098027e-01 9.99758561822005915181721391604697e-04
 	 1.49331073629515708595105749623144e-02 7.92771427451096077909653558890568e-01 9.99758561822005915181721391604697e-04
 	 7.92771427451096077909653558890568e-01 1.92295465185952280107173351098027e-01 9.99758561822005915181721391604697e-04
 	 7.92771427451096077909653558890568e-01 1.49331073629515708595105749623144e-02 9.99758561822005915181721391604697e-04
 	 1.60414053402923612035024802935368e-01 3.53852934054426707111140615324985e-02 1.42908494641375569469965434166170e-03
 	 1.60414053402923612035024802935368e-01 8.04200653191633696437179423810448e-01 1.42908494641375569469965434166170e-03
 	 3.53852934054426707111140615324985e-02 1.60414053402923612035024802935368e-01 1.42908494641375569469965434166170e-03
 	 3.53852934054426707111140615324985e-02 8.04200653191633696437179423810448e-01 1.42908494641375569469965434166170e-03
 	 8.04200653191633696437179423810448e-01 1.60414053402923612035024802935368e-01 1.42908494641375569469965434166170e-03
 	 8.04200653191633696437179423810448e-01 3.53852934054426707111140615324985e-02 1.42908494641375569469965434166170e-03
 	 2.21253498980421736685997302629403e-01 3.62519958338577280576586758797930e-02 1.62869147472470966568625083681354e-03
 	 2.21253498980421736685997302629403e-01 7.42494505185720465867404982418520e-01 1.62869147472470966568625083681354e-03
 	 3.62519958338577280576586758797930e-02 2.21253498980421736685997302629403e-01 1.62869147472470966568625083681354e-03
 	 3.62519958338577280576586758797930e-02 7.42494505185720465867404982418520e-01 1.62869147472470966568625083681354e-03
 	 7.42494505185720465867404982418520e-01 2.21253498980421736685997302629403e-01 1.62869147472470966568625083681354e-03
 	 7.42494505185720465867404982418520e-01 3.62519958338577280576586758797930e-02 1.62869147472470966568625083681354e-03
 	 2.71194224068813549699541454174323e-01 1.06599696973037380565152432154719e-01 2.93614082918626203080880721074664e-03
 	 2.71194224068813549699541454174323e-01 6.22206078958149055857518305856502e-01 2.93614082918626203080880721074664e-03
 	 1.06599696973037380565152432154719e-01 2.71194224068813549699541454174323e-01 2.93614082918626203080880721074664e-03
 	 1.06599696973037380565152432154719e-01 6.22206078958149055857518305856502e-01 2.93614082918626203080880721074664e-03
 	 6.22206078958149055857518305856502e-01 2.71194224068813549699541454174323e-01 2.93614082918626203080880721074664e-03
 	 6.22206078958149055857518305856502e-01 1.06599696973037380565152432154719e-01 2.93614082918626203080880721074664e-03
 	 3.92323411299770385962659702272504e-01 6.65697076536746201735894601370092e-02 2.54753922375026108093631904694121e-03
 	 3.92323411299770385962659702272504e-01 5.41106881046554910597023990703747e-01 2.54753922375026108093631904694121e-03
 	 6.65697076536746201735894601370092e-02 3.92323411299770385962659702272504e-01 2.54753922375026108093631904694121e-03
 	 6.65697076536746201735894601370092e-02 5.41106881046554910597023990703747e-01 2.54753922375026108093631904694121e-03
 	 5.41106881046554910597023990703747e-01 3.92323411299770385962659702272504e-01 2.54753922375026108093631904694121e-03
 	 5.41106881046554910597023990703747e-01 6.65697076536746201735894601370092e-02 2.54753922375026108093631904694121e-03
 	 ];
 
 	 case  42 

 	 % ALG. DEG.:   42
 	 % PTS CARD.:  324
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw=[
 	 4.02371925109793249220047073322348e-01 4.02371925109793249220047073322348e-01 1.77322000798858401757196467940503e-03
 	 4.02371925109793249220047073322348e-01 1.95256149780413501559905853355303e-01 1.77322000798858401757196467940503e-03
 	 1.95256149780413501559905853355303e-01 4.02371925109793249220047073322348e-01 1.77322000798858401757196467940503e-03
 	 1.36539257595404031446484349743287e-03 1.36539257595404031446484349743287e-03 1.73597677182810516765230912650253e-05
 	 1.36539257595404031446484349743287e-03 9.97269214848091944958241583663039e-01 1.73597677182810516765230912650253e-05
 	 9.97269214848091944958241583663039e-01 1.36539257595404031446484349743287e-03 1.73597677182810516765230912650253e-05
 	 4.97531729625205365596940509931301e-01 4.97531729625205365596940509931301e-01 5.07084821416368069189883893699289e-04
 	 4.97531729625205365596940509931301e-01 4.93654074958926880611898013739847e-03 5.07084821416368069189883893699289e-04
 	 4.93654074958926880611898013739847e-03 4.97531729625205365596940509931301e-01 5.07084821416368069189883893699289e-04
 	 4.79900295754419115024091979648801e-01 4.79900295754419115024091979648801e-01 1.42209297850611989834368475982274e-03
 	 4.79900295754419115024091979648801e-01 4.01994084911617699518160407023970e-02 1.42209297850611989834368475982274e-03
 	 4.01994084911617699518160407023970e-02 4.79900295754419115024091979648801e-01 1.42209297850611989834368475982274e-03
 	 6.64663290557835906291472838347545e-02 6.64663290557835906291472838347545e-02 9.35490769011440006716617823201432e-04
 	 6.64663290557835906291472838347545e-02 8.67067341888432818741705432330491e-01 9.35490769011440006716617823201432e-04
 	 8.67067341888432818741705432330491e-01 6.64663290557835906291472838347545e-02 9.35490769011440006716617823201432e-04
 	 4.32363893877459951053943143506331e-02 4.32363893877459951053943143506331e-02 6.66312500203990383008945119769351e-04
 	 4.32363893877459951053943143506331e-02 9.13527221224508023666999179113191e-01 6.66312500203990383008945119769351e-04
 	 9.13527221224508023666999179113191e-01 4.32363893877459951053943143506331e-02 6.66312500203990383008945119769351e-04
 	 4.90305014201646682803215071544400e-01 4.90305014201646682803215071544400e-01 1.09634084079294233209089792779878e-03
 	 4.90305014201646682803215071544400e-01 1.93899715967066343935698569111992e-02 1.09634084079294233209089792779878e-03
 	 1.93899715967066343935698569111992e-02 4.90305014201646682803215071544400e-01 1.09634084079294233209089792779878e-03
 	 2.69988226283729981780368234467460e-02 2.69988226283729981780368234467460e-02 4.76202977827340750548862358115798e-04
 	 2.69988226283729981780368234467460e-02 9.46002354743254003643926353106508e-01 4.76202977827340750548862358115798e-04
 	 9.46002354743254003643926353106508e-01 2.69988226283729981780368234467460e-02 4.76202977827340750548862358115798e-04
 	 1.38504806910322769697430089763657e-01 1.38504806910322769697430089763657e-01 2.17992502094623398847805795242039e-03
 	 1.38504806910322769697430089763657e-01 7.22990386179354516116291051730514e-01 2.17992502094623398847805795242039e-03
 	 7.22990386179354516116291051730514e-01 1.38504806910322769697430089763657e-01 2.17992502094623398847805795242039e-03
 	 4.67013207355763959593986101026530e-01 4.67013207355763959593986101026530e-01 2.26626612751637578416219476196147e-03
 	 4.67013207355763959593986101026530e-01 6.59735852884720808120277979469392e-02 2.26626612751637578416219476196147e-03
 	 6.59735852884720808120277979469392e-02 4.67013207355763959593986101026530e-01 2.26626612751637578416219476196147e-03
 	 1.06580425858858796051009676375543e-01 1.06580425858858796051009676375543e-01 1.84803533077693886779724330438057e-03
 	 1.06580425858858796051009676375543e-01 7.86839148282282407897980647248914e-01 1.84803533077693886779724330438057e-03
 	 7.86839148282282407897980647248914e-01 1.06580425858858796051009676375543e-01 1.84803533077693886779724330438057e-03
 	 3.11735391072587297855989163508639e-01 3.11735391072587297855989163508639e-01 4.04866880451419577230387503163911e-03
 	 3.11735391072587297855989163508639e-01 3.76529217854825404288021672982723e-01 4.04866880451419577230387503163911e-03
 	 3.76529217854825404288021672982723e-01 3.11735391072587297855989163508639e-01 4.04866880451419577230387503163911e-03
 	 2.44860575868881713557101420519757e-01 2.44860575868881713557101420519757e-01 3.64530052639338696812698614735382e-03
 	 2.44860575868881713557101420519757e-01 5.10278848262236572885797158960486e-01 3.64530052639338696812698614735382e-03
 	 5.10278848262236572885797158960486e-01 2.44860575868881713557101420519757e-01 3.64530052639338696812698614735382e-03
 	 1.74835145811190639797416679357411e-01 1.74835145811190639797416679357411e-01 3.02776339101268636075370288551767e-03
 	 1.74835145811190639797416679357411e-01 6.50329708377618720405166641285177e-01 3.02776339101268636075370288551767e-03
 	 6.50329708377618720405166641285177e-01 1.74835145811190639797416679357411e-01 3.02776339101268636075370288551767e-03
 	 4.27569334150190383248002490290673e-01 4.27569334150190383248002490290673e-01 3.37947231961488459006659468286671e-03
 	 4.27569334150190383248002490290673e-01 1.44861331699619233503995019418653e-01 3.37947231961488459006659468286671e-03
 	 1.44861331699619233503995019418653e-01 4.27569334150190383248002490290673e-01 3.37947231961488459006659468286671e-03
 	 3.74270156678447651898977710516192e-01 3.74270156678447651898977710516192e-01 3.96102228829565711915039472046374e-03
 	 3.74270156678447651898977710516192e-01 2.51459686643104696202044578967616e-01 3.96102228829565711915039472046374e-03
 	 2.51459686643104696202044578967616e-01 3.74270156678447651898977710516192e-01 3.96102228829565711915039472046374e-03
 	 3.30553853684353138309148789630854e-01 1.57042560146290624892295717529578e-03 2.66365847170266245320241482730239e-04
 	 3.30553853684353138309148789630854e-01 6.67875720714183995774249069654616e-01 2.66365847170266245320241482730239e-04
 	 1.57042560146290624892295717529578e-03 3.30553853684353138309148789630854e-01 2.66365847170266245320241482730239e-04
 	 1.57042560146290624892295717529578e-03 6.67875720714183995774249069654616e-01 2.66365847170266245320241482730239e-04
 	 6.67875720714183995774249069654616e-01 3.30553853684353138309148789630854e-01 2.66365847170266245320241482730239e-04
 	 6.67875720714183995774249069654616e-01 1.57042560146290624892295717529578e-03 2.66365847170266245320241482730239e-04
 	 9.69953965146683194653576265409356e-01 9.61466912071009052742631695309683e-03 2.19538513584912036574747773443050e-04
 	 9.69953965146683194653576265409356e-01 2.04313657326067148189974176375472e-02 2.19538513584912036574747773443050e-04
 	 9.61466912071009052742631695309683e-03 9.69953965146683194653576265409356e-01 2.19538513584912036574747773443050e-04
 	 9.61466912071009052742631695309683e-03 2.04313657326067148189974176375472e-02 2.19538513584912036574747773443050e-04
 	 2.04313657326067148189974176375472e-02 9.69953965146683194653576265409356e-01 2.19538513584912036574747773443050e-04
 	 2.04313657326067148189974176375472e-02 9.61466912071009052742631695309683e-03 2.19538513584912036574747773443050e-04
 	 5.71983061939756801117518136834406e-02 2.19035586156293565762709363298200e-02 5.18512523267713391732225414187951e-04
 	 5.71983061939756801117518136834406e-02 9.20898135190394984128658961708425e-01 5.18512523267713391732225414187951e-04
 	 2.19035586156293565762709363298200e-02 5.71983061939756801117518136834406e-02 5.18512523267713391732225414187951e-04
 	 2.19035586156293565762709363298200e-02 9.20898135190394984128658961708425e-01 5.18512523267713391732225414187951e-04
 	 9.20898135190394984128658961708425e-01 5.71983061939756801117518136834406e-02 5.18512523267713391732225414187951e-04
 	 9.20898135190394984128658961708425e-01 2.19035586156293565762709363298200e-02 5.18512523267713391732225414187951e-04
 	 4.53270971637945607746189580211649e-01 1.49355129029098685801424384322900e-03 2.79775975114021982492751305926504e-04
 	 4.53270971637945607746189580211649e-01 5.45235477071763452450170461816015e-01 2.79775975114021982492751305926504e-04
 	 1.49355129029098685801424384322900e-03 4.53270971637945607746189580211649e-01 2.79775975114021982492751305926504e-04
 	 1.49355129029098685801424384322900e-03 5.45235477071763452450170461816015e-01 2.79775975114021982492751305926504e-04
 	 5.45235477071763452450170461816015e-01 4.53270971637945607746189580211649e-01 2.79775975114021982492751305926504e-04
 	 5.45235477071763452450170461816015e-01 1.49355129029098685801424384322900e-03 2.79775975114021982492751305926504e-04
 	 1.40732473906720334522191251380718e-01 5.54414996743645416277246340541751e-02 1.26896025323238619865462428748515e-03
 	 1.40732473906720334522191251380718e-01 8.03826026418915096094508498936193e-01 1.26896025323238619865462428748515e-03
 	 5.54414996743645416277246340541751e-02 1.40732473906720334522191251380718e-01 1.26896025323238619865462428748515e-03
 	 5.54414996743645416277246340541751e-02 8.03826026418915096094508498936193e-01 1.26896025323238619865462428748515e-03
 	 8.03826026418915096094508498936193e-01 1.40732473906720334522191251380718e-01 1.26896025323238619865462428748515e-03
 	 8.03826026418915096094508498936193e-01 5.54414996743645416277246340541751e-02 1.26896025323238619865462428748515e-03
 	 1.83788630301941036115920269367052e-01 1.18693569421395000995644863905909e-01 2.02907889905697916971272221076106e-03
 	 1.83788630301941036115920269367052e-01 6.97517800276663990644010482355952e-01 2.02907889905697916971272221076106e-03
 	 1.18693569421395000995644863905909e-01 1.83788630301941036115920269367052e-01 2.02907889905697916971272221076106e-03
 	 1.18693569421395000995644863905909e-01 6.97517800276663990644010482355952e-01 2.02907889905697916971272221076106e-03
 	 6.97517800276663990644010482355952e-01 1.83788630301941036115920269367052e-01 2.02907889905697916971272221076106e-03
 	 6.97517800276663990644010482355952e-01 1.18693569421395000995644863905909e-01 2.02907889905697916971272221076106e-03
 	 3.21121524868778346339937002085207e-02 1.39305721718615584114875360910446e-03 1.13321287603745677404105951513458e-04
 	 3.21121524868778346339937002085207e-02 9.66494790295935990442899310437497e-01 1.13321287603745677404105951513458e-04
 	 1.39305721718615584114875360910446e-03 3.21121524868778346339937002085207e-02 1.13321287603745677404105951513458e-04
 	 1.39305721718615584114875360910446e-03 9.66494790295935990442899310437497e-01 1.13321287603745677404105951513458e-04
 	 9.66494790295935990442899310437497e-01 3.21121524868778346339937002085207e-02 1.13321287603745677404105951513458e-04
 	 9.66494790295935990442899310437497e-01 1.39305721718615584114875360910446e-03 1.13321287603745677404105951513458e-04
 	 4.29640722006761482942849283972464e-02 1.02994751818414106286914133647770e-02 3.40926671570748306833165131024543e-04
 	 4.29640722006761482942849283972464e-02 9.46736452617482515670133125240682e-01 3.40926671570748306833165131024543e-04
 	 1.02994751818414106286914133647770e-02 4.29640722006761482942849283972464e-02 3.40926671570748306833165131024543e-04
 	 1.02994751818414106286914133647770e-02 9.46736452617482515670133125240682e-01 3.40926671570748306833165131024543e-04
 	 9.46736452617482515670133125240682e-01 4.29640722006761482942849283972464e-02 3.40926671570748306833165131024543e-04
 	 9.46736452617482515670133125240682e-01 1.02994751818414106286914133647770e-02 3.40926671570748306833165131024543e-04
 	 1.05248427300748837592836437693222e-02 2.58470999228818361717618934392249e-03 9.35465343078011979209562820614110e-05
 	 1.05248427300748837592836437693222e-02 9.86890447277636861933558520831866e-01 9.35465343078011979209562820614110e-05
 	 2.58470999228818361717618934392249e-03 1.05248427300748837592836437693222e-02 9.35465343078011979209562820614110e-05
 	 2.58470999228818361717618934392249e-03 9.86890447277636861933558520831866e-01 9.35465343078011979209562820614110e-05
 	 9.86890447277636861933558520831866e-01 1.05248427300748837592836437693222e-02 9.35465343078011979209562820614110e-05
 	 9.86890447277636861933558520831866e-01 2.58470999228818361717618934392249e-03 9.35465343078011979209562820614110e-05
 	 7.53790285629702960790154975256883e-02 3.94743127161576515260499320447707e-02 8.43314834911866161720750412200687e-04
 	 7.53790285629702960790154975256883e-02 8.85146658720872059333828474336769e-01 8.43314834911866161720750412200687e-04
 	 3.94743127161576515260499320447707e-02 7.53790285629702960790154975256883e-02 8.43314834911866161720750412200687e-04
 	 3.94743127161576515260499320447707e-02 8.85146658720872059333828474336769e-01 8.43314834911866161720750412200687e-04
 	 8.85146658720872059333828474336769e-01 7.53790285629702960790154975256883e-02 8.43314834911866161720750412200687e-04
 	 8.85146658720872059333828474336769e-01 3.94743127161576515260499320447707e-02 8.43314834911866161720750412200687e-04
 	 4.36333362089955989482348286401248e-01 1.22938385245525295258461895286928e-02 9.51274898228950094823674898947274e-04
 	 4.36333362089955989482348286401248e-01 5.51372799385491441093165576603496e-01 9.51274898228950094823674898947274e-04
 	 1.22938385245525295258461895286928e-02 4.36333362089955989482348286401248e-01 9.51274898228950094823674898947274e-04
 	 1.22938385245525295258461895286928e-02 5.51372799385491441093165576603496e-01 9.51274898228950094823674898947274e-04
 	 5.51372799385491441093165576603496e-01 4.36333362089955989482348286401248e-01 9.51274898228950094823674898947274e-04
 	 5.51372799385491441093165576603496e-01 1.22938385245525295258461895286928e-02 9.51274898228950094823674898947274e-04
 	 2.70490746514976954095743622019654e-01 2.58980924784568732402445512263967e-03 3.86683512649890390698581565942504e-04
 	 2.70490746514976954095743622019654e-01 7.26919444237177359013912791851908e-01 3.86683512649890390698581565942504e-04
 	 2.58980924784568732402445512263967e-03 2.70490746514976954095743622019654e-01 3.86683512649890390698581565942504e-04
 	 2.58980924784568732402445512263967e-03 7.26919444237177359013912791851908e-01 3.86683512649890390698581565942504e-04
 	 7.26919444237177359013912791851908e-01 2.70490746514976954095743622019654e-01 3.86683512649890390698581565942504e-04
 	 7.26919444237177359013912791851908e-01 2.58980924784568732402445512263967e-03 3.86683512649890390698581565942504e-04
 	 3.50813643381097384210676182192401e-01 3.75563888722968697297943663215847e-02 1.58619394545012016781160291145625e-03
 	 3.50813643381097384210676182192401e-01 6.11629967746605829326256298372755e-01 1.58619394545012016781160291145625e-03
 	 3.75563888722968697297943663215847e-02 3.50813643381097384210676182192401e-01 1.58619394545012016781160291145625e-03
 	 3.75563888722968697297943663215847e-02 6.11629967746605829326256298372755e-01 1.58619394545012016781160291145625e-03
 	 6.11629967746605829326256298372755e-01 3.50813643381097384210676182192401e-01 1.58619394545012016781160291145625e-03
 	 6.11629967746605829326256298372755e-01 3.75563888722968697297943663215847e-02 1.58619394545012016781160291145625e-03
 	 3.72765511974292140795483874171623e-01 1.70945467207073396875838255937197e-02 1.08426235493087126833533506697904e-03
 	 3.72765511974292140795483874171623e-01 6.10139941305000599314212195167784e-01 1.08426235493087126833533506697904e-03
 	 1.70945467207073396875838255937197e-02 3.72765511974292140795483874171623e-01 1.08426235493087126833533506697904e-03
 	 1.70945467207073396875838255937197e-02 6.10139941305000599314212195167784e-01 1.08426235493087126833533506697904e-03
 	 6.10139941305000599314212195167784e-01 3.72765511974292140795483874171623e-01 1.08426235493087126833533506697904e-03
 	 6.10139941305000599314212195167784e-01 1.70945467207073396875838255937197e-02 1.08426235493087126833533506697904e-03
 	 2.17107352263341546461106190690771e-01 8.57583162943158783253494448217680e-02 2.03705873682035734292816719914754e-03
 	 2.17107352263341546461106190690771e-01 6.97134331442342602969119980116375e-01 2.03705873682035734292816719914754e-03
 	 8.57583162943158783253494448217680e-02 2.17107352263341546461106190690771e-01 2.03705873682035734292816719914754e-03
 	 8.57583162943158783253494448217680e-02 6.97134331442342602969119980116375e-01 2.03705873682035734292816719914754e-03
 	 6.97134331442342602969119980116375e-01 2.17107352263341546461106190690771e-01 2.03705873682035734292816719914754e-03
 	 6.97134331442342602969119980116375e-01 8.57583162943158783253494448217680e-02 2.03705873682035734292816719914754e-03
 	 1.92756365009005836697042468586005e-01 5.79856449641143953388500165146979e-02 1.68604450719807568044583678812387e-03
 	 1.92756365009005836697042468586005e-01 7.49257990026879761025213610992068e-01 1.68604450719807568044583678812387e-03
 	 5.79856449641143953388500165146979e-02 1.92756365009005836697042468586005e-01 1.68604450719807568044583678812387e-03
 	 5.79856449641143953388500165146979e-02 7.49257990026879761025213610992068e-01 1.68604450719807568044583678812387e-03
 	 7.49257990026879761025213610992068e-01 1.92756365009005836697042468586005e-01 1.68604450719807568044583678812387e-03
 	 7.49257990026879761025213610992068e-01 5.79856449641143953388500165146979e-02 1.68604450719807568044583678812387e-03
 	 4.20685030686416272516225944855250e-01 3.38481728829903155686409377267410e-02 1.66873270767465111188987414436724e-03
 	 4.20685030686416272516225944855250e-01 5.45466796430593370281769693974638e-01 1.66873270767465111188987414436724e-03
 	 3.38481728829903155686409377267410e-02 4.20685030686416272516225944855250e-01 1.66873270767465111188987414436724e-03
 	 3.38481728829903155686409377267410e-02 5.45466796430593370281769693974638e-01 1.66873270767465111188987414436724e-03
 	 5.45466796430593370281769693974638e-01 4.20685030686416272516225944855250e-01 1.66873270767465111188987414436724e-03
 	 5.45466796430593370281769693974638e-01 3.38481728829903155686409377267410e-02 1.66873270767465111188987414436724e-03
 	 2.12485185437091050886238008388318e-01 2.52669138520864814539956810790500e-03 3.72150230356113652721572471193667e-04
 	 2.12485185437091050886238008388318e-01 7.84988123177700281019042449770495e-01 3.72150230356113652721572471193667e-04
 	 2.52669138520864814539956810790500e-03 2.12485185437091050886238008388318e-01 3.72150230356113652721572471193667e-04
 	 2.52669138520864814539956810790500e-03 7.84988123177700281019042449770495e-01 3.72150230356113652721572471193667e-04
 	 7.84988123177700281019042449770495e-01 2.12485185437091050886238008388318e-01 3.72150230356113652721572471193667e-04
 	 7.84988123177700281019042449770495e-01 2.52669138520864814539956810790500e-03 3.72150230356113652721572471193667e-04
 	 3.19257208729187336171406741414103e-01 1.06565421155276375542175770760878e-02 8.74502828754643128650325678563604e-04
 	 3.19257208729187336171406741414103e-01 6.70086249155284918721520170947770e-01 8.74502828754643128650325678563604e-04
 	 1.06565421155276375542175770760878e-02 3.19257208729187336171406741414103e-01 8.74502828754643128650325678563604e-04
 	 1.06565421155276375542175770760878e-02 6.70086249155284918721520170947770e-01 8.74502828754643128650325678563604e-04
 	 6.70086249155284918721520170947770e-01 3.19257208729187336171406741414103e-01 8.74502828754643128650325678563604e-04
 	 6.70086249155284918721520170947770e-01 1.06565421155276375542175770760878e-02 8.74502828754643128650325678563604e-04
 	 2.51638235512572583374435453151818e-01 1.34296732422585305549711520711753e-02 9.51584197719013689421851953653686e-04
 	 2.51638235512572583374435453151818e-01 7.34932091245168894744210774661042e-01 9.51584197719013689421851953653686e-04
 	 1.34296732422585305549711520711753e-02 2.51638235512572583374435453151818e-01 9.51584197719013689421851953653686e-04
 	 1.34296732422585305549711520711753e-02 7.34932091245168894744210774661042e-01 9.51584197719013689421851953653686e-04
 	 7.34932091245168894744210774661042e-01 2.51638235512572583374435453151818e-01 9.51584197719013689421851953653686e-04
 	 7.34932091245168894744210774661042e-01 1.34296732422585305549711520711753e-02 9.51584197719013689421851953653686e-04
 	 1.52211981456809364310345245030476e-01 8.83417782932650746952063514072506e-02 1.97907224537829679739120436465782e-03
 	 1.52211981456809364310345245030476e-01 7.59446240249925574872236211376730e-01 1.97907224537829679739120436465782e-03
 	 8.83417782932650746952063514072506e-02 1.52211981456809364310345245030476e-01 1.97907224537829679739120436465782e-03
 	 8.83417782932650746952063514072506e-02 7.59446240249925574872236211376730e-01 1.97907224537829679739120436465782e-03
 	 7.59446240249925574872236211376730e-01 1.52211981456809364310345245030476e-01 1.97907224537829679739120436465782e-03
 	 7.59446240249925574872236211376730e-01 8.83417782932650746952063514072506e-02 1.97907224537829679739120436465782e-03
 	 1.11142094794033280402700825106876e-01 3.29221182111608043352468655484699e-02 1.08166500595875464049711034419943e-03
 	 1.11142094794033280402700825106876e-01 8.55935786994805991589885252324166e-01 1.08166500595875464049711034419943e-03
 	 3.29221182111608043352468655484699e-02 1.11142094794033280402700825106876e-01 1.08166500595875464049711034419943e-03
 	 3.29221182111608043352468655484699e-02 8.55935786994805991589885252324166e-01 1.08166500595875464049711034419943e-03
 	 8.55935786994805991589885252324166e-01 1.11142094794033280402700825106876e-01 1.08166500595875464049711034419943e-03
 	 8.55935786994805991589885252324166e-01 3.29221182111608043352468655484699e-02 1.08166500595875464049711034419943e-03
 	 3.58150058851250285840706055751070e-01 1.94800760777327719441842646119767e-01 3.13337069827091148355169281103372e-03
 	 3.58150058851250285840706055751070e-01 4.47049180371421994717451298129163e-01 3.13337069827091148355169281103372e-03
 	 1.94800760777327719441842646119767e-01 3.58150058851250285840706055751070e-01 3.13337069827091148355169281103372e-03
 	 1.94800760777327719441842646119767e-01 4.47049180371421994717451298129163e-01 3.13337069827091148355169281103372e-03
 	 4.47049180371421994717451298129163e-01 3.58150058851250285840706055751070e-01 3.13337069827091148355169281103372e-03
 	 4.47049180371421994717451298129163e-01 1.94800760777327719441842646119767e-01 3.13337069827091148355169281103372e-03
 	 1.63799856956150069464683838305064e-01 3.14610159618917972768059598820400e-02 1.21573547237640460817742482646509e-03
 	 1.63799856956150069464683838305064e-01 8.04739127081958161014085817441810e-01 1.21573547237640460817742482646509e-03
 	 3.14610159618917972768059598820400e-02 1.63799856956150069464683838305064e-01 1.21573547237640460817742482646509e-03
 	 3.14610159618917972768059598820400e-02 8.04739127081958161014085817441810e-01 1.21573547237640460817742482646509e-03
 	 8.04739127081958161014085817441810e-01 1.63799856956150069464683838305064e-01 1.21573547237640460817742482646509e-03
 	 8.04739127081958161014085817441810e-01 3.14610159618917972768059598820400e-02 1.21573547237640460817742482646509e-03
 	 1.02112773336674317326000505090633e-01 6.73683101645258797240956027962966e-02 1.41328904880122746372250741586640e-03
 	 1.02112773336674317326000505090633e-01 8.30518916498799830705479507741984e-01 1.41328904880122746372250741586640e-03
 	 6.73683101645258797240956027962966e-02 1.02112773336674317326000505090633e-01 1.41328904880122746372250741586640e-03
 	 6.73683101645258797240956027962966e-02 8.30518916498799830705479507741984e-01 1.41328904880122746372250741586640e-03
 	 8.30518916498799830705479507741984e-01 1.02112773336674317326000505090633e-01 1.41328904880122746372250741586640e-03
 	 8.30518916498799830705479507741984e-01 6.73683101645258797240956027962966e-02 1.41328904880122746372250741586640e-03
 	 2.33555703019351579285967090982012e-01 1.86565244199972779526319754950237e-01 3.23767811274164188720114943009776e-03
 	 2.33555703019351579285967090982012e-01 5.79879052780675641187713154067751e-01 3.23767811274164188720114943009776e-03
 	 1.86565244199972779526319754950237e-01 2.33555703019351579285967090982012e-01 3.23767811274164188720114943009776e-03
 	 1.86565244199972779526319754950237e-01 5.79879052780675641187713154067751e-01 3.23767811274164188720114943009776e-03
 	 5.79879052780675641187713154067751e-01 2.33555703019351579285967090982012e-01 3.23767811274164188720114943009776e-03
 	 5.79879052780675641187713154067751e-01 1.86565244199972779526319754950237e-01 3.23767811274164188720114943009776e-03
 	 3.21416462831711324810157748288475e-01 6.38834834123953448914434716243704e-02 2.12424122562709363423727459974089e-03
 	 3.21416462831711324810157748288475e-01 6.14700053755893316420610972272698e-01 2.12424122562709363423727459974089e-03
 	 6.38834834123953448914434716243704e-02 3.21416462831711324810157748288475e-01 2.12424122562709363423727459974089e-03
 	 6.38834834123953448914434716243704e-02 6.14700053755893316420610972272698e-01 2.12424122562709363423727459974089e-03
 	 6.14700053755893316420610972272698e-01 3.21416462831711324810157748288475e-01 2.12424122562709363423727459974089e-03
 	 6.14700053755893316420610972272698e-01 6.38834834123953448914434716243704e-02 2.12424122562709363423727459974089e-03
 	 2.23336184895712552833657582596061e-01 3.25712217949498672453501058043912e-02 1.45504295453112724063882144065474e-03
 	 2.23336184895712552833657582596061e-01 7.44092593309337635432143542857375e-01 1.45504295453112724063882144065474e-03
 	 3.25712217949498672453501058043912e-02 2.23336184895712552833657582596061e-01 1.45504295453112724063882144065474e-03
 	 3.25712217949498672453501058043912e-02 7.44092593309337635432143542857375e-01 1.45504295453112724063882144065474e-03
 	 7.44092593309337635432143542857375e-01 2.23336184895712552833657582596061e-01 1.45504295453112724063882144065474e-03
 	 7.44092593309337635432143542857375e-01 3.25712217949498672453501058043912e-02 1.45504295453112724063882144065474e-03
 	 1.90588118946320272950600838157698e-01 1.32734827561577940074899473188452e-02 8.77197165465703880028736083573904e-04
 	 1.90588118946320272950600838157698e-01 7.96138398297521865387693651427981e-01 8.77197165465703880028736083573904e-04
 	 1.32734827561577940074899473188452e-02 1.90588118946320272950600838157698e-01 8.77197165465703880028736083573904e-04
 	 1.32734827561577940074899473188452e-02 7.96138398297521865387693651427981e-01 8.77197165465703880028736083573904e-04
 	 7.96138398297521865387693651427981e-01 1.90588118946320272950600838157698e-01 8.77197165465703880028736083573904e-04
 	 7.96138398297521865387693651427981e-01 1.32734827561577940074899473188452e-02 8.77197165465703880028736083573904e-04
 	 2.27355840245479501326997251453577e-01 1.36233775509128074432396715565119e-01 2.66390718176628960023322179040406e-03
 	 2.27355840245479501326997251453577e-01 6.36410384245392424240606032981304e-01 2.66390718176628960023322179040406e-03
 	 1.36233775509128074432396715565119e-01 2.27355840245479501326997251453577e-01 2.66390718176628960023322179040406e-03
 	 1.36233775509128074432396715565119e-01 6.36410384245392424240606032981304e-01 2.66390718176628960023322179040406e-03
 	 6.36410384245392424240606032981304e-01 2.27355840245479501326997251453577e-01 2.66390718176628960023322179040406e-03
 	 6.36410384245392424240606032981304e-01 1.36233775509128074432396715565119e-01 2.66390718176628960023322179040406e-03
 	 1.56767922787160035591469409155252e-01 2.61537753388922135366900789676947e-03 3.55867757526690084608766984075601e-04
 	 1.56767922787160035591469409155252e-01 8.40616699678950807239630194089841e-01 3.55867757526690084608766984075601e-04
 	 2.61537753388922135366900789676947e-03 1.56767922787160035591469409155252e-01 3.55867757526690084608766984075601e-04
 	 2.61537753388922135366900789676947e-03 8.40616699678950807239630194089841e-01 3.55867757526690084608766984075601e-04
 	 8.40616699678950807239630194089841e-01 1.56767922787160035591469409155252e-01 3.55867757526690084608766984075601e-04
 	 8.40616699678950807239630194089841e-01 2.61537753388922135366900789676947e-03 3.55867757526690084608766984075601e-04
 	 1.34033334986778468467250036155747e-01 1.34812112051568063625373028457943e-02 7.84259809071718733824996050429945e-04
 	 1.34033334986778468467250036155747e-01 8.52485453808064730374383088928880e-01 7.84259809071718733824996050429945e-04
 	 1.34812112051568063625373028457943e-02 1.34033334986778468467250036155747e-01 7.84259809071718733824996050429945e-04
 	 1.34812112051568063625373028457943e-02 8.52485453808064730374383088928880e-01 7.84259809071718733824996050429945e-04
 	 8.52485453808064730374383088928880e-01 1.34033334986778468467250036155747e-01 7.84259809071718733824996050429945e-04
 	 8.52485453808064730374383088928880e-01 1.34812112051568063625373028457943e-02 7.84259809071718733824996050429945e-04
 	 2.95721175745453590533173837684444e-01 1.91884104352206263932600904809078e-01 3.45484185169266750856098546762496e-03
 	 2.95721175745453590533173837684444e-01 5.12394719902340090023074026248651e-01 3.45484185169266750856098546762496e-03
 	 1.91884104352206263932600904809078e-01 2.95721175745453590533173837684444e-01 3.45484185169266750856098546762496e-03
 	 1.91884104352206263932600904809078e-01 5.12394719902340090023074026248651e-01 3.45484185169266750856098546762496e-03
 	 5.12394719902340090023074026248651e-01 2.95721175745453590533173837684444e-01 3.45484185169266750856098546762496e-03
 	 5.12394719902340090023074026248651e-01 1.91884104352206263932600904809078e-01 3.45484185169266750856098546762496e-03
 	 1.06719271813000365911605626934033e-01 2.54728163216983664179915436420742e-03 3.03883444669208048309616554405466e-04
 	 1.06719271813000365911605626934033e-01 8.90733446554829777497275244968478e-01 3.03883444669208048309616554405466e-04
 	 2.54728163216983664179915436420742e-03 1.06719271813000365911605626934033e-01 3.03883444669208048309616554405466e-04
 	 2.54728163216983664179915436420742e-03 8.90733446554829777497275244968478e-01 3.03883444669208048309616554405466e-04
 	 8.90733446554829777497275244968478e-01 1.06719271813000365911605626934033e-01 3.03883444669208048309616554405466e-04
 	 8.90733446554829777497275244968478e-01 2.54728163216983664179915436420742e-03 3.03883444669208048309616554405466e-04
 	 4.12566419483916535515533041689196e-01 1.01037294355759685315909734981688e-01 2.92995302527590106150823245911852e-03
 	 4.12566419483916535515533041689196e-01 4.86396286160323820801920646772487e-01 2.92995302527590106150823245911852e-03
 	 1.01037294355759685315909734981688e-01 4.12566419483916535515533041689196e-01 2.92995302527590106150823245911852e-03
 	 1.01037294355759685315909734981688e-01 4.86396286160323820801920646772487e-01 2.92995302527590106150823245911852e-03
 	 4.86396286160323820801920646772487e-01 4.12566419483916535515533041689196e-01 2.92995302527590106150823245911852e-03
 	 4.86396286160323820801920646772487e-01 1.01037294355759685315909734981688e-01 2.92995302527590106150823245911852e-03
 	 3.07851982992886075152227931539528e-01 2.49750741165288780987197014837875e-01 3.88259302031484414621798073596892e-03
 	 3.07851982992886075152227931539528e-01 4.42397275841825143860575053622597e-01 3.88259302031484414621798073596892e-03
 	 2.49750741165288780987197014837875e-01 3.07851982992886075152227931539528e-01 3.88259302031484414621798073596892e-03
 	 2.49750741165288780987197014837875e-01 4.42397275841825143860575053622597e-01 3.88259302031484414621798073596892e-03
 	 4.42397275841825143860575053622597e-01 3.07851982992886075152227931539528e-01 3.88259302031484414621798073596892e-03
 	 4.42397275841825143860575053622597e-01 2.49750741165288780987197014837875e-01 3.88259302031484414621798073596892e-03
 	 8.70205486996966370849548866317491e-02 1.37126252885580324908376681491973e-02 6.55020416493056270579309341428598e-04
 	 8.70205486996966370849548866317491e-02 8.99266826011745346036718729010317e-01 6.55020416493056270579309341428598e-04
 	 1.37126252885580324908376681491973e-02 8.70205486996966370849548866317491e-02 6.55020416493056270579309341428598e-04
 	 1.37126252885580324908376681491973e-02 8.99266826011745346036718729010317e-01 6.55020416493056270579309341428598e-04
 	 8.99266826011745346036718729010317e-01 8.70205486996966370849548866317491e-02 6.55020416493056270579309341428598e-04
 	 8.99266826011745346036718729010317e-01 1.37126252885580324908376681491973e-02 6.55020416493056270579309341428598e-04
 	 3.89428331681219708215735408884939e-01 3.34459543340264765787228640192552e-03 5.28548624586135194075575682859380e-04
 	 3.89428331681219708215735408884939e-01 6.07227072885377694433373108040541e-01 5.28548624586135194075575682859380e-04
 	 3.34459543340264765787228640192552e-03 3.89428331681219708215735408884939e-01 5.28548624586135194075575682859380e-04
 	 3.34459543340264765787228640192552e-03 6.07227072885377694433373108040541e-01 5.28548624586135194075575682859380e-04
 	 6.07227072885377694433373108040541e-01 3.89428331681219708215735408884939e-01 5.28548624586135194075575682859380e-04
 	 6.07227072885377694433373108040541e-01 3.34459543340264765787228640192552e-03 5.28548624586135194075575682859380e-04
 	 2.61293970314177004254929670423735e-01 5.56746304306052139376781440205377e-02 2.02059882537530084364862936752161e-03
 	 2.61293970314177004254929670423735e-01 6.83031399255217830379649512906326e-01 2.02059882537530084364862936752161e-03
 	 5.56746304306052139376781440205377e-02 2.61293970314177004254929670423735e-01 2.02059882537530084364862936752161e-03
 	 5.56746304306052139376781440205377e-02 6.83031399255217830379649512906326e-01 2.02059882537530084364862936752161e-03
 	 6.83031399255217830379649512906326e-01 2.61293970314177004254929670423735e-01 2.02059882537530084364862936752161e-03
 	 6.83031399255217830379649512906326e-01 5.56746304306052139376781440205377e-02 2.02059882537530084364862936752161e-03
 	 6.49755331098118837918065082703833e-02 2.80375859354026635977819026379620e-03 2.62123945672969142772767980886783e-04
 	 6.49755331098118837918065082703833e-02 9.32220708296647826429648375778925e-01 2.62123945672969142772767980886783e-04
 	 2.80375859354026635977819026379620e-03 6.49755331098118837918065082703833e-02 2.62123945672969142772767980886783e-04
 	 2.80375859354026635977819026379620e-03 9.32220708296647826429648375778925e-01 2.62123945672969142772767980886783e-04
 	 9.32220708296647826429648375778925e-01 6.49755331098118837918065082703833e-02 2.62123945672969142772767980886783e-04
 	 9.32220708296647826429648375778925e-01 2.80375859354026635977819026379620e-03 2.62123945672969142772767980886783e-04
 	 2.71950006098130969700576997638564e-01 9.63505000772398451092115578830999e-02 2.60243400316005494068982706323823e-03
 	 2.71950006098130969700576997638564e-01 6.31699493824629088045696789777139e-01 2.60243400316005494068982706323823e-03
 	 9.63505000772398451092115578830999e-02 2.71950006098130969700576997638564e-01 2.60243400316005494068982706323823e-03
 	 9.63505000772398451092115578830999e-02 6.31699493824629088045696789777139e-01 2.60243400316005494068982706323823e-03
 	 6.31699493824629088045696789777139e-01 2.71950006098130969700576997638564e-01 2.60243400316005494068982706323823e-03
 	 6.31699493824629088045696789777139e-01 9.63505000772398451092115578830999e-02 2.60243400316005494068982706323823e-03
 	 2.93090364272546199941871236660518e-01 2.91991066004359950403213019853865e-02 1.51665566313493650231480902590420e-03
 	 2.93090364272546199941871236660518e-01 6.77710529127017791140019653539639e-01 1.51665566313493650231480902590420e-03
 	 2.91991066004359950403213019853865e-02 2.93090364272546199941871236660518e-01 1.51665566313493650231480902590420e-03
 	 2.91991066004359950403213019853865e-02 6.77710529127017791140019653539639e-01 1.51665566313493650231480902590420e-03
 	 6.77710529127017791140019653539639e-01 2.93090364272546199941871236660518e-01 1.51665566313493650231480902590420e-03
 	 6.77710529127017791140019653539639e-01 2.91991066004359950403213019853865e-02 1.51665566313493650231480902590420e-03
 	 3.94664826587819206338281219359487e-01 6.35745506621691741644397666277655e-02 2.43427618019893474143877654114476e-03
 	 3.94664826587819206338281219359487e-01 5.41760622750011577863915590569377e-01 2.43427618019893474143877654114476e-03
 	 6.35745506621691741644397666277655e-02 3.94664826587819206338281219359487e-01 2.43427618019893474143877654114476e-03
 	 6.35745506621691741644397666277655e-02 5.41760622750011577863915590569377e-01 2.43427618019893474143877654114476e-03
 	 5.41760622750011577863915590569377e-01 3.94664826587819206338281219359487e-01 2.43427618019893474143877654114476e-03
 	 5.41760622750011577863915590569377e-01 6.35745506621691741644397666277655e-02 2.43427618019893474143877654114476e-03
 	 3.56852218192982795219592162538902e-01 1.43928580065543848531817161529034e-01 3.30143630904448318746924329047943e-03
 	 3.56852218192982795219592162538902e-01 4.99219201741473384004166291560978e-01 3.30143630904448318746924329047943e-03
 	 1.43928580065543848531817161529034e-01 3.56852218192982795219592162538902e-01 3.30143630904448318746924329047943e-03
 	 1.43928580065543848531817161529034e-01 4.99219201741473384004166291560978e-01 3.30143630904448318746924329047943e-03
 	 4.99219201741473384004166291560978e-01 3.56852218192982795219592162538902e-01 3.30143630904448318746924329047943e-03
 	 4.99219201741473384004166291560978e-01 1.43928580065543848531817161529034e-01 3.30143630904448318746924329047943e-03
 	 3.41361351638876264757982426090166e-01 9.92086997532997810766985935515549e-02 2.82656834415620202352603662632191e-03
 	 3.41361351638876264757982426090166e-01 5.59429948607823912531955556914909e-01 2.82656834415620202352603662632191e-03
 	 9.92086997532997810766985935515549e-02 3.41361351638876264757982426090166e-01 2.82656834415620202352603662632191e-03
 	 9.92086997532997810766985935515549e-02 5.59429948607823912531955556914909e-01 2.82656834415620202352603662632191e-03
 	 5.59429948607823912531955556914909e-01 3.41361351638876264757982426090166e-01 2.82656834415620202352603662632191e-03
 	 5.59429948607823912531955556914909e-01 9.92086997532997810766985935515549e-02 2.82656834415620202352603662632191e-03
 	 2.89512941079514585229759404683136e-01 1.40388921421462892213938289387443e-01 3.09596450617196901691774435505522e-03
 	 2.89512941079514585229759404683136e-01 5.70098137499022605823029152816162e-01 3.09596450617196901691774435505522e-03
 	 1.40388921421462892213938289387443e-01 2.89512941079514585229759404683136e-01 3.09596450617196901691774435505522e-03
 	 1.40388921421462892213938289387443e-01 5.70098137499022605823029152816162e-01 3.09596450617196901691774435505522e-03
 	 5.70098137499022605823029152816162e-01 2.89512941079514585229759404683136e-01 3.09596450617196901691774435505522e-03
 	 5.70098137499022605823029152816162e-01 1.40388921421462892213938289387443e-01 3.09596450617196901691774435505522e-03
 	 ];
 
 	 case  43 

 	 % ALG. DEG.:   43
 	 % PTS CARD.:  339
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 4.11780170859933791760454369068611e-01 4.11780170859933791760454369068611e-01 1.53998278459081686456166870868856e-03
 	 4.11780170859933791760454369068611e-01 1.76439658280132416479091261862777e-01 1.53998278459081686456166870868856e-03
 	 1.76439658280132416479091261862777e-01 4.11780170859933791760454369068611e-01 1.53998278459081686456166870868856e-03
 	 4.75575867099131466275707680324558e-01 4.75575867099131466275707680324558e-01 1.24367411012324207385260077529665e-03
 	 4.75575867099131466275707680324558e-01 4.88482658017370674485846393508837e-02 1.24367411012324207385260077529665e-03
 	 4.88482658017370674485846393508837e-02 4.75575867099131466275707680324558e-01 1.24367411012324207385260077529665e-03
 	 4.99179836734477966331269271904603e-01 4.99179836734477966331269271904603e-01 3.04307861090390098426222698080323e-04
 	 4.99179836734477966331269271904603e-01 1.64032653104406733746145619079471e-03 3.04307861090390098426222698080323e-04
 	 1.64032653104406733746145619079471e-03 4.99179836734477966331269271904603e-01 3.04307861090390098426222698080323e-04
 	 2.96247988168869824665563328380813e-01 2.96247988168869824665563328380813e-01 2.93904116687957860792890230072771e-03
 	 2.96247988168869824665563328380813e-01 4.07504023662260350668873343238374e-01 2.93904116687957860792890230072771e-03
 	 4.07504023662260350668873343238374e-01 2.96247988168869824665563328380813e-01 2.93904116687957860792890230072771e-03
 	 3.53188804887000662446894239110406e-01 3.53188804887000662446894239110406e-01 3.43424448325747823027032090692501e-03
 	 3.53188804887000662446894239110406e-01 2.93622390225998675106211521779187e-01 3.43424448325747823027032090692501e-03
 	 2.93622390225998675106211521779187e-01 3.53188804887000662446894239110406e-01 3.43424448325747823027032090692501e-03
 	 4.95105980802769907178628727706382e-01 4.95105980802769907178628727706382e-01 8.07153621957877142993609265175792e-04
 	 4.95105980802769907178628727706382e-01 9.78803839446018564274254458723590e-03 8.07153621957877142993609265175792e-04
 	 9.78803839446018564274254458723590e-03 4.95105980802769907178628727706382e-01 8.07153621957877142993609265175792e-04
 	 3.29098159605345705336354455994297e-02 3.29098159605345705336354455994297e-02 5.41811214635524313054659728550178e-04
 	 3.29098159605345705336354455994297e-02 9.34180368078930900566092532244511e-01 5.41811214635524313054659728550178e-04
 	 9.34180368078930900566092532244511e-01 3.29098159605345705336354455994297e-02 5.41811214635524313054659728550178e-04
 	 4.86563751130688337820373590147938e-01 4.86563751130688337820373590147938e-01 1.35830253414758882375690252075628e-03
 	 4.86563751130688337820373590147938e-01 2.68724977386233243592528197041247e-02 1.35830253414758882375690252075628e-03
 	 2.68724977386233243592528197041247e-02 4.86563751130688337820373590147938e-01 1.35830253414758882375690252075628e-03
 	 6.27150483897616628503612901113229e-02 6.27150483897616628503612901113229e-02 1.01216465227482710874384874699672e-03
 	 6.27150483897616628503612901113229e-02 8.74569903220476674299277419777354e-01 1.01216465227482710874384874699672e-03
 	 8.74569903220476674299277419777354e-01 6.27150483897616628503612901113229e-02 1.01216465227482710874384874699672e-03
 	 1.44743559770221352778207801748067e-01 1.44743559770221352778207801748067e-01 2.12271596053216233396243595166197e-03
 	 1.44743559770221352778207801748067e-01 7.10512880459557294443584396503866e-01 2.12271596053216233396243595166197e-03
 	 7.10512880459557294443584396503866e-01 1.44743559770221352778207801748067e-01 2.12271596053216233396243595166197e-03
 	 1.33646206082615737198437955157715e-02 1.33646206082615737198437955157715e-02 2.36051052789603533306125870971925e-04
 	 1.33646206082615737198437955157715e-02 9.73270758783476797049161177710630e-01 2.36051052789603533306125870971925e-04
 	 9.73270758783476797049161177710630e-01 1.33646206082615737198437955157715e-02 2.36051052789603533306125870971925e-04
 	 2.56494137002013589468618626199259e-03 2.56494137002013589468618626199259e-03 4.28662883399411086867564213420678e-05
 	 2.56494137002013589468618626199259e-03 9.94870117259959774180799740861403e-01 4.28662883399411086867564213420678e-05
 	 9.94870117259959774180799740861403e-01 2.56494137002013589468618626199259e-03 4.28662883399411086867564213420678e-05
 	 1.87772242778578402067068964242935e-01 1.87772242778578402067068964242935e-01 2.66763767119809497990745583706484e-03
 	 1.87772242778578402067068964242935e-01 6.24455514442843195865862071514130e-01 2.66763767119809497990745583706484e-03
 	 6.24455514442843195865862071514130e-01 1.87772242778578402067068964242935e-01 2.66763767119809497990745583706484e-03
 	 3.82564308786935480810598164680414e-01 3.82564308786935480810598164680414e-01 3.47484043452829039280715939241873e-03
 	 3.82564308786935480810598164680414e-01 2.34871382426129038378803670639172e-01 3.47484043452829039280715939241873e-03
 	 2.34871382426129038378803670639172e-01 3.82564308786935480810598164680414e-01 3.47484043452829039280715939241873e-03
 	 4.52892260845951022396604912501061e-01 4.52892260845951022396604912501061e-01 2.66640271020050691891389860188610e-03
 	 4.52892260845951022396604912501061e-01 9.42154783080979552067901749978773e-02 2.66640271020050691891389860188610e-03
 	 9.42154783080979552067901749978773e-02 4.52892260845951022396604912501061e-01 2.66640271020050691891389860188610e-03
 	 9.28670462140478714108127178405994e-02 9.28670462140478714108127178405994e-02 1.64535307292699864781249097234195e-03
 	 9.28670462140478714108127178405994e-02 8.14265907571904312689525795576628e-01 1.64535307292699864781249097234195e-03
 	 8.14265907571904312689525795576628e-01 9.28670462140478714108127178405994e-02 1.64535307292699864781249097234195e-03
 	 2.52484932649090720868656489983550e-01 2.52484932649090720868656489983550e-01 3.65710457156017071725373490664879e-03
 	 2.52484932649090720868656489983550e-01 4.95030134701818558262687020032899e-01 3.65710457156017071725373490664879e-03
 	 4.95030134701818558262687020032899e-01 2.52484932649090720868656489983550e-01 3.65710457156017071725373490664879e-03
 	 2.29739436527249235586722875268606e-01 1.45453795387832596208710356222582e-01 1.95631917040878493957434258732064e-03
 	 2.29739436527249235586722875268606e-01 6.24806768084918084937839921622071e-01 1.95631917040878493957434258732064e-03
 	 1.45453795387832596208710356222582e-01 2.29739436527249235586722875268606e-01 1.95631917040878493957434258732064e-03
 	 1.45453795387832596208710356222582e-01 6.24806768084918084937839921622071e-01 1.95631917040878493957434258732064e-03
 	 6.24806768084918084937839921622071e-01 2.29739436527249235586722875268606e-01 1.95631917040878493957434258732064e-03
 	 6.24806768084918084937839921622071e-01 1.45453795387832596208710356222582e-01 1.95631917040878493957434258732064e-03
 	 3.60558076088783818757832477785996e-01 3.24154748417785493197484925076424e-02 1.32877988603856043124673558253335e-03
 	 3.60558076088783818757832477785996e-01 6.07026449069437590289055606262991e-01 1.32877988603856043124673558253335e-03
 	 3.24154748417785493197484925076424e-02 3.60558076088783818757832477785996e-01 1.32877988603856043124673558253335e-03
 	 3.24154748417785493197484925076424e-02 6.07026449069437590289055606262991e-01 1.32877988603856043124673558253335e-03
 	 6.07026449069437590289055606262991e-01 3.60558076088783818757832477785996e-01 1.32877988603856043124673558253335e-03
 	 6.07026449069437590289055606262991e-01 3.24154748417785493197484925076424e-02 1.32877988603856043124673558253335e-03
 	 9.59172276669436746354691081251076e-02 1.24129082244383796146403042826023e-02 5.20192928808181458133486074757457e-04
 	 9.59172276669436746354691081251076e-02 8.91669864108617926667932351847412e-01 5.20192928808181458133486074757457e-04
 	 1.24129082244383796146403042826023e-02 9.59172276669436746354691081251076e-02 5.20192928808181458133486074757457e-04
 	 1.24129082244383796146403042826023e-02 8.91669864108617926667932351847412e-01 5.20192928808181458133486074757457e-04
 	 8.91669864108617926667932351847412e-01 9.59172276669436746354691081251076e-02 5.20192928808181458133486074757457e-04
 	 8.91669864108617926667932351847412e-01 1.24129082244383796146403042826023e-02 5.20192928808181458133486074757457e-04
 	 1.89801510111088478360841236280976e-01 1.37858117891493076045961174713739e-01 1.93441112276208177986336345099971e-03
 	 1.89801510111088478360841236280976e-01 6.72340371997418473348773204634199e-01 1.93441112276208177986336345099971e-03
 	 1.37858117891493076045961174713739e-01 1.89801510111088478360841236280976e-01 1.93441112276208177986336345099971e-03
 	 1.37858117891493076045961174713739e-01 6.72340371997418473348773204634199e-01 1.93441112276208177986336345099971e-03
 	 6.72340371997418473348773204634199e-01 1.89801510111088478360841236280976e-01 1.93441112276208177986336345099971e-03
 	 6.72340371997418473348773204634199e-01 1.37858117891493076045961174713739e-01 1.93441112276208177986336345099971e-03
 	 4.01058451292605144811176387520391e-01 1.35336131153596217480128416355001e-01 2.71800396079253025680144695286344e-03
 	 4.01058451292605144811176387520391e-01 4.63605417553798582197543964866782e-01 2.71800396079253025680144695286344e-03
 	 1.35336131153596217480128416355001e-01 4.01058451292605144811176387520391e-01 2.71800396079253025680144695286344e-03
 	 1.35336131153596217480128416355001e-01 4.63605417553798582197543964866782e-01 2.71800396079253025680144695286344e-03
 	 4.63605417553798582197543964866782e-01 4.01058451292605144811176387520391e-01 2.71800396079253025680144695286344e-03
 	 4.63605417553798582197543964866782e-01 1.35336131153596217480128416355001e-01 2.71800396079253025680144695286344e-03
 	 2.77582532276102134094486473259167e-01 1.43526791892476662804156717356818e-01 2.56651053850672590181392074271116e-03
 	 2.77582532276102134094486473259167e-01 5.78890675831421286368083656270755e-01 2.56651053850672590181392074271116e-03
 	 1.43526791892476662804156717356818e-01 2.77582532276102134094486473259167e-01 2.56651053850672590181392074271116e-03
 	 1.43526791892476662804156717356818e-01 5.78890675831421286368083656270755e-01 2.56651053850672590181392074271116e-03
 	 5.78890675831421286368083656270755e-01 2.77582532276102134094486473259167e-01 2.56651053850672590181392074271116e-03
 	 5.78890675831421286368083656270755e-01 1.43526791892476662804156717356818e-01 2.56651053850672590181392074271116e-03
 	 3.06118376690335036727219630847685e-01 3.54515915965141689691897397551656e-02 1.36244263020324067083033359182309e-03
 	 3.06118376690335036727219630847685e-01 6.58430031713150842875847956747748e-01 1.36244263020324067083033359182309e-03
 	 3.54515915965141689691897397551656e-02 3.06118376690335036727219630847685e-01 1.36244263020324067083033359182309e-03
 	 3.54515915965141689691897397551656e-02 6.58430031713150842875847956747748e-01 1.36244263020324067083033359182309e-03
 	 6.58430031713150842875847956747748e-01 3.06118376690335036727219630847685e-01 1.36244263020324067083033359182309e-03
 	 6.58430031713150842875847956747748e-01 3.54515915965141689691897397551656e-02 1.36244263020324067083033359182309e-03
 	 4.18289170173424762477765170842758e-01 3.54185331313221704596649885843362e-02 1.54096391385130193456276526120519e-03
 	 4.18289170173424762477765170842758e-01 5.46292296695253032368100321036763e-01 1.54096391385130193456276526120519e-03
 	 3.54185331313221704596649885843362e-02 4.18289170173424762477765170842758e-01 1.54096391385130193456276526120519e-03
 	 3.54185331313221704596649885843362e-02 5.46292296695253032368100321036763e-01 1.54096391385130193456276526120519e-03
 	 5.46292296695253032368100321036763e-01 4.18289170173424762477765170842758e-01 1.54096391385130193456276526120519e-03
 	 5.46292296695253032368100321036763e-01 3.54185331313221704596649885843362e-02 1.54096391385130193456276526120519e-03
 	 9.65099243357523811637221911041706e-02 5.57938681257981461403261391751585e-02 1.09800733044825558383517094540593e-03
 	 9.65099243357523811637221911041706e-02 8.47696207538449542084890708792955e-01 1.09800733044825558383517094540593e-03
 	 5.57938681257981461403261391751585e-02 9.65099243357523811637221911041706e-02 1.09800733044825558383517094540593e-03
 	 5.57938681257981461403261391751585e-02 8.47696207538449542084890708792955e-01 1.09800733044825558383517094540593e-03
 	 8.47696207538449542084890708792955e-01 9.65099243357523811637221911041706e-02 1.09800733044825558383517094540593e-03
 	 8.47696207538449542084890708792955e-01 5.57938681257981461403261391751585e-02 1.09800733044825558383517094540593e-03
 	 1.32839741110529208079071850079345e-01 6.39762347898086281006158060336020e-02 1.35358581459473457930808848459492e-03
 	 1.32839741110529208079071850079345e-01 8.03184024099662163820312343887053e-01 1.35358581459473457930808848459492e-03
 	 6.39762347898086281006158060336020e-02 1.32839741110529208079071850079345e-01 1.35358581459473457930808848459492e-03
 	 6.39762347898086281006158060336020e-02 8.03184024099662163820312343887053e-01 1.35358581459473457930808848459492e-03
 	 8.03184024099662163820312343887053e-01 1.32839741110529208079071850079345e-01 1.35358581459473457930808848459492e-03
 	 8.03184024099662163820312343887053e-01 6.39762347898086281006158060336020e-02 1.35358581459473457930808848459492e-03
 	 9.69643297980663232404907603267930e-02 3.02625797417711110692817300105162e-02 8.86625283151499577784238059763311e-04
 	 9.69643297980663232404907603267930e-02 8.72773090460162492831841518636793e-01 8.86625283151499577784238059763311e-04
 	 3.02625797417711110692817300105162e-02 9.69643297980663232404907603267930e-02 8.86625283151499577784238059763311e-04
 	 3.02625797417711110692817300105162e-02 8.72773090460162492831841518636793e-01 8.86625283151499577784238059763311e-04
 	 8.72773090460162492831841518636793e-01 9.69643297980663232404907603267930e-02 8.86625283151499577784238059763311e-04
 	 8.72773090460162492831841518636793e-01 3.02625797417711110692817300105162e-02 8.86625283151499577784238059763311e-04
 	 4.28753753691012928772607892824453e-01 1.46376163589685189675426713051820e-02 1.05970476604280001119151588540035e-03
 	 4.28753753691012928772607892824453e-01 5.56608629950018585219595479429699e-01 1.05970476604280001119151588540035e-03
 	 1.46376163589685189675426713051820e-02 4.28753753691012928772607892824453e-01 1.05970476604280001119151588540035e-03
 	 1.46376163589685189675426713051820e-02 5.56608629950018585219595479429699e-01 1.05970476604280001119151588540035e-03
 	 5.56608629950018585219595479429699e-01 4.28753753691012928772607892824453e-01 1.05970476604280001119151588540035e-03
 	 5.56608629950018585219595479429699e-01 1.46376163589685189675426713051820e-02 1.05970476604280001119151588540035e-03
 	 1.36853445326083039690345799499482e-01 1.36052509293985018912209739028185e-02 6.91132913699826203698939330877238e-04
 	 1.36853445326083039690345799499482e-01 8.49541303744518527807372265669983e-01 6.91132913699826203698939330877238e-04
 	 1.36052509293985018912209739028185e-02 1.36853445326083039690345799499482e-01 6.91132913699826203698939330877238e-04
 	 1.36052509293985018912209739028185e-02 8.49541303744518527807372265669983e-01 6.91132913699826203698939330877238e-04
 	 8.49541303744518527807372265669983e-01 1.36853445326083039690345799499482e-01 6.91132913699826203698939330877238e-04
 	 8.49541303744518527807372265669983e-01 1.36052509293985018912209739028185e-02 6.91132913699826203698939330877238e-04
 	 3.63561909099252844601579681693693e-01 2.47604062219227219476813672827120e-03 4.14389801137990615789719051065276e-04
 	 3.63561909099252844601579681693693e-01 6.33962050278554900550886941346107e-01 4.14389801137990615789719051065276e-04
 	 2.47604062219227219476813672827120e-03 3.63561909099252844601579681693693e-01 4.14389801137990615789719051065276e-04
 	 2.47604062219227219476813672827120e-03 6.33962050278554900550886941346107e-01 4.14389801137990615789719051065276e-04
 	 6.33962050278554900550886941346107e-01 3.63561909099252844601579681693693e-01 4.14389801137990615789719051065276e-04
 	 6.33962050278554900550886941346107e-01 2.47604062219227219476813672827120e-03 4.14389801137990615789719051065276e-04
 	 3.36143572327619710726764878927497e-01 1.42925973377929421692655864717381e-01 2.88046498518415659134683792785836e-03
 	 3.36143572327619710726764878927497e-01 5.20930454294450839825003640726209e-01 2.88046498518415659134683792785836e-03
 	 1.42925973377929421692655864717381e-01 3.36143572327619710726764878927497e-01 2.88046498518415659134683792785836e-03
 	 1.42925973377929421692655864717381e-01 5.20930454294450839825003640726209e-01 2.88046498518415659134683792785836e-03
 	 5.20930454294450839825003640726209e-01 3.36143572327619710726764878927497e-01 2.88046498518415659134683792785836e-03
 	 5.20930454294450839825003640726209e-01 1.42925973377929421692655864717381e-01 2.88046498518415659134683792785836e-03
 	 9.40988534499003353994694975881430e-02 2.42077774579726101231158530424636e-03 2.43320326789467253044210726109498e-04
 	 9.40988534499003353994694975881430e-02 9.03480368804302380603132860414917e-01 2.43320326789467253044210726109498e-04
 	 2.42077774579726101231158530424636e-03 9.40988534499003353994694975881430e-02 2.43320326789467253044210726109498e-04
 	 2.42077774579726101231158530424636e-03 9.03480368804302380603132860414917e-01 2.43320326789467253044210726109498e-04
 	 9.03480368804302380603132860414917e-01 9.40988534499003353994694975881430e-02 2.43320326789467253044210726109498e-04
 	 9.03480368804302380603132860414917e-01 2.42077774579726101231158530424636e-03 2.43320326789467253044210726109498e-04
 	 2.42710586669900529876997552491957e-01 1.95150339989513393890163683863648e-01 3.03058530224832849836458237291481e-03
 	 2.42710586669900529876997552491957e-01 5.62139073340586103988414379273308e-01 3.03058530224832849836458237291481e-03
 	 1.95150339989513393890163683863648e-01 2.42710586669900529876997552491957e-01 3.03058530224832849836458237291481e-03
 	 1.95150339989513393890163683863648e-01 5.62139073340586103988414379273308e-01 3.03058530224832849836458237291481e-03
 	 5.62139073340586103988414379273308e-01 2.42710586669900529876997552491957e-01 3.03058530224832849836458237291481e-03
 	 5.62139073340586103988414379273308e-01 1.95150339989513393890163683863648e-01 3.03058530224832849836458237291481e-03
 	 4.25238442831057605886257988458965e-01 6.40551018216570233754225682787364e-02 1.97958017650065988893293145167718e-03
 	 4.25238442831057605886257988458965e-01 5.10706455347285315227168212004472e-01 1.97958017650065988893293145167718e-03
 	 6.40551018216570233754225682787364e-02 4.25238442831057605886257988458965e-01 1.97958017650065988893293145167718e-03
 	 6.40551018216570233754225682787364e-02 5.10706455347285315227168212004472e-01 1.97958017650065988893293145167718e-03
 	 5.10706455347285315227168212004472e-01 4.25238442831057605886257988458965e-01 1.97958017650065988893293145167718e-03
 	 5.10706455347285315227168212004472e-01 6.40551018216570233754225682787364e-02 1.97958017650065988893293145167718e-03
 	 3.64278126974187321795994876083569e-01 1.31876112324832255040529815914851e-02 9.75765280742351098601516934394340e-04
 	 3.64278126974187321795994876083569e-01 6.22534261793329490863868613814702e-01 9.75765280742351098601516934394340e-04
 	 1.31876112324832255040529815914851e-02 3.64278126974187321795994876083569e-01 9.75765280742351098601516934394340e-04
 	 1.31876112324832255040529815914851e-02 6.22534261793329490863868613814702e-01 9.75765280742351098601516934394340e-04
 	 6.22534261793329490863868613814702e-01 3.64278126974187321795994876083569e-01 9.75765280742351098601516934394340e-04
 	 6.22534261793329490863868613814702e-01 1.31876112324832255040529815914851e-02 9.75765280742351098601516934394340e-04
 	 1.77663726489636492056334304834309e-01 6.18730821070126515981435488811258e-02 1.58793200978925058870772080155120e-03
 	 1.77663726489636492056334304834309e-01 7.60463191403350835528840434562881e-01 1.58793200978925058870772080155120e-03
 	 6.18730821070126515981435488811258e-02 1.77663726489636492056334304834309e-01 1.58793200978925058870772080155120e-03
 	 6.18730821070126515981435488811258e-02 7.60463191403350835528840434562881e-01 1.58793200978925058870772080155120e-03
 	 7.60463191403350835528840434562881e-01 1.77663726489636492056334304834309e-01 1.58793200978925058870772080155120e-03
 	 7.60463191403350835528840434562881e-01 6.18730821070126515981435488811258e-02 1.58793200978925058870772080155120e-03
 	 5.88456479492050557600357763021748e-02 2.61247234276882700845789919696927e-03 2.08884489201240227621708678285017e-04
 	 5.88456479492050557600357763021748e-02 9.38541879708026050010971630399581e-01 2.08884489201240227621708678285017e-04
 	 2.61247234276882700845789919696927e-03 5.88456479492050557600357763021748e-02 2.08884489201240227621708678285017e-04
 	 2.61247234276882700845789919696927e-03 9.38541879708026050010971630399581e-01 2.08884489201240227621708678285017e-04
 	 9.38541879708026050010971630399581e-01 5.88456479492050557600357763021748e-02 2.08884489201240227621708678285017e-04
 	 9.38541879708026050010971630399581e-01 2.61247234276882700845789919696927e-03 2.08884489201240227621708678285017e-04
 	 2.50099601909829272194940585904988e-01 3.41904035600949715578700249807298e-02 1.40189925650187536577961910921886e-03
 	 2.50099601909829272194940585904988e-01 7.15709994530075777063871100835968e-01 1.40189925650187536577961910921886e-03
 	 3.41904035600949715578700249807298e-02 2.50099601909829272194940585904988e-01 1.40189925650187536577961910921886e-03
 	 3.41904035600949715578700249807298e-02 7.15709994530075777063871100835968e-01 1.40189925650187536577961910921886e-03
 	 7.15709994530075777063871100835968e-01 2.50099601909829272194940585904988e-01 1.40189925650187536577961910921886e-03
 	 7.15709994530075777063871100835968e-01 3.41904035600949715578700249807298e-02 1.40189925650187536577961910921886e-03
 	 3.19725865365346195723361688578734e-02 2.65083133054744551210246683581317e-03 1.53716150062060003802719143628508e-04
 	 3.19725865365346195723361688578734e-02 9.65376582132917993028797809529351e-01 1.53716150062060003802719143628508e-04
 	 2.65083133054744551210246683581317e-03 3.19725865365346195723361688578734e-02 1.53716150062060003802719143628508e-04
 	 2.65083133054744551210246683581317e-03 9.65376582132917993028797809529351e-01 1.53716150062060003802719143628508e-04
 	 9.65376582132917993028797809529351e-01 3.19725865365346195723361688578734e-02 1.53716150062060003802719143628508e-04
 	 9.65376582132917993028797809529351e-01 2.65083133054744551210246683581317e-03 1.53716150062060003802719143628508e-04
 	 2.41723961357679040240498125058366e-01 2.59156908972399966165078843971514e-03 3.79023937257839244312912496681633e-04
 	 2.41723961357679040240498125058366e-01 7.55684469552596937980126767797628e-01 3.79023937257839244312912496681633e-04
 	 2.59156908972399966165078843971514e-03 2.41723961357679040240498125058366e-01 3.79023937257839244312912496681633e-04
 	 2.59156908972399966165078843971514e-03 7.55684469552596937980126767797628e-01 3.79023937257839244312912496681633e-04
 	 7.55684469552596937980126767797628e-01 2.41723961357679040240498125058366e-01 3.79023937257839244312912496681633e-04
 	 7.55684469552596937980126767797628e-01 2.59156908972399966165078843971514e-03 3.79023937257839244312912496681633e-04
 	 1.84404707439201814844764726331050e-01 1.42733464909807362258620244688245e-02 8.14280093595709324703901810238449e-04
 	 1.84404707439201814844764726331050e-01 8.01321946069817436786308917362476e-01 8.14280093595709324703901810238449e-04
 	 1.42733464909807362258620244688245e-02 1.84404707439201814844764726331050e-01 8.14280093595709324703901810238449e-04
 	 1.42733464909807362258620244688245e-02 8.01321946069817436786308917362476e-01 8.14280093595709324703901810238449e-04
 	 8.01321946069817436786308917362476e-01 1.84404707439201814844764726331050e-01 8.14280093595709324703901810238449e-04
 	 8.01321946069817436786308917362476e-01 1.42733464909807362258620244688245e-02 8.14280093595709324703901810238449e-04
 	 6.12563890152719517367962964726757e-02 1.38564076854345488015729515041130e-02 5.00790757565847816090709443415108e-04
 	 6.12563890152719517367962964726757e-02 9.24887203299293525482482891675318e-01 5.00790757565847816090709443415108e-04
 	 1.38564076854345488015729515041130e-02 6.12563890152719517367962964726757e-02 5.00790757565847816090709443415108e-04
 	 1.38564076854345488015729515041130e-02 9.24887203299293525482482891675318e-01 5.00790757565847816090709443415108e-04
 	 9.24887203299293525482482891675318e-01 6.12563890152719517367962964726757e-02 5.00790757565847816090709443415108e-04
 	 9.24887203299293525482482891675318e-01 1.38564076854345488015729515041130e-02 5.00790757565847816090709443415108e-04
 	 1.32571416922718544884052249699380e-02 2.49382626599786065904607035292884e-03 9.48517546105485443753979613035199e-05
 	 1.32571416922718544884052249699380e-02 9.84249032041730309572358237346634e-01 9.48517546105485443753979613035199e-05
 	 2.49382626599786065904607035292884e-03 1.32571416922718544884052249699380e-02 9.48517546105485443753979613035199e-05
 	 2.49382626599786065904607035292884e-03 9.84249032041730309572358237346634e-01 9.48517546105485443753979613035199e-05
 	 9.84249032041730309572358237346634e-01 1.32571416922718544884052249699380e-02 9.48517546105485443753979613035199e-05
 	 9.84249032041730309572358237346634e-01 2.49382626599786065904607035292884e-03 9.48517546105485443753979613035199e-05
 	 1.37973140081455225569584399636369e-01 1.00440931058371943351836819147138e-01 1.96129685941321589906505273859239e-03
 	 1.37973140081455225569584399636369e-01 7.61585928860172844956366589030949e-01 1.96129685941321589906505273859239e-03
 	 1.00440931058371943351836819147138e-01 1.37973140081455225569584399636369e-01 1.96129685941321589906505273859239e-03
 	 1.00440931058371943351836819147138e-01 7.61585928860172844956366589030949e-01 1.96129685941321589906505273859239e-03
 	 7.61585928860172844956366589030949e-01 1.37973140081455225569584399636369e-01 1.96129685941321589906505273859239e-03
 	 7.61585928860172844956366589030949e-01 1.00440931058371943351836819147138e-01 1.96129685941321589906505273859239e-03
 	 3.32056799273112990267264876820263e-02 1.36974423527236825043340573415662e-02 3.67632224535556766543270557079381e-04
 	 3.32056799273112990267264876820263e-02 9.53096877719965096531495873932727e-01 3.67632224535556766543270557079381e-04
 	 1.36974423527236825043340573415662e-02 3.32056799273112990267264876820263e-02 3.67632224535556766543270557079381e-04
 	 1.36974423527236825043340573415662e-02 9.53096877719965096531495873932727e-01 3.67632224535556766543270557079381e-04
 	 9.53096877719965096531495873932727e-01 3.32056799273112990267264876820263e-02 3.67632224535556766543270557079381e-04
 	 9.53096877719965096531495873932727e-01 1.36974423527236825043340573415662e-02 3.67632224535556766543270557079381e-04
 	 1.94466196781106465119037807198765e-01 3.41431958895440298973333881349390e-02 1.31387504913329416014744488450106e-03
 	 1.94466196781106465119037807198765e-01 7.71390607329349498044734900759067e-01 1.31387504913329416014744488450106e-03
 	 3.41431958895440298973333881349390e-02 1.94466196781106465119037807198765e-01 1.31387504913329416014744488450106e-03
 	 3.41431958895440298973333881349390e-02 7.71390607329349498044734900759067e-01 1.31387504913329416014744488450106e-03
 	 7.71390607329349498044734900759067e-01 1.94466196781106465119037807198765e-01 1.31387504913329416014744488450106e-03
 	 7.71390607329349498044734900759067e-01 3.41431958895440298973333881349390e-02 1.31387504913329416014744488450106e-03
 	 2.39482635085204537128689139535709e-01 1.38046252946412654344365833480879e-02 9.20816959513956543974255719575694e-04
 	 2.39482635085204537128689139535709e-01 7.46712739620154275499430696072523e-01 9.20816959513956543974255719575694e-04
 	 1.38046252946412654344365833480879e-02 2.39482635085204537128689139535709e-01 9.20816959513956543974255719575694e-04
 	 1.38046252946412654344365833480879e-02 7.46712739620154275499430696072523e-01 9.20816959513956543974255719575694e-04
 	 7.46712739620154275499430696072523e-01 2.39482635085204537128689139535709e-01 9.20816959513956543974255719575694e-04
 	 7.46712739620154275499430696072523e-01 1.38046252946412654344365833480879e-02 9.20816959513956543974255719575694e-04
 	 3.64554227776340777911201485039783e-01 1.86497214299555097438698680889502e-01 2.96251638633688099688789918673137e-03
 	 3.64554227776340777911201485039783e-01 4.48948557924104152405675449699629e-01 2.96251638633688099688789918673137e-03
 	 1.86497214299555097438698680889502e-01 3.64554227776340777911201485039783e-01 2.96251638633688099688789918673137e-03
 	 1.86497214299555097438698680889502e-01 4.48948557924104152405675449699629e-01 2.96251638633688099688789918673137e-03
 	 4.48948557924104152405675449699629e-01 3.64554227776340777911201485039783e-01 2.96251638633688099688789918673137e-03
 	 4.48948557924104152405675449699629e-01 1.86497214299555097438698680889502e-01 2.96251638633688099688789918673137e-03
 	 1.37356402366199809028657341514190e-01 2.54175936468376819851733294797214e-03 3.06169420407145201519505395282295e-04
 	 1.37356402366199809028657341514190e-01 8.60101838269116347746034989540931e-01 3.06169420407145201519505395282295e-04
 	 2.54175936468376819851733294797214e-03 1.37356402366199809028657341514190e-01 3.06169420407145201519505395282295e-04
 	 2.54175936468376819851733294797214e-03 8.60101838269116347746034989540931e-01 3.06169420407145201519505395282295e-04
 	 8.60101838269116347746034989540931e-01 1.37356402366199809028657341514190e-01 3.06169420407145201519505395282295e-04
 	 8.60101838269116347746034989540931e-01 2.54175936468376819851733294797214e-03 3.06169420407145201519505395282295e-04
 	 2.32232037318890388588599194008566e-01 6.30349337046809815587877778852999e-02 1.91248172423942944253560938250303e-03
 	 2.32232037318890388588599194008566e-01 7.04733028976428643730400835920591e-01 1.91248172423942944253560938250303e-03
 	 6.30349337046809815587877778852999e-02 2.32232037318890388588599194008566e-01 1.91248172423942944253560938250303e-03
 	 6.30349337046809815587877778852999e-02 7.04733028976428643730400835920591e-01 1.91248172423942944253560938250303e-03
 	 7.04733028976428643730400835920591e-01 2.32232037318890388588599194008566e-01 1.91248172423942944253560938250303e-03
 	 7.04733028976428643730400835920591e-01 6.30349337046809815587877778852999e-02 1.91248172423942944253560938250303e-03
 	 2.92661395072246866000398313190090e-01 6.38769125793660075274260634614620e-02 2.06415161110312878403605374444396e-03
 	 2.92661395072246866000398313190090e-01 6.43461692348387126472175623348448e-01 2.06415161110312878403605374444396e-03
 	 6.38769125793660075274260634614620e-02 2.92661395072246866000398313190090e-01 2.06415161110312878403605374444396e-03
 	 6.38769125793660075274260634614620e-02 6.43461692348387126472175623348448e-01 2.06415161110312878403605374444396e-03
 	 6.43461692348387126472175623348448e-01 2.92661395072246866000398313190090e-01 2.06415161110312878403605374444396e-03
 	 6.43461692348387126472175623348448e-01 6.38769125793660075274260634614620e-02 2.06415161110312878403605374444396e-03
 	 3.17648116398156710182831830024952e-01 2.41952845175475161898503984048148e-01 3.34601602087061583343241544241664e-03
 	 3.17648116398156710182831830024952e-01 4.40399038426368127918664185926900e-01 3.34601602087061583343241544241664e-03
 	 2.41952845175475161898503984048148e-01 3.17648116398156710182831830024952e-01 3.34601602087061583343241544241664e-03
 	 2.41952845175475161898503984048148e-01 4.40399038426368127918664185926900e-01 3.34601602087061583343241544241664e-03
 	 4.40399038426368127918664185926900e-01 3.17648116398156710182831830024952e-01 3.34601602087061583343241544241664e-03
 	 4.40399038426368127918664185926900e-01 2.41952845175475161898503984048148e-01 3.34601602087061583343241544241664e-03
 	 3.00301596615778321197609557202668e-01 1.45992712589763495162342721300774e-02 1.02364147369649050034468018566258e-03
 	 3.00301596615778321197609557202668e-01 6.85099132125245424695947349391645e-01 1.02364147369649050034468018566258e-03
 	 1.45992712589763495162342721300774e-02 3.00301596615778321197609557202668e-01 1.02364147369649050034468018566258e-03
 	 1.45992712589763495162342721300774e-02 6.85099132125245424695947349391645e-01 1.02364147369649050034468018566258e-03
 	 6.85099132125245424695947349391645e-01 3.00301596615778321197609557202668e-01 1.02364147369649050034468018566258e-03
 	 6.85099132125245424695947349391645e-01 1.45992712589763495162342721300774e-02 1.02364147369649050034468018566258e-03
 	 3.00561353716810975011952677959925e-01 2.81811459692608715435491184564398e-03 4.39007839582545515266093216766308e-04
 	 3.00561353716810975011952677959925e-01 6.96620531686262922654861995397368e-01 4.39007839582545515266093216766308e-04
 	 2.81811459692608715435491184564398e-03 3.00561353716810975011952677959925e-01 4.39007839582545515266093216766308e-04
 	 2.81811459692608715435491184564398e-03 6.96620531686262922654861995397368e-01 4.39007839582545515266093216766308e-04
 	 6.96620531686262922654861995397368e-01 3.00561353716810975011952677959925e-01 4.39007839582545515266093216766308e-04
 	 6.96620531686262922654861995397368e-01 2.81811459692608715435491184564398e-03 4.39007839582545515266093216766308e-04
 	 6.05239793987312202361295021546539e-02 3.41344995593797426169935249617993e-02 7.88892559272939180095574052131724e-04
 	 6.05239793987312202361295021546539e-02 9.05341521041889030207983068976318e-01 7.88892559272939180095574052131724e-04
 	 3.41344995593797426169935249617993e-02 6.05239793987312202361295021546539e-02 7.88892559272939180095574052131724e-04
 	 3.41344995593797426169935249617993e-02 9.05341521041889030207983068976318e-01 7.88892559272939180095574052131724e-04
 	 9.05341521041889030207983068976318e-01 6.05239793987312202361295021546539e-02 7.88892559272939180095574052131724e-04
 	 9.05341521041889030207983068976318e-01 3.41344995593797426169935249617993e-02 7.88892559272939180095574052131724e-04
 	 3.00785919233889365020928607918904e-01 1.93355477276418330490059815929271e-01 3.15371795549420404908280701761214e-03
 	 3.00785919233889365020928607918904e-01 5.05858603489692360000162807409652e-01 3.15371795549420404908280701761214e-03
 	 1.93355477276418330490059815929271e-01 3.00785919233889365020928607918904e-01 3.15371795549420404908280701761214e-03
 	 1.93355477276418330490059815929271e-01 5.05858603489692360000162807409652e-01 3.15371795549420404908280701761214e-03
 	 5.05858603489692360000162807409652e-01 3.00785919233889365020928607918904e-01 3.15371795549420404908280701761214e-03
 	 5.05858603489692360000162807409652e-01 1.93355477276418330490059815929271e-01 3.15371795549420404908280701761214e-03
 	 1.89550703977685197632041536053293e-01 9.73629697501508795109970151315792e-02 2.13631991052658405660924501034970e-03
 	 1.89550703977685197632041536053293e-01 7.13086326272163950612537064444041e-01 2.13631991052658405660924501034970e-03
 	 9.73629697501508795109970151315792e-02 1.89550703977685197632041536053293e-01 2.13631991052658405660924501034970e-03
 	 9.73629697501508795109970151315792e-02 7.13086326272163950612537064444041e-01 2.13631991052658405660924501034970e-03
 	 7.13086326272163950612537064444041e-01 1.89550703977685197632041536053293e-01 2.13631991052658405660924501034970e-03
 	 7.13086326272163950612537064444041e-01 9.73629697501508795109970151315792e-02 2.13631991052658405660924501034970e-03
 	 4.30139903362148912080442642036360e-01 2.78830240511142692441670654091013e-03 4.84918673119630056888434976869462e-04
 	 4.30139903362148912080442642036360e-01 5.67071794232739678776056280185003e-01 4.84918673119630056888434976869462e-04
 	 2.78830240511142692441670654091013e-03 4.30139903362148912080442642036360e-01 4.84918673119630056888434976869462e-04
 	 2.78830240511142692441670654091013e-03 5.67071794232739678776056280185003e-01 4.84918673119630056888434976869462e-04
 	 5.67071794232739678776056280185003e-01 4.30139903362148912080442642036360e-01 4.84918673119630056888434976869462e-04
 	 5.67071794232739678776056280185003e-01 2.78830240511142692441670654091013e-03 4.84918673119630056888434976869462e-04
 	 1.87018572217664685863880436045292e-01 2.75596244648371960922483836498031e-03 3.69009135228931571884314344345057e-04
 	 1.87018572217664685863880436045292e-01 8.10225465335851602333150367485359e-01 3.69009135228931571884314344345057e-04
 	 2.75596244648371960922483836498031e-03 1.87018572217664685863880436045292e-01 3.69009135228931571884314344345057e-04
 	 2.75596244648371960922483836498031e-03 8.10225465335851602333150367485359e-01 3.69009135228931571884314344345057e-04
 	 8.10225465335851602333150367485359e-01 1.87018572217664685863880436045292e-01 3.69009135228931571884314344345057e-04
 	 8.10225465335851602333150367485359e-01 2.75596244648371960922483836498031e-03 3.69009135228931571884314344345057e-04
 	 3.79189522509007448380913274377235e-01 9.78271071588677626484908955717401e-02 2.63094068006375966101151320231111e-03
 	 3.79189522509007448380913274377235e-01 5.22983370332124830603959253494395e-01 2.63094068006375966101151320231111e-03
 	 9.78271071588677626484908955717401e-02 3.79189522509007448380913274377235e-01 2.63094068006375966101151320231111e-03
 	 9.78271071588677626484908955717401e-02 5.22983370332124830603959253494395e-01 2.63094068006375966101151320231111e-03
 	 5.22983370332124830603959253494395e-01 3.79189522509007448380913274377235e-01 2.63094068006375966101151320231111e-03
 	 5.22983370332124830603959253494395e-01 9.78271071588677626484908955717401e-02 2.63094068006375966101151320231111e-03
 	 3.12966976982159250653126036922913e-01 9.95736856368709677411743541597389e-02 2.65013598749912638458114955142264e-03
 	 3.12966976982159250653126036922913e-01 5.87459337380969781605699608917348e-01 2.65013598749912638458114955142264e-03
 	 9.95736856368709677411743541597389e-02 3.12966976982159250653126036922913e-01 2.65013598749912638458114955142264e-03
 	 9.95736856368709677411743541597389e-02 5.87459337380969781605699608917348e-01 2.65013598749912638458114955142264e-03
 	 5.87459337380969781605699608917348e-01 3.12966976982159250653126036922913e-01 2.65013598749912638458114955142264e-03
 	 5.87459337380969781605699608917348e-01 9.95736856368709677411743541597389e-02 2.65013598749912638458114955142264e-03
 	 1.41804487017288982642071459849831e-01 3.41143516662648707549188031862286e-02 1.22790050513958497700739425084748e-03
 	 1.41804487017288982642071459849831e-01 8.24081161316446153541903640871169e-01 1.22790050513958497700739425084748e-03
 	 3.41143516662648707549188031862286e-02 1.41804487017288982642071459849831e-01 1.22790050513958497700739425084748e-03
 	 3.41143516662648707549188031862286e-02 8.24081161316446153541903640871169e-01 1.22790050513958497700739425084748e-03
 	 8.24081161316446153541903640871169e-01 1.41804487017288982642071459849831e-01 1.22790050513958497700739425084748e-03
 	 8.24081161316446153541903640871169e-01 3.41143516662648707549188031862286e-02 1.22790050513958497700739425084748e-03
 	 2.48181460015588495338079155771993e-01 1.00497443272928421720280312001705e-01 2.52780519757884276563220105060736e-03
 	 2.48181460015588495338079155771993e-01 6.51321096711483082941640532226302e-01 2.52780519757884276563220105060736e-03
 	 1.00497443272928421720280312001705e-01 2.48181460015588495338079155771993e-01 2.52780519757884276563220105060736e-03
 	 1.00497443272928421720280312001705e-01 6.51321096711483082941640532226302e-01 2.52780519757884276563220105060736e-03
 	 6.51321096711483082941640532226302e-01 2.48181460015588495338079155771993e-01 2.52780519757884276563220105060736e-03
 	 6.51321096711483082941640532226302e-01 1.00497443272928421720280312001705e-01 2.52780519757884276563220105060736e-03
 	 3.58797835407998699785991902899696e-01 6.16738036965516905896222965566267e-02 2.21709548456510601235902591099602e-03
 	 3.58797835407998699785991902899696e-01 5.79528360895449567991022377100307e-01 2.21709548456510601235902591099602e-03
 	 6.16738036965516905896222965566267e-02 3.58797835407998699785991902899696e-01 2.21709548456510601235902591099602e-03
 	 6.16738036965516905896222965566267e-02 5.79528360895449567991022377100307e-01 2.21709548456510601235902591099602e-03
 	 5.79528360895449567991022377100307e-01 3.58797835407998699785991902899696e-01 2.21709548456510601235902591099602e-03
 	 5.79528360895449567991022377100307e-01 6.16738036965516905896222965566267e-02 2.21709548456510601235902591099602e-03
 	 ];
 
 	 case  44 

 	 % ALG. DEG.:   44
 	 % PTS CARD.:  354
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw=[
 	 1.71230757996369982974760315386220e-03 1.71230757996369982974760315386220e-03 2.21520454570737307072644112215798e-05
 	 1.71230757996369982974760315386220e-03 9.96575384840072575620695261022775e-01 2.21520454570737307072644112215798e-05
 	 9.96575384840072575620695261022775e-01 1.71230757996369982974760315386220e-03 2.21520454570737307072644112215798e-05
 	 2.91673514653004867236418817810772e-02 2.91673514653004867236418817810772e-02 5.61488691411857524481143766337254e-04
 	 2.91673514653004867236418817810772e-02 9.41665297069399054308291852066759e-01 5.61488691411857524481143766337254e-04
 	 9.41665297069399054308291852066759e-01 2.91673514653004867236418817810772e-02 5.61488691411857524481143766337254e-04
 	 4.95499879123024178362300062872237e-02 4.95499879123024178362300062872237e-02 8.72575782766472408426283724480754e-04
 	 4.95499879123024178362300062872237e-02 9.00900024175395164327539987425553e-01 8.72575782766472408426283724480754e-04
 	 9.00900024175395164327539987425553e-01 4.95499879123024178362300062872237e-02 8.72575782766472408426283724480754e-04
 	 4.87723980583153360335302295425208e-01 4.87723980583153360335302295425208e-01 1.36482635824496534998617747191929e-03
 	 4.87723980583153360335302295425208e-01 2.45520388336932793293954091495834e-02 1.36482635824496534998617747191929e-03
 	 2.45520388336932793293954091495834e-02 4.87723980583153360335302295425208e-01 1.36482635824496534998617747191929e-03
 	 4.96061804465474931458146556906286e-01 4.96061804465474931458146556906286e-01 6.02253006705961600394938493252539e-04
 	 4.96061804465474931458146556906286e-01 7.87639106905013708370688618742861e-03 6.02253006705961600394938493252539e-04
 	 7.87639106905013708370688618742861e-03 4.96061804465474931458146556906286e-01 6.02253006705961600394938493252539e-04
 	 7.65961156051737368510856640568818e-02 7.65961156051737368510856640568818e-02 1.18289665538962355216534572122100e-03
 	 7.65961156051737368510856640568818e-02 8.46807768789652470786677440628409e-01 1.18289665538962355216534572122100e-03
 	 8.46807768789652470786677440628409e-01 7.65961156051737368510856640568818e-02 1.18289665538962355216534572122100e-03
 	 4.75951846052771243567036663080216e-01 4.75951846052771243567036663080216e-01 1.75559713417060541534864270829530e-03
 	 4.75951846052771243567036663080216e-01 4.80963078944575128659266738395672e-02 1.75559713417060541534864270829530e-03
 	 4.80963078944575128659266738395672e-02 4.75951846052771243567036663080216e-01 1.75559713417060541534864270829530e-03
 	 1.09095541957237654462353759754478e-01 1.09095541957237654462353759754478e-01 1.47173402359788551424513158849550e-03
 	 1.09095541957237654462353759754478e-01 7.81808916085524718830868096119957e-01 1.47173402359788551424513158849550e-03
 	 7.81808916085524718830868096119957e-01 1.09095541957237654462353759754478e-01 1.47173402359788551424513158849550e-03
 	 2.31247003693840935678593950797222e-01 2.31247003693840935678593950797222e-01 3.36162144923654376479915661946052e-03
 	 2.31247003693840935678593950797222e-01 5.37505992612318128642812098405557e-01 3.36162144923654376479915661946052e-03
 	 5.37505992612318128642812098405557e-01 2.31247003693840935678593950797222e-01 3.36162144923654376479915661946052e-03
 	 1.95908198223650492630909525360039e-01 1.95908198223650492630909525360039e-01 2.48992940625945846644384573664865e-03
 	 1.95908198223650492630909525360039e-01 6.08183603552699070249332180537749e-01 2.48992940625945846644384573664865e-03
 	 6.08183603552699070249332180537749e-01 1.95908198223650492630909525360039e-01 2.48992940625945846644384573664865e-03
 	 4.22321808207151372371868092159275e-01 4.22321808207151372371868092159275e-01 2.46041862262338191166821665945008e-03
 	 4.22321808207151372371868092159275e-01 1.55356383585697255256263815681450e-01 2.46041862262338191166821665945008e-03
 	 1.55356383585697255256263815681450e-01 4.22321808207151372371868092159275e-01 2.46041862262338191166821665945008e-03
 	 4.54881749959505921054869759245776e-01 4.54881749959505921054869759245776e-01 2.51073751429879829175084715586763e-03
 	 4.54881749959505921054869759245776e-01 9.02365000809881578902604815084487e-02 2.51073751429879829175084715586763e-03
 	 9.02365000809881578902604815084487e-02 4.54881749959505921054869759245776e-01 2.51073751429879829175084715586763e-03
 	 1.43900119540420812214165380282793e-01 1.43900119540420812214165380282793e-01 2.22329662038065400606057231414070e-03
 	 1.43900119540420812214165380282793e-01 7.12199760919158375571669239434414e-01 2.22329662038065400606057231414070e-03
 	 7.12199760919158375571669239434414e-01 1.43900119540420812214165380282793e-01 2.22329662038065400606057231414070e-03
 	 4.02340447854735383526048053681734e-01 4.02340447854735383526048053681734e-01 2.32330638229219987520024481852943e-03
 	 4.02340447854735383526048053681734e-01 1.95319104290529232947903892636532e-01 2.32330638229219987520024481852943e-03
 	 1.95319104290529232947903892636532e-01 4.02340447854735383526048053681734e-01 2.32330638229219987520024481852943e-03
 	 2.94295765690833932559655750083039e-01 2.94295765690833932559655750083039e-01 3.21273602508716097161944880156170e-03
 	 2.94295765690833932559655750083039e-01 4.11408468618332134880688499833923e-01 3.21273602508716097161944880156170e-03
 	 4.11408468618332134880688499833923e-01 2.94295765690833932559655750083039e-01 3.21273602508716097161944880156170e-03
 	 3.51615788795768935415253508836031e-01 3.51615788795768935415253508836031e-01 3.13279394181341245065319789375735e-03
 	 3.51615788795768935415253508836031e-01 2.96768422408462129169492982327938e-01 3.13279394181341245065319789375735e-03
 	 2.96768422408462129169492982327938e-01 3.51615788795768935415253508836031e-01 3.13279394181341245065319789375735e-03
 	 1.97551676157197361738404595143948e-02 1.07567195566842938037055432687339e-02 2.05987823218478822723948029604912e-04
 	 1.97551676157197361738404595143948e-02 9.69488112827595949205772285495186e-01 2.05987823218478822723948029604912e-04
 	 1.07567195566842938037055432687339e-02 1.97551676157197361738404595143948e-02 2.05987823218478822723948029604912e-04
 	 1.07567195566842938037055432687339e-02 9.69488112827595949205772285495186e-01 2.05987823218478822723948029604912e-04
 	 9.69488112827595949205772285495186e-01 1.97551676157197361738404595143948e-02 2.05987823218478822723948029604912e-04
 	 9.69488112827595949205772285495186e-01 1.07567195566842938037055432687339e-02 2.05987823218478822723948029604912e-04
 	 9.95165813818446182148491629959608e-02 7.80585899861933429737248513191616e-04 1.36620423001840941628834413812399e-04
 	 9.95165813818446182148491629959608e-02 8.99702832718293432634482087451033e-01 1.36620423001840941628834413812399e-04
 	 7.80585899861933429737248513191616e-04 9.95165813818446182148491629959608e-02 1.36620423001840941628834413812399e-04
 	 7.80585899861933429737248513191616e-04 8.99702832718293432634482087451033e-01 1.36620423001840941628834413812399e-04
 	 8.99702832718293432634482087451033e-01 9.95165813818446182148491629959608e-02 1.36620423001840941628834413812399e-04
 	 8.99702832718293432634482087451033e-01 7.80585899861933429737248513191616e-04 1.36620423001840941628834413812399e-04
 	 1.53494544755213874198673806859006e-01 1.93833291279059036736620580398949e-03 2.69664221964948346010881863321629e-04
 	 1.53494544755213874198673806859006e-01 8.44567122331995601136611639958574e-01 2.69664221964948346010881863321629e-04
 	 1.93833291279059036736620580398949e-03 1.53494544755213874198673806859006e-01 2.69664221964948346010881863321629e-04
 	 1.93833291279059036736620580398949e-03 8.44567122331995601136611639958574e-01 2.69664221964948346010881863321629e-04
 	 8.44567122331995601136611639958574e-01 1.53494544755213874198673806859006e-01 2.69664221964948346010881863321629e-04
 	 8.44567122331995601136611639958574e-01 1.93833291279059036736620580398949e-03 2.69664221964948346010881863321629e-04
 	 4.60607452003998885103897009685170e-01 1.78614248052541058943420981819372e-03 3.35489485291019079969687677333923e-04
 	 4.60607452003998885103897009685170e-01 5.37606405515475671563763171434402e-01 3.35489485291019079969687677333923e-04
 	 1.78614248052541058943420981819372e-03 4.60607452003998885103897009685170e-01 3.35489485291019079969687677333923e-04
 	 1.78614248052541058943420981819372e-03 5.37606405515475671563763171434402e-01 3.35489485291019079969687677333923e-04
 	 5.37606405515475671563763171434402e-01 4.60607452003998885103897009685170e-01 3.35489485291019079969687677333923e-04
 	 5.37606405515475671563763171434402e-01 1.78614248052541058943420981819372e-03 3.35489485291019079969687677333923e-04
 	 2.96420604264443915409898977486591e-02 1.75422517105275517501628002037251e-03 1.12965768056969912335948946768838e-04
 	 2.96420604264443915409898977486591e-02 9.68603714402502924407656337280059e-01 1.12965768056969912335948946768838e-04
 	 1.75422517105275517501628002037251e-03 2.96420604264443915409898977486591e-02 1.12965768056969912335948946768838e-04
 	 1.75422517105275517501628002037251e-03 9.68603714402502924407656337280059e-01 1.12965768056969912335948946768838e-04
 	 9.68603714402502924407656337280059e-01 2.96420604264443915409898977486591e-02 1.12965768056969912335948946768838e-04
 	 9.68603714402502924407656337280059e-01 1.75422517105275517501628002037251e-03 1.12965768056969912335948946768838e-04
 	 3.33840624824811804671753634465858e-01 5.17294259660069986710151379583067e-04 1.61033154709168695086635159086086e-04
 	 3.33840624824811804671753634465858e-01 6.65642080915528122631030782940798e-01 1.61033154709168695086635159086086e-04
 	 5.17294259660069986710151379583067e-04 3.33840624824811804671753634465858e-01 1.61033154709168695086635159086086e-04
 	 5.17294259660069986710151379583067e-04 6.65642080915528122631030782940798e-01 1.61033154709168695086635159086086e-04
 	 6.65642080915528122631030782940798e-01 3.33840624824811804671753634465858e-01 1.61033154709168695086635159086086e-04
 	 6.65642080915528122631030782940798e-01 5.17294259660069986710151379583067e-04 1.61033154709168695086635159086086e-04
 	 1.19426687227411967850976282079500e-01 7.54587092570611038533368031266946e-03 4.83883651397566259995397519588778e-04
 	 1.19426687227411967850976282079500e-01 8.73027441846881857578921426465968e-01 4.83883651397566259995397519588778e-04
 	 7.54587092570611038533368031266946e-03 1.19426687227411967850976282079500e-01 4.83883651397566259995397519588778e-04
 	 7.54587092570611038533368031266946e-03 8.73027441846881857578921426465968e-01 4.83883651397566259995397519588778e-04
 	 8.73027441846881857578921426465968e-01 1.19426687227411967850976282079500e-01 4.83883651397566259995397519588778e-04
 	 8.73027441846881857578921426465968e-01 7.54587092570611038533368031266946e-03 4.83883651397566259995397519588778e-04
 	 1.73311806699428916367367037310032e-01 1.14925464528052804352720173142188e-02 6.73332446090880174308090921897474e-04
 	 1.73311806699428916367367037310032e-01 8.15195646847765797993190517445328e-01 6.73332446090880174308090921897474e-04
 	 1.14925464528052804352720173142188e-02 1.73311806699428916367367037310032e-01 6.73332446090880174308090921897474e-04
 	 1.14925464528052804352720173142188e-02 8.15195646847765797993190517445328e-01 6.73332446090880174308090921897474e-04
 	 8.15195646847765797993190517445328e-01 1.73311806699428916367367037310032e-01 6.73332446090880174308090921897474e-04
 	 8.15195646847765797993190517445328e-01 1.14925464528052804352720173142188e-02 6.73332446090880174308090921897474e-04
 	 5.93978633857566162834729084352148e-02 2.42629677211045335916139720211504e-02 6.68754141990617208789193792739525e-04
 	 5.93978633857566162834729084352148e-02 9.16339168893138822369337503914721e-01 6.68754141990617208789193792739525e-04
 	 2.42629677211045335916139720211504e-02 5.93978633857566162834729084352148e-02 6.68754141990617208789193792739525e-04
 	 2.42629677211045335916139720211504e-02 9.16339168893138822369337503914721e-01 6.68754141990617208789193792739525e-04
 	 9.16339168893138822369337503914721e-01 5.93978633857566162834729084352148e-02 6.68754141990617208789193792739525e-04
 	 9.16339168893138822369337503914721e-01 2.42629677211045335916139720211504e-02 6.68754141990617208789193792739525e-04
 	 2.59446164627843145478180986174266e-01 9.79769330245964208125908356805667e-03 6.04714018344115408765127028800634e-04
 	 2.59446164627843145478180986174266e-01 7.30756142069697189889154742559185e-01 6.04714018344115408765127028800634e-04
 	 9.79769330245964208125908356805667e-03 2.59446164627843145478180986174266e-01 6.04714018344115408765127028800634e-04
 	 9.79769330245964208125908356805667e-03 7.30756142069697189889154742559185e-01 6.04714018344115408765127028800634e-04
 	 7.30756142069697189889154742559185e-01 2.59446164627843145478180986174266e-01 6.04714018344115408765127028800634e-04
 	 7.30756142069697189889154742559185e-01 9.79769330245964208125908356805667e-03 6.04714018344115408765127028800634e-04
 	 2.69664879531117784861038444432779e-01 1.89915082820833660409709509053755e-03 2.98688070880941223140397910995603e-04
 	 2.69664879531117784861038444432779e-01 7.28435969640673808278563683415996e-01 2.98688070880941223140397910995603e-04
 	 1.89915082820833660409709509053755e-03 2.69664879531117784861038444432779e-01 2.98688070880941223140397910995603e-04
 	 1.89915082820833660409709509053755e-03 7.28435969640673808278563683415996e-01 2.98688070880941223140397910995603e-04
 	 7.28435969640673808278563683415996e-01 2.69664879531117784861038444432779e-01 2.98688070880941223140397910995603e-04
 	 7.28435969640673808278563683415996e-01 1.89915082820833660409709509053755e-03 2.98688070880941223140397910995603e-04
 	 3.23428410410956435061535785280284e-01 7.67467985614434661245653046535153e-03 7.34100531866784780828105727579214e-04
 	 3.23428410410956435061535785280284e-01 6.68896909732899280776052819419419e-01 7.34100531866784780828105727579214e-04
 	 7.67467985614434661245653046535153e-03 3.23428410410956435061535785280284e-01 7.34100531866784780828105727579214e-04
 	 7.67467985614434661245653046535153e-03 6.68896909732899280776052819419419e-01 7.34100531866784780828105727579214e-04
 	 6.68896909732899280776052819419419e-01 3.23428410410956435061535785280284e-01 7.34100531866784780828105727579214e-04
 	 6.68896909732899280776052819419419e-01 7.67467985614434661245653046535153e-03 7.34100531866784780828105727579214e-04
 	 2.09397609435192477711495939729502e-01 2.70720430776859224270003423384878e-03 4.00527242600620333751876289696270e-04
 	 2.09397609435192477711495939729502e-01 7.87895186257038915300654480233788e-01 4.00527242600620333751876289696270e-04
 	 2.70720430776859224270003423384878e-03 2.09397609435192477711495939729502e-01 4.00527242600620333751876289696270e-04
 	 2.70720430776859224270003423384878e-03 7.87895186257038915300654480233788e-01 4.00527242600620333751876289696270e-04
 	 7.87895186257038915300654480233788e-01 2.09397609435192477711495939729502e-01 4.00527242600620333751876289696270e-04
 	 7.87895186257038915300654480233788e-01 2.70720430776859224270003423384878e-03 4.00527242600620333751876289696270e-04
 	 1.07937373867395408622016361732676e-02 2.70639655716989335765276791789802e-03 9.27835211688662648155806467187290e-05
 	 1.07937373867395408622016361732676e-02 9.86499866056090635169084634981118e-01 9.27835211688662648155806467187290e-05
 	 2.70639655716989335765276791789802e-03 1.07937373867395408622016361732676e-02 9.27835211688662648155806467187290e-05
 	 2.70639655716989335765276791789802e-03 9.86499866056090635169084634981118e-01 9.27835211688662648155806467187290e-05
 	 9.86499866056090635169084634981118e-01 1.07937373867395408622016361732676e-02 9.27835211688662648155806467187290e-05
 	 9.86499866056090635169084634981118e-01 2.70639655716989335765276791789802e-03 9.27835211688662648155806467187290e-05
 	 4.16577600266789249694454611017136e-02 1.04627340296394866214768626377918e-02 3.60711013213061229294026377445448e-04
 	 4.16577600266789249694454611017136e-02 9.47879505943681532897926445002668e-01 3.60711013213061229294026377445448e-04
 	 1.04627340296394866214768626377918e-02 4.16577600266789249694454611017136e-02 3.60711013213061229294026377445448e-04
 	 1.04627340296394866214768626377918e-02 9.47879505943681532897926445002668e-01 3.60711013213061229294026377445448e-04
 	 9.47879505943681532897926445002668e-01 4.16577600266789249694454611017136e-02 3.60711013213061229294026377445448e-04
 	 9.47879505943681532897926445002668e-01 1.04627340296394866214768626377918e-02 3.60711013213061229294026377445448e-04
 	 1.39300774418482237182459471114271e-01 2.15128602849198879987113741663052e-02 7.66083362023713934814417303442724e-04
 	 1.39300774418482237182459471114271e-01 8.39186365296597847063253539090510e-01 7.66083362023713934814417303442724e-04
 	 2.15128602849198879987113741663052e-02 1.39300774418482237182459471114271e-01 7.66083362023713934814417303442724e-04
 	 2.15128602849198879987113741663052e-02 8.39186365296597847063253539090510e-01 7.66083362023713934814417303442724e-04
 	 8.39186365296597847063253539090510e-01 1.39300774418482237182459471114271e-01 7.66083362023713934814417303442724e-04
 	 8.39186365296597847063253539090510e-01 2.15128602849198879987113741663052e-02 7.66083362023713934814417303442724e-04
 	 9.71407574555290531659323960411712e-02 2.28245356349519729066699369468552e-02 7.54513310214146746754404482260270e-04
 	 9.71407574555290531659323960411712e-02 8.80034706909518904538458627939690e-01 7.54513310214146746754404482260270e-04
 	 2.28245356349519729066699369468552e-02 9.71407574555290531659323960411712e-02 7.54513310214146746754404482260270e-04
 	 2.28245356349519729066699369468552e-02 8.80034706909518904538458627939690e-01 7.54513310214146746754404482260270e-04
 	 8.80034706909518904538458627939690e-01 9.71407574555290531659323960411712e-02 7.54513310214146746754404482260270e-04
 	 8.80034706909518904538458627939690e-01 2.28245356349519729066699369468552e-02 7.54513310214146746754404482260270e-04
 	 1.51124809738970578010253120737616e-01 1.00088530304790021552285850248154e-01 1.70086123647450698607996866229541e-03
 	 1.51124809738970578010253120737616e-01 7.48786659956239386559673221199773e-01 1.70086123647450698607996866229541e-03
 	 1.00088530304790021552285850248154e-01 1.51124809738970578010253120737616e-01 1.70086123647450698607996866229541e-03
 	 1.00088530304790021552285850248154e-01 7.48786659956239386559673221199773e-01 1.70086123647450698607996866229541e-03
 	 7.48786659956239386559673221199773e-01 1.51124809738970578010253120737616e-01 1.70086123647450698607996866229541e-03
 	 7.48786659956239386559673221199773e-01 1.00088530304790021552285850248154e-01 1.70086123647450698607996866229541e-03
 	 3.93932395535154467047789239586564e-01 3.15956953663550782485103241015167e-03 5.17994081903192481186604112508576e-04
 	 3.93932395535154467047789239586564e-01 6.02908034928209990432890208467143e-01 5.17994081903192481186604112508576e-04
 	 3.15956953663550782485103241015167e-03 3.93932395535154467047789239586564e-01 5.17994081903192481186604112508576e-04
 	 3.15956953663550782485103241015167e-03 6.02908034928209990432890208467143e-01 5.17994081903192481186604112508576e-04
 	 6.02908034928209990432890208467143e-01 3.93932395535154467047789239586564e-01 5.17994081903192481186604112508576e-04
 	 6.02908034928209990432890208467143e-01 3.15956953663550782485103241015167e-03 5.17994081903192481186604112508576e-04
 	 1.27637459417324766741685948545637e-01 4.35675752808351648970308644948091e-02 1.18874384638993006550744535587683e-03
 	 1.27637459417324766741685948545637e-01 8.28794965301840047544601475237869e-01 1.18874384638993006550744535587683e-03
 	 4.35675752808351648970308644948091e-02 1.27637459417324766741685948545637e-01 1.18874384638993006550744535587683e-03
 	 4.35675752808351648970308644948091e-02 8.28794965301840047544601475237869e-01 1.18874384638993006550744535587683e-03
 	 8.28794965301840047544601475237869e-01 1.27637459417324766741685948545637e-01 1.18874384638993006550744535587683e-03
 	 8.28794965301840047544601475237869e-01 4.35675752808351648970308644948091e-02 1.18874384638993006550744535587683e-03
 	 2.15342785917052303990004702427541e-01 6.28153762458395631407270798263198e-02 1.69769561709233744901947904537565e-03
 	 2.15342785917052303990004702427541e-01 7.21841837837108202258207256818423e-01 1.69769561709233744901947904537565e-03
 	 6.28153762458395631407270798263198e-02 2.15342785917052303990004702427541e-01 1.69769561709233744901947904537565e-03
 	 6.28153762458395631407270798263198e-02 7.21841837837108202258207256818423e-01 1.69769561709233744901947904537565e-03
 	 7.21841837837108202258207256818423e-01 2.15342785917052303990004702427541e-01 1.69769561709233744901947904537565e-03
 	 7.21841837837108202258207256818423e-01 6.28153762458395631407270798263198e-02 1.69769561709233744901947904537565e-03
 	 1.80523887256028525705175979965134e-01 3.46911866169311577934308843396138e-02 1.35204419124090890504119588655385e-03
 	 1.80523887256028525705175979965134e-01 7.84784926127040316501393135695253e-01 1.35204419124090890504119588655385e-03
 	 3.46911866169311577934308843396138e-02 1.80523887256028525705175979965134e-01 1.35204419124090890504119588655385e-03
 	 3.46911866169311577934308843396138e-02 7.84784926127040316501393135695253e-01 1.35204419124090890504119588655385e-03
 	 7.84784926127040316501393135695253e-01 1.80523887256028525705175979965134e-01 1.35204419124090890504119588655385e-03
 	 7.84784926127040316501393135695253e-01 3.46911866169311577934308843396138e-02 1.35204419124090890504119588655385e-03
 	 3.70697478749728304148192137290607e-01 1.59521357680311760829372502712431e-02 1.00850169514564371071874138152680e-03
 	 3.70697478749728304148192137290607e-01 6.13350385482240412216015101876110e-01 1.00850169514564371071874138152680e-03
 	 1.59521357680311760829372502712431e-02 3.70697478749728304148192137290607e-01 1.00850169514564371071874138152680e-03
 	 1.59521357680311760829372502712431e-02 6.13350385482240412216015101876110e-01 1.00850169514564371071874138152680e-03
 	 6.13350385482240412216015101876110e-01 3.70697478749728304148192137290607e-01 1.00850169514564371071874138152680e-03
 	 6.13350385482240412216015101876110e-01 1.59521357680311760829372502712431e-02 1.00850169514564371071874138152680e-03
 	 2.38904346634593867104712217042106e-01 3.65656909809639746322673659051361e-02 1.39594056621288411558501341147576e-03
 	 2.38904346634593867104712217042106e-01 7.24529962384442116629656993609387e-01 1.39594056621288411558501341147576e-03
 	 3.65656909809639746322673659051361e-02 2.38904346634593867104712217042106e-01 1.39594056621288411558501341147576e-03
 	 3.65656909809639746322673659051361e-02 7.24529962384442116629656993609387e-01 1.39594056621288411558501341147576e-03
 	 7.24529962384442116629656993609387e-01 2.38904346634593867104712217042106e-01 1.39594056621288411558501341147576e-03
 	 7.24529962384442116629656993609387e-01 3.65656909809639746322673659051361e-02 1.39594056621288411558501341147576e-03
 	 4.03544504764916933670093612818164e-01 1.22867248406971205088034082564263e-01 2.15022943286524628042633011659746e-03
 	 4.03544504764916933670093612818164e-01 4.73588246828111902875235728060943e-01 2.15022943286524628042633011659746e-03
 	 1.22867248406971205088034082564263e-01 4.03544504764916933670093612818164e-01 2.15022943286524628042633011659746e-03
 	 1.22867248406971205088034082564263e-01 4.73588246828111902875235728060943e-01 2.15022943286524628042633011659746e-03
 	 4.73588246828111902875235728060943e-01 4.03544504764916933670093612818164e-01 2.15022943286524628042633011659746e-03
 	 4.73588246828111902875235728060943e-01 1.22867248406971205088034082564263e-01 2.15022943286524628042633011659746e-03
 	 2.51088618401061669516138863400556e-01 1.22061192033510804155760354205995e-01 2.49192826459687828688505106811135e-03
 	 2.51088618401061669516138863400556e-01 6.26850189565427484694737358950078e-01 2.49192826459687828688505106811135e-03
 	 1.22061192033510804155760354205995e-01 2.51088618401061669516138863400556e-01 2.49192826459687828688505106811135e-03
 	 1.22061192033510804155760354205995e-01 6.26850189565427484694737358950078e-01 2.49192826459687828688505106811135e-03
 	 6.26850189565427484694737358950078e-01 2.51088618401061669516138863400556e-01 2.49192826459687828688505106811135e-03
 	 6.26850189565427484694737358950078e-01 1.22061192033510804155760354205995e-01 2.49192826459687828688505106811135e-03
 	 3.10092460353001919681759090963169e-01 8.78278870328067923223258617326792e-02 2.32664813783349305395531381179808e-03
 	 3.10092460353001919681759090963169e-01 6.02079652614191274118127239489695e-01 2.32664813783349305395531381179808e-03
 	 8.78278870328067923223258617326792e-02 3.10092460353001919681759090963169e-01 2.32664813783349305395531381179808e-03
 	 8.78278870328067923223258617326792e-02 6.02079652614191274118127239489695e-01 2.32664813783349305395531381179808e-03
 	 6.02079652614191274118127239489695e-01 3.10092460353001919681759090963169e-01 2.32664813783349305395531381179808e-03
 	 6.02079652614191274118127239489695e-01 8.78278870328067923223258617326792e-02 2.32664813783349305395531381179808e-03
 	 4.17188937068111109773838052205974e-01 6.56811030561964964702426073017705e-02 2.06393802112825059530409887997848e-03
 	 4.17188937068111109773838052205974e-01 5.17129959875692435389282763935626e-01 2.06393802112825059530409887997848e-03
 	 6.56811030561964964702426073017705e-02 4.17188937068111109773838052205974e-01 2.06393802112825059530409887997848e-03
 	 6.56811030561964964702426073017705e-02 5.17129959875692435389282763935626e-01 2.06393802112825059530409887997848e-03
 	 5.17129959875692435389282763935626e-01 4.17188937068111109773838052205974e-01 2.06393802112825059530409887997848e-03
 	 5.17129959875692435389282763935626e-01 6.56811030561964964702426073017705e-02 2.06393802112825059530409887997848e-03
 	 8.42771975158688041451782169133367e-02 4.57201471848305632250664132243401e-02 1.02891088117624531980687230259264e-03
 	 8.42771975158688041451782169133367e-02 8.70002655299300653446437081584008e-01 1.02891088117624531980687230259264e-03
 	 4.57201471848305632250664132243401e-02 8.42771975158688041451782169133367e-02 1.02891088117624531980687230259264e-03
 	 4.57201471848305632250664132243401e-02 8.70002655299300653446437081584008e-01 1.02891088117624531980687230259264e-03
 	 8.70002655299300653446437081584008e-01 8.42771975158688041451782169133367e-02 1.02891088117624531980687230259264e-03
 	 8.70002655299300653446437081584008e-01 4.57201471848305632250664132243401e-02 1.02891088117624531980687230259264e-03
 	 2.87517281890495191021273058140650e-01 5.28034108950670294513329849905858e-02 1.94691022921440444817808845812124e-03
 	 2.87517281890495191021273058140650e-01 6.59679307214437793405181764683221e-01 1.94691022921440444817808845812124e-03
 	 5.28034108950670294513329849905858e-02 2.87517281890495191021273058140650e-01 1.94691022921440444817808845812124e-03
 	 5.28034108950670294513329849905858e-02 6.59679307214437793405181764683221e-01 1.94691022921440444817808845812124e-03
 	 6.59679307214437793405181764683221e-01 2.87517281890495191021273058140650e-01 1.94691022921440444817808845812124e-03
 	 6.59679307214437793405181764683221e-01 5.28034108950670294513329849905858e-02 1.94691022921440444817808845812124e-03
 	 3.42142184906992441462136866903165e-01 3.32627075502785821137230470867507e-02 1.38538069827777053297235276829724e-03
 	 3.42142184906992441462136866903165e-01 6.24595107542728955607458374288399e-01 1.38538069827777053297235276829724e-03
 	 3.32627075502785821137230470867507e-02 3.42142184906992441462136866903165e-01 1.38538069827777053297235276829724e-03
 	 3.32627075502785821137230470867507e-02 6.24595107542728955607458374288399e-01 1.38538069827777053297235276829724e-03
 	 6.24595107542728955607458374288399e-01 3.42142184906992441462136866903165e-01 1.38538069827777053297235276829724e-03
 	 6.24595107542728955607458374288399e-01 3.32627075502785821137230470867507e-02 1.38538069827777053297235276829724e-03
 	 2.90781335627484260886177480642800e-01 2.30909511650298354679122780908074e-02 1.24007199925338091987814248540190e-03
 	 2.90781335627484260886177480642800e-01 6.86127713207486000790424895967590e-01 1.24007199925338091987814248540190e-03
 	 2.30909511650298354679122780908074e-02 2.90781335627484260886177480642800e-01 1.24007199925338091987814248540190e-03
 	 2.30909511650298354679122780908074e-02 6.86127713207486000790424895967590e-01 1.24007199925338091987814248540190e-03
 	 6.86127713207486000790424895967590e-01 2.90781335627484260886177480642800e-01 1.24007199925338091987814248540190e-03
 	 6.86127713207486000790424895967590e-01 2.30909511650298354679122780908074e-02 1.24007199925338091987814248540190e-03
 	 7.77385297161002769561477521165216e-02 8.41212288864582984071471827292044e-03 4.31451090416773528225108380595998e-04
 	 7.77385297161002769561477521165216e-02 9.13849347395253919223989669262664e-01 4.31451090416773528225108380595998e-04
 	 8.41212288864582984071471827292044e-03 7.77385297161002769561477521165216e-02 4.31451090416773528225108380595998e-04
 	 8.41212288864582984071471827292044e-03 9.13849347395253919223989669262664e-01 4.31451090416773528225108380595998e-04
 	 9.13849347395253919223989669262664e-01 7.77385297161002769561477521165216e-02 4.31451090416773528225108380595998e-04
 	 9.13849347395253919223989669262664e-01 8.41212288864582984071471827292044e-03 4.31451090416773528225108380595998e-04
 	 5.83538087981567143991412649484118e-02 1.85584469043908713639656760108210e-03 1.60466588787147433235388827021950e-04
 	 5.83538087981567143991412649484118e-02 9.39790346511404139917544853233267e-01 1.60466588787147433235388827021950e-04
 	 1.85584469043908713639656760108210e-03 5.83538087981567143991412649484118e-02 1.60466588787147433235388827021950e-04
 	 1.85584469043908713639656760108210e-03 9.39790346511404139917544853233267e-01 1.60466588787147433235388827021950e-04
 	 9.39790346511404139917544853233267e-01 5.83538087981567143991412649484118e-02 1.60466588787147433235388827021950e-04
 	 9.39790346511404139917544853233267e-01 1.85584469043908713639656760108210e-03 1.60466588787147433235388827021950e-04
 	 3.53736217391187435232779989746632e-01 1.51861221499153403735604683788551e-01 2.49050430530871769879697197325186e-03
 	 3.53736217391187435232779989746632e-01 4.94402561109659188787190942093730e-01 2.49050430530871769879697197325186e-03
 	 1.51861221499153403735604683788551e-01 3.53736217391187435232779989746632e-01 2.49050430530871769879697197325186e-03
 	 1.51861221499153403735604683788551e-01 4.94402561109659188787190942093730e-01 2.49050430530871769879697197325186e-03
 	 4.94402561109659188787190942093730e-01 3.53736217391187435232779989746632e-01 2.49050430530871769879697197325186e-03
 	 4.94402561109659188787190942093730e-01 1.51861221499153403735604683788551e-01 2.49050430530871769879697197325186e-03
 	 1.94103683421922135199366721280967e-01 1.46693846495503765758883218950359e-01 2.50978895904076194575682556830998e-03
 	 1.94103683421922135199366721280967e-01 6.59202470082574154552901291026501e-01 2.50978895904076194575682556830998e-03
 	 1.46693846495503765758883218950359e-01 1.94103683421922135199366721280967e-01 2.50978895904076194575682556830998e-03
 	 1.46693846495503765758883218950359e-01 6.59202470082574154552901291026501e-01 2.50978895904076194575682556830998e-03
 	 6.59202470082574154552901291026501e-01 1.94103683421922135199366721280967e-01 2.50978895904076194575682556830998e-03
 	 6.59202470082574154552901291026501e-01 1.46693846495503765758883218950359e-01 2.50978895904076194575682556830998e-03
 	 1.15244680262074267185212761432922e-01 7.30582724234847963318273400545877e-02 1.38461640914676353299184174971970e-03
 	 1.15244680262074267185212761432922e-01 8.11697047314440922605172090698034e-01 1.38461640914676353299184174971970e-03
 	 7.30582724234847963318273400545877e-02 1.15244680262074267185212761432922e-01 1.38461640914676353299184174971970e-03
 	 7.30582724234847963318273400545877e-02 8.11697047314440922605172090698034e-01 1.38461640914676353299184174971970e-03
 	 8.11697047314440922605172090698034e-01 1.15244680262074267185212761432922e-01 1.38461640914676353299184174971970e-03
 	 8.11697047314440922605172090698034e-01 7.30582724234847963318273400545877e-02 1.38461640914676353299184174971970e-03
 	 2.52648918856827386925090195290977e-01 8.33205145800466895344982276583323e-02 1.85079032983941375520298144863318e-03
 	 2.52648918856827386925090195290977e-01 6.64030566563125868029260345792864e-01 1.85079032983941375520298144863318e-03
 	 8.33205145800466895344982276583323e-02 2.52648918856827386925090195290977e-01 1.85079032983941375520298144863318e-03
 	 8.33205145800466895344982276583323e-02 6.64030566563125868029260345792864e-01 1.85079032983941375520298144863318e-03
 	 6.64030566563125868029260345792864e-01 2.52648918856827386925090195290977e-01 1.85079032983941375520298144863318e-03
 	 6.64030566563125868029260345792864e-01 8.33205145800466895344982276583323e-02 1.85079032983941375520298144863318e-03
 	 3.70638127911035064609990286044194e-01 9.76700995193537646610337787933531e-02 2.53751872958099793792241527512488e-03
 	 3.70638127911035064609990286044194e-01 5.31691772569611087462249088275712e-01 2.53751872958099793792241527512488e-03
 	 9.76700995193537646610337787933531e-02 3.70638127911035064609990286044194e-01 2.53751872958099793792241527512488e-03
 	 9.76700995193537646610337787933531e-02 5.31691772569611087462249088275712e-01 2.53751872958099793792241527512488e-03
 	 5.31691772569611087462249088275712e-01 3.70638127911035064609990286044194e-01 2.53751872958099793792241527512488e-03
 	 5.31691772569611087462249088275712e-01 9.76700995193537646610337787933531e-02 2.53751872958099793792241527512488e-03
 	 1.97510766235328455442399331332126e-01 1.02127473235820234731541233941243e-01 2.13383834577409023033900403731877e-03
 	 1.97510766235328455442399331332126e-01 7.00361760528851240437120395654347e-01 2.13383834577409023033900403731877e-03
 	 1.02127473235820234731541233941243e-01 1.97510766235328455442399331332126e-01 2.13383834577409023033900403731877e-03
 	 1.02127473235820234731541233941243e-01 7.00361760528851240437120395654347e-01 2.13383834577409023033900403731877e-03
 	 7.00361760528851240437120395654347e-01 1.97510766235328455442399331332126e-01 2.13383834577409023033900403731877e-03
 	 7.00361760528851240437120395654347e-01 1.02127473235820234731541233941243e-01 2.13383834577409023033900403731877e-03
 	 2.19102178776639594515174280786596e-01 1.69401226467935060726599516556234e-02 8.64613651994067212644412556699081e-04
 	 2.19102178776639594515174280786596e-01 7.63957698576566923698294431233080e-01 8.64613651994067212644412556699081e-04
 	 1.69401226467935060726599516556234e-02 2.19102178776639594515174280786596e-01 8.64613651994067212644412556699081e-04
 	 1.69401226467935060726599516556234e-02 7.63957698576566923698294431233080e-01 8.64613651994067212644412556699081e-04
 	 7.63957698576566923698294431233080e-01 2.19102178776639594515174280786596e-01 8.64613651994067212644412556699081e-04
 	 7.63957698576566923698294431233080e-01 1.69401226467935060726599516556234e-02 8.64613651994067212644412556699081e-04
 	 1.64749471455534146624444247208885e-01 6.46074146543942490206191564539040e-02 1.61236995612197434382673044694911e-03
 	 1.64749471455534146624444247208885e-01 7.70643113890071562721573172893841e-01 1.61236995612197434382673044694911e-03
 	 6.46074146543942490206191564539040e-02 1.64749471455534146624444247208885e-01 1.61236995612197434382673044694911e-03
 	 6.46074146543942490206191564539040e-02 7.70643113890071562721573172893841e-01 1.61236995612197434382673044694911e-03
 	 7.70643113890071562721573172893841e-01 1.64749471455534146624444247208885e-01 1.61236995612197434382673044694911e-03
 	 7.70643113890071562721573172893841e-01 6.46074146543942490206191564539040e-02 1.61236995612197434382673044694911e-03
 	 3.48756887430614948009122144867433e-01 1.94293491861925404773359105092823e-01 2.64397385648094821256059994141197e-03
 	 3.48756887430614948009122144867433e-01 4.56949620707459647217518750039744e-01 2.64397385648094821256059994141197e-03
 	 1.94293491861925404773359105092823e-01 3.48756887430614948009122144867433e-01 2.64397385648094821256059994141197e-03
 	 1.94293491861925404773359105092823e-01 4.56949620707459647217518750039744e-01 2.64397385648094821256059994141197e-03
 	 4.56949620707459647217518750039744e-01 3.48756887430614948009122144867433e-01 2.64397385648094821256059994141197e-03
 	 4.56949620707459647217518750039744e-01 1.94293491861925404773359105092823e-01 2.64397385648094821256059994141197e-03
 	 3.55853330058662320478646279298118e-01 5.87895877753212212080136112035689e-02 2.00979214318253510129785865956364e-03
 	 3.55853330058662320478646279298118e-01 5.85357082166016451374446205591084e-01 2.00979214318253510129785865956364e-03
 	 5.87895877753212212080136112035689e-02 3.55853330058662320478646279298118e-01 2.00979214318253510129785865956364e-03
 	 5.87895877753212212080136112035689e-02 5.85357082166016451374446205591084e-01 2.00979214318253510129785865956364e-03
 	 5.85357082166016451374446205591084e-01 3.55853330058662320478646279298118e-01 2.00979214318253510129785865956364e-03
 	 5.85357082166016451374446205591084e-01 5.87895877753212212080136112035689e-02 2.00979214318253510129785865956364e-03
 	 3.48716528985469398360663717539865e-01 2.43584975885173138365757949941326e-01 3.03041660365002338273221482722874e-03
 	 3.48716528985469398360663717539865e-01 4.07698495129357407762427101260982e-01 3.03041660365002338273221482722874e-03
 	 2.43584975885173138365757949941326e-01 3.48716528985469398360663717539865e-01 3.03041660365002338273221482722874e-03
 	 2.43584975885173138365757949941326e-01 4.07698495129357407762427101260982e-01 3.03041660365002338273221482722874e-03
 	 4.07698495129357407762427101260982e-01 3.48716528985469398360663717539865e-01 3.03041660365002338273221482722874e-03
 	 4.07698495129357407762427101260982e-01 2.43584975885173138365757949941326e-01 3.03041660365002338273221482722874e-03
 	 2.90704335549696046836487539621885e-01 1.86125965956163291759040134820680e-01 2.89956852928164102167762905537529e-03
 	 2.90704335549696046836487539621885e-01 5.23169698494140633648896709928522e-01 2.89956852928164102167762905537529e-03
 	 1.86125965956163291759040134820680e-01 2.90704335549696046836487539621885e-01 2.89956852928164102167762905537529e-03
 	 1.86125965956163291759040134820680e-01 5.23169698494140633648896709928522e-01 2.89956852928164102167762905537529e-03
 	 5.23169698494140633648896709928522e-01 2.90704335549696046836487539621885e-01 2.89956852928164102167762905537529e-03
 	 5.23169698494140633648896709928522e-01 1.86125965956163291759040134820680e-01 2.89956852928164102167762905537529e-03
 	 2.89862934817113671037702715693740e-01 2.38357019552556226305028985734680e-01 3.19657376055502030071098218400039e-03
 	 2.89862934817113671037702715693740e-01 4.71780045630330102657268298571580e-01 3.19657376055502030071098218400039e-03
 	 2.38357019552556226305028985734680e-01 2.89862934817113671037702715693740e-01 3.19657376055502030071098218400039e-03
 	 2.38357019552556226305028985734680e-01 4.71780045630330102657268298571580e-01 3.19657376055502030071098218400039e-03
 	 4.71780045630330102657268298571580e-01 2.89862934817113671037702715693740e-01 3.19657376055502030071098218400039e-03
 	 4.71780045630330102657268298571580e-01 2.38357019552556226305028985734680e-01 3.19657376055502030071098218400039e-03
 	 3.09383575445457970065632480327622e-01 1.31229616791972980571756579593057e-01 2.82733750449421557954243766630498e-03
 	 3.09383575445457970065632480327622e-01 5.59386807762569104873762171337148e-01 2.82733750449421557954243766630498e-03
 	 1.31229616791972980571756579593057e-01 3.09383575445457970065632480327622e-01 2.82733750449421557954243766630498e-03
 	 1.31229616791972980571756579593057e-01 5.59386807762569104873762171337148e-01 2.82733750449421557954243766630498e-03
 	 5.59386807762569104873762171337148e-01 3.09383575445457970065632480327622e-01 2.82733750449421557954243766630498e-03
 	 5.59386807762569104873762171337148e-01 1.31229616791972980571756579593057e-01 2.82733750449421557954243766630498e-03
 	 2.46979539099244443933756087972142e-01 1.68458978552479210488712624282925e-01 2.65552470844998469295950016544339e-03
 	 2.46979539099244443933756087972142e-01 5.84561482348276317821955672116019e-01 2.65552470844998469295950016544339e-03
 	 1.68458978552479210488712624282925e-01 2.46979539099244443933756087972142e-01 2.65552470844998469295950016544339e-03
 	 1.68458978552479210488712624282925e-01 5.84561482348276317821955672116019e-01 2.65552470844998469295950016544339e-03
 	 5.84561482348276317821955672116019e-01 2.46979539099244443933756087972142e-01 2.65552470844998469295950016544339e-03
 	 5.84561482348276317821955672116019e-01 1.68458978552479210488712624282925e-01 2.65552470844998469295950016544339e-03
 	 4.35345195121465189380671745311702e-01 1.31254695112234757298219633980807e-02 9.86615210737949374641964084275969e-04
 	 4.35345195121465189380671745311702e-01 5.51529335367311301929760247730883e-01 9.86615210737949374641964084275969e-04
 	 1.31254695112234757298219633980807e-02 4.35345195121465189380671745311702e-01 9.86615210737949374641964084275969e-04
 	 1.31254695112234757298219633980807e-02 5.51529335367311301929760247730883e-01 9.86615210737949374641964084275969e-04
 	 5.51529335367311301929760247730883e-01 4.35345195121465189380671745311702e-01 9.86615210737949374641964084275969e-04
 	 5.51529335367311301929760247730883e-01 1.31254695112234757298219633980807e-02 9.86615210737949374641964084275969e-04
 	 4.13701289314883091652319535569404e-01 3.44134405185802239035552929635742e-02 1.77773973578346949388218067866774e-03
 	 4.13701289314883091652319535569404e-01 5.51885270166536767710852018353762e-01 1.77773973578346949388218067866774e-03
 	 3.44134405185802239035552929635742e-02 4.13701289314883091652319535569404e-01 1.77773973578346949388218067866774e-03
 	 3.44134405185802239035552929635742e-02 5.51885270166536767710852018353762e-01 1.77773973578346949388218067866774e-03
 	 5.51885270166536767710852018353762e-01 4.13701289314883091652319535569404e-01 1.77773973578346949388218067866774e-03
 	 5.51885270166536767710852018353762e-01 3.44134405185802239035552929635742e-02 1.77773973578346949388218067866774e-03
 	 ];
 
 	 case  45 

 	 % ALG. DEG.:   45
 	 % PTS CARD.:  370
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.47073482719251202865962113719434e-03
 	 1.29806653300276658713485744556237e-01 1.29806653300276658713485744556237e-01 1.60120857517628638853890432613980e-03
 	 1.29806653300276658713485744556237e-01 7.40386693399446738084179742145352e-01 1.60120857517628638853890432613980e-03
 	 7.40386693399446738084179742145352e-01 1.29806653300276658713485744556237e-01 1.60120857517628638853890432613980e-03
 	 2.06349665630883027933606399528799e-01 2.06349665630883027933606399528799e-01 2.31867442056098637878647217291928e-03
 	 2.06349665630883027933606399528799e-01 5.87300668738233944132787200942403e-01 2.31867442056098637878647217291928e-03
 	 5.87300668738233944132787200942403e-01 2.06349665630883027933606399528799e-01 2.31867442056098637878647217291928e-03
 	 1.75084588806939833727227551207761e-01 1.75084588806939833727227551207761e-01 2.04353023274364813816061925422218e-03
 	 1.75084588806939833727227551207761e-01 6.49830822386120332545544897584477e-01 2.04353023274364813816061925422218e-03
 	 6.49830822386120332545544897584477e-01 1.75084588806939833727227551207761e-01 2.04353023274364813816061925422218e-03
 	 4.99504576867959404484764718290535e-01 4.99504576867959404484764718290535e-01 2.41556761516012848600362672435438e-04
 	 4.99504576867959404484764718290535e-01 9.90846264081191030470563418930396e-04 2.41556761516012848600362672435438e-04
 	 9.90846264081191030470563418930396e-04 4.99504576867959404484764718290535e-01 2.41556761516012848600362672435438e-04
 	 5.52204190605027900318191313999705e-02 5.52204190605027900318191313999705e-02 8.46305070277619114760270235819917e-04
 	 5.52204190605027900318191313999705e-02 8.89559161878994419936361737200059e-01 8.46305070277619114760270235819917e-04
 	 8.89559161878994419936361737200059e-01 5.52204190605027900318191313999705e-02 8.46305070277619114760270235819917e-04
 	 2.99152765836593892423422857973492e-01 2.99152765836593892423422857973492e-01 3.41687768784906158517356011827815e-03
 	 2.99152765836593892423422857973492e-01 4.01694468326812215153154284053016e-01 3.41687768784906158517356011827815e-03
 	 4.01694468326812215153154284053016e-01 2.99152765836593892423422857973492e-01 3.41687768784906158517356011827815e-03
 	 3.66982277256458211400769187093829e-01 3.66982277256458211400769187093829e-01 3.44625239929347623041300252566543e-03
 	 3.66982277256458211400769187093829e-01 2.66035445487083577198461625812342e-01 3.44625239929347623041300252566543e-03
 	 2.66035445487083577198461625812342e-01 3.66982277256458211400769187093829e-01 3.44625239929347623041300252566543e-03
 	 2.64921642390380518428116829454666e-01 2.64921642390380518428116829454666e-01 3.15732849651644865984767562849811e-03
 	 2.64921642390380518428116829454666e-01 4.70156715219238963143766341090668e-01 3.15732849651644865984767562849811e-03
 	 4.70156715219238963143766341090668e-01 2.64921642390380518428116829454666e-01 3.15732849651644865984767562849811e-03
 	 3.98469068413945026740918819996295e-01 3.98469068413945026740918819996295e-01 3.27915375009894208974126073030675e-03
 	 3.98469068413945026740918819996295e-01 2.03061863172109946518162360007409e-01 3.27915375009894208974126073030675e-03
 	 2.03061863172109946518162360007409e-01 3.98469068413945026740918819996295e-01 3.27915375009894208974126073030675e-03
 	 4.52620190751494178016400837805122e-01 4.52620190751494178016400837805122e-01 2.50842974298410518324553564184498e-03
 	 4.52620190751494178016400837805122e-01 9.47596184970116439671983243897557e-02 2.50842974298410518324553564184498e-03
 	 9.47596184970116439671983243897557e-02 4.52620190751494178016400837805122e-01 2.50842974298410518324553564184498e-03
 	 4.26861049533307446157692766064429e-01 4.26861049533307446157692766064429e-01 2.94125456308764977528258377503789e-03
 	 4.26861049533307446157692766064429e-01 1.46277900933385107684614467871143e-01 2.94125456308764977528258377503789e-03
 	 1.46277900933385107684614467871143e-01 4.26861049533307446157692766064429e-01 2.94125456308764977528258377503789e-03
 	 9.45724371334943636480119266707334e-02 9.45724371334943636480119266707334e-02 1.56857173108213422511869605813217e-03
 	 9.45724371334943636480119266707334e-02 8.10855125733011217192824915400706e-01 1.56857173108213422511869605813217e-03
 	 8.10855125733011217192824915400706e-01 9.45724371334943636480119266707334e-02 1.56857173108213422511869605813217e-03
 	 4.72989470868897310396050670533441e-01 4.72989470868897310396050670533441e-01 2.04653257390983479846457981921048e-03
 	 4.72989470868897310396050670533441e-01 5.40210582622053792078986589331180e-02 2.04653257390983479846457981921048e-03
 	 5.40210582622053792078986589331180e-02 4.72989470868897310396050670533441e-01 2.04653257390983479846457981921048e-03
 	 3.40851411567991424700352354193456e-02 3.40851411567991424700352354193456e-02 6.25657342660229350353451316379960e-04
 	 3.40851411567991424700352354193456e-02 9.31829717686401659548778297903482e-01 6.25657342660229350353451316379960e-04
 	 9.31829717686401659548778297903482e-01 3.40851411567991424700352354193456e-02 6.25657342660229350353451316379960e-04
 	 4.86998996825781460540127909553121e-01 4.86998996825781460540127909553121e-01 1.52790288514941473806130201040787e-03
 	 4.86998996825781460540127909553121e-01 2.60020063484370789197441808937583e-02 1.52790288514941473806130201040787e-03
 	 2.60020063484370789197441808937583e-02 4.86998996825781460540127909553121e-01 1.52790288514941473806130201040787e-03
 	 1.26048038307361616461310660497475e-02 7.29242955084338090321338654575811e-03 9.71532123877305272326848628594576e-05
 	 1.26048038307361616461310660497475e-02 9.80102766618420440103420787636423e-01 9.71532123877305272326848628594576e-05
 	 7.29242955084338090321338654575811e-03 1.26048038307361616461310660497475e-02 9.71532123877305272326848628594576e-05
 	 7.29242955084338090321338654575811e-03 9.80102766618420440103420787636423e-01 9.71532123877305272326848628594576e-05
 	 9.80102766618420440103420787636423e-01 1.26048038307361616461310660497475e-02 9.71532123877305272326848628594576e-05
 	 9.80102766618420440103420787636423e-01 7.29242955084338090321338654575811e-03 9.71532123877305272326848628594576e-05
 	 4.60547663144127931295068734129927e-03 1.34999718211049760455133572634168e-03 2.96832401489165982686867922835106e-05
 	 4.60547663144127931295068734129927e-03 9.94044526186448229587711011845386e-01 2.96832401489165982686867922835106e-05
 	 1.34999718211049760455133572634168e-03 4.60547663144127931295068734129927e-03 2.96832401489165982686867922835106e-05
 	 1.34999718211049760455133572634168e-03 9.94044526186448229587711011845386e-01 2.96832401489165982686867922835106e-05
 	 9.94044526186448229587711011845386e-01 4.60547663144127931295068734129927e-03 2.96832401489165982686867922835106e-05
 	 9.94044526186448229587711011845386e-01 1.34999718211049760455133572634168e-03 2.96832401489165982686867922835106e-05
 	 6.79464966039111523121718505535682e-02 6.85917593806053670774103281360112e-03 2.40344353751331478961927867743498e-04
 	 6.79464966039111523121718505535682e-02 9.25194327458028320521066234505270e-01 2.40344353751331478961927867743498e-04
 	 6.85917593806053670774103281360112e-03 6.79464966039111523121718505535682e-02 2.40344353751331478961927867743498e-04
 	 6.85917593806053670774103281360112e-03 9.25194327458028320521066234505270e-01 2.40344353751331478961927867743498e-04
 	 9.25194327458028320521066234505270e-01 6.79464966039111523121718505535682e-02 2.40344353751331478961927867743498e-04
 	 9.25194327458028320521066234505270e-01 6.85917593806053670774103281360112e-03 2.40344353751331478961927867743498e-04
 	 6.93380043634408277375413831578044e-02 1.22976799593489888665076570362089e-03 1.15062466750111980088103202923833e-04
 	 6.93380043634408277375413831578044e-02 9.29432227640624275544212196109584e-01 1.15062466750111980088103202923833e-04
 	 1.22976799593489888665076570362089e-03 6.93380043634408277375413831578044e-02 1.15062466750111980088103202923833e-04
 	 1.22976799593489888665076570362089e-03 9.29432227640624275544212196109584e-01 1.15062466750111980088103202923833e-04
 	 9.29432227640624275544212196109584e-01 6.93380043634408277375413831578044e-02 1.15062466750111980088103202923833e-04
 	 9.29432227640624275544212196109584e-01 1.22976799593489888665076570362089e-03 1.15062466750111980088103202923833e-04
 	 4.68270859870947964154197507014032e-01 8.78010020069475149995241736178286e-03 6.47231358534071528863795830233130e-04
 	 4.68270859870947964154197507014032e-01 5.22949039928357284345850075624185e-01 6.47231358534071528863795830233130e-04
 	 8.78010020069475149995241736178286e-03 4.68270859870947964154197507014032e-01 6.47231358534071528863795830233130e-04
 	 8.78010020069475149995241736178286e-03 5.22949039928357284345850075624185e-01 6.47231358534071528863795830233130e-04
 	 5.22949039928357284345850075624185e-01 4.68270859870947964154197507014032e-01 6.47231358534071528863795830233130e-04
 	 5.22949039928357284345850075624185e-01 8.78010020069475149995241736178286e-03 6.47231358534071528863795830233130e-04
 	 2.50495170335221506441314431867795e-01 1.68302636118027710253330919698556e-03 2.30260449145342833325925124832168e-04
 	 2.50495170335221506441314431867795e-01 7.47821803303598264811569151788717e-01 2.30260449145342833325925124832168e-04
 	 1.68302636118027710253330919698556e-03 2.50495170335221506441314431867795e-01 2.30260449145342833325925124832168e-04
 	 1.68302636118027710253330919698556e-03 7.47821803303598264811569151788717e-01 2.30260449145342833325925124832168e-04
 	 7.47821803303598264811569151788717e-01 2.50495170335221506441314431867795e-01 2.30260449145342833325925124832168e-04
 	 7.47821803303598264811569151788717e-01 1.68302636118027710253330919698556e-03 2.30260449145342833325925124832168e-04
 	 1.79231013398374397493917342671921e-02 1.75797258353514685921825666525820e-03 7.75345040014330428874284040219322e-05
 	 1.79231013398374397493917342671921e-02 9.80318926076627406018815236166120e-01 7.75345040014330428874284040219322e-05
 	 1.75797258353514685921825666525820e-03 1.79231013398374397493917342671921e-02 7.75345040014330428874284040219322e-05
 	 1.75797258353514685921825666525820e-03 9.80318926076627406018815236166120e-01 7.75345040014330428874284040219322e-05
 	 9.80318926076627406018815236166120e-01 1.79231013398374397493917342671921e-02 7.75345040014330428874284040219322e-05
 	 9.80318926076627406018815236166120e-01 1.75797258353514685921825666525820e-03 7.75345040014330428874284040219322e-05
 	 3.59456841995052789329179177002516e-01 1.47561365316294709065791934676781e-03 2.63216008449837382630193127752705e-04
 	 3.59456841995052789329179177002516e-01 6.39067544351784255773907261755085e-01 2.63216008449837382630193127752705e-04
 	 1.47561365316294709065791934676781e-03 3.59456841995052789329179177002516e-01 2.63216008449837382630193127752705e-04
 	 1.47561365316294709065791934676781e-03 6.39067544351784255773907261755085e-01 2.63216008449837382630193127752705e-04
 	 6.39067544351784255773907261755085e-01 3.59456841995052789329179177002516e-01 2.63216008449837382630193127752705e-04
 	 6.39067544351784255773907261755085e-01 1.47561365316294709065791934676781e-03 2.63216008449837382630193127752705e-04
 	 2.21153984784947493791307238097943e-01 1.53663127462592530303453486340004e-01 2.03880140043859832063577464111859e-03
 	 2.21153984784947493791307238097943e-01 6.25182887752459892638512428675313e-01 2.03880140043859832063577464111859e-03
 	 1.53663127462592530303453486340004e-01 2.21153984784947493791307238097943e-01 2.03880140043859832063577464111859e-03
 	 1.53663127462592530303453486340004e-01 6.25182887752459892638512428675313e-01 2.03880140043859832063577464111859e-03
 	 6.25182887752459892638512428675313e-01 2.21153984784947493791307238097943e-01 2.03880140043859832063577464111859e-03
 	 6.25182887752459892638512428675313e-01 1.53663127462592530303453486340004e-01 2.03880140043859832063577464111859e-03
 	 2.38973194878696115761584906067583e-01 2.27625216137249258840924426294805e-01 1.36366857778165797600300468417345e-03
 	 2.38973194878696115761584906067583e-01 5.33401588984054542130763820750872e-01 1.36366857778165797600300468417345e-03
 	 2.27625216137249258840924426294805e-01 2.38973194878696115761584906067583e-01 1.36366857778165797600300468417345e-03
 	 2.27625216137249258840924426294805e-01 5.33401588984054542130763820750872e-01 1.36366857778165797600300468417345e-03
 	 5.33401588984054542130763820750872e-01 2.38973194878696115761584906067583e-01 1.36366857778165797600300468417345e-03
 	 5.33401588984054542130763820750872e-01 2.27625216137249258840924426294805e-01 1.36366857778165797600300468417345e-03
 	 2.26522885981175758907113504392328e-01 1.14203037751511859987374464253662e-01 1.90891918002090770975498479344878e-03
 	 2.26522885981175758907113504392328e-01 6.59274076267312381105512031354010e-01 1.90891918002090770975498479344878e-03
 	 1.14203037751511859987374464253662e-01 2.26522885981175758907113504392328e-01 1.90891918002090770975498479344878e-03
 	 1.14203037751511859987374464253662e-01 6.59274076267312381105512031354010e-01 1.90891918002090770975498479344878e-03
 	 6.59274076267312381105512031354010e-01 2.26522885981175758907113504392328e-01 1.90891918002090770975498479344878e-03
 	 6.59274076267312381105512031354010e-01 1.14203037751511859987374464253662e-01 1.90891918002090770975498479344878e-03
 	 2.39590524037790186806518022422097e-01 8.03750594685513908288498896581586e-02 1.62179496424432779966284812189770e-03
 	 2.39590524037790186806518022422097e-01 6.80034416493658366853480856661918e-01 1.62179496424432779966284812189770e-03
 	 8.03750594685513908288498896581586e-02 2.39590524037790186806518022422097e-01 1.62179496424432779966284812189770e-03
 	 8.03750594685513908288498896581586e-02 6.80034416493658366853480856661918e-01 1.62179496424432779966284812189770e-03
 	 6.80034416493658366853480856661918e-01 2.39590524037790186806518022422097e-01 1.62179496424432779966284812189770e-03
 	 6.80034416493658366853480856661918e-01 8.03750594685513908288498896581586e-02 1.62179496424432779966284812189770e-03
 	 1.78291402992592273868410757131642e-01 3.06183636824900254347348038663768e-02 9.42482859192453098669262079312148e-04
 	 1.78291402992592273868410757131642e-01 7.91090233324917679880172727280296e-01 9.42482859192453098669262079312148e-04
 	 3.06183636824900254347348038663768e-02 1.78291402992592273868410757131642e-01 9.42482859192453098669262079312148e-04
 	 3.06183636824900254347348038663768e-02 7.91090233324917679880172727280296e-01 9.42482859192453098669262079312148e-04
 	 7.91090233324917679880172727280296e-01 1.78291402992592273868410757131642e-01 9.42482859192453098669262079312148e-04
 	 7.91090233324917679880172727280296e-01 3.06183636824900254347348038663768e-02 9.42482859192453098669262079312148e-04
 	 2.82586689120417511311700309306616e-01 2.69421027814230988617349993319294e-02 1.09036119380348994409302143537843e-03
 	 2.82586689120417511311700309306616e-01 6.90471208098159427990481162851211e-01 1.09036119380348994409302143537843e-03
 	 2.69421027814230988617349993319294e-02 2.82586689120417511311700309306616e-01 1.09036119380348994409302143537843e-03
 	 2.69421027814230988617349993319294e-02 6.90471208098159427990481162851211e-01 1.09036119380348994409302143537843e-03
 	 6.90471208098159427990481162851211e-01 2.82586689120417511311700309306616e-01 1.09036119380348994409302143537843e-03
 	 6.90471208098159427990481162851211e-01 2.69421027814230988617349993319294e-02 1.09036119380348994409302143537843e-03
 	 1.37257110258729553287082580936840e-01 3.27972135469326506185261393966357e-02 9.17290619580521512585469245948389e-04
 	 1.37257110258729553287082580936840e-01 8.29945676194337789155497375759296e-01 9.17290619580521512585469245948389e-04
 	 3.27972135469326506185261393966357e-02 1.37257110258729553287082580936840e-01 9.17290619580521512585469245948389e-04
 	 3.27972135469326506185261393966357e-02 8.29945676194337789155497375759296e-01 9.17290619580521512585469245948389e-04
 	 8.29945676194337789155497375759296e-01 1.37257110258729553287082580936840e-01 9.17290619580521512585469245948389e-04
 	 8.29945676194337789155497375759296e-01 3.27972135469326506185261393966357e-02 9.17290619580521512585469245948389e-04
 	 1.00254415236569610625494419764436e-01 3.27271127336489636716621021150786e-02 8.13669897716354098907154401842945e-04
 	 1.00254415236569610625494419764436e-01 8.67018472029781439580631285934942e-01 8.13669897716354098907154401842945e-04
 	 3.27271127336489636716621021150786e-02 1.00254415236569610625494419764436e-01 8.13669897716354098907154401842945e-04
 	 3.27271127336489636716621021150786e-02 8.67018472029781439580631285934942e-01 8.13669897716354098907154401842945e-04
 	 8.67018472029781439580631285934942e-01 1.00254415236569610625494419764436e-01 8.13669897716354098907154401842945e-04
 	 8.67018472029781439580631285934942e-01 3.27271127336489636716621021150786e-02 8.13669897716354098907154401842945e-04
 	 5.17074765599652777514627643995482e-02 1.51601013138725621010038935310149e-02 4.14266410586361995705556582336726e-04
 	 5.17074765599652777514627643995482e-02 9.33132422126162097697488206904382e-01 4.14266410586361995705556582336726e-04
 	 1.51601013138725621010038935310149e-02 5.17074765599652777514627643995482e-02 4.14266410586361995705556582336726e-04
 	 1.51601013138725621010038935310149e-02 9.33132422126162097697488206904382e-01 4.14266410586361995705556582336726e-04
 	 9.33132422126162097697488206904382e-01 5.17074765599652777514627643995482e-02 4.14266410586361995705556582336726e-04
 	 9.33132422126162097697488206904382e-01 1.51601013138725621010038935310149e-02 4.14266410586361995705556582336726e-04
 	 2.60614855137656920014421757514356e-01 1.70884652952977555973035350689315e-01 2.55374504338384258547711702647121e-03
 	 2.60614855137656920014421757514356e-01 5.68500491909365468501391660538502e-01 2.55374504338384258547711702647121e-03
 	 1.70884652952977555973035350689315e-01 2.60614855137656920014421757514356e-01 2.55374504338384258547711702647121e-03
 	 1.70884652952977555973035350689315e-01 5.68500491909365468501391660538502e-01 2.55374504338384258547711702647121e-03
 	 5.68500491909365468501391660538502e-01 2.60614855137656920014421757514356e-01 2.55374504338384258547711702647121e-03
 	 5.68500491909365468501391660538502e-01 1.70884652952977555973035350689315e-01 2.55374504338384258547711702647121e-03
 	 2.27214324959957303384783244837308e-01 2.86632862041672348274445880633721e-02 1.11955667944577640093850590119473e-03
 	 2.27214324959957303384783244837308e-01 7.44122388835875447909984359284863e-01 1.11955667944577640093850590119473e-03
 	 2.86632862041672348274445880633721e-02 2.27214324959957303384783244837308e-01 1.11955667944577640093850590119473e-03
 	 2.86632862041672348274445880633721e-02 7.44122388835875447909984359284863e-01 1.11955667944577640093850590119473e-03
 	 7.44122388835875447909984359284863e-01 2.27214324959957303384783244837308e-01 1.11955667944577640093850590119473e-03
 	 7.44122388835875447909984359284863e-01 2.86632862041672348274445880633721e-02 1.11955667944577640093850590119473e-03
 	 3.11040487235050899794686074528727e-01 1.26956715659609486318570858998100e-02 8.20086182210518952438726980602723e-04
 	 3.11040487235050899794686074528727e-01 6.76263841198988080449794324522372e-01 8.20086182210518952438726980602723e-04
 	 1.26956715659609486318570858998100e-02 3.11040487235050899794686074528727e-01 8.20086182210518952438726980602723e-04
 	 1.26956715659609486318570858998100e-02 6.76263841198988080449794324522372e-01 8.20086182210518952438726980602723e-04
 	 6.76263841198988080449794324522372e-01 3.11040487235050899794686074528727e-01 8.20086182210518952438726980602723e-04
 	 6.76263841198988080449794324522372e-01 1.26956715659609486318570858998100e-02 8.20086182210518952438726980602723e-04
 	 1.85623876299053219840473616386589e-01 8.79015352488810713937894547598262e-02 1.83583569658886782208218058087823e-03
 	 1.85623876299053219840473616386589e-01 7.26474588452065694887949121039128e-01 1.83583569658886782208218058087823e-03
 	 8.79015352488810713937894547598262e-02 1.85623876299053219840473616386589e-01 1.83583569658886782208218058087823e-03
 	 8.79015352488810713937894547598262e-02 7.26474588452065694887949121039128e-01 1.83583569658886782208218058087823e-03
 	 7.26474588452065694887949121039128e-01 1.85623876299053219840473616386589e-01 1.83583569658886782208218058087823e-03
 	 7.26474588452065694887949121039128e-01 8.79015352488810713937894547598262e-02 1.83583569658886782208218058087823e-03
 	 6.58626437608177683902255239445367e-02 3.07203461767424183814778615442265e-02 7.06502470799715205120039573927215e-04
 	 6.58626437608177683902255239445367e-02 9.03417010062439795881061854743166e-01 7.06502470799715205120039573927215e-04
 	 3.07203461767424183814778615442265e-02 6.58626437608177683902255239445367e-02 7.06502470799715205120039573927215e-04
 	 3.07203461767424183814778615442265e-02 9.03417010062439795881061854743166e-01 7.06502470799715205120039573927215e-04
 	 9.03417010062439795881061854743166e-01 6.58626437608177683902255239445367e-02 7.06502470799715205120039573927215e-04
 	 9.03417010062439795881061854743166e-01 3.07203461767424183814778615442265e-02 7.06502470799715205120039573927215e-04
 	 3.01590470095362273017514098683023e-01 2.81455063987638438166571930310056e-03 3.82221000431039019135798229243051e-04
 	 3.01590470095362273017514098683023e-01 6.95594979264761437143249622749863e-01 3.82221000431039019135798229243051e-04
 	 2.81455063987638438166571930310056e-03 3.01590470095362273017514098683023e-01 3.82221000431039019135798229243051e-04
 	 2.81455063987638438166571930310056e-03 6.95594979264761437143249622749863e-01 3.82221000431039019135798229243051e-04
 	 6.95594979264761437143249622749863e-01 3.01590470095362273017514098683023e-01 3.82221000431039019135798229243051e-04
 	 6.95594979264761437143249622749863e-01 2.81455063987638438166571930310056e-03 3.82221000431039019135798229243051e-04
 	 2.92542657654236315512008559380774e-01 7.98394163722915967129623027176422e-02 1.97701581302659997255166679508420e-03
 	 2.92542657654236315512008559380774e-01 6.27617925973472101652816945716040e-01 1.97701581302659997255166679508420e-03
 	 7.98394163722915967129623027176422e-02 2.92542657654236315512008559380774e-01 1.97701581302659997255166679508420e-03
 	 7.98394163722915967129623027176422e-02 6.27617925973472101652816945716040e-01 1.97701581302659997255166679508420e-03
 	 6.27617925973472101652816945716040e-01 2.92542657654236315512008559380774e-01 1.97701581302659997255166679508420e-03
 	 6.27617925973472101652816945716040e-01 7.98394163722915967129623027176422e-02 1.97701581302659997255166679508420e-03
 	 2.73024847528849125277705667258488e-02 1.33211979027671369862906303183081e-02 3.22416772478557639609875185016108e-04
 	 2.73024847528849125277705667258488e-02 9.59376317344348028548495221912162e-01 3.22416772478557639609875185016108e-04
 	 1.33211979027671369862906303183081e-02 2.73024847528849125277705667258488e-02 3.22416772478557639609875185016108e-04
 	 1.33211979027671369862906303183081e-02 9.59376317344348028548495221912162e-01 3.22416772478557639609875185016108e-04
 	 9.59376317344348028548495221912162e-01 2.73024847528849125277705667258488e-02 3.22416772478557639609875185016108e-04
 	 9.59376317344348028548495221912162e-01 1.33211979027671369862906303183081e-02 3.22416772478557639609875185016108e-04
 	 3.71571920577544234642886067376821e-01 9.60218601811555806657683120874935e-03 7.77378451269038206472572483107797e-04
 	 3.71571920577544234642886067376821e-01 6.18825893404340132697427634411724e-01 7.77378451269038206472572483107797e-04
 	 9.60218601811555806657683120874935e-03 3.71571920577544234642886067376821e-01 7.77378451269038206472572483107797e-04
 	 9.60218601811555806657683120874935e-03 6.18825893404340132697427634411724e-01 7.77378451269038206472572483107797e-04
 	 6.18825893404340132697427634411724e-01 3.71571920577544234642886067376821e-01 7.77378451269038206472572483107797e-04
 	 6.18825893404340132697427634411724e-01 9.60218601811555806657683120874935e-03 7.77378451269038206472572483107797e-04
 	 2.01007303993687103105258984214743e-01 2.50243738523270699627976121348638e-03 3.13239896240612636021949377607143e-04
 	 2.01007303993687103105258984214743e-01 7.96490258621080249312740306777414e-01 3.13239896240612636021949377607143e-04
 	 2.50243738523270699627976121348638e-03 2.01007303993687103105258984214743e-01 3.13239896240612636021949377607143e-04
 	 2.50243738523270699627976121348638e-03 7.96490258621080249312740306777414e-01 3.13239896240612636021949377607143e-04
 	 7.96490258621080249312740306777414e-01 2.01007303993687103105258984214743e-01 3.13239896240612636021949377607143e-04
 	 7.96490258621080249312740306777414e-01 2.50243738523270699627976121348638e-03 3.13239896240612636021949377607143e-04
 	 2.93183129372266426670989858394023e-01 2.01730828065996542486359999202250e-01 2.99590287508692950865785142866571e-03
 	 2.93183129372266426670989858394023e-01 5.05086042561737058598225758032640e-01 2.99590287508692950865785142866571e-03
 	 2.01730828065996542486359999202250e-01 2.93183129372266426670989858394023e-01 2.99590287508692950865785142866571e-03
 	 2.01730828065996542486359999202250e-01 5.05086042561737058598225758032640e-01 2.99590287508692950865785142866571e-03
 	 5.05086042561737058598225758032640e-01 2.93183129372266426670989858394023e-01 2.99590287508692950865785142866571e-03
 	 5.05086042561737058598225758032640e-01 2.01730828065996542486359999202250e-01 2.99590287508692950865785142866571e-03
 	 2.33331891103622568461872788248002e-01 5.26776823006486205613896345312241e-02 1.52920890728200538355441295834680e-03
 	 2.33331891103622568461872788248002e-01 7.13990426595728755465586345962947e-01 1.52920890728200538355441295834680e-03
 	 5.26776823006486205613896345312241e-02 2.33331891103622568461872788248002e-01 1.52920890728200538355441295834680e-03
 	 5.26776823006486205613896345312241e-02 7.13990426595728755465586345962947e-01 1.52920890728200538355441295834680e-03
 	 7.13990426595728755465586345962947e-01 2.33331891103622568461872788248002e-01 1.52920890728200538355441295834680e-03
 	 7.13990426595728755465586345962947e-01 5.26776823006486205613896345312241e-02 1.52920890728200538355441295834680e-03
 	 1.79299141897004327139697466009238e-01 5.57691461107685942932832290352962e-02 1.49820395207656323864620073749165e-03
 	 1.79299141897004327139697466009238e-01 7.64931711992227092444807112769922e-01 1.49820395207656323864620073749165e-03
 	 5.57691461107685942932832290352962e-02 1.79299141897004327139697466009238e-01 1.49820395207656323864620073749165e-03
 	 5.57691461107685942932832290352962e-02 7.64931711992227092444807112769922e-01 1.49820395207656323864620073749165e-03
 	 7.64931711992227092444807112769922e-01 1.79299141897004327139697466009238e-01 1.49820395207656323864620073749165e-03
 	 7.64931711992227092444807112769922e-01 5.57691461107685942932832290352962e-02 1.49820395207656323864620073749165e-03
 	 2.93435331129092979995931500525330e-01 4.82367013092171934007801326060871e-02 1.61668679165861322102881736384461e-03
 	 2.93435331129092979995931500525330e-01 6.58327967561689875175545694219181e-01 1.61668679165861322102881736384461e-03
 	 4.82367013092171934007801326060871e-02 2.93435331129092979995931500525330e-01 1.61668679165861322102881736384461e-03
 	 4.82367013092171934007801326060871e-02 6.58327967561689875175545694219181e-01 1.61668679165861322102881736384461e-03
 	 6.58327967561689875175545694219181e-01 2.93435331129092979995931500525330e-01 1.61668679165861322102881736384461e-03
 	 6.58327967561689875175545694219181e-01 4.82367013092171934007801326060871e-02 1.61668679165861322102881736384461e-03
 	 3.29840596275619235555609520815779e-01 2.33697583553122173460891985996568e-01 3.32318218248998454092402177195709e-03
 	 3.29840596275619235555609520815779e-01 4.36461820171258563227922877558740e-01 3.32318218248998454092402177195709e-03
 	 2.33697583553122173460891985996568e-01 3.29840596275619235555609520815779e-01 3.32318218248998454092402177195709e-03
 	 2.33697583553122173460891985996568e-01 4.36461820171258563227922877558740e-01 3.32318218248998454092402177195709e-03
 	 4.36461820171258563227922877558740e-01 3.29840596275619235555609520815779e-01 3.32318218248998454092402177195709e-03
 	 4.36461820171258563227922877558740e-01 2.33697583553122173460891985996568e-01 3.32318218248998454092402177195709e-03
 	 1.38175693611527594661936291231541e-01 9.26621506087761254155665824328025e-02 1.59745246645443027613819886312285e-03
 	 1.38175693611527594661936291231541e-01 7.69162155779696266044709318521200e-01 1.59745246645443027613819886312285e-03
 	 9.26621506087761254155665824328025e-02 1.38175693611527594661936291231541e-01 1.59745246645443027613819886312285e-03
 	 9.26621506087761254155665824328025e-02 7.69162155779696266044709318521200e-01 1.59745246645443027613819886312285e-03
 	 7.69162155779696266044709318521200e-01 1.38175693611527594661936291231541e-01 1.59745246645443027613819886312285e-03
 	 7.69162155779696266044709318521200e-01 9.26621506087761254155665824328025e-02 1.59745246645443027613819886312285e-03
 	 3.58512865776101086190408295806265e-01 1.73454768103072393126140582353401e-01 3.08099584148886947165824068406437e-03
 	 3.58512865776101086190408295806265e-01 4.68032366120826548439026737469248e-01 3.08099584148886947165824068406437e-03
 	 1.73454768103072393126140582353401e-01 3.58512865776101086190408295806265e-01 3.08099584148886947165824068406437e-03
 	 1.73454768103072393126140582353401e-01 4.68032366120826548439026737469248e-01 3.08099584148886947165824068406437e-03
 	 4.68032366120826548439026737469248e-01 3.58512865776101086190408295806265e-01 3.08099584148886947165824068406437e-03
 	 4.68032366120826548439026737469248e-01 1.73454768103072393126140582353401e-01 3.08099584148886947165824068406437e-03
 	 4.20337783466548764454984166150098e-01 1.78508936465828042805537023696161e-02 1.09190886564487473278650675467816e-03
 	 4.20337783466548764454984166150098e-01 5.61811322886868524939529834227869e-01 1.09190886564487473278650675467816e-03
 	 1.78508936465828042805537023696161e-02 4.20337783466548764454984166150098e-01 1.09190886564487473278650675467816e-03
 	 1.78508936465828042805537023696161e-02 5.61811322886868524939529834227869e-01 1.09190886564487473278650675467816e-03
 	 5.61811322886868524939529834227869e-01 4.20337783466548764454984166150098e-01 1.09190886564487473278650675467816e-03
 	 5.61811322886868524939529834227869e-01 1.78508936465828042805537023696161e-02 1.09190886564487473278650675467816e-03
 	 2.79051133003480611449731441098265e-01 1.19946692495847162529543084019679e-01 2.41911437679862570751532224733182e-03
 	 2.79051133003480611449731441098265e-01 6.01002174500672170509574243624229e-01 2.41911437679862570751532224733182e-03
 	 1.19946692495847162529543084019679e-01 2.79051133003480611449731441098265e-01 2.41911437679862570751532224733182e-03
 	 1.19946692495847162529543084019679e-01 6.01002174500672170509574243624229e-01 2.41911437679862570751532224733182e-03
 	 6.01002174500672170509574243624229e-01 2.79051133003480611449731441098265e-01 2.41911437679862570751532224733182e-03
 	 6.01002174500672170509574243624229e-01 1.19946692495847162529543084019679e-01 2.41911437679862570751532224733182e-03
 	 9.34626722493710621053608633701515e-02 1.39846172517608963864477189531499e-02 5.85471759754055626548407964548915e-04
 	 9.34626722493710621053608633701515e-02 8.92552710498867973853975854581222e-01 5.85471759754055626548407964548915e-04
 	 1.39846172517608963864477189531499e-02 9.34626722493710621053608633701515e-02 5.85471759754055626548407964548915e-04
 	 1.39846172517608963864477189531499e-02 8.92552710498867973853975854581222e-01 5.85471759754055626548407964548915e-04
 	 8.92552710498867973853975854581222e-01 9.34626722493710621053608633701515e-02 5.85471759754055626548407964548915e-04
 	 8.92552710498867973853975854581222e-01 1.39846172517608963864477189531499e-02 5.85471759754055626548407964548915e-04
 	 3.87408987689019879141483215789776e-01 1.19357764315077496952710589539493e-01 2.70374842821991760027922069298256e-03
 	 3.87408987689019879141483215789776e-01 4.93233247995902623905806194670731e-01 2.70374842821991760027922069298256e-03
 	 1.19357764315077496952710589539493e-01 3.87408987689019879141483215789776e-01 2.70374842821991760027922069298256e-03
 	 1.19357764315077496952710589539493e-01 4.93233247995902623905806194670731e-01 2.70374842821991760027922069298256e-03
 	 4.93233247995902623905806194670731e-01 3.87408987689019879141483215789776e-01 2.70374842821991760027922069298256e-03
 	 4.93233247995902623905806194670731e-01 1.19357764315077496952710589539493e-01 2.70374842821991760027922069298256e-03
 	 4.07184695661520157372592620959040e-01 7.35846549853617637459990419301903e-02 2.26669456187450968007168761175762e-03
 	 4.07184695661520157372592620959040e-01 5.19230649353118023370257105852943e-01 2.26669456187450968007168761175762e-03
 	 7.35846549853617637459990419301903e-02 4.07184695661520157372592620959040e-01 2.26669456187450968007168761175762e-03
 	 7.35846549853617637459990419301903e-02 5.19230649353118023370257105852943e-01 2.26669456187450968007168761175762e-03
 	 5.19230649353118023370257105852943e-01 4.07184695661520157372592620959040e-01 2.26669456187450968007168761175762e-03
 	 5.19230649353118023370257105852943e-01 7.35846549853617637459990419301903e-02 2.26669456187450968007168761175762e-03
 	 1.87640583389709708628245721229177e-01 1.27167478485407797750283975801722e-02 7.63422222268318587980184819485885e-04
 	 1.87640583389709708628245721229177e-01 7.99642668761749497718938073376194e-01 7.63422222268318587980184819485885e-04
 	 1.27167478485407797750283975801722e-02 1.87640583389709708628245721229177e-01 7.63422222268318587980184819485885e-04
 	 1.27167478485407797750283975801722e-02 7.99642668761749497718938073376194e-01 7.63422222268318587980184819485885e-04
 	 7.99642668761749497718938073376194e-01 1.87640583389709708628245721229177e-01 7.63422222268318587980184819485885e-04
 	 7.99642668761749497718938073376194e-01 1.27167478485407797750283975801722e-02 7.63422222268318587980184819485885e-04
 	 1.52225526038276298690377075217839e-01 2.44038040768785029904774930287203e-03 2.99277879376055508907350510838796e-04
 	 1.52225526038276298690377075217839e-01 8.45334093554035770345933542557759e-01 2.99277879376055508907350510838796e-04
 	 2.44038040768785029904774930287203e-03 1.52225526038276298690377075217839e-01 2.99277879376055508907350510838796e-04
 	 2.44038040768785029904774930287203e-03 8.45334093554035770345933542557759e-01 2.99277879376055508907350510838796e-04
 	 8.45334093554035770345933542557759e-01 1.52225526038276298690377075217839e-01 2.99277879376055508907350510838796e-04
 	 8.45334093554035770345933542557759e-01 2.44038040768785029904774930287203e-03 2.99277879376055508907350510838796e-04
 	 1.74142001786563360710147208010312e-01 1.29890625977294477122470084395900e-01 2.11066871570363048110641202015358e-03
 	 1.74142001786563360710147208010312e-01 6.95967372236142134411807091964874e-01 2.11066871570363048110641202015358e-03
 	 1.29890625977294477122470084395900e-01 1.74142001786563360710147208010312e-01 2.11066871570363048110641202015358e-03
 	 1.29890625977294477122470084395900e-01 6.95967372236142134411807091964874e-01 2.11066871570363048110641202015358e-03
 	 6.95967372236142134411807091964874e-01 1.74142001786563360710147208010312e-01 2.11066871570363048110641202015358e-03
 	 6.95967372236142134411807091964874e-01 1.29890625977294477122470084395900e-01 2.11066871570363048110641202015358e-03
 	 3.21408155175526122349083379958756e-01 1.43880630387304531137004914853605e-01 2.75728111566974709925603725935161e-03
 	 3.21408155175526122349083379958756e-01 5.34711214437169291002760473929811e-01 2.75728111566974709925603725935161e-03
 	 1.43880630387304531137004914853605e-01 3.21408155175526122349083379958756e-01 2.75728111566974709925603725935161e-03
 	 1.43880630387304531137004914853605e-01 5.34711214437169291002760473929811e-01 2.75728111566974709925603725935161e-03
 	 5.34711214437169291002760473929811e-01 3.21408155175526122349083379958756e-01 2.75728111566974709925603725935161e-03
 	 5.34711214437169291002760473929811e-01 1.43880630387304531137004914853605e-01 2.75728111566974709925603725935161e-03
 	 8.88043361734264791174098263581982e-02 5.88598092883567541866440819831041e-02 1.16858890495533281062012775919356e-03
 	 8.88043361734264791174098263581982e-02 8.52335854538216697307007052586414e-01 1.16858890495533281062012775919356e-03
 	 5.88598092883567541866440819831041e-02 8.88043361734264791174098263581982e-02 1.16858890495533281062012775919356e-03
 	 5.88598092883567541866440819831041e-02 8.52335854538216697307007052586414e-01 1.16858890495533281062012775919356e-03
 	 8.52335854538216697307007052586414e-01 8.88043361734264791174098263581982e-02 1.16858890495533281062012775919356e-03
 	 8.52335854538216697307007052586414e-01 5.88598092883567541866440819831041e-02 1.16858890495533281062012775919356e-03
 	 1.30428915551712210074697395612020e-01 6.02973413848093622857682305493654e-02 1.39399447633984903752168982293824e-03
 	 1.30428915551712210074697395612020e-01 8.09273743063478434578428277745843e-01 1.39399447633984903752168982293824e-03
 	 6.02973413848093622857682305493654e-02 1.30428915551712210074697395612020e-01 1.39399447633984903752168982293824e-03
 	 6.02973413848093622857682305493654e-02 8.09273743063478434578428277745843e-01 1.39399447633984903752168982293824e-03
 	 8.09273743063478434578428277745843e-01 1.30428915551712210074697395612020e-01 1.39399447633984903752168982293824e-03
 	 8.09273743063478434578428277745843e-01 6.02973413848093622857682305493654e-02 1.39399447633984903752168982293824e-03
 	 1.36837912722210020000090935354820e-01 1.32254525993588060300831799054322e-02 7.15287497685284149283313492873049e-04
 	 1.36837912722210020000090935354820e-01 8.49936634678431168765655456809327e-01 7.15287497685284149283313492873049e-04
 	 1.32254525993588060300831799054322e-02 1.36837912722210020000090935354820e-01 7.15287497685284149283313492873049e-04
 	 1.32254525993588060300831799054322e-02 8.49936634678431168765655456809327e-01 7.15287497685284149283313492873049e-04
 	 8.49936634678431168765655456809327e-01 1.36837912722210020000090935354820e-01 7.15287497685284149283313492873049e-04
 	 8.49936634678431168765655456809327e-01 1.32254525993588060300831799054322e-02 7.15287497685284149283313492873049e-04
 	 3.52853359179670589274024905535043e-01 5.72712595019886847036438837221795e-02 1.98602112093872228484880970711401e-03
 	 3.52853359179670589274024905535043e-01 5.89875381318340830105739769351203e-01 1.98602112093872228484880970711401e-03
 	 5.72712595019886847036438837221795e-02 3.52853359179670589274024905535043e-01 1.98602112093872228484880970711401e-03
 	 5.72712595019886847036438837221795e-02 5.89875381318340830105739769351203e-01 1.98602112093872228484880970711401e-03
 	 5.89875381318340830105739769351203e-01 3.52853359179670589274024905535043e-01 1.98602112093872228484880970711401e-03
 	 5.89875381318340830105739769351203e-01 5.72712595019886847036438837221795e-02 1.98602112093872228484880970711401e-03
 	 2.46386900217142157387684164859820e-01 1.09336475862860226654360573661506e-02 8.11510714695543727836835046218766e-04
 	 2.46386900217142157387684164859820e-01 7.42679452196571832089944109611679e-01 8.11510714695543727836835046218766e-04
 	 1.09336475862860226654360573661506e-02 2.46386900217142157387684164859820e-01 8.11510714695543727836835046218766e-04
 	 1.09336475862860226654360573661506e-02 7.42679452196571832089944109611679e-01 8.11510714695543727836835046218766e-04
 	 7.42679452196571832089944109611679e-01 2.46386900217142157387684164859820e-01 8.11510714695543727836835046218766e-04
 	 7.42679452196571832089944109611679e-01 1.09336475862860226654360573661506e-02 8.11510714695543727836835046218766e-04
 	 3.43520044059471285624596248453599e-01 9.59251650895475566072079232071701e-02 2.41542743894754448341632979690985e-03
 	 3.43520044059471285624596248453599e-01 5.60554790850981254912710483040428e-01 2.41542743894754448341632979690985e-03
 	 9.59251650895475566072079232071701e-02 3.43520044059471285624596248453599e-01 2.41542743894754448341632979690985e-03
 	 9.59251650895475566072079232071701e-02 5.60554790850981254912710483040428e-01 2.41542743894754448341632979690985e-03
 	 5.60554790850981254912710483040428e-01 3.43520044059471285624596248453599e-01 2.41542743894754448341632979690985e-03
 	 5.60554790850981254912710483040428e-01 9.59251650895475566072079232071701e-02 2.41542743894754448341632979690985e-03
 	 4.16208963636464202018316882458748e-01 3.96704297157567664644517435590387e-02 1.76983940807325101918223708707956e-03
 	 4.16208963636464202018316882458748e-01 5.44120606647779059272806989611126e-01 1.76983940807325101918223708707956e-03
 	 3.96704297157567664644517435590387e-02 4.16208963636464202018316882458748e-01 1.76983940807325101918223708707956e-03
 	 3.96704297157567664644517435590387e-02 5.44120606647779059272806989611126e-01 1.76983940807325101918223708707956e-03
 	 5.44120606647779059272806989611126e-01 4.16208963636464202018316882458748e-01 1.76983940807325101918223708707956e-03
 	 5.44120606647779059272806989611126e-01 3.96704297157567664644517435590387e-02 1.76983940807325101918223708707956e-03
 	 3.90118106999857716665758289309451e-02 2.79504775052941568241893222079852e-03 1.83532994709030615552297627246503e-04
 	 3.90118106999857716665758289309451e-02 9.58193141549484872498965160048101e-01 1.83532994709030615552297627246503e-04
 	 2.79504775052941568241893222079852e-03 3.90118106999857716665758289309451e-02 1.83532994709030615552297627246503e-04
 	 2.79504775052941568241893222079852e-03 9.58193141549484872498965160048101e-01 1.83532994709030615552297627246503e-04
 	 9.58193141549484872498965160048101e-01 3.90118106999857716665758289309451e-02 1.83532994709030615552297627246503e-04
 	 9.58193141549484872498965160048101e-01 2.79504775052941568241893222079852e-03 1.83532994709030615552297627246503e-04
 	 1.07180714134606072662769804537675e-01 2.66661165267688318042393902373988e-03 2.85484954702090840301942353818276e-04
 	 1.07180714134606072662769804537675e-01 8.90152674212717043289444518450182e-01 2.85484954702090840301942353818276e-04
 	 2.66661165267688318042393902373988e-03 1.07180714134606072662769804537675e-01 2.85484954702090840301942353818276e-04
 	 2.66661165267688318042393902373988e-03 8.90152674212717043289444518450182e-01 2.85484954702090840301942353818276e-04
 	 8.90152674212717043289444518450182e-01 1.07180714134606072662769804537675e-01 2.85484954702090840301942353818276e-04
 	 8.90152674212717043289444518450182e-01 2.66661165267688318042393902373988e-03 2.85484954702090840301942353818276e-04
 	 4.26423819706326090450687615884817e-01 2.53953007625778645617309337012557e-03 4.38056769584410936237833800177555e-04
 	 4.26423819706326090450687615884817e-01 5.71036650217416119623692338791443e-01 4.38056769584410936237833800177555e-04
 	 2.53953007625778645617309337012557e-03 4.26423819706326090450687615884817e-01 4.38056769584410936237833800177555e-04
 	 2.53953007625778645617309337012557e-03 5.71036650217416119623692338791443e-01 4.38056769584410936237833800177555e-04
 	 5.71036650217416119623692338791443e-01 4.26423819706326090450687615884817e-01 4.38056769584410936237833800177555e-04
 	 5.71036650217416119623692338791443e-01 2.53953007625778645617309337012557e-03 4.38056769584410936237833800177555e-04
 	 3.51960131363829642481277915067039e-01 2.87313755582887971062877596750695e-02 1.54355548746208225824316784269286e-03
 	 3.51960131363829642481277915067039e-01 6.19308493077881605515244700654875e-01 1.54355548746208225824316784269286e-03
 	 2.87313755582887971062877596750695e-02 3.51960131363829642481277915067039e-01 1.54355548746208225824316784269286e-03
 	 2.87313755582887971062877596750695e-02 6.19308493077881605515244700654875e-01 1.54355548746208225824316784269286e-03
 	 6.19308493077881605515244700654875e-01 3.51960131363829642481277915067039e-01 1.54355548746208225824316784269286e-03
 	 6.19308493077881605515244700654875e-01 2.87313755582887971062877596750695e-02 1.54355548746208225824316784269286e-03
 	 ];
 
 	 case  46 

 	 % ALG. DEG.:   46
 	 % PTS CARD.:  385
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.5e-16  

 	 xyw=[
 	 3.33333333333333259318465024989564e-01 3.33333333333333370340767487505218e-01 3.31752356160357978615005336564536e-03
 	 4.79162709481021631408026451026672e-01 4.79162709481021131807665369706228e-01 7.53181193949777364957109959675563e-04
 	 4.79162709481021131807665369706228e-01 4.16745810379577363846692605875432e-02 7.53181193949798506899473427012026e-04
 	 4.16745810379577363846692605875432e-02 4.79162709481021131807665369706228e-01 7.53181193949784520691448364004827e-04
 	 4.86830795833198479161119109903666e-02 4.86830795833199450606265656915639e-02 6.23734590822669354714946621243143e-04
 	 4.86830795833203405775790884035814e-02 9.02633840833359735178476057626540e-01 6.23734590822674016784288308912210e-04
 	 9.02633840833359957223080982657848e-01 4.86830795833199034272631422481936e-02 6.23734590822674450465157303113983e-04
 	 4.86849434452577278786833403501078e-01 4.86849434452579887810941272618948e-01 1.09475819165004016782216655911952e-03
 	 4.86849434452579221677126497525023e-01 2.63011310948429340161869305347864e-02 1.09475819165005556349301585328249e-03
 	 2.63011310948430207523607293751411e-02 4.86849434452578500032160491173272e-01 1.09475819165005512981214685908071e-03
 	 1.96294809229449668253053573607758e-01 1.96294809229449557230751111092104e-01 2.26630825917091332719066620882131e-03
 	 1.96294809229449473964024264205364e-01 6.07410381541100830027346546557965e-01 2.26630825917092243448891508705856e-03
 	 6.07410381541100719005044084042311e-01 1.96294809229449668253053573607758e-01 2.26630825917091506191414218562841e-03
 	 1.65798716567096271479186953001772e-01 1.65798716567096021679006412341550e-01 2.05606677560804832968766042711195e-03
 	 1.65798716567095744123250256052415e-01 6.68402566865807901130835944059072e-01 2.05606677560805310017721936333146e-03
 	 6.68402566865807790108533481543418e-01 1.65798716567096271479186953001772e-01 2.05606677560805136545374338652437e-03
 	 2.29007117787044744972035914543085e-01 2.29007117787044606194157836398517e-01 2.66814199893166282412382273037110e-03
 	 2.29007117787044633949733452027431e-01 5.41985764425910621078230633429484e-01 2.66814199893166846197511965499416e-03
 	 5.41985764425910510055928170913830e-01 2.29007117787044689460884683285258e-01 2.66814199893166455884729870717820e-03
 	 2.99898101879728595786644973486545e-01 2.99898101879728706808947436002200e-01 3.23781096391131777145755421543072e-03
 	 2.99898101879728540275493742228718e-01 4.00203796240542808426710053026909e-01 3.23781096391131603673407823862362e-03
 	 4.00203796240542586382105127995601e-01 2.99898101879728706808947436002200e-01 3.23781096391131777145755421543072e-03
 	 3.66081261411425273877284780610353e-01 3.66081261411425440410738474383834e-01 3.26415847271571430560088700190136e-03
 	 3.66081261411425384899587243126007e-01 2.67837477177149230200825513747986e-01 3.26415847271571040247306605408539e-03
 	 2.67837477177149174689674282490159e-01 3.66081261411425440410738474383834e-01 3.26415847271571517296262499030490e-03
 	 3.07693439520818311228023134162868e-02 3.07693439520817894894388899729165e-02 4.85854850068560004464068846630198e-04
 	 3.07693439520818831645065927204996e-02 9.38461312095836164282047775486717e-01 4.85854850068562931809934557492170e-04
 	 9.38461312095836275304350238002371e-01 3.07693439520818762256126888132712e-02 4.85854850068562118658305193363844e-04
 	 8.24986937635583394978766591520980e-02 8.24986937635584643979669294822088e-02 1.21934895073771108753302172544863e-03
 	 8.24986937635586309314206232556899e-02 8.35002612472883098959641756664496e-01 1.21934895073771022017128373704509e-03
 	 8.35002612472883098959641756664496e-01 8.24986937635583811312400825954683e-02 1.21934895073771065385215273124686e-03
 	 4.60823004347587883433590150161763e-01 4.60823004347588327522800000224379e-01 2.09410203588819001860321655783537e-03
 	 4.60823004347588272011648768966552e-01 7.83539913048236641435195792837476e-02 2.09410203588819869222059644187084e-03
 	 7.83539913048237196546708105415746e-02 4.60823004347588105478195075193071e-01 2.09410203588819305436929951724778e-03
 	 2.66615708697696796036780142458156e-01 2.66615708697696796036780142458156e-01 2.99313714823755535818228246114359e-03
 	 2.66615708697696685014477679942502e-01 4.66768582604606574459893408857170e-01 2.99313714823755796026749642635423e-03
 	 4.66768582604606352415288483825861e-01 2.66615708697696740525628911200329e-01 2.99313714823755622554402044954713e-03
 	 1.28439434947512309825867760082474e-01 1.28439434947512365337018991340301e-01 1.88674007826653174213493713295975e-03
 	 1.28439434947512337581443375711387e-01 7.43121130104975269325962017319398e-01 1.88674007826653347685841310976684e-03
 	 7.43121130104975269325962017319398e-01 1.28439434947512420848170222598128e-01 1.88674007826653152529450263585886e-03
 	 3.97511575402048289440415373974247e-01 3.97511575402048400462717836489901e-01 3.24082362724327239372756892521465e-03
 	 3.97511575402048289440415373974247e-01 2.04976849195903282341291173906939e-01 3.24082362724327326108930691361820e-03
 	 2.04976849195903282341291173906939e-01 3.97511575402048344951566605232074e-01 3.24082362724327239372756892521465e-03
 	 1.28796984358851961810499275884467e-02 1.28796984358851545476865041450765e-02 2.24673355140022311393632747922311e-04
 	 1.28796984358851684254743119595332e-02 9.74240603128229687435180039756233e-01 2.24673355140022121658252562959035e-04
 	 9.74240603128229687435180039756233e-01 1.28796984358851909768794996580255e-02 2.24673355140022121658252562959035e-04
 	 4.92922242405739816778487139004028e-04 4.92922242405913505966519316814356e-04 7.04761006797478867003147254277629e-06
 	 4.92922242405969776059271314494481e-04 9.99014155515188240208601655467646e-01 7.04761006797526554958077671386718e-06
 	 9.99014155515188240208601655467646e-01 4.92922242405788822716683483804445e-04 7.04761006797529265463508885147803e-06
 	 3.97969764640709822156594555053744e-01 1.54123149166077111349437700482667e-01 2.22685409346650440079451449548742e-03
 	 3.97969764640709822156594555053744e-01 4.47907086193212955471665281947935e-01 2.22685409346649139036844466943421e-03
 	 1.54123149166077250127315778627235e-01 3.97969764640709822156594555053744e-01 2.22685409346650396711364550128565e-03
 	 1.54123149166077055838286469224840e-01 4.47907086193212899960514050690108e-01 2.22685409346649485981539662304840e-03
 	 4.47907086193212677915909125658800e-01 3.97969764640710044201199480085052e-01 2.22685409346650483447538348968919e-03
 	 4.47907086193212899960514050690108e-01 1.54123149166077166860588931740494e-01 2.22685409346650526815625248389097e-03
 	 4.14307607988175896629456929076696e-01 1.13136705924023320268823056267138e-01 2.16000476232081767280490680604998e-03
 	 4.14307607988176007651759391592350e-01 4.72555686087800519423751666181488e-01 2.16000476232081550440056183504112e-03
 	 1.13136705924023375779974287524965e-01 4.14307607988175785607154466561042e-01 2.16000476232081680544316881764644e-03
 	 1.13136705924023334146610864081595e-01 4.72555686087800685957205359954969e-01 2.16000476232081723912403781184821e-03
 	 4.72555686087800852490659053728450e-01 4.14307607988175674584852004045388e-01 2.16000476232081246863447887562870e-03
 	 4.72555686087800796979507822470623e-01 1.13136705924023334146610864081595e-01 2.16000476232081723912403781184821e-03
 	 3.29728249876623691339005972622545e-01 7.30183277797032265210575019409589e-02 1.54343982796946422274275700914359e-03
 	 3.29728249876623746850157203880372e-01 5.97253422343673068262148717622040e-01 1.54343982796946747534927446565689e-03
 	 7.30183277797032403988453097554157e-02 3.29728249876623746850157203880372e-01 1.54343982796946639114710198015246e-03
 	 7.30183277797031987654818863120454e-02 5.97253422343673068262148717622040e-01 1.54343982796946465642362600334536e-03
 	 5.97253422343672735195241330075078e-01 3.29728249876623857872459666396026e-01 1.54343982796946921007275044246398e-03
 	 5.97253422343673068262148717622040e-01 7.30183277797032681544209253843292e-02 1.54343982796946248801928103233649e-03
 	 2.25759242330057757763839276776707e-01 1.09803376807363725631283557504503e-01 1.71511290774016751138619785166384e-03
 	 2.25759242330057646741536814261053e-01 6.64437380862578752527269898564555e-01 1.71511290774016837874793584006738e-03
 	 1.09803376807363559097829863731022e-01 2.25759242330057646741536814261053e-01 1.71511290774017054715228081107625e-03
 	 1.09803376807363406442163977771997e-01 6.64437380862578752527269898564555e-01 1.71511290774016534298185288065497e-03
 	 6.64437380862578752527269898564555e-01 2.25759242330057757763839276776707e-01 1.71511290774016946295010832557182e-03
 	 6.64437380862578419460362511017593e-01 1.09803376807363795020222596576787e-01 1.71511290774016621034359086905852e-03
 	 3.28699347560523824629541422837065e-01 1.02835875371072804629335450954386e-01 1.89138099119562819346029858280644e-03
 	 3.28699347560523325029180341516621e-01 5.68464777068403592785728051239857e-01 1.89138099119564185440767190016231e-03
 	 1.02835875371073026673940375985694e-01 3.28699347560523769118390191579238e-01 1.89138099119564098704593391175877e-03
 	 1.02835875371072846262698874397756e-01 5.68464777068403370741123126208549e-01 1.89138099119562949450290556541177e-03
 	 5.68464777068402926651913276145933e-01 3.28699347560524046674146347868373e-01 1.89138099119563296394985751902595e-03
 	 5.68464777068403481763425588724203e-01 1.02835875371072985040576952542324e-01 1.89138099119563448183289899873216e-03
 	 5.70245183292810500774727699990763e-02 1.04550153444101338873206685775585e-02 3.35215320031304986163334103110856e-04
 	 5.70245183292808210939739410605398e-02 9.32520466326309138693773093109485e-01 3.35215320031302763548880507826766e-04
 	 1.04550153444099378635678831983569e-02 5.70245183292807100716714785448858e-02 3.35215320031299998833340669790459e-04
 	 1.04550153444101685817901881137004e-02 9.32520466326308694604563243046869e-01 3.35215320031308401400177432449823e-04
 	 9.32520466326308805626865705562523e-01 5.70245183292810778330483856279898e-02 3.35215320031306178785723837165733e-04
 	 9.32520466326309249716075555625139e-01 1.04550153444100332733590619227471e-02 3.35215320031302980389315004927653e-04
 	 2.18153490627607304919166608669912e-01 1.47522261546056465686405090309563e-01 2.08705738367026463059294982826941e-03
 	 2.18153490627606805318805527349468e-01 6.34324247826336562461335688567488e-01 2.08705738367026896740163977028715e-03
 	 1.47522261546056493441980705938477e-01 2.18153490627607055118986068009690e-01 2.08705738367026593163555681087473e-03
 	 1.47522261546056243641800165278255e-01 6.34324247826336562461335688567488e-01 2.08705738367026896740163977028715e-03
 	 6.34324247826336340416730763536179e-01 2.18153490627607304919166608669912e-01 2.08705738367026593163555681087473e-03
 	 6.34324247826336451439033226051833e-01 1.47522261546056604464283168454131e-01 2.08705738367026636531642580507651e-03
 	 2.02306345883463883916775216675887e-01 5.21260968074300778951624124601949e-02 1.27918332848801817938633185178787e-03
 	 2.02306345883463578605443444757839e-01 7.45567557309106287988242911524139e-01 1.27918332848800473527939303153289e-03
 	 5.21260968074301472841014515324787e-02 2.02306345883463578605443444757839e-01 1.27918332848801601098198688077900e-03
 	 5.21260968074298766672391991505719e-02 7.45567557309106399010545374039793e-01 1.27918332848800928892851747065151e-03
 	 7.45567557309105843899033061461523e-01 2.02306345883464355761560682367417e-01 1.27918332848801752886502836048521e-03
 	 7.45567557309106399010545374039793e-01 5.21260968074302374897222023264476e-02 1.27918332848801427625851090397191e-03
 	 2.13283209808808105201194393885089e-01 8.00841957661689723968478915594460e-02 1.59199347606165005075684604207709e-03
 	 2.13283209808808160712345625142916e-01 7.06632594425022908524169906741008e-01 1.59199347606163920873512118703275e-03
 	 8.00841957661688891301210446727055e-02 2.13283209808808271734648087658570e-01 1.59199347606164050977772816963807e-03
 	 8.00841957661687087188795430847676e-02 7.06632594425023352613379756803624e-01 1.59199347606164983391641154497620e-03
 	 7.06632594425022908524169906741008e-01 2.13283209808808299490223703287484e-01 1.59199347606165026759728053917797e-03
 	 7.06632594425022797501867444225354e-01 8.00841957661691250525137775184703e-02 1.59199347606164462974598361455492e-03
 	 8.21335887122179308938996200595284e-03 2.16078035466824849505917960357237e-03 6.58585463976953778371045689077334e-05
 	 8.21335887122208452293392610954470e-03 9.89625860774109633588579981733346e-01 6.58585463976957302028106266966745e-05
 	 2.16078035466824242352701368474754e-03 8.21335887122211921740344564568659e-03 6.58585463976959605957722798663667e-05
 	 2.16078035466828188848609215710894e-03 9.89625860774109855633184906764654e-01 6.58585463976954049421588810453443e-05
 	 9.89625860774109855633184906764654e-01 8.21335887122181737551862568125216e-03 6.58585463976959199381908116599504e-05
 	 9.89625860774109633588579981733346e-01 2.16078035466826931174089132525751e-03 6.58585463976963400665326497929186e-05
 	 4.61515361612300445415257854619995e-01 1.13638023497272429296334195214513e-02 8.22836191553006062598951686481996e-04
 	 4.61515361612299723770291848268243e-01 5.27120836037973106158460723236203e-01 8.22836191552999665806134022005836e-04
 	 1.13638023497272325212925636606087e-02 4.61515361612300778482165242166957e-01 8.22836191553002159471130738666034e-04
 	 1.13638023497272411949099435446442e-02 5.27120836037972662069250873173587e-01 8.22836191553001400529609998812930e-04
 	 5.27120836037971662868528710532701e-01 4.61515361612301056037921398456092e-01 8.22836191553004544715910206775789e-04
 	 5.27120836037972662069250873173587e-01 1.13638023497272030309934720548881e-02 8.22836191553003894194606715473128e-04
 	 3.54622467312705746955714403156890e-01 1.29778523617650909383058888124651e-01 2.29774154662928074832617397760259e-03
 	 3.54622467312706246556075484477333e-01 5.15599009069642955083168089913670e-01 2.29774154662926990630444912255825e-03
 	 1.29778523617651075916512581898132e-01 3.54622467312705913489168096930371e-01 2.29774154662926947262358012835648e-03
 	 1.29778523617650853871907656866824e-01 5.15599009069643177127773014944978e-01 2.29774154662927684519835302978663e-03
 	 5.15599009069643066105470552429324e-01 3.54622467312705802466865634414717e-01 2.29774154662927120734705610516357e-03
 	 5.15599009069643066105470552429324e-01 1.29778523617650937138634503753565e-01 2.29774154662927814624096001239195e-03
 	 3.10920643586031941740799311446608e-01 4.89372786072453658245962060391321e-02 1.43443007840781192041568203876523e-03
 	 3.10920643586031053562379611321376e-01 6.40142077806723608368599798268406e-01 1.43443007840781365513915801557232e-03
 	 4.89372786072453033745510708740767e-02 3.10920643586031608673891923899646e-01 1.43443007840781387197959251267321e-03
 	 4.89372786072453311301266865029902e-02 6.40142077806722831212482560658827e-01 1.43443007840781105305394405036168e-03
 	 6.40142077806721720989457935502287e-01 3.10920643586032885430370242829667e-01 1.43443007840780975201133706775636e-03
 	 6.40142077806723608368599798268406e-01 4.89372786072454213357474372969591e-02 1.43443007840781842562871695179183e-03
 	 3.04955784133230711763218323540059e-01 1.58417559007465874598707955556165e-01 2.36336703046011046072671923923281e-03
 	 3.04955784133230989318974479829194e-01 5.36626656859303441393649336532690e-01 2.36336703046012477219539604789134e-03
 	 1.58417559007465819087556724298338e-01 3.04955784133230711763218323540059e-01 2.36336703046011913434409912326828e-03
 	 1.58417559007465708065254261782684e-01 5.36626656859303441393649336532690e-01 2.36336703046011566489714716965409e-03
 	 5.36626656859303330371346874017036e-01 3.04955784133230656252067092282232e-01 2.36336703046011393017367119284700e-03
 	 5.36626656859303441393649336532690e-01 1.58417559007465819087556724298338e-01 2.36336703046011566489714716965409e-03
 	 2.50794437563904293320149463397684e-01 1.75500085438409003657511675555725e-01 2.40436588441475789651446959283021e-03
 	 2.50794437563904237808998232139857e-01 5.73705476997686703022338861046592e-01 2.40436588441477047325967042468164e-03
 	 1.75500085438409086924238522442465e-01 2.50794437563904237808998232139857e-01 2.40436588441476223332315953484795e-03
 	 1.75500085438408920390784828668984e-01 5.73705476997686703022338861046592e-01 2.40436588441476310068489752325149e-03
 	 5.73705476997686592000036398530938e-01 2.50794437563904293320149463397684e-01 2.40436588441476006491881456383908e-03
 	 5.73705476997686703022338861046592e-01 1.75500085438409059168662906813552e-01 2.40436588441476310068489752325149e-03
 	 4.33869221864480791861495845296304e-01 5.31263813104962193123448344067583e-02 1.59638354184672096730546186904576e-03
 	 4.33869221864480514305739689007169e-01 5.13004396825023301076384996122215e-01 1.59638354184675024076411897766548e-03
 	 5.31263813104962193123448344067583e-02 4.33869221864480514305739689007169e-01 1.59638354184673094196544873568655e-03
 	 5.31263813104962193123448344067583e-02 5.13004396825022968009477608575253e-01 1.59638354184672617147588979946704e-03
 	 5.13004396825022079831057908450020e-01 4.33869221864481569017613082905882e-01 1.59638354184672443675241382265995e-03
 	 5.13004396825023634143292383669177e-01 5.31263813104961776789814109633880e-02 1.59638354184673441141240068930074e-03
 	 7.70376986253195061848941804782953e-02 5.09089773583295407410886923571525e-02 8.74382525144718446286073998408028e-04
 	 7.70376986253199641518918383553682e-02 8.72053324016350606129321931803133e-01 8.74382525144714217897601304940736e-04
 	 5.09089773583294435965740376559552e-02 7.70376986253194229181673335915548e-02 8.74382525144714217897601304940736e-04
 	 5.09089773583297419690119056667754e-02 8.72053324016350717151624394318787e-01 8.74382525144719313647811986811575e-04
 	 8.72053324016350828173926856834441e-01 7.70376986253195478182576039216656e-02 8.74382525144718663126508495508915e-04
 	 8.72053324016350717151624394318787e-01 5.09089773583294574743618454704119e-02 8.74382525144714001057166807839849e-04
 	 2.76836186019522256795966086428962e-01 1.11213995971377009597258478379445e-02 7.15335166191508899612150340630023e-04
 	 2.76836186019522645374024705233751e-01 7.12042414383339705707953726232518e-01 7.15335166191499683893684213842334e-04
 	 1.11213995971376922861084679539090e-02 2.76836186019522700885175936491578e-01 7.15335166191506514367370872520269e-04
 	 1.11213995971376992250023718611374e-02 7.12042414383339816730256188748172e-01 7.15335166191503912282156907309627e-04
 	 7.12042414383339816730256188748172e-01 2.76836186019522423329419780202443e-01 7.15335166191511501697364305840665e-04
 	 7.12042414383339927752558651263826e-01 1.11213995971376697347032802554168e-02 7.15335166191504562803460398612287e-04
 	 1.73637162103421366365907374529343e-01 1.17797536807179113044208307314875e-02 6.34087639467666294365577606129136e-04
 	 1.73637162103421782699541608963045e-01 8.14583084215860231402928093302762e-01 6.34087639467669546972095062642438e-04
 	 1.17797536807179113044208307314875e-02 1.73637162103421255343604912013689e-01 6.34087639467670522754050299596429e-04
 	 1.17797536807178679363339313113102e-02 8.14583084215860453447533018334070e-01 6.34087639467664451221884380771598e-04
 	 8.14583084215861008559045330912340e-01 1.73637162103421199832453680755862e-01 6.34087639467665318583622369175146e-04
 	 8.14583084215860564469835480849724e-01 1.17797536807179165085912586619088e-02 6.34087639467669330131660565541551e-04
 	 3.35433688661376905315592011902481e-01 1.18081263036932723048400006859993e-02 7.89516871955840628290179683546057e-04
 	 3.35433688661376794293289549386827e-01 6.52758185034929883094889646599768e-01 7.89516871955837267263444978482312e-04
 	 1.18081263036932705701165247091922e-02 3.35433688661377404915953093222925e-01 7.89516871955839652508224446592067e-04
 	 1.18081263036933017951390922917199e-02 6.52758185034929772072587184084114e-01 7.89516871955838676726269209638076e-04
 	 6.52758185034929439005679796537152e-01 3.35433688661377238382499399449443e-01 7.89516871955842363013655660353152e-04
 	 6.52758185034929883094889646599768e-01 1.18081263036932809784573805700347e-02 7.89516871955838243045400215436302e-04
 	 3.75064218452396958003447480223258e-01 5.12438839908936141775974704160035e-02 1.60772260421603442430427133302828e-03
 	 3.75064218452396291869632705129334e-01 5.73691897556710128647239343990805e-01 1.60772260421603073801688488231321e-03
 	 5.12438839908936002998096626015467e-02 3.75064218452396624936540092676296e-01 1.60772260421603095485731937941409e-03
 	 5.12438839908936141775974704160035e-02 5.73691897556709573535727031412534e-01 1.60772260421603334010209884752385e-03
 	 5.73691897556708574335004868771648e-01 3.75064218452397679648413486575009e-01 1.60772260421604114635774074315577e-03
 	 5.73691897556710128647239343990805e-01 5.12438839908936072387035665087751e-02 1.60772260421603008749558139101055e-03
 	 3.46711286129900431163264329370577e-01 1.82541256476132757180508292549348e-01 2.69885291100848204171036570642173e-03
 	 3.46711286129900542185566791886231e-01 4.70747457393966783900651762451162e-01 2.69885291100848117434862771801818e-03
 	 1.82541256476132812691659523807175e-01 3.46711286129900375652113098112750e-01 2.69885291100848334275297268902705e-03
 	 1.82541256476132590647054598775867e-01 4.70747457393966672878349299935508e-01 2.69885291100848464379557967163237e-03
 	 4.70747457393966672878349299935508e-01 3.46711286129900542185566791886231e-01 2.69885291100848767956166263104478e-03
 	 4.70747457393966783900651762451162e-01 1.82541256476132757180508292549348e-01 2.69885291100848204171036570642173e-03
 	 2.55968511260664444151302632235456e-01 5.39018714502928139586934719318378e-02 1.53135260150544520903193035366030e-03
 	 2.55968511260663889039790319657186e-01 6.90129617289043317818197920132661e-01 1.53135260150543328280803301311153e-03
 	 5.39018714502928278364812797462946e-02 2.55968511260664222106697707204148e-01 1.53135260150544130590410940584434e-03
 	 5.39018714502927653864361445812392e-02 6.90129617289042873728988070070045e-01 1.53135260150544347430845437685321e-03
 	 6.90129617289042096572870832460467e-01 2.55968511260665165796268638587208e-01 1.53135260150545301528757224929223e-03
 	 6.90129617289043428840500382648315e-01 5.39018714502928833476325110041216e-02 1.53135260150543740277628845802838e-03
 	 2.92006920788532020605288153092260e-01 2.73433134615536331535334824138772e-02 1.15960920481872993212379974181658e-03
 	 2.92006920788531021404565990451374e-01 6.80649765749915425239180422067875e-01 1.15960920481872494479380630849619e-03
 	 2.73433134615535637645944433415934e-02 2.92006920788531854071834459318779e-01 1.15960920481872451111293731429441e-03
 	 2.73433134615536227451926265530346e-02 6.80649765749914648083063184458297e-01 1.15960920481872776371945477080772e-03
 	 6.80649765749913759904643484333064e-01 2.92006920788532520205649234412704e-01 1.15960920481873253420901370702722e-03
 	 6.80649765749915203194575497036567e-01 2.73433134615535949896170109241211e-02 1.15960920481872841424075826211038e-03
 	 2.36417239579575721997173332056263e-01 2.97423818792802059640667522444346e-02 1.14805014508864602733317905602917e-03
 	 2.36417239579575083618934172591253e-01 7.33840378541144588986355756787816e-01 1.14805014508863843791797165749813e-03
 	 2.97423818792802892307935991311751e-02 2.36417239579575721997173332056263e-01 1.14805014508864841257795852413892e-03
 	 2.97423818792801747390441846619069e-02 7.33840378541144255919448369240854e-01 1.14805014508864299156709609661675e-03
 	 7.33840378541143700807936056662584e-01 2.36417239579576110575231950861053e-01 1.14805014508865144834404148355134e-03
 	 7.33840378541144588986355756787816e-01 2.97423818792803239252631186673170e-02 1.14805014508864212420535810821320e-03
 	 4.66150898129435442562851221737219e-01 2.19129468105727642779356756363995e-03 3.66905166035598733625944234404415e-04
 	 4.66150898129435886652061071799835e-01 5.31657807189506836920145360636525e-01 3.66905166035599113096704604330967e-04
 	 2.19129468105728640245355443028075e-03 4.66150898129435053984792602932430e-01 3.66905166035601389921266823890278e-04
 	 2.19129468105729594343267230271977e-03 5.31657807189506836920145360636525e-01 3.66905166035601606761701320991165e-04
 	 5.31657807189507614076262598246103e-01 4.66150898129435109495943834190257e-01 3.66905166035603178854851424972594e-04
 	 5.31657807189506947942447823152179e-01 2.19129468105726645313358069699916e-03 3.66905166035597378373228627523872e-04
 	 2.23482629145585393048989431008522e-01 1.25736658366042333007106535092134e-02 7.21880138370401013871158202306333e-04
 	 2.23482629145586003671652974844619e-01 7.63943705017809726598443376133218e-01 7.21880138370405892780934387076286e-04
 	 1.25736658366042558521158412077057e-02 2.23482629145585670604745587297657e-01 7.21880138370406976983106872580720e-04
 	 1.25736658366042072798585138571070e-02 7.63943705017810059665350763680181e-01 7.21880138370402965435068676214314e-04
 	 7.63943705017810503754560613742797e-01 2.23482629145585337537838199750695e-01 7.21880138370402098073330687810767e-04
 	 7.63943705017810059665350763680181e-01 1.25736658366042801382445048830050e-02 7.21880138370404591738327404470965e-04
 	 3.97368013878000636562859426703653e-01 1.15196691295124820780815255716334e-02 8.29333161982132266269729381491516e-04
 	 3.97368013878000192473649576641037e-01 5.91112316992487341060780181578593e-01 8.29333161982128363141908433675553e-04
 	 1.15196691295124699350171937339837e-02 3.97368013878001136163220508024096e-01 8.29333161982130965227122398886195e-04
 	 1.15196691295124577919528618963341e-02 5.91112316992487007993872794031631e-01 8.29333161982130097865384410482648e-04
 	 5.91112316992486341860058018937707e-01 3.97368013878001247185522970539751e-01 8.29333161982133892572988109748167e-04
 	 5.91112316992487230038477719062939e-01 1.15196691295125046294867132701256e-02 8.29333161982130639966470653234865e-04
 	 2.85679243244989999883642894928926e-01 2.10668037666766255755490533374541e-01 2.78536465405662594235769446981976e-03
 	 2.85679243244990055394794126186753e-01 5.03652719088243827627593418583274e-01 2.78536465405663288125159837704814e-03
 	 2.10668037666766255755490533374541e-01 2.85679243244989944372491663671099e-01 2.78536465405662811076203944082863e-03
 	 2.10668037666766061466461223972146e-01 5.03652719088243716605290956067620e-01 2.78536465405663027916638441183750e-03
 	 5.03652719088243494560686031036312e-01 2.85679243244990055394794126186753e-01 2.78536465405662897812377742923218e-03
 	 5.03652719088243716605290956067620e-01 2.10668037666766255755490533374541e-01 2.78536465405662854444290843503040e-03
 	 4.00991912296406793903003062951029e-01 2.17085028246797977213855546096966e-03 3.60718717232299374529647106868424e-04
 	 4.00991912296407015947607987982337e-01 5.96837237421124933156590941507602e-01 3.60718717232301597144100702152514e-04
 	 2.17085028246801967077850292753283e-03 4.00991912296406294302641981630586e-01 3.60718717232299699790298852519754e-04
 	 2.17085028246800188986287416526011e-03 5.96837237421124933156590941507602e-01 3.60718717232299808210516101070198e-04
 	 5.96837237421125710312708179117180e-01 4.00991912296406405324944444146240e-01 3.60718717232298019276931499987882e-04
 	 5.96837237421125044178893404023256e-01 2.17085028246798540998985238559271e-03 3.60718717232300783992471338024188e-04
 	 1.56273510404076859670041699246212e-01 5.57664223797979322072571051194245e-02 1.31106391220739545641627010752472e-03
 	 1.56273510404076942936768546132953e-01 7.87960067216125104039292637025937e-01 1.31106391220738765016062821189280e-03
 	 5.57664223797979322072571051194245e-02 1.56273510404076609869861158585991e-01 1.31106391220739307117149063941497e-03
 	 5.57664223797978489405302582326840e-02 7.87960067216125326083897562057246e-01 1.31106391220738895120323519449812e-03
 	 7.87960067216124993016990174510283e-01 1.56273510404077081714646624277520e-01 1.31106391220739849218235306693714e-03
 	 7.87960067216125437106200024572900e-01 5.57664223797979530239388168411097e-02 1.31106391220738548175628324088393e-03
 	 4.77858936846817378141238918942690e-02 2.09790827030161951965991917745669e-03 1.51789801686192277500528358125109e-04
 	 4.77858936846819182253653934822069e-02 9.50116198045016457918165997398319e-01 1.51789801686189702520368705052078e-04
 	 2.09790827030157181476432981526159e-03 4.77858936846820708810312794412312e-02 1.51789801686189458574879895813581e-04
 	 2.09790827030163079536251302670280e-03 9.50116198045016568940468459913973e-01 1.51789801686192792496560288739715e-04
 	 9.50116198045016457918165997398319e-01 4.77858936846818557753202583171515e-02 1.51789801686192792496560288739715e-04
 	 9.50116198045016346895863534882665e-01 2.09790827030158872831822058913076e-03 1.51789801686189512784988520088802e-04
 	 1.82249159931374221654820644289430e-01 2.90781975795925302918920607453401e-02 1.05004350057420693838328151770156e-03
 	 1.82249159931373860832337641113554e-01 7.88672642489033570711853826651350e-01 1.05004350057420303525546056988560e-03
 	 2.90781975795925164141042529308834e-02 1.82249159931374221654820644289430e-01 1.05004350057420563734067453509624e-03
 	 2.90781975795924053918017904152293e-02 7.88672642489033570711853826651350e-01 1.05004350057420260157459157568383e-03
 	 7.88672642489033237644946439104388e-01 1.82249159931374332677123106805084e-01 1.05004350057420758890458500900422e-03
 	 7.88672642489033570711853826651350e-01 2.90781975795925649863615802814820e-02 1.05004350057420520365980554089447e-03
 	 8.93475681919860265089994300069520e-02 1.15829668440251571520649420676818e-02 4.83149309370665470432515409271446e-04
 	 8.93475681919859293644847753057547e-02 8.99069464963988984607112797675654e-01 4.83149309370666175163927524849328e-04
 	 1.15829668440251623562353699981031e-02 8.93475681919856934420920424599899e-02 4.83149309370665090961755039344894e-04
 	 1.15829668440252404187917889544224e-02 8.99069464963988651540205410128692e-01 4.83149309370668343568272495858196e-04
 	 8.99069464963988651540205410128692e-01 8.93475681919860403867872378214088e-02 4.83149309370665904113384403473219e-04
 	 8.99069464963988984607112797675654e-01 1.15829668440251311312128024155754e-02 4.83149309370666012533601652023663e-04
 	 1.65219881239912713688511303189443e-01 8.74623616502728101762542678443424e-02 1.60233618511449100486887520133905e-03
 	 1.65219881239912963488691843849665e-01 7.47317757109814184701690464862622e-01 1.60233618511449078802844070423816e-03
 	 8.74623616502727824206786522154289e-02 1.65219881239913018999843075107492e-01 1.60233618511449729324147561726477e-03
 	 8.74623616502726020094371506274911e-02 7.47317757109814850835505239956547e-01 1.60233618511448623437931626511954e-03
 	 7.47317757109814406746295389893930e-01 1.65219881239912907977540612591838e-01 1.60233618511449469115626165205413e-03
 	 7.47317757109814406746295389893930e-01 8.74623616502728379318298834732559e-02 1.60233618511449100486887520133905e-03
 	 8.05280047391682685109515205112984e-02 2.07850359821924604922238621895758e-03 1.96147522693671173170740229529940e-04
 	 8.05280047391684072888295986558660e-02 9.17393491662612414749844447214855e-01 1.96147522693670116073622056163117e-04
 	 2.07850359821923867664761331752743e-03 8.05280047391685321889198689859768e-02 1.96147522693670116073622056163117e-04
 	 2.07850359821925732492498006820369e-03 9.17393491662612414749844447214855e-01 1.96147522693672636843673084960926e-04
 	 9.17393491662612303727541984699201e-01 8.05280047391684211666174064703227e-02 1.96147522693672230267858402896763e-04
 	 9.17393491662612192705239522183547e-01 2.07850359821924084505195828853630e-03 1.96147522693670143178676368300728e-04
 	 3.30541501567599094180138763476862e-01 2.36477783744783676134204597474309e-01 3.12879060401824622694721966809084e-03
 	 3.30541501567598983157836300961208e-01 4.32980714687617285196807870306657e-01 3.12879060401824752798982665069616e-03
 	 2.36477783744783731645355828732136e-01 3.30541501567599094180138763476862e-01 3.12879060401824275750026771447665e-03
 	 2.36477783744783648378628981845395e-01 4.32980714687617285196807870306657e-01 3.12879060401824752798982665069616e-03
 	 4.32980714687617174174505407791003e-01 3.30541501567599094180138763476862e-01 3.12879060401824319118113670867842e-03
 	 4.32980714687617174174505407791003e-01 2.36477783744783648378628981845395e-01 3.12879060401824622694721966809084e-03
 	 1.75074013252293603226661389271612e-01 1.22809018053712859508408428155235e-01 1.89062025704546323064125790125445e-03
 	 1.75074013252293547715510158013785e-01 7.02116968693993426242627720057499e-01 1.89062025704546041171560943894292e-03
 	 1.22809018053713026041862121928716e-01 1.75074013252293547715510158013785e-01 1.89062025704546344748169239835534e-03
 	 1.22809018053712554197076656237186e-01 7.02116968693993759309535107604461e-01 1.89062025704546084539647843314469e-03
 	 7.02116968693993426242627720057499e-01 1.75074013252293658737812620529439e-01 1.89062025704546236327951991285090e-03
 	 7.02116968693993426242627720057499e-01 1.22809018053712984408498698485346e-01 1.89062025704546604956690636356598e-03
 	 1.13394973029422335697447010716132e-01 5.50050284444837597752631097591802e-02 1.15318098238608433316054746597956e-03
 	 1.13394973029422654886566590448638e-01 8.31599998526093564521488588070497e-01 1.15318098238607891214968503845739e-03
 	 5.50050284444837112030057824085816e-02 1.13394973029422224675144548200478e-01 1.15318098238608021319229202106271e-03
 	 5.50050284444838846753533800892910e-02 8.31599998526093675543791050586151e-01 1.15318098238608389947967847177779e-03
 	 8.31599998526093675543791050586151e-01 1.13394973029422474475325088860700e-01 1.15318098238608476684141646018134e-03
 	 8.31599998526093786566093513101805e-01 5.50050284444837528363692058519518e-02 1.15318098238607782794751255295296e-03
 	 9.45442284064488686068372658155567e-02 2.87935332271120614233694823269616e-02 7.98215168649472222618668215687876e-04
 	 9.45442284064488547290494580011000e-02 8.76662238366439194869883522187592e-01 7.98215168649467235288674782367480e-04
 	 2.87935332271120510150286264661190e-02 9.45442284064488269734738423721865e-02 7.98215168649470162634540493229451e-04
 	 2.87935332271121550984371850745447e-02 8.76662238366438972825278597156284e-01 7.98215168649472222618668215687876e-04
 	 8.76662238366438972825278597156284e-01 9.45442284064488130956860345577297e-02 7.98215168649472439459102712788763e-04
 	 8.76662238366439194869883522187592e-01 2.87935332271120163205591069299771e-02 7.98215168649468861591933510624131e-04
 	 5.89589423608463392145750958661665e-02 2.62933317918677966762430742164725e-02 6.24418006796969519284212779552945e-04
 	 5.89589423608463461534689997733949e-02 9.14747725847286030642635523690842e-01 6.24418006796969302443778282452058e-04
 	 2.62933317918675468760625335562509e-02 5.89589423608462420700604411649692e-02 6.24418006796970169805516270855605e-04
 	 2.62933317918679076985455367321265e-02 9.14747725847285808598030598659534e-01 6.24418006796972988731164733167134e-04
 	 9.14747725847285808598030598659534e-01 5.89589423608462837034238646083395e-02 6.24418006796972229789643993314030e-04
 	 9.14747725847286030642635523690842e-01 2.62933317918676717761528038863617e-02 6.24418006796968977183126536800728e-04
 	 3.55446117102370062745819723204477e-01 2.83073273852235754444173210231384e-02 1.27781420414727043231850611704203e-03
 	 3.55446117102368841500492635532282e-01 6.16246555512407589993983947351808e-01 1.27781420414726609550981617502430e-03
 	 2.83073273852235234027130417189255e-02 3.55446117102369785190063566915342e-01 1.27781420414726891443546463733583e-03
 	 2.83073273852235442193947534406107e-02 6.16246555512406701815564247226575e-01 1.27781420414726826391416114603317e-03
 	 6.16246555512405702614842084585689e-01 3.55446117102370673368483267040574e-01 1.27781420414727021547807161994115e-03
 	 6.16246555512407367949379022320500e-01 2.83073273852236136083337925128944e-02 1.27781420414726934811633363153760e-03
 	 4.20627844445429388553492344726692e-01 2.81269388071388286298724068501542e-02 1.33914246584527986579093994379264e-03
 	 4.20627844445428056285862794538843e-01 5.51245216747433097737030038842931e-01 1.33914246584527205953529804816071e-03
 	 2.81269388071388390382132627109968e-02 4.20627844445428999975433725921903e-01 1.33914246584527574582268449887579e-03
 	 2.81269388071388425076602146646110e-02 5.51245216747432209558610338717699e-01 1.33914246584527509530138100757313e-03
 	 5.51245216747431210357888176076813e-01 4.20627844445429888153853426047135e-01 1.33914246584527943211007094959086e-03
 	 5.51245216747432764670122651295969e-01 2.81269388071388355687663107573826e-02 1.33914246584527791422702946988466e-03
 	 2.76342477166445776859404759306926e-01 2.10090109306923684961976306340148e-03 3.20695007916892203900932623028552e-04
 	 2.76342477166445721348253528049099e-01 7.21556621740485071292425800493220e-01 3.20695007916892149690823998753331e-04
 	 2.10090109306925419685452283147242e-03 2.76342477166445388281346140502137e-01 3.20695007916893938624408599835647e-04
 	 2.10090109306922730864064519096246e-03 7.21556621740484960270123337977566e-01 3.20695007916893233892996484257765e-04
 	 7.21556621740484960270123337977566e-01 2.76342477166445721348253528049099e-01 3.20695007916895185456906958165746e-04
 	 7.21556621740484849247820875461912e-01 2.10090109306923251281107312138374e-03 3.20695007916891824430172253102000e-04
 	 1.35834405138137326307656849166960e-01 3.05221004022597809657302292407621e-02 9.55358677029269896287255736666566e-04
 	 1.35834405138137243040930002280220e-01 8.33643494459602951707211104803719e-01 9.55358677029266318420086534501934e-04
 	 3.05221004022598121907527968232898e-02 1.35834405138137381818808080424787e-01 9.55358677029269679446821239565679e-04
 	 3.05221004022598330074345085449750e-02 8.33643494459602840684908642288065e-01 9.55358677029268269983997008409915e-04
 	 8.33643494459602840684908642288065e-01 1.35834405138137381818808080424787e-01 9.55358677029270438388341979418783e-04
 	 8.33643494459603062729513567319373e-01 3.05221004022597809657302292407621e-02 9.55358677029266752100955528703707e-04
 	 1.21432444920387266895644984288083e-01 8.81430419815302790276234645716613e-02 1.51428242832449028339170116197465e-03
 	 1.21432444920387558329188948391675e-01 7.90424513098082148765399779222207e-01 1.51428242832449158443430814457997e-03
 	 8.81430419815302512720478489427478e-02 1.21432444920387475062462101504934e-01 1.51428242832449592124299808659771e-03
 	 8.81430419815303345387746958294883e-02 7.90424513098082481832307166769169e-01 1.51428242832448854866822518516756e-03
 	 7.90424513098082259787702241737861e-01 1.21432444920387391795735254618194e-01 1.51428242832449483704082560109327e-03
 	 7.90424513098082259787702241737861e-01 8.81430419815303067831990802005748e-02 1.51428242832448919918952867647022e-03
 	 1.29254481332948284455497400813329e-01 1.25808072722037589397103829469415e-02 5.97009737256883380417116224947449e-04
 	 1.29254481332948423233375478957896e-01 8.58164711394847845582489753724076e-01 5.97009737256886849864068178561638e-04
 	 1.25808072722038005730738063903118e-02 1.29254481332947979144165628895280e-01 5.97009737256882621475595485094345e-04
 	 1.25808072722038161855850901815757e-02 8.58164711394847734560187291208422e-01 5.97009737256885006720374953204100e-04
 	 8.58164711394848067627094678755384e-01 1.29254481332948173433194938297675e-01 5.97009737256880561491467762635921e-04
 	 8.58164711394847956604792216239730e-01 1.25808072722037520008164790397132e-02 5.97009737256885548821461195956317e-04
 	 2.72939318330326197159507728429162e-01 8.38760556578321270215781169099500e-02 1.99489307211005422598715242088474e-03
 	 2.72939318330326308181810190944816e-01 6.43184626011841675818914154660888e-01 1.99489307211005726175323538029716e-03
 	 8.38760556578321270215781169099500e-02 2.72939318330326419204112653460470e-01 1.99489307211005639439149739189361e-03
 	 8.38760556578320576326390778376663e-02 6.43184626011841675818914154660888e-01 1.99489307211005465966802141508651e-03
 	 6.43184626011841342752006767113926e-01 2.72939318330326474715263884718297e-01 1.99489307211005639439149739189361e-03
 	 6.43184626011841564796611692145234e-01 8.38760556578321270215781169099500e-02 1.99489307211005552702975940349006e-03
 	 2.76224431674287174143245238155941e-01 1.24791600444704692263186984746426e-01 2.38707993822376458858958159225949e-03
 	 2.76224431674286674542884156835498e-01 5.98983967881008494416050780273508e-01 2.38707993822376242018523662125062e-03
 	 1.24791600444704720018762600375339e-01 2.76224431674286952098640313124633e-01 2.38707993822376675699392656326836e-03
 	 1.24791600444704636752035753488599e-01 5.98983967881008161349143392726546e-01 2.38707993822376632331305756906659e-03
 	 5.98983967881007939304538467695238e-01 2.76224431674287174143245238155941e-01 2.38707993822376849171740254007545e-03
 	 5.98983967881008272371445855242200e-01 1.24791600444704803285489447262080e-01 2.38707993822376242018523662125062e-03
 	 1.66531061991801065946816606810899e-01 2.23024928943946123410801973818707e-03 2.84050648765331542697915034878520e-04
 	 1.66531061991801010435665375553071e-01 8.31238688718759499707289251091424e-01 2.84050648765331651118132283428963e-04
 	 2.23024928943945256049063985415160e-03 1.66531061991801010435665375553071e-01 2.84050648765329374293570063869652e-04
 	 2.23024928943944692263934292952854e-03 8.31238688718759499707289251091424e-01 2.84050648765330566915959797924529e-04
 	 8.31238688718759499707289251091424e-01 1.66531061991801149213543453697639e-01 2.84050648765329374293570063869652e-04
 	 8.31238688718759277662684326060116e-01 2.23024928943945906570367476717820e-03 2.84050648765330946386720167851081e-04
 	 3.37323861878955577608962812519167e-01 2.28466711100100547046642951443118e-03 3.64644894945765946255022971200788e-04
 	 3.37323861878955744142416506292648e-01 6.60391471010043251688159671175526e-01 3.64644894945767952029042069383991e-04
 	 2.28466711100100416942382253182586e-03 3.37323861878955189030904193714377e-01 3.64644894945765458364045352723792e-04
 	 2.28466711100098508746558678694782e-03 6.60391471010043140665857208659872e-01 3.64644894945768223079585190760099e-04
 	 6.60391471010043584755067058722489e-01 3.37323861878955466586660350003513e-01 3.64644894945766217305566092576896e-04
 	 6.60391471010043140665857208659872e-01 2.28466711100100503678556052022941e-03 3.64644894945766488356109213953005e-04
 	 3.89984837680378892965649129109806e-01 8.31933025800657838244589470377832e-02 2.19977808499302162487110123834100e-03
 	 3.89984837680378670921044204078498e-01 5.26821859739555531376709041069262e-01 2.19977808499303116585021911078002e-03
 	 8.31933025800657977022467548522400e-02 3.89984837680378781943346666594152e-01 2.19977808499302205855197023254277e-03
 	 8.31933025800657699466711392233265e-02 5.26821859739555309332104116037954e-01 2.19977808499302422695631520355164e-03
 	 5.26821859739555198309801653522300e-01 3.89984837680379059499102822883287e-01 2.19977808499301989014762526153390e-03
 	 5.26821859739555420354406578553608e-01 8.31933025800658254578223704811535e-02 2.19977808499302379327544620934987e-03
 	 2.19057402029606967941433026680897e-01 2.40703109183257888195606177816899e-03 3.39479499288665811408682859706687e-04
 	 2.19057402029606856919130564165243e-01 7.78535566878560625347915902239038e-01 3.39479499288667329291724339412895e-04
 	 2.40703109183256760625346792892287e-03 2.19057402029606745896828101649589e-01 3.39479499288667383501832963688116e-04
 	 2.40703109183254809061436318984306e-03 7.78535566878560514325613439723384e-01 3.39479499288666028249117356807574e-04
 	 7.78535566878560514325613439723384e-01 2.19057402029606967941433026680897e-01 3.39479499288666624560312223835012e-04
 	 7.78535566878560292281008514692076e-01 2.40703109183258712189257266800269e-03 3.39479499288666895610855345211121e-04
 	 1.20341342443090248970349875889951e-01 2.41706361847833376202410171629253e-03 2.65722056703089951588958594896894e-04
 	 1.20341342443090290603713299333322e-01 8.77241593938431374333219991967781e-01 2.65722056703089517908089600695121e-04
 	 2.41706361847833549674757769309963e-03 1.20341342443090359992652338405605e-01 2.65722056703089951588958594896894e-04
 	 2.41706361847831814951281792502868e-03 8.77241593938431374333219991967781e-01 2.65722056703090602110262086199555e-04
 	 8.77241593938431263310917529452126e-01 1.20341342443090373870440146220062e-01 2.65722056703090927370913831850885e-04
 	 8.77241593938431152288615066936472e-01 2.41706361847833419570497071049431e-03 2.65722056703089572118198224970342e-04
 	 3.21434597854268963579293938437331e-02 1.28868718184529940096183509012917e-02 3.23762331706670656878560565772318e-04
 	 3.21434597854267437022635078847088e-02 9.54969668396120185960285198234487e-01 3.23762331706669193205627710341332e-04
 	 1.28868718184530616638339139967684e-02 3.21434597854267575800513156991656e-02 3.23762331706668651104541467589115e-04
 	 1.28868718184530269693643944606265e-02 9.54969668396120185960285198234487e-01 3.23762331706670277407800195845766e-04
 	 9.54969668396120185960285198234487e-01 3.21434597854268616634598743075912e-02 3.23762331706670385828017444396210e-04
 	 9.54969668396120185960285198234487e-01 1.28868718184530512554930581359258e-02 3.23762331706669410046062207442219e-04
 	 2.39783625881971607096687648663647e-02 2.58739871201068465447758804032219e-03 1.30663973001149966504663701982736e-04
 	 2.39783625881975458182804317175396e-02 9.73434238699791842819308840262238e-01 1.30663973001150237555206823358844e-04
 	 2.58739871201064475583764057375902e-03 2.39783625881976082683255668825950e-02 1.30663973001150779656293066111061e-04
 	 2.58739871201065039368893749838207e-03 9.73434238699792064863913765293546e-01 1.30663973001149803874337829157071e-04
 	 9.73434238699792175886216227809200e-01 2.39783625881972890792059871500896e-02 1.30663973001150264660261135496455e-04
 	 9.73434238699791620774703915230930e-01 2.58739871201070070066974082578781e-03 1.30663973001150535710804256872564e-04
 	 ];
 
 	 case  47 

 	 % ALG. DEG.:   47
 	 % PTS CARD.:  399
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw=[
 	 3.49177504154390971891075423627626e-01 3.49177504154390971891075423627626e-01 2.15732847916676184762962975582923e-03
 	 3.49177504154390971891075423627626e-01 3.01644991691218056217849152744748e-01 2.15732847916676184762962975582923e-03
 	 3.01644991691218056217849152744748e-01 3.49177504154390971891075423627626e-01 2.15732847916676184762962975582923e-03
 	 3.02896544117914334748320470680483e-01 3.02896544117914334748320470680483e-01 2.34958561562595468277803156809114e-03
 	 3.02896544117914334748320470680483e-01 3.94206911764171330503359058639035e-01 2.34958561562595468277803156809114e-03
 	 3.94206911764171330503359058639035e-01 3.02896544117914334748320470680483e-01 2.34958561562595468277803156809114e-03
 	 5.05319024623013812735905503359390e-02 5.05319024623013812735905503359390e-02 6.18246204852673482757485778904538e-04
 	 5.05319024623013812735905503359390e-02 8.98936195075397237452818899328122e-01 6.18246204852673482757485778904538e-04
 	 8.98936195075397237452818899328122e-01 5.05319024623013812735905503359390e-02 6.18246204852673482757485778904538e-04
 	 4.21509392878709365781730866729049e-01 4.21509392878709365781730866729049e-01 2.25799868909655303272909776524102e-03
 	 4.21509392878709365781730866729049e-01 1.56981214242581268436538266541902e-01 2.25799868909655303272909776524102e-03
 	 1.56981214242581268436538266541902e-01 4.21509392878709365781730866729049e-01 2.25799868909655303272909776524102e-03
 	 4.74627024342958780955825659475522e-01 4.74627024342958780955825659475522e-01 1.47224053313713067366041986616665e-03
 	 4.74627024342958780955825659475522e-01 5.07459513140824380883486810489558e-02 1.47224053313713067366041986616665e-03
 	 5.07459513140824380883486810489558e-02 4.74627024342958780955825659475522e-01 1.47224053313713067366041986616665e-03
 	 7.95728420692438376260469112821738e-02 7.95728420692438376260469112821738e-02 1.04150124319736590676466203575501e-03
 	 7.95728420692438376260469112821738e-02 8.40854315861512269236754946177825e-01 1.04150124319736590676466203575501e-03
 	 8.40854315861512269236754946177825e-01 7.95728420692438376260469112821738e-02 1.04150124319736590676466203575501e-03
 	 2.36802291430402538086052999233289e-02 2.36802291430402538086052999233289e-02 3.31503931633387379385863313885352e-04
 	 2.36802291430402538086052999233289e-02 9.52639541713919513199471111875027e-01 3.31503931633387379385863313885352e-04
 	 9.52639541713919513199471111875027e-01 2.36802291430402538086052999233289e-02 3.31503931633387379385863313885352e-04
 	 2.63056435770372187832322197209578e-01 2.63056435770372187832322197209578e-01 2.79912721630154025936887407510767e-03
 	 2.63056435770372187832322197209578e-01 4.73887128459255624335355605580844e-01 2.79912721630154025936887407510767e-03
 	 4.73887128459255624335355605580844e-01 2.63056435770372187832322197209578e-01 2.79912721630154025936887407510767e-03
 	 4.42069397263830543565177322307136e-01 4.42069397263830543565177322307136e-01 2.27590725678494636141646623173074e-03
 	 4.42069397263830543565177322307136e-01 1.15861205472338912869645355385728e-01 2.27590725678494636141646623173074e-03
 	 1.15861205472338912869645355385728e-01 4.42069397263830543565177322307136e-01 2.27590725678494636141646623173074e-03
 	 4.86160107483689762908340981084621e-01 4.86160107483689762908340981084621e-01 1.25364067529043347361261684369538e-03
 	 4.86160107483689762908340981084621e-01 2.76797850326204741833180378307588e-02 1.25364067529043347361261684369538e-03
 	 2.76797850326204741833180378307588e-02 4.86160107483689762908340981084621e-01 1.25364067529043347361261684369538e-03
 	 1.62146122522450308878205760265701e-01 1.62146122522450308878205760265701e-01 2.03221496293360314941423006018795e-03
 	 1.62146122522450308878205760265701e-01 6.75707754955099382243588479468599e-01 2.03221496293360314941423006018795e-03
 	 6.75707754955099382243588479468599e-01 1.62146122522450308878205760265701e-01 2.03221496293360314941423006018795e-03
 	 3.73691181805182015551736185443588e-01 3.73691181805182015551736185443588e-01 2.75255677067570963395537475548736e-03
 	 3.73691181805182015551736185443588e-01 2.52617636389635968896527629112825e-01 2.75255677067570963395537475548736e-03
 	 2.52617636389635968896527629112825e-01 3.73691181805182015551736185443588e-01 2.75255677067570963395537475548736e-03
 	 2.12551268904813739357706481314381e-01 2.12551268904813739357706481314381e-01 2.47233079993487659883899532076157e-03
 	 2.12551268904813739357706481314381e-01 5.74897462190372521284587037371239e-01 2.47233079993487659883899532076157e-03
 	 5.74897462190372521284587037371239e-01 2.12551268904813739357706481314381e-01 2.47233079993487659883899532076157e-03
 	 4.59832174149501116122706889655092e-01 4.59832174149501116122706889655092e-01 2.03289490379708181339024619660449e-03
 	 4.59832174149501116122706889655092e-01 8.03356517009977677545862206898164e-02 2.03289490379708181339024619660449e-03
 	 8.03356517009977677545862206898164e-02 4.59832174149501116122706889655092e-01 2.03289490379708181339024619660449e-03
 	 4.98918529148673406403702301759040e-01 4.98918529148673406403702301759040e-01 3.74415430601990112304683355759494e-04
 	 4.98918529148673406403702301759040e-01 2.16294170265318719259539648192003e-03 3.74415430601990112304683355759494e-04
 	 2.16294170265318719259539648192003e-03 4.98918529148673406403702301759040e-01 3.74415430601990112304683355759494e-04
 	 1.24974506748911293185777537928516e-01 1.24974506748911293185777537928516e-01 1.81606992783187883543083440684995e-03
 	 1.24974506748911293185777537928516e-01 7.50050986502177385872869308514055e-01 1.81606992783187883543083440684995e-03
 	 7.50050986502177385872869308514055e-01 1.24974506748911293185777537928516e-01 1.81606992783187883543083440684995e-03
 	 2.60509669473600602440654938618536e-03 2.60509669473600602440654938618536e-03 4.46268307090296161964565468949218e-05
 	 2.60509669473600602440654938618536e-03 9.94789806610527960195611285598716e-01 4.46268307090296161964565468949218e-05
 	 9.94789806610527960195611285598716e-01 2.60509669473600602440654938618536e-03 4.46268307090296161964565468949218e-05
 	 1.32182347742614610813793873944633e-02 6.92610811899467895824678009830677e-03 1.06391003262472626797810471011019e-04
 	 1.32182347742614610813793873944633e-02 9.79855657106743938022930251463549e-01 1.06391003262472626797810471011019e-04
 	 6.92610811899467895824678009830677e-03 1.32182347742614610813793873944633e-02 1.06391003262472626797810471011019e-04
 	 6.92610811899467895824678009830677e-03 9.79855657106743938022930251463549e-01 1.06391003262472626797810471011019e-04
 	 9.79855657106743938022930251463549e-01 1.32182347742614610813793873944633e-02 1.06391003262472626797810471011019e-04
 	 9.79855657106743938022930251463549e-01 6.92610811899467895824678009830677e-03 1.06391003262472626797810471011019e-04
 	 1.82074143261559212580991129470931e-01 8.16358471109855377001451870455639e-02 1.12574137246430677414266163793855e-03
 	 1.82074143261559212580991129470931e-01 7.36290009627455166452136836596765e-01 1.12574137246430677414266163793855e-03
 	 8.16358471109855377001451870455639e-02 1.82074143261559212580991129470931e-01 1.12574137246430677414266163793855e-03
 	 8.16358471109855377001451870455639e-02 7.36290009627455166452136836596765e-01 1.12574137246430677414266163793855e-03
 	 7.36290009627455166452136836596765e-01 1.82074143261559212580991129470931e-01 1.12574137246430677414266163793855e-03
 	 7.36290009627455166452136836596765e-01 8.16358471109855377001451870455639e-02 1.12574137246430677414266163793855e-03
 	 1.50580927317701368517433024862839e-01 8.61963659887330785336345684299886e-02 1.13253505774401773582849006771767e-03
 	 1.50580927317701368517433024862839e-01 7.63222706693565622337871445779456e-01 1.13253505774401773582849006771767e-03
 	 8.61963659887330785336345684299886e-02 1.50580927317701368517433024862839e-01 1.13253505774401773582849006771767e-03
 	 8.61963659887330785336345684299886e-02 7.63222706693565622337871445779456e-01 1.13253505774401773582849006771767e-03
 	 7.63222706693565622337871445779456e-01 1.50580927317701368517433024862839e-01 1.13253505774401773582849006771767e-03
 	 7.63222706693565622337871445779456e-01 8.61963659887330785336345684299886e-02 1.13253505774401773582849006771767e-03
 	 7.64329826567074904763998688395077e-02 5.02931805301914183758960064096755e-02 7.01364787340123113645873331734037e-04
 	 7.64329826567074904763998688395077e-02 8.73273836813101111964385836472502e-01 7.01364787340123113645873331734037e-04
 	 5.02931805301914183758960064096755e-02 7.64329826567074904763998688395077e-02 7.01364787340123113645873331734037e-04
 	 5.02931805301914183758960064096755e-02 8.73273836813101111964385836472502e-01 7.01364787340123113645873331734037e-04
 	 8.73273836813101111964385836472502e-01 7.64329826567074904763998688395077e-02 7.01364787340123113645873331734037e-04
 	 8.73273836813101111964385836472502e-01 5.02931805301914183758960064096755e-02 7.01364787340123113645873331734037e-04
 	 1.38326160976293081189547606868473e-02 1.04889894991745235425240068138919e-03 4.89049584063299501023210080763448e-05
 	 1.38326160976293081189547606868473e-02 9.85118484952453243863601528573781e-01 4.89049584063299501023210080763448e-05
 	 1.04889894991745235425240068138919e-03 1.38326160976293081189547606868473e-02 4.89049584063299501023210080763448e-05
 	 1.04889894991745235425240068138919e-03 9.85118484952453243863601528573781e-01 4.89049584063299501023210080763448e-05
 	 9.85118484952453243863601528573781e-01 1.38326160976293081189547606868473e-02 4.89049584063299501023210080763448e-05
 	 9.85118484952453243863601528573781e-01 1.04889894991745235425240068138919e-03 4.89049584063299501023210080763448e-05
 	 2.67452272430761042731894860935427e-02 1.00204975653522664752470561211339e-02 2.01931493401746626082521318679142e-04
 	 2.67452272430761042731894860935427e-02 9.63234275191571565066794846643461e-01 2.01931493401746626082521318679142e-04
 	 1.00204975653522664752470561211339e-02 2.67452272430761042731894860935427e-02 2.01931493401746626082521318679142e-04
 	 1.00204975653522664752470561211339e-02 9.63234275191571565066794846643461e-01 2.01931493401746626082521318679142e-04
 	 9.63234275191571565066794846643461e-01 2.67452272430761042731894860935427e-02 2.01931493401746626082521318679142e-04
 	 9.63234275191571565066794846643461e-01 1.00204975653522664752470561211339e-02 2.01931493401746626082521318679142e-04
 	 3.71190236752514501894495424494380e-01 2.03674253045179914911599894367100e-01 2.57682766030653976480069289323183e-03
 	 3.71190236752514501894495424494380e-01 4.25135510202305555438329065509606e-01 2.57682766030653976480069289323183e-03
 	 2.03674253045179914911599894367100e-01 3.71190236752514501894495424494380e-01 2.57682766030653976480069289323183e-03
 	 2.03674253045179914911599894367100e-01 4.25135510202305555438329065509606e-01 2.57682766030653976480069289323183e-03
 	 4.25135510202305555438329065509606e-01 3.71190236752514501894495424494380e-01 2.57682766030653976480069289323183e-03
 	 4.25135510202305555438329065509606e-01 2.03674253045179914911599894367100e-01 2.57682766030653976480069289323183e-03
 	 3.68894972792118358562163393798983e-01 1.59326683873933672153100360446842e-01 2.25473552819196879429264335215066e-03
 	 3.68894972792118358562163393798983e-01 4.71778343333947969284736245754175e-01 2.25473552819196879429264335215066e-03
 	 1.59326683873933672153100360446842e-01 3.68894972792118358562163393798983e-01 2.25473552819196879429264335215066e-03
 	 1.59326683873933672153100360446842e-01 4.71778343333947969284736245754175e-01 2.25473552819196879429264335215066e-03
 	 4.71778343333947969284736245754175e-01 3.68894972792118358562163393798983e-01 2.25473552819196879429264335215066e-03
 	 4.71778343333947969284736245754175e-01 1.59326683873933672153100360446842e-01 2.25473552819196879429264335215066e-03
 	 1.07074579893119942175516712268291e-01 5.33687025646959883884434816536668e-02 9.57294483603012154836198188689877e-04
 	 1.07074579893119942175516712268291e-01 8.39556717542184083313827613892499e-01 9.57294483603012154836198188689877e-04
 	 5.33687025646959883884434816536668e-02 1.07074579893119942175516712268291e-01 9.57294483603012154836198188689877e-04
 	 5.33687025646959883884434816536668e-02 8.39556717542184083313827613892499e-01 9.57294483603012154836198188689877e-04
 	 8.39556717542184083313827613892499e-01 1.07074579893119942175516712268291e-01 9.57294483603012154836198188689877e-04
 	 8.39556717542184083313827613892499e-01 5.33687025646959883884434816536668e-02 9.57294483603012154836198188689877e-04
 	 1.15217912167360214681366414879449e-01 8.52960644923164285069461243438127e-02 1.30313259149965202446375123201960e-03
 	 1.15217912167360214681366414879449e-01 7.99486023340323370689475268591195e-01 1.30313259149965202446375123201960e-03
 	 8.52960644923164285069461243438127e-02 1.15217912167360214681366414879449e-01 1.30313259149965202446375123201960e-03
 	 8.52960644923164285069461243438127e-02 7.99486023340323370689475268591195e-01 1.30313259149965202446375123201960e-03
 	 7.99486023340323370689475268591195e-01 1.15217912167360214681366414879449e-01 1.30313259149965202446375123201960e-03
 	 7.99486023340323370689475268591195e-01 8.52960644923164285069461243438127e-02 1.30313259149965202446375123201960e-03
 	 4.17962853969899517103669950301992e-01 5.14822979290668059082491936351289e-02 1.53807863714332422599984084854441e-03
 	 4.17962853969899517103669950301992e-01 5.30554848101033704743656471691793e-01 1.53807863714332422599984084854441e-03
 	 5.14822979290668059082491936351289e-02 4.17962853969899517103669950301992e-01 1.53807863714332422599984084854441e-03
 	 5.14822979290668059082491936351289e-02 5.30554848101033704743656471691793e-01 1.53807863714332422599984084854441e-03
 	 5.30554848101033704743656471691793e-01 4.17962853969899517103669950301992e-01 1.53807863714332422599984084854441e-03
 	 5.30554848101033704743656471691793e-01 5.14822979290668059082491936351289e-02 1.53807863714332422599984084854441e-03
 	 4.62992599159318674040264340874273e-02 2.75536314394735394606161804631483e-02 5.16406156255945643883398243900729e-04
 	 4.62992599159318674040264340874273e-02 9.26147108644594596604804337403039e-01 5.16406156255945643883398243900729e-04
 	 2.75536314394735394606161804631483e-02 4.62992599159318674040264340874273e-02 5.16406156255945643883398243900729e-04
 	 2.75536314394735394606161804631483e-02 9.26147108644594596604804337403039e-01 5.16406156255945643883398243900729e-04
 	 9.26147108644594596604804337403039e-01 4.62992599159318674040264340874273e-02 5.16406156255945643883398243900729e-04
 	 9.26147108644594596604804337403039e-01 2.75536314394735394606161804631483e-02 5.16406156255945643883398243900729e-04
 	 3.25029937315999439828573258637334e-01 1.18702027168940849044531660183566e-01 2.17718061520642477968401351517969e-03
 	 3.25029937315999439828573258637334e-01 5.56268035515059655615743849921273e-01 2.17718061520642477968401351517969e-03
 	 1.18702027168940849044531660183566e-01 3.25029937315999439828573258637334e-01 2.17718061520642477968401351517969e-03
 	 1.18702027168940849044531660183566e-01 5.56268035515059655615743849921273e-01 2.17718061520642477968401351517969e-03
 	 5.56268035515059655615743849921273e-01 3.25029937315999439828573258637334e-01 2.17718061520642477968401351517969e-03
 	 5.56268035515059655615743849921273e-01 1.18702027168940849044531660183566e-01 2.17718061520642477968401351517969e-03
 	 2.23021456853453786672858427664323e-01 8.50615771696930367262723393650958e-02 1.69604395891152196114426420336940e-03
 	 2.23021456853453786672858427664323e-01 6.91916965976853148845293617341667e-01 1.69604395891152196114426420336940e-03
 	 8.50615771696930367262723393650958e-02 2.23021456853453786672858427664323e-01 1.69604395891152196114426420336940e-03
 	 8.50615771696930367262723393650958e-02 6.91916965976853148845293617341667e-01 1.69604395891152196114426420336940e-03
 	 6.91916965976853148845293617341667e-01 2.23021456853453786672858427664323e-01 1.69604395891152196114426420336940e-03
 	 6.91916965976853148845293617341667e-01 8.50615771696930367262723393650958e-02 1.69604395891152196114426420336940e-03
 	 3.82240080251783131970455542614218e-01 1.18127508441192408117359491370735e-01 2.26657835230176501334353744709915e-03
 	 3.82240080251783131970455542614218e-01 4.99632411307024459912184966015047e-01 2.26657835230176501334353744709915e-03
 	 1.18127508441192408117359491370735e-01 3.82240080251783131970455542614218e-01 2.26657835230176501334353744709915e-03
 	 1.18127508441192408117359491370735e-01 4.99632411307024459912184966015047e-01 2.26657835230176501334353744709915e-03
 	 4.99632411307024459912184966015047e-01 3.82240080251783131970455542614218e-01 2.26657835230176501334353744709915e-03
 	 4.99632411307024459912184966015047e-01 1.18127508441192408117359491370735e-01 2.26657835230176501334353744709915e-03
 	 3.18681016804057470892530545825139e-01 2.52708350652741664532641152618453e-01 2.68485965378233984099387576804929e-03
 	 3.18681016804057470892530545825139e-01 4.28610632543200864574828301556408e-01 2.68485965378233984099387576804929e-03
 	 2.52708350652741664532641152618453e-01 3.18681016804057470892530545825139e-01 2.68485965378233984099387576804929e-03
 	 2.52708350652741664532641152618453e-01 4.28610632543200864574828301556408e-01 2.68485965378233984099387576804929e-03
 	 4.28610632543200864574828301556408e-01 3.18681016804057470892530545825139e-01 2.68485965378233984099387576804929e-03
 	 4.28610632543200864574828301556408e-01 2.52708350652741664532641152618453e-01 2.68485965378233984099387576804929e-03
 	 3.16102429197291978635320219837013e-01 2.05745941208171606584542701057217e-01 2.50562594513383668504147294697759e-03
 	 3.16102429197291978635320219837013e-01 4.78151629594536387024561463476857e-01 2.50562594513383668504147294697759e-03
 	 2.05745941208171606584542701057217e-01 3.16102429197291978635320219837013e-01 2.50562594513383668504147294697759e-03
 	 2.05745941208171606584542701057217e-01 4.78151629594536387024561463476857e-01 2.50562594513383668504147294697759e-03
 	 4.78151629594536387024561463476857e-01 3.16102429197291978635320219837013e-01 2.50562594513383668504147294697759e-03
 	 4.78151629594536387024561463476857e-01 2.05745941208171606584542701057217e-01 2.50562594513383668504147294697759e-03
 	 2.01714360262501668508150487468811e-01 2.86457371054149485811723963024633e-02 9.76697137394438386417960806795691e-04
 	 2.01714360262501668508150487468811e-01 7.69639902632083372502336260367883e-01 9.76697137394438386417960806795691e-04
 	 2.86457371054149485811723963024633e-02 2.01714360262501668508150487468811e-01 9.76697137394438386417960806795691e-04
 	 2.86457371054149485811723963024633e-02 7.69639902632083372502336260367883e-01 9.76697137394438386417960806795691e-04
 	 7.69639902632083372502336260367883e-01 2.01714360262501668508150487468811e-01 9.76697137394438386417960806795691e-04
 	 7.69639902632083372502336260367883e-01 2.86457371054149485811723963024633e-02 9.76697137394438386417960806795691e-04
 	 3.04095374457296840908782087353757e-01 2.87008250916218343729013895426760e-02 1.13507664579970629983862728806798e-03
 	 3.04095374457296840908782087353757e-01 6.67203800451081296962740907474654e-01 1.13507664579970629983862728806798e-03
 	 2.87008250916218343729013895426760e-02 3.04095374457296840908782087353757e-01 1.13507664579970629983862728806798e-03
 	 2.87008250916218343729013895426760e-02 6.67203800451081296962740907474654e-01 1.13507664579970629983862728806798e-03
 	 6.67203800451081296962740907474654e-01 3.04095374457296840908782087353757e-01 1.13507664579970629983862728806798e-03
 	 6.67203800451081296962740907474654e-01 2.87008250916218343729013895426760e-02 1.13507664579970629983862728806798e-03
 	 2.50940600094452903601194293514709e-01 2.90822358487935334059315550803149e-02 1.06933649152424442400899362581868e-03
 	 2.50940600094452903601194293514709e-01 7.19977164056753493603935112332692e-01 1.06933649152424442400899362581868e-03
 	 2.90822358487935334059315550803149e-02 2.50940600094452903601194293514709e-01 1.06933649152424442400899362581868e-03
 	 2.90822358487935334059315550803149e-02 7.19977164056753493603935112332692e-01 1.06933649152424442400899362581868e-03
 	 7.19977164056753493603935112332692e-01 2.50940600094452903601194293514709e-01 1.06933649152424442400899362581868e-03
 	 7.19977164056753493603935112332692e-01 2.90822358487935334059315550803149e-02 1.06933649152424442400899362581868e-03
 	 2.70113685487746946201070841198089e-01 1.21742235940660512016897598641663e-01 2.13906709163620830857488464005201e-03
 	 2.70113685487746946201070841198089e-01 6.08144078571592583415394983603619e-01 2.13906709163620830857488464005201e-03
 	 1.21742235940660512016897598641663e-01 2.70113685487746946201070841198089e-01 2.13906709163620830857488464005201e-03
 	 1.21742235940660512016897598641663e-01 6.08144078571592583415394983603619e-01 2.13906709163620830857488464005201e-03
 	 6.08144078571592583415394983603619e-01 2.70113685487746946201070841198089e-01 2.13906709163620830857488464005201e-03
 	 6.08144078571592583415394983603619e-01 1.21742235940660512016897598641663e-01 2.13906709163620830857488464005201e-03
 	 4.23007886771842922524200503175962e-01 2.79469184369985149118953415836586e-02 1.25350967222140428219967489553710e-03
 	 4.23007886771842922524200503175962e-01 5.49045194791158541747222443518694e-01 1.25350967222140428219967489553710e-03
 	 2.79469184369985149118953415836586e-02 4.23007886771842922524200503175962e-01 1.25350967222140428219967489553710e-03
 	 2.79469184369985149118953415836586e-02 5.49045194791158541747222443518694e-01 1.25350967222140428219967489553710e-03
 	 5.49045194791158541747222443518694e-01 4.23007886771842922524200503175962e-01 1.25350967222140428219967489553710e-03
 	 5.49045194791158541747222443518694e-01 2.79469184369985149118953415836586e-02 1.25350967222140428219967489553710e-03
 	 2.18838108408261983184317500672478e-01 1.22140066758372467514703885171912e-01 1.98686555019924725867808135149062e-03
 	 2.18838108408261983184317500672478e-01 6.59021824833365466034251767268870e-01 1.98686555019924725867808135149062e-03
 	 1.22140066758372467514703885171912e-01 2.18838108408261983184317500672478e-01 1.98686555019924725867808135149062e-03
 	 1.22140066758372467514703885171912e-01 6.59021824833365466034251767268870e-01 1.98686555019924725867808135149062e-03
 	 6.59021824833365466034251767268870e-01 2.18838108408261983184317500672478e-01 1.98686555019924725867808135149062e-03
 	 6.59021824833365466034251767268870e-01 1.22140066758372467514703885171912e-01 1.98686555019924725867808135149062e-03
 	 3.15558282430156267217569165950408e-01 1.60412985091024695716299675041228e-01 2.37020684316891329726506576491829e-03
 	 3.15558282430156267217569165950408e-01 5.24028732478819092577282390266191e-01 2.37020684316891329726506576491829e-03
 	 1.60412985091024695716299675041228e-01 3.15558282430156267217569165950408e-01 2.37020684316891329726506576491829e-03
 	 1.60412985091024695716299675041228e-01 5.24028732478819092577282390266191e-01 2.37020684316891329726506576491829e-03
 	 5.24028732478819092577282390266191e-01 3.15558282430156267217569165950408e-01 2.37020684316891329726506576491829e-03
 	 5.24028732478819092577282390266191e-01 1.60412985091024695716299675041228e-01 2.37020684316891329726506576491829e-03
 	 3.59994205076786699670776670245687e-01 5.20384051030055791442485713105270e-02 1.58045107889224069157296792553780e-03
 	 3.59994205076786699670776670245687e-01 5.87967389820207686490505238907645e-01 1.58045107889224069157296792553780e-03
 	 5.20384051030055791442485713105270e-02 3.59994205076786699670776670245687e-01 1.58045107889224069157296792553780e-03
 	 5.20384051030055791442485713105270e-02 5.87967389820207686490505238907645e-01 1.58045107889224069157296792553780e-03
 	 5.87967389820207686490505238907645e-01 3.59994205076786699670776670245687e-01 1.58045107889224069157296792553780e-03
 	 5.87967389820207686490505238907645e-01 5.20384051030055791442485713105270e-02 1.58045107889224069157296792553780e-03
 	 7.61492805627096702725253862809041e-02 2.80080973264347880824498560059510e-02 6.53246515891860494128218217468884e-04
 	 7.61492805627096702725253862809041e-02 8.95842622110855524297789997945074e-01 6.53246515891860494128218217468884e-04
 	 2.80080973264347880824498560059510e-02 7.61492805627096702725253862809041e-02 6.53246515891860494128218217468884e-04
 	 2.80080973264347880824498560059510e-02 8.95842622110855524297789997945074e-01 6.53246515891860494128218217468884e-04
 	 8.95842622110855524297789997945074e-01 7.61492805627096702725253862809041e-02 6.53246515891860494128218217468884e-04
 	 8.95842622110855524297789997945074e-01 2.80080973264347880824498560059510e-02 6.53246515891860494128218217468884e-04
 	 3.61687125042856494339105211111018e-01 2.83641992932530291604553696060975e-02 1.21120828529704105923359147567453e-03
 	 3.61687125042856494339105211111018e-01 6.09948675663890438336522947793128e-01 1.21120828529704105923359147567453e-03
 	 2.83641992932530291604553696060975e-02 3.61687125042856494339105211111018e-01 1.21120828529704105923359147567453e-03
 	 2.83641992932530291604553696060975e-02 6.09948675663890438336522947793128e-01 1.21120828529704105923359147567453e-03
 	 6.09948675663890438336522947793128e-01 3.61687125042856494339105211111018e-01 1.21120828529704105923359147567453e-03
 	 6.09948675663890438336522947793128e-01 2.83641992932530291604553696060975e-02 1.21120828529704105923359147567453e-03
 	 3.96957042979479091115990740945563e-01 8.18149550216045046147073094289226e-02 2.06687929519422559920815984924047e-03
 	 3.96957042979479091115990740945563e-01 5.21228001998916390391514141811058e-01 2.06687929519422559920815984924047e-03
 	 8.18149550216045046147073094289226e-02 3.96957042979479091115990740945563e-01 2.06687929519422559920815984924047e-03
 	 8.18149550216045046147073094289226e-02 5.21228001998916390391514141811058e-01 2.06687929519422559920815984924047e-03
 	 5.21228001998916390391514141811058e-01 3.96957042979479091115990740945563e-01 2.06687929519422559920815984924047e-03
 	 5.21228001998916390391514141811058e-01 8.18149550216045046147073094289226e-02 2.06687929519422559920815984924047e-03
 	 2.63582104650385729005535040414543e-01 2.12133896316561210149131966318237e-01 2.55256659060561609878026168019005e-03
 	 2.63582104650385729005535040414543e-01 5.24283999033053116356484224525047e-01 2.55256659060561609878026168019005e-03
 	 2.12133896316561210149131966318237e-01 2.63582104650385729005535040414543e-01 2.55256659060561609878026168019005e-03
 	 2.12133896316561210149131966318237e-01 5.24283999033053116356484224525047e-01 2.55256659060561609878026168019005e-03
 	 5.24283999033053116356484224525047e-01 2.63582104650385729005535040414543e-01 2.55256659060561609878026168019005e-03
 	 5.24283999033053116356484224525047e-01 2.12133896316561210149131966318237e-01 2.55256659060561609878026168019005e-03
 	 1.92535054212271156126590199164639e-01 5.24452042229162709863210523053567e-02 1.34881166699170914995142833703312e-03
 	 1.92535054212271156126590199164639e-01 7.55019741564812552070407036808319e-01 1.34881166699170914995142833703312e-03
 	 5.24452042229162709863210523053567e-02 1.92535054212271156126590199164639e-01 1.34881166699170914995142833703312e-03
 	 5.24452042229162709863210523053567e-02 7.55019741564812552070407036808319e-01 1.34881166699170914995142833703312e-03
 	 7.55019741564812552070407036808319e-01 1.92535054212271156126590199164639e-01 1.34881166699170914995142833703312e-03
 	 7.55019741564812552070407036808319e-01 5.24452042229162709863210523053567e-02 1.34881166699170914995142833703312e-03
 	 1.55053798001932918726453181079705e-01 2.91776764327326132431039695802610e-02 9.40482198953650075715082756744323e-04
 	 1.55053798001932918726453181079705e-01 8.15768525565334523541594080597861e-01 9.40482198953650075715082756744323e-04
 	 2.91776764327326132431039695802610e-02 1.55053798001932918726453181079705e-01 9.40482198953650075715082756744323e-04
 	 2.91776764327326132431039695802610e-02 8.15768525565334523541594080597861e-01 9.40482198953650075715082756744323e-04
 	 8.15768525565334523541594080597861e-01 1.55053798001932918726453181079705e-01 9.40482198953650075715082756744323e-04
 	 8.15768525565334523541594080597861e-01 2.91776764327326132431039695802610e-02 9.40482198953650075715082756744323e-04
 	 8.08139183670610050658211775953532e-02 1.16752954894914842687292377831909e-02 4.57109505137131535892208722415830e-04
 	 8.08139183670610050658211775953532e-02 9.07510786143447489848767872899771e-01 4.57109505137131535892208722415830e-04
 	 1.16752954894914842687292377831909e-02 8.08139183670610050658211775953532e-02 4.57109505137131535892208722415830e-04
 	 1.16752954894914842687292377831909e-02 9.07510786143447489848767872899771e-01 4.57109505137131535892208722415830e-04
 	 9.07510786143447489848767872899771e-01 8.08139183670610050658211775953532e-02 4.57109505137131535892208722415830e-04
 	 9.07510786143447489848767872899771e-01 1.16752954894914842687292377831909e-02 4.57109505137131535892208722415830e-04
 	 4.94903005695827707954848051485897e-02 1.13529551848956314352712126947154e-02 3.50532801434540880469725721013674e-04
 	 4.94903005695827707954848051485897e-02 9.39156744245521535319198846991640e-01 3.50532801434540880469725721013674e-04
 	 1.13529551848956314352712126947154e-02 4.94903005695827707954848051485897e-02 3.50532801434540880469725721013674e-04
 	 1.13529551848956314352712126947154e-02 9.39156744245521535319198846991640e-01 3.50532801434540880469725721013674e-04
 	 9.39156744245521535319198846991640e-01 4.94903005695827707954848051485897e-02 3.50532801434540880469725721013674e-04
 	 9.39156744245521535319198846991640e-01 1.13529551848956314352712126947154e-02 3.50532801434540880469725721013674e-04
 	 3.01366119175060842572122510318877e-01 5.27412086548005240582703834206768e-02 1.59505282435752713393606327940688e-03
 	 3.01366119175060842572122510318877e-01 6.45892672170138681941864433611045e-01 1.59505282435752713393606327940688e-03
 	 5.27412086548005240582703834206768e-02 3.01366119175060842572122510318877e-01 1.59505282435752713393606327940688e-03
 	 5.27412086548005240582703834206768e-02 6.45892672170138681941864433611045e-01 1.59505282435752713393606327940688e-03
 	 6.45892672170138681941864433611045e-01 3.01366119175060842572122510318877e-01 1.59505282435752713393606327940688e-03
 	 6.45892672170138681941864433611045e-01 5.27412086548005240582703834206768e-02 1.59505282435752713393606327940688e-03
 	 1.45559094124306370732213622432027e-01 5.39363844971338171618846502042288e-02 1.21691292055276802618057896410164e-03
 	 1.45559094124306370732213622432027e-01 8.00504521378559874555946862528799e-01 1.21691292055276802618057896410164e-03
 	 5.39363844971338171618846502042288e-02 1.45559094124306370732213622432027e-01 1.21691292055276802618057896410164e-03
 	 5.39363844971338171618846502042288e-02 8.00504521378559874555946862528799e-01 1.21691292055276802618057896410164e-03
 	 8.00504521378559874555946862528799e-01 1.45559094124306370732213622432027e-01 1.21691292055276802618057896410164e-03
 	 8.00504521378559874555946862528799e-01 5.39363844971338171618846502042288e-02 1.21691292055276802618057896410164e-03
 	 3.39239311459584025332247847472900e-02 2.02689658380067255424861194512687e-03 1.25423725728734887551255039461751e-04
 	 3.39239311459584025332247847472900e-02 9.64049172270241006010849105223315e-01 1.25423725728734887551255039461751e-04
 	 2.02689658380067255424861194512687e-03 3.39239311459584025332247847472900e-02 1.25423725728734887551255039461751e-04
 	 2.02689658380067255424861194512687e-03 9.64049172270241006010849105223315e-01 1.25423725728734887551255039461751e-04
 	 9.64049172270241006010849105223315e-01 3.39239311459584025332247847472900e-02 1.25423725728734887551255039461751e-04
 	 9.64049172270241006010849105223315e-01 2.02689658380067255424861194512687e-03 1.25423725728734887551255039461751e-04
 	 4.60920398298352129717869729574886e-01 1.13741139787508632741364067442191e-02 8.55406563880253541058695798682265e-04
 	 4.60920398298352129717869729574886e-01 5.27705487722897048641357287124265e-01 8.55406563880253541058695798682265e-04
 	 1.13741139787508632741364067442191e-02 4.60920398298352129717869729574886e-01 8.55406563880253541058695798682265e-04
 	 1.13741139787508632741364067442191e-02 5.27705487722897048641357287124265e-01 8.55406563880253541058695798682265e-04
 	 5.27705487722897048641357287124265e-01 4.60920398298352129717869729574886e-01 8.55406563880253541058695798682265e-04
 	 5.27705487722897048641357287124265e-01 1.13741139787508632741364067442191e-02 8.55406563880253541058695798682265e-04
 	 2.09650636992742611663942398081417e-01 1.64719735798059069287191391595115e-01 2.26400606671470303737914164798894e-03
 	 2.09650636992742611663942398081417e-01 6.25629627209198235782139363436727e-01 2.26400606671470303737914164798894e-03
 	 1.64719735798059069287191391595115e-01 2.09650636992742611663942398081417e-01 2.26400606671470303737914164798894e-03
 	 1.64719735798059069287191391595115e-01 6.25629627209198235782139363436727e-01 2.26400606671470303737914164798894e-03
 	 6.25629627209198235782139363436727e-01 2.09650636992742611663942398081417e-01 2.26400606671470303737914164798894e-03
 	 6.25629627209198235782139363436727e-01 1.64719735798059069287191391595115e-01 2.26400606671470303737914164798894e-03
 	 3.35618830727636319188889046927216e-01 8.24852827778116137746877711833804e-02 2.00406961507452368101422912616272e-03
 	 3.35618830727636319188889046927216e-01 5.81895886494552039280847566260491e-01 2.00406961507452368101422912616272e-03
 	 8.24852827778116137746877711833804e-02 3.35618830727636319188889046927216e-01 2.00406961507452368101422912616272e-03
 	 8.24852827778116137746877711833804e-02 5.81895886494552039280847566260491e-01 2.00406961507452368101422912616272e-03
 	 5.81895886494552039280847566260491e-01 3.35618830727636319188889046927216e-01 2.00406961507452368101422912616272e-03
 	 5.81895886494552039280847566260491e-01 8.24852827778116137746877711833804e-02 2.00406961507452368101422912616272e-03
 	 1.19198356094802629390194681491266e-01 1.18660258094383762317303165900739e-02 5.59770199953665294721749656758902e-04
 	 1.19198356094802629390194681491266e-01 8.68935618095758921519689010892762e-01 5.59770199953665294721749656758902e-04
 	 1.18660258094383762317303165900739e-02 1.19198356094802629390194681491266e-01 5.59770199953665294721749656758902e-04
 	 1.18660258094383762317303165900739e-02 8.68935618095758921519689010892762e-01 5.59770199953665294721749656758902e-04
 	 8.68935618095758921519689010892762e-01 1.19198356094802629390194681491266e-01 5.59770199953665294721749656758902e-04
 	 8.68935618095758921519689010892762e-01 1.18660258094383762317303165900739e-02 5.59770199953665294721749656758902e-04
 	 1.12751742717588893105684633155761e-01 2.89885801232179704522984309278399e-02 8.27824540613835498266415147128328e-04
 	 1.12751742717588893105684633155761e-01 8.58259677159193157258698647638084e-01 8.27824540613835498266415147128328e-04
 	 2.89885801232179704522984309278399e-02 1.12751742717588893105684633155761e-01 8.27824540613835498266415147128328e-04
 	 2.89885801232179704522984309278399e-02 8.58259677159193157258698647638084e-01 8.27824540613835498266415147128328e-04
 	 8.58259677159193157258698647638084e-01 1.12751742717588893105684633155761e-01 8.27824540613835498266415147128328e-04
 	 8.58259677159193157258698647638084e-01 2.89885801232179704522984309278399e-02 8.27824540613835498266415147128328e-04
 	 2.44604484993710485918327890431101e-01 5.36092519706683826030690909192344e-02 1.53727860563678919540719913783278e-03
 	 2.44604484993710485918327890431101e-01 7.01786263035621193928648153814720e-01 1.53727860563678919540719913783278e-03
 	 5.36092519706683826030690909192344e-02 2.44604484993710485918327890431101e-01 1.53727860563678919540719913783278e-03
 	 5.36092519706683826030690909192344e-02 7.01786263035621193928648153814720e-01 1.53727860563678919540719913783278e-03
 	 7.01786263035621193928648153814720e-01 2.44604484993710485918327890431101e-01 1.53727860563678919540719913783278e-03
 	 7.01786263035621193928648153814720e-01 5.36092519706683826030690909192344e-02 1.53727860563678919540719913783278e-03
 	 2.61327895213015415354362858124659e-01 1.64967292586388120101403842454602e-01 2.41503521209857595353209802624406e-03
 	 2.61327895213015415354362858124659e-01 5.73704812200596547810960146307480e-01 2.41503521209857595353209802624406e-03
 	 1.64967292586388120101403842454602e-01 2.61327895213015415354362858124659e-01 2.41503521209857595353209802624406e-03
 	 1.64967292586388120101403842454602e-01 5.73704812200596547810960146307480e-01 2.41503521209857595353209802624406e-03
 	 5.73704812200596547810960146307480e-01 2.61327895213015415354362858124659e-01 2.41503521209857595353209802624406e-03
 	 5.73704812200596547810960146307480e-01 1.64967292586388120101403842454602e-01 2.41503521209857595353209802624406e-03
 	 2.76710222358847013346405674383277e-01 8.41334586353880142794992025301326e-02 1.94934870191071406633764873106429e-03
 	 2.76710222358847013346405674383277e-01 6.39156319005764972374095123086590e-01 1.94934870191071406633764873106429e-03
 	 8.41334586353880142794992025301326e-02 2.76710222358847013346405674383277e-01 1.94934870191071406633764873106429e-03
 	 8.41334586353880142794992025301326e-02 6.39156319005764972374095123086590e-01 1.94934870191071406633764873106429e-03
 	 6.39156319005764972374095123086590e-01 2.76710222358847013346405674383277e-01 1.94934870191071406633764873106429e-03
 	 6.39156319005764972374095123086590e-01 8.41334586353880142794992025301326e-02 1.94934870191071406633764873106429e-03
 	 3.31057698305513958825230247384752e-01 1.17181407852650371764768877369534e-02 8.22925995577372887748723861989220e-04
 	 3.31057698305513958825230247384752e-01 6.57224160909220977977440725226188e-01 8.22925995577372887748723861989220e-04
 	 1.17181407852650371764768877369534e-02 3.31057698305513958825230247384752e-01 8.22925995577372887748723861989220e-04
 	 1.17181407852650371764768877369534e-02 6.57224160909220977977440725226188e-01 8.22925995577372887748723861989220e-04
 	 6.57224160909220977977440725226188e-01 3.31057698305513958825230247384752e-01 8.22925995577372887748723861989220e-04
 	 6.57224160909220977977440725226188e-01 1.17181407852650371764768877369534e-02 8.22925995577372887748723861989220e-04
 	 1.71165960353522994541464186113444e-01 1.19825159275385270674085802511399e-01 1.85595243546373854168218819893355e-03
 	 1.71165960353522994541464186113444e-01 7.09008880371091776417813434818527e-01 1.85595243546373854168218819893355e-03
 	 1.19825159275385270674085802511399e-01 1.71165960353522994541464186113444e-01 1.85595243546373854168218819893355e-03
 	 1.19825159275385270674085802511399e-01 7.09008880371091776417813434818527e-01 1.85595243546373854168218819893355e-03
 	 7.09008880371091776417813434818527e-01 1.71165960353522994541464186113444e-01 1.85595243546373854168218819893355e-03
 	 7.09008880371091776417813434818527e-01 1.19825159275385270674085802511399e-01 1.85595243546373854168218819893355e-03
 	 2.14838093540415636661933262985258e-01 1.18084740509011697912056249037960e-02 7.09287803930805133174886112357171e-04
 	 2.14838093540415636661933262985258e-01 7.73353432408683261201076675206423e-01 7.09287803930805133174886112357171e-04
 	 1.18084740509011697912056249037960e-02 2.14838093540415636661933262985258e-01 7.09287803930805133174886112357171e-04
 	 1.18084740509011697912056249037960e-02 7.73353432408683261201076675206423e-01 7.09287803930805133174886112357171e-04
 	 7.73353432408683261201076675206423e-01 2.14838093540415636661933262985258e-01 7.09287803930805133174886112357171e-04
 	 7.73353432408683261201076675206423e-01 1.18084740509011697912056249037960e-02 7.09287803930805133174886112357171e-04
 	 1.64032595788237256506647554488154e-01 1.18982357159540252933282999947551e-02 6.44529097785457921396257141566366e-04
 	 1.64032595788237256506647554488154e-01 8.24069168495808690444448529888177e-01 6.44529097785457921396257141566366e-04
 	 1.18982357159540252933282999947551e-02 1.64032595788237256506647554488154e-01 6.44529097785457921396257141566366e-04
 	 1.18982357159540252933282999947551e-02 8.24069168495808690444448529888177e-01 6.44529097785457921396257141566366e-04
 	 8.24069168495808690444448529888177e-01 1.64032595788237256506647554488154e-01 6.44529097785457921396257141566366e-04
 	 8.24069168495808690444448529888177e-01 1.18982357159540252933282999947551e-02 6.44529097785457921396257141566366e-04
 	 2.70599520519274439056545134008047e-01 1.18476002079960143070769262862996e-02 7.80745027452894131345106920605303e-04
 	 2.70599520519274439056545134008047e-01 7.17552879272729593473911791079445e-01 7.80745027452894131345106920605303e-04
 	 1.18476002079960143070769262862996e-02 2.70599520519274439056545134008047e-01 7.80745027452894131345106920605303e-04
 	 1.18476002079960143070769262862996e-02 7.17552879272729593473911791079445e-01 7.80745027452894131345106920605303e-04
 	 7.17552879272729593473911791079445e-01 2.70599520519274439056545134008047e-01 7.80745027452894131345106920605303e-04
 	 7.17552879272729593473911791079445e-01 1.18476002079960143070769262862996e-02 7.80745027452894131345106920605303e-04
 	 3.94881529905421246873231666540960e-01 1.15294467270000370456850546929672e-02 8.47635945473002960608155387234319e-04
 	 3.94881529905421246873231666540960e-01 5.93589023367578683121337235206738e-01 8.47635945473002960608155387234319e-04
 	 1.15294467270000370456850546929672e-02 3.94881529905421246873231666540960e-01 8.47635945473002960608155387234319e-04
 	 1.15294467270000370456850546929672e-02 5.93589023367578683121337235206738e-01 8.47635945473002960608155387234319e-04
 	 5.93589023367578683121337235206738e-01 3.94881529905421246873231666540960e-01 8.47635945473002960608155387234319e-04
 	 5.93589023367578683121337235206738e-01 1.15294467270000370456850546929672e-02 8.47635945473002960608155387234319e-04
 	 9.76801440609630089451087542329333e-02 2.24970582857548151087256904645528e-03 2.26401136283958852530098782018797e-04
 	 9.76801440609630089451087542329333e-02 9.00070150110461431047781388770090e-01 2.26401136283958852530098782018797e-04
 	 2.24970582857548151087256904645528e-03 9.76801440609630089451087542329333e-02 2.26401136283958852530098782018797e-04
 	 2.24970582857548151087256904645528e-03 9.00070150110461431047781388770090e-01 2.26401136283958852530098782018797e-04
 	 9.00070150110461431047781388770090e-01 9.76801440609630089451087542329333e-02 2.26401136283958852530098782018797e-04
 	 9.00070150110461431047781388770090e-01 2.24970582857548151087256904645528e-03 2.26401136283958852530098782018797e-04
 	 4.31663188476496095802303898381069e-01 2.17808311913864462508461095069379e-03 3.72669915533183722031185247658414e-04
 	 4.31663188476496095802303898381069e-01 5.66158728404365207964588080358226e-01 3.72669915533183722031185247658414e-04
 	 2.17808311913864462508461095069379e-03 4.31663188476496095802303898381069e-01 3.72669915533183722031185247658414e-04
 	 2.17808311913864462508461095069379e-03 5.66158728404365207964588080358226e-01 3.72669915533183722031185247658414e-04
 	 5.66158728404365207964588080358226e-01 4.31663188476496095802303898381069e-01 3.72669915533183722031185247658414e-04
 	 5.66158728404365207964588080358226e-01 2.17808311913864462508461095069379e-03 3.72669915533183722031185247658414e-04
 	 1.40323860572580283445631721406244e-01 2.25943109747260215125486126908072e-03 2.66174073629336016208468684851596e-04
 	 1.40323860572580283445631721406244e-01 8.57416708329947097055878657556605e-01 2.66174073629336016208468684851596e-04
 	 2.25943109747260215125486126908072e-03 1.40323860572580283445631721406244e-01 2.66174073629336016208468684851596e-04
 	 2.25943109747260215125486126908072e-03 8.57416708329947097055878657556605e-01 2.66174073629336016208468684851596e-04
 	 8.57416708329947097055878657556605e-01 1.40323860572580283445631721406244e-01 2.66174073629336016208468684851596e-04
 	 8.57416708329947097055878657556605e-01 2.25943109747260215125486126908072e-03 2.66174073629336016208468684851596e-04
 	 2.43796900107501685051047957131232e-01 2.24895104491058166543138163717686e-03 3.28809841813198307138715881237090e-04
 	 2.43796900107501685051047957131232e-01 7.53954148847587712900519818504108e-01 3.28809841813198307138715881237090e-04
 	 2.24895104491058166543138163717686e-03 2.43796900107501685051047957131232e-01 3.28809841813198307138715881237090e-04
 	 2.24895104491058166543138163717686e-03 7.53954148847587712900519818504108e-01 3.28809841813198307138715881237090e-04
 	 7.53954148847587712900519818504108e-01 2.43796900107501685051047957131232e-01 3.28809841813198307138715881237090e-04
 	 7.53954148847587712900519818504108e-01 2.24895104491058166543138163717686e-03 3.28809841813198307138715881237090e-04
 	 6.19939934379152152166270184352470e-02 2.21078294406797885157667238331669e-03 1.81034525565338646948404521808129e-04
 	 6.19939934379152152166270184352470e-02 9.35795223618016813738051951077068e-01 1.81034525565338646948404521808129e-04
 	 2.21078294406797885157667238331669e-03 6.19939934379152152166270184352470e-02 1.81034525565338646948404521808129e-04
 	 2.21078294406797885157667238331669e-03 9.35795223618016813738051951077068e-01 1.81034525565338646948404521808129e-04
 	 9.35795223618016813738051951077068e-01 6.19939934379152152166270184352470e-02 1.81034525565338646948404521808129e-04
 	 9.35795223618016813738051951077068e-01 2.21078294406797885157667238331669e-03 1.81034525565338646948404521808129e-04
 	 3.02950492841990437486998644089908e-01 2.24993142954393399515766738261391e-03 3.53005972835246806945663777810296e-04
 	 3.02950492841990437486998644089908e-01 6.94799575728465734769656592106912e-01 3.53005972835246806945663777810296e-04
 	 2.24993142954393399515766738261391e-03 3.02950492841990437486998644089908e-01 3.53005972835246806945663777810296e-04
 	 2.24993142954393399515766738261391e-03 6.94799575728465734769656592106912e-01 3.53005972835246806945663777810296e-04
 	 6.94799575728465734769656592106912e-01 3.02950492841990437486998644089908e-01 3.53005972835246806945663777810296e-04
 	 6.94799575728465734769656592106912e-01 2.24993142954393399515766738261391e-03 3.53005972835246806945663777810296e-04
 	 1.89266100502910289415936517798400e-01 2.26403926204082287659824501702133e-03 3.00938551109985823715786690257801e-04
 	 1.89266100502910289415936517798400e-01 8.08469860235048964902659918152494e-01 3.00938551109985823715786690257801e-04
 	 2.26403926204082287659824501702133e-03 1.89266100502910289415936517798400e-01 3.00938551109985823715786690257801e-04
 	 2.26403926204082287659824501702133e-03 8.08469860235048964902659918152494e-01 3.00938551109985823715786690257801e-04
 	 8.08469860235048964902659918152494e-01 1.89266100502910289415936517798400e-01 3.00938551109985823715786690257801e-04
 	 8.08469860235048964902659918152494e-01 2.26403926204082287659824501702133e-03 3.00938551109985823715786690257801e-04
 	 3.65919027936809082568458961759461e-01 2.21351192100762176814821025061519e-03 3.66319673274832953435709015366228e-04
 	 3.65919027936809082568458961759461e-01 6.31867460142183312576946718763793e-01 3.66319673274832953435709015366228e-04
 	 2.21351192100762176814821025061519e-03 3.65919027936809082568458961759461e-01 3.66319673274832953435709015366228e-04
 	 2.21351192100762176814821025061519e-03 6.31867460142183312576946718763793e-01 3.66319673274832953435709015366228e-04
 	 6.31867460142183312576946718763793e-01 3.65919027936809082568458961759461e-01 3.66319673274832953435709015366228e-04
 	 6.31867460142183312576946718763793e-01 2.21351192100762176814821025061519e-03 3.66319673274832953435709015366228e-04
 	 ];
 
 	 case  48 

 	 % ALG. DEG.:   48
 	 % PTS CARD.:  423
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 3.47724458710809425365795277684811e-01 3.47724458710809425365795277684811e-01 2.18256937689137106572978552776476e-03
 	 3.47724458710809425365795277684811e-01 3.04551082578381149268409444630379e-01 2.18256937689137106572978552776476e-03
 	 3.04551082578381149268409444630379e-01 3.47724458710809425365795277684811e-01 2.18256937689137106572978552776476e-03
 	 3.73431271255322050350855533906724e-01 3.73431271255322050350855533906724e-01 1.98458752265129366801343913095934e-03
 	 3.73431271255322050350855533906724e-01 2.53137457489355899298288932186551e-01 1.98458752265129366801343913095934e-03
 	 2.53137457489355899298288932186551e-01 3.73431271255322050350855533906724e-01 1.98458752265129366801343913095934e-03
 	 4.89339053562853232293150540499482e-01 4.89339053562853232293150540499482e-01 9.11057268392256066995293917187837e-04
 	 4.89339053562853232293150540499482e-01 2.13218928742935354136989190010354e-02 9.11057268392256066995293917187837e-04
 	 2.13218928742935354136989190010354e-02 4.89339053562853232293150540499482e-01 9.11057268392256066995293917187837e-04
 	 4.84109248251398810447554410529847e-02 4.84109248251398810447554410529847e-02 6.05723625032490351448311027837690e-04
 	 4.84109248251398810447554410529847e-02 9.03178150349720265666064733522944e-01 6.05723625032490351448311027837690e-04
 	 9.03178150349720265666064733522944e-01 4.84109248251398810447554410529847e-02 6.05723625032490351448311027837690e-04
 	 8.01595487479755675064296838172595e-02 8.01595487479755675064296838172595e-02 9.65477244813535938339210673575508e-04
 	 8.01595487479755675064296838172595e-02 8.39680902504048809475989401107654e-01 9.65477244813535938339210673575508e-04
 	 8.39680902504048809475989401107654e-01 8.01595487479755675064296838172595e-02 9.65477244813535938339210673575508e-04
 	 4.79090265959213501556490655275411e-01 4.79090265959213501556490655275411e-01 1.32001218782053795011699470762778e-03
 	 4.79090265959213501556490655275411e-01 4.18194680815729968870186894491781e-02 1.32001218782053795011699470762778e-03
 	 4.18194680815729968870186894491781e-02 4.79090265959213501556490655275411e-01 1.32001218782053795011699470762778e-03
 	 4.66642415348434647093256444350118e-01 4.66642415348434647093256444350118e-01 1.64209604320303642448208858439784e-03
 	 4.66642415348434647093256444350118e-01 6.67151693031307058134871112997644e-02 1.64209604320303642448208858439784e-03
 	 6.67151693031307058134871112997644e-02 4.66642415348434647093256444350118e-01 1.64209604320303642448208858439784e-03
 	 1.17045744671133034736643097062370e-02 1.17045744671133034736643097062370e-02 1.61472479217407985851648333230912e-04
 	 1.17045744671133034736643097062370e-02 9.76590851065773368766542716912227e-01 1.61472479217407985851648333230912e-04
 	 9.76590851065773368766542716912227e-01 1.17045744671133034736643097062370e-02 1.61472479217407985851648333230912e-04
 	 2.67846513711168798810291491463431e-01 2.67846513711168798810291491463431e-01 2.71552315199755653699065227613119e-03
 	 2.67846513711168798810291491463431e-01 4.64306972577662402379417017073138e-01 2.71552315199755653699065227613119e-03
 	 4.64306972577662402379417017073138e-01 2.67846513711168798810291491463431e-01 2.71552315199755653699065227613119e-03
 	 2.13138272480190765767460447932535e-01 2.13138272480190765767460447932535e-01 2.57628027224190850677509878607907e-03
 	 2.13138272480190765767460447932535e-01 5.73723455039618412953927872877102e-01 2.57628027224190850677509878607907e-03
 	 5.73723455039618412953927872877102e-01 2.13138272480190765767460447932535e-01 2.57628027224190850677509878607907e-03
 	 4.33626661366610932635268227386405e-01 4.33626661366610932635268227386405e-01 2.49650257497091836861313751683156e-03
 	 4.33626661366610932635268227386405e-01 1.32746677266778134729463545227190e-01 2.49650257497091836861313751683156e-03
 	 1.32746677266778134729463545227190e-01 4.33626661366610932635268227386405e-01 2.49650257497091836861313751683156e-03
 	 1.59900914440538832739235886037932e-01 1.59900914440538832739235886037932e-01 2.12174924592708254861284089543005e-03
 	 1.59900914440538832739235886037932e-01 6.80198171118922334521528227924136e-01 2.12174924592708254861284089543005e-03
 	 6.80198171118922334521528227924136e-01 1.59900914440538832739235886037932e-01 2.12174924592708254861284089543005e-03
 	 2.80636634926781647347837633788004e-02 2.80636634926781647347837633788004e-02 4.43800280512310265507158746345340e-04
 	 2.80636634926781647347837633788004e-02 9.43872673014643615019281241984572e-01 4.43800280512310265507158746345340e-04
 	 9.43872673014643615019281241984572e-01 2.80636634926781647347837633788004e-02 4.43800280512310265507158746345340e-04
 	 1.08047129242305917085076316652703e-01 1.08047129242305917085076316652703e-01 1.58696417448596512576874939526306e-03
 	 1.08047129242305917085076316652703e-01 7.83905741515388165829847366694594e-01 1.58696417448596512576874939526306e-03
 	 7.83905741515388165829847366694594e-01 1.08047129242305917085076316652703e-01 1.58696417448596512576874939526306e-03
 	 4.97175637238466083811516682544607e-01 4.97175637238466083811516682544607e-01 6.47539955694782895685712720279525e-04
 	 4.97175637238466083811516682544607e-01 5.64872552306783237696663491078652e-03 6.47539955694782895685712720279525e-04
 	 5.64872552306783237696663491078652e-03 4.97175637238466083811516682544607e-01 6.47539955694782895685712720279525e-04
 	 3.69567291590166213666179828578606e-01 2.15700644169616900791552893679182e-01 1.85996570614835625076532998889434e-03
 	 3.69567291590166213666179828578606e-01 4.14732064240216913297842893371126e-01 1.85996570614835625076532998889434e-03
 	 2.15700644169616900791552893679182e-01 3.69567291590166213666179828578606e-01 1.85996570614835625076532998889434e-03
 	 2.15700644169616900791552893679182e-01 4.14732064240216913297842893371126e-01 1.85996570614835625076532998889434e-03
 	 4.14732064240216913297842893371126e-01 3.69567291590166213666179828578606e-01 1.85996570614835625076532998889434e-03
 	 4.14732064240216913297842893371126e-01 2.15700644169616900791552893679182e-01 1.85996570614835625076532998889434e-03
 	 3.08481897993362230714353700022912e-01 1.08301499922003982567808577641699e-01 1.51630547228510373022891677408097e-03
 	 3.08481897993362230714353700022912e-01 5.83216602084633772840049914520932e-01 1.51630547228510373022891677408097e-03
 	 1.08301499922003982567808577641699e-01 3.08481897993362230714353700022912e-01 1.51630547228510373022891677408097e-03
 	 1.08301499922003982567808577641699e-01 5.83216602084633772840049914520932e-01 1.51630547228510373022891677408097e-03
 	 5.83216602084633772840049914520932e-01 3.08481897993362230714353700022912e-01 1.51630547228510373022891677408097e-03
 	 5.83216602084633772840049914520932e-01 1.08301499922003982567808577641699e-01 1.51630547228510373022891677408097e-03
 	 3.19642729224551336297821535481489e-01 3.46959527711364415503147995423205e-02 9.23505432416745993852436047433230e-04
 	 3.19642729224551336297821535481489e-01 6.45661318004312145824030721996678e-01 9.23505432416745993852436047433230e-04
 	 3.46959527711364415503147995423205e-02 3.19642729224551336297821535481489e-01 9.23505432416745993852436047433230e-04
 	 3.46959527711364415503147995423205e-02 6.45661318004312145824030721996678e-01 9.23505432416745993852436047433230e-04
 	 6.45661318004312145824030721996678e-01 3.19642729224551336297821535481489e-01 9.23505432416745993852436047433230e-04
 	 6.45661318004312145824030721996678e-01 3.46959527711364415503147995423205e-02 9.23505432416745993852436047433230e-04
 	 9.96255965477151894660323705465999e-01 1.34606393094949803625193229805745e-03 1.18864540424329079282544235907082e-05
 	 9.96255965477151894660323705465999e-01 2.39797059189860752026479673304493e-03 1.18864540424329079282544235907082e-05
 	 1.34606393094949803625193229805745e-03 9.96255965477151894660323705465999e-01 1.18864540424329079282544235907082e-05
 	 1.34606393094949803625193229805745e-03 2.39797059189860752026479673304493e-03 1.18864540424329079282544235907082e-05
 	 2.39797059189860752026479673304493e-03 9.96255965477151894660323705465999e-01 1.18864540424329079282544235907082e-05
 	 2.39797059189860752026479673304493e-03 1.34606393094949803625193229805745e-03 1.18864540424329079282544235907082e-05
 	 3.28084817808831308294514883527881e-01 1.91707840803216067460112981279963e-02 7.72483726320484249266984377868539e-04
 	 3.28084817808831308294514883527881e-01 6.52744398110847057203898202715209e-01 7.72483726320484249266984377868539e-04
 	 1.91707840803216067460112981279963e-02 3.28084817808831308294514883527881e-01 7.72483726320484249266984377868539e-04
 	 1.91707840803216067460112981279963e-02 6.52744398110847057203898202715209e-01 7.72483726320484249266984377868539e-04
 	 6.52744398110847057203898202715209e-01 3.28084817808831308294514883527881e-01 7.72483726320484249266984377868539e-04
 	 6.52744398110847057203898202715209e-01 1.91707840803216067460112981279963e-02 7.72483726320484249266984377868539e-04
 	 3.19812908272719464974898073705845e-01 2.76361565310809742523900922606117e-01 2.51594349134969886075396949820515e-03
 	 3.19812908272719464974898073705845e-01 4.03825526416470792501201003688038e-01 2.51594349134969886075396949820515e-03
 	 2.76361565310809742523900922606117e-01 3.19812908272719464974898073705845e-01 2.51594349134969886075396949820515e-03
 	 2.76361565310809742523900922606117e-01 4.03825526416470792501201003688038e-01 2.51594349134969886075396949820515e-03
 	 4.03825526416470792501201003688038e-01 3.19812908272719464974898073705845e-01 2.51594349134969886075396949820515e-03
 	 4.03825526416470792501201003688038e-01 2.76361565310809742523900922606117e-01 2.51594349134969886075396949820515e-03
 	 1.58926601361820019064907683059573e-01 1.64116834381746313879790744039155e-03 1.94367883400491949473509745160982e-04
 	 1.58926601361820019064907683059573e-01 8.39432230294362535794050472759409e-01 1.94367883400491949473509745160982e-04
 	 1.64116834381746313879790744039155e-03 1.58926601361820019064907683059573e-01 1.94367883400491949473509745160982e-04
 	 1.64116834381746313879790744039155e-03 8.39432230294362535794050472759409e-01 1.94367883400491949473509745160982e-04
 	 8.39432230294362535794050472759409e-01 1.58926601361820019064907683059573e-01 1.94367883400491949473509745160982e-04
 	 8.39432230294362535794050472759409e-01 1.64116834381746313879790744039155e-03 1.94367883400491949473509745160982e-04
 	 1.96275977197235607096814646865823e-01 5.33231934213235156394539160373824e-02 1.14648466765973405454004385717326e-03
 	 1.96275977197235607096814646865823e-01 7.50400829381440925835988764447393e-01 1.14648466765973405454004385717326e-03
 	 5.33231934213235156394539160373824e-02 1.96275977197235607096814646865823e-01 1.14648466765973405454004385717326e-03
 	 5.33231934213235156394539160373824e-02 7.50400829381440925835988764447393e-01 1.14648466765973405454004385717326e-03
 	 7.50400829381440925835988764447393e-01 1.96275977197235607096814646865823e-01 1.14648466765973405454004385717326e-03
 	 7.50400829381440925835988764447393e-01 5.33231934213235156394539160373824e-02 1.14648466765973405454004385717326e-03
 	 2.93342184590181742631642691776506e-01 8.29288364011383782870012737475918e-02 1.62950409788547570175132328529344e-03
 	 2.93342184590181742631642691776506e-01 6.23728979008679851325780418846989e-01 1.62950409788547570175132328529344e-03
 	 8.29288364011383782870012737475918e-02 2.93342184590181742631642691776506e-01 1.62950409788547570175132328529344e-03
 	 8.29288364011383782870012737475918e-02 6.23728979008679851325780418846989e-01 1.62950409788547570175132328529344e-03
 	 6.23728979008679851325780418846989e-01 2.93342184590181742631642691776506e-01 1.62950409788547570175132328529344e-03
 	 6.23728979008679851325780418846989e-01 8.29288364011383782870012737475918e-02 1.62950409788547570175132328529344e-03
 	 1.24727325881397566043062852259027e-01 2.33190171491815048665507958958187e-02 6.49717196700759806390901296424545e-04
 	 1.24727325881397566043062852259027e-01 8.51953656969420936029280255752383e-01 6.49717196700759806390901296424545e-04
 	 2.33190171491815048665507958958187e-02 1.24727325881397566043062852259027e-01 6.49717196700759806390901296424545e-04
 	 2.33190171491815048665507958958187e-02 8.51953656969420936029280255752383e-01 6.49717196700759806390901296424545e-04
 	 8.51953656969420936029280255752383e-01 1.24727325881397566043062852259027e-01 6.49717196700759806390901296424545e-04
 	 8.51953656969420936029280255752383e-01 2.33190171491815048665507958958187e-02 6.49717196700759806390901296424545e-04
 	 3.11593245943279584242446844655205e-01 1.38713093959385580511423086136347e-01 2.02211589957075653714579921427230e-03
 	 3.11593245943279584242446844655205e-01 5.49693660097334890757281300466275e-01 2.02211589957075653714579921427230e-03
 	 1.38713093959385580511423086136347e-01 3.11593245943279584242446844655205e-01 2.02211589957075653714579921427230e-03
 	 1.38713093959385580511423086136347e-01 5.49693660097334890757281300466275e-01 2.02211589957075653714579921427230e-03
 	 5.49693660097334890757281300466275e-01 3.11593245943279584242446844655205e-01 2.02211589957075653714579921427230e-03
 	 5.49693660097334890757281300466275e-01 1.38713093959385580511423086136347e-01 2.02211589957075653714579921427230e-03
 	 1.10541441031880752210447838024265e-01 1.05406394081225263104073519571102e-02 4.32239553547260173249622283719873e-04
 	 1.10541441031880752210447838024265e-01 8.78917919559996652090205770946341e-01 4.32239553547260173249622283719873e-04
 	 1.05406394081225263104073519571102e-02 1.10541441031880752210447838024265e-01 4.32239553547260173249622283719873e-04
 	 1.05406394081225263104073519571102e-02 8.78917919559996652090205770946341e-01 4.32239553547260173249622283719873e-04
 	 8.78917919559996652090205770946341e-01 1.10541441031880752210447838024265e-01 4.32239553547260173249622283719873e-04
 	 8.78917919559996652090205770946341e-01 1.05406394081225263104073519571102e-02 4.32239553547260173249622283719873e-04
 	 2.97417196275917228298624195304001e-01 1.03472505675079231440838256617099e-02 6.32985718237871709465625080781592e-04
 	 2.97417196275917228298624195304001e-01 6.92235553156574812128098983521340e-01 6.32985718237871709465625080781592e-04
 	 1.03472505675079231440838256617099e-02 2.97417196275917228298624195304001e-01 6.32985718237871709465625080781592e-04
 	 1.03472505675079231440838256617099e-02 6.92235553156574812128098983521340e-01 6.32985718237871709465625080781592e-04
 	 6.92235553156574812128098983521340e-01 2.97417196275917228298624195304001e-01 6.32985718237871709465625080781592e-04
 	 6.92235553156574812128098983521340e-01 1.03472505675079231440838256617099e-02 6.32985718237871709465625080781592e-04
 	 2.94068058652278530029633429876412e-01 5.37818816587767034587130865475046e-02 1.37129429762075758132688907409147e-03
 	 2.94068058652278530029633429876412e-01 6.52150059688944683244926636689343e-01 1.37129429762075758132688907409147e-03
 	 5.37818816587767034587130865475046e-02 2.94068058652278530029633429876412e-01 1.37129429762075758132688907409147e-03
 	 5.37818816587767034587130865475046e-02 6.52150059688944683244926636689343e-01 1.37129429762075758132688907409147e-03
 	 6.52150059688944683244926636689343e-01 2.94068058652278530029633429876412e-01 1.37129429762075758132688907409147e-03
 	 6.52150059688944683244926636689343e-01 5.37818816587767034587130865475046e-02 1.37129429762075758132688907409147e-03
 	 1.11401217606310831698124275135342e-01 6.97603580204464307490397345645761e-02 1.05770377683287353405561237451593e-03
 	 1.11401217606310831698124275135342e-01 8.18838424373242723675048182485625e-01 1.05770377683287353405561237451593e-03
 	 6.97603580204464307490397345645761e-02 1.11401217606310831698124275135342e-01 1.05770377683287353405561237451593e-03
 	 6.97603580204464307490397345645761e-02 8.18838424373242723675048182485625e-01 1.05770377683287353405561237451593e-03
 	 8.18838424373242723675048182485625e-01 1.11401217606310831698124275135342e-01 1.05770377683287353405561237451593e-03
 	 8.18838424373242723675048182485625e-01 6.97603580204464307490397345645761e-02 1.05770377683287353405561237451593e-03
 	 4.43743453863629289113390541388071e-01 1.55023027792510516287283195424607e-02 8.11577263642843300429918773630789e-04
 	 4.43743453863629289113390541388071e-01 5.40754243357119634971752475394169e-01 8.11577263642843300429918773630789e-04
 	 1.55023027792510516287283195424607e-02 4.43743453863629289113390541388071e-01 8.11577263642843300429918773630789e-04
 	 1.55023027792510516287283195424607e-02 5.40754243357119634971752475394169e-01 8.11577263642843300429918773630789e-04
 	 5.40754243357119634971752475394169e-01 4.43743453863629289113390541388071e-01 8.11577263642843300429918773630789e-04
 	 5.40754243357119634971752475394169e-01 1.55023027792510516287283195424607e-02 8.11577263642843300429918773630789e-04
 	 3.67635711929402475561801111325622e-01 3.96225072588169413556613562832354e-02 1.27063686670264856977408118865469e-03
 	 3.67635711929402475561801111325622e-01 5.92741780811780527571386301133316e-01 1.27063686670264856977408118865469e-03
 	 3.96225072588169413556613562832354e-02 3.67635711929402475561801111325622e-01 1.27063686670264856977408118865469e-03
 	 3.96225072588169413556613562832354e-02 5.92741780811780527571386301133316e-01 1.27063686670264856977408118865469e-03
 	 5.92741780811780527571386301133316e-01 3.67635711929402475561801111325622e-01 1.27063686670264856977408118865469e-03
 	 5.92741780811780527571386301133316e-01 3.96225072588169413556613562832354e-02 1.27063686670264856977408118865469e-03
 	 4.83834188936242623468864110236609e-02 1.18107009236640553284658494703763e-02 3.11317736056086768765133188097138e-04
 	 4.83834188936242623468864110236609e-02 9.39805880182711605996814796526451e-01 3.11317736056086768765133188097138e-04
 	 1.18107009236640553284658494703763e-02 4.83834188936242623468864110236609e-02 3.11317736056086768765133188097138e-04
 	 1.18107009236640553284658494703763e-02 9.39805880182711605996814796526451e-01 3.11317736056086768765133188097138e-04
 	 9.39805880182711605996814796526451e-01 4.83834188936242623468864110236609e-02 3.11317736056086768765133188097138e-04
 	 9.39805880182711605996814796526451e-01 1.18107009236640553284658494703763e-02 3.11317736056086768765133188097138e-04
 	 4.26198546034848302355158011778258e-01 3.52878923463722377062978807771287e-02 1.32092018998813736860298284625514e-03
 	 4.26198546034848302355158011778258e-01 5.38513561618779501571907530887984e-01 1.32092018998813736860298284625514e-03
 	 3.52878923463722377062978807771287e-02 4.26198546034848302355158011778258e-01 1.32092018998813736860298284625514e-03
 	 3.52878923463722377062978807771287e-02 5.38513561618779501571907530887984e-01 1.32092018998813736860298284625514e-03
 	 5.38513561618779501571907530887984e-01 4.26198546034848302355158011778258e-01 1.32092018998813736860298284625514e-03
 	 5.38513561618779501571907530887984e-01 3.52878923463722377062978807771287e-02 1.32092018998813736860298284625514e-03
 	 3.46403707508342595389194684685208e-01 6.47150930019751435828823105111951e-02 1.63265855137869567853536878487830e-03
 	 3.46403707508342595389194684685208e-01 5.88881199489682316539074236061424e-01 1.63265855137869567853536878487830e-03
 	 6.47150930019751435828823105111951e-02 3.46403707508342595389194684685208e-01 1.63265855137869567853536878487830e-03
 	 6.47150930019751435828823105111951e-02 5.88881199489682316539074236061424e-01 1.63265855137869567853536878487830e-03
 	 5.88881199489682316539074236061424e-01 3.46403707508342595389194684685208e-01 1.63265855137869567853536878487830e-03
 	 5.88881199489682316539074236061424e-01 6.47150930019751435828823105111951e-02 1.63265855137869567853536878487830e-03
 	 7.61686440792014585188240971547202e-02 1.04225715676421054611822114566166e-02 3.82757292961209444771136789498200e-04
 	 7.61686440792014585188240971547202e-02 9.13408784353156422142205883574206e-01 3.82757292961209444771136789498200e-04
 	 1.04225715676421054611822114566166e-02 7.61686440792014585188240971547202e-02 3.82757292961209444771136789498200e-04
 	 1.04225715676421054611822114566166e-02 9.13408784353156422142205883574206e-01 3.82757292961209444771136789498200e-04
 	 9.13408784353156422142205883574206e-01 7.61686440792014585188240971547202e-02 3.82757292961209444771136789498200e-04
 	 9.13408784353156422142205883574206e-01 1.04225715676421054611822114566166e-02 3.82757292961209444771136789498200e-04
 	 3.19855805989206987138828708339133e-01 2.27104917530668970471197098959237e-01 2.58206804723576507573645777426918e-03
 	 3.19855805989206987138828708339133e-01 4.53039276480124097901125423959456e-01 2.58206804723576507573645777426918e-03
 	 2.27104917530668970471197098959237e-01 3.19855805989206987138828708339133e-01 2.58206804723576507573645777426918e-03
 	 2.27104917530668970471197098959237e-01 4.53039276480124097901125423959456e-01 2.58206804723576507573645777426918e-03
 	 4.53039276480124097901125423959456e-01 3.19855805989206987138828708339133e-01 2.58206804723576507573645777426918e-03
 	 4.53039276480124097901125423959456e-01 2.27104917530668970471197098959237e-01 2.58206804723576507573645777426918e-03
 	 1.14976749976327827229560796240548e-01 4.31548880805705872831801173106214e-02 9.27719490637918990996735324472411e-04
 	 1.14976749976327827229560796240548e-01 8.41868361943101661815092029428342e-01 9.27719490637918990996735324472411e-04
 	 4.31548880805705872831801173106214e-02 1.14976749976327827229560796240548e-01 9.27719490637918990996735324472411e-04
 	 4.31548880805705872831801173106214e-02 8.41868361943101661815092029428342e-01 9.27719490637918990996735324472411e-04
 	 8.41868361943101661815092029428342e-01 1.14976749976327827229560796240548e-01 9.27719490637918990996735324472411e-04
 	 8.41868361943101661815092029428342e-01 4.31548880805705872831801173106214e-02 9.27719490637918990996735324472411e-04
 	 1.55341187486334963985257218155311e-01 4.89749482183904280563346844701300e-02 1.13990500568115723546702700019750e-03
 	 1.55341187486334963985257218155311e-01 7.95683864295274601019514193467330e-01 1.13990500568115723546702700019750e-03
 	 4.89749482183904280563346844701300e-02 1.55341187486334963985257218155311e-01 1.13990500568115723546702700019750e-03
 	 4.89749482183904280563346844701300e-02 7.95683864295274601019514193467330e-01 1.13990500568115723546702700019750e-03
 	 7.95683864295274601019514193467330e-01 1.55341187486334963985257218155311e-01 1.13990500568115723546702700019750e-03
 	 7.95683864295274601019514193467330e-01 4.89749482183904280563346844701300e-02 1.13990500568115723546702700019750e-03
 	 1.53664139478065231436687554378295e-01 9.45454884202667593384727950933666e-03 5.13397308598045627042738558998280e-04
 	 1.53664139478065231436687554378295e-01 8.36881311679908090894741690135561e-01 5.13397308598045627042738558998280e-04
 	 9.45454884202667593384727950933666e-03 1.53664139478065231436687554378295e-01 5.13397308598045627042738558998280e-04
 	 9.45454884202667593384727950933666e-03 8.36881311679908090894741690135561e-01 5.13397308598045627042738558998280e-04
 	 8.36881311679908090894741690135561e-01 1.53664139478065231436687554378295e-01 5.13397308598045627042738558998280e-04
 	 8.36881311679908090894741690135561e-01 9.45454884202667593384727950933666e-03 5.13397308598045627042738558998280e-04
 	 7.98538207718234027687742582202191e-02 1.89430587911264334925742769399903e-03 1.66421560563311383930049092150227e-04
 	 7.98538207718234027687742582202191e-02 9.18251873349063996165853041020455e-01 1.66421560563311383930049092150227e-04
 	 1.89430587911264334925742769399903e-03 7.98538207718234027687742582202191e-02 1.66421560563311383930049092150227e-04
 	 1.89430587911264334925742769399903e-03 9.18251873349063996165853041020455e-01 1.66421560563311383930049092150227e-04
 	 9.18251873349063996165853041020455e-01 7.98538207718234027687742582202191e-02 1.66421560563311383930049092150227e-04
 	 9.18251873349063996165853041020455e-01 1.89430587911264334925742769399903e-03 1.66421560563311383930049092150227e-04
 	 1.97860112128548371046576903609093e-01 1.20283224036929169142862150465589e-02 6.07874655725859571082925203455716e-04
 	 1.97860112128548371046576903609093e-01 7.90111565467758736325265545019647e-01 6.07874655725859571082925203455716e-04
 	 1.20283224036929169142862150465589e-02 1.97860112128548371046576903609093e-01 6.07874655725859571082925203455716e-04
 	 1.20283224036929169142862150465589e-02 7.90111565467758736325265545019647e-01 6.07874655725859571082925203455716e-04
 	 7.90111565467758736325265545019647e-01 1.97860112128548371046576903609093e-01 6.07874655725859571082925203455716e-04
 	 7.90111565467758736325265545019647e-01 1.20283224036929169142862150465589e-02 6.07874655725859571082925203455716e-04
 	 3.16915380380781819269486732082441e-01 1.90446777793631645894767423499161e-03 2.94655786447839092897366120027414e-04
 	 3.16915380380781819269486732082441e-01 6.81180151841281888991375126352068e-01 2.94655786447839092897366120027414e-04
 	 1.90446777793631645894767423499161e-03 3.16915380380781819269486732082441e-01 2.94655786447839092897366120027414e-04
 	 1.90446777793631645894767423499161e-03 6.81180151841281888991375126352068e-01 2.94655786447839092897366120027414e-04
 	 6.81180151841281888991375126352068e-01 3.16915380380781819269486732082441e-01 2.94655786447839092897366120027414e-04
 	 6.81180151841281888991375126352068e-01 1.90446777793631645894767423499161e-03 2.94655786447839092897366120027414e-04
 	 1.64563977163413477367015502750291e-01 2.62052237923564648736096671655105e-02 8.67132902247431448274073151338825e-04
 	 1.64563977163413477367015502750291e-01 8.09230799044230009187117502733599e-01 8.67132902247431448274073151338825e-04
 	 2.62052237923564648736096671655105e-02 1.64563977163413477367015502750291e-01 8.67132902247431448274073151338825e-04
 	 2.62052237923564648736096671655105e-02 8.09230799044230009187117502733599e-01 8.67132902247431448274073151338825e-04
 	 8.09230799044230009187117502733599e-01 1.64563977163413477367015502750291e-01 8.67132902247431448274073151338825e-04
 	 8.09230799044230009187117502733599e-01 2.62052237923564648736096671655105e-02 8.67132902247431448274073151338825e-04
 	 3.61129835979937918732929347243044e-01 9.44709215240264049695539938511502e-02 2.02493753788023263251449890276490e-03
 	 3.61129835979937918732929347243044e-01 5.44399242496035662419728851091349e-01 2.02493753788023263251449890276490e-03
 	 9.44709215240264049695539938511502e-02 3.61129835979937918732929347243044e-01 2.02493753788023263251449890276490e-03
 	 9.44709215240264049695539938511502e-02 5.44399242496035662419728851091349e-01 2.02493753788023263251449890276490e-03
 	 5.44399242496035662419728851091349e-01 3.61129835979937918732929347243044e-01 2.02493753788023263251449890276490e-03
 	 5.44399242496035662419728851091349e-01 9.44709215240264049695539938511502e-02 2.02493753788023263251449890276490e-03
 	 4.19825977454229393170948014812893e-01 9.63233490337837422456956915084447e-02 2.13711614885642468483761824415978e-03
 	 4.19825977454229393170948014812893e-01 4.83850673511986795194417254606378e-01 2.13711614885642468483761824415978e-03
 	 9.63233490337837422456956915084447e-02 4.19825977454229393170948014812893e-01 2.13711614885642468483761824415978e-03
 	 9.63233490337837422456956915084447e-02 4.83850673511986795194417254606378e-01 2.13711614885642468483761824415978e-03
 	 4.83850673511986795194417254606378e-01 4.19825977454229393170948014812893e-01 2.13711614885642468483761824415978e-03
 	 4.83850673511986795194417254606378e-01 9.63233490337837422456956915084447e-02 2.13711614885642468483761824415978e-03
 	 2.43175224574663090271187115831708e-01 5.34903172634274073904414592561807e-02 1.41675427379012392262169761636414e-03
 	 2.43175224574663090271187115831708e-01 7.03334458161909426010538481932599e-01 1.41675427379012392262169761636414e-03
 	 5.34903172634274073904414592561807e-02 2.43175224574663090271187115831708e-01 1.41675427379012392262169761636414e-03
 	 5.34903172634274073904414592561807e-02 7.03334458161909426010538481932599e-01 1.41675427379012392262169761636414e-03
 	 7.03334458161909426010538481932599e-01 2.43175224574663090271187115831708e-01 1.41675427379012392262169761636414e-03
 	 7.03334458161909426010538481932599e-01 5.34903172634274073904414592561807e-02 1.41675427379012392262169761636414e-03
 	 1.45983223113643451052112709476205e-01 7.95244786008371812302542025463481e-02 1.37190627294187265580727164149266e-03
 	 1.45983223113643451052112709476205e-01 7.74492298285519353839845280162990e-01 1.37190627294187265580727164149266e-03
 	 7.95244786008371812302542025463481e-02 1.45983223113643451052112709476205e-01 1.37190627294187265580727164149266e-03
 	 7.95244786008371812302542025463481e-02 7.74492298285519353839845280162990e-01 1.37190627294187265580727164149266e-03
 	 7.74492298285519353839845280162990e-01 1.45983223113643451052112709476205e-01 1.37190627294187265580727164149266e-03
 	 7.74492298285519353839845280162990e-01 7.95244786008371812302542025463481e-02 1.37190627294187265580727164149266e-03
 	 2.72392832679802729400897476352839e-02 1.10307547814719290879548196926407e-02 2.36510728177526303485367353829361e-04
 	 2.72392832679802729400897476352839e-02 9.61729961950547718174675537738949e-01 2.36510728177526303485367353829361e-04
 	 1.10307547814719290879548196926407e-02 2.72392832679802729400897476352839e-02 2.36510728177526303485367353829361e-04
 	 1.10307547814719290879548196926407e-02 9.61729961950547718174675537738949e-01 2.36510728177526303485367353829361e-04
 	 9.61729961950547718174675537738949e-01 2.72392832679802729400897476352839e-02 2.36510728177526303485367353829361e-04
 	 9.61729961950547718174675537738949e-01 1.10307547814719290879548196926407e-02 2.36510728177526303485367353829361e-04
 	 2.45313708964778415255736376821005e-01 1.21862329639788515706078086964226e-02 6.86658872080503661014527772010752e-04
 	 2.45313708964778415255736376821005e-01 7.42500058071242752255614050227450e-01 6.86658872080503661014527772010752e-04
 	 1.21862329639788515706078086964226e-02 2.45313708964778415255736376821005e-01 6.86658872080503661014527772010752e-04
 	 1.21862329639788515706078086964226e-02 7.42500058071242752255614050227450e-01 6.86658872080503661014527772010752e-04
 	 7.42500058071242752255614050227450e-01 2.45313708964778415255736376821005e-01 6.86658872080503661014527772010752e-04
 	 7.42500058071242752255614050227450e-01 1.21862329639788515706078086964226e-02 6.86658872080503661014527772010752e-04
 	 1.16554219073452897115217297141498e-01 2.11321826247760956654642150454038e-03 2.11650495730307140404558019497472e-04
 	 1.16554219073452897115217297141498e-01 8.81332562664069563140856189420447e-01 2.11650495730307140404558019497472e-04
 	 2.11321826247760956654642150454038e-03 1.16554219073452897115217297141498e-01 2.11650495730307140404558019497472e-04
 	 2.11321826247760956654642150454038e-03 8.81332562664069563140856189420447e-01 2.11650495730307140404558019497472e-04
 	 8.81332562664069563140856189420447e-01 1.16554219073452897115217297141498e-01 2.11650495730307140404558019497472e-04
 	 8.81332562664069563140856189420447e-01 2.11321826247760956654642150454038e-03 2.11650495730307140404558019497472e-04
 	 5.35856828700446083391106810722704e-02 2.72189906580712175088176962844955e-02 5.33230593581922643862947008841502e-04
 	 5.35856828700446083391106810722704e-02 9.19195326471884177621518574596848e-01 5.33230593581922643862947008841502e-04
 	 2.72189906580712175088176962844955e-02 5.35856828700446083391106810722704e-02 5.33230593581922643862947008841502e-04
 	 2.72189906580712175088176962844955e-02 9.19195326471884177621518574596848e-01 5.33230593581922643862947008841502e-04
 	 9.19195326471884177621518574596848e-01 5.35856828700446083391106810722704e-02 5.33230593581922643862947008841502e-04
 	 9.19195326471884177621518574596848e-01 2.72189906580712175088176962844955e-02 5.33230593581922643862947008841502e-04
 	 8.51355181500168534114436624804512e-02 2.62562590124720725281992628197258e-02 6.91200536655852348054407396915622e-04
 	 8.51355181500168534114436624804512e-02 8.88608222837511063652016218838980e-01 6.91200536655852348054407396915622e-04
 	 2.62562590124720725281992628197258e-02 8.51355181500168534114436624804512e-02 6.91200536655852348054407396915622e-04
 	 2.62562590124720725281992628197258e-02 8.88608222837511063652016218838980e-01 6.91200536655852348054407396915622e-04
 	 8.88608222837511063652016218838980e-01 8.51355181500168534114436624804512e-02 6.91200536655852348054407396915622e-04
 	 8.88608222837511063652016218838980e-01 2.62562590124720725281992628197258e-02 6.91200536655852348054407396915622e-04
 	 4.08492625785633056700874021771597e-01 6.24750974503704217810629018003965e-02 1.82925589651349810443869969844854e-03
 	 4.08492625785633056700874021771597e-01 5.29032276763996556212532595964149e-01 1.82925589651349810443869969844854e-03
 	 6.24750974503704217810629018003965e-02 4.08492625785633056700874021771597e-01 1.82925589651349810443869969844854e-03
 	 6.24750974503704217810629018003965e-02 5.29032276763996556212532595964149e-01 1.82925589651349810443869969844854e-03
 	 5.29032276763996556212532595964149e-01 4.08492625785633056700874021771597e-01 1.82925589651349810443869969844854e-03
 	 5.29032276763996556212532595964149e-01 6.24750974503704217810629018003965e-02 1.82925589651349810443869969844854e-03
 	 3.82251045094813779456899283104576e-01 1.73776209876193493686358237937384e-01 2.60500242743329267838814367053146e-03
 	 3.82251045094813779456899283104576e-01 4.43972745028992754612318094586954e-01 2.60500242743329267838814367053146e-03
 	 1.73776209876193493686358237937384e-01 3.82251045094813779456899283104576e-01 2.60500242743329267838814367053146e-03
 	 1.73776209876193493686358237937384e-01 4.43972745028992754612318094586954e-01 2.60500242743329267838814367053146e-03
 	 4.43972745028992754612318094586954e-01 3.82251045094813779456899283104576e-01 2.60500242743329267838814367053146e-03
 	 4.43972745028992754612318094586954e-01 1.73776209876193493686358237937384e-01 2.60500242743329267838814367053146e-03
 	 2.59740322065890247293928894123383e-02 2.04912604306957185293369683165565e-03 1.03655280295382562732835196595005e-04
 	 2.59740322065890247293928894123383e-02 9.71976841750341380432587357063312e-01 1.03655280295382562732835196595005e-04
 	 2.04912604306957185293369683165565e-03 2.59740322065890247293928894123383e-02 1.03655280295382562732835196595005e-04
 	 2.04912604306957185293369683165565e-03 9.71976841750341380432587357063312e-01 1.03655280295382562732835196595005e-04
 	 9.71976841750341380432587357063312e-01 2.59740322065890247293928894123383e-02 1.03655280295382562732835196595005e-04
 	 9.71976841750341380432587357063312e-01 2.04912604306957185293369683165565e-03 1.03655280295382562732835196595005e-04
 	 3.85689188760064305405705908924574e-01 1.88900416615420362054234004745012e-02 9.79158143431579485599369760961963e-04
 	 3.85689188760064305405705908924574e-01 5.95420769578393627163848123018397e-01 9.79158143431579485599369760961963e-04
 	 1.88900416615420362054234004745012e-02 3.85689188760064305405705908924574e-01 9.79158143431579485599369760961963e-04
 	 1.88900416615420362054234004745012e-02 5.95420769578393627163848123018397e-01 9.79158143431579485599369760961963e-04
 	 5.95420769578393627163848123018397e-01 3.85689188760064305405705908924574e-01 9.79158143431579485599369760961963e-04
 	 5.95420769578393627163848123018397e-01 1.88900416615420362054234004745012e-02 9.79158143431579485599369760961963e-04
 	 1.90746479431403104243258894712199e-01 8.26189529456984456112778048009204e-02 1.60446126495938120974649176986304e-03
 	 1.90746479431403104243258894712199e-01 7.26634567622898464023251108301338e-01 1.60446126495938120974649176986304e-03
 	 8.26189529456984456112778048009204e-02 1.90746479431403104243258894712199e-01 1.60446126495938120974649176986304e-03
 	 8.26189529456984456112778048009204e-02 7.26634567622898464023251108301338e-01 1.60446126495938120974649176986304e-03
 	 7.26634567622898464023251108301338e-01 1.90746479431403104243258894712199e-01 1.60446126495938120974649176986304e-03
 	 7.26634567622898464023251108301338e-01 8.26189529456984456112778048009204e-02 1.60446126495938120974649176986304e-03
 	 4.93146516048518085417740053344460e-02 2.27995678675310979241497300051833e-03 1.57207577306592641286364653296914e-04
 	 4.93146516048518085417740053344460e-02 9.48405391608395098579364912438905e-01 1.57207577306592641286364653296914e-04
 	 2.27995678675310979241497300051833e-03 4.93146516048518085417740053344460e-02 1.57207577306592641286364653296914e-04
 	 2.27995678675310979241497300051833e-03 9.48405391608395098579364912438905e-01 1.57207577306592641286364653296914e-04
 	 9.48405391608395098579364912438905e-01 4.93146516048518085417740053344460e-02 1.57207577306592641286364653296914e-04
 	 9.48405391608395098579364912438905e-01 2.27995678675310979241497300051833e-03 1.57207577306592641286364653296914e-04
 	 4.26482545498046594634189432326821e-01 4.77225212030264397955470201395656e-03 5.39257277560205414319860484084757e-04
 	 4.26482545498046594634189432326821e-01 5.68745202381650827305747952777892e-01 5.39257277560205414319860484084757e-04
 	 4.77225212030264397955470201395656e-03 4.26482545498046594634189432326821e-01 5.39257277560205414319860484084757e-04
 	 4.77225212030264397955470201395656e-03 5.68745202381650827305747952777892e-01 5.39257277560205414319860484084757e-04
 	 5.68745202381650827305747952777892e-01 4.26482545498046594634189432326821e-01 5.39257277560205414319860484084757e-04
 	 5.68745202381650827305747952777892e-01 4.77225212030264397955470201395656e-03 5.39257277560205414319860484084757e-04
 	 1.51364752670565094749832724119187e-01 1.16202356411588061946282834924205e-01 1.80021348830760805070916319436947e-03
 	 1.51364752670565094749832724119187e-01 7.32432890917846912692823480028892e-01 1.80021348830760805070916319436947e-03
 	 1.16202356411588061946282834924205e-01 1.51364752670565094749832724119187e-01 1.80021348830760805070916319436947e-03
 	 1.16202356411588061946282834924205e-01 7.32432890917846912692823480028892e-01 1.80021348830760805070916319436947e-03
 	 7.32432890917846912692823480028892e-01 1.51364752670565094749832724119187e-01 1.80021348830760805070916319436947e-03
 	 7.32432890917846912692823480028892e-01 1.16202356411588061946282834924205e-01 1.80021348830760805070916319436947e-03
 	 2.41085560390986441969829456866137e-01 8.55252642423670605964503010909539e-02 1.83059570892130899118221964982922e-03
 	 2.41085560390986441969829456866137e-01 6.73389175366646441922569010785082e-01 1.83059570892130899118221964982922e-03
 	 8.55252642423670605964503010909539e-02 2.41085560390986441969829456866137e-01 1.83059570892130899118221964982922e-03
 	 8.55252642423670605964503010909539e-02 6.73389175366646441922569010785082e-01 1.83059570892130899118221964982922e-03
 	 6.73389175366646441922569010785082e-01 2.41085560390986441969829456866137e-01 1.83059570892130899118221964982922e-03
 	 6.73389175366646441922569010785082e-01 8.55252642423670605964503010909539e-02 1.83059570892130899118221964982922e-03
 	 2.12036211205479691033204403538548e-01 2.97767883228066514156306965332988e-02 1.08085615693754135205328914537404e-03
 	 2.12036211205479691033204403538548e-01 7.58187000471713723470656987046823e-01 1.08085615693754135205328914537404e-03
 	 2.97767883228066514156306965332988e-02 2.12036211205479691033204403538548e-01 1.08085615693754135205328914537404e-03
 	 2.97767883228066514156306965332988e-02 7.58187000471713723470656987046823e-01 1.08085615693754135205328914537404e-03
 	 7.58187000471713723470656987046823e-01 2.12036211205479691033204403538548e-01 1.08085615693754135205328914537404e-03
 	 7.58187000471713723470656987046823e-01 2.97767883228066514156306965332988e-02 1.08085615693754135205328914537404e-03
 	 7.73420280842538471199887339935231e-02 5.02535370358713970317943164900498e-02 9.00528138193089941303248746606869e-04
 	 7.73420280842538471199887339935231e-02 8.72404434879874735031535237794742e-01 9.00528138193089941303248746606869e-04
 	 5.02535370358713970317943164900498e-02 7.73420280842538471199887339935231e-02 9.00528138193089941303248746606869e-04
 	 5.02535370358713970317943164900498e-02 8.72404434879874735031535237794742e-01 9.00528138193089941303248746606869e-04
 	 8.72404434879874735031535237794742e-01 7.73420280842538471199887339935231e-02 9.00528138193089941303248746606869e-04
 	 8.72404434879874735031535237794742e-01 5.02535370358713970317943164900498e-02 9.00528138193089941303248746606869e-04
 	 2.65927023654531302643277967945323e-01 2.16300207102354397070698155403079e-01 2.72377964713794214896003254011703e-03
 	 2.65927023654531302643277967945323e-01 5.17772769243114328041599492280511e-01 2.72377964713794214896003254011703e-03
 	 2.16300207102354397070698155403079e-01 2.65927023654531302643277967945323e-01 2.72377964713794214896003254011703e-03
 	 2.16300207102354397070698155403079e-01 5.17772769243114328041599492280511e-01 2.72377964713794214896003254011703e-03
 	 5.17772769243114328041599492280511e-01 2.65927023654531302643277967945323e-01 2.72377964713794214896003254011703e-03
 	 5.17772769243114328041599492280511e-01 2.16300207102354397070698155403079e-01 2.72377964713794214896003254011703e-03
 	 1.02781124040352035697853949614000e-02 2.31820768447709487508623382723272e-03 6.98926007621862555550806828108534e-05
 	 1.02781124040352035697853949614000e-02 9.87403679911487697218319681269350e-01 6.98926007621862555550806828108534e-05
 	 2.31820768447709487508623382723272e-03 1.02781124040352035697853949614000e-02 6.98926007621862555550806828108534e-05
 	 2.31820768447709487508623382723272e-03 9.87403679911487697218319681269350e-01 6.98926007621862555550806828108534e-05
 	 9.87403679911487697218319681269350e-01 1.02781124040352035697853949614000e-02 6.98926007621862555550806828108534e-05
 	 9.87403679911487697218319681269350e-01 2.31820768447709487508623382723272e-03 6.98926007621862555550806828108534e-05
 	 3.63748680489815068295200717329863e-01 6.43018778976174251726938280171453e-03 5.98100592597651135526315435697597e-04
 	 3.63748680489815068295200717329863e-01 6.29821131720423088573568293213611e-01 5.98100592597651135526315435697597e-04
 	 6.43018778976174251726938280171453e-03 3.63748680489815068295200717329863e-01 5.98100592597651135526315435697597e-04
 	 6.43018778976174251726938280171453e-03 6.29821131720423088573568293213611e-01 5.98100592597651135526315435697597e-04
 	 6.29821131720423088573568293213611e-01 3.63748680489815068295200717329863e-01 5.98100592597651135526315435697597e-04
 	 6.29821131720423088573568293213611e-01 6.43018778976174251726938280171453e-03 5.98100592597651135526315435697597e-04
 	 3.69820205106713650877736654365435e-01 1.33111115065471463658752782066585e-01 2.47628291179179289838163668946436e-03
 	 3.69820205106713650877736654365435e-01 4.97068679827814885463510563567979e-01 2.47628291179179289838163668946436e-03
 	 1.33111115065471463658752782066585e-01 3.69820205106713650877736654365435e-01 2.47628291179179289838163668946436e-03
 	 1.33111115065471463658752782066585e-01 4.97068679827814885463510563567979e-01 2.47628291179179289838163668946436e-03
 	 4.97068679827814885463510563567979e-01 3.69820205106713650877736654365435e-01 2.47628291179179289838163668946436e-03
 	 4.97068679827814885463510563567979e-01 1.33111115065471463658752782066585e-01 2.47628291179179289838163668946436e-03
 	 2.62236855625541442904591349360999e-01 1.68252485371562954252766530771623e-01 2.52760293694821334617439667624694e-03
 	 2.62236855625541442904591349360999e-01 5.69510659002895547331490888609551e-01 2.52760293694821334617439667624694e-03
 	 1.68252485371562954252766530771623e-01 2.62236855625541442904591349360999e-01 2.52760293694821334617439667624694e-03
 	 1.68252485371562954252766530771623e-01 5.69510659002895547331490888609551e-01 2.52760293694821334617439667624694e-03
 	 5.69510659002895547331490888609551e-01 2.62236855625541442904591349360999e-01 2.52760293694821334617439667624694e-03
 	 5.69510659002895547331490888609551e-01 1.68252485371562954252766530771623e-01 2.52760293694821334617439667624694e-03
 	 2.05865274198998832178020279570774e-01 2.37764370084020187565143622521191e-03 3.02795530949603256942043172372792e-04
 	 2.05865274198998832178020279570774e-01 7.91757082100161047044650786119746e-01 3.02795530949603256942043172372792e-04
 	 2.37764370084020187565143622521191e-03 2.05865274198998832178020279570774e-01 3.02795530949603256942043172372792e-04
 	 2.37764370084020187565143622521191e-03 7.91757082100161047044650786119746e-01 3.02795530949603256942043172372792e-04
 	 7.91757082100161047044650786119746e-01 2.05865274198998832178020279570774e-01 3.02795530949603256942043172372792e-04
 	 7.91757082100161047044650786119746e-01 2.37764370084020187565143622521191e-03 3.02795530949603256942043172372792e-04
 	 3.21061299239171094033196141026565e-01 1.79275176914734907240855932286649e-01 2.67889510546186161363269029322964e-03
 	 3.21061299239171094033196141026565e-01 4.99663523846094026481523542315699e-01 2.67889510546186161363269029322964e-03
 	 1.79275176914734907240855932286649e-01 3.21061299239171094033196141026565e-01 2.67889510546186161363269029322964e-03
 	 1.79275176914734907240855932286649e-01 4.99663523846094026481523542315699e-01 2.67889510546186161363269029322964e-03
 	 4.99663523846094026481523542315699e-01 3.21061299239171094033196141026565e-01 2.67889510546186161363269029322964e-03
 	 4.99663523846094026481523542315699e-01 1.79275176914734907240855932286649e-01 2.67889510546186161363269029322964e-03
 	 2.67008925352811121722851339654881e-01 2.84633516120191137899197997285228e-02 1.18276761225013507181080818497776e-03
 	 2.67008925352811121722851339654881e-01 7.04527723035169750609441052802140e-01 1.18276761225013507181080818497776e-03
 	 2.84633516120191137899197997285228e-02 2.67008925352811121722851339654881e-01 1.18276761225013507181080818497776e-03
 	 2.84633516120191137899197997285228e-02 7.04527723035169750609441052802140e-01 1.18276761225013507181080818497776e-03
 	 7.04527723035169750609441052802140e-01 2.67008925352811121722851339654881e-01 1.18276761225013507181080818497776e-03
 	 7.04527723035169750609441052802140e-01 2.84633516120191137899197997285228e-02 1.18276761225013507181080818497776e-03
 	 2.58604541010351018925916832813527e-01 2.22646709189586958915763048594272e-03 3.18088027822488136377165890422702e-04
 	 2.58604541010351018925916832813527e-01 7.39168991897753091535605562967248e-01 3.18088027822488136377165890422702e-04
 	 2.22646709189586958915763048594272e-03 2.58604541010351018925916832813527e-01 3.18088027822488136377165890422702e-04
 	 2.22646709189586958915763048594272e-03 7.39168991897753091535605562967248e-01 3.18088027822488136377165890422702e-04
 	 7.39168991897753091535605562967248e-01 2.58604541010351018925916832813527e-01 3.18088027822488136377165890422702e-04
 	 7.39168991897753091535605562967248e-01 2.22646709189586958915763048594272e-03 3.18088027822488136377165890422702e-04
 	 1.99624762677360428897443966889114e-01 1.20364369572249552131637528873398e-01 2.05838971587918350206192208418088e-03
 	 1.99624762677360428897443966889114e-01 6.80010867750389991215342888608575e-01 2.05838971587918350206192208418088e-03
 	 1.20364369572249552131637528873398e-01 1.99624762677360428897443966889114e-01 2.05838971587918350206192208418088e-03
 	 1.20364369572249552131637528873398e-01 6.80010867750389991215342888608575e-01 2.05838971587918350206192208418088e-03
 	 6.80010867750389991215342888608575e-01 1.99624762677360428897443966889114e-01 2.05838971587918350206192208418088e-03
 	 6.80010867750389991215342888608575e-01 1.20364369572249552131637528873398e-01 2.05838971587918350206192208418088e-03
 	 2.08890864384406460541043770717806e-01 1.64334461686715643802259023686929e-01 2.37178308508622943256982651405451e-03
 	 2.08890864384406460541043770717806e-01 6.26774673928877867901121589966351e-01 2.37178308508622943256982651405451e-03
 	 1.64334461686715643802259023686929e-01 2.08890864384406460541043770717806e-01 2.37178308508622943256982651405451e-03
 	 1.64334461686715643802259023686929e-01 6.26774673928877867901121589966351e-01 2.37178308508622943256982651405451e-03
 	 6.26774673928877867901121589966351e-01 2.08890864384406460541043770717806e-01 2.37178308508622943256982651405451e-03
 	 6.26774673928877867901121589966351e-01 1.64334461686715643802259023686929e-01 2.37178308508622943256982651405451e-03
 	 2.53333600601808928143299226576346e-01 1.23887458837676739387134716707806e-01 2.30113371257409425954532089519944e-03
 	 2.53333600601808928143299226576346e-01 6.22778940560514304713990441086935e-01 2.30113371257409425954532089519944e-03
 	 1.23887458837676739387134716707806e-01 2.53333600601808928143299226576346e-01 2.30113371257409425954532089519944e-03
 	 1.23887458837676739387134716707806e-01 6.22778940560514304713990441086935e-01 2.30113371257409425954532089519944e-03
 	 6.22778940560514304713990441086935e-01 2.53333600601808928143299226576346e-01 2.30113371257409425954532089519944e-03
 	 6.22778940560514304713990441086935e-01 1.23887458837676739387134716707806e-01 2.30113371257409425954532089519944e-03
 	 4.63796122746566341632501462299842e-01 1.60010389384323214144456581919940e-04 1.17504461240287803587382942094308e-04
 	 4.63796122746566341632501462299842e-01 5.36043866864049367570999038434820e-01 1.17504461240287803587382942094308e-04
 	 1.60010389384323214144456581919940e-04 4.63796122746566341632501462299842e-01 1.17504461240287803587382942094308e-04
 	 1.60010389384323214144456581919940e-04 5.36043866864049367570999038434820e-01 1.17504461240287803587382942094308e-04
 	 5.36043866864049367570999038434820e-01 4.63796122746566341632501462299842e-01 1.17504461240287803587382942094308e-04
 	 5.36043866864049367570999038434820e-01 1.60010389384323214144456581919940e-04 1.17504461240287803587382942094308e-04
 	 3.83717799050546426453678350299015e-01 1.08509201743662683412559866180658e-04 1.19936839465554535844038497316433e-04
 	 3.83717799050546426453678350299015e-01 6.16173691747709861843418366333935e-01 1.19936839465554535844038497316433e-04
 	 1.08509201743662683412559866180658e-04 3.83717799050546426453678350299015e-01 1.19936839465554535844038497316433e-04
 	 1.08509201743662683412559866180658e-04 6.16173691747709861843418366333935e-01 1.19936839465554535844038497316433e-04
 	 6.16173691747709861843418366333935e-01 3.83717799050546426453678350299015e-01 1.19936839465554535844038497316433e-04
 	 6.16173691747709861843418366333935e-01 1.08509201743662683412559866180658e-04 1.19936839465554535844038497316433e-04
 	 ];
 
 	 case  49 

 	 % ALG. DEG.:   49
 	 % PTS CARD.:  435
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw=[
 	 1.78373016229631531359700602479279e-01 1.78373016229631531359700602479279e-01 1.61493883722624081630825365607507e-03
 	 1.78373016229631531359700602479279e-01 6.43253967540736937280598795041442e-01 1.61493883722624081630825365607507e-03
 	 6.43253967540736937280598795041442e-01 1.78373016229631531359700602479279e-01 1.61493883722624081630825365607507e-03
 	 7.28406536060113435349094856974261e-02 7.28406536060113435349094856974261e-02 7.89545893009189385727819576743514e-04
 	 7.28406536060113435349094856974261e-02 8.54318692787977340685756644234061e-01 7.89545893009189385727819576743514e-04
 	 8.54318692787977340685756644234061e-01 7.28406536060113435349094856974261e-02 7.89545893009189385727819576743514e-04
 	 4.28988355639407015207353879304719e-01 4.28988355639407015207353879304719e-01 1.96545273941011594542871421253949e-03
 	 4.28988355639407015207353879304719e-01 1.42023288721185969585292241390562e-01 1.96545273941011594542871421253949e-03
 	 1.42023288721185969585292241390562e-01 4.28988355639407015207353879304719e-01 1.96545273941011594542871421253949e-03
 	 3.81168837845570263045402725765598e-01 3.81168837845570263045402725765598e-01 2.49792961248307800528611899437692e-03
 	 3.81168837845570263045402725765598e-01 2.37662324308859473909194548468804e-01 2.49792961248307800528611899437692e-03
 	 2.37662324308859473909194548468804e-01 3.81168837845570263045402725765598e-01 2.49792961248307800528611899437692e-03
 	 2.00738367597118549934265274714562e-01 2.00738367597118549934265274714562e-01 2.03895945143986153172410702438810e-03
 	 2.00738367597118549934265274714562e-01 5.98523264805762900131469450570876e-01 2.03895945143986153172410702438810e-03
 	 5.98523264805762900131469450570876e-01 2.00738367597118549934265274714562e-01 2.03895945143986153172410702438810e-03
 	 4.62782231758690903999919896705251e-02 4.62782231758690903999919896705251e-02 5.85893274137245004783147717120073e-04
 	 4.62782231758690903999919896705251e-02 9.07443553648261791444440405030036e-01 5.85893274137245004783147717120073e-04
 	 9.07443553648261791444440405030036e-01 4.62782231758690903999919896705251e-02 5.85893274137245004783147717120073e-04
 	 2.97143088863247917252863317116862e-01 2.97143088863247917252863317116862e-01 2.54202687899601894802592561006804e-03
 	 2.97143088863247917252863317116862e-01 4.05713822273504165494273365766276e-01 2.54202687899601894802592561006804e-03
 	 4.05713822273504165494273365766276e-01 2.97143088863247917252863317116862e-01 2.54202687899601894802592561006804e-03
 	 1.08421217690070140204916526727175e-02 1.08421217690070140204916526727175e-02 1.45496719895626378015254798192757e-04
 	 1.08421217690070140204916526727175e-02 9.78315756461985985836804502469022e-01 1.45496719895626378015254798192757e-04
 	 9.78315756461985985836804502469022e-01 1.08421217690070140204916526727175e-02 1.45496719895626378015254798192757e-04
 	 1.02853381663129031520220735274052e-01 1.02853381663129031520220735274052e-01 1.23399131936961087285808957858535e-03
 	 1.02853381663129031520220735274052e-01 7.94293236673741964715134145080810e-01 1.23399131936961087285808957858535e-03
 	 7.94293236673741964715134145080810e-01 1.02853381663129031520220735274052e-01 1.23399131936961087285808957858535e-03
 	 4.84173563416694874295131967301131e-01 4.84173563416694874295131967301131e-01 1.22377744593757582271253969707914e-03
 	 4.84173563416694874295131967301131e-01 3.16528731666102514097360653977375e-02 1.22377744593757582271253969707914e-03
 	 3.16528731666102514097360653977375e-02 4.84173563416694874295131967301131e-01 1.22377744593757582271253969707914e-03
 	 4.93261195566052690342218056684942e-01 4.93261195566052690342218056684942e-01 8.41735588392921113901068430607211e-04
 	 4.93261195566052690342218056684942e-01 1.34776088678946193155638866301160e-02 8.41735588392921113901068430607211e-04
 	 1.34776088678946193155638866301160e-02 4.93261195566052690342218056684942e-01 8.41735588392921113901068430607211e-04
 	 4.05732471975522424045834668504540e-01 4.05732471975522424045834668504540e-01 2.68271127030139796762475690172778e-03
 	 4.05732471975522424045834668504540e-01 1.88535056048955151908330662990920e-01 2.68271127030139796762475690172778e-03
 	 1.88535056048955151908330662990920e-01 4.05732471975522424045834668504540e-01 2.68271127030139796762475690172778e-03
 	 1.30421644925131446912658361725335e-01 1.30421644925131446912658361725335e-01 1.74963401588083019948249852149047e-03
 	 1.30421644925131446912658361725335e-01 7.39156710149737161685834507807158e-01 1.74963401588083019948249852149047e-03
 	 7.39156710149737161685834507807158e-01 1.30421644925131446912658361725335e-01 1.74963401588083019948249852149047e-03
 	 4.61434805630296263068146345176501e-01 4.61434805630296263068146345176501e-01 1.98000989575437390949330662692773e-03
 	 4.61434805630296263068146345176501e-01 7.71303887394074738637073096469976e-02 1.98000989575437390949330662692773e-03
 	 7.71303887394074738637073096469976e-02 4.61434805630296263068146345176501e-01 1.98000989575437390949330662692773e-03
 	 2.75739602431112201808005579550809e-02 2.75739602431112201808005579550809e-02 4.15975444451907095701204131188433e-04
 	 2.75739602431112201808005579550809e-02 9.44852079513777587393974499718752e-01 4.15975444451907095701204131188433e-04
 	 9.44852079513777587393974499718752e-01 2.75739602431112201808005579550809e-02 4.15975444451907095701204131188433e-04
 	 2.31842445375473937829724491166417e-01 2.31842445375473937829724491166417e-01 2.68220453544745730464771149570424e-03
 	 2.31842445375473937829724491166417e-01 5.36315109249052124340551017667167e-01 2.68220453544745730464771149570424e-03
 	 5.36315109249052124340551017667167e-01 2.31842445375473937829724491166417e-01 2.68220453544745730464771149570424e-03
 	 3.51721776627771431922298006611527e-01 3.51721776627771431922298006611527e-01 3.06338680377702494636582564169203e-03
 	 3.51721776627771431922298006611527e-01 2.96556446744457136155403986776946e-01 3.06338680377702494636582564169203e-03
 	 2.96556446744457136155403986776946e-01 3.51721776627771431922298006611527e-01 3.06338680377702494636582564169203e-03
 	 2.21242130998175424647089748475537e-03 2.21242130998175424647089748475537e-03 3.23057149542251866285863526329081e-05
 	 2.21242130998175424647089748475537e-03 9.95575157380036546150847698299913e-01 3.23057149542251866285863526329081e-05
 	 9.95575157380036546150847698299913e-01 2.21242130998175424647089748475537e-03 3.23057149542251866285863526329081e-05
 	 4.98789564691512810057361093640793e-01 4.98789564691512810057361093640793e-01 3.94277582726633988360193106004203e-04
 	 4.98789564691512810057361093640793e-01 2.42087061697437988527781271841377e-03 3.94277582726633988360193106004203e-04
 	 2.42087061697437988527781271841377e-03 4.98789564691512810057361093640793e-01 3.94277582726633988360193106004203e-04
 	 1.74709854307173090282034877418482e-01 4.00081550569362995317668207917450e-02 7.58974691375409980798050213479655e-04
 	 1.74709854307173090282034877418482e-01 7.85281990635890547736153166624717e-01 7.58974691375409980798050213479655e-04
 	 4.00081550569362995317668207917450e-02 1.74709854307173090282034877418482e-01 7.58974691375409980798050213479655e-04
 	 4.00081550569362995317668207917450e-02 7.85281990635890547736153166624717e-01 7.58974691375409980798050213479655e-04
 	 7.85281990635890547736153166624717e-01 1.74709854307173090282034877418482e-01 7.58974691375409980798050213479655e-04
 	 7.85281990635890547736153166624717e-01 4.00081550569362995317668207917450e-02 7.58974691375409980798050213479655e-04
 	 3.86965057163826176012122459724196e-01 8.66241723145184591703404919371678e-03 4.82018154443510245775461608985779e-04
 	 3.86965057163826176012122459724196e-01 6.04372525604721988479184346942930e-01 4.82018154443510245775461608985779e-04
 	 8.66241723145184591703404919371678e-03 3.86965057163826176012122459724196e-01 4.82018154443510245775461608985779e-04
 	 8.66241723145184591703404919371678e-03 6.04372525604721988479184346942930e-01 4.82018154443510245775461608985779e-04
 	 6.04372525604721988479184346942930e-01 3.86965057163826176012122459724196e-01 4.82018154443510245775461608985779e-04
 	 6.04372525604721988479184346942930e-01 8.66241723145184591703404919371678e-03 4.82018154443510245775461608985779e-04
 	 1.26060933435405392311068339949998e-01 1.30110914835385301988046613530514e-03 1.40675183266099687725766975709973e-04
 	 1.26060933435405392311068339949998e-01 8.72637957416240728214518185268389e-01 1.40675183266099687725766975709973e-04
 	 1.30110914835385301988046613530514e-03 1.26060933435405392311068339949998e-01 1.40675183266099687725766975709973e-04
 	 1.30110914835385301988046613530514e-03 8.72637957416240728214518185268389e-01 1.40675183266099687725766975709973e-04
 	 8.72637957416240728214518185268389e-01 1.26060933435405392311068339949998e-01 1.40675183266099687725766975709973e-04
 	 8.72637957416240728214518185268389e-01 1.30110914835385301988046613530514e-03 1.40675183266099687725766975709973e-04
 	 2.83924952000500496751556056551635e-01 2.45628505378345851628552054535248e-01 2.34311066873255612053039698139401e-03
 	 2.83924952000500496751556056551635e-01 4.70446542621153651619891888913116e-01 2.34311066873255612053039698139401e-03
 	 2.45628505378345851628552054535248e-01 2.83924952000500496751556056551635e-01 2.34311066873255612053039698139401e-03
 	 2.45628505378345851628552054535248e-01 4.70446542621153651619891888913116e-01 2.34311066873255612053039698139401e-03
 	 4.70446542621153651619891888913116e-01 2.83924952000500496751556056551635e-01 2.34311066873255612053039698139401e-03
 	 4.70446542621153651619891888913116e-01 2.45628505378345851628552054535248e-01 2.34311066873255612053039698139401e-03
 	 3.30248269334462274393615643930389e-01 2.50741636173609283577690121092019e-01 2.25894949919160613338586784948347e-03
 	 3.30248269334462274393615643930389e-01 4.19010094491928442028694234977593e-01 2.25894949919160613338586784948347e-03
 	 2.50741636173609283577690121092019e-01 3.30248269334462274393615643930389e-01 2.25894949919160613338586784948347e-03
 	 2.50741636173609283577690121092019e-01 4.19010094491928442028694234977593e-01 2.25894949919160613338586784948347e-03
 	 4.19010094491928442028694234977593e-01 3.30248269334462274393615643930389e-01 2.25894949919160613338586784948347e-03
 	 4.19010094491928442028694234977593e-01 2.50741636173609283577690121092019e-01 2.25894949919160613338586784948347e-03
 	 2.56045941068157811848493565776153e-01 1.50973749388043430690042878694612e-03 2.13206740649609125881971949389992e-04
 	 2.56045941068157811848493565776153e-01 7.42444321437961796128490732371574e-01 2.13206740649609125881971949389992e-04
 	 1.50973749388043430690042878694612e-03 2.56045941068157811848493565776153e-01 2.13206740649609125881971949389992e-04
 	 1.50973749388043430690042878694612e-03 7.42444321437961796128490732371574e-01 2.13206740649609125881971949389992e-04
 	 7.42444321437961796128490732371574e-01 2.56045941068157811848493565776153e-01 2.13206740649609125881971949389992e-04
 	 7.42444321437961796128490732371574e-01 1.50973749388043430690042878694612e-03 2.13206740649609125881971949389992e-04
 	 2.60395316134476195735203418735182e-01 1.08983380212925196062201393942814e-01 1.62341831505260721958683323151718e-03
 	 2.60395316134476195735203418735182e-01 6.30621303652598608202595187322004e-01 1.62341831505260721958683323151718e-03
 	 1.08983380212925196062201393942814e-01 2.60395316134476195735203418735182e-01 1.62341831505260721958683323151718e-03
 	 1.08983380212925196062201393942814e-01 6.30621303652598608202595187322004e-01 1.62341831505260721958683323151718e-03
 	 6.30621303652598608202595187322004e-01 2.60395316134476195735203418735182e-01 1.62341831505260721958683323151718e-03
 	 6.30621303652598608202595187322004e-01 1.08983380212925196062201393942814e-01 1.62341831505260721958683323151718e-03
 	 1.70712696379342027119818681057950e-01 1.01968716908776124707713961470290e-01 1.35567494687072057427124072148672e-03
 	 1.70712696379342027119818681057950e-01 7.27318586711881875928042973100673e-01 1.35567494687072057427124072148672e-03
 	 1.01968716908776124707713961470290e-01 1.70712696379342027119818681057950e-01 1.35567494687072057427124072148672e-03
 	 1.01968716908776124707713961470290e-01 7.27318586711881875928042973100673e-01 1.35567494687072057427124072148672e-03
 	 7.27318586711881875928042973100673e-01 1.70712696379342027119818681057950e-01 1.35567494687072057427124072148672e-03
 	 7.27318586711881875928042973100673e-01 1.01968716908776124707713961470290e-01 1.35567494687072057427124072148672e-03
 	 3.74644058095124909968376414326485e-01 1.97722885748598982413870572827364e-02 8.16379113471228505007071252208561e-04
 	 3.74644058095124909968376414326485e-01 6.05583653330015181381895672529936e-01 8.16379113471228505007071252208561e-04
 	 1.97722885748598982413870572827364e-02 3.74644058095124909968376414326485e-01 8.16379113471228505007071252208561e-04
 	 1.97722885748598982413870572827364e-02 6.05583653330015181381895672529936e-01 8.16379113471228505007071252208561e-04
 	 6.05583653330015181381895672529936e-01 3.74644058095124909968376414326485e-01 8.16379113471228505007071252208561e-04
 	 6.05583653330015181381895672529936e-01 1.97722885748598982413870572827364e-02 8.16379113471228505007071252208561e-04
 	 4.35168457293983068634446453870623e-01 1.35418528809368014266534263612130e-03 2.39515088089517383211635159767638e-04
 	 4.35168457293983068634446453870623e-01 5.63477357417923152560490507312352e-01 2.39515088089517383211635159767638e-04
 	 1.35418528809368014266534263612130e-03 4.35168457293983068634446453870623e-01 2.39515088089517383211635159767638e-04
 	 1.35418528809368014266534263612130e-03 5.63477357417923152560490507312352e-01 2.39515088089517383211635159767638e-04
 	 5.63477357417923152560490507312352e-01 4.35168457293983068634446453870623e-01 2.39515088089517383211635159767638e-04
 	 5.63477357417923152560490507312352e-01 1.35418528809368014266534263612130e-03 2.39515088089517383211635159767638e-04
 	 1.39092391229103939931377453831374e-01 8.76428525159974741720603219619079e-02 1.30013591471941371800757902832402e-03
 	 1.39092391229103939931377453831374e-01 7.73264756254898544263198800763348e-01 1.30013591471941371800757902832402e-03
 	 8.76428525159974741720603219619079e-02 1.39092391229103939931377453831374e-01 1.30013591471941371800757902832402e-03
 	 8.76428525159974741720603219619079e-02 7.73264756254898544263198800763348e-01 1.30013591471941371800757902832402e-03
 	 7.73264756254898544263198800763348e-01 1.39092391229103939931377453831374e-01 1.30013591471941371800757902832402e-03
 	 7.73264756254898544263198800763348e-01 8.76428525159974741720603219619079e-02 1.30013591471941371800757902832402e-03
 	 2.80150654301227930442763636165182e-01 7.84155789651995310807208738879126e-02 1.53690383100287290482621749276859e-03
 	 2.80150654301227930442763636165182e-01 6.41433766733572441332000835245708e-01 1.53690383100287290482621749276859e-03
 	 7.84155789651995310807208738879126e-02 2.80150654301227930442763636165182e-01 1.53690383100287290482621749276859e-03
 	 7.84155789651995310807208738879126e-02 6.41433766733572441332000835245708e-01 1.53690383100287290482621749276859e-03
 	 6.41433766733572441332000835245708e-01 2.80150654301227930442763636165182e-01 1.53690383100287290482621749276859e-03
 	 6.41433766733572441332000835245708e-01 7.84155789651995310807208738879126e-02 1.53690383100287290482621749276859e-03
 	 3.46331187427559528124731969001004e-01 6.27477726380917394388703201002500e-02 1.49390992511364570707876886501708e-03
 	 3.46331187427559528124731969001004e-01 5.90921039934348746314185518713202e-01 1.49390992511364570707876886501708e-03
 	 6.27477726380917394388703201002500e-02 3.46331187427559528124731969001004e-01 1.49390992511364570707876886501708e-03
 	 6.27477726380917394388703201002500e-02 5.90921039934348746314185518713202e-01 1.49390992511364570707876886501708e-03
 	 5.90921039934348746314185518713202e-01 3.46331187427559528124731969001004e-01 1.49390992511364570707876886501708e-03
 	 5.90921039934348746314185518713202e-01 6.27477726380917394388703201002500e-02 1.49390992511364570707876886501708e-03
 	 1.14244793358781793202183507673908e-01 7.10573045383911233024987197381961e-03 3.46295674839278632643063682294837e-04
 	 1.14244793358781793202183507673908e-01 8.78649476187379097069651834317483e-01 3.46295674839278632643063682294837e-04
 	 7.10573045383911233024987197381961e-03 1.14244793358781793202183507673908e-01 3.46295674839278632643063682294837e-04
 	 7.10573045383911233024987197381961e-03 8.78649476187379097069651834317483e-01 3.46295674839278632643063682294837e-04
 	 8.78649476187379097069651834317483e-01 1.14244793358781793202183507673908e-01 3.46295674839278632643063682294837e-04
 	 8.78649476187379097069651834317483e-01 7.10573045383911233024987197381961e-03 3.46295674839278632643063682294837e-04
 	 2.60147782714403918991052933051833e-01 4.08904742282701419431312217511731e-02 1.13209474794829221579173239575766e-03
 	 2.60147782714403918991052933051833e-01 6.98961743057325946004709749104222e-01 1.13209474794829221579173239575766e-03
 	 4.08904742282701419431312217511731e-02 2.60147782714403918991052933051833e-01 1.13209474794829221579173239575766e-03
 	 4.08904742282701419431312217511731e-02 6.98961743057325946004709749104222e-01 1.13209474794829221579173239575766e-03
 	 6.98961743057325946004709749104222e-01 2.60147782714403918991052933051833e-01 1.13209474794829221579173239575766e-03
 	 6.98961743057325946004709749104222e-01 4.08904742282701419431312217511731e-02 1.13209474794829221579173239575766e-03
 	 3.38595450369722106298553399028606e-01 3.24948830275603520179039662707510e-02 1.08418096863569413286498832604821e-03
 	 3.38595450369722106298553399028606e-01 6.28909666602717520866860922978958e-01 1.08418096863569413286498832604821e-03
 	 3.24948830275603520179039662707510e-02 3.38595450369722106298553399028606e-01 1.08418096863569413286498832604821e-03
 	 3.24948830275603520179039662707510e-02 6.28909666602717520866860922978958e-01 1.08418096863569413286498832604821e-03
 	 6.28909666602717520866860922978958e-01 3.38595450369722106298553399028606e-01 1.08418096863569413286498832604821e-03
 	 6.28909666602717520866860922978958e-01 3.24948830275603520179039662707510e-02 1.08418096863569413286498832604821e-03
 	 4.40524947160692070813325926792459e-01 8.72904428993618967946854780848298e-03 6.30167241237810705524469145899502e-04
 	 4.40524947160692070813325926792459e-01 5.50746008549371834916996704123449e-01 6.30167241237810705524469145899502e-04
 	 8.72904428993618967946854780848298e-03 4.40524947160692070813325926792459e-01 6.30167241237810705524469145899502e-04
 	 8.72904428993618967946854780848298e-03 5.50746008549371834916996704123449e-01 6.30167241237810705524469145899502e-04
 	 5.50746008549371834916996704123449e-01 4.40524947160692070813325926792459e-01 6.30167241237810705524469145899502e-04
 	 5.50746008549371834916996704123449e-01 8.72904428993618967946854780848298e-03 6.30167241237810705524469145899502e-04
 	 8.57234837407636202089022958716669e-02 1.57475866401919737010139943578224e-03 1.50964002721018871909161584987658e-04
 	 8.57234837407636202089022958716669e-02 9.12701757595217100238471630291315e-01 1.50964002721018871909161584987658e-04
 	 1.57475866401919737010139943578224e-03 8.57234837407636202089022958716669e-02 1.50964002721018871909161584987658e-04
 	 1.57475866401919737010139943578224e-03 9.12701757595217100238471630291315e-01 1.50964002721018871909161584987658e-04
 	 9.12701757595217100238471630291315e-01 8.57234837407636202089022958716669e-02 1.50964002721018871909161584987658e-04
 	 9.12701757595217100238471630291315e-01 1.57475866401919737010139943578224e-03 1.50964002721018871909161584987658e-04
 	 2.85984086639778534166822510087513e-01 2.01532205535708414112505693083222e-01 2.28081151372815354311240909623848e-03
 	 2.85984086639778534166822510087513e-01 5.12483707824513134987398643716006e-01 2.28081151372815354311240909623848e-03
 	 2.01532205535708414112505693083222e-01 2.85984086639778534166822510087513e-01 2.28081151372815354311240909623848e-03
 	 2.01532205535708414112505693083222e-01 5.12483707824513134987398643716006e-01 2.28081151372815354311240909623848e-03
 	 5.12483707824513134987398643716006e-01 2.85984086639778534166822510087513e-01 2.28081151372815354311240909623848e-03
 	 5.12483707824513134987398643716006e-01 2.01532205535708414112505693083222e-01 2.28081151372815354311240909623848e-03
 	 3.02243064852707965517453203574405e-01 5.14181635143590096137522493791039e-02 1.32157138195153366945489015193971e-03
 	 3.02243064852707965517453203574405e-01 6.46338771632933073441051874397090e-01 1.32157138195153366945489015193971e-03
 	 5.14181635143590096137522493791039e-02 3.02243064852707965517453203574405e-01 1.32157138195153366945489015193971e-03
 	 5.14181635143590096137522493791039e-02 6.46338771632933073441051874397090e-01 1.32157138195153366945489015193971e-03
 	 6.46338771632933073441051874397090e-01 3.02243064852707965517453203574405e-01 1.32157138195153366945489015193971e-03
 	 6.46338771632933073441051874397090e-01 5.14181635143590096137522493791039e-02 1.32157138195153366945489015193971e-03
 	 1.14557425728885831084369328891626e-01 1.90287488235584209550488310469518e-02 5.65729964641721269104357450174803e-04
 	 1.14557425728885831084369328891626e-01 8.66413825447555741021687936154194e-01 5.65729964641721269104357450174803e-04
 	 1.90287488235584209550488310469518e-02 1.14557425728885831084369328891626e-01 5.65729964641721269104357450174803e-04
 	 1.90287488235584209550488310469518e-02 8.66413825447555741021687936154194e-01 5.65729964641721269104357450174803e-04
 	 8.66413825447555741021687936154194e-01 1.14557425728885831084369328891626e-01 5.65729964641721269104357450174803e-04
 	 8.66413825447555741021687936154194e-01 1.90287488235584209550488310469518e-02 5.65729964641721269104357450174803e-04
 	 2.12296430019530718569242822013621e-01 4.07880592078401632560868961263623e-02 1.05443659419093794735178271082532e-03
 	 2.12296430019530718569242822013621e-01 7.46915510772629187563609320932301e-01 1.05443659419093794735178271082532e-03
 	 4.07880592078401632560868961263623e-02 2.12296430019530718569242822013621e-01 1.05443659419093794735178271082532e-03
 	 4.07880592078401632560868961263623e-02 7.46915510772629187563609320932301e-01 1.05443659419093794735178271082532e-03
 	 7.46915510772629187563609320932301e-01 2.12296430019530718569242822013621e-01 1.05443659419093794735178271082532e-03
 	 7.46915510772629187563609320932301e-01 4.07880592078401632560868961263623e-02 1.05443659419093794735178271082532e-03
 	 1.46528429709901986122133621393004e-01 2.85146118965765860142624887885177e-02 7.80409350560662233575737189994470e-04
 	 1.46528429709901986122133621393004e-01 8.24956958393521455619179505447391e-01 7.80409350560662233575737189994470e-04
 	 2.85146118965765860142624887885177e-02 1.46528429709901986122133621393004e-01 7.80409350560662233575737189994470e-04
 	 2.85146118965765860142624887885177e-02 8.24956958393521455619179505447391e-01 7.80409350560662233575737189994470e-04
 	 8.24956958393521455619179505447391e-01 1.46528429709901986122133621393004e-01 7.80409350560662233575737189994470e-04
 	 8.24956958393521455619179505447391e-01 2.85146118965765860142624887885177e-02 7.80409350560662233575737189994470e-04
 	 3.74081646108826992858098492433783e-01 1.53708658611640291979938410804607e-01 2.31542555620517639600186576842589e-03
 	 3.74081646108826992858098492433783e-01 4.72209695279532715161963096761610e-01 2.31542555620517639600186576842589e-03
 	 1.53708658611640291979938410804607e-01 3.74081646108826992858098492433783e-01 2.31542555620517639600186576842589e-03
 	 1.53708658611640291979938410804607e-01 4.72209695279532715161963096761610e-01 2.31542555620517639600186576842589e-03
 	 4.72209695279532715161963096761610e-01 3.74081646108826992858098492433783e-01 2.31542555620517639600186576842589e-03
 	 4.72209695279532715161963096761610e-01 1.53708658611640291979938410804607e-01 2.31542555620517639600186576842589e-03
 	 8.17068303997550704487196071568178e-02 2.46053203840888995435065567107813e-02 5.82418912261697192984943871607584e-04
 	 8.17068303997550704487196071568178e-02 8.93687849216156071641137259575771e-01 5.82418912261697192984943871607584e-04
 	 2.46053203840888995435065567107813e-02 8.17068303997550704487196071568178e-02 5.82418912261697192984943871607584e-04
 	 2.46053203840888995435065567107813e-02 8.93687849216156071641137259575771e-01 5.82418912261697192984943871607584e-04
 	 8.93687849216156071641137259575771e-01 8.17068303997550704487196071568178e-02 5.82418912261697192984943871607584e-04
 	 8.93687849216156071641137259575771e-01 2.46053203840888995435065567107813e-02 5.82418912261697192984943871607584e-04
 	 2.94147478880844692739060519670602e-01 2.35355019299825565792794179742486e-02 9.53923793556402197651999941285794e-04
 	 2.94147478880844692739060519670602e-01 6.82317019189172757620553966262378e-01 9.53923793556402197651999941285794e-04
 	 2.35355019299825565792794179742486e-02 2.94147478880844692739060519670602e-01 9.53923793556402197651999941285794e-04
 	 2.35355019299825565792794179742486e-02 6.82317019189172757620553966262378e-01 9.53923793556402197651999941285794e-04
 	 6.82317019189172757620553966262378e-01 2.94147478880844692739060519670602e-01 9.53923793556402197651999941285794e-04
 	 6.82317019189172757620553966262378e-01 2.35355019299825565792794179742486e-02 9.53923793556402197651999941285794e-04
 	 1.75070369482651533310502145468490e-01 1.37716721260120800174320265796268e-01 1.81036796651771916648321347764750e-03
 	 1.75070369482651533310502145468490e-01 6.87212909257227666515177588735241e-01 1.81036796651771916648321347764750e-03
 	 1.37716721260120800174320265796268e-01 1.75070369482651533310502145468490e-01 1.81036796651771916648321347764750e-03
 	 1.37716721260120800174320265796268e-01 6.87212909257227666515177588735241e-01 1.81036796651771916648321347764750e-03
 	 6.87212909257227666515177588735241e-01 1.75070369482651533310502145468490e-01 1.81036796651771916648321347764750e-03
 	 6.87212909257227666515177588735241e-01 1.37716721260120800174320265796268e-01 1.81036796651771916648321347764750e-03
 	 4.76205378057730083218856975690869e-02 1.09753100892318270626057952199517e-02 3.02352958305666897828589689822820e-04
 	 4.76205378057730083218856975690869e-02 9.41404152104995173289125887094997e-01 3.02352958305666897828589689822820e-04
 	 1.09753100892318270626057952199517e-02 4.76205378057730083218856975690869e-02 3.02352958305666897828589689822820e-04
 	 1.09753100892318270626057952199517e-02 9.41404152104995173289125887094997e-01 3.02352958305666897828589689822820e-04
 	 9.41404152104995173289125887094997e-01 4.76205378057730083218856975690869e-02 3.02352958305666897828589689822820e-04
 	 9.41404152104995173289125887094997e-01 1.09753100892318270626057952199517e-02 3.02352958305666897828589689822820e-04
 	 3.17572481513326898561189182146336e-01 1.60465657202724848451325101450493e-01 2.23578901441128224253374057184374e-03
 	 3.17572481513326898561189182146336e-01 5.21961861283948169720758869516430e-01 2.23578901441128224253374057184374e-03
 	 1.60465657202724848451325101450493e-01 3.17572481513326898561189182146336e-01 2.23578901441128224253374057184374e-03
 	 1.60465657202724848451325101450493e-01 5.21961861283948169720758869516430e-01 2.23578901441128224253374057184374e-03
 	 5.21961861283948169720758869516430e-01 3.17572481513326898561189182146336e-01 2.23578901441128224253374057184374e-03
 	 5.21961861283948169720758869516430e-01 1.60465657202724848451325101450493e-01 2.23578901441128224253374057184374e-03
 	 2.88138053995077414448644503863761e-01 1.32949267737699799996065053164784e-01 2.16089327797227810992741758866487e-03
 	 2.88138053995077414448644503863761e-01 5.78912678267222813310866058600368e-01 2.16089327797227810992741758866487e-03
 	 1.32949267737699799996065053164784e-01 2.88138053995077414448644503863761e-01 2.16089327797227810992741758866487e-03
 	 1.32949267737699799996065053164784e-01 5.78912678267222813310866058600368e-01 2.16089327797227810992741758866487e-03
 	 5.78912678267222813310866058600368e-01 2.88138053995077414448644503863761e-01 2.16089327797227810992741758866487e-03
 	 5.78912678267222813310866058600368e-01 1.32949267737699799996065053164784e-01 2.16089327797227810992741758866487e-03
 	 2.67970889303296155858902238833252e-01 8.75495123131142180539221442359121e-03 5.91722984001432023362654355480572e-04
 	 2.67970889303296155858902238833252e-01 7.23274159465392418866258594789542e-01 5.91722984001432023362654355480572e-04
 	 8.75495123131142180539221442359121e-03 2.67970889303296155858902238833252e-01 5.91722984001432023362654355480572e-04
 	 8.75495123131142180539221442359121e-03 7.23274159465392418866258594789542e-01 5.91722984001432023362654355480572e-04
 	 7.23274159465392418866258594789542e-01 2.67970889303296155858902238833252e-01 5.91722984001432023362654355480572e-04
 	 7.23274159465392418866258594789542e-01 8.75495123131142180539221442359121e-03 5.91722984001432023362654355480572e-04
 	 2.39379059203026878233089291825308e-01 2.07437619833565727034407899509461e-02 8.54923059629562084697773638453100e-04
 	 2.39379059203026878233089291825308e-01 7.39877178813616476205083927197848e-01 8.54923059629562084697773638453100e-04
 	 2.07437619833565727034407899509461e-02 2.39379059203026878233089291825308e-01 8.54923059629562084697773638453100e-04
 	 2.07437619833565727034407899509461e-02 7.39877178813616476205083927197848e-01 8.54923059629562084697773638453100e-04
 	 7.39877178813616476205083927197848e-01 2.39379059203026878233089291825308e-01 8.54923059629562084697773638453100e-04
 	 7.39877178813616476205083927197848e-01 2.07437619833565727034407899509461e-02 8.54923059629562084697773638453100e-04
 	 1.91853271569703082155555762255972e-01 1.97602896840749810147830345385955e-02 7.63033388765983148355198650847342e-04
 	 1.91853271569703082155555762255972e-01 7.88386438746221940299108155159047e-01 7.63033388765983148355198650847342e-04
 	 1.97602896840749810147830345385955e-02 1.91853271569703082155555762255972e-01 7.63033388765983148355198650847342e-04
 	 1.97602896840749810147830345385955e-02 7.88386438746221940299108155159047e-01 7.63033388765983148355198650847342e-04
 	 7.88386438746221940299108155159047e-01 1.91853271569703082155555762255972e-01 7.63033388765983148355198650847342e-04
 	 7.88386438746221940299108155159047e-01 1.97602896840749810147830345385955e-02 7.63033388765983148355198650847342e-04
 	 3.87324242534184959296794659167062e-01 4.29392857768670643814346021827077e-02 1.37645103473179263552095275002785e-03
 	 3.87324242534184959296794659167062e-01 5.69736471688947920810619507392403e-01 1.37645103473179263552095275002785e-03
 	 4.29392857768670643814346021827077e-02 3.87324242534184959296794659167062e-01 1.37645103473179263552095275002785e-03
 	 4.29392857768670643814346021827077e-02 5.69736471688947920810619507392403e-01 1.37645103473179263552095275002785e-03
 	 5.69736471688947920810619507392403e-01 3.87324242534184959296794659167062e-01 1.37645103473179263552095275002785e-03
 	 5.69736471688947920810619507392403e-01 4.29392857768670643814346021827077e-02 1.37645103473179263552095275002785e-03
 	 3.53532415828410828684269517907524e-01 1.17892418158290449015090928241989e-01 2.18161361839561964912070912703257e-03
 	 3.53532415828410828684269517907524e-01 5.28575166013298791689578592922771e-01 2.18161361839561964912070912703257e-03
 	 1.17892418158290449015090928241989e-01 3.53532415828410828684269517907524e-01 2.18161361839561964912070912703257e-03
 	 1.17892418158290449015090928241989e-01 5.28575166013298791689578592922771e-01 2.18161361839561964912070912703257e-03
 	 5.28575166013298791689578592922771e-01 3.53532415828410828684269517907524e-01 2.18161361839561964912070912703257e-03
 	 5.28575166013298791689578592922771e-01 1.17892418158290449015090928241989e-01 2.18161361839561964912070912703257e-03
 	 5.21774890148561099056934153850307e-02 2.53747294625837269133050710934185e-02 4.83142678116275741100754670398487e-04
 	 5.21774890148561099056934153850307e-02 9.22447781522560239508834456501063e-01 4.83142678116275741100754670398487e-04
 	 2.53747294625837269133050710934185e-02 5.21774890148561099056934153850307e-02 4.83142678116275741100754670398487e-04
 	 2.53747294625837269133050710934185e-02 9.22447781522560239508834456501063e-01 4.83142678116275741100754670398487e-04
 	 9.22447781522560239508834456501063e-01 5.21774890148561099056934153850307e-02 4.83142678116275741100754670398487e-04
 	 9.22447781522560239508834456501063e-01 2.53747294625837269133050710934185e-02 4.83142678116275741100754670398487e-04
 	 3.23702116151313945557888018811354e-01 9.35293820848460272232571810491208e-02 1.89077633403431978088848897101570e-03
 	 3.23702116151313945557888018811354e-01 5.82768501763839985585491376696154e-01 1.89077633403431978088848897101570e-03
 	 9.35293820848460272232571810491208e-02 3.23702116151313945557888018811354e-01 1.89077633403431978088848897101570e-03
 	 9.35293820848460272232571810491208e-02 5.82768501763839985585491376696154e-01 1.89077633403431978088848897101570e-03
 	 5.82768501763839985585491376696154e-01 3.23702116151313945557888018811354e-01 1.89077633403431978088848897101570e-03
 	 5.82768501763839985585491376696154e-01 9.35293820848460272232571810491208e-02 1.89077633403431978088848897101570e-03
 	 3.72059360674848627059674299744074e-01 1.98710348807312189509111099994243e-03 3.01784656373464839872189369174293e-04
 	 3.72059360674848627059674299744074e-01 6.25953535837078356429685754847014e-01 3.01784656373464839872189369174293e-04
 	 1.98710348807312189509111099994243e-03 3.72059360674848627059674299744074e-01 3.01784656373464839872189369174293e-04
 	 1.98710348807312189509111099994243e-03 6.25953535837078356429685754847014e-01 3.01784656373464839872189369174293e-04
 	 6.25953535837078356429685754847014e-01 3.72059360674848627059674299744074e-01 3.01784656373464839872189369174293e-04
 	 6.25953535837078356429685754847014e-01 1.98710348807312189509111099994243e-03 3.01784656373464839872189369174293e-04
 	 4.13692534607104922539377866996801e-01 1.08690196293505916824706503120979e-01 2.12758198041947772446991216099832e-03
 	 4.13692534607104922539377866996801e-01 4.77617269099389119002552206438850e-01 2.12758198041947772446991216099832e-03
 	 1.08690196293505916824706503120979e-01 4.13692534607104922539377866996801e-01 2.12758198041947772446991216099832e-03
 	 1.08690196293505916824706503120979e-01 4.77617269099389119002552206438850e-01 2.12758198041947772446991216099832e-03
 	 4.77617269099389119002552206438850e-01 4.13692534607104922539377866996801e-01 2.12758198041947772446991216099832e-03
 	 4.77617269099389119002552206438850e-01 1.08690196293505916824706503120979e-01 2.12758198041947772446991216099832e-03
 	 2.50865443641437146915507128142053e-01 1.74902334150963623127239543464384e-01 2.42452666120457566503731960949608e-03
 	 2.50865443641437146915507128142053e-01 5.74232222207599285468404559651390e-01 2.42452666120457566503731960949608e-03
 	 1.74902334150963623127239543464384e-01 2.50865443641437146915507128142053e-01 2.42452666120457566503731960949608e-03
 	 1.74902334150963623127239543464384e-01 5.74232222207599285468404559651390e-01 2.42452666120457566503731960949608e-03
 	 5.74232222207599285468404559651390e-01 2.50865443641437146915507128142053e-01 2.42452666120457566503731960949608e-03
 	 5.74232222207599285468404559651390e-01 1.74902334150963623127239543464384e-01 2.42452666120457566503731960949608e-03
 	 2.36847703538783593835148622019915e-01 6.69659133716484916698519214151020e-02 1.51274590766757783578955187664405e-03
 	 2.36847703538783593835148622019915e-01 6.96186383089567928372787264379440e-01 1.51274590766757783578955187664405e-03
 	 6.69659133716484916698519214151020e-02 2.36847703538783593835148622019915e-01 1.51274590766757783578955187664405e-03
 	 6.69659133716484916698519214151020e-02 6.96186383089567928372787264379440e-01 1.51274590766757783578955187664405e-03
 	 6.96186383089567928372787264379440e-01 2.36847703538783593835148622019915e-01 1.51274590766757783578955187664405e-03
 	 6.96186383089567928372787264379440e-01 6.69659133716484916698519214151020e-02 1.51274590766757783578955187664405e-03
 	 1.09957683042648218796344394831976e-01 4.09791337707322012029464985971572e-02 9.15132955474598562377319677096921e-04
 	 1.09957683042648218796344394831976e-01 8.49063183186619552245133490941953e-01 9.15132955474598562377319677096921e-04
 	 4.09791337707322012029464985971572e-02 1.09957683042648218796344394831976e-01 9.15132955474598562377319677096921e-04
 	 4.09791337707322012029464985971572e-02 8.49063183186619552245133490941953e-01 9.15132955474598562377319677096921e-04
 	 8.49063183186619552245133490941953e-01 1.09957683042648218796344394831976e-01 9.15132955474598562377319677096921e-04
 	 8.49063183186619552245133490941953e-01 4.09791337707322012029464985971572e-02 9.15132955474598562377319677096921e-04
 	 4.29731902895181538948321531279362e-01 2.44664150758457620005170696231289e-02 1.15564557263624014156466746072738e-03
 	 4.29731902895181538948321531279362e-01 5.45801682028972612314987600257155e-01 1.15564557263624014156466746072738e-03
 	 2.44664150758457620005170696231289e-02 4.29731902895181538948321531279362e-01 1.15564557263624014156466746072738e-03
 	 2.44664150758457620005170696231289e-02 5.45801682028972612314987600257155e-01 1.15564557263624014156466746072738e-03
 	 5.45801682028972612314987600257155e-01 4.29731902895181538948321531279362e-01 1.15564557263624014156466746072738e-03
 	 5.45801682028972612314987600257155e-01 2.44664150758457620005170696231289e-02 1.15564557263624014156466746072738e-03
 	 1.43768037433372491973315732138872e-01 5.66880883410084066009737568947457e-02 1.14880906414655133661317787385769e-03
 	 1.43768037433372491973315732138872e-01 7.99543874225619122242392222688068e-01 1.14880906414655133661317787385769e-03
 	 5.66880883410084066009737568947457e-02 1.43768037433372491973315732138872e-01 1.14880906414655133661317787385769e-03
 	 5.66880883410084066009737568947457e-02 7.99543874225619122242392222688068e-01 1.14880906414655133661317787385769e-03
 	 7.99543874225619122242392222688068e-01 1.43768037433372491973315732138872e-01 1.14880906414655133661317787385769e-03
 	 7.99543874225619122242392222688068e-01 5.66880883410084066009737568947457e-02 1.14880906414655133661317787385769e-03
 	 7.74106779986907661550432635522156e-02 9.65248336154636912831428219305963e-03 3.86871300727659520306972451564320e-04
 	 7.74106779986907661550432635522156e-02 9.12936838639762937575028445280623e-01 3.86871300727659520306972451564320e-04
 	 9.65248336154636912831428219305963e-03 7.74106779986907661550432635522156e-02 3.86871300727659520306972451564320e-04
 	 9.65248336154636912831428219305963e-03 9.12936838639762937575028445280623e-01 3.86871300727659520306972451564320e-04
 	 9.12936838639762937575028445280623e-01 7.74106779986907661550432635522156e-02 3.86871300727659520306972451564320e-04
 	 9.12936838639762937575028445280623e-01 9.65248336154636912831428219305963e-03 3.86871300727659520306972451564320e-04
 	 1.55706005665346897126610770101252e-01 1.10995676273211840018317886347177e-02 5.54555395331634269108500578937537e-04
 	 1.55706005665346897126610770101252e-01 8.33194426707331903259046157472767e-01 5.54555395331634269108500578937537e-04
 	 1.10995676273211840018317886347177e-02 1.55706005665346897126610770101252e-01 5.54555395331634269108500578937537e-04
 	 1.10995676273211840018317886347177e-02 8.33194426707331903259046157472767e-01 5.54555395331634269108500578937537e-04
 	 8.33194426707331903259046157472767e-01 1.55706005665346897126610770101252e-01 5.54555395331634269108500578937537e-04
 	 8.33194426707331903259046157472767e-01 1.10995676273211840018317886347177e-02 5.54555395331634269108500578937537e-04
 	 3.12853302449651204941716287066811e-01 1.97407178793647343148509598620421e-03 2.95864003539374426175051491227919e-04
 	 3.12853302449651204941716287066811e-01 6.85172625762412335070905555767240e-01 2.95864003539374426175051491227919e-04
 	 1.97407178793647343148509598620421e-03 3.12853302449651204941716287066811e-01 2.95864003539374426175051491227919e-04
 	 1.97407178793647343148509598620421e-03 6.85172625762412335070905555767240e-01 2.95864003539374426175051491227919e-04
 	 6.85172625762412335070905555767240e-01 3.12853302449651204941716287066811e-01 2.95864003539374426175051491227919e-04
 	 6.85172625762412335070905555767240e-01 1.97407178793647343148509598620421e-03 2.95864003539374426175051491227919e-04
 	 2.60902661381798156581268699483189e-02 1.10588672805732885634499851335022e-02 2.33164539169912336021711629641118e-04
 	 2.60902661381798156581268699483189e-02 9.62850866581246966902085659967270e-01 2.33164539169912336021711629641118e-04
 	 1.10588672805732885634499851335022e-02 2.60902661381798156581268699483189e-02 2.33164539169912336021711629641118e-04
 	 1.10588672805732885634499851335022e-02 9.62850866581246966902085659967270e-01 2.33164539169912336021711629641118e-04
 	 9.62850866581246966902085659967270e-01 2.60902661381798156581268699483189e-02 2.33164539169912336021711629641118e-04
 	 9.62850866581246966902085659967270e-01 1.10588672805732885634499851335022e-02 2.33164539169912336021711629641118e-04
 	 1.65672860817991568493923182359140e-01 2.46254442236619333975178314233290e-03 2.53027257107086016481301005143223e-04
 	 1.65672860817991568493923182359140e-01 8.31864594759642250743070235330379e-01 2.53027257107086016481301005143223e-04
 	 2.46254442236619333975178314233290e-03 1.65672860817991568493923182359140e-01 2.53027257107086016481301005143223e-04
 	 2.46254442236619333975178314233290e-03 8.31864594759642250743070235330379e-01 2.53027257107086016481301005143223e-04
 	 8.31864594759642250743070235330379e-01 1.65672860817991568493923182359140e-01 2.53027257107086016481301005143223e-04
 	 8.31864594759642250743070235330379e-01 2.46254442236619333975178314233290e-03 2.53027257107086016481301005143223e-04
 	 7.42257546763113590371219174812722e-02 4.63950129826373944275097471745539e-02 7.73102621795122239151121235067876e-04
 	 7.42257546763113590371219174812722e-02 8.79379232341051308985413470509229e-01 7.73102621795122239151121235067876e-04
 	 4.63950129826373944275097471745539e-02 7.42257546763113590371219174812722e-02 7.73102621795122239151121235067876e-04
 	 4.63950129826373944275097471745539e-02 8.79379232341051308985413470509229e-01 7.73102621795122239151121235067876e-04
 	 8.79379232341051308985413470509229e-01 7.42257546763113590371219174812722e-02 7.73102621795122239151121235067876e-04
 	 8.79379232341051308985413470509229e-01 4.63950129826373944275097471745539e-02 7.73102621795122239151121235067876e-04
 	 2.88339172370140305046160023039192e-02 2.07859992487419847906338077336841e-03 1.11908386263531061440706926291000e-04
 	 2.88339172370140305046160023039192e-02 9.69087482838111746730191953247413e-01 1.11908386263531061440706926291000e-04
 	 2.07859992487419847906338077336841e-03 2.88339172370140305046160023039192e-02 1.11908386263531061440706926291000e-04
 	 2.07859992487419847906338077336841e-03 9.69087482838111746730191953247413e-01 1.11908386263531061440706926291000e-04
 	 9.69087482838111746730191953247413e-01 2.88339172370140305046160023039192e-02 1.11908386263531061440706926291000e-04
 	 9.69087482838111746730191953247413e-01 2.07859992487419847906338077336841e-03 1.11908386263531061440706926291000e-04
 	 1.86822660672315066232584968020092e-01 6.83532967983220413055178710237669e-02 1.47809259194698369536957738290539e-03
 	 1.86822660672315066232584968020092e-01 7.44824042529362850828533737512771e-01 1.47809259194698369536957738290539e-03
 	 6.83532967983220413055178710237669e-02 1.86822660672315066232584968020092e-01 1.47809259194698369536957738290539e-03
 	 6.83532967983220413055178710237669e-02 7.44824042529362850828533737512771e-01 1.47809259194698369536957738290539e-03
 	 7.44824042529362850828533737512771e-01 1.86822660672315066232584968020092e-01 1.47809259194698369536957738290539e-03
 	 7.44824042529362850828533737512771e-01 6.83532967983220413055178710237669e-02 1.47809259194698369536957738290539e-03
 	 3.27083928185687322631736151379300e-01 1.06763043029804560041240435452892e-02 7.14520924585107107714077034898992e-04
 	 3.27083928185687322631736151379300e-01 6.62239767511332177996052905655233e-01 7.14520924585107107714077034898992e-04
 	 1.06763043029804560041240435452892e-02 3.27083928185687322631736151379300e-01 7.14520924585107107714077034898992e-04
 	 1.06763043029804560041240435452892e-02 6.62239767511332177996052905655233e-01 7.14520924585107107714077034898992e-04
 	 6.62239767511332177996052905655233e-01 3.27083928185687322631736151379300e-01 7.14520924585107107714077034898992e-04
 	 6.62239767511332177996052905655233e-01 1.06763043029804560041240435452892e-02 7.14520924585107107714077034898992e-04
 	 1.03891103433826778590365336185641e-01 6.91692834636133124792678472658736e-02 1.07293467420879144041956365640544e-03
 	 1.03891103433826778590365336185641e-01 8.26939613102559922808154624362942e-01 1.07293467420879144041956365640544e-03
 	 6.91692834636133124792678472658736e-02 1.03891103433826778590365336185641e-01 1.07293467420879144041956365640544e-03
 	 6.91692834636133124792678472658736e-02 8.26939613102559922808154624362942e-01 1.07293467420879144041956365640544e-03
 	 8.26939613102559922808154624362942e-01 1.03891103433826778590365336185641e-01 1.07293467420879144041956365640544e-03
 	 8.26939613102559922808154624362942e-01 6.91692834636133124792678472658736e-02 1.07293467420879144041956365640544e-03
 	 2.15534288242954619185809406189946e-01 1.00668809434643721778535052635561e-01 1.79238370972849346378363843967918e-03
 	 2.15534288242954619185809406189946e-01 6.83796902322401645157867733360035e-01 1.79238370972849346378363843967918e-03
 	 1.00668809434643721778535052635561e-01 2.15534288242954619185809406189946e-01 1.79238370972849346378363843967918e-03
 	 1.00668809434643721778535052635561e-01 6.83796902322401645157867733360035e-01 1.79238370972849346378363843967918e-03
 	 6.83796902322401645157867733360035e-01 2.15534288242954619185809406189946e-01 1.79238370972849346378363843967918e-03
 	 6.83796902322401645157867733360035e-01 1.00668809434643721778535052635561e-01 1.79238370972849346378363843967918e-03
 	 3.43151613027389945642653401591815e-01 2.01217937528444273942440645441820e-01 2.72636788911361036685798708845141e-03
 	 3.43151613027389945642653401591815e-01 4.55630449444165752659330337337451e-01 2.72636788911361036685798708845141e-03
 	 2.01217937528444273942440645441820e-01 3.43151613027389945642653401591815e-01 2.72636788911361036685798708845141e-03
 	 2.01217937528444273942440645441820e-01 4.55630449444165752659330337337451e-01 2.72636788911361036685798708845141e-03
 	 4.55630449444165752659330337337451e-01 3.43151613027389945642653401591815e-01 2.72636788911361036685798708845141e-03
 	 4.55630449444165752659330337337451e-01 2.01217937528444273942440645441820e-01 2.72636788911361036685798708845141e-03
 	 2.22408758723325439277118675818201e-01 1.43453248492636881161743644952367e-01 2.19083288782857691159855484386298e-03
 	 2.22408758723325439277118675818201e-01 6.34137992784037707316713294858346e-01 2.19083288782857691159855484386298e-03
 	 1.43453248492636881161743644952367e-01 2.22408758723325439277118675818201e-01 2.19083288782857691159855484386298e-03
 	 1.43453248492636881161743644952367e-01 6.34137992784037707316713294858346e-01 2.19083288782857691159855484386298e-03
 	 6.34137992784037707316713294858346e-01 2.22408758723325439277118675818201e-01 2.19083288782857691159855484386298e-03
 	 6.34137992784037707316713294858346e-01 1.43453248492636881161743644952367e-01 2.19083288782857691159855484386298e-03
 	 5.34809769143942265179347828052414e-02 2.12516053769432446476916886979325e-03 1.53587267982227722307175810101398e-04
 	 5.34809769143942265179347828052414e-02 9.44393862547911466798211677087238e-01 1.53587267982227722307175810101398e-04
 	 2.12516053769432446476916886979325e-03 5.34809769143942265179347828052414e-02 1.53587267982227722307175810101398e-04
 	 2.12516053769432446476916886979325e-03 9.44393862547911466798211677087238e-01 1.53587267982227722307175810101398e-04
 	 9.44393862547911466798211677087238e-01 5.34809769143942265179347828052414e-02 1.53587267982227722307175810101398e-04
 	 9.44393862547911466798211677087238e-01 2.12516053769432446476916886979325e-03 1.53587267982227722307175810101398e-04
 	 4.38788968845026938758735468582017e-01 5.14225024494020452325848680175113e-02 1.61908850822945577993539068017981e-03
 	 4.38788968845026938758735468582017e-01 5.09788528705571009069785759493243e-01 1.61908850822945577993539068017981e-03
 	 5.14225024494020452325848680175113e-02 4.38788968845026938758735468582017e-01 1.61908850822945577993539068017981e-03
 	 5.14225024494020452325848680175113e-02 5.09788528705571009069785759493243e-01 1.61908850822945577993539068017981e-03
 	 5.09788528705571009069785759493243e-01 4.38788968845026938758735468582017e-01 1.61908850822945577993539068017981e-03
 	 5.09788528705571009069785759493243e-01 5.14225024494020452325848680175113e-02 1.61908850822945577993539068017981e-03
 	 3.91932101375555841382691824037465e-01 7.81526329255782525873286203932366e-02 2.05269142946377242120448158857471e-03
 	 3.91932101375555841382691824037465e-01 5.29915265698865822763252708682558e-01 2.05269142946377242120448158857471e-03
 	 7.81526329255782525873286203932366e-02 3.91932101375555841382691824037465e-01 2.05269142946377242120448158857471e-03
 	 7.81526329255782525873286203932366e-02 5.29915265698865822763252708682558e-01 2.05269142946377242120448158857471e-03
 	 5.29915265698865822763252708682558e-01 3.91932101375555841382691824037465e-01 2.05269142946377242120448158857471e-03
 	 5.29915265698865822763252708682558e-01 7.81526329255782525873286203932366e-02 2.05269142946377242120448158857471e-03
 	 2.11082179897034566407043598701421e-01 6.49692444592179802614895223200620e-03 5.34179366171051456940732649059100e-04
 	 2.11082179897034566407043598701421e-01 7.82420895657043646842510042915819e-01 5.34179366171051456940732649059100e-04
 	 6.49692444592179802614895223200620e-03 2.11082179897034566407043598701421e-01 5.34179366171051456940732649059100e-04
 	 6.49692444592179802614895223200620e-03 7.82420895657043646842510042915819e-01 5.34179366171051456940732649059100e-04
 	 7.82420895657043646842510042915819e-01 2.11082179897034566407043598701421e-01 5.34179366171051456940732649059100e-04
 	 7.82420895657043646842510042915819e-01 6.49692444592179802614895223200620e-03 5.34179366171051456940732649059100e-04
 	 1.17098573109517579970972889213954e-02 2.09030641915285923110312538142352e-03 7.11599458074914901790225529865097e-05
 	 1.17098573109517579970972889213954e-02 9.86199836269895380169714371731970e-01 7.11599458074914901790225529865097e-05
 	 2.09030641915285923110312538142352e-03 1.17098573109517579970972889213954e-02 7.11599458074914901790225529865097e-05
 	 2.09030641915285923110312538142352e-03 9.86199836269895380169714371731970e-01 7.11599458074914901790225529865097e-05
 	 9.86199836269895380169714371731970e-01 1.17098573109517579970972889213954e-02 7.11599458074914901790225529865097e-05
 	 9.86199836269895380169714371731970e-01 2.09030641915285923110312538142352e-03 7.11599458074914901790225529865097e-05
 	 2.06383353759989840447985898208572e-01 1.39863518147532501665827875392267e-04 8.02792352761152354975043854423689e-05
 	 2.06383353759989840447985898208572e-01 7.93476782721862616831742798240157e-01 8.02792352761152354975043854423689e-05
 	 1.39863518147532501665827875392267e-04 2.06383353759989840447985898208572e-01 8.02792352761152354975043854423689e-05
 	 1.39863518147532501665827875392267e-04 7.93476782721862616831742798240157e-01 8.02792352761152354975043854423689e-05
 	 7.93476782721862616831742798240157e-01 2.06383353759989840447985898208572e-01 8.02792352761152354975043854423689e-05
 	 7.93476782721862616831742798240157e-01 1.39863518147532501665827875392267e-04 8.02792352761152354975043854423689e-05
 	 ];
 
 	 case  50 

 	 % ALG. DEG.:   50
 	 % PTS CARD.:  453
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw=[
 	 2.56355863384790827463888263082481e-01 2.56355863384790827463888263082481e-01 1.66434758735661478268319513063034e-03
 	 2.56355863384790827463888263082481e-01 4.87288273230418345072223473835038e-01 1.66434758735661478268319513063034e-03
 	 4.87288273230418345072223473835038e-01 2.56355863384790827463888263082481e-01 1.66434758735661478268319513063034e-03
 	 1.63057814214604269824338000915986e-03 1.63057814214604269824338000915986e-03 1.82966121231848889868137203462695e-05
 	 1.63057814214604269824338000915986e-03 9.96738843715707867332298519613687e-01 1.82966121231848889868137203462695e-05
 	 9.96738843715707867332298519613687e-01 1.63057814214604269824338000915986e-03 1.82966121231848889868137203462695e-05
 	 4.90326869248451202576433161084424e-01 4.90326869248451202576433161084424e-01 8.25698178639569426578992406007274e-04
 	 4.90326869248451202576433161084424e-01 1.93462615030975948471336778311525e-02 8.25698178639569426578992406007274e-04
 	 1.93462615030975948471336778311525e-02 4.90326869248451202576433161084424e-01 8.25698178639569426578992406007274e-04
 	 4.22587168507520649640696319693234e-01 4.22587168507520649640696319693234e-01 2.12954833909573563663353290564828e-03
 	 4.22587168507520649640696319693234e-01 1.54825662984958700718607360613532e-01 2.12954833909573563663353290564828e-03
 	 1.54825662984958700718607360613532e-01 4.22587168507520649640696319693234e-01 2.12954833909573563663353290564828e-03
 	 4.80575676434030041317413406432024e-01 4.80575676434030041317413406432024e-01 1.21213997870494682822239962405320e-03
 	 4.80575676434030041317413406432024e-01 3.88486471319399173651731871359516e-02 1.21213997870494682822239962405320e-03
 	 3.88486471319399173651731871359516e-02 4.80575676434030041317413406432024e-01 1.21213997870494682822239962405320e-03
 	 4.59586771824411877140903470717603e-01 4.59586771824411877140903470717603e-01 1.79135560553105358493064525049476e-03
 	 4.59586771824411877140903470717603e-01 8.08264563511762457181930585647933e-02 1.79135560553105358493064525049476e-03
 	 8.08264563511762457181930585647933e-02 4.59586771824411877140903470717603e-01 1.79135560553105358493064525049476e-03
 	 1.13333234135074248372099248172162e-01 1.13333234135074248372099248172162e-01 1.38979940022233156016184807413083e-03
 	 1.13333234135074248372099248172162e-01 7.73333531729851531011377119284589e-01 1.38979940022233156016184807413083e-03
 	 7.73333531729851531011377119284589e-01 1.13333234135074248372099248172162e-01 1.38979940022233156016184807413083e-03
 	 1.09390130646629217536780487307624e-02 1.09390130646629217536780487307624e-02 1.49976093457403371464117802780436e-04
 	 1.09390130646629217536780487307624e-02 9.78121973870674121798174383002333e-01 1.49976093457403371464117802780436e-04
 	 9.78121973870674121798174383002333e-01 1.09390130646629217536780487307624e-02 1.49976093457403371464117802780436e-04
 	 7.86463619513996653465071062782954e-02 7.86463619513996653465071062782954e-02 1.03393583353988721858229826722209e-03
 	 7.86463619513996653465071062782954e-02 8.42707276097200641551410171814496e-01 1.03393583353988721858229826722209e-03
 	 8.42707276097200641551410171814496e-01 7.86463619513996653465071062782954e-02 1.03393583353988721858229826722209e-03
 	 1.70258882364131336473178635060322e-01 1.70258882364131336473178635060322e-01 2.01385549425915589757951629223953e-03
 	 1.70258882364131336473178635060322e-01 6.59482235271737327053642729879357e-01 2.01385549425915589757951629223953e-03
 	 6.59482235271737327053642729879357e-01 1.70258882364131336473178635060322e-01 2.01385549425915589757951629223953e-03
 	 1.99633459336817115081785800612124e-01 1.99633459336817115081785800612124e-01 2.28533694456309029521823283914728e-03
 	 1.99633459336817115081785800612124e-01 6.00733081326365825347579630033579e-01 2.28533694456309029521823283914728e-03
 	 6.00733081326365825347579630033579e-01 1.99633459336817115081785800612124e-01 2.28533694456309029521823283914728e-03
 	 4.00668932548830014628293838541140e-01 4.00668932548830014628293838541140e-01 2.58267796372693703155221101042116e-03
 	 4.00668932548830014628293838541140e-01 1.98662134902339970743412322917720e-01 2.58267796372693703155221101042116e-03
 	 1.98662134902339970743412322917720e-01 4.00668932548830014628293838541140e-01 2.58267796372693703155221101042116e-03
 	 1.40613874056384147159803887916496e-01 1.40613874056384147159803887916496e-01 1.74263167672632853129333074804208e-03
 	 1.40613874056384147159803887916496e-01 7.18772251887231705680392224167008e-01 1.74263167672632853129333074804208e-03
 	 7.18772251887231705680392224167008e-01 1.40613874056384147159803887916496e-01 1.74263167672632853129333074804208e-03
 	 3.51190364445415514893511499394663e-01 3.51190364445415514893511499394663e-01 2.92840722695922664464696083541639e-03
 	 3.51190364445415514893511499394663e-01 2.97619271109168970212977001210675e-01 2.92840722695922664464696083541639e-03
 	 2.97619271109168970212977001210675e-01 3.51190364445415514893511499394663e-01 2.92840722695922664464696083541639e-03
 	 4.22503625151379735847001484216889e-02 4.22503625151379735847001484216889e-02 5.99474391919224301392143949840374e-04
 	 4.22503625151379735847001484216889e-02 9.15499274969724052830599703156622e-01 5.99474391919224301392143949840374e-04
 	 9.15499274969724052830599703156622e-01 4.22503625151379735847001484216889e-02 5.99474391919224301392143949840374e-04
 	 4.98683898312057949375741827680031e-01 4.98683898312057949375741827680031e-01 3.74661027052605418493497202447884e-04
 	 4.98683898312057949375741827680031e-01 2.63220337588410124851634463993832e-03 3.74661027052605418493497202447884e-04
 	 2.63220337588410124851634463993832e-03 4.98683898312057949375741827680031e-01 3.74661027052605418493497202447884e-04
 	 2.96479867512970896026303080361686e-01 2.96479867512970896026303080361686e-01 2.88681945179615484509128009449341e-03
 	 2.96479867512970896026303080361686e-01 4.07040264974058207947393839276629e-01 2.88681945179615484509128009449341e-03
 	 4.07040264974058207947393839276629e-01 2.96479867512970896026303080361686e-01 2.88681945179615484509128009449341e-03
 	 4.43323086858342041427505364481476e-01 9.22456106070470324524712690816841e-04 1.73664079746238634313973414613486e-04
 	 4.43323086858342041427505364481476e-01 5.55754457035587567936829600512283e-01 1.73664079746238634313973414613486e-04
 	 9.22456106070470324524712690816841e-04 4.43323086858342041427505364481476e-01 1.73664079746238634313973414613486e-04
 	 9.22456106070470324524712690816841e-04 5.55754457035587567936829600512283e-01 1.73664079746238634313973414613486e-04
 	 5.55754457035587567936829600512283e-01 4.43323086858342041427505364481476e-01 1.73664079746238634313973414613486e-04
 	 5.55754457035587567936829600512283e-01 9.22456106070470324524712690816841e-04 1.73664079746238634313973414613486e-04
 	 2.59368938757903871872301237999636e-02 2.24379912623130783888569794726209e-02 1.50025050954953907472386176458201e-04
 	 2.59368938757903871872301237999636e-02 9.51625114861896603812851935799699e-01 1.50025050954953907472386176458201e-04
 	 2.24379912623130783888569794726209e-02 2.59368938757903871872301237999636e-02 1.50025050954953907472386176458201e-04
 	 2.24379912623130783888569794726209e-02 9.51625114861896603812851935799699e-01 1.50025050954953907472386176458201e-04
 	 9.51625114861896603812851935799699e-01 2.59368938757903871872301237999636e-02 1.50025050954953907472386176458201e-04
 	 9.51625114861896603812851935799699e-01 2.24379912623130783888569794726209e-02 1.50025050954953907472386176458201e-04
 	 2.40144105263269458383490473352140e-01 2.22790728293732892550949031829077e-01 1.36520102961489356828417296441103e-03
 	 2.40144105263269458383490473352140e-01 5.37065166442997621309984879189869e-01 1.36520102961489356828417296441103e-03
 	 2.22790728293732892550949031829077e-01 2.40144105263269458383490473352140e-01 1.36520102961489356828417296441103e-03
 	 2.22790728293732892550949031829077e-01 5.37065166442997621309984879189869e-01 1.36520102961489356828417296441103e-03
 	 5.37065166442997621309984879189869e-01 2.40144105263269458383490473352140e-01 1.36520102961489356828417296441103e-03
 	 5.37065166442997621309984879189869e-01 2.22790728293732892550949031829077e-01 1.36520102961489356828417296441103e-03
 	 1.34552618026642700765904692161712e-01 2.31202139702463074777405438453570e-02 5.66485725892312656781779622860995e-04
 	 1.34552618026642700765904692161712e-01 8.42327168003110915428521821013419e-01 5.66485725892312656781779622860995e-04
 	 2.31202139702463074777405438453570e-02 1.34552618026642700765904692161712e-01 5.66485725892312656781779622860995e-04
 	 2.31202139702463074777405438453570e-02 8.42327168003110915428521821013419e-01 5.66485725892312656781779622860995e-04
 	 8.42327168003110915428521821013419e-01 1.34552618026642700765904692161712e-01 5.66485725892312656781779622860995e-04
 	 8.42327168003110915428521821013419e-01 2.31202139702463074777405438453570e-02 5.66485725892312656781779622860995e-04
 	 4.50355724673314194994588888221188e-02 8.56779795008972286721182776147998e-04 6.82609204983525768651100862349779e-05
 	 4.50355724673314194994588888221188e-02 9.54107647737659547715338703710586e-01 6.82609204983525768651100862349779e-05
 	 8.56779795008972286721182776147998e-04 4.50355724673314194994588888221188e-02 6.82609204983525768651100862349779e-05
 	 8.56779795008972286721182776147998e-04 9.54107647737659547715338703710586e-01 6.82609204983525768651100862349779e-05
 	 9.54107647737659547715338703710586e-01 4.50355724673314194994588888221188e-02 6.82609204983525768651100862349779e-05
 	 9.54107647737659547715338703710586e-01 8.56779795008972286721182776147998e-04 6.82609204983525768651100862349779e-05
 	 4.08714566567771886429483174651978e-01 4.80863766087200571186510700272265e-03 3.84688033392161432208466997906271e-04
 	 4.08714566567771886429483174651978e-01 5.86476795771356140818397761904635e-01 3.84688033392161432208466997906271e-04
 	 4.80863766087200571186510700272265e-03 4.08714566567771886429483174651978e-01 3.84688033392161432208466997906271e-04
 	 4.80863766087200571186510700272265e-03 5.86476795771356140818397761904635e-01 3.84688033392161432208466997906271e-04
 	 5.86476795771356140818397761904635e-01 4.08714566567771886429483174651978e-01 3.84688033392161432208466997906271e-04
 	 5.86476795771356140818397761904635e-01 4.80863766087200571186510700272265e-03 3.84688033392161432208466997906271e-04
 	 1.71463457739983227146041144806077e-01 2.34930123594385593943645318404378e-02 6.48486597306068088958364015184088e-04
 	 1.71463457739983227146041144806077e-01 8.05043529900578258562404698750470e-01 6.48486597306068088958364015184088e-04
 	 2.34930123594385593943645318404378e-02 1.71463457739983227146041144806077e-01 6.48486597306068088958364015184088e-04
 	 2.34930123594385593943645318404378e-02 8.05043529900578258562404698750470e-01 6.48486597306068088958364015184088e-04
 	 8.05043529900578258562404698750470e-01 1.71463457739983227146041144806077e-01 6.48486597306068088958364015184088e-04
 	 8.05043529900578258562404698750470e-01 2.34930123594385593943645318404378e-02 6.48486597306068088958364015184088e-04
 	 2.10105924705033142441124027754995e-01 9.33966471293635747130679192196112e-02 1.40292758105521608857912951862090e-03
 	 2.10105924705033142441124027754995e-01 6.96497428165603227334656821767567e-01 1.40292758105521608857912951862090e-03
 	 9.33966471293635747130679192196112e-02 2.10105924705033142441124027754995e-01 1.40292758105521608857912951862090e-03
 	 9.33966471293635747130679192196112e-02 6.96497428165603227334656821767567e-01 1.40292758105521608857912951862090e-03
 	 6.96497428165603227334656821767567e-01 2.10105924705033142441124027754995e-01 1.40292758105521608857912951862090e-03
 	 6.96497428165603227334656821767567e-01 9.33966471293635747130679192196112e-02 1.40292758105521608857912951862090e-03
 	 1.39296820118585046310855091178382e-01 4.17966366511481543510875269475946e-02 8.54412111496704045239536373657074e-04
 	 1.39296820118585046310855091178382e-01 8.18906543230266792399163477966795e-01 8.54412111496704045239536373657074e-04
 	 4.17966366511481543510875269475946e-02 1.39296820118585046310855091178382e-01 8.54412111496704045239536373657074e-04
 	 4.17966366511481543510875269475946e-02 8.18906543230266792399163477966795e-01 8.54412111496704045239536373657074e-04
 	 8.18906543230266792399163477966795e-01 1.39296820118585046310855091178382e-01 8.54412111496704045239536373657074e-04
 	 8.18906543230266792399163477966795e-01 4.17966366511481543510875269475946e-02 8.54412111496704045239536373657074e-04
 	 7.03820539127592015304912820283789e-02 4.93573118928612927791554909617844e-02 7.41763471609339138795879975418757e-04
 	 7.03820539127592015304912820283789e-02 8.80260634194379498751459323102608e-01 7.41763471609339138795879975418757e-04
 	 4.93573118928612927791554909617844e-02 7.03820539127592015304912820283789e-02 7.41763471609339138795879975418757e-04
 	 4.93573118928612927791554909617844e-02 8.80260634194379498751459323102608e-01 7.41763471609339138795879975418757e-04
 	 8.80260634194379498751459323102608e-01 7.03820539127592015304912820283789e-02 7.41763471609339138795879975418757e-04
 	 8.80260634194379498751459323102608e-01 4.93573118928612927791554909617844e-02 7.41763471609339138795879975418757e-04
 	 3.72606488156493997898621728381841e-01 1.52814107012161137788552878191695e-01 2.12709721662030079233907109426127e-03
 	 3.72606488156493997898621728381841e-01 4.74579404831344864312825393426465e-01 2.12709721662030079233907109426127e-03
 	 1.52814107012161137788552878191695e-01 3.72606488156493997898621728381841e-01 2.12709721662030079233907109426127e-03
 	 1.52814107012161137788552878191695e-01 4.74579404831344864312825393426465e-01 2.12709721662030079233907109426127e-03
 	 4.74579404831344864312825393426465e-01 3.72606488156493997898621728381841e-01 2.12709721662030079233907109426127e-03
 	 4.74579404831344864312825393426465e-01 1.52814107012161137788552878191695e-01 2.12709721662030079233907109426127e-03
 	 1.47915717277644076510512149980059e-01 6.51154299306215683662557580646535e-02 1.09889979335918994488019428956704e-03
 	 1.47915717277644076510512149980059e-01 7.86968852791734341245444284140831e-01 1.09889979335918994488019428956704e-03
 	 6.51154299306215683662557580646535e-02 1.47915717277644076510512149980059e-01 1.09889979335918994488019428956704e-03
 	 6.51154299306215683662557580646535e-02 7.86968852791734341245444284140831e-01 1.09889979335918994488019428956704e-03
 	 7.86968852791734341245444284140831e-01 1.47915717277644076510512149980059e-01 1.09889979335918994488019428956704e-03
 	 7.86968852791734341245444284140831e-01 6.51154299306215683662557580646535e-02 1.09889979335918994488019428956704e-03
 	 2.14024643581643692069604867356247e-01 2.34621431760208033756587298057639e-02 7.74290973945819245398414221170924e-04
 	 2.14024643581643692069604867356247e-01 7.62513213242335452513032123533776e-01 7.74290973945819245398414221170924e-04
 	 2.34621431760208033756587298057639e-02 2.14024643581643692069604867356247e-01 7.74290973945819245398414221170924e-04
 	 2.34621431760208033756587298057639e-02 7.62513213242335452513032123533776e-01 7.74290973945819245398414221170924e-04
 	 7.62513213242335452513032123533776e-01 2.14024643581643692069604867356247e-01 7.74290973945819245398414221170924e-04
 	 7.62513213242335452513032123533776e-01 2.34621431760208033756587298057639e-02 7.74290973945819245398414221170924e-04
 	 3.30267403058144004557306061542477e-01 5.20322782344110751351351495941344e-02 1.30164026507678513323862379280627e-03
 	 3.30267403058144004557306061542477e-01 6.17700318707444906429770981048932e-01 1.30164026507678513323862379280627e-03
 	 5.20322782344110751351351495941344e-02 3.30267403058144004557306061542477e-01 1.30164026507678513323862379280627e-03
 	 5.20322782344110751351351495941344e-02 6.17700318707444906429770981048932e-01 1.30164026507678513323862379280627e-03
 	 6.17700318707444906429770981048932e-01 3.30267403058144004557306061542477e-01 1.30164026507678513323862379280627e-03
 	 6.17700318707444906429770981048932e-01 5.20322782344110751351351495941344e-02 1.30164026507678513323862379280627e-03
 	 3.69984863544403907997804026308586e-01 1.49451910553232629290387745157886e-03 2.33085132051627291413509190931563e-04
 	 3.69984863544403907997804026308586e-01 6.28520617350063814932070727081737e-01 2.33085132051627291413509190931563e-04
 	 1.49451910553232629290387745157886e-03 3.69984863544403907997804026308586e-01 2.33085132051627291413509190931563e-04
 	 1.49451910553232629290387745157886e-03 6.28520617350063814932070727081737e-01 2.33085132051627291413509190931563e-04
 	 6.28520617350063814932070727081737e-01 3.69984863544403907997804026308586e-01 2.33085132051627291413509190931563e-04
 	 6.28520617350063814932070727081737e-01 1.49451910553232629290387745157886e-03 2.33085132051627291413509190931563e-04
 	 6.75115690433361337330353535435279e-02 1.20437469347925395213305677089011e-02 3.28788578186756390471512379036767e-04
 	 6.75115690433361337330353535435279e-02 9.20444684021871406542913973680697e-01 3.28788578186756390471512379036767e-04
 	 1.20437469347925395213305677089011e-02 6.75115690433361337330353535435279e-02 3.28788578186756390471512379036767e-04
 	 1.20437469347925395213305677089011e-02 9.20444684021871406542913973680697e-01 3.28788578186756390471512379036767e-04
 	 9.20444684021871406542913973680697e-01 6.75115690433361337330353535435279e-02 3.28788578186756390471512379036767e-04
 	 9.20444684021871406542913973680697e-01 1.20437469347925395213305677089011e-02 3.28788578186756390471512379036767e-04
 	 4.37098841180096731040549684621510e-01 5.66847855434612496461355135579652e-02 1.39323270474968645069036021766351e-03
 	 4.37098841180096731040549684621510e-01 5.06216373276442088702253840892809e-01 1.39323270474968645069036021766351e-03
 	 5.66847855434612496461355135579652e-02 4.37098841180096731040549684621510e-01 1.39323270474968645069036021766351e-03
 	 5.66847855434612496461355135579652e-02 5.06216373276442088702253840892809e-01 1.39323270474968645069036021766351e-03
 	 5.06216373276442088702253840892809e-01 4.37098841180096731040549684621510e-01 1.39323270474968645069036021766351e-03
 	 5.06216373276442088702253840892809e-01 5.66847855434612496461355135579652e-02 1.39323270474968645069036021766351e-03
 	 4.14512221157785298863984735362465e-01 1.14860142044815705109073178391554e-01 2.06482847657084344142330856186618e-03
 	 4.14512221157785298863984735362465e-01 4.70627636797398996026942086245981e-01 2.06482847657084344142330856186618e-03
 	 1.14860142044815705109073178391554e-01 4.14512221157785298863984735362465e-01 2.06482847657084344142330856186618e-03
 	 1.14860142044815705109073178391554e-01 4.70627636797398996026942086245981e-01 2.06482847657084344142330856186618e-03
 	 4.70627636797398996026942086245981e-01 4.14512221157785298863984735362465e-01 2.06482847657084344142330856186618e-03
 	 4.70627636797398996026942086245981e-01 1.14860142044815705109073178391554e-01 2.06482847657084344142330856186618e-03
 	 3.62380512268927423846776036953088e-01 3.12648361867088886434373762313044e-02 1.07714145866373263785154001936917e-03
 	 3.62380512268927423846776036953088e-01 6.06354651544363631998635355557781e-01 1.07714145866373263785154001936917e-03
 	 3.12648361867088886434373762313044e-02 3.62380512268927423846776036953088e-01 1.07714145866373263785154001936917e-03
 	 3.12648361867088886434373762313044e-02 6.06354651544363631998635355557781e-01 1.07714145866373263785154001936917e-03
 	 6.06354651544363631998635355557781e-01 3.62380512268927423846776036953088e-01 1.07714145866373263785154001936917e-03
 	 6.06354651544363631998635355557781e-01 3.12648361867088886434373762313044e-02 1.07714145866373263785154001936917e-03
 	 3.12251285511203513500788631063187e-01 1.02246640145541758948333210810233e-01 1.73797610083554522619753157641753e-03
 	 3.12251285511203513500788631063187e-01 5.85502074343254741428665965941036e-01 1.73797610083554522619753157641753e-03
 	 1.02246640145541758948333210810233e-01 3.12251285511203513500788631063187e-01 1.73797610083554522619753157641753e-03
 	 1.02246640145541758948333210810233e-01 5.85502074343254741428665965941036e-01 1.73797610083554522619753157641753e-03
 	 5.85502074343254741428665965941036e-01 3.12251285511203513500788631063187e-01 1.73797610083554522619753157641753e-03
 	 5.85502074343254741428665965941036e-01 1.02246640145541758948333210810233e-01 1.73797610083554522619753157641753e-03
 	 3.92689321703687865827703262766590e-01 4.83493018730729307019799989575404e-02 1.35330712719854790934692623238789e-03
 	 3.92689321703687865827703262766590e-01 5.58961376423239175714741122646956e-01 1.35330712719854790934692623238789e-03
 	 4.83493018730729307019799989575404e-02 3.92689321703687865827703262766590e-01 1.35330712719854790934692623238789e-03
 	 4.83493018730729307019799989575404e-02 5.58961376423239175714741122646956e-01 1.35330712719854790934692623238789e-03
 	 5.58961376423239175714741122646956e-01 3.92689321703687865827703262766590e-01 1.35330712719854790934692623238789e-03
 	 5.58961376423239175714741122646956e-01 4.83493018730729307019799989575404e-02 1.35330712719854790934692623238789e-03
 	 2.60638541622880276493745554944326e-02 9.97957692964265841162330161751015e-03 1.92889643491063510552518955876167e-04
 	 2.60638541622880276493745554944326e-02 9.63956568908069244550063103815774e-01 1.92889643491063510552518955876167e-04
 	 9.97957692964265841162330161751015e-03 2.60638541622880276493745554944326e-02 1.92889643491063510552518955876167e-04
 	 9.97957692964265841162330161751015e-03 9.63956568908069244550063103815774e-01 1.92889643491063510552518955876167e-04
 	 9.63956568908069244550063103815774e-01 2.60638541622880276493745554944326e-02 1.92889643491063510552518955876167e-04
 	 9.63956568908069244550063103815774e-01 9.97957692964265841162330161751015e-03 1.92889643491063510552518955876167e-04
 	 3.98390995844955408955456732655875e-01 8.39129407699283902388742717448622e-02 1.71983321461281020089972848552407e-03
 	 3.98390995844955408955456732655875e-01 5.17696063385116200805668995599262e-01 1.71983321461281020089972848552407e-03
 	 8.39129407699283902388742717448622e-02 3.98390995844955408955456732655875e-01 1.71983321461281020089972848552407e-03
 	 8.39129407699283902388742717448622e-02 5.17696063385116200805668995599262e-01 1.71983321461281020089972848552407e-03
 	 5.17696063385116200805668995599262e-01 3.98390995844955408955456732655875e-01 1.71983321461281020089972848552407e-03
 	 5.17696063385116200805668995599262e-01 8.39129407699283902388742717448622e-02 1.71983321461281020089972848552407e-03
 	 4.58803913209149261120955998194404e-02 6.72813170128427201488463538225915e-03 2.19013468545185558799398561902194e-04
 	 4.58803913209149261120955998194404e-02 9.47391476977800794934125860891072e-01 2.19013468545185558799398561902194e-04
 	 6.72813170128427201488463538225915e-03 4.58803913209149261120955998194404e-02 2.19013468545185558799398561902194e-04
 	 6.72813170128427201488463538225915e-03 9.47391476977800794934125860891072e-01 2.19013468545185558799398561902194e-04
 	 9.47391476977800794934125860891072e-01 4.58803913209149261120955998194404e-02 2.19013468545185558799398561902194e-04
 	 9.47391476977800794934125860891072e-01 6.72813170128427201488463538225915e-03 2.19013468545185558799398561902194e-04
 	 2.51098307865166847641091862897156e-01 1.77308024832368460455001013542642e-01 2.20300726390513504013290990712903e-03
 	 2.51098307865166847641091862897156e-01 5.71593667302464636392755892302375e-01 2.20300726390513504013290990712903e-03
 	 1.77308024832368460455001013542642e-01 2.51098307865166847641091862897156e-01 2.20300726390513504013290990712903e-03
 	 1.77308024832368460455001013542642e-01 5.71593667302464636392755892302375e-01 2.20300726390513504013290990712903e-03
 	 5.71593667302464636392755892302375e-01 2.51098307865166847641091862897156e-01 2.20300726390513504013290990712903e-03
 	 5.71593667302464636392755892302375e-01 1.77308024832368460455001013542642e-01 2.20300726390513504013290990712903e-03
 	 1.83136933934611223495636522784480e-01 4.26840877350856129357481449915213e-02 1.00875040422768917983131764515292e-03
 	 1.83136933934611223495636522784480e-01 7.74178978330303246835342179110739e-01 1.00875040422768917983131764515292e-03
 	 4.26840877350856129357481449915213e-02 1.83136933934611223495636522784480e-01 1.00875040422768917983131764515292e-03
 	 4.26840877350856129357481449915213e-02 7.74178978330303246835342179110739e-01 1.00875040422768917983131764515292e-03
 	 7.74178978330303246835342179110739e-01 1.83136933934611223495636522784480e-01 1.00875040422768917983131764515292e-03
 	 7.74178978330303246835342179110739e-01 4.26840877350856129357481449915213e-02 1.00875040422768917983131764515292e-03
 	 3.54046303278362339828078120262944e-01 7.43927680400381513559082691244839e-02 1.61913930227482790596971184982067e-03
 	 3.54046303278362339828078120262944e-01 5.71560928681599578204952649684856e-01 1.61913930227482790596971184982067e-03
 	 7.43927680400381513559082691244839e-02 3.54046303278362339828078120262944e-01 1.61913930227482790596971184982067e-03
 	 7.43927680400381513559082691244839e-02 5.71560928681599578204952649684856e-01 1.61913930227482790596971184982067e-03
 	 5.71560928681599578204952649684856e-01 3.54046303278362339828078120262944e-01 1.61913930227482790596971184982067e-03
 	 5.71560928681599578204952649684856e-01 7.43927680400381513559082691244839e-02 1.61913930227482790596971184982067e-03
 	 2.99210987110167137004168580460828e-01 2.43568947797036305935591826710152e-01 2.33310539959698682449529272275868e-03
 	 2.99210987110167137004168580460828e-01 4.57220065092796557060239592829021e-01 2.33310539959698682449529272275868e-03
 	 2.43568947797036305935591826710152e-01 2.99210987110167137004168580460828e-01 2.33310539959698682449529272275868e-03
 	 2.43568947797036305935591826710152e-01 4.57220065092796557060239592829021e-01 2.33310539959698682449529272275868e-03
 	 4.57220065092796557060239592829021e-01 2.99210987110167137004168580460828e-01 2.33310539959698682449529272275868e-03
 	 4.57220065092796557060239592829021e-01 2.43568947797036305935591826710152e-01 2.33310539959698682449529272275868e-03
 	 2.90839232985411644261120045484859e-01 7.63915697459878195729743310948834e-02 1.57961290887743683979127506944451e-03
 	 2.90839232985411644261120045484859e-01 6.32769197268600480654754392162431e-01 1.57961290887743683979127506944451e-03
 	 7.63915697459878195729743310948834e-02 2.90839232985411644261120045484859e-01 1.57961290887743683979127506944451e-03
 	 7.63915697459878195729743310948834e-02 6.32769197268600480654754392162431e-01 1.57961290887743683979127506944451e-03
 	 6.32769197268600480654754392162431e-01 2.90839232985411644261120045484859e-01 1.57961290887743683979127506944451e-03
 	 6.32769197268600480654754392162431e-01 7.63915697459878195729743310948834e-02 1.57961290887743683979127506944451e-03
 	 1.86146131853306973091832787758904e-01 1.24224589668886137294734339775459e-01 1.73679225922312432603411558318385e-03
 	 1.86146131853306973091832787758904e-01 6.89629278477806861857857256836724e-01 1.73679225922312432603411558318385e-03
 	 1.24224589668886137294734339775459e-01 1.86146131853306973091832787758904e-01 1.73679225922312432603411558318385e-03
 	 1.24224589668886137294734339775459e-01 6.89629278477806861857857256836724e-01 1.73679225922312432603411558318385e-03
 	 6.89629278477806861857857256836724e-01 1.86146131853306973091832787758904e-01 1.73679225922312432603411558318385e-03
 	 6.89629278477806861857857256836724e-01 1.24224589668886137294734339775459e-01 1.73679225922312432603411558318385e-03
 	 1.33627174971224615962483994735521e-01 9.77900837056553014214888008837079e-03 4.47696440204899202396776614065743e-04
 	 1.33627174971224615962483994735521e-01 8.56593816658209883385666216781829e-01 4.47696440204899202396776614065743e-04
 	 9.77900837056553014214888008837079e-03 1.33627174971224615962483994735521e-01 4.47696440204899202396776614065743e-04
 	 9.77900837056553014214888008837079e-03 8.56593816658209883385666216781829e-01 4.47696440204899202396776614065743e-04
 	 8.56593816658209883385666216781829e-01 1.33627174971224615962483994735521e-01 4.47696440204899202396776614065743e-04
 	 8.56593816658209883385666216781829e-01 9.77900837056553014214888008837079e-03 4.47696440204899202396776614065743e-04
 	 6.89763351482116093826846281444887e-02 2.79432020481641396614236327877734e-02 5.40239241812688879978976430606963e-04
 	 6.89763351482116093826846281444887e-02 9.03080462803624306467042970325565e-01 5.40239241812688879978976430606963e-04
 	 2.79432020481641396614236327877734e-02 6.89763351482116093826846281444887e-02 5.40239241812688879978976430606963e-04
 	 2.79432020481641396614236327877734e-02 9.03080462803624306467042970325565e-01 5.40239241812688879978976430606963e-04
 	 9.03080462803624306467042970325565e-01 6.89763351482116093826846281444887e-02 5.40239241812688879978976430606963e-04
 	 9.03080462803624306467042970325565e-01 2.79432020481641396614236327877734e-02 5.40239241812688879978976430606963e-04
 	 2.61491019269808000480281862110132e-01 2.48082685108521189265573525517539e-02 9.06487224554972039099187686161940e-04
 	 2.61491019269808000480281862110132e-01 7.13700712219339838959797361894744e-01 9.06487224554972039099187686161940e-04
 	 2.48082685108521189265573525517539e-02 2.61491019269808000480281862110132e-01 9.06487224554972039099187686161940e-04
 	 2.48082685108521189265573525517539e-02 7.13700712219339838959797361894744e-01 9.06487224554972039099187686161940e-04
 	 7.13700712219339838959797361894744e-01 2.61491019269808000480281862110132e-01 9.06487224554972039099187686161940e-04
 	 7.13700712219339838959797361894744e-01 2.48082685108521189265573525517539e-02 9.06487224554972039099187686161940e-04
 	 4.39794560591167671415036011239863e-02 2.11260004278838765812142952427166e-02 3.82578565243166029627430724247006e-04
 	 4.39794560591167671415036011239863e-02 9.34894543512999276480002208700171e-01 3.82578565243166029627430724247006e-04
 	 2.11260004278838765812142952427166e-02 4.39794560591167671415036011239863e-02 3.82578565243166029627430724247006e-04
 	 2.11260004278838765812142952427166e-02 9.34894543512999276480002208700171e-01 3.82578565243166029627430724247006e-04
 	 9.34894543512999276480002208700171e-01 4.39794560591167671415036011239863e-02 3.82578565243166029627430724247006e-04
 	 9.34894543512999276480002208700171e-01 2.11260004278838765812142952427166e-02 3.82578565243166029627430724247006e-04
 	 2.46957231707310764790008761337958e-01 6.81498702540452999665276934138092e-02 1.42884085213951976880975003325602e-03
 	 2.46957231707310764790008761337958e-01 6.84892898038643949121251353062689e-01 1.42884085213951976880975003325602e-03
 	 6.81498702540452999665276934138092e-02 2.46957231707310764790008761337958e-01 1.42884085213951976880975003325602e-03
 	 6.81498702540452999665276934138092e-02 6.84892898038643949121251353062689e-01 1.42884085213951976880975003325602e-03
 	 6.84892898038643949121251353062689e-01 2.46957231707310764790008761337958e-01 1.42884085213951976880975003325602e-03
 	 6.84892898038643949121251353062689e-01 6.81498702540452999665276934138092e-02 1.42884085213951976880975003325602e-03
 	 1.91607302979841132017924110186868e-01 6.87953069004346856596399106820172e-02 1.32790604527584579774845963129337e-03
 	 1.91607302979841132017924110186868e-01 7.39597390119724251711375018203398e-01 1.32790604527584579774845963129337e-03
 	 6.87953069004346856596399106820172e-02 1.91607302979841132017924110186868e-01 1.32790604527584579774845963129337e-03
 	 6.87953069004346856596399106820172e-02 7.39597390119724251711375018203398e-01 1.32790604527584579774845963129337e-03
 	 7.39597390119724251711375018203398e-01 1.91607302979841132017924110186868e-01 1.32790604527584579774845963129337e-03
 	 7.39597390119724251711375018203398e-01 6.87953069004346856596399106820172e-02 1.32790604527584579774845963129337e-03
 	 3.17395982308531277027441319660284e-01 1.56353477120021455704090840299614e-01 2.23871881055322892103975895849999e-03
 	 3.17395982308531277027441319660284e-01 5.26250540571447267268467840040103e-01 2.23871881055322892103975895849999e-03
 	 1.56353477120021455704090840299614e-01 3.17395982308531277027441319660284e-01 2.23871881055322892103975895849999e-03
 	 1.56353477120021455704090840299614e-01 5.26250540571447267268467840040103e-01 2.23871881055322892103975895849999e-03
 	 5.26250540571447267268467840040103e-01 3.17395982308531277027441319660284e-01 2.23871881055322892103975895849999e-03
 	 5.26250540571447267268467840040103e-01 1.56353477120021455704090840299614e-01 2.23871881055322892103975895849999e-03
 	 3.93839306299842706327041241820552e-01 1.57887711356747735547134681155512e-02 8.26758630636717029363524922302986e-04
 	 3.93839306299842706327041241820552e-01 5.90371922564482565221055665460881e-01 8.26758630636717029363524922302986e-04
 	 1.57887711356747735547134681155512e-02 3.93839306299842706327041241820552e-01 8.26758630636717029363524922302986e-04
 	 1.57887711356747735547134681155512e-02 5.90371922564482565221055665460881e-01 8.26758630636717029363524922302986e-04
 	 5.90371922564482565221055665460881e-01 3.93839306299842706327041241820552e-01 8.26758630636717029363524922302986e-04
 	 5.90371922564482565221055665460881e-01 1.57887711356747735547134681155512e-02 8.26758630636717029363524922302986e-04
 	 3.18144668212785697303246479350491e-01 2.34464079672303087054086034868305e-02 9.72494817857270585359508174860821e-04
 	 3.18144668212785697303246479350491e-01 6.58408923819983948888534541765694e-01 9.72494817857270585359508174860821e-04
 	 2.34464079672303087054086034868305e-02 3.18144668212785697303246479350491e-01 9.72494817857270585359508174860821e-04
 	 2.34464079672303087054086034868305e-02 6.58408923819983948888534541765694e-01 9.72494817857270585359508174860821e-04
 	 6.58408923819983948888534541765694e-01 3.18144668212785697303246479350491e-01 9.72494817857270585359508174860821e-04
 	 6.58408923819983948888534541765694e-01 2.34464079672303087054086034868305e-02 9.72494817857270585359508174860821e-04
 	 2.80364487557996810984661806287477e-01 1.35929813471386190526501991371333e-01 2.02725879035876898129342471577274e-03
 	 2.80364487557996810984661806287477e-01 5.83705698970616970733260586712277e-01 2.02725879035876898129342471577274e-03
 	 1.35929813471386190526501991371333e-01 2.80364487557996810984661806287477e-01 2.02725879035876898129342471577274e-03
 	 1.35929813471386190526501991371333e-01 5.83705698970616970733260586712277e-01 2.02725879035876898129342471577274e-03
 	 5.83705698970616970733260586712277e-01 2.80364487557996810984661806287477e-01 2.02725879035876898129342471577274e-03
 	 5.83705698970616970733260586712277e-01 1.35929813471386190526501991371333e-01 2.02725879035876898129342471577274e-03
 	 2.29975730084156670951500700539327e-01 4.46955970130420640606949689299654e-02 1.17359850493396820729496976554174e-03
 	 2.29975730084156670951500700539327e-01 7.25328672902801230293334810994565e-01 1.17359850493396820729496976554174e-03
 	 4.46955970130420640606949689299654e-02 2.29975730084156670951500700539327e-01 1.17359850493396820729496976554174e-03
 	 4.46955970130420640606949689299654e-02 7.25328672902801230293334810994565e-01 1.17359850493396820729496976554174e-03
 	 7.25328672902801230293334810994565e-01 2.29975730084156670951500700539327e-01 1.17359850493396820729496976554174e-03
 	 7.25328672902801230293334810994565e-01 4.46955970130420640606949689299654e-02 1.17359850493396820729496976554174e-03
 	 3.49488125037135055617198986510630e-01 2.46056250689159622391244397476839e-01 2.70989834094576519107899770233416e-03
 	 3.49488125037135055617198986510630e-01 4.04455624273705294235981000383617e-01 2.70989834094576519107899770233416e-03
 	 2.46056250689159622391244397476839e-01 3.49488125037135055617198986510630e-01 2.70989834094576519107899770233416e-03
 	 2.46056250689159622391244397476839e-01 4.04455624273705294235981000383617e-01 2.70989834094576519107899770233416e-03
 	 4.04455624273705294235981000383617e-01 3.49488125037135055617198986510630e-01 2.70989834094576519107899770233416e-03
 	 4.04455624273705294235981000383617e-01 2.46056250689159622391244397476839e-01 2.70989834094576519107899770233416e-03
 	 9.64083579062224721445417685572465e-02 1.07634727377168594453227257190520e-02 4.10709557778086346933182904095361e-04
 	 9.64083579062224721445417685572465e-02 8.92828169356060685757370265491772e-01 4.10709557778086346933182904095361e-04
 	 1.07634727377168594453227257190520e-02 9.64083579062224721445417685572465e-02 4.10709557778086346933182904095361e-04
 	 1.07634727377168594453227257190520e-02 8.92828169356060685757370265491772e-01 4.10709557778086346933182904095361e-04
 	 8.92828169356060685757370265491772e-01 9.64083579062224721445417685572465e-02 4.10709557778086346933182904095361e-04
 	 8.92828169356060685757370265491772e-01 1.07634727377168594453227257190520e-02 4.10709557778086346933182904095361e-04
 	 1.00338007966599584985800674985512e-01 2.67977697259694710996136279845814e-02 6.66561537390982276028716935201146e-04
 	 1.00338007966599584985800674985512e-01 8.72864222307430881464540561864851e-01 6.66561537390982276028716935201146e-04
 	 2.67977697259694710996136279845814e-02 1.00338007966599584985800674985512e-01 6.66561537390982276028716935201146e-04
 	 2.67977697259694710996136279845814e-02 8.72864222307430881464540561864851e-01 6.66561537390982276028716935201146e-04
 	 8.72864222307430881464540561864851e-01 1.00338007966599584985800674985512e-01 6.66561537390982276028716935201146e-04
 	 8.72864222307430881464540561864851e-01 2.67977697259694710996136279845814e-02 6.66561537390982276028716935201146e-04
 	 2.89437843083978907365860777645139e-01 1.99901656639539293536245168070309e-01 2.33630115192034115353947321125361e-03
 	 2.89437843083978907365860777645139e-01 5.10660500276481799097894054284552e-01 2.33630115192034115353947321125361e-03
 	 1.99901656639539293536245168070309e-01 2.89437843083978907365860777645139e-01 2.33630115192034115353947321125361e-03
 	 1.99901656639539293536245168070309e-01 5.10660500276481799097894054284552e-01 2.33630115192034115353947321125361e-03
 	 5.10660500276481799097894054284552e-01 2.89437843083978907365860777645139e-01 2.33630115192034115353947321125361e-03
 	 5.10660500276481799097894054284552e-01 1.99901656639539293536245168070309e-01 2.33630115192034115353947321125361e-03
 	 1.78616453955091902816576521217939e-01 9.65979284760496922923600493504637e-03 5.23674622175512513577722017998894e-04
 	 1.78616453955091902816576521217939e-01 8.11723753197303166118103945336770e-01 5.23674622175512513577722017998894e-04
 	 9.65979284760496922923600493504637e-03 1.78616453955091902816576521217939e-01 5.23674622175512513577722017998894e-04
 	 9.65979284760496922923600493504637e-03 8.11723753197303166118103945336770e-01 5.23674622175512513577722017998894e-04
 	 8.11723753197303166118103945336770e-01 1.78616453955091902816576521217939e-01 5.23674622175512513577722017998894e-04
 	 8.11723753197303166118103945336770e-01 9.65979284760496922923600493504637e-03 5.23674622175512513577722017998894e-04
 	 2.86153922631251944608266057912260e-01 4.36162890256223956253478490907582e-02 1.27850641044706804343167316773133e-03
 	 2.86153922631251944608266057912260e-01 6.70229788343125632010810477368068e-01 1.27850641044706804343167316773133e-03
 	 4.36162890256223956253478490907582e-02 2.86153922631251944608266057912260e-01 1.27850641044706804343167316773133e-03
 	 4.36162890256223956253478490907582e-02 6.70229788343125632010810477368068e-01 1.27850641044706804343167316773133e-03
 	 6.70229788343125632010810477368068e-01 2.86153922631251944608266057912260e-01 1.27850641044706804343167316773133e-03
 	 6.70229788343125632010810477368068e-01 4.36162890256223956253478490907582e-02 1.27850641044706804343167316773133e-03
 	 2.29328895960897921613153016551223e-01 9.63379554976936600119152842580661e-03 5.76882964065722893091947565125110e-04
 	 2.29328895960897921613153016551223e-01 7.61037308489332708916208503069356e-01 5.76882964065722893091947565125110e-04
 	 9.63379554976936600119152842580661e-03 2.29328895960897921613153016551223e-01 5.76882964065722893091947565125110e-04
 	 9.63379554976936600119152842580661e-03 7.61037308489332708916208503069356e-01 5.76882964065722893091947565125110e-04
 	 7.61037308489332708916208503069356e-01 2.29328895960897921613153016551223e-01 5.76882964065722893091947565125110e-04
 	 7.61037308489332708916208503069356e-01 9.63379554976936600119152842580661e-03 5.76882964065722893091947565125110e-04
 	 3.54212896166471558068167269084370e-01 1.16457002151752600505041357337177e-01 2.11187879154452759836169128959682e-03
 	 3.54212896166471558068167269084370e-01 5.29330101681775855304579181392910e-01 2.11187879154452759836169128959682e-03
 	 1.16457002151752600505041357337177e-01 3.54212896166471558068167269084370e-01 2.11187879154452759836169128959682e-03
 	 1.16457002151752600505041357337177e-01 5.29330101681775855304579181392910e-01 2.11187879154452759836169128959682e-03
 	 5.29330101681775855304579181392910e-01 3.54212896166471558068167269084370e-01 2.11187879154452759836169128959682e-03
 	 5.29330101681775855304579181392910e-01 1.16457002151752600505041357337177e-01 2.11187879154452759836169128959682e-03
 	 3.44944491544985354369856622724910e-01 9.47687714910445087868051672330694e-03 6.68708757251548421840503522162180e-04
 	 3.44944491544985354369856622724910e-01 6.45578631305910199955633288482204e-01 6.68708757251548421840503522162180e-04
 	 9.47687714910445087868051672330694e-03 3.44944491544985354369856622724910e-01 6.68708757251548421840503522162180e-04
 	 9.47687714910445087868051672330694e-03 6.45578631305910199955633288482204e-01 6.68708757251548421840503522162180e-04
 	 6.45578631305910199955633288482204e-01 3.44944491544985354369856622724910e-01 6.68708757251548421840503522162180e-04
 	 6.45578631305910199955633288482204e-01 9.47687714910445087868051672330694e-03 6.68708757251548421840503522162180e-04
 	 4.31673230823553855106666787833092e-01 2.79666162959972923462981242437309e-02 1.19071165228710378405918568489597e-03
 	 4.31673230823553855106666787833092e-01 5.40360152880448918466527175041847e-01 1.19071165228710378405918568489597e-03
 	 2.79666162959972923462981242437309e-02 4.31673230823553855106666787833092e-01 1.19071165228710378405918568489597e-03
 	 2.79666162959972923462981242437309e-02 5.40360152880448918466527175041847e-01 1.19071165228710378405918568489597e-03
 	 5.40360152880448918466527175041847e-01 4.31673230823553855106666787833092e-01 1.19071165228710378405918568489597e-03
 	 5.40360152880448918466527175041847e-01 2.79666162959972923462981242437309e-02 1.19071165228710378405918568489597e-03
 	 2.20797223751839605254687626256782e-01 1.47265844196796946707905817675055e-01 2.14142622600952065373136612436156e-03
 	 2.20797223751839605254687626256782e-01 6.31936932051363475792982171697076e-01 2.14142622600952065373136612436156e-03
 	 1.47265844196796946707905817675055e-01 2.20797223751839605254687626256782e-01 2.14142622600952065373136612436156e-03
 	 1.47265844196796946707905817675055e-01 6.31936932051363475792982171697076e-01 2.14142622600952065373136612436156e-03
 	 6.31936932051363475792982171697076e-01 2.20797223751839605254687626256782e-01 2.14142622600952065373136612436156e-03
 	 6.31936932051363475792982171697076e-01 1.47265844196796946707905817675055e-01 2.14142622600952065373136612436156e-03
 	 1.53172835097684312266608230856946e-01 1.87056691103424949790268172478136e-03 2.20346979268820907264456177010459e-04
 	 1.53172835097684312266608230856946e-01 8.44956597991281421755616065638606e-01 2.20346979268820907264456177010459e-04
 	 1.87056691103424949790268172478136e-03 1.53172835097684312266608230856946e-01 2.20346979268820907264456177010459e-04
 	 1.87056691103424949790268172478136e-03 8.44956597991281421755616065638606e-01 2.20346979268820907264456177010459e-04
 	 8.44956597991281421755616065638606e-01 1.53172835097684312266608230856946e-01 2.20346979268820907264456177010459e-04
 	 8.44956597991281421755616065638606e-01 1.87056691103424949790268172478136e-03 2.20346979268820907264456177010459e-04
 	 9.19861676581091788906796580249647e-03 2.06714017852669502614548768804070e-03 5.78226288753999324940974213760114e-05
 	 9.19861676581091788906796580249647e-03 9.88734243055662376242764821654418e-01 5.78226288753999324940974213760114e-05
 	 2.06714017852669502614548768804070e-03 9.19861676581091788906796580249647e-03 5.78226288753999324940974213760114e-05
 	 2.06714017852669502614548768804070e-03 9.88734243055662376242764821654418e-01 5.78226288753999324940974213760114e-05
 	 9.88734243055662376242764821654418e-01 9.19861676581091788906796580249647e-03 5.78226288753999324940974213760114e-05
 	 9.88734243055662376242764821654418e-01 2.06714017852669502614548768804070e-03 5.78226288753999324940974213760114e-05
 	 2.35452342574103377914607193588381e-02 2.00638084202376830098013549275038e-03 9.12125509019911059243115869499263e-05
 	 2.35452342574103377914607193588381e-02 9.74448384900565955923923411319265e-01 9.12125509019911059243115869499263e-05
 	 2.00638084202376830098013549275038e-03 2.35452342574103377914607193588381e-02 9.12125509019911059243115869499263e-05
 	 2.00638084202376830098013549275038e-03 9.74448384900565955923923411319265e-01 9.12125509019911059243115869499263e-05
 	 9.74448384900565955923923411319265e-01 2.35452342574103377914607193588381e-02 9.12125509019911059243115869499263e-05
 	 9.74448384900565955923923411319265e-01 2.00638084202376830098013549275038e-03 9.12125509019911059243115869499263e-05
 	 3.45728479718466152892375475857989e-01 1.96591992279532390419660714542260e-01 2.56755792363438494624316987824386e-03
 	 3.45728479718466152892375475857989e-01 4.57679528002001512199115040857578e-01 2.56755792363438494624316987824386e-03
 	 1.96591992279532390419660714542260e-01 3.45728479718466152892375475857989e-01 2.56755792363438494624316987824386e-03
 	 1.96591992279532390419660714542260e-01 4.57679528002001512199115040857578e-01 2.56755792363438494624316987824386e-03
 	 4.57679528002001512199115040857578e-01 3.45728479718466152892375475857989e-01 2.56755792363438494624316987824386e-03
 	 4.57679528002001512199115040857578e-01 1.96591992279532390419660714542260e-01 2.56755792363438494624316987824386e-03
 	 2.50169308812157320520697112442576e-01 1.07478866102230660728444888718514e-01 1.95252785507732634466548926610585e-03
 	 2.50169308812157320520697112442576e-01 6.42351825085612060384221422282280e-01 1.95252785507732634466548926610585e-03
 	 1.07478866102230660728444888718514e-01 2.50169308812157320520697112442576e-01 1.95252785507732634466548926610585e-03
 	 1.07478866102230660728444888718514e-01 6.42351825085612060384221422282280e-01 1.95252785507732634466548926610585e-03
 	 6.42351825085612060384221422282280e-01 2.50169308812157320520697112442576e-01 1.95252785507732634466548926610585e-03
 	 6.42351825085612060384221422282280e-01 1.07478866102230660728444888718514e-01 1.95252785507732634466548926610585e-03
 	 2.55549862601632926661920919286786e-01 1.86180935326567915596984725823404e-03 2.64108779916953542287599843163548e-04
 	 2.55549862601632926661920919286786e-01 7.42588328045101442320685691811377e-01 2.64108779916953542287599843163548e-04
 	 1.86180935326567915596984725823404e-03 2.55549862601632926661920919286786e-01 2.64108779916953542287599843163548e-04
 	 1.86180935326567915596984725823404e-03 7.42588328045101442320685691811377e-01 2.64108779916953542287599843163548e-04
 	 7.42588328045101442320685691811377e-01 2.55549862601632926661920919286786e-01 2.64108779916953542287599843163548e-04
 	 7.42588328045101442320685691811377e-01 1.86180935326567915596984725823404e-03 2.64108779916953542287599843163548e-04
 	 1.03293435262624994086522178804444e-01 5.02072925915596976476074075890210e-02 9.49531737923529233803832116933563e-04
 	 1.03293435262624994086522178804444e-01 8.46499272145815329082552125328220e-01 9.49531737923529233803832116933563e-04
 	 5.02072925915596976476074075890210e-02 1.03293435262624994086522178804444e-01 9.49531737923529233803832116933563e-04
 	 5.02072925915596976476074075890210e-02 8.46499272145815329082552125328220e-01 9.49531737923529233803832116933563e-04
 	 8.46499272145815329082552125328220e-01 1.03293435262624994086522178804444e-01 9.49531737923529233803832116933563e-04
 	 8.46499272145815329082552125328220e-01 5.02072925915596976476074075890210e-02 9.49531737923529233803832116933563e-04
 	 1.13482779190540200575654239401047e-01 7.90987667568746055657413762673968e-02 1.16702965608184898796406692156324e-03
 	 1.13482779190540200575654239401047e-01 8.07418454052585277125331231218297e-01 1.16702965608184898796406692156324e-03
 	 7.90987667568746055657413762673968e-02 1.13482779190540200575654239401047e-01 1.16702965608184898796406692156324e-03
 	 7.90987667568746055657413762673968e-02 8.07418454052585277125331231218297e-01 1.16702965608184898796406692156324e-03
 	 8.07418454052585277125331231218297e-01 1.13482779190540200575654239401047e-01 1.16702965608184898796406692156324e-03
 	 8.07418454052585277125331231218297e-01 7.90987667568746055657413762673968e-02 1.16702965608184898796406692156324e-03
 	 2.02001519139572843775098931473622e-01 1.82886968001511268991365888325618e-03 2.41335338989844894793529439525059e-04
 	 2.02001519139572843775098931473622e-01 7.96169611180411962436664907727391e-01 2.41335338989844894793529439525059e-04
 	 1.82886968001511268991365888325618e-03 2.02001519139572843775098931473622e-01 2.41335338989844894793529439525059e-04
 	 1.82886968001511268991365888325618e-03 7.96169611180411962436664907727391e-01 2.41335338989844894793529439525059e-04
 	 7.96169611180411962436664907727391e-01 2.02001519139572843775098931473622e-01 2.41335338989844894793529439525059e-04
 	 7.96169611180411962436664907727391e-01 1.82886968001511268991365888325618e-03 2.41335338989844894793529439525059e-04
 	 1.55407293341666141728296679502819e-01 9.74984606749395160685267569533607e-02 1.62450972466069917810038703009923e-03
 	 1.55407293341666141728296679502819e-01 7.47094245983394356080964371358277e-01 1.62450972466069917810038703009923e-03
 	 9.74984606749395160685267569533607e-02 1.55407293341666141728296679502819e-01 1.62450972466069917810038703009923e-03
 	 9.74984606749395160685267569533607e-02 7.47094245983394356080964371358277e-01 1.62450972466069917810038703009923e-03
 	 7.47094245983394356080964371358277e-01 1.55407293341666141728296679502819e-01 1.62450972466069917810038703009923e-03
 	 7.47094245983394356080964371358277e-01 9.74984606749395160685267569533607e-02 1.62450972466069917810038703009923e-03
 	 2.83733125849908784932296157421661e-01 1.02710427379365670796929066455050e-02 6.59883458383826227745816428438275e-04
 	 2.83733125849908784932296157421661e-01 7.05995831412154717376949975005118e-01 6.59883458383826227745816428438275e-04
 	 1.02710427379365670796929066455050e-02 2.83733125849908784932296157421661e-01 6.59883458383826227745816428438275e-04
 	 1.02710427379365670796929066455050e-02 7.05995831412154717376949975005118e-01 6.59883458383826227745816428438275e-04
 	 7.05995831412154717376949975005118e-01 2.83733125849908784932296157421661e-01 6.59883458383826227745816428438275e-04
 	 7.05995831412154717376949975005118e-01 1.02710427379365670796929066455050e-02 6.59883458383826227745816428438275e-04
 	 1.10137610711961098086675292506698e-01 1.94506677452367052888471121718794e-03 1.98364630522206522068862089014374e-04
 	 1.10137610711961098086675292506698e-01 8.87917322513515183679544406913919e-01 1.98364630522206522068862089014374e-04
 	 1.94506677452367052888471121718794e-03 1.10137610711961098086675292506698e-01 1.98364630522206522068862089014374e-04
 	 1.94506677452367052888471121718794e-03 8.87917322513515183679544406913919e-01 1.98364630522206522068862089014374e-04
 	 8.87917322513515183679544406913919e-01 1.10137610711961098086675292506698e-01 1.98364630522206522068862089014374e-04
 	 8.87917322513515183679544406913919e-01 1.94506677452367052888471121718794e-03 1.98364630522206522068862089014374e-04
 	 3.11626986396292382508477203373332e-01 2.01271492926212132792973541484116e-03 2.92796720510567285832709272241914e-04
 	 3.11626986396292382508477203373332e-01 6.86360298674445479250039170437958e-01 2.92796720510567285832709272241914e-04
 	 2.01271492926212132792973541484116e-03 3.11626986396292382508477203373332e-01 2.92796720510567285832709272241914e-04
 	 2.01271492926212132792973541484116e-03 6.86360298674445479250039170437958e-01 2.92796720510567285832709272241914e-04
 	 6.86360298674445479250039170437958e-01 3.11626986396292382508477203373332e-01 2.92796720510567285832709272241914e-04
 	 6.86360298674445479250039170437958e-01 2.01271492926212132792973541484116e-03 2.92796720510567285832709272241914e-04
 	 4.56065627549956553732357633634820e-01 9.87982421462061527472897637380811e-03 7.00387442375592444120113722050291e-04
 	 4.56065627549956553732357633634820e-01 5.34054548235422754665080447011860e-01 7.00387442375592444120113722050291e-04
 	 9.87982421462061527472897637380811e-03 4.56065627549956553732357633634820e-01 7.00387442375592444120113722050291e-04
 	 9.87982421462061527472897637380811e-03 5.34054548235422754665080447011860e-01 7.00387442375592444120113722050291e-04
 	 5.34054548235422754665080447011860e-01 4.56065627549956553732357633634820e-01 7.00387442375592444120113722050291e-04
 	 5.34054548235422754665080447011860e-01 9.87982421462061527472897637380811e-03 7.00387442375592444120113722050291e-04
 	 7.40590746798509141912703057641920e-02 2.22615254701005607987362999722336e-03 1.85252774407086126572455353489488e-04
 	 7.40590746798509141912703057641920e-02 9.23714772773138959038874418183696e-01 1.85252774407086126572455353489488e-04
 	 2.22615254701005607987362999722336e-03 7.40590746798509141912703057641920e-02 1.85252774407086126572455353489488e-04
 	 2.22615254701005607987362999722336e-03 9.23714772773138959038874418183696e-01 1.85252774407086126572455353489488e-04
 	 9.23714772773138959038874418183696e-01 7.40590746798509141912703057641920e-02 1.85252774407086126572455353489488e-04
 	 9.23714772773138959038874418183696e-01 2.22615254701005607987362999722336e-03 1.85252774407086126572455353489488e-04
 	 ];
 

 	 otherwise
        
        [xyw]=set_stroud_pre(deg);

end
     

if isempty(xyw) == 0
 	 X=xyw(:,1); Y=xyw(:,2); Z=1-X-Y; W=xyw(:,3);
 	 xyw_bar=[X Y Z W./sum(W)];
end
 

 
 
 	 pointset_stats=[
 	   1    1 1.92e-16    0    0
 	   2    3 1.18e-16    0    0
 	   3    4 2.15e-16    0    0
 	   4    6 1.39e-16    0    0
 	   5    7 1.60e-16    0    0
 	   6   11 1.08e-15    0    0
 	   7   12 5.07e-16    0    0
 	   8   16 8.05e-16    0    0
 	   9   19 3.26e-16    0    0
 	  10   24 7.22e-16    0    0
 	  11   27 3.64e-15    0    0
 	  12   32 1.61e-15    0    0
 	  13   36 3.05e-16    0    0
 	  14   42 4.37e-16    0    0
 	  15   46 5.00e-16    0    0
 	  16   52 5.67e-16    0    0
 	  17   57 5.83e-16    0    0
 	  18   66 6.11e-16    0    0
 	  19   70 4.16e-16    0    0
 	  20   78 4.89e-16    0    0
 	  21   85 4.64e-16    0    0
 	  22   93 7.56e-16    0    0
 	  23  100 6.66e-16    0    0
 	  24  109 7.81e-16    0    0
 	  25  117 5.41e-16    0    0
 	  26  130 1.96e-15    0    0
 	  27  141 7.77e-16    0    0
 	  28  150 1.39e-15    0    0
 	  29  159 1.34e-15    0    0
 	  30  171 9.40e-16    0    0
 	  31  181 1.70e-15    0    0
 	  32  193 1.71e-15    0    0
 	  33  204 1.45e-15    0    0
 	  34  214 1.87e-15    0    0
 	  35  228 1.68e-15    0    0
 	  36  243 9.71e-16    0    0
 	  37  252 1.03e-15    0    0
 	  38  267 1.85e-15    0    0
 	  39  282 1.58e-15    0    0
 	  40  295 1.42e-15    0    0
 	  41  309 1.45e-15    0    0
 	  42  324 1.44e-15    0    0
 	  43  339 1.45e-15    0    0
 	  44  354 1.38e-15    0    0
 	  45  370 1.52e-15    0    0
 	  46  385 8.47e-16    0    0
 	  47  399 1.56e-15    0    0
 	  48  423 1.49e-15    0    0
 	  49  435 1.23e-15    0    0
 	  50  453 1.39e-15    0    0
 	 ];
 
 
   




function [xyw,xyw_bar]=set_stroud_pre(ade)

% INPUT:
% ade: degree of precision.
%
% OUTPUT:
% xyw determines the cubature points and weights, in BARYCENTRIC coordinates.
% nodes: xyw(:,1:3)
% weights: xyw(:,4)

xyw=stroud_conical_rules_ref(ade);
xx=xyw(:,1); yy=xyw(:,2); ww=xyw(:,3);

L2=yy;
L3=xx-L2;
L1=1-L2-L3;

ww_bar=2*ww;

xyw_bar=[L1 L2 L3 ww_bar];

xyw=xyw_bar(:,[1 3 4]);
xyw(:,3)=xyw(:,3)/2;
xyw_bar=[xyw(:,1:2) 1-xyw(:,1)-xyw(:,2) xyw(:,3)*2];







function xyw=stroud_conical_rules_ref(ade)

% SEE LYNESS, COOLS, "A survey on numerical cubature over triangles", p.4.

N=ceil((ade+1)/2);

[t,T]=gauss_jacobi(N,0,0);
t=(t+1)/2; T=T/2;

[x,w]=gauss_jacobi(N,0,1);
x=(x+1)/2; X=w/4;

[wx,wy]=meshgrid(T,X);
ww=wx.*wy;

[yt,xx]=meshgrid(x,x);

[yt,yx]=meshgrid(t,x);
yy=yt.*yx;

xyw=[xx(:) yy(:) ww(:)];






function [x,w]=gauss_jacobi(N,a,b,gl)

% GAUSS-JACOBI (LOBATTO) RULE ON (-1,1).
% N IS ...
% a,b ARE THE GAUSS-JACOBI EXPONENTS.
% gl: 0: GAUSS POINTS. 1: GAUSS-LOBATTO POINTS.
% x, w ARE COLUMN VECTORS OF NODES AND WEIGHTS.
%      THE LENGTH OF x AND w IS "N" IF gl=0, "N+2" IF "gl=1".

if nargin < 2
    a=0; b=0;
end

if nargin < 4
    gl = 0;
end

if gl == 0
    ab=r_jacobi(N,a,b);
    xw=gauss(N,ab);
else
    xw=lobatto_jacobi(N,a,b);
end

x=xw(:,1);
w=xw(:,2);




%--------------------------------------------------------------------------
% ADDITIONAL FUNCTIONS BY D.LAURIE AND W.GAUTSCHI.
%--------------------------------------------------------------------------

function ab=r_jacobi(N,a,b)

nu=(b-a)/(a+b+2);
mu=2^(a+b+1)*gamma(a+1)*gamma(b+1)/gamma(a+b+2);
if N==1
    ab=[nu mu]; return
end

N=N-1;
n=1:N;
nab=2*n+a+b;
nuadd=(b^2-a^2)*ones(1,N)./(nab.*(nab+2));
A=[nu nuadd];
n=2:N;
nab=nab(n);
B1=4*(a+1)*(b+1)/((a+b+2)^2*(a+b+3));
B=4*(n+a).*(n+b).*n.*(n+a+b)./((nab.^2).*(nab+1).*(nab-1));
abadd=[mu; B1; B'];
ab=[A' abadd];


function xw=gauss(N,ab)
N0=size(ab,1); if N0<N, error('input array ab too short'), end
J=zeros(N);
for n=1:N, J(n,n)=ab(n,1); end
for n=2:N
    J(n,n-1)=sqrt(ab(n,2));
    J(n-1,n)=J(n,n-1);
end
[V,D]=eig(J);
[D,I]=sort(diag(D));
V=V(:,I);
xw=[D ab(1,2)*V(1,:)'.^2];


function xw=lobatto_jacobi(N,a,b)

if nargin<2, a=0; end;
if nargin<3, b=a; end
ab=r_jacobi(N+2,a,b);
ab(N+2,1)=(a-b)/(2*N+a+b+2);
ab(N+2,2)=4*(N+a+1)*(N+b+1)*(N+a+b+1)/((2*N+a+b+1)*(2*N+a+b+2)^2);
xw=gauss(N+2,ab);


function [xx,ww]=rules_convert(xw)

% CONVERTING RULES FROM A REFERENCE SIMPLEX TO ANOTHER.

x=xw(:,1); y=xw(:,2); ww=xw(:,3);
pts_bar=[x y 1-x-y];
delta=0;
vertices=[-1+delta -1+delta; 1-2*delta -1+delta; -1+delta 1-2*delta];
xx=pts_bar*vertices;
ww=4*ww;
