
function [xyw_bar,pointset_stats]=set_cools_haegemans_C_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% R. Cools, A. Haegemans,
% Construction of minimal cubature formulae for the square and the triangle
% using invariant theory,
% Department of Computer Science, K.U.Leuven,
% TW Reports vol.TW96, Sept. 1987.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   8 |  15 |   0 |   3 | 3.61e-16 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    3
        % M.E.INF. : 3.6e-16
        
        xyw_bar=[
            3.45792011168270685406156417229795e-01 3.62316822156928486364790842344519e+00 -2.96896023273755549354291360941716e+00 3.21166877133605451075581878474892e-10
            3.62316822156924622788665146799758e+00 -2.96896023273751508142481725371908e+00 3.45792011168268853538165785721503e-01 3.21166877133636315252187763320010e-10
            -2.96896023273753062454716200591065e+00 3.45792011168268520471258398174541e-01 3.62316822156926221509820607025176e+00 3.21166877133624010940576037033346e-10
            6.51019934589391752188802797718381e-02 8.70165101563563081477070682012709e-01 6.47329049774977294262612304009963e-02 5.30612488695607342759075208959985e-02
            8.70165101563563081477070682012709e-01 6.47329049774977849374124616588233e-02 6.51019934589391335855168563284678e-02 5.30612488695607620314831365249120e-02
            6.47329049774977849374124616588233e-02 6.51019934589391335855168563284678e-02 8.70165101563562970454768219497055e-01 5.30612488695607828481648482465971e-02
            6.51775303648795767408330448233755e-01 3.13477887523732956509547875612043e-01 3.47468088274712760821216761542019e-02 5.85714352803318114015773687697219e-02
            3.13477887523733012020699106869870e-01 3.47468088274712830210155800614302e-02 6.51775303648795767408330448233755e-01 5.85714352803318114015773687697219e-02
            3.47468088274712691432277722469735e-02 6.51775303648795767408330448233755e-01 3.13477887523732956509547875612043e-01 5.85714352803317489515322336046665e-02
            3.13251210671725288658961972032557e-01 6.30621434318956120002042098349193e-01 5.61273550093185358278446983604226e-02 8.78191135824415436417211822117679e-02
            6.30621434318956120002042098349193e-01 5.61273550093185497056325061748794e-02 3.13251210671725344170113203290384e-01 8.78191135824415575195089900262246e-02
            5.61273550093185566445264100821078e-02 3.13251210671725344170113203290384e-01 6.30621434318956120002042098349193e-01 8.78191135824415713972967978406814e-02
            5.13346920639454085133479566138703e-01 2.81041247315110431781448596666451e-01 2.05611832045435483085071837194846e-01 1.33881535279832347695716521229770e-01
            2.81041247315110376270297365408624e-01 2.05611832045435510840647452823760e-01 5.13346920639454085133479566138703e-01 1.33881535279832319940140905600856e-01
            2.05611832045435399818344990308105e-01 5.13346920639454307178084491170011e-01 2.81041247315110265247994902892970e-01 1.33881535279832319940140905600856e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    8   15 3.61e-16    0    3
    ];




