
function [xyw,pointset_stats]=set_cools_haegemans_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% R. Cools, A. Haegemans,
% Construction of minimal cubature formulae for the square and the triangle
% using invariant theory,
% Department of Computer Science, K.U.Leuven,
% TW Reports vol.TW96, Sept. 1987,
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   8 |  15 |   0 |   3 | 6.00e-14 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    3
        % M.E.INF. : 6.0e-14
        
        xyw=[
            3.45792011168269020071619479494984e-01 3.62316822156926177100899622018915e+00 1.60583438566821802390667943438197e-10
            3.62316822156926177100899622018915e+00 -2.96896023273753062454716200591065e+00 1.60583438566821802390667943438197e-10
            -2.96896023273753062454716200591065e+00 3.45792011168269020071619479494984e-01 1.60583438566821802390667943438197e-10
            6.51019934589391613410924719573813e-02 8.70165101563563081477070682012709e-01 2.65306244347819700224455630177545e-02
            8.70165101563563081477070682012709e-01 6.47329049774977294262612304009963e-02 2.65306244347819700224455630177545e-02
            6.47329049774977294262612304009963e-02 6.51019934589391613410924719573813e-02 2.65306244347819700224455630177545e-02
            6.51775303648795656386027985718101e-01 3.13477887523733012020699106869870e-01 2.92857176401576484170430347830916e-02
            3.13477887523733012020699106869870e-01 3.47468088274713315932729074120289e-02 2.92857176401576484170430347830916e-02
            3.47468088274713315932729074120289e-02 6.51775303648795656386027985718101e-01 2.92857176401576484170430347830916e-02
            3.13251210671725288658961972032557e-01 6.30621434318956120002042098349193e-01 4.39095567912234155394379797598958e-02
            6.30621434318956120002042098349193e-01 5.61273550093185358278446983604226e-02 4.39095567912234155394379797598958e-02
            5.61273550093185358278446983604226e-02 3.13251210671725288658961972032557e-01 4.39095567912234155394379797598958e-02
            5.13346920639454196155782028654357e-01 2.81041247315110376270297365408624e-01 6.69407676399201845285347189928871e-02
            2.81041247315110376270297365408624e-01 2.05611832045435427573920605937019e-01 6.69407676399201845285347189928871e-02
            2.05611832045435427573920605937019e-01 5.13346920639454196155782028654357e-01 6.69407676399201845285347189928871e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    8   15 6.00e-14    0    3
    ];




