
function [xyw_bar,pointset_stats]=set_cowper_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  G.R. Cowper,
%  "Gaussian quadrature formulas for triangles",
%  Numerical Methods in Engineering,
%  Volume 7, Issue 3, (1973), pp. 405-408.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.24e-15 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 8.55e-15 |PI|
% |   7 |  13 |   1 |   0 | 8.65e-15 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw_bar=[
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 3.33333333333333314829616256247391e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 3.33333333333333314829616256247391e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 3.33333333333333314829616256247391e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -5.62500000000000000000000000000000e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 5.20833333333333370340767487505218e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        xyw_bar=[
            9.15762135097710067155318824916321e-02 9.15762135097710067155318824916321e-02 8.16847572980457958813360619387822e-01 1.09951743655322120574169275641907e-01
            9.15762135097710067155318824916321e-02 8.16847572980457958813360619387822e-01 9.15762135097710067155318824916321e-02 1.09951743655322120574169275641907e-01
            8.16847572980457958813360619387822e-01 9.15762135097710067155318824916321e-02 9.15762135097710067155318824916321e-02 1.09951743655322120574169275641907e-01
            4.45948490915965001235576892213430e-01 4.45948490915965001235576892213430e-01 1.08103018168069997528846215573139e-01 2.23381589678011249766598211863311e-01
            4.45948490915965001235576892213430e-01 1.08103018168069997528846215573139e-01 4.45948490915965001235576892213430e-01 2.23381589678011249766598211863311e-01
            1.08103018168069997528846215573139e-01 4.45948490915965001235576892213430e-01 4.45948490915965001235576892213430e-01 2.23381589678011249766598211863311e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.8e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.25000000000000005551115123125783e-01
            1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 1.25939180544827167285149016606738e-01
            1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 1.25939180544827167285149016606738e-01
            7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 1.25939180544827167285149016606738e-01
            4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 1.32394152788506164197812609018001e-01
            4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 1.32394152788506164197812609018001e-01
            5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 1.32394152788506164197812609018001e-01
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.5e-15
        
        xyw_bar=[
            6.30890144915020045779385782225290e-02 6.30890144915020045779385782225290e-02 8.73821971016995990844122843554942e-01 5.08449063702068951298151944229176e-02
            6.30890144915020045779385782225290e-02 8.73821971016995990844122843554942e-01 6.30890144915020045779385782225290e-02 5.08449063702068951298151944229176e-02
            8.73821971016995990844122843554942e-01 6.30890144915020045779385782225290e-02 6.30890144915020045779385782225290e-02 5.08449063702068951298151944229176e-02
            2.49286745170910012392440080475353e-01 2.49286745170910012392440080475353e-01 5.01426509658180030726271070307121e-01 1.16786275726378757644496886314300e-01
            2.49286745170910012392440080475353e-01 5.01426509658180030726271070307121e-01 2.49286745170910012392440080475353e-01 1.16786275726378757644496886314300e-01
            5.01426509658180030726271070307121e-01 2.49286745170910012392440080475353e-01 2.49286745170910012392440080475353e-01 1.16786275726378757644496886314300e-01
            6.36502499121399001325016797636636e-01 3.10352451033785003975395966335782e-01 5.31450498448159946995872360275825e-02 8.28510756183738344970990397087007e-02
            6.36502499121399001325016797636636e-01 5.31450498448159946995872360275825e-02 3.10352451033785003975395966335782e-01 8.28510756183738344970990397087007e-02
            3.10352451033785003975395966335782e-01 6.36502499121399001325016797636636e-01 5.31450498448159946995872360275825e-02 8.28510756183738344970990397087007e-02
            3.10352451033785003975395966335782e-01 5.31450498448159946995872360275825e-02 6.36502499121399001325016797636636e-01 8.28510756183738344970990397087007e-02
            5.31450498448159946995872360275825e-02 6.36502499121399001325016797636636e-01 3.10352451033785003975395966335782e-01 8.28510756183738344970990397087007e-02
            5.31450498448159946995872360275825e-02 3.10352451033785003975395966335782e-01 6.36502499121399001325016797636636e-01 8.28510756183738344970990397087007e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 8.6e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -1.49570044467669832632950033257657e-01
            2.60345966079037982598975986547885e-01 2.60345966079037982598975986547885e-01 4.79308067841924034802048026904231e-01 1.75615257433203802994725606367865e-01
            2.60345966079037982598975986547885e-01 4.79308067841924034802048026904231e-01 2.60345966079037982598975986547885e-01 1.75615257433203802994725606367865e-01
            4.79308067841924034802048026904231e-01 2.60345966079037982598975986547885e-01 2.60345966079037982598975986547885e-01 1.75615257433203802994725606367865e-01
            6.51301029022160055115264754022064e-02 6.51301029022160055115264754022064e-02 8.69739794195568016732522664824501e-01 5.33472356088389373929281589425955e-02
            6.51301029022160055115264754022064e-02 8.69739794195568016732522664824501e-01 6.51301029022160055115264754022064e-02 5.33472356088389373929281589425955e-02
            8.69739794195568016732522664824501e-01 6.51301029022160055115264754022064e-02 6.51301029022160055115264754022064e-02 5.33472356088389373929281589425955e-02
            6.38444188569809001343458021437982e-01 3.12865496004875009994350421038689e-01 4.86903154253159886621915575233288e-02 7.71137608902569132718340938481560e-02
            6.38444188569809001343458021437982e-01 4.86903154253159886621915575233288e-02 3.12865496004875009994350421038689e-01 7.71137608902569132718340938481560e-02
            3.12865496004875009994350421038689e-01 6.38444188569809001343458021437982e-01 4.86903154253159886621915575233288e-02 7.71137608902569132718340938481560e-02
            3.12865496004875009994350421038689e-01 4.86903154253159886621915575233288e-02 6.38444188569809001343458021437982e-01 7.71137608902569132718340938481560e-02
            4.86903154253159886621915575233288e-02 6.38444188569809001343458021437982e-01 3.12865496004875009994350421038689e-01 7.71137608902569132718340938481560e-02
            4.86903154253159886621915575233288e-02 3.12865496004875009994350421038689e-01 6.38444188569809001343458021437982e-01 7.71137608902569132718340938481560e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.24e-15    0    0
    5    7 4.79e-16    0    0
    6   12 8.55e-15    0    0
    7   13 8.65e-15    1    0
    ];


