
function [S1,S2,S3,pointset_stats]=set_cowper_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  G.R. Cowper,
%  "Gaussian quadrature formulas for triangles",
%  Numerical Methods in Engineering,
%  Volume 7, Issue 3, (1973), pp. 405-408.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.24e-15 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 8.55e-15 |PI|
% |   7 |  13 |   1 |   0 | 8.65e-15 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        S1=[];
        
        S2=[
            3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
            ];
        
        S3=[];
        
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        S1=[];
        
        S2=[
            5.20833333333333370340767487505218e-01 2.00000000000000011102230246251565e-01
            ];
        
        S3=[
            -5.62500000000000000000000000000000e-01
            ];
        
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        S1=[];
        
        S2=[
            1.09951743655321995674079005311796e-01 9.15762135097710067155318824916321e-02
            2.23381589678010999966417671203089e-01 4.45948490915965001235576892213430e-01
            ];
        
        S3=[];
        
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.8e-16
        
        S1=[];
        
        S2=[
            1.25939180544827167285149016606738e-01 1.01286507323456329010546994595643e-01
            1.32394152788506164197812609018001e-01 4.70142064105115053962435922585428e-01
            ];
        
        S3=[
            2.25000000000000005551115123125783e-01
            ];
        
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.5e-15
        
        S1=[
            8.28510756183740010305527334821818e-02 6.36502499121399001325016797636636e-01 3.10352451033785003975395966335782e-01
            ];
        
        S2=[
            5.08449063702069992132237530313432e-02 6.30890144915020045779385782225290e-02
            1.16786275726378993566889619160065e-01 2.49286745170910012392440080475353e-01
            ];
        
        S3=[];
        
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 8.6e-15
        
        S1=[
            7.71137608902569965385609407348966e-02 6.38444188569809001343458021437982e-01 3.12865496004875009994350421038689e-01
            ];
        
        S2=[
            1.75615257433203997283754915770260e-01 2.60345966079037982598975986547885e-01
            5.33472356088389998429732941076509e-02 6.51301029022160055115264754022064e-02
            ];
        
        S3=[
            -1.49570044467669999166403727031138e-01
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.24e-15    0    0
    5    7 4.79e-16    0    0
    6   12 8.55e-15    0    0
    7   13 8.65e-15    1    0
    ];


