
function [S1,S2,S3]=set_cowper_pre(deg)

%     G.R. Cowper,
%     Gaussian quadrature formulas for triangles,
%     Numerical Methods in Engineering,
%     Volume 7, Issue 3, 1973, Pages 405?408.

S1=[];
S2=[];
S3=[];

switch deg 
                
        %% 2:
            case 2
            
                S2=[frac(1, 3), frac(1, 2)];
                
        %% 3:
            case 3
            
                S3=[-frac(9, 16)];
                S2=[frac(25, 48), frac(1, 5)];
                
        %% 4:
            case 3
            
                S1=[frac(1, 6), 0.659027622374092, 0.231933368553031];
                
        %% 5:
            case 4
            
                S2=[0.109951743655322, 0.091576213509771
                    0.223381589678011, 0.445948490915965];
                    
                    
        %% 6:
            case 4
            
                S3=frac(3, 8);
                S1=[frac(5, 48), 0.736712498968435, 0.237932366472434];
                
        %% 7:
            case 5
            
                S3=frac(9, 40);
                S2=[0.12593918054482717, 0.10128650732345633
                    0.13239415278850616, 0.47014206410511505];
                    
                
        %% 8:
            case 5
            
                S2=[0.205950504760887, 0.437525248383384];
                S1=[0.063691414286223, 0.797112651860071, 0.165409927389841];
                    
                
        %% 9:
            case 6
            
                S2=[0.050844906370207, 0.063089014491502
                    0.116786275726379, 0.249286745170910];
                    
                S1=[0.082851075618374, 0.636502499121399, 0.310352451033785];
                    
                
        
            case 7
            
                S3=-0.149570044467670;
                S2=[+0.175615257433204, 0.260345966079038
                    +0.053347235608839, 0.065130102902216];
                    
                S1=[+0.077113760890257, 0.638444188569809, 0.312865496004875];
                    
                

    
        end