
function [xyw,pointset_stats]=set_cowper_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  G.R. Cowper,
%  "Gaussian quadrature formulas for triangles",
%  Numerical Methods in Engineering,
%  Volume 7, Issue 3, (1973), pp. 405-408.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.24e-15 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 8.55e-15 |PI|
% |   7 |  13 |   1 |   0 | 8.65e-15 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw=[
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 1.66666666666666657414808128123695e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 1.66666666666666657414808128123695e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 1.66666666666666657414808128123695e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -2.81250000000000000000000000000000e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.60416666666666685170383743752609e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        xyw=[
            9.15762135097710067155318824916321e-02 9.15762135097710067155318824916321e-02 5.49758718276610602870846378209535e-02
            9.15762135097710067155318824916321e-02 8.16847572980457958813360619387822e-01 5.49758718276610602870846378209535e-02
            8.16847572980457958813360619387822e-01 9.15762135097710067155318824916321e-02 5.49758718276610602870846378209535e-02
            4.45948490915965001235576892213430e-01 4.45948490915965001235576892213430e-01 1.11690794839005624883299105931656e-01
            4.45948490915965001235576892213430e-01 1.08103018168069997528846215573139e-01 1.11690794839005624883299105931656e-01
            1.08103018168069997528846215573139e-01 4.45948490915965001235576892213430e-01 1.11690794839005624883299105931656e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.8e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.12500000000000002775557561562891e-01
            1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 6.29695902724135836425745083033689e-02
            1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 6.29695902724135836425745083033689e-02
            7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 6.29695902724135836425745083033689e-02
            4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 6.61970763942530820989063045090006e-02
            4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 6.61970763942530820989063045090006e-02
            5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 6.61970763942530820989063045090006e-02
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.5e-15
        
        xyw=[
            6.30890144915020045779385782225290e-02 6.30890144915020045779385782225290e-02 2.54224531851034475649075972114588e-02
            6.30890144915020045779385782225290e-02 8.73821971016995990844122843554942e-01 2.54224531851034475649075972114588e-02
            8.73821971016995990844122843554942e-01 6.30890144915020045779385782225290e-02 2.54224531851034475649075972114588e-02
            2.49286745170910012392440080475353e-01 2.49286745170910012392440080475353e-01 5.83931378631893788222484431571502e-02
            2.49286745170910012392440080475353e-01 5.01426509658180030726271070307121e-01 5.83931378631893788222484431571502e-02
            5.01426509658180030726271070307121e-01 2.49286745170910012392440080475353e-01 5.83931378631893788222484431571502e-02
            6.36502499121399001325016797636636e-01 3.10352451033785003975395966335782e-01 4.14255378091869172485495198543504e-02
            6.36502499121399001325016797636636e-01 5.31450498448159946995872360275825e-02 4.14255378091869172485495198543504e-02
            3.10352451033785003975395966335782e-01 6.36502499121399001325016797636636e-01 4.14255378091869172485495198543504e-02
            3.10352451033785003975395966335782e-01 5.31450498448159946995872360275825e-02 4.14255378091869172485495198543504e-02
            5.31450498448159946995872360275825e-02 6.36502499121399001325016797636636e-01 4.14255378091869172485495198543504e-02
            5.31450498448159946995872360275825e-02 3.10352451033785003975395966335782e-01 4.14255378091869172485495198543504e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 8.6e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -7.47850222338349163164750166288286e-02
            2.60345966079037982598975986547885e-01 2.60345966079037982598975986547885e-01 8.78076287166019014973628031839326e-02
            2.60345966079037982598975986547885e-01 4.79308067841924034802048026904231e-01 8.78076287166019014973628031839326e-02
            4.79308067841924034802048026904231e-01 2.60345966079037982598975986547885e-01 8.78076287166019014973628031839326e-02
            6.51301029022160055115264754022064e-02 6.51301029022160055115264754022064e-02 2.66736178044194686964640794712977e-02
            6.51301029022160055115264754022064e-02 8.69739794195568016732522664824501e-01 2.66736178044194686964640794712977e-02
            8.69739794195568016732522664824501e-01 6.51301029022160055115264754022064e-02 2.66736178044194686964640794712977e-02
            6.38444188569809001343458021437982e-01 3.12865496004875009994350421038689e-01 3.85568804451284566359170469240780e-02
            6.38444188569809001343458021437982e-01 4.86903154253159886621915575233288e-02 3.85568804451284566359170469240780e-02
            3.12865496004875009994350421038689e-01 6.38444188569809001343458021437982e-01 3.85568804451284566359170469240780e-02
            3.12865496004875009994350421038689e-01 4.86903154253159886621915575233288e-02 3.85568804451284566359170469240780e-02
            4.86903154253159886621915575233288e-02 6.38444188569809001343458021437982e-01 3.85568804451284566359170469240780e-02
            4.86903154253159886621915575233288e-02 3.12865496004875009994350421038689e-01 3.85568804451284566359170469240780e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.24e-15    0    0
    5    7 4.79e-16    0    0
    6   12 8.55e-15    0    0
    7   13 8.65e-15    1    0
    ];




