
function [xyw_bar,pointset_stats]=set_day_taylor_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  D.M. Day and M.A. Taylor,
%  "A new 11 point degree 6 formula for the triangle",
%  PAMM Proc. Appl. Math. Mech. 7 1022501-1022502 (2007).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   6 |  11 |   0 |   0 | 1.08e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   11
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.1e-15
        
        xyw_bar=[
            5.72549866774768601018763547472190e-02 8.95498146789879490015096052957233e-01 4.72468665326436498830275922955479e-02 3.80680718529555969786848379499133e-02
            8.95362640024579103936730462010019e-01 6.18282212503219533172860167269391e-02 4.28091387250989427459835212630423e-02 3.83793553077528201700197030277195e-02
            6.84475748456514043738252439652570e-01 2.33437384976827311255931363120908e-02 2.92180513045803225136154424035340e-01 4.62004567445618366527959608447418e-02
            6.87462559150295304810640573123237e-02 6.00302757472630024726534259116306e-02 8.71223468337707362962873958167620e-01 5.34675894441989998928654870269384e-02
            6.15676205575839574635210738051683e-01 3.33461808341377174969011321081780e-01 5.08619860827832503957779408665374e-02 8.37558269657456833101605297997594e-02
            6.27946141197789464705181217141217e-01 1.59189185992151482906820092466660e-01 2.12864672810059052387998690392124e-01 1.01644833025517064561960012269992e-01
            6.29091383418635685664810353046050e-02 6.55295093705452469379224567092024e-01 2.81795767952683906543143166345544e-01 1.01861524461366953486773923032160e-01
            6.83782119205099125913704938284354e-02 3.09117685428267230385301900241757e-01 6.22504102651222912534478837187635e-01 1.11421831660001705022189355531737e-01
            2.87529458374392254960127957019722e-01 6.36426509179620181200220940809231e-01 7.60440324459875638396511021710467e-02 1.12009450262946064214020225335844e-01
            3.28783556413134614437865366198821e-01 7.70240056424634222942415817669826e-02 5.94192437944401907756741820776369e-01 1.24787571437558322817729106191109e-01
            3.12290405013644800646943622268736e-01 3.52344786445899504911949406960048e-01 3.35364808540455694441106970771216e-01 1.88403488837394827992710588659975e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    6   11 1.08e-15    0    0
    ];





