
function xyw=set_day_taylor(deg)


% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
% --------------------------------------------------------------------
% SOURCE:
% D.M. Day and M.A. Taylor
% "A new 11 point degree 6 formula for the triangle"
% PAMM Proc. Appl. Math. Mech. 7 1022501-1022502 (2007).
% --------------------------------------------------------------------


%----------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%----------------------------------------
% |   6 |  11 |   0 |   0 | 1.08e-15 |PI|
%---------------------------------------

%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   11
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.1e-15
        
        xyw=[
            5.72549866774768601019e-02 8.95498146789879490015e-01 1.90340359264777984893e-02
            8.95362640024579103937e-01 6.18282212503219533173e-02 1.91896776538764100850e-02
            6.84475748456514043738e-01 2.33437384976827311256e-02 2.31002283722809183264e-02
            6.87462559150295304811e-02 6.00302757472630024727e-02 2.67337947220994999464e-02
            6.15676205575839574635e-01 3.33461808341377174969e-01 4.18779134828728416551e-02
            6.27946141197789464705e-01 1.59189185992151482907e-01 5.08224165127585322810e-02
            6.29091383418635685665e-02 6.55295093705452469379e-01 5.09307622306834767434e-02
            6.83782119205099125914e-02 3.09117685428267230385e-01 5.57109158300008525111e-02
            2.87529458374392254960e-01 6.36426509179620181200e-01 5.60047251314730321070e-02
            3.28783556413134614438e-01 7.70240056424634222942e-02 6.23937857187791614089e-02
            3.12290405013644800647e-01 3.52344786445899504912e-01 9.42017444186974139964e-02
            ];
        
        
    otherwise
        xyw=[];
end




