
function [xyw,pointset_stats]=set_day_taylor_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  D.M. Day and M.A. Taylor,
%  "A new 11 point degree 6 formula for the triangle",
%  PAMM Proc. Appl. Math. Mech. 7 1022501-1022502 (2007).
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   6 |  11 |   0 |   0 | 1.08e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   11
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.1e-15
        
        xyw=[
            5.72549866774768601018763547472190e-02 8.95498146789879490015096052957233e-01 1.90340359264777984893424189749567e-02
            8.95362640024579103936730462010019e-01 6.18282212503219533172860167269391e-02 1.91896776538764100850098515138598e-02
            6.84475748456514043738252439652570e-01 2.33437384976827311255931363120908e-02 2.31002283722809183263979804223709e-02
            6.87462559150295304810640573123237e-02 6.00302757472630024726534259116306e-02 2.67337947220994999464327435134692e-02
            6.15676205575839574635210738051683e-01 3.33461808341377174969011321081780e-01 4.18779134828728416550802648998797e-02
            6.27946141197789464705181217141217e-01 1.59189185992151482906820092466660e-01 5.08224165127585322809800061349961e-02
            6.29091383418635685664810353046050e-02 6.55295093705452469379224567092024e-01 5.09307622306834767433869615160802e-02
            6.83782119205099125913704938284354e-02 3.09117685428267230385301900241757e-01 5.57109158300008525110946777658683e-02
            2.87529458374392254960127957019722e-01 6.36426509179620181200220940809231e-01 5.60047251314730321070101126679219e-02
            3.28783556413134614437865366198821e-01 7.70240056424634222942415817669826e-02 6.23937857187791614088645530955546e-02
            3.12290405013644800646943622268736e-01 3.52344786445899504911949406960048e-01 9.42017444186974139963552943299874e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    6   11 1.08e-15    0    0
    ];




