
function [xyw_bar,pointset_stats]=set_dedoncker_robinson_C_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  E. de Doncker and I. Robinson,
%  Algorithm 612: TRIEX: Integration Over a TRIangle Using Nonlinear
%  Extrapolation.
%  ACM Trans. Math. Softw.,
%  March 1984.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   9 |  19 |   0 |   0 | 4.86e-16 |PI|
% |  11 |  28 |   0 |   0 | 5.13e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.9e-16
        
        xyw_bar=[
            3.33333333333335313231060581529164e-01 3.33333333333331371939323162223445e-01 3.33333333333333370340767487505218e-01 9.71357962827988641318910367772332e-02
            4.89682519198736121435189261319465e-01 4.89682519198739119037355749242124e-01 2.06349616025247040163037581805838e-02 3.13347002271390021044261686711252e-02
            4.89682519198737009613608961444697e-01 2.06349616025244576855701694739764e-02 4.89682519198738452903540974148200e-01 3.13347002271386829153065889386198e-02
            2.06349616025248740192044039076791e-02 4.89682519198738286370087280374719e-01 4.89682519198736843080155267671216e-01 3.13347002271392935379701327747171e-02
            4.37089591492937801220364235632587e-01 4.37089591492935525263163754061679e-01 1.25820817014126673516472010305733e-01 7.78275410047742643993018418768770e-02
            4.37089591492937856731515466890414e-01 1.25820817014125480026720538262452e-01 4.37089591492936690997339610476047e-01 7.78275410047739035768188387010014e-02
            1.25820817014127672717194172946620e-01 4.37089591492935636285466216577333e-01 4.37089591492936635486188379218220e-01 7.78275410047747084885116919394932e-02
            1.88203535619033551773426893305441e-01 1.88203535619031997461192418086284e-01 6.23592928761934395254229457350448e-01 7.96477389272102626049942841746088e-02
            1.88203535619033968107061127739144e-01 6.23592928761932840941994982131291e-01 1.88203535619033246462095121387392e-01 7.96477389272104846495992092059168e-02
            6.23592928761936171611068857600912e-01 1.88203535619031553371982568023668e-01 1.88203535619032275016948574375419e-01 7.96477389272100128048137435143872e-02
            4.47295133944526565605848134055123e-02 4.47295133944527745217811798283947e-02 9.10540973211094617489891334116692e-01 2.55776756586980277830001284655737e-02
            4.47295133944526010494335821476852e-02 9.10540973211094728512193796632346e-01 4.47295133944526357439031016838271e-02 2.55776756586979202301446179035338e-02
            9.10540973211094395445286409085384e-01 4.47295133944528439107202189006784e-02 4.47295133944527606439933720139379e-02 2.55776756586981422747495429348419e-02
            7.41198598784497897362655294273281e-01 3.68384120547358973052354258470587e-02 2.21962989160766205332109279879660e-01 4.32835393772890222874316634715797e-02
            7.41198598784497564295747906726319e-01 2.21962989160766371865562973653141e-01 3.68384120547360638386891196205397e-02 4.32835393772892373931426845956594e-02
            3.68384120547366814002465673638653e-02 7.41198598784498008384957756788936e-01 2.21962989160765289398113964125514e-01 4.32835393772897439323976698233309e-02
            3.68384120547364454778538345181005e-02 2.21962989160765927776353123590525e-01 7.41198598784497564295747906726319e-01 4.32835393772896120934134955859918e-02
            2.21962989160765011842357807836379e-01 7.41198598784498452474167606851552e-01 3.68384120547364801723233540542424e-02 4.32835393772895010711110330703377e-02
            2.21962989160765372664840811012255e-01 3.68384120547361540443098704145086e-02 7.41198598784498452474167606851552e-01 4.32835393772891541264158377089188e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.1e-16
        
        xyw_bar=[
            3.33333333333333370340767487505218e-01 3.33333333333333425851918718763045e-01 3.33333333333333203807313793731737e-01 8.79773011622321798874679643631680e-02
            2.59891409282874893960091355893383e-02 2.59891409282874859265621836357241e-02 9.48021718143424951819042689749040e-01 8.74431155373607202352381762011646e-03
            2.59891409282874304154109523778970e-02 9.48021718143425173863647614780348e-01 2.59891409282874130681761926098261e-02 8.74431155373604600267167796801004e-03
            9.48021718143425173863647614780348e-01 2.59891409282874234765170484706687e-02 2.59891409282874026598353367489835e-02 8.74431155373606161518296175927389e-03
            9.42875026479227801301519207299862e-02 9.42875026479226968634250738432456e-02 8.11424994704154523006423005426768e-01 3.80815719939349567324526901757054e-02
            9.42875026479225719633348035131348e-02 8.11424994704154745051027930458076e-01 9.42875026479226274744860347709619e-02 3.80815719939349567324526901757054e-02
            8.11424994704154523006423005426768e-01 9.42875026479226691078494582143321e-02 9.42875026479228078857275363588997e-02 3.80815719939349497935587862684770e-02
            4.94636775017213814464867027709261e-01 4.94636775017213869976018258967088e-01 1.07264499655723155591147133236518e-02 1.88554480561312354236491728443070e-02
            4.94636775017213869976018258967088e-01 1.07264499655723381105199010221440e-02 4.94636775017213869976018258967088e-01 1.88554480561312527708839326123780e-02
            1.07264499655723311716259971149157e-02 4.94636775017213758953715796451434e-01 4.94636775017213869976018258967088e-01 1.88554480561312458319900287051496e-02
            2.07343382614511406725199549327954e-01 2.07343382614511434480775164956867e-01 5.85313234770977075527298438828439e-01 7.21596975447395122538196687855816e-02
            2.07343382614511351214048318070127e-01 5.85313234770977297571903363859747e-01 2.07343382614511351214048318070127e-01 7.21596975447394983760318609711248e-02
            5.85313234770977186549600901344093e-01 2.07343382614511434480775164956867e-01 2.07343382614511378969623933699040e-01 7.21596975447395122538196687855816e-02
            4.38907805700492037459525818121620e-01 4.38907805700492203992979511895101e-01 1.22184388599015758547494669983280e-01 6.93291387055358920843417536161724e-02
            4.38907805700492092970677049379447e-01 1.22184388599015855692009324684477e-01 4.38907805700492092970677049379447e-01 6.93291387055358782065539458017156e-02
            1.22184388599015869569797132498934e-01 4.38907805700492203992979511895101e-01 4.38907805700491870926072124348138e-01 6.93291387055358920843417536161724e-02
            6.77937654882590057248137327405857e-01 4.48416775891305116608087644181069e-02 2.77220667528279451907735619897721e-01 4.10563154292885659768508332945203e-02
            6.77937654882590057248137327405857e-01 2.77220667528279396396584388639894e-01 4.48416775891305463552782839542488e-02 4.10563154292885659768508332945203e-02
            4.48416775891304353329758214385947e-02 6.77937654882590168270439789921511e-01 2.77220667528279340885433157382067e-01 4.10563154292885520990630254800635e-02
            4.48416775891304908441270526964217e-02 2.77220667528279451907735619897721e-01 6.77937654882590057248137327405857e-01 4.10563154292885867935325450162054e-02
            2.77220667528279340885433157382067e-01 6.77937654882590279292742252437165e-01 4.48416775891303798218245901807677e-02 4.10563154292885520990630254800635e-02
            2.77220667528279451907735619897721e-01 4.48416775891304977830209566036501e-02 6.77937654882590057248137327405857e-01 4.10563154292885729157447372017486e-02
            8.58870281282636427455656757956604e-01 1.83216309617027279687061400272617e-16 1.41129718717363378255313932641002e-01 7.36238378330062240295639242049219e-03
            8.58870281282636427455656757956604e-01 1.41129718717363350499738317012088e-01 2.22044604925031308084726333618164e-16 7.36238378330061893350944046687800e-03
            9.60764621317673307808524465041727e-17 8.58870281282636427455656757956604e-01 1.41129718717363461522040779527742e-01 7.36238378330058684112513489594676e-03
            2.67828342449925385748091359346653e-16 1.41129718717363572544343242043396e-01 8.58870281282636205411051832925295e-01 7.36238378330064321963810414217733e-03
            1.41129718717363378255313932641002e-01 8.58870281282636427455656757956604e-01 2.22044604925031308084726333618164e-16 7.36238378330061199461553655964963e-03
            1.41129718717363572544343242043396e-01 1.69002612246827253665581992802680e-16 8.58870281282636205411051832925295e-01 7.36238378330062153559465443208865e-03
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    9   19 4.86e-16    0    0
    11   28 5.13e-16    0    0
    ];




