
function [xyw,pointset_stats]=set_dedoncker_robinson_C_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  E. de Doncker and I. Robinson,
%  Algorithm 612: TRIEX: Integration Over a TRIangle Using Nonlinear
%  Extrapolation.
%  ACM Trans. Math. Softw.,
%  March 1984.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   9 |  19 |   0 |   0 | 4.86e-16 |PI|
% |  11 |  28 |   0 |   0 | 5.13e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.9e-16
        
        xyw=[
            3.33333333333335313231060581529164e-01 3.33333333333331371939323162223445e-01 4.85678981413994320659455183886166e-02
            4.89682519198736121435189261319465e-01 4.89682519198739119037355749242124e-01 1.56673501135695010522130843355626e-02
            4.89682519198737009613608961444697e-01 2.06349616025244576855701694739764e-02 1.56673501135693414576532944693099e-02
            2.06349616025248740192044039076791e-02 4.89682519198738286370087280374719e-01 1.56673501135696467689850663873585e-02
            4.37089591492937801220364235632587e-01 4.37089591492935525263163754061679e-01 3.89137705023871321996509209384385e-02
            4.37089591492937856731515466890414e-01 1.25820817014125480026720538262452e-01 3.89137705023869517884094193505007e-02
            1.25820817014127672717194172946620e-01 4.37089591492935636285466216577333e-01 3.89137705023873542442558459697466e-02
            1.88203535619033551773426893305441e-01 1.88203535619031997461192418086284e-01 3.98238694636051313024971420873044e-02
            1.88203535619033968107061127739144e-01 6.23592928761932840941994982131291e-01 3.98238694636052423247996046029584e-02
            6.23592928761936171611068857600912e-01 1.88203535619031553371982568023668e-01 3.98238694636050064024068717571936e-02
            4.47295133944526565605848134055123e-02 4.47295133944527745217811798283947e-02 1.27888378293490138915000642327868e-02
            4.47295133944526010494335821476852e-02 9.10540973211094728512193796632346e-01 1.27888378293489601150723089517669e-02
            9.10540973211094395445286409085384e-01 4.47295133944528439107202189006784e-02 1.27888378293490711373747714674209e-02
            7.41198598784497897362655294273281e-01 3.68384120547358973052354258470587e-02 2.16417696886445111437158317357898e-02
            7.41198598784497564295747906726319e-01 2.21962989160766371865562973653141e-01 2.16417696886446186965713422978297e-02
            3.68384120547366814002465673638653e-02 7.41198598784498008384957756788936e-01 2.16417696886448719661988349116655e-02
            3.68384120547364454778538345181005e-02 2.21962989160765927776353123590525e-01 2.16417696886448060467067477929959e-02
            2.21962989160765011842357807836379e-01 7.41198598784498452474167606851552e-01 2.16417696886447505355555165351689e-02
            2.21962989160765372664840811012255e-01 3.68384120547361540443098704145086e-02 2.16417696886445770632079188544594e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.1e-16
        
        xyw=[
            3.33333333333333370340767487505218e-01 3.33333333333333425851918718763045e-01 4.39886505811160899437339821815840e-02
            2.59891409282874893960091355893383e-02 2.59891409282874859265621836357241e-02 4.37215577686803601176190881005823e-03
            2.59891409282874304154109523778970e-02 9.48021718143425173863647614780348e-01 4.37215577686802300133583898400502e-03
            9.48021718143425173863647614780348e-01 2.59891409282874234765170484706687e-02 4.37215577686803080759148087963695e-03
            9.42875026479227801301519207299862e-02 9.42875026479226968634250738432456e-02 1.90407859969674783662263450878527e-02
            9.42875026479225719633348035131348e-02 8.11424994704154745051027930458076e-01 1.90407859969674783662263450878527e-02
            8.11424994704154523006423005426768e-01 9.42875026479226691078494582143321e-02 1.90407859969674748967793931342385e-02
            4.94636775017213814464867027709261e-01 4.94636775017213869976018258967088e-01 9.42772402806561771182458642215352e-03
            4.94636775017213869976018258967088e-01 1.07264499655723381105199010221440e-02 9.42772402806562638544196630618899e-03
            1.07264499655723311716259971149157e-02 4.94636775017213758953715796451434e-01 9.42772402806562291599501435257480e-03
            2.07343382614511406725199549327954e-01 2.07343382614511434480775164956867e-01 3.60798487723697561269098343927908e-02
            2.07343382614511351214048318070127e-01 5.85313234770977297571903363859747e-01 3.60798487723697491880159304855624e-02
            5.85313234770977186549600901344093e-01 2.07343382614511434480775164956867e-01 3.60798487723697561269098343927908e-02
            4.38907805700492037459525818121620e-01 4.38907805700492203992979511895101e-01 3.46645693527679460421708768080862e-02
            4.38907805700492092970677049379447e-01 1.22184388599015855692009324684477e-01 3.46645693527679391032769729008578e-02
            1.22184388599015869569797132498934e-01 4.38907805700492203992979511895101e-01 3.46645693527679460421708768080862e-02
            6.77937654882590057248137327405857e-01 4.48416775891305116608087644181069e-02 2.05281577146442829884254166472601e-02
            6.77937654882590057248137327405857e-01 2.77220667528279396396584388639894e-01 2.05281577146442829884254166472601e-02
            4.48416775891304353329758214385947e-02 6.77937654882590168270439789921511e-01 2.05281577146442760495315127400318e-02
            4.48416775891304908441270526964217e-02 2.77220667528279451907735619897721e-01 2.05281577146442933967662725081027e-02
            2.77220667528279340885433157382067e-01 6.77937654882590279292742252437165e-01 2.05281577146442760495315127400318e-02
            2.77220667528279451907735619897721e-01 4.48416775891304977830209566036501e-02 2.05281577146442864578723686008743e-02
            8.58870281282636427455656757956604e-01 1.83216309617027279687061400272617e-16 3.68119189165031120147819621024610e-03
            8.58870281282636427455656757956604e-01 1.41129718717363350499738317012088e-01 3.68119189165030946675472023343900e-03
            9.60764621317673307808524465041727e-17 8.58870281282636427455656757956604e-01 3.68119189165029342056256744797338e-03
            2.67828342449925385748091359346653e-16 1.41129718717363572544343242043396e-01 3.68119189165032160981905207108866e-03
            1.41129718717363378255313932641002e-01 8.58870281282636427455656757956604e-01 3.68119189165030599730776827982481e-03
            1.41129718717363572544343242043396e-01 1.69002612246827253665581992802680e-16 3.68119189165031076779732721604432e-03
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    9   19 4.86e-16    0    0
    11   28 5.13e-16    0    0
    ];



