
function [S1,S2,S3,pointset_stats]=set_dedoncker_robinson_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  E. de Doncker and I. Robinson,
%  Algorithm 612: TRIEX: Integration Over a TRIangle Using Nonlinear
%  Extrapolation.
%  ACM Trans. Math. Softw.,
%  March 1984.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   9 |  19 |   0 |   0 | 8.69e-15 |PI|
% |  11 |  28 |   0 |   0 | 3.51e-14 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.7e-15
        
        S1=[
            4.32835393772893969877024744619121e-02 7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02
            ];
        
        S2=[
            3.13347002271398278328007336313021e-02 4.89682519198737009613608961444697e-01
            7.78275410047754301334776982912445e-02 4.37089591492935525263163754061679e-01
            7.96477389272090968708184277602413e-02 1.88203535619032191750221727488679e-01
            2.55776756586981006413861194914716e-02 4.47295133944529688108104892307892e-02
            ];
        
        S3=[
            9.71357962827961024521172817003389e-02
            ];
        
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.5e-14
        
        S1=[
            4.10563154292886006713203528306622e-02 6.77937654882590168270439789921511e-01 4.48416775891305532941721878614771e-02
            7.36238378330057296333732708149000e-03 8.58870281282636427455656757956604e-01 0.00000000000000000000000000000000e+00
            ];
        
        S2=[
            8.74431155373618998472018404299888e-03 2.59891409282883290021715083639720e-02
            3.80815719939353314327235011660377e-02 9.42875026479226968634250738432456e-02
            1.88554480561312493014369806587638e-02 4.94636775017214702643286727834493e-01
            7.21596975447409971771151049324544e-02 2.07343382614514210038336727848218e-01
            6.93291387055371965963956881751074e-02 4.38907805700490705191896267933771e-01
            ];
        
        S3=[
            8.79773011622218964467023738507123e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    9   19 8.69e-15    0    0
    11   28 3.51e-14    0    0
    ];




