
function [xyw,pointset_stats]=set_dedoncker_robinson_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  E. de Doncker and I. Robinson,
%  Algorithm 612: TRIEX: Integration Over a TRIangle Using Nonlinear
%  Extrapolation.
%  ACM Trans. Math. Softw.,
%  March 1984.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   9 |  19 |   0 |   0 | 8.69e-15 |PI|
% |  11 |  28 |   0 |   0 | 3.51e-14 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.7e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.85678981413980859205281603863114e-02
            4.89682519198737009613608961444697e-01 4.89682519198737009613608961444697e-01 1.56673501135699243247412226764936e-02
            4.89682519198737009613608961444697e-01 2.06349616025259807727820771106053e-02 1.56673501135699243247412226764936e-02
            2.06349616025259807727820771106053e-02 4.89682519198737009613608961444697e-01 1.56673501135699243247412226764936e-02
            4.37089591492935525263163754061679e-01 4.37089591492935525263163754061679e-01 3.89137705023877428223144647745357e-02
            4.37089591492935525263163754061679e-01 1.25820817014128949473672491876641e-01 3.89137705023877428223144647745357e-02
            1.25820817014128949473672491876641e-01 4.37089591492935525263163754061679e-01 3.89137705023877428223144647745357e-02
            1.88203535619032191750221727488679e-01 1.88203535619032191750221727488679e-01 3.98238694636045761909848295090342e-02
            1.88203535619032191750221727488679e-01 6.23592928761935616499556545022642e-01 3.98238694636045761909848295090342e-02
            6.23592928761935616499556545022642e-01 1.88203535619032191750221727488679e-01 3.98238694636045761909848295090342e-02
            4.47295133944529688108104892307892e-02 4.47295133944529688108104892307892e-02 1.27888378293490589943104396297713e-02
            4.47295133944529688108104892307892e-02 9.10540973211094062378379021538422e-01 1.27888378293490589943104396297713e-02
            9.10540973211094062378379021538422e-01 4.47295133944529688108104892307892e-02 1.27888378293490589943104396297713e-02
            7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02 2.16417696886447123716390450454128e-02
            7.41198598784498008384957756788936e-01 2.21962989160765733487323814188130e-01 2.16417696886447123716390450454128e-02
            3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01 2.16417696886447123716390450454128e-02
            3.68384120547362581277184290229343e-02 2.21962989160765733487323814188130e-01 2.16417696886447123716390450454128e-02
            2.21962989160765733487323814188130e-01 7.41198598784498008384957756788936e-01 2.16417696886447123716390450454128e-02
            2.21962989160765733487323814188130e-01 3.68384120547362581277184290229343e-02 2.16417696886447123716390450454128e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.5e-14
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.39886505811109551622450908325845e-02
            2.59891409282883290021715083639720e-02 2.59891409282883290021715083639720e-02 4.37215577686809585972183000990299e-03
            2.59891409282883290021715083639720e-02 9.48021718143423397506808214529883e-01 4.37215577686809585972183000990299e-03
            9.48021718143423397506808214529883e-01 2.59891409282883290021715083639720e-02 4.37215577686809585972183000990299e-03
            9.42875026479226968634250738432456e-02 9.42875026479226968634250738432456e-02 1.90407859969676691858087025366331e-02
            9.42875026479226968634250738432456e-02 8.11424994704154634028725467942422e-01 1.90407859969676691858087025366331e-02
            8.11424994704154634028725467942422e-01 9.42875026479226968634250738432456e-02 1.90407859969676691858087025366331e-02
            4.94636775017214702643286727834493e-01 4.94636775017214702643286727834493e-01 9.42772402806562638544196630618899e-03
            4.94636775017214702643286727834493e-01 1.07264499655705947134265443310142e-02 9.42772402806562638544196630618899e-03
            1.07264499655705947134265443310142e-02 4.94636775017214702643286727834493e-01 9.42772402806562638544196630618899e-03
            2.07343382614514210038336727848218e-01 2.07343382614514210038336727848218e-01 3.60798487723705055274514563734556e-02
            2.07343382614514210038336727848218e-01 5.85313234770971524412175313045736e-01 3.60798487723705055274514563734556e-02
            5.85313234770971524412175313045736e-01 2.07343382614514210038336727848218e-01 3.60798487723705055274514563734556e-02
            4.38907805700490705191896267933771e-01 4.38907805700490705191896267933771e-01 3.46645693527686052370917479947821e-02
            4.38907805700490705191896267933771e-01 1.22184388599018589616207464132458e-01 3.46645693527686052370917479947821e-02
            1.22184388599018589616207464132458e-01 4.38907805700490705191896267933771e-01 3.46645693527686052370917479947821e-02
            6.77937654882590168270439789921511e-01 4.48416775891305532941721878614771e-02 2.05281577146443038051071283689453e-02
            6.77937654882590168270439789921511e-01 2.77220667528279285374281926124240e-01 2.05281577146443038051071283689453e-02
            4.48416775891305532941721878614771e-02 6.77937654882590168270439789921511e-01 2.05281577146443038051071283689453e-02
            4.48416775891305532941721878614771e-02 2.77220667528279285374281926124240e-01 2.05281577146443038051071283689453e-02
            2.77220667528279285374281926124240e-01 6.77937654882590168270439789921511e-01 2.05281577146443038051071283689453e-02
            2.77220667528279285374281926124240e-01 4.48416775891305532941721878614771e-02 2.05281577146443038051071283689453e-02
            8.58870281282636427455656757956604e-01 0.00000000000000000000000000000000e+00 3.68119189165028734903040152914855e-03
            8.58870281282636427455656757956604e-01 1.41129718717363572544343242043396e-01 3.68119189165028734903040152914855e-03
            0.00000000000000000000000000000000e+00 8.58870281282636427455656757956604e-01 3.68119189165028734903040152914855e-03
            0.00000000000000000000000000000000e+00 1.41129718717363572544343242043396e-01 3.68119189165028734903040152914855e-03
            1.41129718717363572544343242043396e-01 8.58870281282636427455656757956604e-01 3.68119189165028734903040152914855e-03
            1.41129718717363572544343242043396e-01 0.00000000000000000000000000000000e+00 3.68119189165028734903040152914855e-03
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    9   19 8.69e-15    0    0
    11   28 3.51e-14    0    0
    ];




