
function [S1,S2,S3,pointset_stats]=set_dunavant_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  D.A. Dunavant,
%  "High Degree Efficient Symmetrical Gaussian Quadrature Rules for the
%  Triangle"
%  International Journal for Numerical Methods in Engineering,
%  21(6), June 1985, pp. 1129-1148
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 3.68e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.24e-15 |PI|
% |   5 |   7 |   0 |   0 | 1.79e-13 |PI|
% |   6 |  12 |   0 |   0 | 2.75e-15 |PI|
% |   7 |  13 |   1 |   0 | 4.16e-15 |NI|
% |   8 |  16 |   0 |   0 | 3.87e-15 |PI|
% |   9 |  19 |   0 |   0 | 3.43e-15 |PI|
% |  10 |  25 |   0 |   0 | 1.10e-14 |PI|
% |  11 |  27 |   0 |   3 | 1.20e-13 |P0|
% |  12 |  33 |   0 |   0 | 4.54e-15 |PI|
% |  13 |  37 |   0 |   0 | 9.07e-15 |PI|
% |  14 |  42 |   0 |   0 | 6.71e-15 |PI|
% |  15 |  48 |   0 |   9 | 3.60e-14 |P0|
% |  16 |  52 |   0 |   6 | 1.98e-14 |P0|
% |  17 |  61 |   0 |   0 | 1.10e-14 |PI|
% |  18 |  70 |   3 |   6 | 5.08e-13 |N0|
% |  19 |  73 |   0 |   0 | 1.65e-14 |PI|
% |  20 |  79 |   3 |   9 | 4.74e-14 |N0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        S1=[];
        
        S2=[];
        
        S3=[
            1.00000000000000000000000000000000e+00
            ];
        
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        S1=[];
        
        S2=[
            3.33333333333333314829616256247391e-01 1.66666666666666657414808128123695e-01
            ];
        
        S3=[];
        
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        S1=[];
        
        S2=[
            5.20833333333333370340767487505218e-01 2.00000000000000011102230246251565e-01
            ];
        
        S3=[
            -5.62500000000000000000000000000000e-01
            ];
        
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        S1=[];
        
        S2=[
            2.23381589678010999966417671203089e-01 4.45948490915965001235576892213430e-01
            1.09951743655321995674079005311796e-01 9.15762135097710067155318824916321e-02
            ];
        
        S3=[];
        
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.8e-13
        
        S1=[];
        
        S2=[
            1.32394152788505997664358915244520e-01 4.70142064105100010440452251714305e-01
            1.25939180544827000751695322833257e-01 1.01286507323455995943639607048681e-01
            ];
        
        S3=[
            2.25000000000000005551115123125783e-01
            ];
        
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.7e-15
        
        S1=[
            8.28510756183740010305527334821818e-02 5.31450498448170008392033025756973e-02 3.10352451033784004774673803694895e-01
            ];
        
        S2=[
            1.16786275726378993566889619160065e-01 2.49286745170910012392440080475353e-01
            5.08449063702069992132237530313432e-02 6.30890144915020045779385782225290e-02
            ];
        
        S3=[];
        
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 4.2e-15
        
        S1=[
            7.71137608902569965385609407348966e-02 4.86903154253160025399793653377856e-02 3.12865496004874010793628258397803e-01
            ];
        
        S2=[
            1.75615257433207994086643566333805e-01 2.60345966079039981000420311829657e-01
            5.33472356088380006422511314667645e-02 6.51301029022160055115264754022064e-02
            ];
        
        S3=[
            -1.49570044467681989575069678721775e-01
            ];
        
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-15
        
        S1=[
            2.72303141744349996855589779443108e-02 8.39477740995800067458354476457316e-03 2.63112829634638001330415590928169e-01
            ];
        
        S2=[
            9.50916342672849940198531726309739e-02 4.59292588292723014120610969257541e-01
            1.03217370534717994834394971803704e-01 1.70569307751759990932072241776041e-01
            3.24584976231980029681700727905991e-02 5.05472283170309982791579272998206e-02
            ];
        
        S3=[
            1.44315607677787005602709768936620e-01
            ];
        
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.4e-15
        
        S1=[
            4.32835393772890014707499517498945e-02 3.68384120547360013886439844554843e-02 2.21962989160766011043079970477265e-01
            ];
        
        S2=[
            3.13347002271390021044261686711252e-02 4.89682519198738008814331124085584e-01
            7.78275410047740007213334934021987e-02 4.37089591492937024064246998023009e-01
            7.96477389272099989270259356999304e-02 1.88203535619032996661914580727171e-01
            2.55776756586980000274245128366601e-02 4.47295133944529965663861048597028e-02
            ];
        
        S3=[
            9.71357962827990029097691149218008e-02
            ];
        
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.1e-14
        
        S1=[
            7.27579168454200037041701421003381e-02 1.41707219414879986851829585248197e-01 3.07939838764121009972996034775861e-01
            2.83272425310569994638676405429578e-02 2.50035347626859985603609004556347e-02 2.46672560639903004631179328498547e-01
            9.42166696373300006916995386063718e-03 9.54081540029899990984496582768770e-03 6.68032510121999989483043691507191e-02
            ];
        
        S2=[
            3.67259577564669967286725693611515e-02 4.85577633383657003562916543160100e-01
            4.53210594355279994260854437015951e-02 1.09481575485036994321852432676678e-01
            ];
        
        S3=[
            9.08179903827539963812043311008892e-02
            ];
        
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    3
        % M.E.INF. : 1.2e-13
        
        S1=[
            5.23371119622040026353460007157992e-02 5.01781383104950018392287347523961e-02 3.56620648261293027303509006742388e-01
            2.07076596391410003294986097444053e-02 2.10220165361660014935463181018349e-02 1.71488980304041999103148441463418e-01
            ];
        
        S2=[
            9.27006328961000008841153441352390e-04 5.34611048270758004719027667306364e-01
            7.71495349148129949679031369669246e-02 3.98969302965854977216508814308327e-01
            5.93229773807740015656442267300008e-02 2.03309900431281997956745044575655e-01
            3.61845405034180028769341674887983e-02 1.19350912282581003709402978074650e-01
            1.36597310026779997921275722205792e-02 3.23649481112759998535644001549372e-02
            ];
        
        S3=[];
        
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   33
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.5e-15
        
        S1=[
            4.03715577663810026853852264139277e-02 1.15343494534697998954442255126196e-01 2.75713269685514017481864357250743e-01
            2.23567732023030006638375510874539e-02 2.28383322222570003812158745404304e-02 2.81325580989939982856640199315734e-01
            1.73162311086589998376794596879336e-02 2.57340505483300008293667815451045e-02 1.16251915907596994892436725876905e-01
            ];
        
        S2=[
            2.57310664404549992168025340788517e-02 4.88217389773805021668806602974655e-01
            4.36925445380380028659317304118304e-02 4.39724392294459975882858771001338e-01
            6.28582242178850059133310423931107e-02 2.71210385012115973157875714605325e-01
            3.47961129307090000217783654079540e-02 1.27576145541586000176081938661810e-01
            6.16626105155900026272286496009656e-03 2.13173504532099995778526846379464e-02
            ];
        
        S3=[];
        
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 9.1e-15
        
        S1=[
            3.68484027287320006771587088678643e-02 9.48538283795789943786402886871656e-02 2.68794997058760976038627177331364e-01
            1.74014633038220012384300616758992e-02 1.81007732788069988782986285968946e-02 2.91730066734287973861938780828496e-01
            1.55217868390449993676316609025889e-02 2.22330766740900000189018470564406e-02 1.26357385491668999799586003973673e-01
            ];
        
        S2=[
            1.12801452093299996171094079500108e-02 4.95048184939704982721053738714545e-01
            3.14235183624540018176851674525096e-02 4.68716635109574009110389170018607e-01
            4.70725025041940012271446391878271e-02 4.14521336801277007211297132016625e-01
            4.73635865363550012663296229220578e-02 2.29399572042831012552710490126628e-01
            3.11675290457939999089198579440563e-02 1.14424495196329994994854928336281e-01
            7.97577146507399969976859210873954e-03 2.48113913634590010914848789980169e-02
            ];
        
        S3=[
            5.25209234008019998363181457534665e-02
            ];
        
        
    case  14
        
        % ALG. DEG.:   14
        % PTS CARD.:   42
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.7e-15
        
        S1=[
            2.46657532125639997189203711513983e-02 5.71247574036480021408834772955743e-02 1.72266687821356012655371614528121e-01
            3.85715107870610030005309454281814e-02 9.29162493569719999397804599539086e-02 3.36861459796345019679364440889913e-01
            1.44363081135340000360489653985496e-02 1.46469500556539993646465447341143e-02 2.98372882136258010810081486852141e-01
            5.01022883850099978730874283883168e-03 1.26833093287199993870473235801910e-03 1.18974497696957004500006860325811e-01
            ];
        
        S2=[
            2.18835813694290004516318504101946e-02 4.88963910362179010604677387163974e-01
            3.27883535441250012487657272686192e-02 4.17644719340453995926054631127045e-01
            5.17741045072920014202821903381846e-02 2.73477528308838979675954306003405e-01
            4.21625887369930021919550711118063e-02 1.77205532412542998699223062430974e-01
            1.44336996697770007097583189192846e-02 6.17998830908730034661147101360257e-02
            4.92340360240000034924845451200781e-03 1.93909612487009989922892572167257e-02
            ];
        
        S3=[];
        
        
    case  15
        
        % ALG. DEG.:   15
        % PTS CARD.:   48
        % NEG. W.  :    0
        % OUT PTS. :    9
        % M.E.INF. : 3.6e-14
        
        S1=[
            3.85500725995929979794674125059828e-02 1.33734161966620995753984857401520e-01 2.61311371140087012054920023729210e-01
            2.72158143206240009381868816262795e-02 3.63666773969169992986039119386987e-02 5.75586555512814013191302819905104e-01
            2.18207736679700003978865652243258e-03 -1.01748831265709993587620374455582e-02 2.85712220049915976982646270698751e-01
            2.15053198477309984171235157646151e-02 3.68438698758780033837290091014438e-02 2.15599664072284008531354970727989e-01
            7.67394263104899995026064729586324e-03 1.24598093311989992909571967061311e-02 1.03575616576386003719889572494139e-01
            ];
        
        S2=[
            1.91687564284899990274535497292163e-03 5.06972916858242972359960276662605e-01
            4.42490272711449986187126626191457e-02 4.31406354283022985818263350665802e-01
            5.11865487188519971417655085588194e-02 2.77693644847143983334092354198219e-01
            2.36877358706879988237137268924926e-02 1.26464891041253996162296857619367e-01
            1.32897756900210006064666501401916e-02 7.08083859746860000417001401729067e-02
            4.74891660819199996207418124072319e-03 1.89651702410729983139248133738874e-02
            ];
        
        S3=[];
        
        
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   52
        % NEG. W.  :    0
        % OUT PTS. :    6
        % M.E.INF. : 2.0e-14
        
        S1=[
            3.27731474606269973515182414303126e-02 1.03575692245251996248533998823405e-01 2.96555596579887004171638409388834e-01
            1.52983062484409997744405629305220e-02 2.00834116554160016510088837549119e-02 3.37723063403079004629603332432453e-01
            2.38624419283900001537146451369154e-03 -4.34100261413900012641420289583039e-03 2.04748281642812002267817206302425e-01
            1.90847927558989993723770339784096e-02 4.19417864680100005436713672679616e-02 1.89358492130623001781231096174452e-01
            6.85005454654200041098022211372154e-03 1.43173202306810000428161089303103e-02 8.52836156826569935507365016746917e-02
            ];
        
        S2=[
            6.40587857858499962193654653219710e-03 4.97380541948438004151711311351391e-01
            4.17102967393869969447983692134585e-02 4.13469438549351975265011560622952e-01
            2.68914842500640009770318528126154e-02 4.70458599066991001169668606962659e-01
            4.21325227616499986549314371586661e-02 2.40553749969521002416428245851421e-01
            3.00002668427729983491314413868167e-02 1.47965794222572999405684868179378e-01
            1.42000989250239996464220126881628e-02 7.54651876574739949310455244813056e-02
            3.58246235127300007017314698032351e-03 1.65964026230249993287824139542863e-02
            ];
        
        S3=[
            4.68756974276419990932396331118071e-02
            ];
        
        
    case  17
        
        % ALG. DEG.:   17
        % PTS CARD.:   61
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.1e-14
        
        S1=[
            8.11965531899300034524014080261622e-03 3.34319867363657985404046257826849e-01 6.55493203809422997352385209524073e-01
            2.68057422831630004500524933064298e-02 2.92221537796943986453612751574838e-01 5.72337590532020046296679538500030e-01
            1.84599932108219996762521475375252e-02 3.19574885423190013788996566290734e-01 6.26001190286228026415926706249593e-01
            8.47686853432800049845674550397234e-03 1.90704224192291993400516503243125e-01 7.96427214974070984965237585129216e-01
            1.82927967700249986815475011781018e-02 1.80483211648746005861809749148961e-01 7.52351005937728967154498604941182e-01
            6.66563200416500026973531944918250e-03 8.07113136795639951603931194767938e-02 9.04625504095608046206677954614861e-01
            ];
        
        S2=[
            5.09341544050700024276467914319255e-03 4.97170540556774009921525703248335e-01
            1.46708645276379997385296505285623e-02 4.82176322624625008916865454011713e-01
            2.43508783536720008200404663512018e-02 4.50239969020782004882619276031619e-01
            3.11075508689689986252524533938413e-02 4.00266239377397026188987183559220e-01
            3.12571112186200011917591723431542e-02 2.52141267970952986932076100856648e-01
            2.48156543396650004773551501102702e-02 1.62047004658461002435387854347937e-01
            1.40560730705570000043103107145726e-02 7.58758822607459998410561752280046e-02
            3.19467617377899989680734016417318e-03 1.56547269678220003774615776137580e-02
            ];
        
        S3=[
            3.34371992908030005176023280455411e-02
            ];
        
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   70
        % NEG. W.  :    3
        % OUT PTS. :    6
        % M.E.INF. : 5.1e-13
        
        S1=[
            6.33191407640599970146899622136516e-03 3.58911494940943986975412371975835e-01 6.32657968856636054866271479113493e-01
            2.72575380491380005187895818608013e-02 2.94402476751957020706385037556174e-01 5.74410971510854961863401513255667e-01
            1.76767856494649995557910671095669e-02 3.25017801641813985913387341497582e-01 6.24779046792511949526272019284079e-01
            1.83794846380700011012621075678908e-02 1.84737559666045991768612566374941e-01 7.48933176523037036353969142510323e-01
            8.10473280819199934366103832417139e-03 2.18796800013320996702859133620223e-01 7.69207005420442957444038256653585e-01
            7.63412907072500042382490192949263e-03 1.01179597136408006008423399180174e-01 8.83962302273466948854263591783820e-01
            4.61876607939999998201502373618155e-05 2.08747552825860015202064090544809e-02 1.01434726000536290513309722882695e+00
            ];
        
        S2=[
            9.07243667940399976801213455246398e-03 4.93344808630921005665470602252753e-01
            1.87613169395939999306577306015242e-02 4.69210594241956990835262786276871e-01
            1.94410979854769995489593981119469e-02 4.36281395887005984945972159039229e-01
            2.77539486108100003081133877458342e-02 3.94846170673415985952203755005030e-01
            3.22562253514570018708695897657890e-02 2.49794568803157007730320060545637e-01
            2.50740326169219991669923075505721e-02 1.61432193743842988808978589077014e-01
            1.52719279718319996680397920840733e-02 7.65982274853709982354033058982168e-02
            6.79392202296300040664789321454009e-03 2.42524393534499990709996097848489e-02
            -2.22309872992000005093027326097399e-03 4.31463672169649994914131241330324e-02
            ];
        
        S3=[
            3.08099399376469997025029812220964e-02
            ];
        
        
    case  19
        
        % ALG. DEG.:   19
        % PTS CARD.:   73
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.6e-14
        
        S1=[
            3.88487690498100007516213416636219e-03 3.95754787356943027454292405309388e-01 6.00633794794644959580409704358317e-01
            2.55741606120220010822663425642531e-02 3.07929983880436020093895876925671e-01 5.57603261588784038238486573391128e-01
            8.88090357333799935990459317736168e-03 2.64566948406520008330033988386276e-01 7.20987025817364957092081567679998e-01
            1.61245467617310012098386096113245e-02 3.58539352205951011853812815388665e-01 5.94527068955871040856209219782613e-01
            2.49194181749099992820295490503213e-03 1.57807405968594993694864569988567e-01 8.39331473680839046380697254789993e-01
            1.82428401189510015767414330412066e-02 7.50505969759110019845493866341712e-02 7.01087978926173027716117758245673e-01
            1.02585637361989993887601002597876e-02 1.42421601113383006209645031958644e-01 8.22931324069857028646879371081013e-01
            3.79992885530199995744449203982640e-03 6.54946280829380028665198665294156e-02 9.24344252620784012641763638384873e-01
            ];
        
        S2=[
            1.03307318912719998948990252074509e-02 4.89609987073006014401954644199577e-01
            2.23872472630160003481680774939377e-02 4.54536892697892991321850786334835e-01
            3.02661258694679989600384573122938e-02 4.01416680649430979155312115835841e-01
            3.04909678021979997641910387073949e-02 2.55551654403098016388184987590648e-01
            2.41592127416410014373315817692855e-02 1.77077942152129991226772176560189e-01
            1.60508035868009990565496991621330e-02 1.10061053227951996524858202519681e-01
            8.08458026178399992434098209059812e-03 5.55286242518399988932209510039684e-02
            2.07936202748499991688202470641045e-03 1.26218637772290004361863680060196e-02
            ];
        
        S3=[
            3.29063313889189981709115784269670e-02
            ];
        
        
    case  20
        
        % ALG. DEG.:   20
        % PTS CARD.:   79
        % NEG. W.  :    3
        % OUT PTS. :    9
        % M.E.INF. : 4.7e-14
        
        S1=[
            1.64658391895760002066051441715899e-02 3.44855770229000990756418332239264e-01 6.06402646106160014838337701803539e-01
            4.83903354048500003448118889082252e-03 3.77843269594853981008242271855124e-01 6.15842614456540982104115755646490e-01
            2.58049065346500003381713383987517e-02 3.06635479062356997026483895751880e-01 5.59048000390295007910879121482139e-01
            8.47109105444100035642307489069935e-03 2.49419362774741998345362503641809e-01 7.36606743262866014987366725108586e-01
            1.83549141062799986423570430815744e-02 2.12775724802801990964695733055123e-01 7.11675142287434003840473906166153e-01
            7.04404677907999971983588061164028e-04 1.46965436053239001390480211739487e-01 8.61402717154986952152739831944928e-01
            1.01126849274619998175772650483850e-02 1.37726978828923013464802238559059e-01 8.35586957912363037515035557589727e-01
            3.57390938594999993740963795119114e-03 5.96961091490069983844790613147779e-02 9.29756171556852972770457199658267e-01
            ];
        
        S2=[
            8.67019185662999962611874327222949e-04 5.00950464352200031115103229240049e-01
            1.16600527164480004954638658887234e-02 4.88212957934729019360275970029761e-01
            2.28769363564210008454846700942653e-02 4.55136681950283006337087954307208e-01
            3.04489826739379985942601791748530e-02 4.01996259318288973183541656908346e-01
            3.06248917253549995942663031200937e-02 2.55892909759420972282129014274688e-01
            2.43680576767999999832081670092521e-02 1.76488255995106008144901466039300e-01
            1.59974320320240004367207120594685e-02 1.04170855336758003129027372324344e-01
            7.69830181560200027535145750334777e-03 5.30689638409300029620041527778085e-02
            -6.32060497487999949257908571809139e-04 4.16187151960289991592389924335293e-02
            1.75113430119299990500580932462071e-03 1.15819214068219999286268873106565e-02
            ];
        
        S3=[
            3.30570555416239975077274948489503e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 3.68e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.24e-15    0    0
    5    7 1.79e-13    0    0
    6   12 2.75e-15    0    0
    7   13 4.16e-15    1    0
    8   16 3.87e-15    0    0
    9   19 3.43e-15    0    0
    10   25 1.10e-14    0    0
    11   27 1.20e-13    0    3
    12   33 4.54e-15    0    0
    13   37 9.07e-15    0    0
    14   42 6.71e-15    0    0
    15   48 3.60e-14    0    9
    16   52 1.98e-14    0    6
    17   61 1.10e-14    0    0
    18   70 5.08e-13    3    6
    19   73 1.65e-14    0    0
    20   79 4.74e-14    3    9
    ];

