
function [xyw,pointset_stats]=set_gatermann_C_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% K. Gatermann.
% "The Construction of Symmetric Cubature Formulas for the Square and the
% Triangle"
% Computing, 40, (1988), pp. 229-240.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   7 |  12 |   0 |   0 | 5.07e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.1e-16
        
        xyw=[
            6.23822650944021450669652040232904e-02 6.75178670739160630143160801708291e-02 2.65170281574362634580133146755543e-02
            6.75178670739161046476795036141993e-02 8.70099867831681805796506523620337e-01 2.65170281574362530496724588147117e-02
            8.70099867831681694774204061104683e-01 6.23822650944021381280713001160620e-02 2.65170281574362669274602666291685e-02
            5.52254566569266303055485423101345e-02 3.21502493851981818728802409168566e-01 4.38814087144460684974944797431817e-02
            3.21502493851981763217651177910739e-01 6.23272049491091606476800279779127e-01 4.38814087144460615586005758359534e-02
            6.23272049491091606476800279779127e-01 5.52254566569265609166095032378507e-02 4.38814087144460546197066719287250e-02
            3.43243029450971681715287786573754e-02 6.60949196186735643543386231613113e-01 2.87750427849816046987907469656420e-02
            6.60949196186735643543386231613113e-01 3.04726500868167216040660605358426e-01 2.87750427849815838821090352439569e-02
            3.04726500868167160529509374100599e-01 3.43243029450971195992714513067767e-02 2.87750427849815665348742754758860e-02
            5.15842334353591835949259802873712e-01 2.77716166976391787279965228663059e-01 6.74931870098027658633199621363019e-02
            2.77716166976391787279965228663059e-01 2.06441498670016376770774968463229e-01 6.74931870098027658633199621363019e-02
            2.06441498670016487793077430978883e-01 5.15842334353591724926957340358058e-01 6.74931870098027797411077699507587e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    7   12 5.07e-16    0    0
    ];


