
function [xyw_bar,pointset_stats]=set_gatermann_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% K. Gatermann.
% "The Construction of Symmetric Cubature Formulas for the Square and the
% Triangle"
% Computing, 40, (1988), pp. 229-240.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   7 |  12 |   0 |   0 | 2.00e-13 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.0e-13
        
        xyw_bar=[
            6.23822650943908416087957391482632e-02 6.75178670739243619314251532159687e-02 8.70099867831684803398673011542996e-01 5.30340563148690019579234444790927e-02
            6.75178670739243619314251532159687e-02 8.70099867831684803398673011542996e-01 6.23822650943908416087957391482632e-02 5.30340563148690019579234444790927e-02
            8.70099867831684803398673011542996e-01 6.23822650943908416087957391482632e-02 6.75178670739243619314251532159687e-02 5.30340563148690019579234444790927e-02
            5.52254566569199967229764069998055e-02 3.21502493852015625019902245185222e-01 6.23272049491064406012696963443886e-01 8.77628174288962170646044569366495e-02
            3.21502493852015625019902245185222e-01 6.23272049491064406012696963443886e-01 5.52254566569199967229764069998055e-02 8.77628174288962170646044569366495e-02
            6.23272049491064406012696963443886e-01 5.52254566569199967229764069998055e-02 3.21502493852015625019902245185222e-01 8.77628174288962170646044569366495e-02
            3.43243029450948783365404892720107e-02 6.60949196186798038077370165410684e-01 3.04726500868107041952725921873935e-01 5.75500855699505597939946710539516e-02
            6.60949196186798038077370165410684e-01 3.04726500868107041952725921873935e-01 3.43243029450948783365404892720107e-02 5.75500855699505597939946710539516e-02
            3.04726500868107041952725921873935e-01 3.43243029450948783365404892720107e-02 6.60949196186798038077370165410684e-01 5.75500855699505597939946710539516e-02
            5.15842334353600051599642029032111e-01 2.77716166976404998933958268025890e-01 2.06441498669994949466399702941999e-01 1.34986374019617577646457107221067e-01
            2.77716166976404998933958268025890e-01 2.06441498669994949466399702941999e-01 5.15842334353600051599642029032111e-01 1.34986374019617577646457107221067e-01
            2.06441498669994949466399702941999e-01 5.15842334353600051599642029032111e-01 2.77716166976404998933958268025890e-01 1.34986374019617577646457107221067e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    7   12 2.00e-13    0    0
    ];





