
function [xyw_bar,pointset_stats]=set_hammer_marlowe_stroud_I_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% P.C. Hammer, O.J. Marlowe and A.H. Stroud,
% "Numerical Integration Over Simplexes and Cones",
% Vol. 10, No. 55, Jul. 1956, pp. 130-137
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 1.18e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   5 |   7 |   0 |   0 | 1.60e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 1.00000000000000000000000000000000e+00
            ];
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.2e-16
        
        xyw_bar=[
            6.66666666666666629659232512494782e-01 1.66666666666666685170383743752609e-01 1.66666666666666685170383743752609e-01 3.33333333333333314829616256247391e-01
            1.66666666666666685170383743752609e-01 6.66666666666666629659232512494782e-01 1.66666666666666629659232512494782e-01 3.33333333333333314829616256247391e-01
            1.66666666666666685170383743752609e-01 1.66666666666666685170383743752609e-01 6.66666666666666518636930049979128e-01 3.33333333333333314829616256247391e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 -5.62500000000000000000000000000000e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.00000000000000066613381477509392e-01 5.20833333333333370340767487505218e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 6.00000000000000088817841970012523e-01 5.20833333333333370340767487505218e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.6e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 2.25000000000000005551115123125783e-01
            7.97426985353087314223330395179801e-01 1.01286507323456342888334802410100e-01 1.01286507323456342888334802410100e-01 1.25939180544827167285149016606738e-01
            1.01286507323456342888334802410100e-01 7.97426985353087314223330395179801e-01 1.01286507323456342888334802410100e-01 1.25939180544827167285149016606738e-01
            1.01286507323456342888334802410100e-01 1.01286507323456342888334802410100e-01 7.97426985353087314223330395179801e-01 1.25939180544827167285149016606738e-01
            5.97158717897697810528256923134904e-02 4.70142064105115109473587153843255e-01 4.70142064105115109473587153843255e-01 1.32394152788506164197812609018001e-01
            4.70142064105115109473587153843255e-01 5.97158717897697810528256923134904e-02 4.70142064105115164984738385101082e-01 1.32394152788506164197812609018001e-01
            4.70142064105115109473587153843255e-01 4.70142064105115109473587153843255e-01 5.97158717897698365639769235713175e-02 1.32394152788506164197812609018001e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 1.18e-16    0    0
    3    4 2.22e-16    1    0
    5    7 1.60e-16    0    0
    ];





