
function [xyw,pointset_stats]=set_hammer_marlowe_stroud_I_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% P.C. Hammer, O.J. Marlowe and A.H. Stroud,
% "Numerical Integration Over Simplexes and Cones",
% Vol. 10, No. 55, Jul. 1956, pp. 130-137
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 1.18e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   5 |   7 |   0 |   0 | 1.60e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
            ];
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.2e-16
        
        xyw=[
            6.66666666666666629659232512494782e-01 1.66666666666666685170383743752609e-01 1.66666666666666657414808128123695e-01
            1.66666666666666685170383743752609e-01 6.66666666666666629659232512494782e-01 1.66666666666666657414808128123695e-01
            1.66666666666666685170383743752609e-01 1.66666666666666685170383743752609e-01 1.66666666666666657414808128123695e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -2.81250000000000000000000000000000e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.60416666666666685170383743752609e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.6e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.12500000000000002775557561562891e-01
            7.97426985353087314223330395179801e-01 1.01286507323456342888334802410100e-01 6.29695902724135836425745083033689e-02
            1.01286507323456342888334802410100e-01 7.97426985353087314223330395179801e-01 6.29695902724135836425745083033689e-02
            1.01286507323456342888334802410100e-01 1.01286507323456342888334802410100e-01 6.29695902724135836425745083033689e-02
            5.97158717897697810528256923134904e-02 4.70142064105115109473587153843255e-01 6.61970763942530820989063045090006e-02
            4.70142064105115109473587153843255e-01 5.97158717897697810528256923134904e-02 6.61970763942530820989063045090006e-02
            4.70142064105115109473587153843255e-01 4.70142064105115109473587153843255e-01 6.61970763942530820989063045090006e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 1.18e-16    0    0
    3    4 2.22e-16    1    0
    5    7 1.60e-16    0    0
    ];




