
function xyw=set_hammer_marlowe_stroud_pre(deg)

%     P.C. Hammer, O.J. Marlowe and A.H. Stroud,
%     Numerical Integration Over Simplexes and Cones,
%     Mathematical Tables and Other Aids to Computation,
%     Vol. 10, No. 55, Jul. 1956, pp. 130-137,
%
%     P.C. Hammer, Arthur H. Stroud,
%     Numerical Evaluation of Multiple Integrals II,
%     Mathematical Tables and Other Aids to Computation.
%     Vol. 12, No. 64 (Oct., 1958), pp. 272-280,

xyw_bar=[];
xyw=[];

subcase=2;

switch deg
    
    case  1
        switch subcase
            case 1
                xyw_bar = [1/3 1/3 1/3 1];
        end
    case  2
        switch subcase
            case 1
                v1=r(frac(1, 2));
                w1=frac(1, 3)*ones(size(v1,1),1);
                
                xyw_bar=[v1 w1];
                
            case  2
                v1=r(-frac(1, 2));
                w1=frac(1, 3)*ones(size(v1,1),1);
                
                xyw_bar=[v1 w1];
        end
        %  4:
    case  3
        switch subcase
            case 1
                xyw_bar=[1/3 1/3 1/3 -frac(9, 16)];
                
                v1=r(frac(2, 5));
                w1=frac(25, 48)*ones(size(v1,1),1);
                xyw_barL=[v1 w1];
                
                xyw_bar=[xyw_bar; xyw_barL];
        end
    case 5
        switch subcase
            case 1
                w1=(155 - sqrt(15)) / 1200;
                w2=(155 + sqrt(15)) / 1200;
                
                x1 = (1 + sqrt(15)) / 7;
                x2 = (1 -sqrt(15)) / 7;
                
                xyw_bar=[1/3 1/3 1/3 frac(9, 40)];
                
                v1=r(x1);
                v2=r(x2);
                
                w1=w1*ones(size(v1,1),1);
                w2=w2*ones(size(v2,1),1);
                
                xyw_barL=[v1 w1; v2 w2];
                xyw_bar=[xyw_bar; xyw_barL];
        end
        
end

if isempty(xyw_bar) == 0
    xyw=xyw_bar(:, [1 2 4]);
    xyw(:,3)=xyw(:,3)/2;
end


function y=r(c)

a = c + (1-c) / 3;
b = (1-a) / 2;
y=[a, b, b
    b, a, b
    b, b, a];