

function [xyw,pointset_stats]=set_hillion_I_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% P. Hillion,
% "Numerical Integration on a Triangle",
% International Journal for Numerical Methods in Engineering,
% Vol. 11, (1977),  pp.797-815.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   0 |   0 | 3.89e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
            ];
        
        
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw=[
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 1.66666666666666657414808128123695e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 1.66666666666666657414808128123695e-01
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 1.66666666666666657414808128123695e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-16
        
        xyw=[
            6.66390246014701426169324349757517e-01 1.78558728263616461884311092944699e-01 1.59020690871988612524745576592977e-01
            1.78558728263616461884311092944699e-01 6.66390246014701426169324349757517e-01 1.59020690871988612524745576592977e-01
            2.80019915499074012465996474929852e-01 7.50311102226081383381739442484104e-02 9.09793091280113597196788077781093e-02
            7.50311102226081383381739442484104e-02 2.80019915499074012465996474929852e-01 9.09793091280113597196788077781093e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 2.78e-16    0    0
    3    4 3.89e-16    0    0
    ];




