
function [xyw_bar,pointset_stats]=set_hillion_II_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% P. Hillion,
% "Numerical Integration on a Triangle",
% International Journal for Numerical Methods in Engineering,
% Vol. 11, (1977),  pp.797-815.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 3.68e-16 |PI|
% |   3 |   4 |   0 |   0 | 2.43e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        xyw_bar=[
            1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01 6.66666666666666740681534975010436e-01 3.33333333333333314829616256247391e-01
            1.66666666666666657414808128123695e-01 6.66666666666666740681534975010436e-01 1.66666666666666629659232512494782e-01 3.33333333333333314829616256247391e-01
            6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01 1.66666666666666601903656896865868e-01 3.33333333333333314829616256247391e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.4e-16
        
        xyw_bar=[
            0.00000000000000000000000000000000e+00 8.00000000000000044408920985006262e-01 1.99999999999999955591079014993738e-01 1.30208333333333342585191871876305e-01
            8.00000000000000044408920985006262e-01 0.00000000000000000000000000000000e+00 1.99999999999999955591079014993738e-01 1.30208333333333342585191871876305e-01
            4.33949142535719423197093647104339e-01 4.33949142535719423197093647104339e-01 1.32101714928561209116963937049150e-01 3.84382276911161668841998562129447e-01
            1.75574666988090100083752531645587e-01 1.75574666988090100083752531645587e-01 6.48850666023819799832494936708827e-01 3.55201056422171645987617694117944e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 3.68e-16    0    0
    3    4 2.43e-16    0    0
    ];





