
function [xyw,pointset_stats]=set_hillion_II_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% P. Hillion,
% "Numerical Integration on a Triangle",
% International Journal for Numerical Methods in Engineering,
% Vol. 11, (1977),  pp.797-815.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 3.68e-16 |PI|
% |   3 |   4 |   0 |   0 | 2.43e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        xyw=[
            1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01
            1.66666666666666657414808128123695e-01 6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01
            6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.4e-16
        
        xyw=[
            0.00000000000000000000000000000000e+00 8.00000000000000044408920985006262e-01 6.51041666666666712925959359381523e-02
            8.00000000000000044408920985006262e-01 0.00000000000000000000000000000000e+00 6.51041666666666712925959359381523e-02
            4.33949142535719423197093647104339e-01 4.33949142535719423197093647104339e-01 1.92191138455580834420999281064724e-01
            1.75574666988090100083752531645587e-01 1.75574666988090100083752531645587e-01 1.77600528211085822993808847058972e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 3.68e-16    0    0
    3    4 2.43e-16    0    0
    ];




