
function [xyw_bar,pointset_stats]=set_hillion_III_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% P. Hillion,
% "Numerical Integration on a Triangle",
% International Journal for Numerical Methods in Engineering,
% Vol. 11, (1977),  pp.797-815.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 1.67e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.7e-16
        
        xyw_bar=[
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 1.11111111111111104943205418749130e-01
            5.91506350946109593635924284171779e-01 1.58493649053890350852924484570394e-01 2.50000000000000055511151231257827e-01 4.44444444444444419772821674996521e-01
            1.58493649053890350852924484570394e-01 5.91506350946109593635924284171779e-01 2.50000000000000000000000000000000e-01 4.44444444444444419772821674996521e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 6.00000000000000088817841970012523e-01 5.20833333333333370340767487505218e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.00000000000000066613381477509392e-01 5.20833333333333370340767487505218e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 -5.62500000000000000000000000000000e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 1.67e-16    0    0
    3    4 2.22e-16    1    0
    ];





