
function [xyw,xyw_bar]=set_hillion_pre(deg)
% Numerical Integration on a Triangle,
% International Journal for Numerical Methods in Engineering,
% Vol. 11, 797-815 (1977).
% DOI:10.1002/nme.1620110504,
% <https://doi.org/10.1002/nme.1620110504>.

xyw_bar=[];
subcase=3;
switch deg
    case  1
        switch subcase
            case 1
                xyw_bar=[1/3 1/3 1/3 frac(1, 2)];
        end
        
    case  2
        switch subcase
            case 1
                S2=[frac(1, 2) frac(1, 6)];
                size(S2)
                [XYW,xyw_bar]=orbit_maker_3(S2);
                
            case  2
                S2=[frac(1, 6) frac(1, 6)];
                [XYW,xyw_bar]=orbit_maker_3(S2);
                
            case  3
                a0=(3 + sqrt(3)) / 8;
                a1=(3 - sqrt(3)) / 8;
                v1=[ 0 0 1 frac(1, 18)];
                
                v2A=frac(2, 9);
                v2B=my_symm(a0, a1);
                v2A=frac(2, 9)*ones(size(v2B,1),1);
                xyw_bar=[v1; v2B v2A];
                
            case  4
                a0=(3 + sqrt(3)) / 8;
                a1=(3 - sqrt(3)) / 8;
                
                v1=[frac(2, 3) frac(2, 3) -frac(1, 3) frac(1, 18)];
                
                v2A=my_symm(frac(2, 3) - a0, frac(2, 3) - a1);
                v2B=frac(2, 9)*ones(size(v2A,1),1);
                
                xyw_bar=[v1; v2A v2B];
                
            case  5
                lm=(2 + sqrt(2 + sqrt(3))) / 6;
                mu=(2 - sqrt(2 - sqrt(3))) / 6;
                
                v1A=my_symm(lm, mu);
                v1B=frac(1, 8)*ones(size(v1A,1),1);
                
                v2A=my_symm(frac(2, 3) - lm, frac(2, 3) - mu);
                v2B=frac(1, 8)*ones(size(v2A,1),1);
                
                xyw_bar=[v1A v1B; v2A v2B];
                
        end
        
        %   7:
    case  3
        switch subcase
            case 1
                a=(6 + sqrt(2) + sqrt(6 * (3 + 2*sqrt(2)))) / 20;
                b=(6 + sqrt(2) - sqrt(6 * (3 + 2*sqrt(2)))) / 20;
                c=(6 - sqrt(2) + sqrt(6 * (3 - 2*sqrt(2)))) / 20;
                d=(6 - sqrt(2) - sqrt(6 * (3 - 2*sqrt(2)))) / 20;
                w1=((2 - 3 * (b+c)) / 12) / (a+d-b-c);
                w2=( (2 - 3 * (a+d)) / 12) / (b+c-a-d);
                
                v1A=my_symm(a,d);
                v1B=w1*ones(size(v1A,1),1);
                
                v2A=my_symm(c,b);
                v2B=w2*ones(size(v2A,1),1);
                
                xyw_bar=[v1A v1B; v2A v2B];
                
            case  2
                lambda2=(32 + 2*sqrt(46))/105;
                lambda3=(32 - 2*sqrt(46))/105;
                
                w1=(3266 + 19*sqrt(46)) / 17664;
                w2=(3266 - 19*sqrt(46)) / 17664;
                
                v1A=my_symm(0, frac(4, 5));
                v1B=frac(25, 384)*ones(size(v1A,1),1);
                
                v2=[lambda2 lambda2 1-2*lambda2 w1];
                
                v3=[lambda3, lambda3, 1 - 2*lambda3, w2];
                
                xyw_bar=[v1A v1B; v2; v3];
                
            case  3
                % # ERR the article is missing the minus sign
                
                v1=[1/3 1/3 1/3 -frac(9, 32)];
                S2=[frac(1, 5) frac(25, 96) ];
                [XYW,xyw_bar]=orbit_maker_3(S2);
                xyw_bar=[xyw_bar; v1];
                
                
            case  4
                
                lambda1=(16 + 2*sqrt(14))/25;
                lambda2=(16 - 2*sqrt(14))/25;
                w1=(161 + 17*sqrt(14))/2688;
                w2=(161 - 17*sqrt(14))/2688;
                
                v1A=my_symm(lambda1, 0);
                v1B=w2*ones(size(v1A,1),1);
                
                v2A=my_symm(0, lambda2);
                v2B=w1*ones(size(v1A,1),1);
                
                v3=[frac(2, 5), frac(2, 5), frac(1, 5),frac(25, 96)];
                
                xyw_bar=[v1A v1B; v2A v2B; v3];
                
        end
end


if isempty(xyw_bar) == 0
    xyw_bar(:,4)=2*xyw_bar(:,4);
    xyw=xyw_bar(:,[1 2 4]);
    xyw(:,3)=xyw(:,3)/2;
else
    xyw=[];
end



function y=my_symm(a, b)
c=1 - a - b;

y=[a, b, c
    b, a, c];




