
function [xyw,pointset_stats]=set_hillion_IV_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% P. Hillion,
% "Numerical Integration on a Triangle",
% International Journal for Numerical Methods in Engineering,
% Vol. 11, (1977),  pp.797-815.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   1 | 1.11e-16 |P0|
% |   3 |   5 |   0 |   0 | 5.55e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    1
        % M.E.INF. : 1.1e-16
        
        xyw=[
            6.66666666666666629659232512494782e-01 6.66666666666666629659232512494782e-01 5.55555555555555524716027093745652e-02
            7.51603157205570360233082283230033e-02 5.08173017612776334317459259182215e-01 2.22222222222222209886410837498261e-01
            5.08173017612776334317459259182215e-01 7.51603157205570360233082283230033e-02 2.22222222222222209886410837498261e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    5
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.6e-16
        
        xyw=[
            9.39332590941915235305259557208046e-01 0.00000000000000000000000000000000e+00 3.62320775390040927810275661613559e-02
            0.00000000000000000000000000000000e+00 9.39332590941915235305259557208046e-01 3.62320775390040927810275661613559e-02
            0.00000000000000000000000000000000e+00 3.40667409058084735828941802537884e-01 8.35595891276625785115683697767963e-02
            3.40667409058084735828941802537884e-01 0.00000000000000000000000000000000e+00 8.35595891276625785115683697767963e-02
            4.00000000000000022204460492503131e-01 4.00000000000000022204460492503131e-01 2.60416666666666685170383743752609e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 1.11e-16    0    1
    3    5 5.55e-16    0    0
    ];


