
function [xyw_bar,pointset_stats]=set_hillion_V_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% P. Hillion,
% "Numerical Integration on a Triangle",
% International Journal for Numerical Methods in Engineering,
% Vol. 11, (1977),  pp.797-815.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   4 |   0 |   0 | 2.50e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    4
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.5e-16
        
        xyw_bar=[
            6.55308608763022770737904920679284e-01 2.47060318299159753507865389110520e-01 9.76310729378174757542296902101953e-02 2.50000000000000000000000000000000e-01
            2.47060318299159753507865389110520e-01 6.55308608763022770737904920679284e-01 9.76310729378174757542296902101953e-02 2.50000000000000000000000000000000e-01
            1.13580579036438589213275918154977e-02 4.19606348367506876151367123384262e-01 5.69035593728849264927305284800241e-01 2.50000000000000000000000000000000e-01
            4.19606348367506876151367123384262e-01 1.13580579036438589213275918154977e-02 5.69035593728849264927305284800241e-01 2.50000000000000000000000000000000e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    4 2.50e-16    0    0
    ];





