
function [xyw_bar,pointset_stats]=set_laurie_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  D.P. Laurie
%  "Algorithm 584: CUBTRI: Automatic Cubature over a Triangle".
%  ACM Trans. Math. Softw., June 1982.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   8 |  19 |   0 |   0 | 9.58e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 9.6e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.78610912003147156990046084956703e-02
            1.01286507323456301254971378966729e-01 1.01286507323456301254971378966729e-01 7.97426985353087425245632857695455e-01 3.76204254131829105012307934430282e-02
            1.01286507323456301254971378966729e-01 7.97426985353087425245632857695455e-01 1.01286507323456301254971378966729e-01 3.76204254131829105012307934430282e-02
            7.97426985353087425245632857695455e-01 1.01286507323456301254971378966729e-01 1.01286507323456301254971378966729e-01 3.76204254131829105012307934430282e-02
            4.70142064105115109473587153843255e-01 4.70142064105115109473587153843255e-01 5.97158717897697810528256923134904e-02 7.83573522441174397101804061094299e-02
            4.70142064105115109473587153843255e-01 5.97158717897697810528256923134904e-02 4.70142064105115109473587153843255e-01 7.83573522441174397101804061094299e-02
            5.97158717897697810528256923134904e-02 4.70142064105115109473587153843255e-01 4.70142064105115109473587153843255e-01 7.83573522441174397101804061094299e-02
            2.32102326775050410434531045211770e-01 2.32102326775050410434531045211770e-01 5.35795346449899234642089140834287e-01 1.16271479656965950888469762958266e-01
            2.32102326775050410434531045211770e-01 5.35795346449899234642089140834287e-01 2.32102326775050410434531045211770e-01 1.16271479656965950888469762958266e-01
            5.35795346449899234642089140834287e-01 2.32102326775050410434531045211770e-01 2.32102326775050410434531045211770e-01 1.16271479656965950888469762958266e-01
            2.94808608844395990400411022847038e-02 2.94808608844395990400411022847038e-02 9.41038278231120850492175122781191e-01 1.34442673751655056291198775397788e-02
            2.94808608844395990400411022847038e-02 9.41038278231120850492175122781191e-01 2.94808608844395990400411022847038e-02 1.34442673751655056291198775397788e-02
            9.41038278231120850492175122781191e-01 2.94808608844395990400411022847038e-02 2.94808608844395990400411022847038e-02 1.34442673751655056291198775397788e-02
            7.38416812340510042567132131807739e-01 2.32102326775050410434531045211770e-01 2.94808608844395469983368229804910e-02 3.75097224552317157209024856001633e-02
            7.38416812340510042567132131807739e-01 2.94808608844395469983368229804910e-02 2.32102326775050410434531045211770e-01 3.75097224552317157209024856001633e-02
            2.32102326775050410434531045211770e-01 7.38416812340510042567132131807739e-01 2.94808608844395469983368229804910e-02 3.75097224552317157209024856001633e-02
            2.32102326775050410434531045211770e-01 2.94808608844395469983368229804910e-02 7.38416812340510042567132131807739e-01 3.75097224552317157209024856001633e-02
            2.94808608844395469983368229804910e-02 7.38416812340510042567132131807739e-01 2.32102326775050410434531045211770e-01 3.75097224552317157209024856001633e-02
            2.94808608844395469983368229804910e-02 2.32102326775050410434531045211770e-01 7.38416812340510042567132131807739e-01 3.75097224552317157209024856001633e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    8   19 9.58e-16    0    0
    ];





