
function [xyw_bar,pointset_stats]=set_laursen_gellert_I_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  M.E. Laursen, M. Gellert,
%  "Some criteria for numerically integrated matrices and quadrature
%  formulas for triangles"
%  International Journal for Numerical Methods in Engineering,
%  Volume 12, Issue 1 (1978), pp. 67-76.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 3.68e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.24e-15 |PI|
% |   5 |   7 |   0 |   0 | 2.18e-15 |PI|
% |   6 |  12 |   0 |   0 | 8.55e-15 |PI|
% |   7 |  13 |   1 |   0 | 8.65e-15 |NI|
% |   8 |  16 |   0 |   0 | 5.18e-15 |PI|
% |   9 |  19 |   0 |   0 | 3.43e-15 |PI|
% |  10 |  25 |   0 |   0 | 4.16e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.00000000000000000000000000000000e+00
            ];
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        xyw_bar=[
            1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01 6.66666666666666740681534975010436e-01 3.33333333333333314829616256247391e-01
            1.66666666666666657414808128123695e-01 6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01 3.33333333333333314829616256247391e-01
            6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01 3.33333333333333314829616256247391e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -5.62500000000000000000000000000000e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 5.20833333333333370340767487505218e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        xyw_bar=[
            9.15762135097710067155318824916321e-02 9.15762135097710067155318824916321e-02 8.16847572980457958813360619387822e-01 1.09951743655322120574169275641907e-01
            9.15762135097710067155318824916321e-02 8.16847572980457958813360619387822e-01 9.15762135097710067155318824916321e-02 1.09951743655322120574169275641907e-01
            8.16847572980457958813360619387822e-01 9.15762135097710067155318824916321e-02 9.15762135097710067155318824916321e-02 1.09951743655322120574169275641907e-01
            4.45948490915965001235576892213430e-01 4.45948490915965001235576892213430e-01 1.08103018168069997528846215573139e-01 2.23381589678011249766598211863311e-01
            4.45948490915965001235576892213430e-01 1.08103018168069997528846215573139e-01 4.45948490915965001235576892213430e-01 2.23381589678011249766598211863311e-01
            1.08103018168069997528846215573139e-01 4.45948490915965001235576892213430e-01 4.45948490915965001235576892213430e-01 2.23381589678011249766598211863311e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.25000000000000255351295663786004e-01
            1.01286507323455995943639607048681e-01 1.01286507323455995943639607048681e-01 7.97426985353087980357145170273725e-01 1.25939180544827139529573400977824e-01
            1.01286507323455995943639607048681e-01 7.97426985353087980357145170273725e-01 1.01286507323455995943639607048681e-01 1.25939180544827139529573400977824e-01
            7.97426985353087980357145170273725e-01 1.01286507323455995943639607048681e-01 1.01286507323455995943639607048681e-01 1.25939180544827139529573400977824e-01
            4.70142064105114998451284691327601e-01 4.70142064105114998451284691327601e-01 5.97158717897700030974306173447985e-02 1.32394152788506136442236993389088e-01
            4.70142064105114998451284691327601e-01 5.97158717897700030974306173447985e-02 4.70142064105114998451284691327601e-01 1.32394152788506136442236993389088e-01
            5.97158717897700030974306173447985e-02 4.70142064105114998451284691327601e-01 4.70142064105114998451284691327601e-01 1.32394152788506136442236993389088e-01
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.5e-15
        
        xyw_bar=[
            6.30890144915020045779385782225290e-02 6.30890144915020045779385782225290e-02 8.73821971016995990844122843554942e-01 5.08449063702068951298151944229176e-02
            6.30890144915020045779385782225290e-02 8.73821971016995990844122843554942e-01 6.30890144915020045779385782225290e-02 5.08449063702068951298151944229176e-02
            8.73821971016995990844122843554942e-01 6.30890144915020045779385782225290e-02 6.30890144915020045779385782225290e-02 5.08449063702068951298151944229176e-02
            2.49286745170910012392440080475353e-01 2.49286745170910012392440080475353e-01 5.01426509658180030726271070307121e-01 1.16786275726378757644496886314300e-01
            2.49286745170910012392440080475353e-01 5.01426509658180030726271070307121e-01 2.49286745170910012392440080475353e-01 1.16786275726378757644496886314300e-01
            5.01426509658180030726271070307121e-01 2.49286745170910012392440080475353e-01 2.49286745170910012392440080475353e-01 1.16786275726378757644496886314300e-01
            6.36502499121399001325016797636636e-01 3.10352451033785003975395966335782e-01 5.31450498448159946995872360275825e-02 8.28510756183738344970990397087007e-02
            6.36502499121399001325016797636636e-01 5.31450498448159946995872360275825e-02 3.10352451033785003975395966335782e-01 8.28510756183738344970990397087007e-02
            3.10352451033785003975395966335782e-01 6.36502499121399001325016797636636e-01 5.31450498448159946995872360275825e-02 8.28510756183738344970990397087007e-02
            3.10352451033785003975395966335782e-01 5.31450498448159946995872360275825e-02 6.36502499121399001325016797636636e-01 8.28510756183738344970990397087007e-02
            5.31450498448159946995872360275825e-02 6.36502499121399001325016797636636e-01 3.10352451033785003975395966335782e-01 8.28510756183738344970990397087007e-02
            5.31450498448159946995872360275825e-02 3.10352451033785003975395966335782e-01 6.36502499121399001325016797636636e-01 8.28510756183738344970990397087007e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 8.6e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -1.49570044467669832632950033257657e-01
            2.60345966079037982598975986547885e-01 2.60345966079037982598975986547885e-01 4.79308067841924034802048026904231e-01 1.75615257433203802994725606367865e-01
            2.60345966079037982598975986547885e-01 4.79308067841924034802048026904231e-01 2.60345966079037982598975986547885e-01 1.75615257433203802994725606367865e-01
            4.79308067841924034802048026904231e-01 2.60345966079037982598975986547885e-01 2.60345966079037982598975986547885e-01 1.75615257433203802994725606367865e-01
            6.51301029022160055115264754022064e-02 6.51301029022160055115264754022064e-02 8.69739794195568016732522664824501e-01 5.33472356088389373929281589425955e-02
            6.51301029022160055115264754022064e-02 8.69739794195568016732522664824501e-01 6.51301029022160055115264754022064e-02 5.33472356088389373929281589425955e-02
            8.69739794195568016732522664824501e-01 6.51301029022160055115264754022064e-02 6.51301029022160055115264754022064e-02 5.33472356088389373929281589425955e-02
            6.38444188569809001343458021437982e-01 3.12865496004875009994350421038689e-01 4.86903154253159886621915575233288e-02 7.71137608902569132718340938481560e-02
            6.38444188569809001343458021437982e-01 4.86903154253159886621915575233288e-02 3.12865496004875009994350421038689e-01 7.71137608902569132718340938481560e-02
            3.12865496004875009994350421038689e-01 6.38444188569809001343458021437982e-01 4.86903154253159886621915575233288e-02 7.71137608902569132718340938481560e-02
            3.12865496004875009994350421038689e-01 4.86903154253159886621915575233288e-02 6.38444188569809001343458021437982e-01 7.71137608902569132718340938481560e-02
            4.86903154253159886621915575233288e-02 6.38444188569809001343458021437982e-01 3.12865496004875009994350421038689e-01 7.71137608902569132718340938481560e-02
            4.86903154253159886621915575233288e-02 3.12865496004875009994350421038689e-01 6.38444188569809001343458021437982e-01 7.71137608902569132718340938481560e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.2e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.44315607677787449691919618999236e-01
            1.70569307751760990132794404416927e-01 1.70569307751760990132794404416927e-01 6.58861384496478019734411191166146e-01 1.03217370534718314023514551536209e-01
            1.70569307751760990132794404416927e-01 6.58861384496478019734411191166146e-01 1.70569307751760990132794404416927e-01 1.03217370534718314023514551536209e-01
            6.58861384496478019734411191166146e-01 1.70569307751760990132794404416927e-01 1.70569307751760990132794404416927e-01 1.03217370534718314023514551536209e-01
            5.05472283170309982791579272998206e-02 5.05472283170309982791579272998206e-02 8.98905543365937975686108529771445e-01 3.24584976231981070515786313990247e-02
            5.05472283170309982791579272998206e-02 8.98905543365937975686108529771445e-01 5.05472283170309982791579272998206e-02 3.24584976231981070515786313990247e-02
            8.98905543365937975686108529771445e-01 5.05472283170309982791579272998206e-02 5.05472283170309982791579272998206e-02 3.24584976231981070515786313990247e-02
            4.59292588292723014120610969257541e-01 4.59292588292723014120610969257541e-01 8.14148234145539717587780614849180e-02 9.50916342672842862526749740936793e-02
            4.59292588292723014120610969257541e-01 8.14148234145539717587780614849180e-02 4.59292588292723014120610969257541e-01 9.50916342672842862526749740936793e-02
            8.14148234145539717587780614849180e-02 4.59292588292723014120610969257541e-01 4.59292588292723014120610969257541e-01 9.50916342672842862526749740936793e-02
            8.39477740995800067458354476457316e-03 2.63112829634638001330415590928169e-01 7.28492392955404022281129527982557e-01 2.72303141744350829522858248310513e-02
            8.39477740995800067458354476457316e-03 7.28492392955404022281129527982557e-01 2.63112829634638001330415590928169e-01 2.72303141744350829522858248310513e-02
            2.63112829634638001330415590928169e-01 8.39477740995800067458354476457316e-03 7.28492392955404022281129527982557e-01 2.72303141744350829522858248310513e-02
            2.63112829634638001330415590928169e-01 7.28492392955404022281129527982557e-01 8.39477740995800067458354476457316e-03 2.72303141744350829522858248310513e-02
            7.28492392955404022281129527982557e-01 8.39477740995800067458354476457316e-03 2.63112829634638001330415590928169e-01 2.72303141744350829522858248310513e-02
            7.28492392955404022281129527982557e-01 2.63112829634638001330415590928169e-01 8.39477740995800067458354476457316e-03 2.72303141744350829522858248310513e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.4e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 9.71357962827994192434033493555035e-02
            4.89682519198738008814331124085584e-01 4.89682519198738008814331124085584e-01 2.06349616025239823713377518288326e-02 3.13347002271391339434103429084644e-02
            4.89682519198738008814331124085584e-01 2.06349616025239823713377518288326e-02 4.89682519198738008814331124085584e-01 3.13347002271391339434103429084644e-02
            2.06349616025239823713377518288326e-02 4.89682519198738008814331124085584e-01 4.89682519198738008814331124085584e-01 3.13347002271391339434103429084644e-02
            4.37089591492937024064246998023009e-01 4.37089591492937024064246998023009e-01 1.25820817014125951871506003953982e-01 7.78275410047743337882408809491608e-02
            4.37089591492937024064246998023009e-01 1.25820817014125951871506003953982e-01 4.37089591492937024064246998023009e-01 7.78275410047743337882408809491608e-02
            1.25820817014125951871506003953982e-01 4.37089591492937024064246998023009e-01 4.37089591492937024064246998023009e-01 7.78275410047743337882408809491608e-02
            1.88203535619032996661914580727171e-01 1.88203535619032996661914580727171e-01 6.23592928761933951165019607287832e-01 7.96477389272103319939333232468925e-02
            1.88203535619032996661914580727171e-01 6.23592928761933951165019607287832e-01 1.88203535619032996661914580727171e-01 7.96477389272103319939333232468925e-02
            6.23592928761933951165019607287832e-01 1.88203535619032996661914580727171e-01 1.88203535619032996661914580727171e-01 7.96477389272103319939333232468925e-02
            4.47295133944529965663861048597028e-02 4.47295133944529965663861048597028e-02 9.10540973211094062378379021538422e-01 2.55776756586981075802800233987000e-02
            4.47295133944529965663861048597028e-02 9.10540973211094062378379021538422e-01 4.47295133944529965663861048597028e-02 2.55776756586981075802800233987000e-02
            9.10540973211094062378379021538422e-01 4.47295133944529965663861048597028e-02 4.47295133944529965663861048597028e-02 2.55776756586981075802800233987000e-02
            3.68384120547360013886439844554843e-02 2.21962989160766011043079970477265e-01 7.41198598784498008384957756788936e-01 4.32835393772891818819914533378324e-02
            3.68384120547360013886439844554843e-02 7.41198598784498008384957756788936e-01 2.21962989160766011043079970477265e-01 4.32835393772891818819914533378324e-02
            2.21962989160766011043079970477265e-01 3.68384120547360013886439844554843e-02 7.41198598784498008384957756788936e-01 4.32835393772891818819914533378324e-02
            2.21962989160766011043079970477265e-01 7.41198598784498008384957756788936e-01 3.68384120547360013886439844554843e-02 4.32835393772891818819914533378324e-02
            7.41198598784498008384957756788936e-01 3.68384120547360013886439844554843e-02 2.21962989160766011043079970477265e-01 4.32835393772891818819914533378324e-02
            7.41198598784498008384957756788936e-01 2.21962989160766011043079970477265e-01 3.68384120547360013886439844554843e-02 4.32835393772891818819914533378324e-02
            ];
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.2e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 7.98945047412402131747910516423872e-02
            4.25086210602091008059488785875146e-01 4.25086210602091008059488785875146e-01 1.49827578795817983881022428249707e-01 7.11238022323772006716424698424817e-02
            4.25086210602091008059488785875146e-01 1.49827578795817983881022428249707e-01 4.25086210602091008059488785875146e-01 7.11238022323772006716424698424817e-02
            1.49827578795817983881022428249707e-01 4.25086210602091008059488785875146e-01 4.25086210602091008059488785875146e-01 7.11238022323772006716424698424817e-02
            2.33088675100000010387280013901545e-02 2.33088675100000010387280013901545e-02 9.53382264980000004861437901126919e-01 8.22381869046402182166222161185942e-03
            2.33088675100000010387280013901545e-02 9.53382264980000004861437901126919e-01 2.33088675100000010387280013901545e-02 8.22381869046402182166222161185942e-03
            9.53382264980000004861437901126919e-01 2.33088675100000010387280013901545e-02 2.33088675100000010387280013901545e-02 8.22381869046402182166222161185942e-03
            1.47925626209534005761625508057477e-01 2.23766973576973005055634757809457e-01 6.28307400213492961427164118504152e-01 4.54305922961701150186719644352706e-02
            1.47925626209534005761625508057477e-01 6.28307400213492961427164118504152e-01 2.23766973576973005055634757809457e-01 4.54305922961701150186719644352706e-02
            2.23766973576973005055634757809457e-01 1.47925626209534005761625508057477e-01 6.28307400213492961427164118504152e-01 4.54305922961701150186719644352706e-02
            2.23766973576973005055634757809457e-01 6.28307400213492961427164118504152e-01 1.47925626209534005761625508057477e-01 4.54305922961701150186719644352706e-02
            6.28307400213492961427164118504152e-01 1.47925626209534005761625508057477e-01 2.23766973576973005055634757809457e-01 4.54305922961701150186719644352706e-02
            6.28307400213492961427164118504152e-01 2.23766973576973005055634757809457e-01 1.47925626209534005761625508057477e-01 4.54305922961701150186719644352706e-02
            2.99460319541710005830648100300095e-02 3.58740141864430983620337656248012e-01 6.11313826181397956815999350510538e-01 3.73598562343050999423610392113915e-02
            2.99460319541710005830648100300095e-02 6.11313826181397956815999350510538e-01 3.58740141864430983620337656248012e-01 3.73598562343050999423610392113915e-02
            3.58740141864430983620337656248012e-01 2.99460319541710005830648100300095e-02 6.11313826181397956815999350510538e-01 3.73598562343050999423610392113915e-02
            3.58740141864430983620337656248012e-01 6.11313826181397956815999350510538e-01 2.99460319541710005830648100300095e-02 3.73598562343050999423610392113915e-02
            6.11313826181397956815999350510538e-01 2.99460319541710005830648100300095e-02 3.58740141864430983620337656248012e-01 3.73598562343050999423610392113915e-02
            6.11313826181397956815999350510538e-01 3.58740141864430983620337656248012e-01 2.99460319541710005830648100300095e-02 3.73598562343050999423610392113915e-02
            3.56325595875039979887333174701780e-02 1.43295370426866991442338417073188e-01 8.21072069985628982813352649827721e-01 3.08866568845640836193933154163460e-02
            3.56325595875039979887333174701780e-02 8.21072069985628982813352649827721e-01 1.43295370426866991442338417073188e-01 3.08866568845640836193933154163460e-02
            1.43295370426866991442338417073188e-01 3.56325595875039979887333174701780e-02 8.21072069985628982813352649827721e-01 3.08866568845640836193933154163460e-02
            1.43295370426866991442338417073188e-01 8.21072069985628982813352649827721e-01 3.56325595875039979887333174701780e-02 3.08866568845640836193933154163460e-02
            8.21072069985628982813352649827721e-01 3.56325595875039979887333174701780e-02 1.43295370426866991442338417073188e-01 3.08866568845640836193933154163460e-02
            8.21072069985628982813352649827721e-01 1.43295370426866991442338417073188e-01 3.56325595875039979887333174701780e-02 3.08866568845640836193933154163460e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 3.68e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.24e-15    0    0
    5    7 2.18e-15    0    0
    6   12 8.55e-15    0    0
    7   13 8.65e-15    1    0
    8   16 5.18e-15    0    0
    9   19 3.43e-15    0    0
    10   25 4.16e-15    0    0
    ];




