
function [S1,S2,S3,pointset_stats]=set_laursen_gellert_I_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  M.E. Laursen, M. Gellert,
%  "Some criteria for numerically integrated matrices and quadrature
%  formulas for triangles"
%  International Journal for Numerical Methods in Engineering,
%  Volume 12, Issue 1 (1978), pp. 67-76.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 3.68e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.24e-15 |PI|
% |   5 |   7 |   0 |   0 | 2.18e-15 |PI|
% |   6 |  12 |   0 |   0 | 8.55e-15 |PI|
% |   7 |  13 |   1 |   0 | 8.65e-15 |NI|
% |   8 |  16 |   0 |   0 | 5.18e-15 |PI|
% |   9 |  19 |   0 |   0 | 3.43e-15 |PI|
% |  10 |  25 |   0 |   0 | 4.16e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        S1=[];
        
        S2=[];
        
        S3=[
            1.00000000000000000000000000000000e+00
            ];
        
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        S1=[];
        
        S2=[
            3.33333333333333314829616256247391e-01 1.66666666666666657414808128123695e-01
            ];
        
        S3=[];
        
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        S1=[];
        
        S2=[
            5.20833333333333370340767487505218e-01 2.00000000000000011102230246251565e-01
            ];
        
        S3=[
            -5.62500000000000000000000000000000e-01
            ];
        
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        S1=[];
        
        S2=[
            1.09951743655321995674079005311796e-01 9.15762135097710067155318824916321e-02
            2.23381589678010999966417671203089e-01 4.45948490915965001235576892213430e-01
            ];
        
        S3=[];
        
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        S1=[];
        
        S2=[
            1.25939180544827000751695322833257e-01 1.01286507323455995943639607048681e-01
            1.32394152788505997664358915244520e-01 4.70142064105114998451284691327601e-01
            ];
        
        S3=[
            2.25000000000000005551115123125783e-01
            ];
        
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.5e-15
        
        S1=[
            8.28510756183740010305527334821818e-02 6.36502499121399001325016797636636e-01 3.10352451033785003975395966335782e-01
            ];
        
        S2=[
            5.08449063702069992132237530313432e-02 6.30890144915020045779385782225290e-02
            1.16786275726378993566889619160065e-01 2.49286745170910012392440080475353e-01
            ];
        
        S3=[];
        
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 8.6e-15
        
        S1=[
            7.71137608902569965385609407348966e-02 6.38444188569809001343458021437982e-01 3.12865496004875009994350421038689e-01
            ];
        
        S2=[
            1.75615257433203997283754915770260e-01 2.60345966079037982598975986547885e-01
            5.33472356088389998429732941076509e-02 6.51301029022160055115264754022064e-02
            ];
        
        S3=[
            -1.49570044467669999166403727031138e-01
            ];
        
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.2e-15
        
        S1=[
            2.72303141744349996855589779443108e-02 8.39477740995800067458354476457316e-03 2.63112829634638001330415590928169e-01
            ];
        
        S2=[
            1.03217370534717994834394971803704e-01 1.70569307751760990132794404416927e-01
            3.24584976231980029681700727905991e-02 5.05472283170309982791579272998206e-02
            9.50916342672839948191310099900875e-02 4.59292588292723014120610969257541e-01
            ];
        
        S3=[
            1.44315607677787005602709768936620e-01
            ];
        
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.4e-15
        
        S1=[
            4.32835393772890014707499517498945e-02 3.68384120547360013886439844554843e-02 2.21962989160766011043079970477265e-01
            ];
        
        S2=[
            3.13347002271390021044261686711252e-02 4.89682519198738008814331124085584e-01
            7.78275410047740007213334934021987e-02 4.37089591492937024064246998023009e-01
            7.96477389272099989270259356999304e-02 1.88203535619032996661914580727171e-01
            2.55776756586980000274245128366601e-02 4.47295133944529965663861048597028e-02
            ];
        
        S3=[
            9.71357962827990029097691149218008e-02
            ];
        
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.2e-15
        
        S1=[
            4.54305922961699970574755980123882e-02 1.47925626209534005761625508057477e-01 2.23766973576973005055634757809457e-01
            3.73598562343050027978463845101942e-02 2.99460319541710005830648100300095e-02 3.58740141864430983620337656248012e-01
            3.08866568845640003526664685296055e-02 3.56325595875039979887333174701780e-02 1.43295370426866991442338417073188e-01
            ];
        
        S2=[
            7.11238022323770063826131604400871e-02 4.25086210602091008059488785875146e-01
            8.22381869046399927025703391336720e-03 2.33088675100000010387280013901545e-02
            ];
        
        S3=[
            7.98945047412400050079739344255358e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 3.68e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.24e-15    0    0
    5    7 2.18e-15    0    0
    6   12 8.55e-15    0    0
    7   13 8.65e-15    1    0
    8   16 5.18e-15    0    0
    9   19 3.43e-15    0    0
    10   25 4.16e-15    0    0
    ];




