
function [xyw,pointset_stats]=set_laursen_gellert_I_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  M.E. Laursen, M. Gellert,
%  "Some criteria for numerically integrated matrices and quadrature
%  formulas for triangles"
%  International Journal for Numerical Methods in Engineering,
%  Volume 12, Issue 1 (1978), pp. 67-76.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 3.68e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.24e-15 |PI|
% |   5 |   7 |   0 |   0 | 2.18e-15 |PI|
% |   6 |  12 |   0 |   0 | 8.55e-15 |PI|
% |   7 |  13 |   1 |   0 | 8.65e-15 |NI|
% |   8 |  16 |   0 |   0 | 5.18e-15 |PI|
% |   9 |  19 |   0 |   0 | 3.43e-15 |PI|
% |  10 |  25 |   0 |   0 | 4.16e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
            ];
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        xyw=[
            1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01
            1.66666666666666657414808128123695e-01 6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01
            6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -2.81250000000000000000000000000000e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.60416666666666685170383743752609e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        xyw=[
            9.15762135097710067155318824916321e-02 9.15762135097710067155318824916321e-02 5.49758718276610602870846378209535e-02
            9.15762135097710067155318824916321e-02 8.16847572980457958813360619387822e-01 5.49758718276610602870846378209535e-02
            8.16847572980457958813360619387822e-01 9.15762135097710067155318824916321e-02 5.49758718276610602870846378209535e-02
            4.45948490915965001235576892213430e-01 4.45948490915965001235576892213430e-01 1.11690794839005624883299105931656e-01
            4.45948490915965001235576892213430e-01 1.08103018168069997528846215573139e-01 1.11690794839005624883299105931656e-01
            1.08103018168069997528846215573139e-01 4.45948490915965001235576892213430e-01 1.11690794839005624883299105931656e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.12500000000000127675647831893002e-01
            1.01286507323455995943639607048681e-01 1.01286507323455995943639607048681e-01 6.29695902724135697647867004889122e-02
            1.01286507323455995943639607048681e-01 7.97426985353087980357145170273725e-01 6.29695902724135697647867004889122e-02
            7.97426985353087980357145170273725e-01 1.01286507323455995943639607048681e-01 6.29695902724135697647867004889122e-02
            4.70142064105114998451284691327601e-01 4.70142064105114998451284691327601e-01 6.61970763942530682211184966945439e-02
            4.70142064105114998451284691327601e-01 5.97158717897700030974306173447985e-02 6.61970763942530682211184966945439e-02
            5.97158717897700030974306173447985e-02 4.70142064105114998451284691327601e-01 6.61970763942530682211184966945439e-02
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.5e-15
        
        xyw=[
            6.30890144915020045779385782225290e-02 6.30890144915020045779385782225290e-02 2.54224531851034475649075972114588e-02
            6.30890144915020045779385782225290e-02 8.73821971016995990844122843554942e-01 2.54224531851034475649075972114588e-02
            8.73821971016995990844122843554942e-01 6.30890144915020045779385782225290e-02 2.54224531851034475649075972114588e-02
            2.49286745170910012392440080475353e-01 2.49286745170910012392440080475353e-01 5.83931378631893788222484431571502e-02
            2.49286745170910012392440080475353e-01 5.01426509658180030726271070307121e-01 5.83931378631893788222484431571502e-02
            5.01426509658180030726271070307121e-01 2.49286745170910012392440080475353e-01 5.83931378631893788222484431571502e-02
            6.36502499121399001325016797636636e-01 3.10352451033785003975395966335782e-01 4.14255378091869172485495198543504e-02
            6.36502499121399001325016797636636e-01 5.31450498448159946995872360275825e-02 4.14255378091869172485495198543504e-02
            3.10352451033785003975395966335782e-01 6.36502499121399001325016797636636e-01 4.14255378091869172485495198543504e-02
            3.10352451033785003975395966335782e-01 5.31450498448159946995872360275825e-02 4.14255378091869172485495198543504e-02
            5.31450498448159946995872360275825e-02 6.36502499121399001325016797636636e-01 4.14255378091869172485495198543504e-02
            5.31450498448159946995872360275825e-02 3.10352451033785003975395966335782e-01 4.14255378091869172485495198543504e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 8.6e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -7.47850222338349163164750166288286e-02
            2.60345966079037982598975986547885e-01 2.60345966079037982598975986547885e-01 8.78076287166019014973628031839326e-02
            2.60345966079037982598975986547885e-01 4.79308067841924034802048026904231e-01 8.78076287166019014973628031839326e-02
            4.79308067841924034802048026904231e-01 2.60345966079037982598975986547885e-01 8.78076287166019014973628031839326e-02
            6.51301029022160055115264754022064e-02 6.51301029022160055115264754022064e-02 2.66736178044194686964640794712977e-02
            6.51301029022160055115264754022064e-02 8.69739794195568016732522664824501e-01 2.66736178044194686964640794712977e-02
            8.69739794195568016732522664824501e-01 6.51301029022160055115264754022064e-02 2.66736178044194686964640794712977e-02
            6.38444188569809001343458021437982e-01 3.12865496004875009994350421038689e-01 3.85568804451284566359170469240780e-02
            6.38444188569809001343458021437982e-01 4.86903154253159886621915575233288e-02 3.85568804451284566359170469240780e-02
            3.12865496004875009994350421038689e-01 6.38444188569809001343458021437982e-01 3.85568804451284566359170469240780e-02
            3.12865496004875009994350421038689e-01 4.86903154253159886621915575233288e-02 3.85568804451284566359170469240780e-02
            4.86903154253159886621915575233288e-02 6.38444188569809001343458021437982e-01 3.85568804451284566359170469240780e-02
            4.86903154253159886621915575233288e-02 3.12865496004875009994350421038689e-01 3.85568804451284566359170469240780e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.2e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 7.21578038388937248459598094996181e-02
            1.70569307751760990132794404416927e-01 1.70569307751760990132794404416927e-01 5.16086852673591570117572757681046e-02
            1.70569307751760990132794404416927e-01 6.58861384496478019734411191166146e-01 5.16086852673591570117572757681046e-02
            6.58861384496478019734411191166146e-01 1.70569307751760990132794404416927e-01 5.16086852673591570117572757681046e-02
            5.05472283170309982791579272998206e-02 5.05472283170309982791579272998206e-02 1.62292488115990535257893156995124e-02
            5.05472283170309982791579272998206e-02 8.98905543365937975686108529771445e-01 1.62292488115990535257893156995124e-02
            8.98905543365937975686108529771445e-01 5.05472283170309982791579272998206e-02 1.62292488115990535257893156995124e-02
            4.59292588292723014120610969257541e-01 4.59292588292723014120610969257541e-01 4.75458171336421431263374870468397e-02
            4.59292588292723014120610969257541e-01 8.14148234145539717587780614849180e-02 4.75458171336421431263374870468397e-02
            8.14148234145539717587780614849180e-02 4.59292588292723014120610969257541e-01 4.75458171336421431263374870468397e-02
            8.39477740995800067458354476457316e-03 2.63112829634638001330415590928169e-01 1.36151570872175414761429124155256e-02
            8.39477740995800067458354476457316e-03 7.28492392955404022281129527982557e-01 1.36151570872175414761429124155256e-02
            2.63112829634638001330415590928169e-01 8.39477740995800067458354476457316e-03 1.36151570872175414761429124155256e-02
            2.63112829634638001330415590928169e-01 7.28492392955404022281129527982557e-01 1.36151570872175414761429124155256e-02
            7.28492392955404022281129527982557e-01 8.39477740995800067458354476457316e-03 1.36151570872175414761429124155256e-02
            7.28492392955404022281129527982557e-01 2.63112829634638001330415590928169e-01 1.36151570872175414761429124155256e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.4e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.85678981413997096217016746777517e-02
            4.89682519198738008814331124085584e-01 4.89682519198738008814331124085584e-01 1.56673501135695669717051714542322e-02
            4.89682519198738008814331124085584e-01 2.06349616025239823713377518288326e-02 1.56673501135695669717051714542322e-02
            2.06349616025239823713377518288326e-02 4.89682519198738008814331124085584e-01 1.56673501135695669717051714542322e-02
            4.37089591492937024064246998023009e-01 4.37089591492937024064246998023009e-01 3.89137705023871668941204404745804e-02
            4.37089591492937024064246998023009e-01 1.25820817014125951871506003953982e-01 3.89137705023871668941204404745804e-02
            1.25820817014125951871506003953982e-01 4.37089591492937024064246998023009e-01 3.89137705023871668941204404745804e-02
            1.88203535619032996661914580727171e-01 1.88203535619032996661914580727171e-01 3.98238694636051659969666616234463e-02
            1.88203535619032996661914580727171e-01 6.23592928761933951165019607287832e-01 3.98238694636051659969666616234463e-02
            6.23592928761933951165019607287832e-01 1.88203535619032996661914580727171e-01 3.98238694636051659969666616234463e-02
            4.47295133944529965663861048597028e-02 4.47295133944529965663861048597028e-02 1.27888378293490537901400116993500e-02
            4.47295133944529965663861048597028e-02 9.10540973211094062378379021538422e-01 1.27888378293490537901400116993500e-02
            9.10540973211094062378379021538422e-01 4.47295133944529965663861048597028e-02 1.27888378293490537901400116993500e-02
            3.68384120547360013886439844554843e-02 2.21962989160766011043079970477265e-01 2.16417696886445909409957266689162e-02
            3.68384120547360013886439844554843e-02 7.41198598784498008384957756788936e-01 2.16417696886445909409957266689162e-02
            2.21962989160766011043079970477265e-01 3.68384120547360013886439844554843e-02 2.16417696886445909409957266689162e-02
            2.21962989160766011043079970477265e-01 7.41198598784498008384957756788936e-01 2.16417696886445909409957266689162e-02
            7.41198598784498008384957756788936e-01 3.68384120547360013886439844554843e-02 2.16417696886445909409957266689162e-02
            7.41198598784498008384957756788936e-01 2.21962989160766011043079970477265e-01 2.16417696886445909409957266689162e-02
            ];
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.2e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.99472523706201065873955258211936e-02
            4.25086210602091008059488785875146e-01 4.25086210602091008059488785875146e-01 3.55619011161886003358212349212408e-02
            4.25086210602091008059488785875146e-01 1.49827578795817983881022428249707e-01 3.55619011161886003358212349212408e-02
            1.49827578795817983881022428249707e-01 4.25086210602091008059488785875146e-01 3.55619011161886003358212349212408e-02
            2.33088675100000010387280013901545e-02 2.33088675100000010387280013901545e-02 4.11190934523201091083111080592971e-03
            2.33088675100000010387280013901545e-02 9.53382264980000004861437901126919e-01 4.11190934523201091083111080592971e-03
            9.53382264980000004861437901126919e-01 2.33088675100000010387280013901545e-02 4.11190934523201091083111080592971e-03
            1.47925626209534005761625508057477e-01 2.23766973576973005055634757809457e-01 2.27152961480850575093359822176353e-02
            1.47925626209534005761625508057477e-01 6.28307400213492961427164118504152e-01 2.27152961480850575093359822176353e-02
            2.23766973576973005055634757809457e-01 1.47925626209534005761625508057477e-01 2.27152961480850575093359822176353e-02
            2.23766973576973005055634757809457e-01 6.28307400213492961427164118504152e-01 2.27152961480850575093359822176353e-02
            6.28307400213492961427164118504152e-01 1.47925626209534005761625508057477e-01 2.27152961480850575093359822176353e-02
            6.28307400213492961427164118504152e-01 2.23766973576973005055634757809457e-01 2.27152961480850575093359822176353e-02
            2.99460319541710005830648100300095e-02 3.58740141864430983620337656248012e-01 1.86799281171525499711805196056957e-02
            2.99460319541710005830648100300095e-02 6.11313826181397956815999350510538e-01 1.86799281171525499711805196056957e-02
            3.58740141864430983620337656248012e-01 2.99460319541710005830648100300095e-02 1.86799281171525499711805196056957e-02
            3.58740141864430983620337656248012e-01 6.11313826181397956815999350510538e-01 1.86799281171525499711805196056957e-02
            6.11313826181397956815999350510538e-01 2.99460319541710005830648100300095e-02 1.86799281171525499711805196056957e-02
            6.11313826181397956815999350510538e-01 3.58740141864430983620337656248012e-01 1.86799281171525499711805196056957e-02
            3.56325595875039979887333174701780e-02 1.43295370426866991442338417073188e-01 1.54433284422820418096966577081730e-02
            3.56325595875039979887333174701780e-02 8.21072069985628982813352649827721e-01 1.54433284422820418096966577081730e-02
            1.43295370426866991442338417073188e-01 3.56325595875039979887333174701780e-02 1.54433284422820418096966577081730e-02
            1.43295370426866991442338417073188e-01 8.21072069985628982813352649827721e-01 1.54433284422820418096966577081730e-02
            8.21072069985628982813352649827721e-01 3.56325595875039979887333174701780e-02 1.54433284422820418096966577081730e-02
            8.21072069985628982813352649827721e-01 1.43295370426866991442338417073188e-01 1.54433284422820418096966577081730e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 3.68e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.24e-15    0    0
    5    7 2.18e-15    0    0
    6   12 8.55e-15    0    0
    7   13 8.65e-15    1    0
    8   16 5.18e-15    0    0
    9   19 3.43e-15    0    0
    10   25 4.16e-15    0    0
    ];




