
function [xyw_bar,pointset_stats]=set_laursen_gellert_II_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  M.E. Laursen, M. Gellert,
%  "Some criteria for numerically integrated matrices and quadrature
%  formulas for triangles"
%  International Journal for Numerical Methods in Engineering,
%  Volume 12, Issue 1 (1978), pp. 67-76.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   6 |   0 |   0 | 1.70e-15 |PI|
% |   4 |   7 |   0 |   0 | 5.47e-15 |PI|
% |   5 |   9 |   0 |   0 | 4.95e-15 |PI|
% |   7 |  15 |   0 |   0 | 1.32e-14 |PI|
% |   9 |  21 |   0 |   0 | 4.31e-15 |PI|
% |  10 |  25 |   0 |   0 | 6.72e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw_bar=[
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 3.33333333333333314829616256247391e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 3.33333333333333314829616256247391e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 3.33333333333333314829616256247391e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.7e-15
        
        xyw_bar=[
            6.59027622374091959223108005971881e-01 2.31933368553031010739218231719860e-01 1.09039009072877030037673762308259e-01 1.66666666666666685170383743752609e-01
            6.59027622374091959223108005971881e-01 1.09039009072877030037673762308259e-01 2.31933368553031010739218231719860e-01 1.66666666666666685170383743752609e-01
            2.31933368553031010739218231719860e-01 6.59027622374091959223108005971881e-01 1.09039009072877030037673762308259e-01 1.66666666666666685170383743752609e-01
            2.31933368553031010739218231719860e-01 1.09039009072877030037673762308259e-01 6.59027622374091959223108005971881e-01 1.66666666666666685170383743752609e-01
            1.09039009072877030037673762308259e-01 6.59027622374091959223108005971881e-01 2.31933368553031010739218231719860e-01 1.66666666666666685170383743752609e-01
            1.09039009072877030037673762308259e-01 2.31933368553031010739218231719860e-01 6.59027622374091959223108005971881e-01 1.66666666666666685170383743752609e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.5e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.75000000000000111022302462515654e-01
            7.36712498968435047785874303372111e-01 2.37932366472433987070189687074162e-01 2.53551345591309651439360095537268e-02 1.04166666666666699048171551567066e-01
            7.36712498968435047785874303372111e-01 2.53551345591309651439360095537268e-02 2.37932366472433987070189687074162e-01 1.04166666666666699048171551567066e-01
            2.37932366472433987070189687074162e-01 7.36712498968435047785874303372111e-01 2.53551345591309651439360095537268e-02 1.04166666666666699048171551567066e-01
            2.37932366472433987070189687074162e-01 2.53551345591309651439360095537268e-02 7.36712498968435047785874303372111e-01 1.04166666666666699048171551567066e-01
            2.53551345591309651439360095537268e-02 7.36712498968435047785874303372111e-01 2.37932366472433987070189687074162e-01 1.04166666666666699048171551567066e-01
            2.53551345591309651439360095537268e-02 2.37932366472433987070189687074162e-01 7.36712498968435047785874303372111e-01 1.04166666666666699048171551567066e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    9
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.0e-15
        
        xyw_bar=[
            4.37525248383384024464248795993626e-01 4.37525248383384024464248795993626e-01 1.24949503233231951071502408012748e-01 2.05950504760887137534197677268821e-01
            4.37525248383384024464248795993626e-01 1.24949503233231951071502408012748e-01 4.37525248383384024464248795993626e-01 2.05950504760887137534197677268821e-01
            1.24949503233231951071502408012748e-01 4.37525248383384024464248795993626e-01 4.37525248383384024464248795993626e-01 2.05950504760887137534197677268821e-01
            7.97112651860070964282556360558374e-01 1.65409927389841004963244586178917e-01 3.74774207500880307541990532627096e-02 6.36914142862230470143458660459146e-02
            7.97112651860070964282556360558374e-01 3.74774207500880307541990532627096e-02 1.65409927389841004963244586178917e-01 6.36914142862230470143458660459146e-02
            1.65409927389841004963244586178917e-01 7.97112651860070964282556360558374e-01 3.74774207500880307541990532627096e-02 6.36914142862230470143458660459146e-02
            1.65409927389841004963244586178917e-01 3.74774207500880307541990532627096e-02 7.97112651860070964282556360558374e-01 6.36914142862230470143458660459146e-02
            3.74774207500880307541990532627096e-02 7.97112651860070964282556360558374e-01 1.65409927389841004963244586178917e-01 6.36914142862230470143458660459146e-02
            3.74774207500880307541990532627096e-02 1.65409927389841004963244586178917e-01 7.97112651860070964282556360558374e-01 6.36914142862230470143458660459146e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.3e-14
        
        xyw_bar=[
            6.49305131591649958844314483030757e-02 6.49305131591649958844314483030757e-02 8.70138973681670035986712719022762e-01 5.30778017902327411969842785310902e-02
            6.49305131591649958844314483030757e-02 8.70138973681670035986712719022762e-01 6.49305131591649958844314483030757e-02 5.30778017902327411969842785310902e-02
            8.70138973681670035986712719022762e-01 6.49305131591649958844314483030757e-02 6.49305131591649958844314483030757e-02 5.30778017902327411969842785310902e-02
            2.84575584249173008100086690319586e-01 5.17039939069324994136422901647165e-01 1.98384476681501942252339176775422e-01 7.08530836921356516056036412010144e-02
            2.84575584249173008100086690319586e-01 1.98384476681501942252339176775422e-01 5.17039939069324994136422901647165e-01 7.08530836921356516056036412010144e-02
            5.17039939069324994136422901647165e-01 2.84575584249173008100086690319586e-01 1.98384476681501942252339176775422e-01 7.08530836921356516056036412010144e-02
            5.17039939069324994136422901647165e-01 1.98384476681501942252339176775422e-01 2.84575584249173008100086690319586e-01 7.08530836921356516056036412010144e-02
            1.98384476681501942252339176775422e-01 2.84575584249173008100086690319586e-01 5.17039939069324994136422901647165e-01 7.08530836921356516056036412010144e-02
            1.98384476681501942252339176775422e-01 5.17039939069324994136422901647165e-01 2.84575584249173008100086690319586e-01 7.08530836921356516056036412010144e-02
            3.13559184384932021494307718967320e-01 4.38634717923710032438933126286429e-02 6.42577343822696933628435544960666e-01 6.92746820794146733746288191468921e-02
            3.13559184384932021494307718967320e-01 6.42577343822696933628435544960666e-01 4.38634717923710032438933126286429e-02 6.92746820794146733746288191468921e-02
            4.38634717923710032438933126286429e-02 3.13559184384932021494307718967320e-01 6.42577343822696933628435544960666e-01 6.92746820794146733746288191468921e-02
            4.38634717923710032438933126286429e-02 6.42577343822696933628435544960666e-01 3.13559184384932021494307718967320e-01 6.92746820794146733746288191468921e-02
            6.42577343822696933628435544960666e-01 3.13559184384932021494307718967320e-01 4.38634717923710032438933126286429e-02 6.92746820794146733746288191468921e-02
            6.42577343822696933628435544960666e-01 4.38634717923710032438933126286429e-02 3.13559184384932021494307718967320e-01 6.92746820794146733746288191468921e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   21
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.3e-15
        
        xyw_bar=[
            4.81519834783311007075923271258944e-01 4.81519834783311007075923271258944e-01 3.69603304333779858481534574821126e-02 5.16172025690210325987727912888658e-02
            4.81519834783311007075923271258944e-01 3.69603304333779858481534574821126e-02 4.81519834783311007075923271258944e-01 5.16172025690210325987727912888658e-02
            3.69603304333779858481534574821126e-02 4.81519834783311007075923271258944e-01 4.81519834783311007075923271258944e-01 5.16172025690210325987727912888658e-02
            4.03603979817939995111686357631697e-01 4.03603979817939995111686357631697e-01 1.92792040364120009776627284736605e-01 9.40800734583560754886732979684894e-02
            4.03603979817939995111686357631697e-01 1.92792040364120009776627284736605e-01 4.03603979817939995111686357631697e-01 9.40800734583560754886732979684894e-02
            1.92792040364120009776627284736605e-01 4.03603979817939995111686357631697e-01 4.03603979817939995111686357631697e-01 9.40800734583560754886732979684894e-02
            4.51890097843770030539012338977045e-02 4.51890097843770030539012338977045e-02 9.09621980431245980014409724390134e-01 2.59935710323200182270131364248300e-02
            4.51890097843770030539012338977045e-02 9.09621980431245980014409724390134e-01 4.51890097843770030539012338977045e-02 2.59935710323200182270131364248300e-02
            9.09621980431245980014409724390134e-01 4.51890097843770030539012338977045e-02 4.51890097843770030539012338977045e-02 2.59935710323200182270131364248300e-02
            1.36991201264903994516686225324520e-01 2.18290070971381006126321722149441e-01 6.44718727763715082623718899412779e-01 4.54695380476190305629735632919619e-02
            1.36991201264903994516686225324520e-01 6.44718727763715082623718899412779e-01 2.18290070971381006126321722149441e-01 4.54695380476190305629735632919619e-02
            2.18290070971381006126321722149441e-01 1.36991201264903994516686225324520e-01 6.44718727763715082623718899412779e-01 4.54695380476190305629735632919619e-02
            2.18290070971381006126321722149441e-01 6.44718727763715082623718899412779e-01 1.36991201264903994516686225324520e-01 4.54695380476190305629735632919619e-02
            6.44718727763715082623718899412779e-01 1.36991201264903994516686225324520e-01 2.18290070971381006126321722149441e-01 4.54695380476190305629735632919619e-02
            6.44718727763715082623718899412779e-01 2.18290070971381006126321722149441e-01 1.36991201264903994516686225324520e-01 4.54695380476190305629735632919619e-02
            3.04243617288200013382137854023313e-02 2.22063165537318002451527831908606e-01 7.47512472733862010088046190503519e-01 3.53517050891990203265180525704636e-02
            3.04243617288200013382137854023313e-02 7.47512472733862010088046190503519e-01 2.22063165537318002451527831908606e-01 3.53517050891990203265180525704636e-02
            2.22063165537318002451527831908606e-01 3.04243617288200013382137854023313e-02 7.47512472733862010088046190503519e-01 3.53517050891990203265180525704636e-02
            2.22063165537318002451527831908606e-01 7.47512472733862010088046190503519e-01 3.04243617288200013382137854023313e-02 3.53517050891990203265180525704636e-02
            7.47512472733862010088046190503519e-01 3.04243617288200013382137854023313e-02 2.22063165537318002451527831908606e-01 3.53517050891990203265180525704636e-02
            7.47512472733862010088046190503519e-01 2.22063165537318002451527831908606e-01 3.04243617288200013382137854023313e-02 3.53517050891990203265180525704636e-02
            ];
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.7e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.17433291462862504639375060833117e-02
            1.42161101056563987654612901678775e-01 1.42161101056563987654612901678775e-01 7.15677797886872024690774196642451e-01 4.59579636047451473013225609065557e-02
            1.42161101056563987654612901678775e-01 7.15677797886872024690774196642451e-01 1.42161101056563987654612901678775e-01 4.59579636047451473013225609065557e-02
            7.15677797886872024690774196642451e-01 1.42161101056563987654612901678775e-01 1.42161101056563987654612901678775e-01 4.59579636047451473013225609065557e-02
            3.20553732169440025456808029957756e-02 3.20553732169440025456808029957756e-02 9.35889253566111967153062778379535e-01 1.33529688131500418740715829812871e-02
            3.20553732169440025456808029957756e-02 9.35889253566111967153062778379535e-01 3.20553732169440025456808029957756e-02 1.33529688131500418740715829812871e-02
            9.35889253566111967153062778379535e-01 3.20553732169440025456808029957756e-02 3.20553732169440025456808029957756e-02 1.33529688131500418740715829812871e-02
            1.48132885783821000025284320145147e-01 3.21812995288835002050120692729251e-01 5.30054118927343997924594987125602e-01 6.39049063964241964574952703515009e-02
            1.48132885783821000025284320145147e-01 5.30054118927343997924594987125602e-01 3.21812995288835002050120692729251e-01 6.39049063964241964574952703515009e-02
            3.21812995288835002050120692729251e-01 1.48132885783821000025284320145147e-01 5.30054118927343997924594987125602e-01 6.39049063964241964574952703515009e-02
            3.21812995288835002050120692729251e-01 5.30054118927343997924594987125602e-01 1.48132885783821000025284320145147e-01 6.39049063964241964574952703515009e-02
            5.30054118927343997924594987125602e-01 1.48132885783821000025284320145147e-01 3.21812995288835002050120692729251e-01 6.39049063964241964574952703515009e-02
            5.30054118927343997924594987125602e-01 3.21812995288835002050120692729251e-01 1.48132885783821000025284320145147e-01 6.39049063964241964574952703515009e-02
            2.96198894887300008538222328979828e-02 3.69146781827811021337026886612875e-01 6.01233328683459022911961255886126e-01 3.41846481629591025797054726353963e-02
            2.96198894887300008538222328979828e-02 6.01233328683459022911961255886126e-01 3.69146781827811021337026886612875e-01 3.41846481629591025797054726353963e-02
            3.69146781827811021337026886612875e-01 2.96198894887300008538222328979828e-02 6.01233328683459022911961255886126e-01 3.41846481629591025797054726353963e-02
            3.69146781827811021337026886612875e-01 6.01233328683459022911961255886126e-01 2.96198894887300008538222328979828e-02 3.41846481629591025797054726353963e-02
            6.01233328683459022911961255886126e-01 2.96198894887300008538222328979828e-02 3.69146781827811021337026886612875e-01 3.41846481629591025797054726353963e-02
            6.01233328683459022911961255886126e-01 3.69146781827811021337026886612875e-01 2.96198894887300008538222328979828e-02 3.41846481629591025797054726353963e-02
            2.83676653399380016007391702714813e-02 1.63701733737181998051823939022142e-01 8.07930600922880048919694218056975e-01 2.52977577072880793762621465248230e-02
            2.83676653399380016007391702714813e-02 8.07930600922880048919694218056975e-01 1.63701733737181998051823939022142e-01 2.52977577072880793762621465248230e-02
            1.63701733737181998051823939022142e-01 2.83676653399380016007391702714813e-02 8.07930600922880048919694218056975e-01 2.52977577072880793762621465248230e-02
            1.63701733737181998051823939022142e-01 8.07930600922880048919694218056975e-01 2.83676653399380016007391702714813e-02 2.52977577072880793762621465248230e-02
            8.07930600922880048919694218056975e-01 2.83676653399380016007391702714813e-02 1.63701733737181998051823939022142e-01 2.52977577072880793762621465248230e-02
            8.07930600922880048919694218056975e-01 1.63701733737181998051823939022142e-01 2.83676653399380016007391702714813e-02 2.52977577072880793762621465248230e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    6 1.70e-15    0    0
    4    7 5.47e-15    0    0
    5    9 4.95e-15    0    0
    7   15 1.32e-14    0    0
    9   21 4.31e-15    0    0
    10   25 6.72e-15    0    0
    ];



