
function [S1,S2,S3,pointset_stats]=set_laursen_gellert_II_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  M.E. Laursen, M. Gellert,
%  "Some criteria for numerically integrated matrices and quadrature
%  formulas for triangles"
%  International Journal for Numerical Methods in Engineering,
%  Volume 12, Issue 1 (1978), pp. 67-76.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   6 |   0 |   0 | 1.70e-15 |PI|
% |   4 |   7 |   0 |   0 | 5.47e-15 |PI|
% |   5 |   9 |   0 |   0 | 4.95e-15 |PI|
% |   7 |  15 |   0 |   0 | 1.32e-14 |PI|
% |   9 |  21 |   0 |   0 | 4.31e-15 |PI|
% |  10 |  25 |   0 |   0 | 6.72e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        S1=[];
        
        S2=[
            3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
            ];
        
        S3=[];
        
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.7e-15
        
        S1=[
            1.66666666666666657414808128123695e-01 6.59027622374091959223108005971881e-01 2.31933368553031010739218231719860e-01
            ];
        
        S2=[];
        
        S3=[];
        
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.5e-15
        
        S1=[
            1.04166666666666671292595935938152e-01 7.36712498968435047785874303372111e-01 2.37932366472433987070189687074162e-01
            ];
        
        S2=[];
        
        S3=[
            3.75000000000000000000000000000000e-01
            ];
        
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    9
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.0e-15
        
        S1=[
            6.36914142862230053809824426025443e-02 7.97112651860070964282556360558374e-01 1.65409927389841004963244586178917e-01
            ];
        
        S2=[
            2.05950504760886998756319599124254e-01 4.37525248383384024464248795993626e-01
            ];
        
        S3=[];
        
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.3e-14
        
        S1=[
            7.08530836921359985502988365624333e-02 2.84575584249173008100086690319586e-01 5.17039939069324994136422901647165e-01
            6.92746820794150064415362066938542e-02 3.13559184384932021494307718967320e-01 4.38634717923710032438933126286429e-02
            ];
        
        S2=[
            5.30778017902329979360587230985402e-02 6.49305131591649958844314483030757e-02
            ];
        
        S3=[];
        
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   21
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.3e-15
        
        S1=[
            4.54695380476190028073979476630484e-02 1.36991201264903994516686225324520e-01 2.18290070971381006126321722149441e-01
            3.53517050891989995098363408487785e-02 3.04243617288200013382137854023313e-02 2.22063165537318002451527831908606e-01
            ];
        
        S2=[
            5.16172025690209979043032717527240e-02 4.81519834783311007075923271258944e-01
            9.40800734583560060997342588962056e-02 4.03603979817939995111686357631697e-01
            2.59935710323200008797783766567591e-02 4.51890097843770030539012338977045e-02
            ];
        
        S3=[];
        
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.7e-15
        
        S1=[
            6.39049063964240021684659609491064e-02 1.48132885783821000025284320145147e-01 3.21812995288835002050120692729251e-01
            3.41846481629589984962969140269706e-02 2.96198894887300008538222328979828e-02 3.69146781827811021337026886612875e-01
            2.52977577072879995789822515916967e-02 2.83676653399380016007391702714813e-02 1.63701733737181998051823939022142e-01
            ];
        
        S2=[
            4.59579636047450015845505788547598e-02 1.42161101056563987654612901678775e-01
            1.33529688131500002407081595379168e-02 3.20553732169440025456808029957756e-02
            ];
        
        S3=[
            8.17433291462860006637569654230902e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    6 1.70e-15    0    0
    4    7 5.47e-15    0    0
    5    9 4.95e-15    0    0
    7   15 1.32e-14    0    0
    9   21 4.31e-15    0    0
    10   25 6.72e-15    0    0
    ];

