
function [xyw_bar,pointset_stats]=set_lyness_jespersen_I_barycentric(deg)

% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn. Dubiner basis,
%    number of points with negative weights, number of points outside the domain.
% --------------------------------------------------------------------
% SOURCE:
% J.N. Lyness, D. Jespersen,
% "Moderate Degree Symmetric Quadrature Rules for the Triangle"
% J. Inst. Maths Applies, 15 (1975), pp.19-32.
% --------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
% --------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.22e-16 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 1.24e-13 |PI|
% |   7 |  13 |   1 |   0 | 4.11e-14 |NI|
% |   8 |  16 |   0 |   0 | 8.38e-15 |PI|
% |   9 |  19 |   0 |   0 | 8.75e-15 |PI|
% |  11 |  27 |   0 |   3 | 1.36e-13 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw_bar=[
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 3.33333333333333314829616256247391e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 3.33333333333333314829616256247391e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 3.33333333333333314829616256247391e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -5.62500000000000000000000000000000e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 5.20833333333333370340767487505218e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            9.15762135097707291597757262024970e-02 9.15762135097707291597757262024970e-02 8.16847572980458513924872931966092e-01 1.09951743655321856896200927167229e-01
            9.15762135097707291597757262024970e-02 8.16847572980458513924872931966092e-01 9.15762135097707291597757262024970e-02 1.09951743655321856896200927167229e-01
            8.16847572980458513924872931966092e-01 9.15762135097707291597757262024970e-02 9.15762135097707291597757262024970e-02 1.09951743655321856896200927167229e-01
            4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 2.23381589678011555077929983781360e-01
            4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 2.23381589678011555077929983781360e-01
            1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 2.23381589678011555077929983781360e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.8e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.25000000000000005551115123125783e-01
            1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 1.25939180544827167285149016606738e-01
            1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 1.25939180544827167285149016606738e-01
            7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 1.25939180544827167285149016606738e-01
            4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 1.32394152788506164197812609018001e-01
            4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 1.32394152788506164197812609018001e-01
            5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 1.32394152788506164197812609018001e-01
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.2e-13
        
        xyw_bar=[
            2.49286745170932910742322974328999e-01 2.49286745170932910742322974328999e-01 5.01426509658134178515354051342001e-01 1.16786275726343577452404076666426e-01
            2.49286745170932910742322974328999e-01 5.01426509658134178515354051342001e-01 2.49286745170932910742322974328999e-01 1.16786275726343577452404076666426e-01
            5.01426509658134178515354051342001e-01 2.49286745170932910742322974328999e-01 2.49286745170932910742322974328999e-01 1.16786275726343577452404076666426e-01
            6.30890144915017686555458453767642e-02 6.30890144915017686555458453767642e-02 8.73821971016996434933332693617558e-01 5.08449063702066939018919811132946e-02
            6.30890144915017686555458453767642e-02 8.73821971016996434933332693617558e-01 6.30890144915017686555458453767642e-02 5.08449063702066939018919811132946e-02
            8.73821971016996434933332693617558e-01 6.30890144915017686555458453767642e-02 6.30890144915017686555458453767642e-02 5.08449063702066939018919811132946e-02
            6.36502499121393894299103521916550e-01 5.31450498448321623223833398697025e-02 3.10352451033773957256300946028205e-01 8.28510756183915841877052343988908e-02
            6.36502499121393894299103521916550e-01 3.10352451033773957256300946028205e-01 5.31450498448321623223833398697025e-02 8.28510756183915841877052343988908e-02
            5.31450498448321623223833398697025e-02 6.36502499121393894299103521916550e-01 3.10352451033773957256300946028205e-01 8.28510756183915841877052343988908e-02
            5.31450498448321623223833398697025e-02 3.10352451033773957256300946028205e-01 6.36502499121393894299103521916550e-01 8.28510756183915841877052343988908e-02
            3.10352451033773957256300946028205e-01 6.36502499121393894299103521916550e-01 5.31450498448321623223833398697025e-02 8.28510756183915841877052343988908e-02
            3.10352451033773957256300946028205e-01 5.31450498448321623223833398697025e-02 6.36502499121393894299103521916550e-01 8.28510756183915841877052343988908e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 4.1e-14
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -1.49570044467756957384807492417167e-01
            2.60345966079046586827416831511073e-01 2.60345966079046586827416831511073e-01 4.79308067841906826345166336977854e-01 1.75615257433219706939553361735307e-01
            2.60345966079046586827416831511073e-01 4.79308067841906826345166336977854e-01 2.60345966079046586827416831511073e-01 1.75615257433219706939553361735307e-01
            4.79308067841906826345166336977854e-01 2.60345966079046586827416831511073e-01 2.60345966079046586827416831511073e-01 1.75615257433219706939553361735307e-01
            6.51301029022162275561314004335145e-02 6.51301029022162275561314004335145e-02 8.69739794195567572643312814761885e-01 5.33472356088415602948238358749222e-02
            6.51301029022162275561314004335145e-02 8.69739794195567572643312814761885e-01 6.51301029022162275561314004335145e-02 5.33472356088415602948238358749222e-02
            8.69739794195567572643312814761885e-01 6.51301029022162275561314004335145e-02 6.51301029022162275561314004335145e-02 5.33472356088415602948238358749222e-02
            6.38444188569809556454970334016252e-01 4.86903154253175568522138405569422e-02 3.12865496004872900570603633241262e-01 7.71137608902621868312010633417231e-02
            6.38444188569809556454970334016252e-01 3.12865496004872900570603633241262e-01 4.86903154253175568522138405569422e-02 7.71137608902621868312010633417231e-02
            4.86903154253175568522138405569422e-02 6.38444188569809556454970334016252e-01 3.12865496004872900570603633241262e-01 7.71137608902621868312010633417231e-02
            4.86903154253175568522138405569422e-02 3.12865496004872900570603633241262e-01 6.38444188569809556454970334016252e-01 7.71137608902621868312010633417231e-02
            3.12865496004872900570603633241262e-01 6.38444188569809556454970334016252e-01 4.86903154253175568522138405569422e-02 7.71137608902621868312010633417231e-02
            3.12865496004872900570603633241262e-01 4.86903154253175568522138405569422e-02 6.38444188569809556454970334016252e-01 7.71137608902621868312010633417231e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.4e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.44315607677786228446592531327042e-01
            4.59292588292722903098308506741887e-01 4.59292588292722903098308506741887e-01 8.14148234145541938033829865162261e-02 9.50916342672849940198531726309739e-02
            4.59292588292722903098308506741887e-01 8.14148234145541938033829865162261e-02 4.59292588292722903098308506741887e-01 9.50916342672849940198531726309739e-02
            8.14148234145541938033829865162261e-02 4.59292588292722903098308506741887e-01 4.59292588292722903098308506741887e-01 9.50916342672849940198531726309739e-02
            5.05472283170310329736274468359625e-02 5.05472283170310329736274468359625e-02 8.98905543365937975686108529771445e-01 3.24584976231981417460481509351666e-02
            5.05472283170310329736274468359625e-02 8.98905543365937975686108529771445e-01 5.05472283170310329736274468359625e-02 3.24584976231981417460481509351666e-02
            8.98905543365937975686108529771445e-01 5.05472283170310329736274468359625e-02 5.05472283170310329736274468359625e-02 3.24584976231981417460481509351666e-02
            1.70569307751760101954374704291695e-01 1.70569307751760101954374704291695e-01 6.58861384496479796091250591416610e-01 1.03217370534718425045817014051863e-01
            1.70569307751760101954374704291695e-01 6.58861384496479796091250591416610e-01 1.70569307751760101954374704291695e-01 1.03217370534718425045817014051863e-01
            6.58861384496479796091250591416610e-01 1.70569307751760101954374704291695e-01 1.70569307751760101954374704291695e-01 1.03217370534718425045817014051863e-01
            8.39477740995721137540197531734520e-03 7.28492392955404133303431990498211e-01 2.63112829634638667464230366022093e-01 2.72303141744348713160217556605858e-02
            8.39477740995721137540197531734520e-03 2.63112829634638667464230366022093e-01 7.28492392955404133303431990498211e-01 2.72303141744348713160217556605858e-02
            7.28492392955404133303431990498211e-01 8.39477740995721137540197531734520e-03 2.63112829634638667464230366022093e-01 2.72303141744348713160217556605858e-02
            7.28492392955404133303431990498211e-01 2.63112829634638667464230366022093e-01 8.39477740995721137540197531734520e-03 2.72303141744348713160217556605858e-02
            2.63112829634638667464230366022093e-01 8.39477740995721137540197531734520e-03 7.28492392955404133303431990498211e-01 2.72303141744348713160217556605858e-02
            2.63112829634638667464230366022093e-01 7.28492392955404133303431990498211e-01 8.39477740995721137540197531734520e-03 2.72303141744348713160217556605858e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.7e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 9.71357962827961302076928973292524e-02
            4.89682519198737009613608961444697e-01 4.89682519198737009613608961444697e-01 2.06349616025259807727820771106053e-02 3.13347002271398417105885414457589e-02
            4.89682519198737009613608961444697e-01 2.06349616025259807727820771106053e-02 4.89682519198737009613608961444697e-01 3.13347002271398417105885414457589e-02
            2.06349616025259807727820771106053e-02 4.89682519198737009613608961444697e-01 4.89682519198737009613608961444697e-01 3.13347002271398417105885414457589e-02
            4.37089591492935525263163754061679e-01 4.37089591492935525263163754061679e-01 1.25820817014128949473672491876641e-01 7.78275410047754440112655061057012e-02
            4.37089591492935525263163754061679e-01 1.25820817014128949473672491876641e-01 4.37089591492935525263163754061679e-01 7.78275410047754440112655061057012e-02
            1.25820817014128949473672491876641e-01 4.37089591492935525263163754061679e-01 4.37089591492935525263163754061679e-01 7.78275410047754440112655061057012e-02
            1.88203535619032191750221727488679e-01 1.88203535619032191750221727488679e-01 6.23592928761935616499556545022642e-01 7.96477389272090552374550043168711e-02
            1.88203535619032191750221727488679e-01 6.23592928761935616499556545022642e-01 1.88203535619032191750221727488679e-01 7.96477389272090552374550043168711e-02
            6.23592928761935616499556545022642e-01 1.88203535619032191750221727488679e-01 1.88203535619032191750221727488679e-01 7.96477389272090552374550043168711e-02
            4.47295133944529688108104892307892e-02 4.47295133944529688108104892307892e-02 9.10540973211094062378379021538422e-01 2.55776756586981075802800233987000e-02
            4.47295133944529688108104892307892e-02 9.10540973211094062378379021538422e-01 4.47295133944529688108104892307892e-02 2.55776756586981075802800233987000e-02
            9.10540973211094062378379021538422e-01 4.47295133944529688108104892307892e-02 4.47295133944529688108104892307892e-02 2.55776756586981075802800233987000e-02
            3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01 2.21962989160765733487323814188130e-01 4.32835393772894108654902822763688e-02
            3.68384120547362581277184290229343e-02 2.21962989160765733487323814188130e-01 7.41198598784498008384957756788936e-01 4.32835393772894108654902822763688e-02
            7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02 2.21962989160765733487323814188130e-01 4.32835393772894108654902822763688e-02
            7.41198598784498008384957756788936e-01 2.21962989160765733487323814188130e-01 3.68384120547362581277184290229343e-02 4.32835393772894108654902822763688e-02
            2.21962989160765733487323814188130e-01 3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01 4.32835393772894108654902822763688e-02
            2.21962989160765733487323814188130e-01 7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02 4.32835393772894108654902822763688e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    3
        % M.E.INF. : 1.4e-13
        
        xyw_bar=[
            3.23649481112717324338134972094849e-02 3.23649481112717324338134972094849e-02 9.35270103777456562887948621209944e-01 1.36597310026770075302993134869212e-02
            3.23649481112717324338134972094849e-02 9.35270103777456562887948621209944e-01 3.23649481112717324338134972094849e-02 1.36597310026770075302993134869212e-02
            9.35270103777456562887948621209944e-01 3.23649481112717324338134972094849e-02 3.23649481112717324338134972094849e-02 1.36597310026770075302993134869212e-02
            1.19350912282593105140371392280940e-01 1.19350912282593105140371392280940e-01 7.61298175434813817474832831067033e-01 3.61845405034288275514242627650674e-02
            1.19350912282593105140371392280940e-01 7.61298175434813817474832831067033e-01 1.19350912282593105140371392280940e-01 3.61845405034288275514242627650674e-02
            7.61298175434813817474832831067033e-01 1.19350912282593105140371392280940e-01 1.19350912282593105140371392280940e-01 3.61845405034288275514242627650674e-02
            5.34611048270757227562910429696785e-01 5.34611048270757227562910429696785e-01 -6.92220965415144551258208593935706e-02 9.27006328960603190846023746729543e-04
            5.34611048270757227562910429696785e-01 -6.92220965415144551258208593935706e-02 5.34611048270757227562910429696785e-01 9.27006328960603190846023746729543e-04
            -6.92220965415144551258208593935706e-02 5.34611048270757227562910429696785e-01 5.34611048270757227562910429696785e-01 9.27006328960603190846023746729543e-04
            2.03309900431281609378686425770866e-01 2.03309900431281609378686425770866e-01 5.93380199137436781242627148458268e-01 5.93229773807555441078598335025163e-02
            2.03309900431281609378686425770866e-01 5.93380199137436781242627148458268e-01 2.03309900431281609378686425770866e-01 5.93229773807555441078598335025163e-02
            5.93380199137436781242627148458268e-01 2.03309900431281609378686425770866e-01 2.03309900431281609378686425770866e-01 5.93229773807555441078598335025163e-02
            3.98969302965855809883777283175732e-01 3.98969302965855809883777283175732e-01 2.02061394068288380232445433648536e-01 7.71495349148225012525514898698020e-02
            3.98969302965855809883777283175732e-01 2.02061394068288380232445433648536e-01 3.98969302965855809883777283175732e-01 7.71495349148225012525514898698020e-02
            2.02061394068288380232445433648536e-01 3.98969302965855809883777283175732e-01 3.98969302965855809883777283175732e-01 7.71495349148225012525514898698020e-02
            5.01781383104947381612603862777178e-02 5.93201213428213192102589346177410e-01 3.56620648261292028102786844101502e-01 5.23371119622038499796801147567749e-02
            5.01781383104947381612603862777178e-02 3.56620648261292028102786844101502e-01 5.93201213428213192102589346177410e-01 5.23371119622038499796801147567749e-02
            5.93201213428213192102589346177410e-01 5.01781383104947381612603862777178e-02 3.56620648261292028102786844101502e-01 5.23371119622038499796801147567749e-02
            5.93201213428213192102589346177410e-01 3.56620648261292028102786844101502e-01 5.01781383104947381612603862777178e-02 5.23371119622038499796801147567749e-02
            3.56620648261292028102786844101502e-01 5.01781383104947381612603862777178e-02 5.93201213428213192102589346177410e-01 5.23371119622038499796801147567749e-02
            3.56620648261292028102786844101502e-01 5.93201213428213192102589346177410e-01 5.01781383104947381612603862777178e-02 5.23371119622038499796801147567749e-02
            2.10220165361661298630835403855599e-02 8.07489003159792329000765676028095e-01 1.71488980304041582769514207029715e-01 2.07076596391405978736521831251594e-02
            2.10220165361661298630835403855599e-02 1.71488980304041582769514207029715e-01 8.07489003159792329000765676028095e-01 2.07076596391405978736521831251594e-02
            8.07489003159792329000765676028095e-01 2.10220165361661298630835403855599e-02 1.71488980304041582769514207029715e-01 2.07076596391405978736521831251594e-02
            8.07489003159792329000765676028095e-01 1.71488980304041582769514207029715e-01 2.10220165361661298630835403855599e-02 2.07076596391405978736521831251594e-02
            1.71488980304041582769514207029715e-01 2.10220165361661298630835403855599e-02 8.07489003159792329000765676028095e-01 2.07076596391405978736521831251594e-02
            1.71488980304041582769514207029715e-01 8.07489003159792329000765676028095e-01 2.10220165361661298630835403855599e-02 2.07076596391405978736521831251594e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.22e-16    0    0
    5    7 4.79e-16    0    0
    6   12 1.24e-13    0    0
    7   13 4.11e-14    1    0
    8   16 8.38e-15    0    0
    9   19 8.75e-15    0    0
    11   27 1.36e-13    0    3
    ];




